/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.31.1(337587859b1c171314b40503171188b6cea6a32a)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
define("vs/language/typescript/tsWorker",[],()=>{
var moduleExports = (() => {
  var __defProp = Object.defineProperty;
  var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
  var __export = (target, all) => {
    __markAsModule(target);
    for (var name in all)
      __defProp(target, name, { get: all[name], enumerable: true });
  };

  // src/typescript/tsWorker.ts
  var tsWorker_exports = {};
  __export(tsWorker_exports, {
    TypeScriptWorker: () => TypeScriptWorker,
    create: () => create
  });

  // src/typescript/lib/typescriptServices.js
  var typescriptServices_exports = {};
  __export(typescriptServices_exports, {
    EndOfLineState: () => EndOfLineState,
    IndentStyle: () => IndentStyle,
    ScriptKind: () => ScriptKind,
    ScriptTarget: () => ScriptTarget,
    TokenClass: () => TokenClass,
    createClassifier: () => createClassifier,
    createLanguageService: () => createLanguageService,
    displayPartsToString: () => displayPartsToString,
    flattenDiagnosticMessageText: () => flattenDiagnosticMessageText,
    typescript: () => typescript
  });
  "use strict";
  var __spreadArray = function(to, from, pack) {
    if (pack || arguments.length === 2)
      for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
          if (!ar)
            ar = Array.prototype.slice.call(from, 0, i);
          ar[i] = from[i];
        }
      }
    return to.concat(ar || Array.prototype.slice.call(from));
  };
  var __assign = function() {
    __assign = Object.assign || function(t) {
      for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s)
          if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
      }
      return t;
    };
    return __assign.apply(this, arguments);
  };
  var __makeTemplateObject = function(cooked, raw) {
    if (Object.defineProperty) {
      Object.defineProperty(cooked, "raw", { value: raw });
    } else {
      cooked.raw = raw;
    }
    return cooked;
  };
  var __generator = function(thisArg, body) {
    var _ = { label: 0, sent: function() {
      if (t[0] & 1)
        throw t[1];
      return t[1];
    }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
      return this;
    }), g;
    function verb(n) {
      return function(v) {
        return step([n, v]);
      };
    }
    function step(op) {
      if (f)
        throw new TypeError("Generator is already executing.");
      while (_)
        try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
            return t;
          if (y = 0, t)
            op = [op[0] & 2, t.value];
          switch (op[0]) {
            case 0:
            case 1:
              t = op;
              break;
            case 4:
              _.label++;
              return { value: op[1], done: false };
            case 5:
              _.label++;
              y = op[1];
              op = [0];
              continue;
            case 7:
              op = _.ops.pop();
              _.trys.pop();
              continue;
            default:
              if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                _ = 0;
                continue;
              }
              if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                _.label = op[1];
                break;
              }
              if (op[0] === 6 && _.label < t[1]) {
                _.label = t[1];
                t = op;
                break;
              }
              if (t && _.label < t[2]) {
                _.label = t[2];
                _.ops.push(op);
                break;
              }
              if (t[2])
                _.ops.pop();
              _.trys.pop();
              continue;
          }
          op = body.call(thisArg, _);
        } catch (e) {
          op = [6, e];
          y = 0;
        } finally {
          f = t = 0;
        }
      if (op[0] & 5)
        throw op[1];
      return { value: op[0] ? op[1] : void 0, done: true };
    }
  };
  var __rest = function(s, e) {
    var t = {};
    for (var p in s)
      if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
      for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
        if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
          t[p[i]] = s[p[i]];
      }
    return t;
  };
  var __extends = function() {
    var extendStatics = function(d, b) {
      extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
        d2.__proto__ = b2;
      } || function(d2, b2) {
        for (var p in b2)
          if (Object.prototype.hasOwnProperty.call(b2, p))
            d2[p] = b2[p];
      };
      return extendStatics(d, b);
    };
    return function(d, b) {
      if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
      extendStatics(d, b);
      function __() {
        this.constructor = d;
      }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
  }();
  var ts;
  (function(ts2) {
    function createMapData() {
      var sentinel = {};
      sentinel.prev = sentinel;
      return { head: sentinel, tail: sentinel, size: 0 };
    }
    function createMapEntry(key, value) {
      return { key, value, next: void 0, prev: void 0 };
    }
    function sameValueZero(x, y) {
      return x === y || x !== x && y !== y;
    }
    function getPrev(entry) {
      var prev = entry.prev;
      if (!prev || prev === entry)
        throw new Error("Illegal state");
      return prev;
    }
    function getNext(entry) {
      while (entry) {
        var skipNext = !entry.prev;
        entry = entry.next;
        if (skipNext) {
          continue;
        }
        return entry;
      }
    }
    function getEntry(data, key) {
      for (var entry = data.tail; entry !== data.head; entry = getPrev(entry)) {
        if (sameValueZero(entry.key, key)) {
          return entry;
        }
      }
    }
    function addOrUpdateEntry(data, key, value) {
      var existing = getEntry(data, key);
      if (existing) {
        existing.value = value;
        return;
      }
      var entry = createMapEntry(key, value);
      entry.prev = data.tail;
      data.tail.next = entry;
      data.tail = entry;
      data.size++;
      return entry;
    }
    function deleteEntry(data, key) {
      for (var entry = data.tail; entry !== data.head; entry = getPrev(entry)) {
        if (entry.prev === void 0)
          throw new Error("Illegal state");
        if (sameValueZero(entry.key, key)) {
          if (entry.next) {
            entry.next.prev = entry.prev;
          } else {
            if (data.tail !== entry)
              throw new Error("Illegal state");
            data.tail = entry.prev;
          }
          entry.prev.next = entry.next;
          entry.next = entry.prev;
          entry.prev = void 0;
          data.size--;
          return entry;
        }
      }
    }
    function clearEntries(data) {
      var node = data.tail;
      while (node !== data.head) {
        var prev = getPrev(node);
        node.next = data.head;
        node.prev = void 0;
        node = prev;
      }
      data.head.next = void 0;
      data.tail = data.head;
      data.size = 0;
    }
    function forEachEntry(data, action) {
      var entry = data.head;
      while (entry) {
        entry = getNext(entry);
        if (entry) {
          action(entry.value, entry.key);
        }
      }
    }
    function forEachIteration(iterator, action) {
      if (iterator) {
        for (var step = iterator.next(); !step.done; step = iterator.next()) {
          action(step.value);
        }
      }
    }
    function createIteratorData(data, selector) {
      return { current: data.head, selector };
    }
    function iteratorNext(data) {
      data.current = getNext(data.current);
      if (data.current) {
        return { value: data.selector(data.current.key, data.current.value), done: false };
      } else {
        return { value: void 0, done: true };
      }
    }
    var ShimCollections;
    (function(ShimCollections2) {
      function createMapShim(getIterator) {
        var MapIterator = function() {
          function MapIterator2(data, selector) {
            this._data = createIteratorData(data, selector);
          }
          MapIterator2.prototype.next = function() {
            return iteratorNext(this._data);
          };
          return MapIterator2;
        }();
        return function() {
          function Map2(iterable) {
            var _this = this;
            this._mapData = createMapData();
            forEachIteration(getIterator(iterable), function(_a) {
              var key = _a[0], value = _a[1];
              return _this.set(key, value);
            });
          }
          Object.defineProperty(Map2.prototype, "size", {
            get: function() {
              return this._mapData.size;
            },
            enumerable: false,
            configurable: true
          });
          Map2.prototype.get = function(key) {
            var _a;
            return (_a = getEntry(this._mapData, key)) === null || _a === void 0 ? void 0 : _a.value;
          };
          Map2.prototype.set = function(key, value) {
            return addOrUpdateEntry(this._mapData, key, value), this;
          };
          Map2.prototype.has = function(key) {
            return !!getEntry(this._mapData, key);
          };
          Map2.prototype.delete = function(key) {
            return !!deleteEntry(this._mapData, key);
          };
          Map2.prototype.clear = function() {
            clearEntries(this._mapData);
          };
          Map2.prototype.keys = function() {
            return new MapIterator(this._mapData, function(key, _value) {
              return key;
            });
          };
          Map2.prototype.values = function() {
            return new MapIterator(this._mapData, function(_key, value) {
              return value;
            });
          };
          Map2.prototype.entries = function() {
            return new MapIterator(this._mapData, function(key, value) {
              return [key, value];
            });
          };
          Map2.prototype.forEach = function(action) {
            forEachEntry(this._mapData, action);
          };
          return Map2;
        }();
      }
      ShimCollections2.createMapShim = createMapShim;
      function createSetShim(getIterator) {
        var SetIterator = function() {
          function SetIterator2(data, selector) {
            this._data = createIteratorData(data, selector);
          }
          SetIterator2.prototype.next = function() {
            return iteratorNext(this._data);
          };
          return SetIterator2;
        }();
        return function() {
          function Set2(iterable) {
            var _this = this;
            this._mapData = createMapData();
            forEachIteration(getIterator(iterable), function(value) {
              return _this.add(value);
            });
          }
          Object.defineProperty(Set2.prototype, "size", {
            get: function() {
              return this._mapData.size;
            },
            enumerable: false,
            configurable: true
          });
          Set2.prototype.add = function(value) {
            return addOrUpdateEntry(this._mapData, value, value), this;
          };
          Set2.prototype.has = function(value) {
            return !!getEntry(this._mapData, value);
          };
          Set2.prototype.delete = function(value) {
            return !!deleteEntry(this._mapData, value);
          };
          Set2.prototype.clear = function() {
            clearEntries(this._mapData);
          };
          Set2.prototype.keys = function() {
            return new SetIterator(this._mapData, function(key, _value) {
              return key;
            });
          };
          Set2.prototype.values = function() {
            return new SetIterator(this._mapData, function(_key, value) {
              return value;
            });
          };
          Set2.prototype.entries = function() {
            return new SetIterator(this._mapData, function(key, value) {
              return [key, value];
            });
          };
          Set2.prototype.forEach = function(action) {
            forEachEntry(this._mapData, action);
          };
          return Set2;
        }();
      }
      ShimCollections2.createSetShim = createSetShim;
    })(ShimCollections = ts2.ShimCollections || (ts2.ShimCollections = {}));
  })(ts || (ts = {}));
  var ts;
  (function(ts2) {
    ts2.versionMajorMinor = "4.4";
    ts2.version = "4.4.4";
    var Comparison;
    (function(Comparison2) {
      Comparison2[Comparison2["LessThan"] = -1] = "LessThan";
      Comparison2[Comparison2["EqualTo"] = 0] = "EqualTo";
      Comparison2[Comparison2["GreaterThan"] = 1] = "GreaterThan";
    })(Comparison = ts2.Comparison || (ts2.Comparison = {}));
    var NativeCollections;
    (function(NativeCollections2) {
      function tryGetNativeMap() {
        return typeof Map !== "undefined" && "entries" in Map.prototype && new Map([[0, 0]]).size === 1 ? Map : void 0;
      }
      NativeCollections2.tryGetNativeMap = tryGetNativeMap;
      function tryGetNativeSet() {
        return typeof Set !== "undefined" && "entries" in Set.prototype && new Set([0]).size === 1 ? Set : void 0;
      }
      NativeCollections2.tryGetNativeSet = tryGetNativeSet;
    })(NativeCollections = ts2.NativeCollections || (ts2.NativeCollections = {}));
  })(ts || (ts = {}));
  var ts;
  (function(ts2) {
    function getCollectionImplementation(name, nativeFactory, shimFactory) {
      var _a;
      var constructor = (_a = ts2.NativeCollections[nativeFactory]()) !== null && _a !== void 0 ? _a : ts2.ShimCollections === null || ts2.ShimCollections === void 0 ? void 0 : ts2.ShimCollections[shimFactory](getIterator);
      if (constructor)
        return constructor;
      throw new Error("TypeScript requires an environment that provides a compatible native " + name + " implementation.");
    }
    ts2.Map = getCollectionImplementation("Map", "tryGetNativeMap", "createMapShim");
    ts2.Set = getCollectionImplementation("Set", "tryGetNativeSet", "createSetShim");
    function getIterator(iterable) {
      if (iterable) {
        if (isArray(iterable))
          return arrayIterator(iterable);
        if (iterable instanceof ts2.Map)
          return iterable.entries();
        if (iterable instanceof ts2.Set)
          return iterable.values();
        throw new Error("Iteration not supported.");
      }
    }
    ts2.getIterator = getIterator;
    ts2.emptyArray = [];
    ts2.emptyMap = new ts2.Map();
    ts2.emptySet = new ts2.Set();
    function createMap() {
      return new ts2.Map();
    }
    ts2.createMap = createMap;
    function createMapFromTemplate(template) {
      var map2 = new ts2.Map();
      for (var key in template) {
        if (hasOwnProperty.call(template, key)) {
          map2.set(key, template[key]);
        }
      }
      return map2;
    }
    ts2.createMapFromTemplate = createMapFromTemplate;
    function length(array) {
      return array ? array.length : 0;
    }
    ts2.length = length;
    function forEach(array, callback) {
      if (array) {
        for (var i = 0; i < array.length; i++) {
          var result = callback(array[i], i);
          if (result) {
            return result;
          }
        }
      }
      return void 0;
    }
    ts2.forEach = forEach;
    function forEachRight(array, callback) {
      if (array) {
        for (var i = array.length - 1; i >= 0; i--) {
          var result = callback(array[i], i);
          if (result) {
            return result;
          }
        }
      }
      return void 0;
    }
    ts2.forEachRight = forEachRight;
    function firstDefined(array, callback) {
      if (array === void 0) {
        return void 0;
      }
      for (var i = 0; i < array.length; i++) {
        var result = callback(array[i], i);
        if (result !== void 0) {
          return result;
        }
      }
      return void 0;
    }
    ts2.firstDefined = firstDefined;
    function firstDefinedIterator(iter, callback) {
      while (true) {
        var iterResult = iter.next();
        if (iterResult.done) {
          return void 0;
        }
        var result = callback(iterResult.value);
        if (result !== void 0) {
          return result;
        }
      }
    }
    ts2.firstDefinedIterator = firstDefinedIterator;
    function reduceLeftIterator(iterator, f, initial) {
      var result = initial;
      if (iterator) {
        for (var step = iterator.next(), pos = 0; !step.done; step = iterator.next(), pos++) {
          result = f(result, step.value, pos);
        }
      }
      return result;
    }
    ts2.reduceLeftIterator = reduceLeftIterator;
    function zipWith(arrayA, arrayB, callback) {
      var result = [];
      ts2.Debug.assertEqual(arrayA.length, arrayB.length);
      for (var i = 0; i < arrayA.length; i++) {
        result.push(callback(arrayA[i], arrayB[i], i));
      }
      return result;
    }
    ts2.zipWith = zipWith;
    function zipToIterator(arrayA, arrayB) {
      ts2.Debug.assertEqual(arrayA.length, arrayB.length);
      var i = 0;
      return {
        next: function() {
          if (i === arrayA.length) {
            return { value: void 0, done: true };
          }
          i++;
          return { value: [arrayA[i - 1], arrayB[i - 1]], done: false };
        }
      };
    }
    ts2.zipToIterator = zipToIterator;
    function zipToMap(keys, values) {
      ts2.Debug.assert(keys.length === values.length);
      var map2 = new ts2.Map();
      for (var i = 0; i < keys.length; ++i) {
        map2.set(keys[i], values[i]);
      }
      return map2;
    }
    ts2.zipToMap = zipToMap;
    function intersperse(input, element) {
      if (input.length <= 1) {
        return input;
      }
      var result = [];
      for (var i = 0, n = input.length; i < n; i++) {
        if (i)
          result.push(element);
        result.push(input[i]);
      }
      return result;
    }
    ts2.intersperse = intersperse;
    function every(array, callback) {
      if (array) {
        for (var i = 0; i < array.length; i++) {
          if (!callback(array[i], i)) {
            return false;
          }
        }
      }
      return true;
    }
    ts2.every = every;
    function find(array, predicate) {
      for (var i = 0; i < array.length; i++) {
        var value = array[i];
        if (predicate(value, i)) {
          return value;
        }
      }
      return void 0;
    }
    ts2.find = find;
    function findLast(array, predicate) {
      for (var i = array.length - 1; i >= 0; i--) {
        var value = array[i];
        if (predicate(value, i)) {
          return value;
        }
      }
      return void 0;
    }
    ts2.findLast = findLast;
    function findIndex(array, predicate, startIndex) {
      for (var i = startIndex || 0; i < array.length; i++) {
        if (predicate(array[i], i)) {
          return i;
        }
      }
      return -1;
    }
    ts2.findIndex = findIndex;
    function findLastIndex(array, predicate, startIndex) {
      for (var i = startIndex === void 0 ? array.length - 1 : startIndex; i >= 0; i--) {
        if (predicate(array[i], i)) {
          return i;
        }
      }
      return -1;
    }
    ts2.findLastIndex = findLastIndex;
    function findMap(array, callback) {
      for (var i = 0; i < array.length; i++) {
        var result = callback(array[i], i);
        if (result) {
          return result;
        }
      }
      return ts2.Debug.fail();
    }
    ts2.findMap = findMap;
    function contains(array, value, equalityComparer) {
      if (equalityComparer === void 0) {
        equalityComparer = equateValues;
      }
      if (array) {
        for (var _i = 0, array_1 = array; _i < array_1.length; _i++) {
          var v = array_1[_i];
          if (equalityComparer(v, value)) {
            return true;
          }
        }
      }
      return false;
    }
    ts2.contains = contains;
    function arraysEqual(a, b, equalityComparer) {
      if (equalityComparer === void 0) {
        equalityComparer = equateValues;
      }
      return a.length === b.length && a.every(function(x, i) {
        return equalityComparer(x, b[i]);
      });
    }
    ts2.arraysEqual = arraysEqual;
    function indexOfAnyCharCode(text, charCodes, start) {
      for (var i = start || 0; i < text.length; i++) {
        if (contains(charCodes, text.charCodeAt(i))) {
          return i;
        }
      }
      return -1;
    }
    ts2.indexOfAnyCharCode = indexOfAnyCharCode;
    function countWhere(array, predicate) {
      var count = 0;
      if (array) {
        for (var i = 0; i < array.length; i++) {
          var v = array[i];
          if (predicate(v, i)) {
            count++;
          }
        }
      }
      return count;
    }
    ts2.countWhere = countWhere;
    function filter(array, f) {
      if (array) {
        var len = array.length;
        var i = 0;
        while (i < len && f(array[i]))
          i++;
        if (i < len) {
          var result = array.slice(0, i);
          i++;
          while (i < len) {
            var item = array[i];
            if (f(item)) {
              result.push(item);
            }
            i++;
          }
          return result;
        }
      }
      return array;
    }
    ts2.filter = filter;
    function filterMutate(array, f) {
      var outIndex = 0;
      for (var i = 0; i < array.length; i++) {
        if (f(array[i], i, array)) {
          array[outIndex] = array[i];
          outIndex++;
        }
      }
      array.length = outIndex;
    }
    ts2.filterMutate = filterMutate;
    function clear(array) {
      array.length = 0;
    }
    ts2.clear = clear;
    function map(array, f) {
      var result;
      if (array) {
        result = [];
        for (var i = 0; i < array.length; i++) {
          result.push(f(array[i], i));
        }
      }
      return result;
    }
    ts2.map = map;
    function mapIterator(iter, mapFn) {
      return {
        next: function() {
          var iterRes = iter.next();
          return iterRes.done ? iterRes : { value: mapFn(iterRes.value), done: false };
        }
      };
    }
    ts2.mapIterator = mapIterator;
    function sameMap(array, f) {
      if (array) {
        for (var i = 0; i < array.length; i++) {
          var item = array[i];
          var mapped = f(item, i);
          if (item !== mapped) {
            var result = array.slice(0, i);
            result.push(mapped);
            for (i++; i < array.length; i++) {
              result.push(f(array[i], i));
            }
            return result;
          }
        }
      }
      return array;
    }
    ts2.sameMap = sameMap;
    function flatten(array) {
      var result = [];
      for (var _i = 0, array_2 = array; _i < array_2.length; _i++) {
        var v = array_2[_i];
        if (v) {
          if (isArray(v)) {
            addRange(result, v);
          } else {
            result.push(v);
          }
        }
      }
      return result;
    }
    ts2.flatten = flatten;
    function flatMap(array, mapfn) {
      var result;
      if (array) {
        for (var i = 0; i < array.length; i++) {
          var v = mapfn(array[i], i);
          if (v) {
            if (isArray(v)) {
              result = addRange(result, v);
            } else {
              result = append(result, v);
            }
          }
        }
      }
      return result || ts2.emptyArray;
    }
    ts2.flatMap = flatMap;
    function flatMapToMutable(array, mapfn) {
      var result = [];
      if (array) {
        for (var i = 0; i < array.length; i++) {
          var v = mapfn(array[i], i);
          if (v) {
            if (isArray(v)) {
              addRange(result, v);
            } else {
              result.push(v);
            }
          }
        }
      }
      return result;
    }
    ts2.flatMapToMutable = flatMapToMutable;
    function flatMapIterator(iter, mapfn) {
      var first2 = iter.next();
      if (first2.done) {
        return ts2.emptyIterator;
      }
      var currentIter = getIterator2(first2.value);
      return {
        next: function() {
          while (true) {
            var currentRes = currentIter.next();
            if (!currentRes.done) {
              return currentRes;
            }
            var iterRes = iter.next();
            if (iterRes.done) {
              return iterRes;
            }
            currentIter = getIterator2(iterRes.value);
          }
        }
      };
      function getIterator2(x) {
        var res = mapfn(x);
        return res === void 0 ? ts2.emptyIterator : isArray(res) ? arrayIterator(res) : res;
      }
    }
    ts2.flatMapIterator = flatMapIterator;
    function sameFlatMap(array, mapfn) {
      var result;
      if (array) {
        for (var i = 0; i < array.length; i++) {
          var item = array[i];
          var mapped = mapfn(item, i);
          if (result || item !== mapped || isArray(mapped)) {
            if (!result) {
              result = array.slice(0, i);
            }
            if (isArray(mapped)) {
              addRange(result, mapped);
            } else {
              result.push(mapped);
            }
          }
        }
      }
      return result || array;
    }
    ts2.sameFlatMap = sameFlatMap;
    function mapAllOrFail(array, mapFn) {
      var result = [];
      for (var i = 0; i < array.length; i++) {
        var mapped = mapFn(array[i], i);
        if (mapped === void 0) {
          return void 0;
        }
        result.push(mapped);
      }
      return result;
    }
    ts2.mapAllOrFail = mapAllOrFail;
    function mapDefined(array, mapFn) {
      var result = [];
      if (array) {
        for (var i = 0; i < array.length; i++) {
          var mapped = mapFn(array[i], i);
          if (mapped !== void 0) {
            result.push(mapped);
          }
        }
      }
      return result;
    }
    ts2.mapDefined = mapDefined;
    function mapDefinedIterator(iter, mapFn) {
      return {
        next: function() {
          while (true) {
            var res = iter.next();
            if (res.done) {
              return res;
            }
            var value = mapFn(res.value);
            if (value !== void 0) {
              return { value, done: false };
            }
          }
        }
      };
    }
    ts2.mapDefinedIterator = mapDefinedIterator;
    function mapDefinedEntries(map2, f) {
      if (!map2) {
        return void 0;
      }
      var result = new ts2.Map();
      map2.forEach(function(value, key) {
        var entry = f(key, value);
        if (entry !== void 0) {
          var newKey = entry[0], newValue = entry[1];
          if (newKey !== void 0 && newValue !== void 0) {
            result.set(newKey, newValue);
          }
        }
      });
      return result;
    }
    ts2.mapDefinedEntries = mapDefinedEntries;
    function mapDefinedValues(set, f) {
      if (set) {
        var result_1 = new ts2.Set();
        set.forEach(function(value) {
          var newValue = f(value);
          if (newValue !== void 0) {
            result_1.add(newValue);
          }
        });
        return result_1;
      }
    }
    ts2.mapDefinedValues = mapDefinedValues;
    function getOrUpdate(map2, key, callback) {
      if (map2.has(key)) {
        return map2.get(key);
      }
      var value = callback();
      map2.set(key, value);
      return value;
    }
    ts2.getOrUpdate = getOrUpdate;
    function tryAddToSet(set, value) {
      if (!set.has(value)) {
        set.add(value);
        return true;
      }
      return false;
    }
    ts2.tryAddToSet = tryAddToSet;
    ts2.emptyIterator = { next: function() {
      return { value: void 0, done: true };
    } };
    function singleIterator(value) {
      var done = false;
      return {
        next: function() {
          var wasDone = done;
          done = true;
          return wasDone ? { value: void 0, done: true } : { value, done: false };
        }
      };
    }
    ts2.singleIterator = singleIterator;
    function spanMap(array, keyfn, mapfn) {
      var result;
      if (array) {
        result = [];
        var len = array.length;
        var previousKey = void 0;
        var key = void 0;
        var start = 0;
        var pos = 0;
        while (start < len) {
          while (pos < len) {
            var value = array[pos];
            key = keyfn(value, pos);
            if (pos === 0) {
              previousKey = key;
            } else if (key !== previousKey) {
              break;
            }
            pos++;
          }
          if (start < pos) {
            var v = mapfn(array.slice(start, pos), previousKey, start, pos);
            if (v) {
              result.push(v);
            }
            start = pos;
          }
          previousKey = key;
          pos++;
        }
      }
      return result;
    }
    ts2.spanMap = spanMap;
    function mapEntries(map2, f) {
      if (!map2) {
        return void 0;
      }
      var result = new ts2.Map();
      map2.forEach(function(value, key) {
        var _a = f(key, value), newKey = _a[0], newValue = _a[1];
        result.set(newKey, newValue);
      });
      return result;
    }
    ts2.mapEntries = mapEntries;
    function some(array, predicate) {
      if (array) {
        if (predicate) {
          for (var _i = 0, array_3 = array; _i < array_3.length; _i++) {
            var v = array_3[_i];
            if (predicate(v)) {
              return true;
            }
          }
        } else {
          return array.length > 0;
        }
      }
      return false;
    }
    ts2.some = some;
    function getRangesWhere(arr, pred, cb) {
      var start;
      for (var i = 0; i < arr.length; i++) {
        if (pred(arr[i])) {
          start = start === void 0 ? i : start;
        } else {
          if (start !== void 0) {
            cb(start, i);
            start = void 0;
          }
        }
      }
      if (start !== void 0)
        cb(start, arr.length);
    }
    ts2.getRangesWhere = getRangesWhere;
    function concatenate(array1, array2) {
      if (!some(array2))
        return array1;
      if (!some(array1))
        return array2;
      return __spreadArray(__spreadArray([], array1, true), array2, true);
    }
    ts2.concatenate = concatenate;
    function selectIndex(_, i) {
      return i;
    }
    function indicesOf(array) {
      return array.map(selectIndex);
    }
    ts2.indicesOf = indicesOf;
    function deduplicateRelational(array, equalityComparer, comparer) {
      var indices = indicesOf(array);
      stableSortIndices(array, indices, comparer);
      var last2 = array[indices[0]];
      var deduplicated = [indices[0]];
      for (var i = 1; i < indices.length; i++) {
        var index = indices[i];
        var item = array[index];
        if (!equalityComparer(last2, item)) {
          deduplicated.push(index);
          last2 = item;
        }
      }
      deduplicated.sort();
      return deduplicated.map(function(i2) {
        return array[i2];
      });
    }
    function deduplicateEquality(array, equalityComparer) {
      var result = [];
      for (var _i = 0, array_4 = array; _i < array_4.length; _i++) {
        var item = array_4[_i];
        pushIfUnique(result, item, equalityComparer);
      }
      return result;
    }
    function deduplicate(array, equalityComparer, comparer) {
      return array.length === 0 ? [] : array.length === 1 ? array.slice() : comparer ? deduplicateRelational(array, equalityComparer, comparer) : deduplicateEquality(array, equalityComparer);
    }
    ts2.deduplicate = deduplicate;
    function deduplicateSorted(array, comparer) {
      if (array.length === 0)
        return ts2.emptyArray;
      var last2 = array[0];
      var deduplicated = [last2];
      for (var i = 1; i < array.length; i++) {
        var next = array[i];
        switch (comparer(next, last2)) {
          case true:
          case 0:
            continue;
          case -1:
            return ts2.Debug.fail("Array is unsorted.");
        }
        deduplicated.push(last2 = next);
      }
      return deduplicated;
    }
    function insertSorted(array, insert, compare) {
      if (array.length === 0) {
        array.push(insert);
        return;
      }
      var insertIndex = binarySearch(array, insert, identity, compare);
      if (insertIndex < 0) {
        array.splice(~insertIndex, 0, insert);
      }
    }
    ts2.insertSorted = insertSorted;
    function sortAndDeduplicate(array, comparer, equalityComparer) {
      return deduplicateSorted(sort(array, comparer), equalityComparer || comparer || compareStringsCaseSensitive);
    }
    ts2.sortAndDeduplicate = sortAndDeduplicate;
    function arrayIsSorted(array, comparer) {
      if (array.length < 2)
        return true;
      var prevElement = array[0];
      for (var _i = 0, _a = array.slice(1); _i < _a.length; _i++) {
        var element = _a[_i];
        if (comparer(prevElement, element) === 1) {
          return false;
        }
        prevElement = element;
      }
      return true;
    }
    ts2.arrayIsSorted = arrayIsSorted;
    function arrayIsEqualTo(array1, array2, equalityComparer) {
      if (equalityComparer === void 0) {
        equalityComparer = equateValues;
      }
      if (!array1 || !array2) {
        return array1 === array2;
      }
      if (array1.length !== array2.length) {
        return false;
      }
      for (var i = 0; i < array1.length; i++) {
        if (!equalityComparer(array1[i], array2[i], i)) {
          return false;
        }
      }
      return true;
    }
    ts2.arrayIsEqualTo = arrayIsEqualTo;
    function compact(array) {
      var result;
      if (array) {
        for (var i = 0; i < array.length; i++) {
          var v = array[i];
          if (result || !v) {
            if (!result) {
              result = array.slice(0, i);
            }
            if (v) {
              result.push(v);
            }
          }
        }
      }
      return result || array;
    }
    ts2.compact = compact;
    function relativeComplement(arrayA, arrayB, comparer) {
      if (!arrayB || !arrayA || arrayB.length === 0 || arrayA.length === 0)
        return arrayB;
      var result = [];
      loopB:
        for (var offsetA = 0, offsetB = 0; offsetB < arrayB.length; offsetB++) {
          if (offsetB > 0) {
            ts2.Debug.assertGreaterThanOrEqual(comparer(arrayB[offsetB], arrayB[offsetB - 1]), 0);
          }
          loopA:
            for (var startA = offsetA; offsetA < arrayA.length; offsetA++) {
              if (offsetA > startA) {
                ts2.Debug.assertGreaterThanOrEqual(comparer(arrayA[offsetA], arrayA[offsetA - 1]), 0);
              }
              switch (comparer(arrayB[offsetB], arrayA[offsetA])) {
                case -1:
                  result.push(arrayB[offsetB]);
                  continue loopB;
                case 0:
                  continue loopB;
                case 1:
                  continue loopA;
              }
            }
        }
      return result;
    }
    ts2.relativeComplement = relativeComplement;
    function sum(array, prop) {
      var result = 0;
      for (var _i = 0, array_5 = array; _i < array_5.length; _i++) {
        var v = array_5[_i];
        result += v[prop];
      }
      return result;
    }
    ts2.sum = sum;
    function append(to, value) {
      if (value === void 0)
        return to;
      if (to === void 0)
        return [value];
      to.push(value);
      return to;
    }
    ts2.append = append;
    function combine(xs, ys) {
      if (xs === void 0)
        return ys;
      if (ys === void 0)
        return xs;
      if (isArray(xs))
        return isArray(ys) ? concatenate(xs, ys) : append(xs, ys);
      if (isArray(ys))
        return append(ys, xs);
      return [xs, ys];
    }
    ts2.combine = combine;
    function toOffset(array, offset) {
      return offset < 0 ? array.length + offset : offset;
    }
    function addRange(to, from, start, end) {
      if (from === void 0 || from.length === 0)
        return to;
      if (to === void 0)
        return from.slice(start, end);
      start = start === void 0 ? 0 : toOffset(from, start);
      end = end === void 0 ? from.length : toOffset(from, end);
      for (var i = start; i < end && i < from.length; i++) {
        if (from[i] !== void 0) {
          to.push(from[i]);
        }
      }
      return to;
    }
    ts2.addRange = addRange;
    function pushIfUnique(array, toAdd, equalityComparer) {
      if (contains(array, toAdd, equalityComparer)) {
        return false;
      } else {
        array.push(toAdd);
        return true;
      }
    }
    ts2.pushIfUnique = pushIfUnique;
    function appendIfUnique(array, toAdd, equalityComparer) {
      if (array) {
        pushIfUnique(array, toAdd, equalityComparer);
        return array;
      } else {
        return [toAdd];
      }
    }
    ts2.appendIfUnique = appendIfUnique;
    function stableSortIndices(array, indices, comparer) {
      indices.sort(function(x, y) {
        return comparer(array[x], array[y]) || compareValues(x, y);
      });
    }
    function sort(array, comparer) {
      return array.length === 0 ? array : array.slice().sort(comparer);
    }
    ts2.sort = sort;
    function arrayIterator(array) {
      var i = 0;
      return { next: function() {
        if (i === array.length) {
          return { value: void 0, done: true };
        } else {
          i++;
          return { value: array[i - 1], done: false };
        }
      } };
    }
    ts2.arrayIterator = arrayIterator;
    function arrayReverseIterator(array) {
      var i = array.length;
      return {
        next: function() {
          if (i === 0) {
            return { value: void 0, done: true };
          } else {
            i--;
            return { value: array[i], done: false };
          }
        }
      };
    }
    ts2.arrayReverseIterator = arrayReverseIterator;
    function stableSort(array, comparer) {
      var indices = indicesOf(array);
      stableSortIndices(array, indices, comparer);
      return indices.map(function(i) {
        return array[i];
      });
    }
    ts2.stableSort = stableSort;
    function rangeEquals(array1, array2, pos, end) {
      while (pos < end) {
        if (array1[pos] !== array2[pos]) {
          return false;
        }
        pos++;
      }
      return true;
    }
    ts2.rangeEquals = rangeEquals;
    function elementAt(array, offset) {
      if (array) {
        offset = toOffset(array, offset);
        if (offset < array.length) {
          return array[offset];
        }
      }
      return void 0;
    }
    ts2.elementAt = elementAt;
    function firstOrUndefined(array) {
      return array.length === 0 ? void 0 : array[0];
    }
    ts2.firstOrUndefined = firstOrUndefined;
    function first(array) {
      ts2.Debug.assert(array.length !== 0);
      return array[0];
    }
    ts2.first = first;
    function lastOrUndefined(array) {
      return array.length === 0 ? void 0 : array[array.length - 1];
    }
    ts2.lastOrUndefined = lastOrUndefined;
    function last(array) {
      ts2.Debug.assert(array.length !== 0);
      return array[array.length - 1];
    }
    ts2.last = last;
    function singleOrUndefined(array) {
      return array && array.length === 1 ? array[0] : void 0;
    }
    ts2.singleOrUndefined = singleOrUndefined;
    function singleOrMany(array) {
      return array && array.length === 1 ? array[0] : array;
    }
    ts2.singleOrMany = singleOrMany;
    function replaceElement(array, index, value) {
      var result = array.slice(0);
      result[index] = value;
      return result;
    }
    ts2.replaceElement = replaceElement;
    function binarySearch(array, value, keySelector, keyComparer, offset) {
      return binarySearchKey(array, keySelector(value), keySelector, keyComparer, offset);
    }
    ts2.binarySearch = binarySearch;
    function binarySearchKey(array, key, keySelector, keyComparer, offset) {
      if (!some(array)) {
        return -1;
      }
      var low = offset || 0;
      var high = array.length - 1;
      while (low <= high) {
        var middle = low + (high - low >> 1);
        var midKey = keySelector(array[middle], middle);
        switch (keyComparer(midKey, key)) {
          case -1:
            low = middle + 1;
            break;
          case 0:
            return middle;
          case 1:
            high = middle - 1;
            break;
        }
      }
      return ~low;
    }
    ts2.binarySearchKey = binarySearchKey;
    function reduceLeft(array, f, initial, start, count) {
      if (array && array.length > 0) {
        var size = array.length;
        if (size > 0) {
          var pos = start === void 0 || start < 0 ? 0 : start;
          var end = count === void 0 || pos + count > size - 1 ? size - 1 : pos + count;
          var result = void 0;
          if (arguments.length <= 2) {
            result = array[pos];
            pos++;
          } else {
            result = initial;
          }
          while (pos <= end) {
            result = f(result, array[pos], pos);
            pos++;
          }
          return result;
        }
      }
      return initial;
    }
    ts2.reduceLeft = reduceLeft;
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    function hasProperty(map2, key) {
      return hasOwnProperty.call(map2, key);
    }
    ts2.hasProperty = hasProperty;
    function getProperty(map2, key) {
      return hasOwnProperty.call(map2, key) ? map2[key] : void 0;
    }
    ts2.getProperty = getProperty;
    function getOwnKeys(map2) {
      var keys = [];
      for (var key in map2) {
        if (hasOwnProperty.call(map2, key)) {
          keys.push(key);
        }
      }
      return keys;
    }
    ts2.getOwnKeys = getOwnKeys;
    function getAllKeys(obj) {
      var result = [];
      do {
        var names = Object.getOwnPropertyNames(obj);
        for (var _i = 0, names_1 = names; _i < names_1.length; _i++) {
          var name = names_1[_i];
          pushIfUnique(result, name);
        }
      } while (obj = Object.getPrototypeOf(obj));
      return result;
    }
    ts2.getAllKeys = getAllKeys;
    function getOwnValues(sparseArray) {
      var values = [];
      for (var key in sparseArray) {
        if (hasOwnProperty.call(sparseArray, key)) {
          values.push(sparseArray[key]);
        }
      }
      return values;
    }
    ts2.getOwnValues = getOwnValues;
    var _entries = Object.entries || function(obj) {
      var keys = getOwnKeys(obj);
      var result = Array(keys.length);
      for (var i = 0; i < keys.length; i++) {
        result[i] = [keys[i], obj[keys[i]]];
      }
      return result;
    };
    function getEntries(obj) {
      return obj ? _entries(obj) : [];
    }
    ts2.getEntries = getEntries;
    function arrayOf(count, f) {
      var result = new Array(count);
      for (var i = 0; i < count; i++) {
        result[i] = f(i);
      }
      return result;
    }
    ts2.arrayOf = arrayOf;
    function arrayFrom(iterator, map2) {
      var result = [];
      for (var iterResult = iterator.next(); !iterResult.done; iterResult = iterator.next()) {
        result.push(map2 ? map2(iterResult.value) : iterResult.value);
      }
      return result;
    }
    ts2.arrayFrom = arrayFrom;
    function assign(t) {
      var args = [];
      for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
      }
      for (var _a = 0, args_1 = args; _a < args_1.length; _a++) {
        var arg = args_1[_a];
        if (arg === void 0)
          continue;
        for (var p in arg) {
          if (hasProperty(arg, p)) {
            t[p] = arg[p];
          }
        }
      }
      return t;
    }
    ts2.assign = assign;
    function equalOwnProperties(left, right, equalityComparer) {
      if (equalityComparer === void 0) {
        equalityComparer = equateValues;
      }
      if (left === right)
        return true;
      if (!left || !right)
        return false;
      for (var key in left) {
        if (hasOwnProperty.call(left, key)) {
          if (!hasOwnProperty.call(right, key))
            return false;
          if (!equalityComparer(left[key], right[key]))
            return false;
        }
      }
      for (var key in right) {
        if (hasOwnProperty.call(right, key)) {
          if (!hasOwnProperty.call(left, key))
            return false;
        }
      }
      return true;
    }
    ts2.equalOwnProperties = equalOwnProperties;
    function arrayToMap(array, makeKey, makeValue) {
      if (makeValue === void 0) {
        makeValue = identity;
      }
      var result = new ts2.Map();
      for (var _i = 0, array_6 = array; _i < array_6.length; _i++) {
        var value = array_6[_i];
        var key = makeKey(value);
        if (key !== void 0)
          result.set(key, makeValue(value));
      }
      return result;
    }
    ts2.arrayToMap = arrayToMap;
    function arrayToNumericMap(array, makeKey, makeValue) {
      if (makeValue === void 0) {
        makeValue = identity;
      }
      var result = [];
      for (var _i = 0, array_7 = array; _i < array_7.length; _i++) {
        var value = array_7[_i];
        result[makeKey(value)] = makeValue(value);
      }
      return result;
    }
    ts2.arrayToNumericMap = arrayToNumericMap;
    function arrayToMultiMap(values, makeKey, makeValue) {
      if (makeValue === void 0) {
        makeValue = identity;
      }
      var result = createMultiMap();
      for (var _i = 0, values_1 = values; _i < values_1.length; _i++) {
        var value = values_1[_i];
        result.add(makeKey(value), makeValue(value));
      }
      return result;
    }
    ts2.arrayToMultiMap = arrayToMultiMap;
    function group(values, getGroupId, resultSelector) {
      if (resultSelector === void 0) {
        resultSelector = identity;
      }
      return arrayFrom(arrayToMultiMap(values, getGroupId).values(), resultSelector);
    }
    ts2.group = group;
    function clone(object) {
      var result = {};
      for (var id in object) {
        if (hasOwnProperty.call(object, id)) {
          result[id] = object[id];
        }
      }
      return result;
    }
    ts2.clone = clone;
    function extend(first2, second) {
      var result = {};
      for (var id in second) {
        if (hasOwnProperty.call(second, id)) {
          result[id] = second[id];
        }
      }
      for (var id in first2) {
        if (hasOwnProperty.call(first2, id)) {
          result[id] = first2[id];
        }
      }
      return result;
    }
    ts2.extend = extend;
    function copyProperties(first2, second) {
      for (var id in second) {
        if (hasOwnProperty.call(second, id)) {
          first2[id] = second[id];
        }
      }
    }
    ts2.copyProperties = copyProperties;
    function maybeBind(obj, fn) {
      return fn ? fn.bind(obj) : void 0;
    }
    ts2.maybeBind = maybeBind;
    function createMultiMap() {
      var map2 = new ts2.Map();
      map2.add = multiMapAdd;
      map2.remove = multiMapRemove;
      return map2;
    }
    ts2.createMultiMap = createMultiMap;
    function multiMapAdd(key, value) {
      var values = this.get(key);
      if (values) {
        values.push(value);
      } else {
        this.set(key, values = [value]);
      }
      return values;
    }
    function multiMapRemove(key, value) {
      var values = this.get(key);
      if (values) {
        unorderedRemoveItem(values, value);
        if (!values.length) {
          this.delete(key);
        }
      }
    }
    function createUnderscoreEscapedMultiMap() {
      return createMultiMap();
    }
    ts2.createUnderscoreEscapedMultiMap = createUnderscoreEscapedMultiMap;
    function isArray(value) {
      return Array.isArray ? Array.isArray(value) : value instanceof Array;
    }
    ts2.isArray = isArray;
    function toArray(value) {
      return isArray(value) ? value : [value];
    }
    ts2.toArray = toArray;
    function isString(text) {
      return typeof text === "string";
    }
    ts2.isString = isString;
    function isNumber(x) {
      return typeof x === "number";
    }
    ts2.isNumber = isNumber;
    function tryCast(value, test) {
      return value !== void 0 && test(value) ? value : void 0;
    }
    ts2.tryCast = tryCast;
    function cast(value, test) {
      if (value !== void 0 && test(value))
        return value;
      return ts2.Debug.fail("Invalid cast. The supplied value " + value + " did not pass the test '" + ts2.Debug.getFunctionName(test) + "'.");
    }
    ts2.cast = cast;
    function noop(_) {
    }
    ts2.noop = noop;
    function returnFalse() {
      return false;
    }
    ts2.returnFalse = returnFalse;
    function returnTrue() {
      return true;
    }
    ts2.returnTrue = returnTrue;
    function returnUndefined() {
      return void 0;
    }
    ts2.returnUndefined = returnUndefined;
    function identity(x) {
      return x;
    }
    ts2.identity = identity;
    function toLowerCase(x) {
      return x.toLowerCase();
    }
    ts2.toLowerCase = toLowerCase;
    var fileNameLowerCaseRegExp = /[^\u0130\u0131\u00DFa-z0-9\\/:\-_\. ]+/g;
    function toFileNameLowerCase(x) {
      return fileNameLowerCaseRegExp.test(x) ? x.replace(fileNameLowerCaseRegExp, toLowerCase) : x;
    }
    ts2.toFileNameLowerCase = toFileNameLowerCase;
    function notImplemented() {
      throw new Error("Not implemented");
    }
    ts2.notImplemented = notImplemented;
    function memoize(callback) {
      var value;
      return function() {
        if (callback) {
          value = callback();
          callback = void 0;
        }
        return value;
      };
    }
    ts2.memoize = memoize;
    function memoizeOne(callback) {
      var map2 = new ts2.Map();
      return function(arg) {
        var key = typeof arg + ":" + arg;
        var value = map2.get(key);
        if (value === void 0 && !map2.has(key)) {
          value = callback(arg);
          map2.set(key, value);
        }
        return value;
      };
    }
    ts2.memoizeOne = memoizeOne;
    function compose(a, b, c, d, e) {
      if (!!e) {
        var args_2 = [];
        for (var i = 0; i < arguments.length; i++) {
          args_2[i] = arguments[i];
        }
        return function(t) {
          return reduceLeft(args_2, function(u, f) {
            return f(u);
          }, t);
        };
      } else if (d) {
        return function(t) {
          return d(c(b(a(t))));
        };
      } else if (c) {
        return function(t) {
          return c(b(a(t)));
        };
      } else if (b) {
        return function(t) {
          return b(a(t));
        };
      } else if (a) {
        return function(t) {
          return a(t);
        };
      } else {
        return function(t) {
          return t;
        };
      }
    }
    ts2.compose = compose;
    var AssertionLevel;
    (function(AssertionLevel2) {
      AssertionLevel2[AssertionLevel2["None"] = 0] = "None";
      AssertionLevel2[AssertionLevel2["Normal"] = 1] = "Normal";
      AssertionLevel2[AssertionLevel2["Aggressive"] = 2] = "Aggressive";
      AssertionLevel2[AssertionLevel2["VeryAggressive"] = 3] = "VeryAggressive";
    })(AssertionLevel = ts2.AssertionLevel || (ts2.AssertionLevel = {}));
    function equateValues(a, b) {
      return a === b;
    }
    ts2.equateValues = equateValues;
    function equateStringsCaseInsensitive(a, b) {
      return a === b || a !== void 0 && b !== void 0 && a.toUpperCase() === b.toUpperCase();
    }
    ts2.equateStringsCaseInsensitive = equateStringsCaseInsensitive;
    function equateStringsCaseSensitive(a, b) {
      return equateValues(a, b);
    }
    ts2.equateStringsCaseSensitive = equateStringsCaseSensitive;
    function compareComparableValues(a, b) {
      return a === b ? 0 : a === void 0 ? -1 : b === void 0 ? 1 : a < b ? -1 : 1;
    }
    function compareValues(a, b) {
      return compareComparableValues(a, b);
    }
    ts2.compareValues = compareValues;
    function compareTextSpans(a, b) {
      return compareValues(a === null || a === void 0 ? void 0 : a.start, b === null || b === void 0 ? void 0 : b.start) || compareValues(a === null || a === void 0 ? void 0 : a.length, b === null || b === void 0 ? void 0 : b.length);
    }
    ts2.compareTextSpans = compareTextSpans;
    function min(a, b, compare) {
      return compare(a, b) === -1 ? a : b;
    }
    ts2.min = min;
    function compareStringsCaseInsensitive(a, b) {
      if (a === b)
        return 0;
      if (a === void 0)
        return -1;
      if (b === void 0)
        return 1;
      a = a.toUpperCase();
      b = b.toUpperCase();
      return a < b ? -1 : a > b ? 1 : 0;
    }
    ts2.compareStringsCaseInsensitive = compareStringsCaseInsensitive;
    function compareStringsCaseSensitive(a, b) {
      return compareComparableValues(a, b);
    }
    ts2.compareStringsCaseSensitive = compareStringsCaseSensitive;
    function getStringComparer(ignoreCase) {
      return ignoreCase ? compareStringsCaseInsensitive : compareStringsCaseSensitive;
    }
    ts2.getStringComparer = getStringComparer;
    var createUIStringComparer = function() {
      var defaultComparer;
      var enUSComparer;
      var stringComparerFactory = getStringComparerFactory();
      return createStringComparer;
      function compareWithCallback(a, b, comparer) {
        if (a === b)
          return 0;
        if (a === void 0)
          return -1;
        if (b === void 0)
          return 1;
        var value = comparer(a, b);
        return value < 0 ? -1 : value > 0 ? 1 : 0;
      }
      function createIntlCollatorStringComparer(locale) {
        var comparer = new Intl.Collator(locale, { usage: "sort", sensitivity: "variant" }).compare;
        return function(a, b) {
          return compareWithCallback(a, b, comparer);
        };
      }
      function createLocaleCompareStringComparer(locale) {
        if (locale !== void 0)
          return createFallbackStringComparer();
        return function(a, b) {
          return compareWithCallback(a, b, compareStrings);
        };
        function compareStrings(a, b) {
          return a.localeCompare(b);
        }
      }
      function createFallbackStringComparer() {
        return function(a, b) {
          return compareWithCallback(a, b, compareDictionaryOrder);
        };
        function compareDictionaryOrder(a, b) {
          return compareStrings(a.toUpperCase(), b.toUpperCase()) || compareStrings(a, b);
        }
        function compareStrings(a, b) {
          return a < b ? -1 : a > b ? 1 : 0;
        }
      }
      function getStringComparerFactory() {
        if (typeof Intl === "object" && typeof Intl.Collator === "function") {
          return createIntlCollatorStringComparer;
        }
        if (typeof String.prototype.localeCompare === "function" && typeof String.prototype.toLocaleUpperCase === "function" && "a".localeCompare("B") < 0) {
          return createLocaleCompareStringComparer;
        }
        return createFallbackStringComparer;
      }
      function createStringComparer(locale) {
        if (locale === void 0) {
          return defaultComparer || (defaultComparer = stringComparerFactory(locale));
        } else if (locale === "en-US") {
          return enUSComparer || (enUSComparer = stringComparerFactory(locale));
        } else {
          return stringComparerFactory(locale);
        }
      }
    }();
    var uiComparerCaseSensitive;
    var uiLocale;
    function getUILocale() {
      return uiLocale;
    }
    ts2.getUILocale = getUILocale;
    function setUILocale(value) {
      if (uiLocale !== value) {
        uiLocale = value;
        uiComparerCaseSensitive = void 0;
      }
    }
    ts2.setUILocale = setUILocale;
    function compareStringsCaseSensitiveUI(a, b) {
      var comparer = uiComparerCaseSensitive || (uiComparerCaseSensitive = createUIStringComparer(uiLocale));
      return comparer(a, b);
    }
    ts2.compareStringsCaseSensitiveUI = compareStringsCaseSensitiveUI;
    function compareProperties(a, b, key, comparer) {
      return a === b ? 0 : a === void 0 ? -1 : b === void 0 ? 1 : comparer(a[key], b[key]);
    }
    ts2.compareProperties = compareProperties;
    function compareBooleans(a, b) {
      return compareValues(a ? 1 : 0, b ? 1 : 0);
    }
    ts2.compareBooleans = compareBooleans;
    function getSpellingSuggestion(name, candidates, getName) {
      var maximumLengthDifference = Math.min(2, Math.floor(name.length * 0.34));
      var bestDistance = Math.floor(name.length * 0.4) + 1;
      var bestCandidate;
      for (var _i = 0, candidates_1 = candidates; _i < candidates_1.length; _i++) {
        var candidate = candidates_1[_i];
        var candidateName = getName(candidate);
        if (candidateName !== void 0 && Math.abs(candidateName.length - name.length) <= maximumLengthDifference) {
          if (candidateName === name) {
            continue;
          }
          if (candidateName.length < 3 && candidateName.toLowerCase() !== name.toLowerCase()) {
            continue;
          }
          var distance = levenshteinWithMax(name, candidateName, bestDistance - 0.1);
          if (distance === void 0) {
            continue;
          }
          ts2.Debug.assert(distance < bestDistance);
          bestDistance = distance;
          bestCandidate = candidate;
        }
      }
      return bestCandidate;
    }
    ts2.getSpellingSuggestion = getSpellingSuggestion;
    function levenshteinWithMax(s1, s2, max) {
      var previous = new Array(s2.length + 1);
      var current = new Array(s2.length + 1);
      var big = max + 0.01;
      for (var i = 0; i <= s2.length; i++) {
        previous[i] = i;
      }
      for (var i = 1; i <= s1.length; i++) {
        var c1 = s1.charCodeAt(i - 1);
        var minJ = Math.ceil(i > max ? i - max : 1);
        var maxJ = Math.floor(s2.length > max + i ? max + i : s2.length);
        current[0] = i;
        var colMin = i;
        for (var j = 1; j < minJ; j++) {
          current[j] = big;
        }
        for (var j = minJ; j <= maxJ; j++) {
          var substitutionDistance = s1[i - 1].toLowerCase() === s2[j - 1].toLowerCase() ? previous[j - 1] + 0.1 : previous[j - 1] + 2;
          var dist = c1 === s2.charCodeAt(j - 1) ? previous[j - 1] : Math.min(previous[j] + 1, current[j - 1] + 1, substitutionDistance);
          current[j] = dist;
          colMin = Math.min(colMin, dist);
        }
        for (var j = maxJ + 1; j <= s2.length; j++) {
          current[j] = big;
        }
        if (colMin > max) {
          return void 0;
        }
        var temp = previous;
        previous = current;
        current = temp;
      }
      var res = previous[s2.length];
      return res > max ? void 0 : res;
    }
    function endsWith(str, suffix) {
      var expectedPos = str.length - suffix.length;
      return expectedPos >= 0 && str.indexOf(suffix, expectedPos) === expectedPos;
    }
    ts2.endsWith = endsWith;
    function removeSuffix(str, suffix) {
      return endsWith(str, suffix) ? str.slice(0, str.length - suffix.length) : str;
    }
    ts2.removeSuffix = removeSuffix;
    function tryRemoveSuffix(str, suffix) {
      return endsWith(str, suffix) ? str.slice(0, str.length - suffix.length) : void 0;
    }
    ts2.tryRemoveSuffix = tryRemoveSuffix;
    function stringContains(str, substring) {
      return str.indexOf(substring) !== -1;
    }
    ts2.stringContains = stringContains;
    function removeMinAndVersionNumbers(fileName) {
      var end = fileName.length;
      for (var pos = end - 1; pos > 0; pos--) {
        var ch = fileName.charCodeAt(pos);
        if (ch >= 48 && ch <= 57) {
          do {
            --pos;
            ch = fileName.charCodeAt(pos);
          } while (pos > 0 && ch >= 48 && ch <= 57);
        } else if (pos > 4 && (ch === 110 || ch === 78)) {
          --pos;
          ch = fileName.charCodeAt(pos);
          if (ch !== 105 && ch !== 73) {
            break;
          }
          --pos;
          ch = fileName.charCodeAt(pos);
          if (ch !== 109 && ch !== 77) {
            break;
          }
          --pos;
          ch = fileName.charCodeAt(pos);
        } else {
          break;
        }
        if (ch !== 45 && ch !== 46) {
          break;
        }
        end = pos;
      }
      return end === fileName.length ? fileName : fileName.slice(0, end);
    }
    ts2.removeMinAndVersionNumbers = removeMinAndVersionNumbers;
    function orderedRemoveItem(array, item) {
      for (var i = 0; i < array.length; i++) {
        if (array[i] === item) {
          orderedRemoveItemAt(array, i);
          return true;
        }
      }
      return false;
    }
    ts2.orderedRemoveItem = orderedRemoveItem;
    function orderedRemoveItemAt(array, index) {
      for (var i = index; i < array.length - 1; i++) {
        array[i] = array[i + 1];
      }
      array.pop();
    }
    ts2.orderedRemoveItemAt = orderedRemoveItemAt;
    function unorderedRemoveItemAt(array, index) {
      array[index] = array[array.length - 1];
      array.pop();
    }
    ts2.unorderedRemoveItemAt = unorderedRemoveItemAt;
    function unorderedRemoveItem(array, item) {
      return unorderedRemoveFirstItemWhere(array, function(element) {
        return element === item;
      });
    }
    ts2.unorderedRemoveItem = unorderedRemoveItem;
    function unorderedRemoveFirstItemWhere(array, predicate) {
      for (var i = 0; i < array.length; i++) {
        if (predicate(array[i])) {
          unorderedRemoveItemAt(array, i);
          return true;
        }
      }
      return false;
    }
    function createGetCanonicalFileName(useCaseSensitiveFileNames) {
      return useCaseSensitiveFileNames ? identity : toFileNameLowerCase;
    }
    ts2.createGetCanonicalFileName = createGetCanonicalFileName;
    function patternText(_a) {
      var prefix = _a.prefix, suffix = _a.suffix;
      return prefix + "*" + suffix;
    }
    ts2.patternText = patternText;
    function matchedText(pattern, candidate) {
      ts2.Debug.assert(isPatternMatch(pattern, candidate));
      return candidate.substring(pattern.prefix.length, candidate.length - pattern.suffix.length);
    }
    ts2.matchedText = matchedText;
    function findBestPatternMatch(values, getPattern, candidate) {
      var matchedValue;
      var longestMatchPrefixLength = -1;
      for (var _i = 0, values_2 = values; _i < values_2.length; _i++) {
        var v = values_2[_i];
        var pattern = getPattern(v);
        if (isPatternMatch(pattern, candidate) && pattern.prefix.length > longestMatchPrefixLength) {
          longestMatchPrefixLength = pattern.prefix.length;
          matchedValue = v;
        }
      }
      return matchedValue;
    }
    ts2.findBestPatternMatch = findBestPatternMatch;
    function startsWith(str, prefix) {
      return str.lastIndexOf(prefix, 0) === 0;
    }
    ts2.startsWith = startsWith;
    function removePrefix(str, prefix) {
      return startsWith(str, prefix) ? str.substr(prefix.length) : str;
    }
    ts2.removePrefix = removePrefix;
    function tryRemovePrefix(str, prefix, getCanonicalFileName) {
      if (getCanonicalFileName === void 0) {
        getCanonicalFileName = identity;
      }
      return startsWith(getCanonicalFileName(str), getCanonicalFileName(prefix)) ? str.substring(prefix.length) : void 0;
    }
    ts2.tryRemovePrefix = tryRemovePrefix;
    function isPatternMatch(_a, candidate) {
      var prefix = _a.prefix, suffix = _a.suffix;
      return candidate.length >= prefix.length + suffix.length && startsWith(candidate, prefix) && endsWith(candidate, suffix);
    }
    function and(f, g) {
      return function(arg) {
        return f(arg) && g(arg);
      };
    }
    ts2.and = and;
    function or() {
      var fs = [];
      for (var _i = 0; _i < arguments.length; _i++) {
        fs[_i] = arguments[_i];
      }
      return function() {
        var args = [];
        for (var _i2 = 0; _i2 < arguments.length; _i2++) {
          args[_i2] = arguments[_i2];
        }
        for (var _a = 0, fs_1 = fs; _a < fs_1.length; _a++) {
          var f = fs_1[_a];
          if (f.apply(void 0, args)) {
            return true;
          }
        }
        return false;
      };
    }
    ts2.or = or;
    function not(fn) {
      return function() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          args[_i] = arguments[_i];
        }
        return !fn.apply(void 0, args);
      };
    }
    ts2.not = not;
    function assertType(_) {
    }
    ts2.assertType = assertType;
    function singleElementArray(t) {
      return t === void 0 ? void 0 : [t];
    }
    ts2.singleElementArray = singleElementArray;
    function enumerateInsertsAndDeletes(newItems, oldItems, comparer, inserted, deleted, unchanged) {
      unchanged = unchanged || noop;
      var newIndex = 0;
      var oldIndex = 0;
      var newLen = newItems.length;
      var oldLen = oldItems.length;
      var hasChanges = false;
      while (newIndex < newLen && oldIndex < oldLen) {
        var newItem = newItems[newIndex];
        var oldItem = oldItems[oldIndex];
        var compareResult = comparer(newItem, oldItem);
        if (compareResult === -1) {
          inserted(newItem);
          newIndex++;
          hasChanges = true;
        } else if (compareResult === 1) {
          deleted(oldItem);
          oldIndex++;
          hasChanges = true;
        } else {
          unchanged(oldItem, newItem);
          newIndex++;
          oldIndex++;
        }
      }
      while (newIndex < newLen) {
        inserted(newItems[newIndex++]);
        hasChanges = true;
      }
      while (oldIndex < oldLen) {
        deleted(oldItems[oldIndex++]);
        hasChanges = true;
      }
      return hasChanges;
    }
    ts2.enumerateInsertsAndDeletes = enumerateInsertsAndDeletes;
    function fill(length2, cb) {
      var result = Array(length2);
      for (var i = 0; i < length2; i++) {
        result[i] = cb(i);
      }
      return result;
    }
    ts2.fill = fill;
    function cartesianProduct(arrays) {
      var result = [];
      cartesianProductWorker(arrays, result, void 0, 0);
      return result;
    }
    ts2.cartesianProduct = cartesianProduct;
    function cartesianProductWorker(arrays, result, outer, index) {
      for (var _i = 0, _a = arrays[index]; _i < _a.length; _i++) {
        var element = _a[_i];
        var inner = void 0;
        if (outer) {
          inner = outer.slice();
          inner.push(element);
        } else {
          inner = [element];
        }
        if (index === arrays.length - 1) {
          result.push(inner);
        } else {
          cartesianProductWorker(arrays, result, inner, index + 1);
        }
      }
    }
    function padLeft(s, length2, padString) {
      if (padString === void 0) {
        padString = " ";
      }
      return length2 <= s.length ? s : padString.repeat(length2 - s.length) + s;
    }
    ts2.padLeft = padLeft;
    function padRight(s, length2, padString) {
      if (padString === void 0) {
        padString = " ";
      }
      return length2 <= s.length ? s : s + padString.repeat(length2 - s.length);
    }
    ts2.padRight = padRight;
    function takeWhile(array, predicate) {
      var len = array.length;
      var index = 0;
      while (index < len && predicate(array[index])) {
        index++;
      }
      return array.slice(0, index);
    }
    ts2.takeWhile = takeWhile;
    ts2.trimString = !!String.prototype.trim ? function(s) {
      return s.trim();
    } : function(s) {
      return ts2.trimStringEnd(ts2.trimStringStart(s));
    };
    ts2.trimStringEnd = !!String.prototype.trimEnd ? function(s) {
      return s.trimEnd();
    } : trimEndImpl;
    ts2.trimStringStart = !!String.prototype.trimStart ? function(s) {
      return s.trimStart();
    } : function(s) {
      return s.replace(/^\s+/g, "");
    };
    function trimEndImpl(s) {
      var end = s.length - 1;
      while (end >= 0) {
        if (!ts2.isWhiteSpaceLike(s.charCodeAt(end)))
          break;
        end--;
      }
      return s.slice(0, end + 1);
    }
  })(ts || (ts = {}));
  var ts;
  (function(ts2) {
    var LogLevel;
    (function(LogLevel2) {
      LogLevel2[LogLevel2["Off"] = 0] = "Off";
      LogLevel2[LogLevel2["Error"] = 1] = "Error";
      LogLevel2[LogLevel2["Warning"] = 2] = "Warning";
      LogLevel2[LogLevel2["Info"] = 3] = "Info";
      LogLevel2[LogLevel2["Verbose"] = 4] = "Verbose";
    })(LogLevel = ts2.LogLevel || (ts2.LogLevel = {}));
    var Debug;
    (function(Debug2) {
      var typeScriptVersion;
      var currentAssertionLevel = 0;
      Debug2.currentLogLevel = LogLevel.Warning;
      Debug2.isDebugging = false;
      function getTypeScriptVersion() {
        return typeScriptVersion !== null && typeScriptVersion !== void 0 ? typeScriptVersion : typeScriptVersion = new ts2.Version(ts2.version);
      }
      Debug2.getTypeScriptVersion = getTypeScriptVersion;
      function shouldLog(level) {
        return Debug2.currentLogLevel <= level;
      }
      Debug2.shouldLog = shouldLog;
      function logMessage(level, s) {
        if (Debug2.loggingHost && shouldLog(level)) {
          Debug2.loggingHost.log(level, s);
        }
      }
      function log(s) {
        logMessage(LogLevel.Info, s);
      }
      Debug2.log = log;
      (function(log_1) {
        function error(s) {
          logMessage(LogLevel.Error, s);
        }
        log_1.error = error;
        function warn(s) {
          logMessage(LogLevel.Warning, s);
        }
        log_1.warn = warn;
        function log2(s) {
          logMessage(LogLevel.Info, s);
        }
        log_1.log = log2;
        function trace(s) {
          logMessage(LogLevel.Verbose, s);
        }
        log_1.trace = trace;
      })(log = Debug2.log || (Debug2.log = {}));
      var assertionCache = {};
      function getAssertionLevel() {
        return currentAssertionLevel;
      }
      Debug2.getAssertionLevel = getAssertionLevel;
      function setAssertionLevel(level) {
        var prevAssertionLevel = currentAssertionLevel;
        currentAssertionLevel = level;
        if (level > prevAssertionLevel) {
          for (var _i = 0, _a = ts2.getOwnKeys(assertionCache); _i < _a.length; _i++) {
            var key = _a[_i];
            var cachedFunc = assertionCache[key];
            if (cachedFunc !== void 0 && Debug2[key] !== cachedFunc.assertion && level >= cachedFunc.level) {
              Debug2[key] = cachedFunc;
              assertionCache[key] = void 0;
            }
          }
        }
      }
      Debug2.setAssertionLevel = setAssertionLevel;
      function shouldAssert(level) {
        return currentAssertionLevel >= level;
      }
      Debug2.shouldAssert = shouldAssert;
      function shouldAssertFunction(level, name) {
        if (!shouldAssert(level)) {
          assertionCache[name] = { level, assertion: Debug2[name] };
          Debug2[name] = ts2.noop;
          return false;
        }
        return true;
      }
      function fail(message, stackCrawlMark) {
        var e = new Error(message ? "Debug Failure. " + message : "Debug Failure.");
        if (Error.captureStackTrace) {
          Error.captureStackTrace(e, stackCrawlMark || fail);
        }
        throw e;
      }
      Debug2.fail = fail;
      function failBadSyntaxKind(node, message, stackCrawlMark) {
        return fail((message || "Unexpected node.") + "\r\nNode " + formatSyntaxKind(node.kind) + " was unexpected.", stackCrawlMark || failBadSyntaxKind);
      }
      Debug2.failBadSyntaxKind = failBadSyntaxKind;
      function assert(expression, message, verboseDebugInfo, stackCrawlMark) {
        if (!expression) {
          message = message ? "False expression: " + message : "False expression.";
          if (verboseDebugInfo) {
            message += "\r\nVerbose Debug Information: " + (typeof verboseDebugInfo === "string" ? verboseDebugInfo : verboseDebugInfo());
          }
          fail(message, stackCrawlMark || assert);
        }
      }
      Debug2.assert = assert;
      function assertEqual(a, b, msg, msg2, stackCrawlMark) {
        if (a !== b) {
          var message = msg ? msg2 ? msg + " " + msg2 : msg : "";
          fail("Expected " + a + " === " + b + ". " + message, stackCrawlMark || assertEqual);
        }
      }
      Debug2.assertEqual = assertEqual;
      function assertLessThan(a, b, msg, stackCrawlMark) {
        if (a >= b) {
          fail("Expected " + a + " < " + b + ". " + (msg || ""), stackCrawlMark || assertLessThan);
        }
      }
      Debug2.assertLessThan = assertLessThan;
      function assertLessThanOrEqual(a, b, stackCrawlMark) {
        if (a > b) {
          fail("Expected " + a + " <= " + b, stackCrawlMark || assertLessThanOrEqual);
        }
      }
      Debug2.assertLessThanOrEqual = assertLessThanOrEqual;
      function assertGreaterThanOrEqual(a, b, stackCrawlMark) {
        if (a < b) {
          fail("Expected " + a + " >= " + b, stackCrawlMark || assertGreaterThanOrEqual);
        }
      }
      Debug2.assertGreaterThanOrEqual = assertGreaterThanOrEqual;
      function assertIsDefined(value, message, stackCrawlMark) {
        if (value === void 0 || value === null) {
          fail(message, stackCrawlMark || assertIsDefined);
        }
      }
      Debug2.assertIsDefined = assertIsDefined;
      function checkDefined(value, message, stackCrawlMark) {
        assertIsDefined(value, message, stackCrawlMark || checkDefined);
        return value;
      }
      Debug2.checkDefined = checkDefined;
      Debug2.assertDefined = checkDefined;
      function assertEachIsDefined(value, message, stackCrawlMark) {
        for (var _i = 0, value_1 = value; _i < value_1.length; _i++) {
          var v = value_1[_i];
          assertIsDefined(v, message, stackCrawlMark || assertEachIsDefined);
        }
      }
      Debug2.assertEachIsDefined = assertEachIsDefined;
      function checkEachDefined(value, message, stackCrawlMark) {
        assertEachIsDefined(value, message, stackCrawlMark || checkEachDefined);
        return value;
      }
      Debug2.checkEachDefined = checkEachDefined;
      Debug2.assertEachDefined = checkEachDefined;
      function assertNever(member, message, stackCrawlMark) {
        if (message === void 0) {
          message = "Illegal value:";
        }
        var detail = typeof member === "object" && ts2.hasProperty(member, "kind") && ts2.hasProperty(member, "pos") && formatSyntaxKind ? "SyntaxKind: " + formatSyntaxKind(member.kind) : JSON.stringify(member);
        return fail(message + " " + detail, stackCrawlMark || assertNever);
      }
      Debug2.assertNever = assertNever;
      function assertEachNode(nodes, test, message, stackCrawlMark) {
        if (shouldAssertFunction(1, "assertEachNode")) {
          assert(test === void 0 || ts2.every(nodes, test), message || "Unexpected node.", function() {
            return "Node array did not pass test '" + getFunctionName(test) + "'.";
          }, stackCrawlMark || assertEachNode);
        }
      }
      Debug2.assertEachNode = assertEachNode;
      function assertNode(node, test, message, stackCrawlMark) {
        if (shouldAssertFunction(1, "assertNode")) {
          assert(node !== void 0 && (test === void 0 || test(node)), message || "Unexpected node.", function() {
            return "Node " + formatSyntaxKind(node === null || node === void 0 ? void 0 : node.kind) + " did not pass test '" + getFunctionName(test) + "'.";
          }, stackCrawlMark || assertNode);
        }
      }
      Debug2.assertNode = assertNode;
      function assertNotNode(node, test, message, stackCrawlMark) {
        if (shouldAssertFunction(1, "assertNotNode")) {
          assert(node === void 0 || test === void 0 || !test(node), message || "Unexpected node.", function() {
            return "Node " + formatSyntaxKind(node.kind) + " should not have passed test '" + getFunctionName(test) + "'.";
          }, stackCrawlMark || assertNotNode);
        }
      }
      Debug2.assertNotNode = assertNotNode;
      function assertOptionalNode(node, test, message, stackCrawlMark) {
        if (shouldAssertFunction(1, "assertOptionalNode")) {
          assert(test === void 0 || node === void 0 || test(node), message || "Unexpected node.", function() {
            return "Node " + formatSyntaxKind(node === null || node === void 0 ? void 0 : node.kind) + " did not pass test '" + getFunctionName(test) + "'.";
          }, stackCrawlMark || assertOptionalNode);
        }
      }
      Debug2.assertOptionalNode = assertOptionalNode;
      function assertOptionalToken(node, kind, message, stackCrawlMark) {
        if (shouldAssertFunction(1, "assertOptionalToken")) {
          assert(kind === void 0 || node === void 0 || node.kind === kind, message || "Unexpected node.", function() {
            return "Node " + formatSyntaxKind(node === null || node === void 0 ? void 0 : node.kind) + " was not a '" + formatSyntaxKind(kind) + "' token.";
          }, stackCrawlMark || assertOptionalToken);
        }
      }
      Debug2.assertOptionalToken = assertOptionalToken;
      function assertMissingNode(node, message, stackCrawlMark) {
        if (shouldAssertFunction(1, "assertMissingNode")) {
          assert(node === void 0, message || "Unexpected node.", function() {
            return "Node " + formatSyntaxKind(node.kind) + " was unexpected'.";
          }, stackCrawlMark || assertMissingNode);
        }
      }
      Debug2.assertMissingNode = assertMissingNode;
      function type(_value) {
      }
      Debug2.type = type;
      function getFunctionName(func) {
        if (typeof func !== "function") {
          return "";
        } else if (func.hasOwnProperty("name")) {
          return func.name;
        } else {
          var text = Function.prototype.toString.call(func);
          var match = /^function\s+([\w\$]+)\s*\(/.exec(text);
          return match ? match[1] : "";
        }
      }
      Debug2.getFunctionName = getFunctionName;
      function formatSymbol(symbol) {
        return "{ name: " + ts2.unescapeLeadingUnderscores(symbol.escapedName) + "; flags: " + formatSymbolFlags(symbol.flags) + "; declarations: " + ts2.map(symbol.declarations, function(node) {
          return formatSyntaxKind(node.kind);
        }) + " }";
      }
      Debug2.formatSymbol = formatSymbol;
      function formatEnum(value, enumObject, isFlags) {
        if (value === void 0) {
          value = 0;
        }
        var members = getEnumMembers(enumObject);
        if (value === 0) {
          return members.length > 0 && members[0][0] === 0 ? members[0][1] : "0";
        }
        if (isFlags) {
          var result = "";
          var remainingFlags = value;
          for (var _i = 0, members_1 = members; _i < members_1.length; _i++) {
            var _a = members_1[_i], enumValue = _a[0], enumName = _a[1];
            if (enumValue > value) {
              break;
            }
            if (enumValue !== 0 && enumValue & value) {
              result = "" + result + (result ? "|" : "") + enumName;
              remainingFlags &= ~enumValue;
            }
          }
          if (remainingFlags === 0) {
            return result;
          }
        } else {
          for (var _b = 0, members_2 = members; _b < members_2.length; _b++) {
            var _c = members_2[_b], enumValue = _c[0], enumName = _c[1];
            if (enumValue === value) {
              return enumName;
            }
          }
        }
        return value.toString();
      }
      Debug2.formatEnum = formatEnum;
      function getEnumMembers(enumObject) {
        var result = [];
        for (var name in enumObject) {
          var value = enumObject[name];
          if (typeof value === "number") {
            result.push([value, name]);
          }
        }
        return ts2.stableSort(result, function(x, y) {
          return ts2.compareValues(x[0], y[0]);
        });
      }
      function formatSyntaxKind(kind) {
        return formatEnum(kind, ts2.SyntaxKind, false);
      }
      Debug2.formatSyntaxKind = formatSyntaxKind;
      function formatNodeFlags(flags) {
        return formatEnum(flags, ts2.NodeFlags, true);
      }
      Debug2.formatNodeFlags = formatNodeFlags;
      function formatModifierFlags(flags) {
        return formatEnum(flags, ts2.ModifierFlags, true);
      }
      Debug2.formatModifierFlags = formatModifierFlags;
      function formatTransformFlags(flags) {
        return formatEnum(flags, ts2.TransformFlags, true);
      }
      Debug2.formatTransformFlags = formatTransformFlags;
      function formatEmitFlags(flags) {
        return formatEnum(flags, ts2.EmitFlags, true);
      }
      Debug2.formatEmitFlags = formatEmitFlags;
      function formatSymbolFlags(flags) {
        return formatEnum(flags, ts2.SymbolFlags, true);
      }
      Debug2.formatSymbolFlags = formatSymbolFlags;
      function formatTypeFlags(flags) {
        return formatEnum(flags, ts2.TypeFlags, true);
      }
      Debug2.formatTypeFlags = formatTypeFlags;
      function formatSignatureFlags(flags) {
        return formatEnum(flags, ts2.SignatureFlags, true);
      }
      Debug2.formatSignatureFlags = formatSignatureFlags;
      function formatObjectFlags(flags) {
        return formatEnum(flags, ts2.ObjectFlags, true);
      }
      Debug2.formatObjectFlags = formatObjectFlags;
      function formatFlowFlags(flags) {
        return formatEnum(flags, ts2.FlowFlags, true);
      }
      Debug2.formatFlowFlags = formatFlowFlags;
      var isDebugInfoEnabled = false;
      var extendedDebugModule;
      function extendedDebug() {
        enableDebugInfo();
        if (!extendedDebugModule) {
          throw new Error("Debugging helpers could not be loaded.");
        }
        return extendedDebugModule;
      }
      function printControlFlowGraph(flowNode) {
        return console.log(formatControlFlowGraph(flowNode));
      }
      Debug2.printControlFlowGraph = printControlFlowGraph;
      function formatControlFlowGraph(flowNode) {
        return extendedDebug().formatControlFlowGraph(flowNode);
      }
      Debug2.formatControlFlowGraph = formatControlFlowGraph;
      var flowNodeProto;
      function attachFlowNodeDebugInfoWorker(flowNode) {
        if (!("__debugFlowFlags" in flowNode)) {
          Object.defineProperties(flowNode, {
            __tsDebuggerDisplay: {
              value: function() {
                var flowHeader = this.flags & 2 ? "FlowStart" : this.flags & 4 ? "FlowBranchLabel" : this.flags & 8 ? "FlowLoopLabel" : this.flags & 16 ? "FlowAssignment" : this.flags & 32 ? "FlowTrueCondition" : this.flags & 64 ? "FlowFalseCondition" : this.flags & 128 ? "FlowSwitchClause" : this.flags & 256 ? "FlowArrayMutation" : this.flags & 512 ? "FlowCall" : this.flags & 1024 ? "FlowReduceLabel" : this.flags & 1 ? "FlowUnreachable" : "UnknownFlow";
                var remainingFlags = this.flags & ~(2048 - 1);
                return "" + flowHeader + (remainingFlags ? " (" + formatFlowFlags(remainingFlags) + ")" : "");
              }
            },
            __debugFlowFlags: { get: function() {
              return formatEnum(this.flags, ts2.FlowFlags, true);
            } },
            __debugToString: { value: function() {
              return formatControlFlowGraph(this);
            } }
          });
        }
      }
      function attachFlowNodeDebugInfo(flowNode) {
        if (isDebugInfoEnabled) {
          if (typeof Object.setPrototypeOf === "function") {
            if (!flowNodeProto) {
              flowNodeProto = Object.create(Object.prototype);
              attachFlowNodeDebugInfoWorker(flowNodeProto);
            }
            Object.setPrototypeOf(flowNode, flowNodeProto);
          } else {
            attachFlowNodeDebugInfoWorker(flowNode);
          }
        }
      }
      Debug2.attachFlowNodeDebugInfo = attachFlowNodeDebugInfo;
      var nodeArrayProto;
      function attachNodeArrayDebugInfoWorker(array) {
        if (!("__tsDebuggerDisplay" in array)) {
          Object.defineProperties(array, {
            __tsDebuggerDisplay: {
              value: function(defaultValue) {
                defaultValue = String(defaultValue).replace(/(?:,[\s\w\d_]+:[^,]+)+\]$/, "]");
                return "NodeArray " + defaultValue;
              }
            }
          });
        }
      }
      function attachNodeArrayDebugInfo(array) {
        if (isDebugInfoEnabled) {
          if (typeof Object.setPrototypeOf === "function") {
            if (!nodeArrayProto) {
              nodeArrayProto = Object.create(Array.prototype);
              attachNodeArrayDebugInfoWorker(nodeArrayProto);
            }
            Object.setPrototypeOf(array, nodeArrayProto);
          } else {
            attachNodeArrayDebugInfoWorker(array);
          }
        }
      }
      Debug2.attachNodeArrayDebugInfo = attachNodeArrayDebugInfo;
      function enableDebugInfo() {
        if (isDebugInfoEnabled)
          return;
        var weakTypeTextMap;
        var weakNodeTextMap;
        function getWeakTypeTextMap() {
          if (weakTypeTextMap === void 0) {
            if (typeof WeakMap === "function")
              weakTypeTextMap = new WeakMap();
          }
          return weakTypeTextMap;
        }
        function getWeakNodeTextMap() {
          if (weakNodeTextMap === void 0) {
            if (typeof WeakMap === "function")
              weakNodeTextMap = new WeakMap();
          }
          return weakNodeTextMap;
        }
        Object.defineProperties(ts2.objectAllocator.getSymbolConstructor().prototype, {
          __tsDebuggerDisplay: {
            value: function() {
              var symbolHeader = this.flags & 33554432 ? "TransientSymbol" : "Symbol";
              var remainingSymbolFlags = this.flags & ~33554432;
              return symbolHeader + " '" + ts2.symbolName(this) + "'" + (remainingSymbolFlags ? " (" + formatSymbolFlags(remainingSymbolFlags) + ")" : "");
            }
          },
          __debugFlags: { get: function() {
            return formatSymbolFlags(this.flags);
          } }
        });
        Object.defineProperties(ts2.objectAllocator.getTypeConstructor().prototype, {
          __tsDebuggerDisplay: {
            value: function() {
              var typeHeader = this.flags & 98304 ? "NullableType" : this.flags & 384 ? "LiteralType " + JSON.stringify(this.value) : this.flags & 2048 ? "LiteralType " + (this.value.negative ? "-" : "") + this.value.base10Value + "n" : this.flags & 8192 ? "UniqueESSymbolType" : this.flags & 32 ? "EnumType" : this.flags & 67359327 ? "IntrinsicType " + this.intrinsicName : this.flags & 1048576 ? "UnionType" : this.flags & 2097152 ? "IntersectionType" : this.flags & 4194304 ? "IndexType" : this.flags & 8388608 ? "IndexedAccessType" : this.flags & 16777216 ? "ConditionalType" : this.flags & 33554432 ? "SubstitutionType" : this.flags & 262144 ? "TypeParameter" : this.flags & 524288 ? this.objectFlags & 3 ? "InterfaceType" : this.objectFlags & 4 ? "TypeReference" : this.objectFlags & 8 ? "TupleType" : this.objectFlags & 16 ? "AnonymousType" : this.objectFlags & 32 ? "MappedType" : this.objectFlags & 1024 ? "ReverseMappedType" : this.objectFlags & 256 ? "EvolvingArrayType" : "ObjectType" : "Type";
              var remainingObjectFlags = this.flags & 524288 ? this.objectFlags & ~1343 : 0;
              return "" + typeHeader + (this.symbol ? " '" + ts2.symbolName(this.symbol) + "'" : "") + (remainingObjectFlags ? " (" + formatObjectFlags(remainingObjectFlags) + ")" : "");
            }
          },
          __debugFlags: { get: function() {
            return formatTypeFlags(this.flags);
          } },
          __debugObjectFlags: { get: function() {
            return this.flags & 524288 ? formatObjectFlags(this.objectFlags) : "";
          } },
          __debugTypeToString: {
            value: function() {
              var map = getWeakTypeTextMap();
              var text = map === null || map === void 0 ? void 0 : map.get(this);
              if (text === void 0) {
                text = this.checker.typeToString(this);
                map === null || map === void 0 ? void 0 : map.set(this, text);
              }
              return text;
            }
          }
        });
        Object.defineProperties(ts2.objectAllocator.getSignatureConstructor().prototype, {
          __debugFlags: { get: function() {
            return formatSignatureFlags(this.flags);
          } },
          __debugSignatureToString: { value: function() {
            var _a;
            return (_a = this.checker) === null || _a === void 0 ? void 0 : _a.signatureToString(this);
          } }
        });
        var nodeConstructors = [
          ts2.objectAllocator.getNodeConstructor(),
          ts2.objectAllocator.getIdentifierConstructor(),
          ts2.objectAllocator.getTokenConstructor(),
          ts2.objectAllocator.getSourceFileConstructor()
        ];
        for (var _i = 0, nodeConstructors_1 = nodeConstructors; _i < nodeConstructors_1.length; _i++) {
          var ctor = nodeConstructors_1[_i];
          if (!ctor.prototype.hasOwnProperty("__debugKind")) {
            Object.defineProperties(ctor.prototype, {
              __tsDebuggerDisplay: {
                value: function() {
                  var nodeHeader = ts2.isGeneratedIdentifier(this) ? "GeneratedIdentifier" : ts2.isIdentifier(this) ? "Identifier '" + ts2.idText(this) + "'" : ts2.isPrivateIdentifier(this) ? "PrivateIdentifier '" + ts2.idText(this) + "'" : ts2.isStringLiteral(this) ? "StringLiteral " + JSON.stringify(this.text.length < 10 ? this.text : this.text.slice(10) + "...") : ts2.isNumericLiteral(this) ? "NumericLiteral " + this.text : ts2.isBigIntLiteral(this) ? "BigIntLiteral " + this.text + "n" : ts2.isTypeParameterDeclaration(this) ? "TypeParameterDeclaration" : ts2.isParameter(this) ? "ParameterDeclaration" : ts2.isConstructorDeclaration(this) ? "ConstructorDeclaration" : ts2.isGetAccessorDeclaration(this) ? "GetAccessorDeclaration" : ts2.isSetAccessorDeclaration(this) ? "SetAccessorDeclaration" : ts2.isCallSignatureDeclaration(this) ? "CallSignatureDeclaration" : ts2.isConstructSignatureDeclaration(this) ? "ConstructSignatureDeclaration" : ts2.isIndexSignatureDeclaration(this) ? "IndexSignatureDeclaration" : ts2.isTypePredicateNode(this) ? "TypePredicateNode" : ts2.isTypeReferenceNode(this) ? "TypeReferenceNode" : ts2.isFunctionTypeNode(this) ? "FunctionTypeNode" : ts2.isConstructorTypeNode(this) ? "ConstructorTypeNode" : ts2.isTypeQueryNode(this) ? "TypeQueryNode" : ts2.isTypeLiteralNode(this) ? "TypeLiteralNode" : ts2.isArrayTypeNode(this) ? "ArrayTypeNode" : ts2.isTupleTypeNode(this) ? "TupleTypeNode" : ts2.isOptionalTypeNode(this) ? "OptionalTypeNode" : ts2.isRestTypeNode(this) ? "RestTypeNode" : ts2.isUnionTypeNode(this) ? "UnionTypeNode" : ts2.isIntersectionTypeNode(this) ? "IntersectionTypeNode" : ts2.isConditionalTypeNode(this) ? "ConditionalTypeNode" : ts2.isInferTypeNode(this) ? "InferTypeNode" : ts2.isParenthesizedTypeNode(this) ? "ParenthesizedTypeNode" : ts2.isThisTypeNode(this) ? "ThisTypeNode" : ts2.isTypeOperatorNode(this) ? "TypeOperatorNode" : ts2.isIndexedAccessTypeNode(this) ? "IndexedAccessTypeNode" : ts2.isMappedTypeNode(this) ? "MappedTypeNode" : ts2.isLiteralTypeNode(this) ? "LiteralTypeNode" : ts2.isNamedTupleMember(this) ? "NamedTupleMember" : ts2.isImportTypeNode(this) ? "ImportTypeNode" : formatSyntaxKind(this.kind);
                  return "" + nodeHeader + (this.flags ? " (" + formatNodeFlags(this.flags) + ")" : "");
                }
              },
              __debugKind: { get: function() {
                return formatSyntaxKind(this.kind);
              } },
              __debugNodeFlags: { get: function() {
                return formatNodeFlags(this.flags);
              } },
              __debugModifierFlags: { get: function() {
                return formatModifierFlags(ts2.getEffectiveModifierFlagsNoCache(this));
              } },
              __debugTransformFlags: { get: function() {
                return formatTransformFlags(this.transformFlags);
              } },
              __debugIsParseTreeNode: { get: function() {
                return ts2.isParseTreeNode(this);
              } },
              __debugEmitFlags: { get: function() {
                return formatEmitFlags(ts2.getEmitFlags(this));
              } },
              __debugGetText: {
                value: function(includeTrivia) {
                  if (ts2.nodeIsSynthesized(this))
                    return "";
                  var map = getWeakNodeTextMap();
                  var text = map === null || map === void 0 ? void 0 : map.get(this);
                  if (text === void 0) {
                    var parseNode = ts2.getParseTreeNode(this);
                    var sourceFile = parseNode && ts2.getSourceFileOfNode(parseNode);
                    text = sourceFile ? ts2.getSourceTextOfNodeFromSourceFile(sourceFile, parseNode, includeTrivia) : "";
                    map === null || map === void 0 ? void 0 : map.set(this, text);
                  }
                  return text;
                }
              }
            });
          }
        }
        try {
          if (ts2.sys && ts2.sys.require) {
            var basePath = ts2.getDirectoryPath(ts2.resolvePath(ts2.sys.getExecutingFilePath()));
            var result = void 0;
            if (!result.error) {
              result.module.init(ts2);
              extendedDebugModule = result.module;
            }
          }
        } catch (_a) {
        }
        isDebugInfoEnabled = true;
      }
      Debug2.enableDebugInfo = enableDebugInfo;
      function formatDeprecationMessage(name, error, errorAfter, since, message) {
        var deprecationMessage = error ? "DeprecationError: " : "DeprecationWarning: ";
        deprecationMessage += "'" + name + "' ";
        deprecationMessage += since ? "has been deprecated since v" + since : "is deprecated";
        deprecationMessage += error ? " and can no longer be used." : errorAfter ? " and will no longer be usable after v" + errorAfter + "." : ".";
        deprecationMessage += message ? " " + ts2.formatStringFromArgs(message, [name], 0) : "";
        return deprecationMessage;
      }
      function createErrorDeprecation(name, errorAfter, since, message) {
        var deprecationMessage = formatDeprecationMessage(name, true, errorAfter, since, message);
        return function() {
          throw new TypeError(deprecationMessage);
        };
      }
      function createWarningDeprecation(name, errorAfter, since, message) {
        var hasWrittenDeprecation = false;
        return function() {
          if (!hasWrittenDeprecation) {
            log.warn(formatDeprecationMessage(name, false, errorAfter, since, message));
            hasWrittenDeprecation = true;
          }
        };
      }
      function createDeprecation(name, options) {
        var _a, _b;
        if (options === void 0) {
          options = {};
        }
        var version = typeof options.typeScriptVersion === "string" ? new ts2.Version(options.typeScriptVersion) : (_a = options.typeScriptVersion) !== null && _a !== void 0 ? _a : getTypeScriptVersion();
        var errorAfter = typeof options.errorAfter === "string" ? new ts2.Version(options.errorAfter) : options.errorAfter;
        var warnAfter = typeof options.warnAfter === "string" ? new ts2.Version(options.warnAfter) : options.warnAfter;
        var since = typeof options.since === "string" ? new ts2.Version(options.since) : (_b = options.since) !== null && _b !== void 0 ? _b : warnAfter;
        var error = options.error || errorAfter && version.compareTo(errorAfter) <= 0;
        var warn = !warnAfter || version.compareTo(warnAfter) >= 0;
        return error ? createErrorDeprecation(name, errorAfter, since, options.message) : warn ? createWarningDeprecation(name, errorAfter, since, options.message) : ts2.noop;
      }
      function wrapFunction(deprecation, func) {
        return function() {
          deprecation();
          return func.apply(this, arguments);
        };
      }
      function deprecate(func, options) {
        var deprecation = createDeprecation(getFunctionName(func), options);
        return wrapFunction(deprecation, func);
      }
      Debug2.deprecate = deprecate;
    })(Debug = ts2.Debug || (ts2.Debug = {}));
  })(ts || (ts = {}));
  var ts;
  (function(ts2) {
    var versionRegExp = /^(0|[1-9]\d*)(?:\.(0|[1-9]\d*)(?:\.(0|[1-9]\d*)(?:\-([a-z0-9-.]+))?(?:\+([a-z0-9-.]+))?)?)?$/i;
    var prereleaseRegExp = /^(?:0|[1-9]\d*|[a-z-][a-z0-9-]*)(?:\.(?:0|[1-9]\d*|[a-z-][a-z0-9-]*))*$/i;
    var buildRegExp = /^[a-z0-9-]+(?:\.[a-z0-9-]+)*$/i;
    var numericIdentifierRegExp = /^(0|[1-9]\d*)$/;
    var Version = function() {
      function Version2(major, minor, patch, prerelease, build) {
        if (minor === void 0) {
          minor = 0;
        }
        if (patch === void 0) {
          patch = 0;
        }
        if (prerelease === void 0) {
          prerelease = "";
        }
        if (build === void 0) {
          build = "";
        }
        if (typeof major === "string") {
          var result = ts2.Debug.checkDefined(tryParseComponents(major), "Invalid version");
          major = result.major, minor = result.minor, patch = result.patch, prerelease = result.prerelease, build = result.build;
        }
        ts2.Debug.assert(major >= 0, "Invalid argument: major");
        ts2.Debug.assert(minor >= 0, "Invalid argument: minor");
        ts2.Debug.assert(patch >= 0, "Invalid argument: patch");
        ts2.Debug.assert(!prerelease || prereleaseRegExp.test(prerelease), "Invalid argument: prerelease");
        ts2.Debug.assert(!build || buildRegExp.test(build), "Invalid argument: build");
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.prerelease = prerelease ? prerelease.split(".") : ts2.emptyArray;
        this.build = build ? build.split(".") : ts2.emptyArray;
      }
      Version2.tryParse = function(text) {
        var result = tryParseComponents(text);
        if (!result)
          return void 0;
        var major = result.major, minor = result.minor, patch = result.patch, prerelease = result.prerelease, build = result.build;
        return new Version2(major, minor, patch, prerelease, build);
      };
      Version2.prototype.compareTo = function(other) {
        if (this === other)
          return 0;
        if (other === void 0)
          return 1;
        return ts2.compareValues(this.major, other.major) || ts2.compareValues(this.minor, other.minor) || ts2.compareValues(this.patch, other.patch) || comparePrereleaseIdentifiers(this.prerelease, other.prerelease);
      };
      Version2.prototype.increment = function(field) {
        switch (field) {
          case "major":
            return new Version2(this.major + 1, 0, 0);
          case "minor":
            return new Version2(this.major, this.minor + 1, 0);
          case "patch":
            return new Version2(this.major, this.minor, this.patch + 1);
          default:
            return ts2.Debug.assertNever(field);
        }
      };
      Version2.prototype.toString = function() {
        var result = this.major + "." + this.minor + "." + this.patch;
        if (ts2.some(this.prerelease))
          result += "-" + this.prerelease.join(".");
        if (ts2.some(this.build))
          result += "+" + this.build.join(".");
        return result;
      };
      Version2.zero = new Version2(0, 0, 0);
      return Version2;
    }();
    ts2.Version = Version;
    function tryParseComponents(text) {
      var match = versionRegExp.exec(text);
      if (!match)
        return void 0;
      var major = match[1], _a = match[2], minor = _a === void 0 ? "0" : _a, _b = match[3], patch = _b === void 0 ? "0" : _b, _c = match[4], prerelease = _c === void 0 ? "" : _c, _d = match[5], build = _d === void 0 ? "" : _d;
      if (prerelease && !prereleaseRegExp.test(prerelease))
        return void 0;
      if (build && !buildRegExp.test(build))
        return void 0;
      return {
        major: parseInt(major, 10),
        minor: parseInt(minor, 10),
        patch: parseInt(patch, 10),
        prerelease,
        build
      };
    }
    function comparePrereleaseIdentifiers(left, right) {
      if (left === right)
        return 0;
      if (left.length === 0)
        return right.length === 0 ? 0 : 1;
      if (right.length === 0)
        return -1;
      var length = Math.min(left.length, right.length);
      for (var i = 0; i < length; i++) {
        var leftIdentifier = left[i];
        var rightIdentifier = right[i];
        if (leftIdentifier === rightIdentifier)
          continue;
        var leftIsNumeric = numericIdentifierRegExp.test(leftIdentifier);
        var rightIsNumeric = numericIdentifierRegExp.test(rightIdentifier);
        if (leftIsNumeric || rightIsNumeric) {
          if (leftIsNumeric !== rightIsNumeric)
            return leftIsNumeric ? -1 : 1;
          var result = ts2.compareValues(+leftIdentifier, +rightIdentifier);
          if (result)
            return result;
        } else {
          var result = ts2.compareStringsCaseSensitive(leftIdentifier, rightIdentifier);
          if (result)
            return result;
        }
      }
      return ts2.compareValues(left.length, right.length);
    }
    var VersionRange = function() {
      function VersionRange2(spec) {
        this._alternatives = spec ? ts2.Debug.checkDefined(parseRange(spec), "Invalid range spec.") : ts2.emptyArray;
      }
      VersionRange2.tryParse = function(text) {
        var sets = parseRange(text);
        if (sets) {
          var range = new VersionRange2("");
          range._alternatives = sets;
          return range;
        }
        return void 0;
      };
      VersionRange2.prototype.test = function(version) {
        if (typeof version === "string")
          version = new Version(version);
        return testDisjunction(version, this._alternatives);
      };
      VersionRange2.prototype.toString = function() {
        return formatDisjunction(this._alternatives);
      };
      return VersionRange2;
    }();
    ts2.VersionRange = VersionRange;
    var logicalOrRegExp = /\|\|/g;
    var whitespaceRegExp = /\s+/g;
    var partialRegExp = /^([xX*0]|[1-9]\d*)(?:\.([xX*0]|[1-9]\d*)(?:\.([xX*0]|[1-9]\d*)(?:-([a-z0-9-.]+))?(?:\+([a-z0-9-.]+))?)?)?$/i;
    var hyphenRegExp = /^\s*([a-z0-9-+.*]+)\s+-\s+([a-z0-9-+.*]+)\s*$/i;
    var rangeRegExp = /^(~|\^|<|<=|>|>=|=)?\s*([a-z0-9-+.*]+)$/i;
    function parseRange(text) {
      var alternatives = [];
      for (var _i = 0, _a = ts2.trimString(text).split(logicalOrRegExp); _i < _a.length; _i++) {
        var range = _a[_i];
        if (!range)
          continue;
        var comparators = [];
        range = ts2.trimString(range);
        var match = hyphenRegExp.exec(range);
        if (match) {
          if (!parseHyphen(match[1], match[2], comparators))
            return void 0;
        } else {
          for (var _b = 0, _c = range.split(whitespaceRegExp); _b < _c.length; _b++) {
            var simple = _c[_b];
            var match_1 = rangeRegExp.exec(ts2.trimString(simple));
            if (!match_1 || !parseComparator(match_1[1], match_1[2], comparators))
              return void 0;
          }
        }
        alternatives.push(comparators);
      }
      return alternatives;
    }
    function parsePartial(text) {
      var match = partialRegExp.exec(text);
      if (!match)
        return void 0;
      var major = match[1], _a = match[2], minor = _a === void 0 ? "*" : _a, _b = match[3], patch = _b === void 0 ? "*" : _b, prerelease = match[4], build = match[5];
      var version = new Version(isWildcard(major) ? 0 : parseInt(major, 10), isWildcard(major) || isWildcard(minor) ? 0 : parseInt(minor, 10), isWildcard(major) || isWildcard(minor) || isWildcard(patch) ? 0 : parseInt(patch, 10), prerelease, build);
      return { version, major, minor, patch };
    }
    function parseHyphen(left, right, comparators) {
      var leftResult = parsePartial(left);
      if (!leftResult)
        return false;
      var rightResult = parsePartial(right);
      if (!rightResult)
        return false;
      if (!isWildcard(leftResult.major)) {
        comparators.push(createComparator(">=", leftResult.version));
      }
      if (!isWildcard(rightResult.major)) {
        comparators.push(isWildcard(rightResult.minor) ? createComparator("<", rightResult.version.increment("major")) : isWildcard(rightResult.patch) ? createComparator("<", rightResult.version.increment("minor")) : createComparator("<=", rightResult.version));
      }
      return true;
    }
    function parseComparator(operator, text, comparators) {
      var result = parsePartial(text);
      if (!result)
        return false;
      var version = result.version, major = result.major, minor = result.minor, patch = result.patch;
      if (!isWildcard(major)) {
        switch (operator) {
          case "~":
            comparators.push(createComparator(">=", version));
            comparators.push(createComparator("<", version.increment(isWildcard(minor) ? "major" : "minor")));
            break;
          case "^":
            comparators.push(createComparator(">=", version));
            comparators.push(createComparator("<", version.increment(version.major > 0 || isWildcard(minor) ? "major" : version.minor > 0 || isWildcard(patch) ? "minor" : "patch")));
            break;
          case "<":
          case ">=":
            comparators.push(createComparator(operator, version));
            break;
          case "<=":
          case ">":
            comparators.push(isWildcard(minor) ? createComparator(operator === "<=" ? "<" : ">=", version.increment("major")) : isWildcard(patch) ? createComparator(operator === "<=" ? "<" : ">=", version.increment("minor")) : createComparator(operator, version));
            break;
          case "=":
          case void 0:
            if (isWildcard(minor) || isWildcard(patch)) {
              comparators.push(createComparator(">=", version));
              comparators.push(createComparator("<", version.increment(isWildcard(minor) ? "major" : "minor")));
            } else {
              comparators.push(createComparator("=", version));
            }
            break;
          default:
            return false;
        }
      } else if (operator === "<" || operator === ">") {
        comparators.push(createComparator("<", Version.zero));
      }
      return true;
    }
    function isWildcard(part) {
      return part === "*" || part === "x" || part === "X";
    }
    function createComparator(operator, operand) {
      return { operator, operand };
    }
    function testDisjunction(version, alternatives) {
      if (alternatives.length === 0)
        return true;
      for (var _i = 0, alternatives_1 = alternatives; _i < alternatives_1.length; _i++) {
        var alternative = alternatives_1[_i];
        if (testAlternative(version, alternative))
          return true;
      }
      return false;
    }
    function testAlternative(version, comparators) {
      for (var _i = 0, comparators_1 = comparators; _i < comparators_1.length; _i++) {
        var comparator = comparators_1[_i];
        if (!testComparator(version, comparator.operator, comparator.operand))
          return false;
      }
      return true;
    }
    function testComparator(version, operator, operand) {
      var cmp = version.compareTo(operand);
      switch (operator) {
        case "<":
          return cmp < 0;
        case "<=":
          return cmp <= 0;
        case ">":
          return cmp > 0;
        case ">=":
          return cmp >= 0;
        case "=":
          return cmp === 0;
        default:
          return ts2.Debug.assertNever(operator);
      }
    }
    function formatDisjunction(alternatives) {
      return ts2.map(alternatives, formatAlternative).join(" || ") || "*";
    }
    function formatAlternative(comparators) {
      return ts2.map(comparators, formatComparator).join(" ");
    }
    function formatComparator(comparator) {
      return "" + comparator.operator + comparator.operand;
    }
  })(ts || (ts = {}));
  var ts;
  (function(ts2) {
    function hasRequiredAPI(performance2, PerformanceObserver2) {
      return typeof performance2 === "object" && typeof performance2.timeOrigin === "number" && typeof performance2.mark === "function" && typeof performance2.measure === "function" && typeof performance2.now === "function" && typeof PerformanceObserver2 === "function";
    }
    function tryGetWebPerformanceHooks() {
      if (typeof performance === "object" && typeof PerformanceObserver === "function" && hasRequiredAPI(performance, PerformanceObserver)) {
        return {
          shouldWriteNativeEvents: true,
          performance,
          PerformanceObserver
        };
      }
    }
    function tryGetNodePerformanceHooks() {
      if (typeof process !== "undefined" && process.nextTick && !process.browser && typeof module === "object" && false) {
        try {
          var performance_1;
          var _a = {}, nodePerformance_1 = _a.performance, PerformanceObserver_1 = _a.PerformanceObserver;
          if (hasRequiredAPI(nodePerformance_1, PerformanceObserver_1)) {
            performance_1 = nodePerformance_1;
            var version_1 = new ts2.Version(process.versions.node);
            var range = new ts2.VersionRange("<12.16.3 || 13 <13.13");
            if (range.test(version_1)) {
              performance_1 = {
                get timeOrigin() {
                  return nodePerformance_1.timeOrigin;
                },
                now: function() {
                  return nodePerformance_1.now();
                },
                mark: function(name) {
                  return nodePerformance_1.mark(name);
                },
                measure: function(name, start, end) {
                  if (start === void 0) {
                    start = "nodeStart";
                  }
                  if (end === void 0) {
                    end = "__performance.measure-fix__";
                    nodePerformance_1.mark(end);
                  }
                  nodePerformance_1.measure(name, start, end);
                  if (end === "__performance.measure-fix__") {
                    nodePerformance_1.clearMarks("__performance.measure-fix__");
                  }
                }
              };
            }
            return {
              shouldWriteNativeEvents: false,
              performance: performance_1,
              PerformanceObserver: PerformanceObserver_1
            };
          }
        } catch (_b) {
        }
      }
    }
    var nativePerformanceHooks = tryGetWebPerformanceHooks() || tryGetNodePerformanceHooks();
    var nativePerformance = nativePerformanceHooks === null || nativePerformanceHooks === void 0 ? void 0 : nativePerformanceHooks.performance;
    function tryGetNativePerformanceHooks() {
      return nativePerformanceHooks;
    }
    ts2.tryGetNativePerformanceHooks = tryGetNativePerformanceHooks;
    ts2.timestamp = nativePerformance ? function() {
      return nativePerformance.now();
    } : Date.now ? Date.now : function() {
      return +new Date();
    };
  })(ts || (ts = {}));
  var ts;
  (function(ts2) {
    var performance2;
    (function(performance3) {
      var perfHooks;
      var performanceImpl;
      function createTimerIf(condition, measureName, startMarkName, endMarkName) {
        return condition ? createTimer(measureName, startMarkName, endMarkName) : performance3.nullTimer;
      }
      performance3.createTimerIf = createTimerIf;
      function createTimer(measureName, startMarkName, endMarkName) {
        var enterCount = 0;
        return {
          enter,
          exit
        };
        function enter() {
          if (++enterCount === 1) {
            mark(startMarkName);
          }
        }
        function exit() {
          if (--enterCount === 0) {
            mark(endMarkName);
            measure(measureName, startMarkName, endMarkName);
          } else if (enterCount < 0) {
            ts2.Debug.fail("enter/exit count does not match.");
          }
        }
      }
      performance3.createTimer = createTimer;
      performance3.nullTimer = { enter: ts2.noop, exit: ts2.noop };
      var enabled = false;
      var timeorigin = ts2.timestamp();
      var marks = new ts2.Map();
      var counts = new ts2.Map();
      var durations = new ts2.Map();
      function mark(markName) {
        var _a;
        if (enabled) {
          var count = (_a = counts.get(markName)) !== null && _a !== void 0 ? _a : 0;
          counts.set(markName, count + 1);
          marks.set(markName, ts2.timestamp());
          performanceImpl === null || performanceImpl === void 0 ? void 0 : performanceImpl.mark(markName);
        }
      }
      performance3.mark = mark;
      function measure(measureName, startMarkName, endMarkName) {
        var _a, _b;
        if (enabled) {
          var end = (_a = endMarkName !== void 0 ? marks.get(endMarkName) : void 0) !== null && _a !== void 0 ? _a : ts2.timestamp();
          var start = (_b = startMarkName !== void 0 ? marks.get(startMarkName) : void 0) !== null && _b !== void 0 ? _b : timeorigin;
          var previousDuration = durations.get(measureName) || 0;
          durations.set(measureName, previousDuration + (end - start));
          performanceImpl === null || performanceImpl === void 0 ? void 0 : performanceImpl.measure(measureName, startMarkName, endMarkName);
        }
      }
      performance3.measure = measure;
      function getCount(markName) {
        return counts.get(markName) || 0;
      }
      performance3.getCount = getCount;
      function getDuration(measureName) {
        return durations.get(measureName) || 0;
      }
      performance3.getDuration = getDuration;
      function forEachMeasure(cb) {
        durations.forEach(function(duration, measureName) {
          return cb(measureName, duration);
        });
      }
      performance3.forEachMeasure = forEachMeasure;
      function isEnabled() {
        return enabled;
      }
      performance3.isEnabled = isEnabled;
      function enable(system) {
        var _a;
        if (system === void 0) {
          system = ts2.sys;
        }
        if (!enabled) {
          enabled = true;
          perfHooks || (perfHooks = ts2.tryGetNativePerformanceHooks());
          if (perfHooks) {
            timeorigin = perfHooks.performance.timeOrigin;
            if (perfHooks.shouldWriteNativeEvents || ((_a = system === null || system === void 0 ? void 0 : system.cpuProfilingEnabled) === null || _a === void 0 ? void 0 : _a.call(system)) || (system === null || system === void 0 ? void 0 : system.debugMode)) {
              performanceImpl = perfHooks.performance;
            }
          }
        }
        return true;
      }
      performance3.enable = enable;
      function disable() {
        if (enabled) {
          marks.clear();
          counts.clear();
          durations.clear();
          performanceImpl = void 0;
          enabled = false;
        }
      }
      performance3.disable = disable;
    })(performance2 = ts2.performance || (ts2.performance = {}));
  })(ts || (ts = {}));
  var ts;
  (function(ts2) {
    var _a;
    var nullLogger = {
      logEvent: ts2.noop,
      logErrEvent: ts2.noop,
      logPerfEvent: ts2.noop,
      logInfoEvent: ts2.noop,
      logStartCommand: ts2.noop,
      logStopCommand: ts2.noop,
      logStartUpdateProgram: ts2.noop,
      logStopUpdateProgram: ts2.noop,
      logStartUpdateGraph: ts2.noop,
      logStopUpdateGraph: ts2.noop,
      logStartResolveModule: ts2.noop,
      logStopResolveModule: ts2.noop,
      logStartParseSourceFile: ts2.noop,
      logStopParseSourceFile: ts2.noop,
      logStartReadFile: ts2.noop,
      logStopReadFile: ts2.noop,
      logStartBindFile: ts2.noop,
      logStopBindFile: ts2.noop,
      logStartScheduledOperation: ts2.noop,
      logStopScheduledOperation: ts2.noop
    };
    var etwModule;
    try {
      var etwModulePath = (_a = process.env.TS_ETW_MODULE_PATH) !== null && _a !== void 0 ? _a : "./node_modules/@microsoft/typescript-etw";
      etwModule = void 0;
    } catch (e) {
      etwModule = void 0;
    }
    ts2.perfLogger = etwModule && etwModule.logEvent ? etwModule : nullLogger;
  })(ts || (ts = {}));
  var ts;
  (function(ts2) {
    var tracingEnabled;
    (function(tracingEnabled2) {
      var fs;
      var traceCount = 0;
      var traceFd = 0;
      var mode;
      var typeCatalog = [];
      var legendPath;
      var legend = [];
      ;
      function startTracing(tracingMode, traceDir, configFilePath) {
        ts2.Debug.assert(!ts2.tracing, "Tracing already started");
        if (fs === void 0) {
          try {
            fs = void 0;
          } catch (e) {
            throw new Error("tracing requires having fs\n(original error: " + (e.message || e) + ")");
          }
        }
        mode = tracingMode;
        typeCatalog.length = 0;
        if (legendPath === void 0) {
          legendPath = ts2.combinePaths(traceDir, "legend.json");
        }
        if (!fs.existsSync(traceDir)) {
          fs.mkdirSync(traceDir, { recursive: true });
        }
        var countPart = mode === "build" ? "." + process.pid + "-" + ++traceCount : mode === "server" ? "." + process.pid : "";
        var tracePath = ts2.combinePaths(traceDir, "trace" + countPart + ".json");
        var typesPath = ts2.combinePaths(traceDir, "types" + countPart + ".json");
        legend.push({
          configFilePath,
          tracePath,
          typesPath
        });
        traceFd = fs.openSync(tracePath, "w");
        ts2.tracing = tracingEnabled2;
        var meta = { cat: "__metadata", ph: "M", ts: 1e3 * ts2.timestamp(), pid: 1, tid: 1 };
        fs.writeSync(traceFd, "[\n" + [__assign({ name: "process_name", args: { name: "tsc" } }, meta), __assign({ name: "thread_name", args: { name: "Main" } }, meta), __assign(__assign({ name: "TracingStartedInBrowser" }, meta), { cat: "disabled-by-default-devtools.timeline" })].map(function(v) {
          return JSON.stringify(v);
        }).join(",\n"));
      }
      tracingEnabled2.startTracing = startTracing;
      function stopTracing() {
        ts2.Debug.assert(ts2.tracing, "Tracing is not in progress");
        ts2.Debug.assert(!!typeCatalog.length === (mode !== "server"));
        fs.writeSync(traceFd, "\n]\n");
        fs.closeSync(traceFd);
        ts2.tracing = void 0;
        if (typeCatalog.length) {
          dumpTypes(typeCatalog);
        } else {
          legend[legend.length - 1].typesPath = void 0;
        }
      }
      tracingEnabled2.stopTracing = stopTracing;
      function recordType(type) {
        if (mode !== "server") {
          typeCatalog.push(type);
        }
      }
      tracingEnabled2.recordType = recordType;
      var Phase;
      (function(Phase2) {
        Phase2["Parse"] = "parse";
        Phase2["Program"] = "program";
        Phase2["Bind"] = "bind";
        Phase2["Check"] = "check";
        Phase2["CheckTypes"] = "checkTypes";
        Phase2["Emit"] = "emit";
        Phase2["Session"] = "session";
      })(Phase = tracingEnabled2.Phase || (tracingEnabled2.Phase = {}));
      function instant(phase, name, args) {
        writeEvent("I", phase, name, args, '"s":"g"');
      }
      tracingEnabled2.instant = instant;
      var eventStack = [];
      function push(phase, name, args, separateBeginAndEnd) {
        if (separateBeginAndEnd === void 0) {
          separateBeginAndEnd = false;
        }
        if (separateBeginAndEnd) {
          writeEvent("B", phase, name, args);
        }
        eventStack.push({ phase, name, args, time: 1e3 * ts2.timestamp(), separateBeginAndEnd });
      }
      tracingEnabled2.push = push;
      function pop() {
        ts2.Debug.assert(eventStack.length > 0);
        writeStackEvent(eventStack.length - 1, 1e3 * ts2.timestamp());
        eventStack.length--;
      }
      tracingEnabled2.pop = pop;
      function popAll() {
        var endTime = 1e3 * ts2.timestamp();
        for (var i = eventStack.length - 1; i >= 0; i--) {
          writeStackEvent(i, endTime);
        }
        eventStack.length = 0;
      }
      tracingEnabled2.popAll = popAll;
      var sampleInterval = 1e3 * 10;
      function writeStackEvent(index, endTime) {
        var _a = eventStack[index], phase = _a.phase, name = _a.name, args = _a.args, time = _a.time, separateBeginAndEnd = _a.separateBeginAndEnd;
        if (separateBeginAndEnd) {
          writeEvent("E", phase, name, args, void 0, endTime);
        } else if (sampleInterval - time % sampleInterval <= endTime - time) {
          writeEvent("X", phase, name, args, '"dur":' + (endTime - time), time);
        }
      }
      function writeEvent(eventType, phase, name, args, extras, time) {
        if (time === void 0) {
          time = 1e3 * ts2.timestamp();
        }
        if (mode === "server" && phase === "checkTypes")
          return;
        ts2.performance.mark("beginTracing");
        fs.writeSync(traceFd, ',\n{"pid":1,"tid":1,"ph":"' + eventType + '","cat":"' + phase + '","ts":' + time + ',"name":"' + name + '"');
        if (extras)
          fs.writeSync(traceFd, "," + extras);
        if (args)
          fs.writeSync(traceFd, ',"args":' + JSON.stringify(args));
        fs.writeSync(traceFd, "}");
        ts2.performance.mark("endTracing");
        ts2.performance.measure("Tracing", "beginTracing", "endTracing");
      }
      function getLocation(node) {
        var file = ts2.getSourceFileOfNode(node);
        return !file ? void 0 : {
          path: file.path,
          start: indexFromOne(ts2.getLineAndCharacterOfPosition(file, node.pos)),
          end: indexFromOne(ts2.getLineAndCharacterOfPosition(file, node.end))
        };
        function indexFromOne(lc) {
          return {
            line: lc.line + 1,
            character: lc.character + 1
          };
        }
      }
      function dumpTypes(types) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x;
        ts2.performance.mark("beginDumpTypes");
        var typesPath = legend[legend.length - 1].typesPath;
        var typesFd = fs.openSync(typesPath, "w");
        var recursionIdentityMap = new ts2.Map();
        fs.writeSync(typesFd, "[");
        var numTypes = types.length;
        for (var i = 0; i < numTypes; i++) {
          var type = types[i];
          var objectFlags = type.objectFlags;
          var symbol = (_a = type.aliasSymbol) !== null && _a !== void 0 ? _a : type.symbol;
          var display = void 0;
          if (objectFlags & 16 | type.flags & 2944) {
            try {
              display = (_b = type.checker) === null || _b === void 0 ? void 0 : _b.typeToString(type);
            } catch (_y) {
              display = void 0;
            }
          }
          var indexedAccessProperties = {};
          if (type.flags & 8388608) {
            var indexedAccessType = type;
            indexedAccessProperties = {
              indexedAccessObjectType: (_c = indexedAccessType.objectType) === null || _c === void 0 ? void 0 : _c.id,
              indexedAccessIndexType: (_d = indexedAccessType.indexType) === null || _d === void 0 ? void 0 : _d.id
            };
          }
          var referenceProperties = {};
          if (objectFlags & 4) {
            var referenceType = type;
            referenceProperties = {
              instantiatedType: (_e = referenceType.target) === null || _e === void 0 ? void 0 : _e.id,
              typeArguments: (_f = referenceType.resolvedTypeArguments) === null || _f === void 0 ? void 0 : _f.map(function(t) {
                return t.id;
              }),
              referenceLocation: getLocation(referenceType.node)
            };
          }
          var conditionalProperties = {};
          if (type.flags & 16777216) {
            var conditionalType = type;
            conditionalProperties = {
              conditionalCheckType: (_g = conditionalType.checkType) === null || _g === void 0 ? void 0 : _g.id,
              conditionalExtendsType: (_h = conditionalType.extendsType) === null || _h === void 0 ? void 0 : _h.id,
              conditionalTrueType: (_k = (_j = conditionalType.resolvedTrueType) === null || _j === void 0 ? void 0 : _j.id) !== null && _k !== void 0 ? _k : -1,
              conditionalFalseType: (_m = (_l = conditionalType.resolvedFalseType) === null || _l === void 0 ? void 0 : _l.id) !== null && _m !== void 0 ? _m : -1
            };
          }
          var substitutionProperties = {};
          if (type.flags & 33554432) {
            var substitutionType = type;
            substitutionProperties = {
              substitutionBaseType: (_o = substitutionType.baseType) === null || _o === void 0 ? void 0 : _o.id,
              substituteType: (_p = substitutionType.substitute) === null || _p === void 0 ? void 0 : _p.id
            };
          }
          var reverseMappedProperties = {};
          if (objectFlags & 1024) {
            var reverseMappedType = type;
            reverseMappedProperties = {
              reverseMappedSourceType: (_q = reverseMappedType.source) === null || _q === void 0 ? void 0 : _q.id,
              reverseMappedMappedType: (_r = reverseMappedType.mappedType) === null || _r === void 0 ? void 0 : _r.id,
              reverseMappedConstraintType: (_s = reverseMappedType.constraintType) === null || _s === void 0 ? void 0 : _s.id
            };
          }
          var evolvingArrayProperties = {};
          if (objectFlags & 256) {
            var evolvingArrayType = type;
            evolvingArrayProperties = {
              evolvingArrayElementType: evolvingArrayType.elementType.id,
              evolvingArrayFinalType: (_t = evolvingArrayType.finalArrayType) === null || _t === void 0 ? void 0 : _t.id
            };
          }
          var recursionToken = void 0;
          var recursionIdentity = type.checker.getRecursionIdentity(type);
          if (recursionIdentity) {
            recursionToken = recursionIdentityMap.get(recursionIdentity);
            if (!recursionToken) {
              recursionToken = recursionIdentityMap.size;
              recursionIdentityMap.set(recursionIdentity, recursionToken);
            }
          }
          var descriptor = __assign(__assign(__assign(__assign(__assign(__assign(__assign({ id: type.id, intrinsicName: type.intrinsicName, symbolName: (symbol === null || symbol === void 0 ? void 0 : symbol.escapedName) && ts2.unescapeLeadingUnderscores(symbol.escapedName), recursionId: recursionToken, isTuple: objectFlags & 8 ? true : void 0, unionTypes: type.flags & 1048576 ? (_u = type.types) === null || _u === void 0 ? void 0 : _u.map(function(t) {
            return t.id;
          }) : void 0, intersectionTypes: type.flags & 2097152 ? type.types.map(function(t) {
            return t.id;
          }) : void 0, aliasTypeArguments: (_v = type.aliasTypeArguments) === null || _v === void 0 ? void 0 : _v.map(function(t) {
            return t.id;
          }), keyofType: type.flags & 4194304 ? (_w = type.type) === null || _w === void 0 ? void 0 : _w.id : void 0 }, indexedAccessProperties), referenceProperties), conditionalProperties), substitutionProperties), reverseMappedProperties), evolvingArrayProperties), { destructuringPattern: getLocation(type.pattern), firstDeclaration: getLocation((_x = symbol === null || symbol === void 0 ? void 0 : symbol.declarations) === null || _x === void 0 ? void 0 : _x[0]), flags: ts2.Debug.formatTypeFlags(type.flags).split("|"), display });
          fs.writeSync(typesFd, JSON.stringify(descriptor));
          if (i < numTypes - 1) {
            fs.writeSync(typesFd, ",\n");
          }
        }
        fs.writeSync(typesFd, "]\n");
        fs.closeSync(typesFd);
        ts2.performance.mark("endDumpTypes");
        ts2.performance.measure("Dump types", "beginDumpTypes", "endDumpTypes");
      }
      function dumpLegend() {
        if (!legendPath) {
          return;
        }
        fs.writeFileSync(legendPath, JSON.stringify(legend));
      }
      tracingEnabled2.dumpLegend = dumpLegend;
    })(tracingEnabled || (tracingEnabled = {}));
    ts2.startTracing = tracingEnabled.startTracing;
    ts2.dumpTracingLegend = tracingEnabled.dumpLegend;
  })(ts || (ts = {}));
  var ts;
  (function(ts2) {
    var SyntaxKind;
    (function(SyntaxKind2) {
      SyntaxKind2[SyntaxKind2["Unknown"] = 0] = "Unknown";
      SyntaxKind2[SyntaxKind2["EndOfFileToken"] = 1] = "EndOfFileToken";
      SyntaxKind2[SyntaxKind2["SingleLineCommentTrivia"] = 2] = "SingleLineCommentTrivia";
      SyntaxKind2[SyntaxKind2["MultiLineCommentTrivia"] = 3] = "MultiLineCommentTrivia";
      SyntaxKind2[SyntaxKind2["NewLineTrivia"] = 4] = "NewLineTrivia";
      SyntaxKind2[SyntaxKind2["WhitespaceTrivia"] = 5] = "WhitespaceTrivia";
      SyntaxKind2[SyntaxKind2["ShebangTrivia"] = 6] = "ShebangTrivia";
      SyntaxKind2[SyntaxKind2["ConflictMarkerTrivia"] = 7] = "ConflictMarkerTrivia";
      SyntaxKind2[SyntaxKind2["NumericLiteral"] = 8] = "NumericLiteral";
      SyntaxKind2[SyntaxKind2["BigIntLiteral"] = 9] = "BigIntLiteral";
      SyntaxKind2[SyntaxKind2["StringLiteral"] = 10] = "StringLiteral";
      SyntaxKind2[SyntaxKind2["JsxText"] = 11] = "JsxText";
      SyntaxKind2[SyntaxKind2["JsxTextAllWhiteSpaces"] = 12] = "JsxTextAllWhiteSpaces";
      SyntaxKind2[SyntaxKind2["RegularExpressionLiteral"] = 13] = "RegularExpressionLiteral";
      SyntaxKind2[SyntaxKind2["NoSubstitutionTemplateLiteral"] = 14] = "NoSubstitutionTemplateLiteral";
      SyntaxKind2[SyntaxKind2["TemplateHead"] = 15] = "TemplateHead";
      SyntaxKind2[SyntaxKind2["TemplateMiddle"] = 16] = "TemplateMiddle";
      SyntaxKind2[SyntaxKind2["TemplateTail"] = 17] = "TemplateTail";
      SyntaxKind2[SyntaxKind2["OpenBraceToken"] = 18] = "OpenBraceToken";
      SyntaxKind2[SyntaxKind2["CloseBraceToken"] = 19] = "CloseBraceToken";
      SyntaxKind2[SyntaxKind2["OpenParenToken"] = 20] = "OpenParenToken";
      SyntaxKind2[SyntaxKind2["CloseParenToken"] = 21] = "CloseParenToken";
      SyntaxKind2[SyntaxKind2["OpenBracketToken"] = 22] = "OpenBracketToken";
      SyntaxKind2[SyntaxKind2["CloseBracketToken"] = 23] = "CloseBracketToken";
      SyntaxKind2[SyntaxKind2["DotToken"] = 24] = "DotToken";
      SyntaxKind2[SyntaxKind2["DotDotDotToken"] = 25] = "DotDotDotToken";
      SyntaxKind2[SyntaxKind2["SemicolonToken"] = 26] = "SemicolonToken";
      SyntaxKind2[SyntaxKind2["CommaToken"] = 27] = "CommaToken";
      SyntaxKind2[SyntaxKind2["QuestionDotToken"] = 28] = "QuestionDotToken";
      SyntaxKind2[SyntaxKind2["LessThanToken"] = 29] = "LessThanToken";
      SyntaxKind2[SyntaxKind2["LessThanSlashToken"] = 30] = "LessThanSlashToken";
      SyntaxKind2[SyntaxKind2["GreaterThanToken"] = 31] = "GreaterThanToken";
      SyntaxKind2[SyntaxKind2["LessThanEqualsToken"] = 32] = "LessThanEqualsToken";
      SyntaxKind2[SyntaxKind2["GreaterThanEqualsToken"] = 33] = "GreaterThanEqualsToken";
      SyntaxKind2[SyntaxKind2["EqualsEqualsToken"] = 34] = "EqualsEqualsToken";
      SyntaxKind2[SyntaxKind2["ExclamationEqualsToken"] = 35] = "ExclamationEqualsToken";
      SyntaxKind2[SyntaxKind2["EqualsEqualsEqualsToken"] = 36] = "EqualsEqualsEqualsToken";
      SyntaxKind2[SyntaxKind2["ExclamationEqualsEqualsToken"] = 37] = "ExclamationEqualsEqualsToken";
      SyntaxKind2[SyntaxKind2["EqualsGreaterThanToken"] = 38] = "EqualsGreaterThanToken";
      SyntaxKind2[SyntaxKind2["PlusToken"] = 39] = "PlusToken";
      SyntaxKind2[SyntaxKind2["MinusToken"] = 40] = "MinusToken";
      SyntaxKind2[SyntaxKind2["AsteriskToken"] = 41] = "AsteriskToken";
      SyntaxKind2[SyntaxKind2["AsteriskAsteriskToken"] = 42] = "AsteriskAsteriskToken";
      SyntaxKind2[SyntaxKind2["SlashToken"] = 43] = "SlashToken";
      SyntaxKind2[SyntaxKind2["PercentToken"] = 44] = "PercentToken";
      SyntaxKind2[SyntaxKind2["PlusPlusToken"] = 45] = "PlusPlusToken";
      SyntaxKind2[SyntaxKind2["MinusMinusToken"] = 46] = "MinusMinusToken";
      SyntaxKind2[SyntaxKind2["LessThanLessThanToken"] = 47] = "LessThanLessThanToken";
      SyntaxKind2[SyntaxKind2["GreaterThanGreaterThanToken"] = 48] = "GreaterThanGreaterThanToken";
      SyntaxKind2[SyntaxKind2["GreaterThanGreaterThanGreaterThanToken"] = 49] = "GreaterThanGreaterThanGreaterThanToken";
      SyntaxKind2[SyntaxKind2["AmpersandToken"] = 50] = "AmpersandToken";
      SyntaxKind2[SyntaxKind2["BarToken"] = 51] = "BarToken";
      SyntaxKind2[SyntaxKind2["CaretToken"] = 52] = "CaretToken";
      SyntaxKind2[SyntaxKind2["ExclamationToken"] = 53] = "ExclamationToken";
      SyntaxKind2[SyntaxKind2["TildeToken"] = 54] = "TildeToken";
      SyntaxKind2[SyntaxKind2["AmpersandAmpersandToken"] = 55] = "AmpersandAmpersandToken";
      SyntaxKind2[SyntaxKind2["BarBarToken"] = 56] = "BarBarToken";
      SyntaxKind2[SyntaxKind2["QuestionToken"] = 57] = "QuestionToken";
      SyntaxKind2[SyntaxKind2["ColonToken"] = 58] = "ColonToken";
      SyntaxKind2[SyntaxKind2["AtToken"] = 59] = "AtToken";
      SyntaxKind2[SyntaxKind2["QuestionQuestionToken"] = 60] = "QuestionQuestionToken";
      SyntaxKind2[SyntaxKind2["BacktickToken"] = 61] = "BacktickToken";
      SyntaxKind2[SyntaxKind2["HashToken"] = 62] = "HashToken";
      SyntaxKind2[SyntaxKind2["EqualsToken"] = 63] = "EqualsToken";
      SyntaxKind2[SyntaxKind2["PlusEqualsToken"] = 64] = "PlusEqualsToken";
      SyntaxKind2[SyntaxKind2["MinusEqualsToken"] = 65] = "MinusEqualsToken";
      SyntaxKind2[SyntaxKind2["AsteriskEqualsToken"] = 66] = "AsteriskEqualsToken";
      SyntaxKind2[SyntaxKind2["AsteriskAsteriskEqualsToken"] = 67] = "AsteriskAsteriskEqualsToken";
      SyntaxKind2[SyntaxKind2["SlashEqualsToken"] = 68] = "SlashEqualsToken";
      SyntaxKind2[SyntaxKind2["PercentEqualsToken"] = 69] = "PercentEqualsToken";
      SyntaxKind2[SyntaxKind2["LessThanLessThanEqualsToken"] = 70] = "LessThanLessThanEqualsToken";
      SyntaxKind2[SyntaxKind2["GreaterThanGreaterThanEqualsToken"] = 71] = "GreaterThanGreaterThanEqualsToken";
      SyntaxKind2[SyntaxKind2["GreaterThanGreaterThanGreaterThanEqualsToken"] = 72] = "GreaterThanGreaterThanGreaterThanEqualsToken";
      SyntaxKind2[SyntaxKind2["AmpersandEqualsToken"] = 73] = "AmpersandEqualsToken";
      SyntaxKind2[SyntaxKind2["BarEqualsToken"] = 74] = "BarEqualsToken";
      SyntaxKind2[SyntaxKind2["BarBarEqualsToken"] = 75] = "BarBarEqualsToken";
      SyntaxKind2[SyntaxKind2["AmpersandAmpersandEqualsToken"] = 76] = "AmpersandAmpersandEqualsToken";
      SyntaxKind2[SyntaxKind2["QuestionQuestionEqualsToken"] = 77] = "QuestionQuestionEqualsToken";
      SyntaxKind2[SyntaxKind2["CaretEqualsToken"] = 78] = "CaretEqualsToken";
      SyntaxKind2[SyntaxKind2["Identifier"] = 79] = "Identifier";
      SyntaxKind2[SyntaxKind2["PrivateIdentifier"] = 80] = "PrivateIdentifier";
      SyntaxKind2[SyntaxKind2["BreakKeyword"] = 81] = "BreakKeyword";
      SyntaxKind2[SyntaxKind2["CaseKeyword"] = 82] = "CaseKeyword";
      SyntaxKind2[SyntaxKind2["CatchKeyword"] = 83] = "CatchKeyword";
      SyntaxKind2[SyntaxKind2["ClassKeyword"] = 84] = "ClassKeyword";
      SyntaxKind2[SyntaxKind2["ConstKeyword"] = 85] = "ConstKeyword";
      SyntaxKind2[SyntaxKind2["ContinueKeyword"] = 86] = "ContinueKeyword";
      SyntaxKind2[SyntaxKind2["DebuggerKeyword"] = 87] = "DebuggerKeyword";
      SyntaxKind2[SyntaxKind2["DefaultKeyword"] = 88] = "DefaultKeyword";
      SyntaxKind2[SyntaxKind2["DeleteKeyword"] = 89] = "DeleteKeyword";
      SyntaxKind2[SyntaxKind2["DoKeyword"] = 90] = "DoKeyword";
      SyntaxKind2[SyntaxKind2["ElseKeyword"] = 91] = "ElseKeyword";
      SyntaxKind2[SyntaxKind2["EnumKeyword"] = 92] = "EnumKeyword";
      SyntaxKind2[SyntaxKind2["ExportKeyword"] = 93] = "ExportKeyword";
      SyntaxKind2[SyntaxKind2["ExtendsKeyword"] = 94] = "ExtendsKeyword";
      SyntaxKind2[SyntaxKind2["FalseKeyword"] = 95] = "FalseKeyword";
      SyntaxKind2[SyntaxKind2["FinallyKeyword"] = 96] = "FinallyKeyword";
      SyntaxKind2[SyntaxKind2["ForKeyword"] = 97] = "ForKeyword";
      SyntaxKind2[SyntaxKind2["FunctionKeyword"] = 98] = "FunctionKeyword";
      SyntaxKind2[SyntaxKind2["IfKeyword"] = 99] = "IfKeyword";
      SyntaxKind2[SyntaxKind2["ImportKeyword"] = 100] = "ImportKeyword";
      SyntaxKind2[SyntaxKind2["InKeyword"] = 101] = "InKeyword";
      SyntaxKind2[SyntaxKind2["InstanceOfKeyword"] = 102] = "InstanceOfKeyword";
      SyntaxKind2[SyntaxKind2["NewKeyword"] = 103] = "NewKeyword";
      SyntaxKind2[SyntaxKind2["NullKeyword"] = 104] = "NullKeyword";
      SyntaxKind2[SyntaxKind2["ReturnKeyword"] = 105] = "ReturnKeyword";
      SyntaxKind2[SyntaxKind2["SuperKeyword"] = 106] = "SuperKeyword";
      SyntaxKind2[SyntaxKind2["SwitchKeyword"] = 107] = "SwitchKeyword";
      SyntaxKind2[SyntaxKind2["ThisKeyword"] = 108] = "ThisKeyword";
      SyntaxKind2[SyntaxKind2["ThrowKeyword"] = 109] = "ThrowKeyword";
      SyntaxKind2[SyntaxKind2["TrueKeyword"] = 110] = "TrueKeyword";
      SyntaxKind2[SyntaxKind2["TryKeyword"] = 111] = "TryKeyword";
      SyntaxKind2[SyntaxKind2["TypeOfKeyword"] = 112] = "TypeOfKeyword";
      SyntaxKind2[SyntaxKind2["VarKeyword"] = 113] = "VarKeyword";
      SyntaxKind2[SyntaxKind2["VoidKeyword"] = 114] = "VoidKeyword";
      SyntaxKind2[SyntaxKind2["WhileKeyword"] = 115] = "WhileKeyword";
      SyntaxKind2[SyntaxKind2["WithKeyword"] = 116] = "WithKeyword";
      SyntaxKind2[SyntaxKind2["ImplementsKeyword"] = 117] = "ImplementsKeyword";
      SyntaxKind2[SyntaxKind2["InterfaceKeyword"] = 118] = "InterfaceKeyword";
      SyntaxKind2[SyntaxKind2["LetKeyword"] = 119] = "LetKeyword";
      SyntaxKind2[SyntaxKind2["PackageKeyword"] = 120] = "PackageKeyword";
      SyntaxKind2[SyntaxKind2["PrivateKeyword"] = 121] = "PrivateKeyword";
      SyntaxKind2[SyntaxKind2["ProtectedKeyword"] = 122] = "ProtectedKeyword";
      SyntaxKind2[SyntaxKind2["PublicKeyword"] = 123] = "PublicKeyword";
      SyntaxKind2[SyntaxKind2["StaticKeyword"] = 124] = "StaticKeyword";
      SyntaxKind2[SyntaxKind2["YieldKeyword"] = 125] = "YieldKeyword";
      SyntaxKind2[SyntaxKind2["AbstractKeyword"] = 126] = "AbstractKeyword";
      SyntaxKind2[SyntaxKind2["AsKeyword"] = 127] = "AsKeyword";
      SyntaxKind2[SyntaxKind2["AssertsKeyword"] = 128] = "AssertsKeyword";
      SyntaxKind2[SyntaxKind2["AnyKeyword"] = 129] = "AnyKeyword";
      SyntaxKind2[SyntaxKind2["AsyncKeyword"] = 130] = "AsyncKeyword";
      SyntaxKind2[SyntaxKind2["AwaitKeyword"] = 131] = "AwaitKeyword";
      SyntaxKind2[SyntaxKind2["BooleanKeyword"] = 132] = "BooleanKeyword";
      SyntaxKind2[SyntaxKind2["ConstructorKeyword"] = 133] = "ConstructorKeyword";
      SyntaxKind2[SyntaxKind2["DeclareKeyword"] = 134] = "DeclareKeyword";
      SyntaxKind2[SyntaxKind2["GetKeyword"] = 135] = "GetKeyword";
      SyntaxKind2[SyntaxKind2["InferKeyword"] = 136] = "InferKeyword";
      SyntaxKind2[SyntaxKind2["IntrinsicKeyword"] = 137] = "IntrinsicKeyword";
      SyntaxKind2[SyntaxKind2["IsKeyword"] = 138] = "IsKeyword";
      SyntaxKind2[SyntaxKind2["KeyOfKeyword"] = 139] = "KeyOfKeyword";
      SyntaxKind2[SyntaxKind2["ModuleKeyword"] = 140] = "ModuleKeyword";
      SyntaxKind2[SyntaxKind2["NamespaceKeyword"] = 141] = "NamespaceKeyword";
      SyntaxKind2[SyntaxKind2["NeverKeyword"] = 142] = "NeverKeyword";
      SyntaxKind2[SyntaxKind2["ReadonlyKeyword"] = 143] = "ReadonlyKeyword";
      SyntaxKind2[SyntaxKind2["RequireKeyword"] = 144] = "RequireKeyword";
      SyntaxKind2[SyntaxKind2["NumberKeyword"] = 145] = "NumberKeyword";
      SyntaxKind2[SyntaxKind2["ObjectKeyword"] = 146] = "ObjectKeyword";
      SyntaxKind2[SyntaxKind2["SetKeyword"] = 147] = "SetKeyword";
      SyntaxKind2[SyntaxKind2["StringKeyword"] = 148] = "StringKeyword";
      SyntaxKind2[SyntaxKind2["SymbolKeyword"] = 149] = "SymbolKeyword";
      SyntaxKind2[SyntaxKind2["TypeKeyword"] = 150] = "TypeKeyword";
      SyntaxKind2[SyntaxKind2["UndefinedKeyword"] = 151] = "UndefinedKeyword";
      SyntaxKind2[SyntaxKind2["UniqueKeyword"] = 152] = "UniqueKeyword";
      SyntaxKind2[SyntaxKind2["UnknownKeyword"] = 153] = "UnknownKeyword";
      SyntaxKind2[SyntaxKind2["FromKeyword"] = 154] = "FromKeyword";
      SyntaxKind2[SyntaxKind2["GlobalKeyword"] = 155] = "GlobalKeyword";
      SyntaxKind2[SyntaxKind2["BigIntKeyword"] = 156] = "BigIntKeyword";
      SyntaxKind2[SyntaxKind2["OverrideKeyword"] = 157] = "OverrideKeyword";
      SyntaxKind2[SyntaxKind2["OfKeyword"] = 158] = "OfKeyword";
      SyntaxKind2[SyntaxKind2["QualifiedName"] = 159] = "QualifiedName";
      SyntaxKind2[SyntaxKind2["ComputedPropertyName"] = 160] = "ComputedPropertyName";
      SyntaxKind2[SyntaxKind2["TypeParameter"] = 161] = "TypeParameter";
      SyntaxKind2[SyntaxKind2["Parameter"] = 162] = "Parameter";
      SyntaxKind2[SyntaxKind2["Decorator"] = 163] = "Decorator";
      SyntaxKind2[SyntaxKind2["PropertySignature"] = 164] = "PropertySignature";
      SyntaxKind2[SyntaxKind2["PropertyDeclaration"] = 165] = "PropertyDeclaration";
      SyntaxKind2[SyntaxKind2["MethodSignature"] = 166] = "MethodSignature";
      SyntaxKind2[SyntaxKind2["MethodDeclaration"] = 167] = "MethodDeclaration";
      SyntaxKind2[SyntaxKind2["ClassStaticBlockDeclaration"] = 168] = "ClassStaticBlockDeclaration";
      SyntaxKind2[SyntaxKind2["Constructor"] = 169] = "Constructor";
      SyntaxKind2[SyntaxKind2["GetAccessor"] = 170] = "GetAccessor";
      SyntaxKind2[SyntaxKind2["SetAccessor"] = 171] = "SetAccessor";
      SyntaxKind2[SyntaxKind2["CallSignature"] = 172] = "CallSignature";
      SyntaxKind2[SyntaxKind2["ConstructSignature"] = 173] = "ConstructSignature";
      SyntaxKind2[SyntaxKind2["IndexSignature"] = 174] = "IndexSignature";
      SyntaxKind2[SyntaxKind2["TypePredicate"] = 175] = "TypePredicate";
      SyntaxKind2[SyntaxKind2["TypeReference"] = 176] = "TypeReference";
      SyntaxKind2[SyntaxKind2["FunctionType"] = 177] = "FunctionType";
      SyntaxKind2[SyntaxKind2["ConstructorType"] = 178] = "ConstructorType";
      SyntaxKind2[SyntaxKind2["TypeQuery"] = 179] = "TypeQuery";
      SyntaxKind2[SyntaxKind2["TypeLiteral"] = 180] = "TypeLiteral";
      SyntaxKind2[SyntaxKind2["ArrayType"] = 181] = "ArrayType";
      SyntaxKind2[SyntaxKind2["TupleType"] = 182] = "TupleType";
      SyntaxKind2[SyntaxKind2["OptionalType"] = 183] = "OptionalType";
      SyntaxKind2[SyntaxKind2["RestType"] = 184] = "RestType";
      SyntaxKind2[SyntaxKind2["UnionType"] = 185] = "UnionType";
      SyntaxKind2[SyntaxKind2["IntersectionType"] = 186] = "IntersectionType";
      SyntaxKind2[SyntaxKind2["ConditionalType"] = 187] = "ConditionalType";
      SyntaxKind2[SyntaxKind2["InferType"] = 188] = "InferType";
      SyntaxKind2[SyntaxKind2["ParenthesizedType"] = 189] = "ParenthesizedType";
      SyntaxKind2[SyntaxKind2["ThisType"] = 190] = "ThisType";
      SyntaxKind2[SyntaxKind2["TypeOperator"] = 191] = "TypeOperator";
      SyntaxKind2[SyntaxKind2["IndexedAccessType"] = 192] = "IndexedAccessType";
      SyntaxKind2[SyntaxKind2["MappedType"] = 193] = "MappedType";
      SyntaxKind2[SyntaxKind2["LiteralType"] = 194] = "LiteralType";
      SyntaxKind2[SyntaxKind2["NamedTupleMember"] = 195] = "NamedTupleMember";
      SyntaxKind2[SyntaxKind2["TemplateLiteralType"] = 196] = "TemplateLiteralType";
      SyntaxKind2[SyntaxKind2["TemplateLiteralTypeSpan"] = 197] = "TemplateLiteralTypeSpan";
      SyntaxKind2[SyntaxKind2["ImportType"] = 198] = "ImportType";
      SyntaxKind2[SyntaxKind2["ObjectBindingPattern"] = 199] = "ObjectBindingPattern";
      SyntaxKind2[SyntaxKind2["ArrayBindingPattern"] = 200] = "ArrayBindingPattern";
      SyntaxKind2[SyntaxKind2["BindingElement"] = 201] = "BindingElement";
      SyntaxKind2[SyntaxKind2["ArrayLiteralExpression"] = 202] = "ArrayLiteralExpression";
      SyntaxKind2[SyntaxKind2["ObjectLiteralExpression"] = 203] = "ObjectLiteralExpression";
      SyntaxKind2[SyntaxKind2["PropertyAccessExpression"] = 204] = "PropertyAccessExpression";
      SyntaxKind2[SyntaxKind2["ElementAccessExpression"] = 205] = "ElementAccessExpression";
      SyntaxKind2[SyntaxKind2["CallExpression"] = 206] = "CallExpression";
      SyntaxKind2[SyntaxKind2["NewExpression"] = 207] = "NewExpression";
      SyntaxKind2[SyntaxKind2["TaggedTemplateExpression"] = 208] = "TaggedTemplateExpression";
      SyntaxKind2[SyntaxKind2["TypeAssertionExpression"] = 209] = "TypeAssertionExpression";
      SyntaxKind2[SyntaxKind2["ParenthesizedExpression"] = 210] = "ParenthesizedExpression";
      SyntaxKind2[SyntaxKind2["FunctionExpression"] = 211] = "FunctionExpression";
      SyntaxKind2[SyntaxKind2["ArrowFunction"] = 212] = "ArrowFunction";
      SyntaxKind2[SyntaxKind2["DeleteExpression"] = 213] = "DeleteExpression";
      SyntaxKind2[SyntaxKind2["TypeOfExpression"] = 214] = "TypeOfExpression";
      SyntaxKind2[SyntaxKind2["VoidExpression"] = 215] = "VoidExpression";
      SyntaxKind2[SyntaxKind2["AwaitExpression"] = 216] = "AwaitExpression";
      SyntaxKind2[SyntaxKind2["PrefixUnaryExpression"] = 217] = "PrefixUnaryExpression";
      SyntaxKind2[SyntaxKind2["PostfixUnaryExpression"] = 218] = "PostfixUnaryExpression";
      SyntaxKind2[SyntaxKind2["BinaryExpression"] = 219] = "BinaryExpression";
      SyntaxKind2[SyntaxKind2["ConditionalExpression"] = 220] = "ConditionalExpression";
      SyntaxKind2[SyntaxKind2["TemplateExpression"] = 221] = "TemplateExpression";
      SyntaxKind2[SyntaxKind2["YieldExpression"] = 222] = "YieldExpression";
      SyntaxKind2[SyntaxKind2["SpreadElement"] = 223] = "SpreadElement";
      SyntaxKind2[SyntaxKind2["ClassExpression"] = 224] = "ClassExpression";
      SyntaxKind2[SyntaxKind2["OmittedExpression"] = 225] = "OmittedExpression";
      SyntaxKind2[SyntaxKind2["ExpressionWithTypeArguments"] = 226] = "ExpressionWithTypeArguments";
      SyntaxKind2[SyntaxKind2["AsExpression"] = 227] = "AsExpression";
      SyntaxKind2[SyntaxKind2["NonNullExpression"] = 228] = "NonNullExpression";
      SyntaxKind2[SyntaxKind2["MetaProperty"] = 229] = "MetaProperty";
      SyntaxKind2[SyntaxKind2["SyntheticExpression"] = 230] = "SyntheticExpression";
      SyntaxKind2[SyntaxKind2["TemplateSpan"] = 231] = "TemplateSpan";
      SyntaxKind2[SyntaxKind2["SemicolonClassElement"] = 232] = "SemicolonClassElement";
      SyntaxKind2[SyntaxKind2["Block"] = 233] = "Block";
      SyntaxKind2[SyntaxKind2["EmptyStatement"] = 234] = "EmptyStatement";
      SyntaxKind2[SyntaxKind2["VariableStatement"] = 235] = "VariableStatement";
      SyntaxKind2[SyntaxKind2["ExpressionStatement"] = 236] = "ExpressionStatement";
      SyntaxKind2[SyntaxKind2["IfStatement"] = 237] = "IfStatement";
      SyntaxKind2[SyntaxKind2["DoStatement"] = 238] = "DoStatement";
      SyntaxKind2[SyntaxKind2["WhileStatement"] = 239] = "WhileStatement";
      SyntaxKind2[SyntaxKind2["ForStatement"] = 240] = "ForStatement";
      SyntaxKind2[SyntaxKind2["ForInStatement"] = 241] = "ForInStatement";
      SyntaxKind2[SyntaxKind2["ForOfStatement"] = 242] = "ForOfStatement";
      SyntaxKind2[SyntaxKind2["ContinueStatement"] = 243] = "ContinueStatement";
      SyntaxKind2[SyntaxKind2["BreakStatement"] = 244] = "BreakStatement";
      SyntaxKind2[SyntaxKind2["ReturnStatement"] = 245] = "ReturnStatement";
      SyntaxKind2[SyntaxKind2["WithStatement"] = 246] = "WithStatement";
      SyntaxKind2[SyntaxKind2["SwitchStatement"] = 247] = "SwitchStatement";
      SyntaxKind2[SyntaxKind2["LabeledStatement"] = 248] = "LabeledStatement";
      SyntaxKind2[SyntaxKind2["ThrowStatement"] = 249] = "ThrowStatement";
      SyntaxKind2[SyntaxKind2["TryStatement"] = 250] = "TryStatement";
      SyntaxKind2[SyntaxKind2["DebuggerStatement"] = 251] = "DebuggerStatement";
      SyntaxKind2[SyntaxKind2["VariableDeclaration"] = 252] = "VariableDeclaration";
      SyntaxKind2[SyntaxKind2["VariableDeclarationList"] = 253] = "VariableDeclarationList";
      SyntaxKind2[SyntaxKind2["FunctionDeclaration"] = 254] = "FunctionDeclaration";
      SyntaxKind2[SyntaxKind2["ClassDeclaration"] = 255] = "ClassDeclaration";
      SyntaxKind2[SyntaxKind2["InterfaceDeclaration"] = 256] = "InterfaceDeclaration";
      SyntaxKind2[SyntaxKind2["TypeAliasDeclaration"] = 257] = "TypeAliasDeclaration";
      SyntaxKind2[SyntaxKind2["EnumDeclaration"] = 258] = "EnumDeclaration";
      SyntaxKind2[SyntaxKind2["ModuleDeclaration"] = 259] = "ModuleDeclaration";
      SyntaxKind2[SyntaxKind2["ModuleBlock"] = 260] = "ModuleBlock";
      SyntaxKind2[SyntaxKind2["CaseBlock"] = 261] = "CaseBlock";
      SyntaxKind2[SyntaxKind2["NamespaceExportDeclaration"] = 262] = "NamespaceExportDeclaration";
      SyntaxKind2[SyntaxKind2["ImportEqualsDeclaration"] = 263] = "ImportEqualsDeclaration";
      SyntaxKind2[SyntaxKind2["ImportDeclaration"] = 264] = "ImportDeclaration";
      SyntaxKind2[SyntaxKind2["ImportClause"] = 265] = "ImportClause";
      SyntaxKind2[SyntaxKind2["NamespaceImport"] = 266] = "NamespaceImport";
      SyntaxKind2[SyntaxKind2["NamedImports"] = 267] = "NamedImports";
      SyntaxKind2[SyntaxKind2["ImportSpecifier"] = 268] = "ImportSpecifier";
      SyntaxKind2[SyntaxKind2["ExportAssignment"] = 269] = "ExportAssignment";
      SyntaxKind2[SyntaxKind2["ExportDeclaration"] = 270] = "ExportDeclaration";
      SyntaxKind2[SyntaxKind2["NamedExports"] = 271] = "NamedExports";
      SyntaxKind2[SyntaxKind2["NamespaceExport"] = 272] = "NamespaceExport";
      SyntaxKind2[SyntaxKind2["ExportSpecifier"] = 273] = "ExportSpecifier";
      SyntaxKind2[SyntaxKind2["MissingDeclaration"] = 274] = "MissingDeclaration";
      SyntaxKind2[SyntaxKind2["ExternalModuleReference"] = 275] = "ExternalModuleReference";
      SyntaxKind2[SyntaxKind2["JsxElement"] = 276] = "JsxElement";
      SyntaxKind2[SyntaxKind2["JsxSelfClosingElement"] = 277] = "JsxSelfClosingElement";
      SyntaxKind2[SyntaxKind2["JsxOpeningElement"] = 278] = "JsxOpeningElement";
      SyntaxKind2[SyntaxKind2["JsxClosingElement"] = 279] = "JsxClosingElement";
      SyntaxKind2[SyntaxKind2["JsxFragment"] = 280] = "JsxFragment";
      SyntaxKind2[SyntaxKind2["JsxOpeningFragment"] = 281] = "JsxOpeningFragment";
      SyntaxKind2[SyntaxKind2["JsxClosingFragment"] = 282] = "JsxClosingFragment";
      SyntaxKind2[SyntaxKind2["JsxAttribute"] = 283] = "JsxAttribute";
      SyntaxKind2[SyntaxKind2["JsxAttributes"] = 284] = "JsxAttributes";
      SyntaxKind2[SyntaxKind2["JsxSpreadAttribute"] = 285] = "JsxSpreadAttribute";
      SyntaxKind2[SyntaxKind2["JsxExpression"] = 286] = "JsxExpression";
      SyntaxKind2[SyntaxKind2["CaseClause"] = 287] = "CaseClause";
      SyntaxKind2[SyntaxKind2["DefaultClause"] = 288] = "DefaultClause";
      SyntaxKind2[SyntaxKind2["HeritageClause"] = 289] = "HeritageClause";
      SyntaxKind2[SyntaxKind2["CatchClause"] = 290] = "CatchClause";
      SyntaxKind2[SyntaxKind2["PropertyAssignment"] = 291] = "PropertyAssignment";
      SyntaxKind2[SyntaxKind2["ShorthandPropertyAssignment"] = 292] = "ShorthandPropertyAssignment";
      SyntaxKind2[SyntaxKind2["SpreadAssignment"] = 293] = "SpreadAssignment";
      SyntaxKind2[SyntaxKind2["EnumMember"] = 294] = "EnumMember";
      SyntaxKind2[SyntaxKind2["UnparsedPrologue"] = 295] = "UnparsedPrologue";
      SyntaxKind2[SyntaxKind2["UnparsedPrepend"] = 296] = "UnparsedPrepend";
      SyntaxKind2[SyntaxKind2["UnparsedText"] = 297] = "UnparsedText";
      SyntaxKind2[SyntaxKind2["UnparsedInternalText"] = 298] = "UnparsedInternalText";
      SyntaxKind2[SyntaxKind2["UnparsedSyntheticReference"] = 299] = "UnparsedSyntheticReference";
      SyntaxKind2[SyntaxKind2["SourceFile"] = 300] = "SourceFile";
      SyntaxKind2[SyntaxKind2["Bundle"] = 301] = "Bundle";
      SyntaxKind2[SyntaxKind2["UnparsedSource"] = 302] = "UnparsedSource";
      SyntaxKind2[SyntaxKind2["InputFiles"] = 303] = "InputFiles";
      SyntaxKind2[SyntaxKind2["JSDocTypeExpression"] = 304] = "JSDocTypeExpression";
      SyntaxKind2[SyntaxKind2["JSDocNameReference"] = 305] = "JSDocNameReference";
      SyntaxKind2[SyntaxKind2["JSDocMemberName"] = 306] = "JSDocMemberName";
      SyntaxKind2[SyntaxKind2["JSDocAllType"] = 307] = "JSDocAllType";
      SyntaxKind2[SyntaxKind2["JSDocUnknownType"] = 308] = "JSDocUnknownType";
      SyntaxKind2[SyntaxKind2["JSDocNullableType"] = 309] = "JSDocNullableType";
      SyntaxKind2[SyntaxKind2["JSDocNonNullableType"] = 310] = "JSDocNonNullableType";
      SyntaxKind2[SyntaxKind2["JSDocOptionalType"] = 311] = "JSDocOptionalType";
      SyntaxKind2[SyntaxKind2["JSDocFunctionType"] = 312] = "JSDocFunctionType";
      SyntaxKind2[SyntaxKind2["JSDocVariadicType"] = 313] = "JSDocVariadicType";
      SyntaxKind2[SyntaxKind2["JSDocNamepathType"] = 314] = "JSDocNamepathType";
      SyntaxKind2[SyntaxKind2["JSDocComment"] = 315] = "JSDocComment";
      SyntaxKind2[SyntaxKind2["JSDocText"] = 316] = "JSDocText";
      SyntaxKind2[SyntaxKind2["JSDocTypeLiteral"] = 317] = "JSDocTypeLiteral";
      SyntaxKind2[SyntaxKind2["JSDocSignature"] = 318] = "JSDocSignature";
      SyntaxKind2[SyntaxKind2["JSDocLink"] = 319] = "JSDocLink";
      SyntaxKind2[SyntaxKind2["JSDocLinkCode"] = 320] = "JSDocLinkCode";
      SyntaxKind2[SyntaxKind2["JSDocLinkPlain"] = 321] = "JSDocLinkPlain";
      SyntaxKind2[SyntaxKind2["JSDocTag"] = 322] = "JSDocTag";
      SyntaxKind2[SyntaxKind2["JSDocAugmentsTag"] = 323] = "JSDocAugmentsTag";
      SyntaxKind2[SyntaxKind2["JSDocImplementsTag"] = 324] = "JSDocImplementsTag";
      SyntaxKind2[SyntaxKind2["JSDocAuthorTag"] = 325] = "JSDocAuthorTag";
      SyntaxKind2[SyntaxKind2["JSDocDeprecatedTag"] = 326] = "JSDocDeprecatedTag";
      SyntaxKind2[SyntaxKind2["JSDocClassTag"] = 327] = "JSDocClassTag";
      SyntaxKind2[SyntaxKind2["JSDocPublicTag"] = 328] = "JSDocPublicTag";
      SyntaxKind2[SyntaxKind2["JSDocPrivateTag"] = 329] = "JSDocPrivateTag";
      SyntaxKind2[SyntaxKind2["JSDocProtectedTag"] = 330] = "JSDocProtectedTag";
      SyntaxKind2[SyntaxKind2["JSDocReadonlyTag"] = 331] = "JSDocReadonlyTag";
      SyntaxKind2[SyntaxKind2["JSDocOverrideTag"] = 332] = "JSDocOverrideTag";
      SyntaxKind2[SyntaxKind2["JSDocCallbackTag"] = 333] = "JSDocCallbackTag";
      SyntaxKind2[SyntaxKind2["JSDocEnumTag"] = 334] = "JSDocEnumTag";
      SyntaxKind2[SyntaxKind2["JSDocParameterTag"] = 335] = "JSDocParameterTag";
      SyntaxKind2[SyntaxKind2["JSDocReturnTag"] = 336] = "JSDocReturnTag";
      SyntaxKind2[SyntaxKind2["JSDocThisTag"] = 337] = "JSDocThisTag";
      SyntaxKind2[SyntaxKind2["JSDocTypeTag"] = 338] = "JSDocTypeTag";
      SyntaxKind2[SyntaxKind2["JSDocTemplateTag"] = 339] = "JSDocTemplateTag";
      SyntaxKind2[SyntaxKind2["JSDocTypedefTag"] = 340] = "JSDocTypedefTag";
      SyntaxKind2[SyntaxKind2["JSDocSeeTag"] = 341] = "JSDocSeeTag";
      SyntaxKind2[SyntaxKind2["JSDocPropertyTag"] = 342] = "JSDocPropertyTag";
      SyntaxKind2[SyntaxKind2["SyntaxList"] = 343] = "SyntaxList";
      SyntaxKind2[SyntaxKind2["NotEmittedStatement"] = 344] = "NotEmittedStatement";
      SyntaxKind2[SyntaxKind2["PartiallyEmittedExpression"] = 345] = "PartiallyEmittedExpression";
      SyntaxKind2[SyntaxKind2["CommaListExpression"] = 346] = "CommaListExpression";
      SyntaxKind2[SyntaxKind2["MergeDeclarationMarker"] = 347] = "MergeDeclarationMarker";
      SyntaxKind2[SyntaxKind2["EndOfDeclarationMarker"] = 348] = "EndOfDeclarationMarker";
      SyntaxKind2[SyntaxKind2["SyntheticReferenceExpression"] = 349] = "SyntheticReferenceExpression";
      SyntaxKind2[SyntaxKind2["Count"] = 350] = "Count";
      SyntaxKind2[SyntaxKind2["FirstAssignment"] = 63] = "FirstAssignment";
      SyntaxKind2[SyntaxKind2["LastAssignment"] = 78] = "LastAssignment";
      SyntaxKind2[SyntaxKind2["FirstCompoundAssignment"] = 64] = "FirstCompoundAssignment";
      SyntaxKind2[SyntaxKind2["LastCompoundAssignment"] = 78] = "LastCompoundAssignment";
      SyntaxKind2[SyntaxKind2["FirstReservedWord"] = 81] = "FirstReservedWord";
      SyntaxKind2[SyntaxKind2["LastReservedWord"] = 116] = "LastReservedWord";
      SyntaxKind2[SyntaxKind2["FirstKeyword"] = 81] = "FirstKeyword";
      SyntaxKind2[SyntaxKind2["LastKeyword"] = 158] = "LastKeyword";
      SyntaxKind2[SyntaxKind2["FirstFutureReservedWord"] = 117] = "FirstFutureReservedWord";
      SyntaxKind2[SyntaxKind2["LastFutureReservedWord"] = 125] = "LastFutureReservedWord";
      SyntaxKind2[SyntaxKind2["FirstTypeNode"] = 175] = "FirstTypeNode";
      SyntaxKind2[SyntaxKind2["LastTypeNode"] = 198] = "LastTypeNode";
      SyntaxKind2[SyntaxKind2["FirstPunctuation"] = 18] = "FirstPunctuation";
      SyntaxKind2[SyntaxKind2["LastPunctuation"] = 78] = "LastPunctuation";
      SyntaxKind2[SyntaxKind2["FirstToken"] = 0] = "FirstToken";
      SyntaxKind2[SyntaxKind2["LastToken"] = 158] = "LastToken";
      SyntaxKind2[SyntaxKind2["FirstTriviaToken"] = 2] = "FirstTriviaToken";
      SyntaxKind2[SyntaxKind2["LastTriviaToken"] = 7] = "LastTriviaToken";
      SyntaxKind2[SyntaxKind2["FirstLiteralToken"] = 8] = "FirstLiteralToken";
      SyntaxKind2[SyntaxKind2["LastLiteralToken"] = 14] = "LastLiteralToken";
      SyntaxKind2[SyntaxKind2["FirstTemplateToken"] = 14] = "FirstTemplateToken";
      SyntaxKind2[SyntaxKind2["LastTemplateToken"] = 17] = "LastTemplateToken";
      SyntaxKind2[SyntaxKind2["FirstBinaryOperator"] = 29] = "FirstBinaryOperator";
      SyntaxKind2[SyntaxKind2["LastBinaryOperator"] = 78] = "LastBinaryOperator";
      SyntaxKind2[SyntaxKind2["FirstStatement"] = 235] = "FirstStatement";
      SyntaxKind2[SyntaxKind2["LastStatement"] = 251] = "LastStatement";
      SyntaxKind2[SyntaxKind2["FirstNode"] = 159] = "FirstNode";
      SyntaxKind2[SyntaxKind2["FirstJSDocNode"] = 304] = "FirstJSDocNode";
      SyntaxKind2[SyntaxKind2["LastJSDocNode"] = 342] = "LastJSDocNode";
      SyntaxKind2[SyntaxKind2["FirstJSDocTagNode"] = 322] = "FirstJSDocTagNode";
      SyntaxKind2[SyntaxKind2["LastJSDocTagNode"] = 342] = "LastJSDocTagNode";
      SyntaxKind2[SyntaxKind2["FirstContextualKeyword"] = 126] = "FirstContextualKeyword";
      SyntaxKind2[SyntaxKind2["LastContextualKeyword"] = 158] = "LastContextualKeyword";
    })(SyntaxKind = ts2.SyntaxKind || (ts2.SyntaxKind = {}));
    var NodeFlags;
    (function(NodeFlags2) {
      NodeFlags2[NodeFlags2["None"] = 0] = "None";
      NodeFlags2[NodeFlags2["Let"] = 1] = "Let";
      NodeFlags2[NodeFlags2["Const"] = 2] = "Const";
      NodeFlags2[NodeFlags2["NestedNamespace"] = 4] = "NestedNamespace";
      NodeFlags2[NodeFlags2["Synthesized"] = 8] = "Synthesized";
      NodeFlags2[NodeFlags2["Namespace"] = 16] = "Namespace";
      NodeFlags2[NodeFlags2["OptionalChain"] = 32] = "OptionalChain";
      NodeFlags2[NodeFlags2["ExportContext"] = 64] = "ExportContext";
      NodeFlags2[NodeFlags2["ContainsThis"] = 128] = "ContainsThis";
      NodeFlags2[NodeFlags2["HasImplicitReturn"] = 256] = "HasImplicitReturn";
      NodeFlags2[NodeFlags2["HasExplicitReturn"] = 512] = "HasExplicitReturn";
      NodeFlags2[NodeFlags2["GlobalAugmentation"] = 1024] = "GlobalAugmentation";
      NodeFlags2[NodeFlags2["HasAsyncFunctions"] = 2048] = "HasAsyncFunctions";
      NodeFlags2[NodeFlags2["DisallowInContext"] = 4096] = "DisallowInContext";
      NodeFlags2[NodeFlags2["YieldContext"] = 8192] = "YieldContext";
      NodeFlags2[NodeFlags2["DecoratorContext"] = 16384] = "DecoratorContext";
      NodeFlags2[NodeFlags2["AwaitContext"] = 32768] = "AwaitContext";
      NodeFlags2[NodeFlags2["ThisNodeHasError"] = 65536] = "ThisNodeHasError";
      NodeFlags2[NodeFlags2["JavaScriptFile"] = 131072] = "JavaScriptFile";
      NodeFlags2[NodeFlags2["ThisNodeOrAnySubNodesHasError"] = 262144] = "ThisNodeOrAnySubNodesHasError";
      NodeFlags2[NodeFlags2["HasAggregatedChildData"] = 524288] = "HasAggregatedChildData";
      NodeFlags2[NodeFlags2["PossiblyContainsDynamicImport"] = 1048576] = "PossiblyContainsDynamicImport";
      NodeFlags2[NodeFlags2["PossiblyContainsImportMeta"] = 2097152] = "PossiblyContainsImportMeta";
      NodeFlags2[NodeFlags2["JSDoc"] = 4194304] = "JSDoc";
      NodeFlags2[NodeFlags2["Ambient"] = 8388608] = "Ambient";
      NodeFlags2[NodeFlags2["InWithStatement"] = 16777216] = "InWithStatement";
      NodeFlags2[NodeFlags2["JsonFile"] = 33554432] = "JsonFile";
      NodeFlags2[NodeFlags2["TypeCached"] = 67108864] = "TypeCached";
      NodeFlags2[NodeFlags2["Deprecated"] = 134217728] = "Deprecated";
      NodeFlags2[NodeFlags2["BlockScoped"] = 3] = "BlockScoped";
      NodeFlags2[NodeFlags2["ReachabilityCheckFlags"] = 768] = "ReachabilityCheckFlags";
      NodeFlags2[NodeFlags2["ReachabilityAndEmitFlags"] = 2816] = "ReachabilityAndEmitFlags";
      NodeFlags2[NodeFlags2["ContextFlags"] = 25358336] = "ContextFlags";
      NodeFlags2[NodeFlags2["TypeExcludesFlags"] = 40960] = "TypeExcludesFlags";
      NodeFlags2[NodeFlags2["PermanentlySetIncrementalFlags"] = 3145728] = "PermanentlySetIncrementalFlags";
    })(NodeFlags = ts2.NodeFlags || (ts2.NodeFlags = {}));
    var ModifierFlags;
    (function(ModifierFlags2) {
      ModifierFlags2[ModifierFlags2["None"] = 0] = "None";
      ModifierFlags2[ModifierFlags2["Export"] = 1] = "Export";
      ModifierFlags2[ModifierFlags2["Ambient"] = 2] = "Ambient";
      ModifierFlags2[ModifierFlags2["Public"] = 4] = "Public";
      ModifierFlags2[ModifierFlags2["Private"] = 8] = "Private";
      ModifierFlags2[ModifierFlags2["Protected"] = 16] = "Protected";
      ModifierFlags2[ModifierFlags2["Static"] = 32] = "Static";
      ModifierFlags2[ModifierFlags2["Readonly"] = 64] = "Readonly";
      ModifierFlags2[ModifierFlags2["Abstract"] = 128] = "Abstract";
      ModifierFlags2[ModifierFlags2["Async"] = 256] = "Async";
      ModifierFlags2[ModifierFlags2["Default"] = 512] = "Default";
      ModifierFlags2[ModifierFlags2["Const"] = 2048] = "Const";
      ModifierFlags2[ModifierFlags2["HasComputedJSDocModifiers"] = 4096] = "HasComputedJSDocModifiers";
      ModifierFlags2[ModifierFlags2["Deprecated"] = 8192] = "Deprecated";
      ModifierFlags2[ModifierFlags2["Override"] = 16384] = "Override";
      ModifierFlags2[ModifierFlags2["HasComputedFlags"] = 536870912] = "HasComputedFlags";
      ModifierFlags2[ModifierFlags2["AccessibilityModifier"] = 28] = "AccessibilityModifier";
      ModifierFlags2[ModifierFlags2["ParameterPropertyModifier"] = 16476] = "ParameterPropertyModifier";
      ModifierFlags2[ModifierFlags2["NonPublicAccessibilityModifier"] = 24] = "NonPublicAccessibilityModifier";
      ModifierFlags2[ModifierFlags2["TypeScriptModifier"] = 18654] = "TypeScriptModifier";
      ModifierFlags2[ModifierFlags2["ExportDefault"] = 513] = "ExportDefault";
      ModifierFlags2[ModifierFlags2["All"] = 27647] = "All";
    })(ModifierFlags = ts2.ModifierFlags || (ts2.ModifierFlags = {}));
    var JsxFlags;
    (function(JsxFlags2) {
      JsxFlags2[JsxFlags2["None"] = 0] = "None";
      JsxFlags2[JsxFlags2["IntrinsicNamedElement"] = 1] = "IntrinsicNamedElement";
      JsxFlags2[JsxFlags2["IntrinsicIndexedElement"] = 2] = "IntrinsicIndexedElement";
      JsxFlags2[JsxFlags2["IntrinsicElement"] = 3] = "IntrinsicElement";
    })(JsxFlags = ts2.JsxFlags || (ts2.JsxFlags = {}));
    var RelationComparisonResult;
    (function(RelationComparisonResult2) {
      RelationComparisonResult2[RelationComparisonResult2["Succeeded"] = 1] = "Succeeded";
      RelationComparisonResult2[RelationComparisonResult2["Failed"] = 2] = "Failed";
      RelationComparisonResult2[RelationComparisonResult2["Reported"] = 4] = "Reported";
      RelationComparisonResult2[RelationComparisonResult2["ReportsUnmeasurable"] = 8] = "ReportsUnmeasurable";
      RelationComparisonResult2[RelationComparisonResult2["ReportsUnreliable"] = 16] = "ReportsUnreliable";
      RelationComparisonResult2[RelationComparisonResult2["ReportsMask"] = 24] = "ReportsMask";
    })(RelationComparisonResult = ts2.RelationComparisonResult || (ts2.RelationComparisonResult = {}));
    var GeneratedIdentifierFlags;
    (function(GeneratedIdentifierFlags2) {
      GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["None"] = 0] = "None";
      GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Auto"] = 1] = "Auto";
      GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Loop"] = 2] = "Loop";
      GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Unique"] = 3] = "Unique";
      GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Node"] = 4] = "Node";
      GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["KindMask"] = 7] = "KindMask";
      GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["ReservedInNestedScopes"] = 8] = "ReservedInNestedScopes";
      GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Optimistic"] = 16] = "Optimistic";
      GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["FileLevel"] = 32] = "FileLevel";
      GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["AllowNameSubstitution"] = 64] = "AllowNameSubstitution";
    })(GeneratedIdentifierFlags = ts2.GeneratedIdentifierFlags || (ts2.GeneratedIdentifierFlags = {}));
    var TokenFlags;
    (function(TokenFlags2) {
      TokenFlags2[TokenFlags2["None"] = 0] = "None";
      TokenFlags2[TokenFlags2["PrecedingLineBreak"] = 1] = "PrecedingLineBreak";
      TokenFlags2[TokenFlags2["PrecedingJSDocComment"] = 2] = "PrecedingJSDocComment";
      TokenFlags2[TokenFlags2["Unterminated"] = 4] = "Unterminated";
      TokenFlags2[TokenFlags2["ExtendedUnicodeEscape"] = 8] = "ExtendedUnicodeEscape";
      TokenFlags2[TokenFlags2["Scientific"] = 16] = "Scientific";
      TokenFlags2[TokenFlags2["Octal"] = 32] = "Octal";
      TokenFlags2[TokenFlags2["HexSpecifier"] = 64] = "HexSpecifier";
      TokenFlags2[TokenFlags2["BinarySpecifier"] = 128] = "BinarySpecifier";
      TokenFlags2[TokenFlags2["OctalSpecifier"] = 256] = "OctalSpecifier";
      TokenFlags2[TokenFlags2["ContainsSeparator"] = 512] = "ContainsSeparator";
      TokenFlags2[TokenFlags2["UnicodeEscape"] = 1024] = "UnicodeEscape";
      TokenFlags2[TokenFlags2["ContainsInvalidEscape"] = 2048] = "ContainsInvalidEscape";
      TokenFlags2[TokenFlags2["BinaryOrOctalSpecifier"] = 384] = "BinaryOrOctalSpecifier";
      TokenFlags2[TokenFlags2["NumericLiteralFlags"] = 1008] = "NumericLiteralFlags";
      TokenFlags2[TokenFlags2["TemplateLiteralLikeFlags"] = 2048] = "TemplateLiteralLikeFlags";
    })(TokenFlags = ts2.TokenFlags || (ts2.TokenFlags = {}));
    var FlowFlags;
    (function(FlowFlags2) {
      FlowFlags2[FlowFlags2["Unreachable"] = 1] = "Unreachable";
      FlowFlags2[FlowFlags2["Start"] = 2] = "Start";
      FlowFlags2[FlowFlags2["BranchLabel"] = 4] = "BranchLabel";
      FlowFlags2[FlowFlags2["LoopLabel"] = 8] = "LoopLabel";
      FlowFlags2[FlowFlags2["Assignment"] = 16] = "Assignment";
      FlowFlags2[FlowFlags2["TrueCondition"] = 32] = "TrueCondition";
      FlowFlags2[FlowFlags2["FalseCondition"] = 64] = "FalseCondition";
      FlowFlags2[FlowFlags2["SwitchClause"] = 128] = "SwitchClause";
      FlowFlags2[FlowFlags2["ArrayMutation"] = 256] = "ArrayMutation";
      FlowFlags2[FlowFlags2["Call"] = 512] = "Call";
      FlowFlags2[FlowFlags2["ReduceLabel"] = 1024] = "ReduceLabel";
      FlowFlags2[FlowFlags2["Referenced"] = 2048] = "Referenced";
      FlowFlags2[FlowFlags2["Shared"] = 4096] = "Shared";
      FlowFlags2[FlowFlags2["Label"] = 12] = "Label";
      FlowFlags2[FlowFlags2["Condition"] = 96] = "Condition";
    })(FlowFlags = ts2.FlowFlags || (ts2.FlowFlags = {}));
    var CommentDirectiveType;
    (function(CommentDirectiveType2) {
      CommentDirectiveType2[CommentDirectiveType2["ExpectError"] = 0] = "ExpectError";
      CommentDirectiveType2[CommentDirectiveType2["Ignore"] = 1] = "Ignore";
    })(CommentDirectiveType = ts2.CommentDirectiveType || (ts2.CommentDirectiveType = {}));
    var OperationCanceledException = function() {
      function OperationCanceledException2() {
      }
      return OperationCanceledException2;
    }();
    ts2.OperationCanceledException = OperationCanceledException;
    var FileIncludeKind;
    (function(FileIncludeKind2) {
      FileIncludeKind2[FileIncludeKind2["RootFile"] = 0] = "RootFile";
      FileIncludeKind2[FileIncludeKind2["SourceFromProjectReference"] = 1] = "SourceFromProjectReference";
      FileIncludeKind2[FileIncludeKind2["OutputFromProjectReference"] = 2] = "OutputFromProjectReference";
      FileIncludeKind2[FileIncludeKind2["Import"] = 3] = "Import";
      FileIncludeKind2[FileIncludeKind2["ReferenceFile"] = 4] = "ReferenceFile";
      FileIncludeKind2[FileIncludeKind2["TypeReferenceDirective"] = 5] = "TypeReferenceDirective";
      FileIncludeKind2[FileIncludeKind2["LibFile"] = 6] = "LibFile";
      FileIncludeKind2[FileIncludeKind2["LibReferenceDirective"] = 7] = "LibReferenceDirective";
      FileIncludeKind2[FileIncludeKind2["AutomaticTypeDirectiveFile"] = 8] = "AutomaticTypeDirectiveFile";
    })(FileIncludeKind = ts2.FileIncludeKind || (ts2.FileIncludeKind = {}));
    var FilePreprocessingDiagnosticsKind;
    (function(FilePreprocessingDiagnosticsKind2) {
      FilePreprocessingDiagnosticsKind2[FilePreprocessingDiagnosticsKind2["FilePreprocessingReferencedDiagnostic"] = 0] = "FilePreprocessingReferencedDiagnostic";
      FilePreprocessingDiagnosticsKind2[FilePreprocessingDiagnosticsKind2["FilePreprocessingFileExplainingDiagnostic"] = 1] = "FilePreprocessingFileExplainingDiagnostic";
    })(FilePreprocessingDiagnosticsKind = ts2.FilePreprocessingDiagnosticsKind || (ts2.FilePreprocessingDiagnosticsKind = {}));
    var StructureIsReused;
    (function(StructureIsReused2) {
      StructureIsReused2[StructureIsReused2["Not"] = 0] = "Not";
      StructureIsReused2[StructureIsReused2["SafeModules"] = 1] = "SafeModules";
      StructureIsReused2[StructureIsReused2["Completely"] = 2] = "Completely";
    })(StructureIsReused = ts2.StructureIsReused || (ts2.StructureIsReused = {}));
    var ExitStatus;
    (function(ExitStatus2) {
      ExitStatus2[ExitStatus2["Success"] = 0] = "Success";
      ExitStatus2[ExitStatus2["DiagnosticsPresent_OutputsSkipped"] = 1] = "DiagnosticsPresent_OutputsSkipped";
      ExitStatus2[ExitStatus2["DiagnosticsPresent_OutputsGenerated"] = 2] = "DiagnosticsPresent_OutputsGenerated";
      ExitStatus2[ExitStatus2["InvalidProject_OutputsSkipped"] = 3] = "InvalidProject_OutputsSkipped";
      ExitStatus2[ExitStatus2["ProjectReferenceCycle_OutputsSkipped"] = 4] = "ProjectReferenceCycle_OutputsSkipped";
      ExitStatus2[ExitStatus2["ProjectReferenceCycle_OutputsSkupped"] = 4] = "ProjectReferenceCycle_OutputsSkupped";
    })(ExitStatus = ts2.ExitStatus || (ts2.ExitStatus = {}));
    var UnionReduction;
    (function(UnionReduction2) {
      UnionReduction2[UnionReduction2["None"] = 0] = "None";
      UnionReduction2[UnionReduction2["Literal"] = 1] = "Literal";
      UnionReduction2[UnionReduction2["Subtype"] = 2] = "Subtype";
    })(UnionReduction = ts2.UnionReduction || (ts2.UnionReduction = {}));
    var ContextFlags;
    (function(ContextFlags2) {
      ContextFlags2[ContextFlags2["None"] = 0] = "None";
      ContextFlags2[ContextFlags2["Signature"] = 1] = "Signature";
      ContextFlags2[ContextFlags2["NoConstraints"] = 2] = "NoConstraints";
      ContextFlags2[ContextFlags2["Completions"] = 4] = "Completions";
      ContextFlags2[ContextFlags2["SkipBindingPatterns"] = 8] = "SkipBindingPatterns";
    })(ContextFlags = ts2.ContextFlags || (ts2.ContextFlags = {}));
    var NodeBuilderFlags;
    (function(NodeBuilderFlags2) {
      NodeBuilderFlags2[NodeBuilderFlags2["None"] = 0] = "None";
      NodeBuilderFlags2[NodeBuilderFlags2["NoTruncation"] = 1] = "NoTruncation";
      NodeBuilderFlags2[NodeBuilderFlags2["WriteArrayAsGenericType"] = 2] = "WriteArrayAsGenericType";
      NodeBuilderFlags2[NodeBuilderFlags2["GenerateNamesForShadowedTypeParams"] = 4] = "GenerateNamesForShadowedTypeParams";
      NodeBuilderFlags2[NodeBuilderFlags2["UseStructuralFallback"] = 8] = "UseStructuralFallback";
      NodeBuilderFlags2[NodeBuilderFlags2["ForbidIndexedAccessSymbolReferences"] = 16] = "ForbidIndexedAccessSymbolReferences";
      NodeBuilderFlags2[NodeBuilderFlags2["WriteTypeArgumentsOfSignature"] = 32] = "WriteTypeArgumentsOfSignature";
      NodeBuilderFlags2[NodeBuilderFlags2["UseFullyQualifiedType"] = 64] = "UseFullyQualifiedType";
      NodeBuilderFlags2[NodeBuilderFlags2["UseOnlyExternalAliasing"] = 128] = "UseOnlyExternalAliasing";
      NodeBuilderFlags2[NodeBuilderFlags2["SuppressAnyReturnType"] = 256] = "SuppressAnyReturnType";
      NodeBuilderFlags2[NodeBuilderFlags2["WriteTypeParametersInQualifiedName"] = 512] = "WriteTypeParametersInQualifiedName";
      NodeBuilderFlags2[NodeBuilderFlags2["MultilineObjectLiterals"] = 1024] = "MultilineObjectLiterals";
      NodeBuilderFlags2[NodeBuilderFlags2["WriteClassExpressionAsTypeLiteral"] = 2048] = "WriteClassExpressionAsTypeLiteral";
      NodeBuilderFlags2[NodeBuilderFlags2["UseTypeOfFunction"] = 4096] = "UseTypeOfFunction";
      NodeBuilderFlags2[NodeBuilderFlags2["OmitParameterModifiers"] = 8192] = "OmitParameterModifiers";
      NodeBuilderFlags2[NodeBuilderFlags2["UseAliasDefinedOutsideCurrentScope"] = 16384] = "UseAliasDefinedOutsideCurrentScope";
      NodeBuilderFlags2[NodeBuilderFlags2["UseSingleQuotesForStringLiteralType"] = 268435456] = "UseSingleQuotesForStringLiteralType";
      NodeBuilderFlags2[NodeBuilderFlags2["NoTypeReduction"] = 536870912] = "NoTypeReduction";
      NodeBuilderFlags2[NodeBuilderFlags2["NoUndefinedOptionalParameterType"] = 1073741824] = "NoUndefinedOptionalParameterType";
      NodeBuilderFlags2[NodeBuilderFlags2["AllowThisInObjectLiteral"] = 32768] = "AllowThisInObjectLiteral";
      NodeBuilderFlags2[NodeBuilderFlags2["AllowQualifiedNameInPlaceOfIdentifier"] = 65536] = "AllowQualifiedNameInPlaceOfIdentifier";
      NodeBuilderFlags2[NodeBuilderFlags2["AllowQualifedNameInPlaceOfIdentifier"] = 65536] = "AllowQualifedNameInPlaceOfIdentifier";
      NodeBuilderFlags2[NodeBuilderFlags2["AllowAnonymousIdentifier"] = 131072] = "AllowAnonymousIdentifier";
      NodeBuilderFlags2[NodeBuilderFlags2["AllowEmptyUnionOrIntersection"] = 262144] = "AllowEmptyUnionOrIntersection";
      NodeBuilderFlags2[NodeBuilderFlags2["AllowEmptyTuple"] = 524288] = "AllowEmptyTuple";
      NodeBuilderFlags2[NodeBuilderFlags2["AllowUniqueESSymbolType"] = 1048576] = "AllowUniqueESSymbolType";
      NodeBuilderFlags2[NodeBuilderFlags2["AllowEmptyIndexInfoType"] = 2097152] = "AllowEmptyIndexInfoType";
      NodeBuilderFlags2[NodeBuilderFlags2["AllowNodeModulesRelativePaths"] = 67108864] = "AllowNodeModulesRelativePaths";
      NodeBuilderFlags2[NodeBuilderFlags2["DoNotIncludeSymbolChain"] = 134217728] = "DoNotIncludeSymbolChain";
      NodeBuilderFlags2[NodeBuilderFlags2["IgnoreErrors"] = 70221824] = "IgnoreErrors";
      NodeBuilderFlags2[NodeBuilderFlags2["InObjectTypeLiteral"] = 4194304] = "InObjectTypeLiteral";
      NodeBuilderFlags2[NodeBuilderFlags2["InTypeAlias"] = 8388608] = "InTypeAlias";
      NodeBuilderFlags2[NodeBuilderFlags2["InInitialEntityName"] = 16777216] = "InInitialEntityName";
    })(NodeBuilderFlags = ts2.NodeBuilderFlags || (ts2.NodeBuilderFlags = {}));
    var TypeFormatFlags;
    (function(TypeFormatFlags2) {
      TypeFormatFlags2[TypeFormatFlags2["None"] = 0] = "None";
      TypeFormatFlags2[TypeFormatFlags2["NoTruncation"] = 1] = "NoTruncation";
      TypeFormatFlags2[TypeFormatFlags2["WriteArrayAsGenericType"] = 2] = "WriteArrayAsGenericType";
      TypeFormatFlags2[TypeFormatFlags2["UseStructuralFallback"] = 8] = "UseStructuralFallback";
      TypeFormatFlags2[TypeFormatFlags2["WriteTypeArgumentsOfSignature"] = 32] = "WriteTypeArgumentsOfSignature";
      TypeFormatFlags2[TypeFormatFlags2["UseFullyQualifiedType"] = 64] = "UseFullyQualifiedType";
      TypeFormatFlags2[TypeFormatFlags2["SuppressAnyReturnType"] = 256] = "SuppressAnyReturnType";
      TypeFormatFlags2[TypeFormatFlags2["MultilineObjectLiterals"] = 1024] = "MultilineObjectLiterals";
      TypeFormatFlags2[TypeFormatFlags2["WriteClassExpressionAsTypeLiteral"] = 2048] = "WriteClassExpressionAsTypeLiteral";
      TypeFormatFlags2[TypeFormatFlags2["UseTypeOfFunction"] = 4096] = "UseTypeOfFunction";
      TypeFormatFlags2[TypeFormatFlags2["OmitParameterModifiers"] = 8192] = "OmitParameterModifiers";
      TypeFormatFlags2[TypeFormatFlags2["UseAliasDefinedOutsideCurrentScope"] = 16384] = "UseAliasDefinedOutsideCurrentScope";
      TypeFormatFlags2[TypeFormatFlags2["UseSingleQuotesForStringLiteralType"] = 268435456] = "UseSingleQuotesForStringLiteralType";
      TypeFormatFlags2[TypeFormatFlags2["NoTypeReduction"] = 536870912] = "NoTypeReduction";
      TypeFormatFlags2[TypeFormatFlags2["AllowUniqueESSymbolType"] = 1048576] = "AllowUniqueESSymbolType";
      TypeFormatFlags2[TypeFormatFlags2["AddUndefined"] = 131072] = "AddUndefined";
      TypeFormatFlags2[TypeFormatFlags2["WriteArrowStyleSignature"] = 262144] = "WriteArrowStyleSignature";
      TypeFormatFlags2[TypeFormatFlags2["InArrayType"] = 524288] = "InArrayType";
      TypeFormatFlags2[TypeFormatFlags2["InElementType"] = 2097152] = "InElementType";
      TypeFormatFlags2[TypeFormatFlags2["InFirstTypeArgument"] = 4194304] = "InFirstTypeArgument";
      TypeFormatFlags2[TypeFormatFlags2["InTypeAlias"] = 8388608] = "InTypeAlias";
      TypeFormatFlags2[TypeFormatFlags2["WriteOwnNameForAnyLike"] = 0] = "WriteOwnNameForAnyLike";
      TypeFormatFlags2[TypeFormatFlags2["NodeBuilderFlagsMask"] = 814775659] = "NodeBuilderFlagsMask";
    })(TypeFormatFlags = ts2.TypeFormatFlags || (ts2.TypeFormatFlags = {}));
    var SymbolFormatFlags;
    (function(SymbolFormatFlags2) {
      SymbolFormatFlags2[SymbolFormatFlags2["None"] = 0] = "None";
      SymbolFormatFlags2[SymbolFormatFlags2["WriteTypeParametersOrArguments"] = 1] = "WriteTypeParametersOrArguments";
      SymbolFormatFlags2[SymbolFormatFlags2["UseOnlyExternalAliasing"] = 2] = "UseOnlyExternalAliasing";
      SymbolFormatFlags2[SymbolFormatFlags2["AllowAnyNodeKind"] = 4] = "AllowAnyNodeKind";
      SymbolFormatFlags2[SymbolFormatFlags2["UseAliasDefinedOutsideCurrentScope"] = 8] = "UseAliasDefinedOutsideCurrentScope";
      SymbolFormatFlags2[SymbolFormatFlags2["DoNotIncludeSymbolChain"] = 16] = "DoNotIncludeSymbolChain";
    })(SymbolFormatFlags = ts2.SymbolFormatFlags || (ts2.SymbolFormatFlags = {}));
    var SymbolAccessibility;
    (function(SymbolAccessibility2) {
      SymbolAccessibility2[SymbolAccessibility2["Accessible"] = 0] = "Accessible";
      SymbolAccessibility2[SymbolAccessibility2["NotAccessible"] = 1] = "NotAccessible";
      SymbolAccessibility2[SymbolAccessibility2["CannotBeNamed"] = 2] = "CannotBeNamed";
    })(SymbolAccessibility = ts2.SymbolAccessibility || (ts2.SymbolAccessibility = {}));
    var SyntheticSymbolKind;
    (function(SyntheticSymbolKind2) {
      SyntheticSymbolKind2[SyntheticSymbolKind2["UnionOrIntersection"] = 0] = "UnionOrIntersection";
      SyntheticSymbolKind2[SyntheticSymbolKind2["Spread"] = 1] = "Spread";
    })(SyntheticSymbolKind = ts2.SyntheticSymbolKind || (ts2.SyntheticSymbolKind = {}));
    var TypePredicateKind;
    (function(TypePredicateKind2) {
      TypePredicateKind2[TypePredicateKind2["This"] = 0] = "This";
      TypePredicateKind2[TypePredicateKind2["Identifier"] = 1] = "Identifier";
      TypePredicateKind2[TypePredicateKind2["AssertsThis"] = 2] = "AssertsThis";
      TypePredicateKind2[TypePredicateKind2["AssertsIdentifier"] = 3] = "AssertsIdentifier";
    })(TypePredicateKind = ts2.TypePredicateKind || (ts2.TypePredicateKind = {}));
    var TypeReferenceSerializationKind;
    (function(TypeReferenceSerializationKind2) {
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["Unknown"] = 0] = "Unknown";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["TypeWithConstructSignatureAndValue"] = 1] = "TypeWithConstructSignatureAndValue";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["VoidNullableOrNeverType"] = 2] = "VoidNullableOrNeverType";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["NumberLikeType"] = 3] = "NumberLikeType";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["BigIntLikeType"] = 4] = "BigIntLikeType";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["StringLikeType"] = 5] = "StringLikeType";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["BooleanType"] = 6] = "BooleanType";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["ArrayLikeType"] = 7] = "ArrayLikeType";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["ESSymbolType"] = 8] = "ESSymbolType";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["Promise"] = 9] = "Promise";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["TypeWithCallSignature"] = 10] = "TypeWithCallSignature";
      TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["ObjectType"] = 11] = "ObjectType";
    })(TypeReferenceSerializationKind = ts2.TypeReferenceSerializationKind || (ts2.TypeReferenceSerializationKind = {}));
    var SymbolFlags;
    (function(SymbolFlags2) {
      SymbolFlags2[SymbolFlags2["None"] = 0] = "None";
      SymbolFlags2[SymbolFlags2["FunctionScopedVariable"] = 1] = "FunctionScopedVariable";
      SymbolFlags2[SymbolFlags2["BlockScopedVariable"] = 2] = "BlockScopedVariable";
      SymbolFlags2[SymbolFlags2["Property"] = 4] = "Property";
      SymbolFlags2[SymbolFlags2["EnumMember"] = 8] = "EnumMember";
      SymbolFlags2[SymbolFlags2["Function"] = 16] = "Function";
      SymbolFlags2[SymbolFlags2["Class"] = 32] = "Class";
      SymbolFlags2[SymbolFlags2["Interface"] = 64] = "Interface";
      SymbolFlags2[SymbolFlags2["ConstEnum"] = 128] = "ConstEnum";
      SymbolFlags2[SymbolFlags2["RegularEnum"] = 256] = "RegularEnum";
      SymbolFlags2[SymbolFlags2["ValueModule"] = 512] = "ValueModule";
      SymbolFlags2[SymbolFlags2["NamespaceModule"] = 1024] = "NamespaceModule";
      SymbolFlags2[SymbolFlags2["TypeLiteral"] = 2048] = "TypeLiteral";
      SymbolFlags2[SymbolFlags2["ObjectLiteral"] = 4096] = "ObjectLiteral";
      SymbolFlags2[SymbolFlags2["Method"] = 8192] = "Method";
      SymbolFlags2[SymbolFlags2["Constructor"] = 16384] = "Constructor";
      SymbolFlags2[SymbolFlags2["GetAccessor"] = 32768] = "GetAccessor";
      SymbolFlags2[SymbolFlags2["SetAccessor"] = 65536] = "SetAccessor";
      SymbolFlags2[SymbolFlags2["Signature"] = 131072] = "Signature";
      SymbolFlags2[SymbolFlags2["TypeParameter"] = 262144] = "TypeParameter";
      SymbolFlags2[SymbolFlags2["TypeAlias"] = 524288] = "TypeAlias";
      SymbolFlags2[SymbolFlags2["ExportValue"] = 1048576] = "ExportValue";
      SymbolFlags2[SymbolFlags2["Alias"] = 2097152] = "Alias";
      SymbolFlags2[SymbolFlags2["Prototype"] = 4194304] = "Prototype";
      SymbolFlags2[SymbolFlags2["ExportStar"] = 8388608] = "ExportStar";
      SymbolFlags2[SymbolFlags2["Optional"] = 16777216] = "Optional";
      SymbolFlags2[SymbolFlags2["Transient"] = 33554432] = "Transient";
      SymbolFlags2[SymbolFlags2["Assignment"] = 67108864] = "Assignment";
      SymbolFlags2[SymbolFlags2["ModuleExports"] = 134217728] = "ModuleExports";
      SymbolFlags2[SymbolFlags2["All"] = 67108863] = "All";
      SymbolFlags2[SymbolFlags2["Enum"] = 384] = "Enum";
      SymbolFlags2[SymbolFlags2["Variable"] = 3] = "Variable";
      SymbolFlags2[SymbolFlags2["Value"] = 111551] = "Value";
      SymbolFlags2[SymbolFlags2["Type"] = 788968] = "Type";
      SymbolFlags2[SymbolFlags2["Namespace"] = 1920] = "Namespace";
      SymbolFlags2[SymbolFlags2["Module"] = 1536] = "Module";
      SymbolFlags2[SymbolFlags2["Accessor"] = 98304] = "Accessor";
      SymbolFlags2[SymbolFlags2["FunctionScopedVariableExcludes"] = 111550] = "FunctionScopedVariableExcludes";
      SymbolFlags2[SymbolFlags2["BlockScopedVariableExcludes"] = 111551] = "BlockScopedVariableExcludes";
      SymbolFlags2[SymbolFlags2["ParameterExcludes"] = 111551] = "ParameterExcludes";
      SymbolFlags2[SymbolFlags2["PropertyExcludes"] = 0] = "PropertyExcludes";
      SymbolFlags2[SymbolFlags2["EnumMemberExcludes"] = 900095] = "EnumMemberExcludes";
      SymbolFlags2[SymbolFlags2["FunctionExcludes"] = 110991] = "FunctionExcludes";
      SymbolFlags2[SymbolFlags2["ClassExcludes"] = 899503] = "ClassExcludes";
      SymbolFlags2[SymbolFlags2["InterfaceExcludes"] = 788872] = "InterfaceExcludes";
      SymbolFlags2[SymbolFlags2["RegularEnumExcludes"] = 899327] = "RegularEnumExcludes";
      SymbolFlags2[SymbolFlags2["ConstEnumExcludes"] = 899967] = "ConstEnumExcludes";
      SymbolFlags2[SymbolFlags2["ValueModuleExcludes"] = 110735] = "ValueModuleExcludes";
      SymbolFlags2[SymbolFlags2["NamespaceModuleExcludes"] = 0] = "NamespaceModuleExcludes";
      SymbolFlags2[SymbolFlags2["MethodExcludes"] = 103359] = "MethodExcludes";
      SymbolFlags2[SymbolFlags2["GetAccessorExcludes"] = 46015] = "GetAccessorExcludes";
      SymbolFlags2[SymbolFlags2["SetAccessorExcludes"] = 78783] = "SetAccessorExcludes";
      SymbolFlags2[SymbolFlags2["TypeParameterExcludes"] = 526824] = "TypeParameterExcludes";
      SymbolFlags2[SymbolFlags2["TypeAliasExcludes"] = 788968] = "TypeAliasExcludes";
      SymbolFlags2[SymbolFlags2["AliasExcludes"] = 2097152] = "AliasExcludes";
      SymbolFlags2[SymbolFlags2["ModuleMember"] = 2623475] = "ModuleMember";
      SymbolFlags2[SymbolFlags2["ExportHasLocal"] = 944] = "ExportHasLocal";
      SymbolFlags2[SymbolFlags2["BlockScoped"] = 418] = "BlockScoped";
      SymbolFlags2[SymbolFlags2["PropertyOrAccessor"] = 98308] = "PropertyOrAccessor";
      SymbolFlags2[SymbolFlags2["ClassMember"] = 106500] = "ClassMember";
      SymbolFlags2[SymbolFlags2["ExportSupportsDefaultModifier"] = 112] = "ExportSupportsDefaultModifier";
      SymbolFlags2[SymbolFlags2["ExportDoesNotSupportDefaultModifier"] = -113] = "ExportDoesNotSupportDefaultModifier";
      SymbolFlags2[SymbolFlags2["Classifiable"] = 2885600] = "Classifiable";
      SymbolFlags2[SymbolFlags2["LateBindingContainer"] = 6256] = "LateBindingContainer";
    })(SymbolFlags = ts2.SymbolFlags || (ts2.SymbolFlags = {}));
    var EnumKind;
    (function(EnumKind2) {
      EnumKind2[EnumKind2["Numeric"] = 0] = "Numeric";
      EnumKind2[EnumKind2["Literal"] = 1] = "Literal";
    })(EnumKind = ts2.EnumKind || (ts2.EnumKind = {}));
    var CheckFlags;
    (function(CheckFlags2) {
      CheckFlags2[CheckFlags2["Instantiated"] = 1] = "Instantiated";
      CheckFlags2[CheckFlags2["SyntheticProperty"] = 2] = "SyntheticProperty";
      CheckFlags2[CheckFlags2["SyntheticMethod"] = 4] = "SyntheticMethod";
      CheckFlags2[CheckFlags2["Readonly"] = 8] = "Readonly";
      CheckFlags2[CheckFlags2["ReadPartial"] = 16] = "ReadPartial";
      CheckFlags2[CheckFlags2["WritePartial"] = 32] = "WritePartial";
      CheckFlags2[CheckFlags2["HasNonUniformType"] = 64] = "HasNonUniformType";
      CheckFlags2[CheckFlags2["HasLiteralType"] = 128] = "HasLiteralType";
      CheckFlags2[CheckFlags2["ContainsPublic"] = 256] = "ContainsPublic";
      CheckFlags2[CheckFlags2["ContainsProtected"] = 512] = "ContainsProtected";
      CheckFlags2[CheckFlags2["ContainsPrivate"] = 1024] = "ContainsPrivate";
      CheckFlags2[CheckFlags2["ContainsStatic"] = 2048] = "ContainsStatic";
      CheckFlags2[CheckFlags2["Late"] = 4096] = "Late";
      CheckFlags2[CheckFlags2["ReverseMapped"] = 8192] = "ReverseMapped";
      CheckFlags2[CheckFlags2["OptionalParameter"] = 16384] = "OptionalParameter";
      CheckFlags2[CheckFlags2["RestParameter"] = 32768] = "RestParameter";
      CheckFlags2[CheckFlags2["DeferredType"] = 65536] = "DeferredType";
      CheckFlags2[CheckFlags2["HasNeverType"] = 131072] = "HasNeverType";
      CheckFlags2[CheckFlags2["Mapped"] = 262144] = "Mapped";
      CheckFlags2[CheckFlags2["StripOptional"] = 524288] = "StripOptional";
      CheckFlags2[CheckFlags2["Synthetic"] = 6] = "Synthetic";
      CheckFlags2[CheckFlags2["Discriminant"] = 192] = "Discriminant";
      CheckFlags2[CheckFlags2["Partial"] = 48] = "Partial";
    })(CheckFlags = ts2.CheckFlags || (ts2.CheckFlags = {}));
    var InternalSymbolName;
    (function(InternalSymbolName2) {
      InternalSymbolName2["Call"] = "__call";
      InternalSymbolName2["Constructor"] = "__constructor";
      InternalSymbolName2["New"] = "__new";
      InternalSymbolName2["Index"] = "__index";
      InternalSymbolName2["ExportStar"] = "__export";
      InternalSymbolName2["Global"] = "__global";
      InternalSymbolName2["Missing"] = "__missing";
      InternalSymbolName2["Type"] = "__type";
      InternalSymbolName2["Object"] = "__object";
      InternalSymbolName2["JSXAttributes"] = "__jsxAttributes";
      InternalSymbolName2["Class"] = "__class";
      InternalSymbolName2["Function"] = "__function";
      InternalSymbolName2["Computed"] = "__computed";
      InternalSymbolName2["Resolving"] = "__resolving__";
      InternalSymbolName2["ExportEquals"] = "export=";
      InternalSymbolName2["Default"] = "default";
      InternalSymbolName2["This"] = "this";
    })(InternalSymbolName = ts2.InternalSymbolName || (ts2.InternalSymbolName = {}));
    var NodeCheckFlags;
    (function(NodeCheckFlags2) {
      NodeCheckFlags2[NodeCheckFlags2["TypeChecked"] = 1] = "TypeChecked";
      NodeCheckFlags2[NodeCheckFlags2["LexicalThis"] = 2] = "LexicalThis";
      NodeCheckFlags2[NodeCheckFlags2["CaptureThis"] = 4] = "CaptureThis";
      NodeCheckFlags2[NodeCheckFlags2["CaptureNewTarget"] = 8] = "CaptureNewTarget";
      NodeCheckFlags2[NodeCheckFlags2["SuperInstance"] = 256] = "SuperInstance";
      NodeCheckFlags2[NodeCheckFlags2["SuperStatic"] = 512] = "SuperStatic";
      NodeCheckFlags2[NodeCheckFlags2["ContextChecked"] = 1024] = "ContextChecked";
      NodeCheckFlags2[NodeCheckFlags2["AsyncMethodWithSuper"] = 2048] = "AsyncMethodWithSuper";
      NodeCheckFlags2[NodeCheckFlags2["AsyncMethodWithSuperBinding"] = 4096] = "AsyncMethodWithSuperBinding";
      NodeCheckFlags2[NodeCheckFlags2["CaptureArguments"] = 8192] = "CaptureArguments";
      NodeCheckFlags2[NodeCheckFlags2["EnumValuesComputed"] = 16384] = "EnumValuesComputed";
      NodeCheckFlags2[NodeCheckFlags2["LexicalModuleMergesWithClass"] = 32768] = "LexicalModuleMergesWithClass";
      NodeCheckFlags2[NodeCheckFlags2["LoopWithCapturedBlockScopedBinding"] = 65536] = "LoopWithCapturedBlockScopedBinding";
      NodeCheckFlags2[NodeCheckFlags2["ContainsCapturedBlockScopeBinding"] = 131072] = "ContainsCapturedBlockScopeBinding";
      NodeCheckFlags2[NodeCheckFlags2["CapturedBlockScopedBinding"] = 262144] = "CapturedBlockScopedBinding";
      NodeCheckFlags2[NodeCheckFlags2["BlockScopedBindingInLoop"] = 524288] = "BlockScopedBindingInLoop";
      NodeCheckFlags2[NodeCheckFlags2["ClassWithBodyScopedClassBinding"] = 1048576] = "ClassWithBodyScopedClassBinding";
      NodeCheckFlags2[NodeCheckFlags2["BodyScopedClassBinding"] = 2097152] = "BodyScopedClassBinding";
      NodeCheckFlags2[NodeCheckFlags2["NeedsLoopOutParameter"] = 4194304] = "NeedsLoopOutParameter";
      NodeCheckFlags2[NodeCheckFlags2["AssignmentsMarked"] = 8388608] = "AssignmentsMarked";
      NodeCheckFlags2[NodeCheckFlags2["ClassWithConstructorReference"] = 16777216] = "ClassWithConstructorReference";
      NodeCheckFlags2[NodeCheckFlags2["ConstructorReferenceInClass"] = 33554432] = "ConstructorReferenceInClass";
      NodeCheckFlags2[NodeCheckFlags2["ContainsClassWithPrivateIdentifiers"] = 67108864] = "ContainsClassWithPrivateIdentifiers";
      NodeCheckFlags2[NodeCheckFlags2["ContainsSuperPropertyInStaticInitializer"] = 134217728] = "ContainsSuperPropertyInStaticInitializer";
    })(NodeCheckFlags = ts2.NodeCheckFlags || (ts2.NodeCheckFlags = {}));
    var TypeFlags;
    (function(TypeFlags2) {
      TypeFlags2[TypeFlags2["Any"] = 1] = "Any";
      TypeFlags2[TypeFlags2["Unknown"] = 2] = "Unknown";
      TypeFlags2[TypeFlags2["String"] = 4] = "String";
      TypeFlags2[TypeFlags2["Number"] = 8] = "Number";
      TypeFlags2[TypeFlags2["Boolean"] = 16] = "Boolean";
      TypeFlags2[TypeFlags2["Enum"] = 32] = "Enum";
      TypeFlags2[TypeFlags2["BigInt"] = 64] = "BigInt";
      TypeFlags2[TypeFlags2["StringLiteral"] = 128] = "StringLiteral";
      TypeFlags2[TypeFlags2["NumberLiteral"] = 256] = "NumberLiteral";
      TypeFlags2[TypeFlags2["BooleanLiteral"] = 512] = "BooleanLiteral";
      TypeFlags2[TypeFlags2["EnumLiteral"] = 1024] = "EnumLiteral";
      TypeFlags2[TypeFlags2["BigIntLiteral"] = 2048] = "BigIntLiteral";
      TypeFlags2[TypeFlags2["ESSymbol"] = 4096] = "ESSymbol";
      TypeFlags2[TypeFlags2["UniqueESSymbol"] = 8192] = "UniqueESSymbol";
      TypeFlags2[TypeFlags2["Void"] = 16384] = "Void";
      TypeFlags2[TypeFlags2["Undefined"] = 32768] = "Undefined";
      TypeFlags2[TypeFlags2["Null"] = 65536] = "Null";
      TypeFlags2[TypeFlags2["Never"] = 131072] = "Never";
      TypeFlags2[TypeFlags2["TypeParameter"] = 262144] = "TypeParameter";
      TypeFlags2[TypeFlags2["Object"] = 524288] = "Object";
      TypeFlags2[TypeFlags2["Union"] = 1048576] = "Union";
      TypeFlags2[TypeFlags2["Intersection"] = 2097152] = "Intersection";
      TypeFlags2[TypeFlags2["Index"] = 4194304] = "Index";
      TypeFlags2[TypeFlags2["IndexedAccess"] = 8388608] = "IndexedAccess";
      TypeFlags2[TypeFlags2["Conditional"] = 16777216] = "Conditional";
      TypeFlags2[TypeFlags2["Substitution"] = 33554432] = "Substitution";
      TypeFlags2[TypeFlags2["NonPrimitive"] = 67108864] = "NonPrimitive";
      TypeFlags2[TypeFlags2["TemplateLiteral"] = 134217728] = "TemplateLiteral";
      TypeFlags2[TypeFlags2["StringMapping"] = 268435456] = "StringMapping";
      TypeFlags2[TypeFlags2["AnyOrUnknown"] = 3] = "AnyOrUnknown";
      TypeFlags2[TypeFlags2["Nullable"] = 98304] = "Nullable";
      TypeFlags2[TypeFlags2["Literal"] = 2944] = "Literal";
      TypeFlags2[TypeFlags2["Unit"] = 109440] = "Unit";
      TypeFlags2[TypeFlags2["StringOrNumberLiteral"] = 384] = "StringOrNumberLiteral";
      TypeFlags2[TypeFlags2["StringOrNumberLiteralOrUnique"] = 8576] = "StringOrNumberLiteralOrUnique";
      TypeFlags2[TypeFlags2["DefinitelyFalsy"] = 117632] = "DefinitelyFalsy";
      TypeFlags2[TypeFlags2["PossiblyFalsy"] = 117724] = "PossiblyFalsy";
      TypeFlags2[TypeFlags2["Intrinsic"] = 67359327] = "Intrinsic";
      TypeFlags2[TypeFlags2["Primitive"] = 131068] = "Primitive";
      TypeFlags2[TypeFlags2["StringLike"] = 402653316] = "StringLike";
      TypeFlags2[TypeFlags2["NumberLike"] = 296] = "NumberLike";
      TypeFlags2[TypeFlags2["BigIntLike"] = 2112] = "BigIntLike";
      TypeFlags2[TypeFlags2["BooleanLike"] = 528] = "BooleanLike";
      TypeFlags2[TypeFlags2["EnumLike"] = 1056] = "EnumLike";
      TypeFlags2[TypeFlags2["ESSymbolLike"] = 12288] = "ESSymbolLike";
      TypeFlags2[TypeFlags2["VoidLike"] = 49152] = "VoidLike";
      TypeFlags2[TypeFlags2["DisjointDomains"] = 469892092] = "DisjointDomains";
      TypeFlags2[TypeFlags2["UnionOrIntersection"] = 3145728] = "UnionOrIntersection";
      TypeFlags2[TypeFlags2["StructuredType"] = 3670016] = "StructuredType";
      TypeFlags2[TypeFlags2["TypeVariable"] = 8650752] = "TypeVariable";
      TypeFlags2[TypeFlags2["InstantiableNonPrimitive"] = 58982400] = "InstantiableNonPrimitive";
      TypeFlags2[TypeFlags2["InstantiablePrimitive"] = 406847488] = "InstantiablePrimitive";
      TypeFlags2[TypeFlags2["Instantiable"] = 465829888] = "Instantiable";
      TypeFlags2[TypeFlags2["StructuredOrInstantiable"] = 469499904] = "StructuredOrInstantiable";
      TypeFlags2[TypeFlags2["ObjectFlagsType"] = 3899393] = "ObjectFlagsType";
      TypeFlags2[TypeFlags2["Simplifiable"] = 25165824] = "Simplifiable";
      TypeFlags2[TypeFlags2["Singleton"] = 67358815] = "Singleton";
      TypeFlags2[TypeFlags2["Narrowable"] = 536624127] = "Narrowable";
      TypeFlags2[TypeFlags2["NotPrimitiveUnion"] = 468598819] = "NotPrimitiveUnion";
      TypeFlags2[TypeFlags2["IncludesMask"] = 205258751] = "IncludesMask";
      TypeFlags2[TypeFlags2["IncludesStructuredOrInstantiable"] = 262144] = "IncludesStructuredOrInstantiable";
      TypeFlags2[TypeFlags2["IncludesNonWideningType"] = 4194304] = "IncludesNonWideningType";
      TypeFlags2[TypeFlags2["IncludesWildcard"] = 8388608] = "IncludesWildcard";
      TypeFlags2[TypeFlags2["IncludesEmptyObject"] = 16777216] = "IncludesEmptyObject";
    })(TypeFlags = ts2.TypeFlags || (ts2.TypeFlags = {}));
    var ObjectFlags;
    (function(ObjectFlags2) {
      ObjectFlags2[ObjectFlags2["Class"] = 1] = "Class";
      ObjectFlags2[ObjectFlags2["Interface"] = 2] = "Interface";
      ObjectFlags2[ObjectFlags2["Reference"] = 4] = "Reference";
      ObjectFlags2[ObjectFlags2["Tuple"] = 8] = "Tuple";
      ObjectFlags2[ObjectFlags2["Anonymous"] = 16] = "Anonymous";
      ObjectFlags2[ObjectFlags2["Mapped"] = 32] = "Mapped";
      ObjectFlags2[ObjectFlags2["Instantiated"] = 64] = "Instantiated";
      ObjectFlags2[ObjectFlags2["ObjectLiteral"] = 128] = "ObjectLiteral";
      ObjectFlags2[ObjectFlags2["EvolvingArray"] = 256] = "EvolvingArray";
      ObjectFlags2[ObjectFlags2["ObjectLiteralPatternWithComputedProperties"] = 512] = "ObjectLiteralPatternWithComputedProperties";
      ObjectFlags2[ObjectFlags2["ReverseMapped"] = 1024] = "ReverseMapped";
      ObjectFlags2[ObjectFlags2["JsxAttributes"] = 2048] = "JsxAttributes";
      ObjectFlags2[ObjectFlags2["MarkerType"] = 4096] = "MarkerType";
      ObjectFlags2[ObjectFlags2["JSLiteral"] = 8192] = "JSLiteral";
      ObjectFlags2[ObjectFlags2["FreshLiteral"] = 16384] = "FreshLiteral";
      ObjectFlags2[ObjectFlags2["ArrayLiteral"] = 32768] = "ArrayLiteral";
      ObjectFlags2[ObjectFlags2["PrimitiveUnion"] = 65536] = "PrimitiveUnion";
      ObjectFlags2[ObjectFlags2["ContainsWideningType"] = 131072] = "ContainsWideningType";
      ObjectFlags2[ObjectFlags2["ContainsObjectOrArrayLiteral"] = 262144] = "ContainsObjectOrArrayLiteral";
      ObjectFlags2[ObjectFlags2["NonInferrableType"] = 524288] = "NonInferrableType";
      ObjectFlags2[ObjectFlags2["CouldContainTypeVariablesComputed"] = 1048576] = "CouldContainTypeVariablesComputed";
      ObjectFlags2[ObjectFlags2["CouldContainTypeVariables"] = 2097152] = "CouldContainTypeVariables";
      ObjectFlags2[ObjectFlags2["ClassOrInterface"] = 3] = "ClassOrInterface";
      ObjectFlags2[ObjectFlags2["RequiresWidening"] = 393216] = "RequiresWidening";
      ObjectFlags2[ObjectFlags2["PropagatingFlags"] = 917504] = "PropagatingFlags";
      ObjectFlags2[ObjectFlags2["ObjectTypeKindMask"] = 1343] = "ObjectTypeKindMask";
      ObjectFlags2[ObjectFlags2["ContainsSpread"] = 4194304] = "ContainsSpread";
      ObjectFlags2[ObjectFlags2["ObjectRestType"] = 8388608] = "ObjectRestType";
      ObjectFlags2[ObjectFlags2["IsClassInstanceClone"] = 16777216] = "IsClassInstanceClone";
      ObjectFlags2[ObjectFlags2["IdenticalBaseTypeCalculated"] = 33554432] = "IdenticalBaseTypeCalculated";
      ObjectFlags2[ObjectFlags2["IdenticalBaseTypeExists"] = 67108864] = "IdenticalBaseTypeExists";
      ObjectFlags2[ObjectFlags2["IsGenericTypeComputed"] = 4194304] = "IsGenericTypeComputed";
      ObjectFlags2[ObjectFlags2["IsGenericObjectType"] = 8388608] = "IsGenericObjectType";
      ObjectFlags2[ObjectFlags2["IsGenericIndexType"] = 16777216] = "IsGenericIndexType";
      ObjectFlags2[ObjectFlags2["IsGenericType"] = 25165824] = "IsGenericType";
      ObjectFlags2[ObjectFlags2["ContainsIntersections"] = 33554432] = "ContainsIntersections";
      ObjectFlags2[ObjectFlags2["IsNeverIntersectionComputed"] = 33554432] = "IsNeverIntersectionComputed";
      ObjectFlags2[ObjectFlags2["IsNeverIntersection"] = 67108864] = "IsNeverIntersection";
    })(ObjectFlags = ts2.ObjectFlags || (ts2.ObjectFlags = {}));
    var VarianceFlags;
    (function(VarianceFlags2) {
      VarianceFlags2[VarianceFlags2["Invariant"] = 0] = "Invariant";
      VarianceFlags2[VarianceFlags2["Covariant"] = 1] = "Covariant";
      VarianceFlags2[VarianceFlags2["Contravariant"] = 2] = "Contravariant";
      VarianceFlags2[VarianceFlags2["Bivariant"] = 3] = "Bivariant";
      VarianceFlags2[VarianceFlags2["Independent"] = 4] = "Independent";
      VarianceFlags2[VarianceFlags2["VarianceMask"] = 7] = "VarianceMask";
      VarianceFlags2[VarianceFlags2["Unmeasurable"] = 8] = "Unmeasurable";
      VarianceFlags2[VarianceFlags2["Unreliable"] = 16] = "Unreliable";
      VarianceFlags2[VarianceFlags2["AllowsStructuralFallback"] = 24] = "AllowsStructuralFallback";
    })(VarianceFlags = ts2.VarianceFlags || (ts2.VarianceFlags = {}));
    var ElementFlags;
    (function(ElementFlags2) {
      ElementFlags2[ElementFlags2["Required"] = 1] = "Required";
      ElementFlags2[ElementFlags2["Optional"] = 2] = "Optional";
      ElementFlags2[ElementFlags2["Rest"] = 4] = "Rest";
      ElementFlags2[ElementFlags2["Variadic"] = 8] = "Variadic";
      ElementFlags2[ElementFlags2["Fixed"] = 3] = "Fixed";
      ElementFlags2[ElementFlags2["Variable"] = 12] = "Variable";
      ElementFlags2[ElementFlags2["NonRequired"] = 14] = "NonRequired";
      ElementFlags2[ElementFlags2["NonRest"] = 11] = "NonRest";
    })(ElementFlags = ts2.ElementFlags || (ts2.ElementFlags = {}));
    var AccessFlags;
    (function(AccessFlags2) {
      AccessFlags2[AccessFlags2["None"] = 0] = "None";
      AccessFlags2[AccessFlags2["IncludeUndefined"] = 1] = "IncludeUndefined";
      AccessFlags2[AccessFlags2["NoIndexSignatures"] = 2] = "NoIndexSignatures";
      AccessFlags2[AccessFlags2["Writing"] = 4] = "Writing";
      AccessFlags2[AccessFlags2["CacheSymbol"] = 8] = "CacheSymbol";
      AccessFlags2[AccessFlags2["NoTupleBoundsCheck"] = 16] = "NoTupleBoundsCheck";
      AccessFlags2[AccessFlags2["ExpressionPosition"] = 32] = "ExpressionPosition";
      AccessFlags2[AccessFlags2["ReportDeprecated"] = 64] = "ReportDeprecated";
      AccessFlags2[AccessFlags2["SuppressNoImplicitAnyError"] = 128] = "SuppressNoImplicitAnyError";
      AccessFlags2[AccessFlags2["Contextual"] = 256] = "Contextual";
      AccessFlags2[AccessFlags2["Persistent"] = 1] = "Persistent";
    })(AccessFlags = ts2.AccessFlags || (ts2.AccessFlags = {}));
    var JsxReferenceKind;
    (function(JsxReferenceKind2) {
      JsxReferenceKind2[JsxReferenceKind2["Component"] = 0] = "Component";
      JsxReferenceKind2[JsxReferenceKind2["Function"] = 1] = "Function";
      JsxReferenceKind2[JsxReferenceKind2["Mixed"] = 2] = "Mixed";
    })(JsxReferenceKind = ts2.JsxReferenceKind || (ts2.JsxReferenceKind = {}));
    var SignatureKind;
    (function(SignatureKind2) {
      SignatureKind2[SignatureKind2["Call"] = 0] = "Call";
      SignatureKind2[SignatureKind2["Construct"] = 1] = "Construct";
    })(SignatureKind = ts2.SignatureKind || (ts2.SignatureKind = {}));
    var SignatureFlags;
    (function(SignatureFlags2) {
      SignatureFlags2[SignatureFlags2["None"] = 0] = "None";
      SignatureFlags2[SignatureFlags2["HasRestParameter"] = 1] = "HasRestParameter";
      SignatureFlags2[SignatureFlags2["HasLiteralTypes"] = 2] = "HasLiteralTypes";
      SignatureFlags2[SignatureFlags2["Abstract"] = 4] = "Abstract";
      SignatureFlags2[SignatureFlags2["IsInnerCallChain"] = 8] = "IsInnerCallChain";
      SignatureFlags2[SignatureFlags2["IsOuterCallChain"] = 16] = "IsOuterCallChain";
      SignatureFlags2[SignatureFlags2["IsUntypedSignatureInJSFile"] = 32] = "IsUntypedSignatureInJSFile";
      SignatureFlags2[SignatureFlags2["PropagatingFlags"] = 39] = "PropagatingFlags";
      SignatureFlags2[SignatureFlags2["CallChainFlags"] = 24] = "CallChainFlags";
    })(SignatureFlags = ts2.SignatureFlags || (ts2.SignatureFlags = {}));
    var IndexKind;
    (function(IndexKind2) {
      IndexKind2[IndexKind2["String"] = 0] = "String";
      IndexKind2[IndexKind2["Number"] = 1] = "Number";
    })(IndexKind = ts2.IndexKind || (ts2.IndexKind = {}));
    var TypeMapKind;
    (function(TypeMapKind2) {
      TypeMapKind2[TypeMapKind2["Simple"] = 0] = "Simple";
      TypeMapKind2[TypeMapKind2["Array"] = 1] = "Array";
      TypeMapKind2[TypeMapKind2["Function"] = 2] = "Function";
      TypeMapKind2[TypeMapKind2["Composite"] = 3] = "Composite";
      TypeMapKind2[TypeMapKind2["Merged"] = 4] = "Merged";
    })(TypeMapKind = ts2.TypeMapKind || (ts2.TypeMapKind = {}));
    var InferencePriority;
    (function(InferencePriority2) {
      InferencePriority2[InferencePriority2["NakedTypeVariable"] = 1] = "NakedTypeVariable";
      InferencePriority2[InferencePriority2["SpeculativeTuple"] = 2] = "SpeculativeTuple";
      InferencePriority2[InferencePriority2["SubstituteSource"] = 4] = "SubstituteSource";
      InferencePriority2[InferencePriority2["HomomorphicMappedType"] = 8] = "HomomorphicMappedType";
      InferencePriority2[InferencePriority2["PartialHomomorphicMappedType"] = 16] = "PartialHomomorphicMappedType";
      InferencePriority2[InferencePriority2["MappedTypeConstraint"] = 32] = "MappedTypeConstraint";
      InferencePriority2[InferencePriority2["ContravariantConditional"] = 64] = "ContravariantConditional";
      InferencePriority2[InferencePriority2["ReturnType"] = 128] = "ReturnType";
      InferencePriority2[InferencePriority2["LiteralKeyof"] = 256] = "LiteralKeyof";
      InferencePriority2[InferencePriority2["NoConstraints"] = 512] = "NoConstraints";
      InferencePriority2[InferencePriority2["AlwaysStrict"] = 1024] = "AlwaysStrict";
      InferencePriority2[InferencePriority2["MaxValue"] = 2048] = "MaxValue";
      InferencePriority2[InferencePriority2["PriorityImpliesCombination"] = 416] = "PriorityImpliesCombination";
      InferencePriority2[InferencePriority2["Circularity"] = -1] = "Circularity";
    })(InferencePriority = ts2.InferencePriority || (ts2.InferencePriority = {}));
    var InferenceFlags;
    (function(InferenceFlags2) {
      InferenceFlags2[InferenceFlags2["None"] = 0] = "None";
      InferenceFlags2[InferenceFlags2["NoDefault"] = 1] = "NoDefault";
      InferenceFlags2[InferenceFlags2["AnyDefault"] = 2] = "AnyDefault";
      InferenceFlags2[InferenceFlags2["SkippedGenericFunction"] = 4] = "SkippedGenericFunction";
    })(InferenceFlags = ts2.InferenceFlags || (ts2.InferenceFlags = {}));
    var Ternary;
    (function(Ternary2) {
      Ternary2[Ternary2["False"] = 0] = "False";
      Ternary2[Ternary2["Unknown"] = 1] = "Unknown";
      Ternary2[Ternary2["Maybe"] = 3] = "Maybe";
      Ternary2[Ternary2["True"] = -1] = "True";
    })(Ternary = ts2.Ternary || (ts2.Ternary = {}));
    var AssignmentDeclarationKind;
    (function(AssignmentDeclarationKind2) {
      AssignmentDeclarationKind2[AssignmentDeclarationKind2["None"] = 0] = "None";
      AssignmentDeclarationKind2[AssignmentDeclarationKind2["ExportsProperty"] = 1] = "ExportsProperty";
      AssignmentDeclarationKind2[AssignmentDeclarationKind2["ModuleExports"] = 2] = "ModuleExports";
      AssignmentDeclarationKind2[AssignmentDeclarationKind2["PrototypeProperty"] = 3] = "PrototypeProperty";
      AssignmentDeclarationKind2[AssignmentDeclarationKind2["ThisProperty"] = 4] = "ThisProperty";
      AssignmentDeclarationKind2[AssignmentDeclarationKind2["Property"] = 5] = "Property";
      AssignmentDeclarationKind2[AssignmentDeclarationKind2["Prototype"] = 6] = "Prototype";
      AssignmentDeclarationKind2[AssignmentDeclarationKind2["ObjectDefinePropertyValue"] = 7] = "ObjectDefinePropertyValue";
      AssignmentDeclarationKind2[AssignmentDeclarationKind2["ObjectDefinePropertyExports"] = 8] = "ObjectDefinePropertyExports";
      AssignmentDeclarationKind2[AssignmentDeclarationKind2["ObjectDefinePrototypeProperty"] = 9] = "ObjectDefinePrototypeProperty";
    })(AssignmentDeclarationKind = ts2.AssignmentDeclarationKind || (ts2.AssignmentDeclarationKind = {}));
    var DiagnosticCategory;
    (function(DiagnosticCategory2) {
      DiagnosticCategory2[DiagnosticCategory2["Warning"] = 0] = "Warning";
      DiagnosticCategory2[DiagnosticCategory2["Error"] = 1] = "Error";
      DiagnosticCategory2[DiagnosticCategory2["Suggestion"] = 2] = "Suggestion";
      DiagnosticCategory2[DiagnosticCategory2["Message"] = 3] = "Message";
    })(DiagnosticCategory = ts2.DiagnosticCategory || (ts2.DiagnosticCategory = {}));
    function diagnosticCategoryName(d, lowerCase) {
      if (lowerCase === void 0) {
        lowerCase = true;
      }
      var name = DiagnosticCategory[d.category];
      return lowerCase ? name.toLowerCase() : name;
    }
    ts2.diagnosticCategoryName = diagnosticCategoryName;
    var ModuleResolutionKind;
    (function(ModuleResolutionKind2) {
      ModuleResolutionKind2[ModuleResolutionKind2["Classic"] = 1] = "Classic";
      ModuleResolutionKind2[ModuleResolutionKind2["NodeJs"] = 2] = "NodeJs";
    })(ModuleResolutionKind = ts2.ModuleResolutionKind || (ts2.ModuleResolutionKind = {}));
    var WatchFileKind;
    (function(WatchFileKind2) {
      WatchFileKind2[WatchFileKind2["FixedPollingInterval"] = 0] = "FixedPollingInterval";
      WatchFileKind2[WatchFileKind2["PriorityPollingInterval"] = 1] = "PriorityPollingInterval";
      WatchFileKind2[WatchFileKind2["DynamicPriorityPolling"] = 2] = "DynamicPriorityPolling";
      WatchFileKind2[WatchFileKind2["FixedChunkSizePolling"] = 3] = "FixedChunkSizePolling";
      WatchFileKind2[WatchFileKind2["UseFsEvents"] = 4] = "UseFsEvents";
      WatchFileKind2[WatchFileKind2["UseFsEventsOnParentDirectory"] = 5] = "UseFsEventsOnParentDirectory";
    })(WatchFileKind = ts2.WatchFileKind || (ts2.WatchFileKind = {}));
    var WatchDirectoryKind;
    (function(WatchDirectoryKind2) {
      WatchDirectoryKind2[WatchDirectoryKind2["UseFsEvents"] = 0] = "UseFsEvents";
      WatchDirectoryKind2[WatchDirectoryKind2["FixedPollingInterval"] = 1] = "FixedPollingInterval";
      WatchDirectoryKind2[WatchDirectoryKind2["DynamicPriorityPolling"] = 2] = "DynamicPriorityPolling";
      WatchDirectoryKind2[WatchDirectoryKind2["FixedChunkSizePolling"] = 3] = "FixedChunkSizePolling";
    })(WatchDirectoryKind = ts2.WatchDirectoryKind || (ts2.WatchDirectoryKind = {}));
    var PollingWatchKind;
    (function(PollingWatchKind2) {
      PollingWatchKind2[PollingWatchKind2["FixedInterval"] = 0] = "FixedInterval";
      PollingWatchKind2[PollingWatchKind2["PriorityInterval"] = 1] = "PriorityInterval";
      PollingWatchKind2[PollingWatchKind2["DynamicPriority"] = 2] = "DynamicPriority";
      PollingWatchKind2[PollingWatchKind2["FixedChunkSize"] = 3] = "FixedChunkSize";
    })(PollingWatchKind = ts2.PollingWatchKind || (ts2.PollingWatchKind = {}));
    var ModuleKind;
    (function(ModuleKind2) {
      ModuleKind2[ModuleKind2["None"] = 0] = "None";
      ModuleKind2[ModuleKind2["CommonJS"] = 1] = "CommonJS";
      ModuleKind2[ModuleKind2["AMD"] = 2] = "AMD";
      ModuleKind2[ModuleKind2["UMD"] = 3] = "UMD";
      ModuleKind2[ModuleKind2["System"] = 4] = "System";
      ModuleKind2[ModuleKind2["ES2015"] = 5] = "ES2015";
      ModuleKind2[ModuleKind2["ES2020"] = 6] = "ES2020";
      ModuleKind2[ModuleKind2["ESNext"] = 99] = "ESNext";
    })(ModuleKind = ts2.ModuleKind || (ts2.ModuleKind = {}));
    var JsxEmit;
    (function(JsxEmit2) {
      JsxEmit2[JsxEmit2["None"] = 0] = "None";
      JsxEmit2[JsxEmit2["Preserve"] = 1] = "Preserve";
      JsxEmit2[JsxEmit2["React"] = 2] = "React";
      JsxEmit2[JsxEmit2["ReactNative"] = 3] = "ReactNative";
      JsxEmit2[JsxEmit2["ReactJSX"] = 4] = "ReactJSX";
      JsxEmit2[JsxEmit2["ReactJSXDev"] = 5] = "ReactJSXDev";
    })(JsxEmit = ts2.JsxEmit || (ts2.JsxEmit = {}));
    var ImportsNotUsedAsValues;
    (function(ImportsNotUsedAsValues2) {
      ImportsNotUsedAsValues2[ImportsNotUsedAsValues2["Remove"] = 0] = "Remove";
      ImportsNotUsedAsValues2[ImportsNotUsedAsValues2["Preserve"] = 1] = "Preserve";
      ImportsNotUsedAsValues2[ImportsNotUsedAsValues2["Error"] = 2] = "Error";
    })(ImportsNotUsedAsValues = ts2.ImportsNotUsedAsValues || (ts2.ImportsNotUsedAsValues = {}));
    var NewLineKind;
    (function(NewLineKind2) {
      NewLineKind2[NewLineKind2["CarriageReturnLineFeed"] = 0] = "CarriageReturnLineFeed";
      NewLineKind2[NewLineKind2["LineFeed"] = 1] = "LineFeed";
    })(NewLineKind = ts2.NewLineKind || (ts2.NewLineKind = {}));
    var ScriptKind2;
    (function(ScriptKind3) {
      ScriptKind3[ScriptKind3["Unknown"] = 0] = "Unknown";
      ScriptKind3[ScriptKind3["JS"] = 1] = "JS";
      ScriptKind3[ScriptKind3["JSX"] = 2] = "JSX";
      ScriptKind3[ScriptKind3["TS"] = 3] = "TS";
      ScriptKind3[ScriptKind3["TSX"] = 4] = "TSX";
      ScriptKind3[ScriptKind3["External"] = 5] = "External";
      ScriptKind3[ScriptKind3["JSON"] = 6] = "JSON";
      ScriptKind3[ScriptKind3["Deferred"] = 7] = "Deferred";
    })(ScriptKind2 = ts2.ScriptKind || (ts2.ScriptKind = {}));
    var ScriptTarget2;
    (function(ScriptTarget3) {
      ScriptTarget3[ScriptTarget3["ES3"] = 0] = "ES3";
      ScriptTarget3[ScriptTarget3["ES5"] = 1] = "ES5";
      ScriptTarget3[ScriptTarget3["ES2015"] = 2] = "ES2015";
      ScriptTarget3[ScriptTarget3["ES2016"] = 3] = "ES2016";
      ScriptTarget3[ScriptTarget3["ES2017"] = 4] = "ES2017";
      ScriptTarget3[ScriptTarget3["ES2018"] = 5] = "ES2018";
      ScriptTarget3[ScriptTarget3["ES2019"] = 6] = "ES2019";
      ScriptTarget3[ScriptTarget3["ES2020"] = 7] = "ES2020";
      ScriptTarget3[ScriptTarget3["ES2021"] = 8] = "ES2021";
      ScriptTarget3[ScriptTarget3["ESNext"] = 99] = "ESNext";
      ScriptTarget3[ScriptTarget3["JSON"] = 100] = "JSON";
      ScriptTarget3[ScriptTarget3["Latest"] = 99] = "Latest";
    })(ScriptTarget2 = ts2.ScriptTarget || (ts2.ScriptTarget = {}));
    var LanguageVariant;
    (function(LanguageVariant2) {
      LanguageVariant2[LanguageVariant2["Standard"] = 0] = "Standard";
      LanguageVariant2[LanguageVariant2["JSX"] = 1] = "JSX";
    })(LanguageVariant = ts2.LanguageVariant || (ts2.LanguageVariant = {}));
    var WatchDirectoryFlags;
    (function(WatchDirectoryFlags2) {
      WatchDirectoryFlags2[WatchDirectoryFlags2["None"] = 0] = "None";
      WatchDirectoryFlags2[WatchDirectoryFlags2["Recursive"] = 1] = "Recursive";
    })(WatchDirectoryFlags = ts2.WatchDirectoryFlags || (ts2.WatchDirectoryFlags = {}));
    var CharacterCodes;
    (function(CharacterCodes2) {
      CharacterCodes2[CharacterCodes2["nullCharacter"] = 0] = "nullCharacter";
      CharacterCodes2[CharacterCodes2["maxAsciiCharacter"] = 127] = "maxAsciiCharacter";
      CharacterCodes2[CharacterCodes2["lineFeed"] = 10] = "lineFeed";
      CharacterCodes2[CharacterCodes2["carriageReturn"] = 13] = "carriageReturn";
      CharacterCodes2[CharacterCodes2["lineSeparator"] = 8232] = "lineSeparator";
      CharacterCodes2[CharacterCodes2["paragraphSeparator"] = 8233] = "paragraphSeparator";
      CharacterCodes2[CharacterCodes2["nextLine"] = 133] = "nextLine";
      CharacterCodes2[CharacterCodes2["space"] = 32] = "space";
      CharacterCodes2[CharacterCodes2["nonBreakingSpace"] = 160] = "nonBreakingSpace";
      CharacterCodes2[CharacterCodes2["enQuad"] = 8192] = "enQuad";
      CharacterCodes2[CharacterCodes2["emQuad"] = 8193] = "emQuad";
      CharacterCodes2[CharacterCodes2["enSpace"] = 8194] = "enSpace";
      CharacterCodes2[CharacterCodes2["emSpace"] = 8195] = "emSpace";
      CharacterCodes2[CharacterCodes2["threePerEmSpace"] = 8196] = "threePerEmSpace";
      CharacterCodes2[CharacterCodes2["fourPerEmSpace"] = 8197] = "fourPerEmSpace";
      CharacterCodes2[CharacterCodes2["sixPerEmSpace"] = 8198] = "sixPerEmSpace";
      CharacterCodes2[CharacterCodes2["figureSpace"] = 8199] = "figureSpace";
      CharacterCodes2[CharacterCodes2["punctuationSpace"] = 8200] = "punctuationSpace";
      CharacterCodes2[CharacterCodes2["thinSpace"] = 8201] = "thinSpace";
      CharacterCodes2[CharacterCodes2["hairSpace"] = 8202] = "hairSpace";
      CharacterCodes2[CharacterCodes2["zeroWidthSpace"] = 8203] = "zeroWidthSpace";
      CharacterCodes2[CharacterCodes2["narrowNoBreakSpace"] = 8239] = "narrowNoBreakSpace";
      CharacterCodes2[CharacterCodes2["ideographicSpace"] = 12288] = "ideographicSpace";
      CharacterCodes2[CharacterCodes2["mathematicalSpace"] = 8287] = "mathematicalSpace";
      CharacterCodes2[CharacterCodes2["ogham"] = 5760] = "ogham";
      CharacterCodes2[CharacterCodes2["_"] = 95] = "_";
      CharacterCodes2[CharacterCodes2["$"] = 36] = "$";
      CharacterCodes2[CharacterCodes2["_0"] = 48] = "_0";
      CharacterCodes2[CharacterCodes2["_1"] = 49] = "_1";
      CharacterCodes2[CharacterCodes2["_2"] = 50] = "_2";
      CharacterCodes2[CharacterCodes2["_3"] = 51] = "_3";
      CharacterCodes2[CharacterCodes2["_4"] = 52] = "_4";
      CharacterCodes2[CharacterCodes2["_5"] = 53] = "_5";
      CharacterCodes2[CharacterCodes2["_6"] = 54] = "_6";
      CharacterCodes2[CharacterCodes2["_7"] = 55] = "_7";
      CharacterCodes2[CharacterCodes2["_8"] = 56] = "_8";
      CharacterCodes2[CharacterCodes2["_9"] = 57] = "_9";
      CharacterCodes2[CharacterCodes2["a"] = 97] = "a";
      CharacterCodes2[CharacterCodes2["b"] = 98] = "b";
      CharacterCodes2[CharacterCodes2["c"] = 99] = "c";
      CharacterCodes2[CharacterCodes2["d"] = 100] = "d";
      CharacterCodes2[CharacterCodes2["e"] = 101] = "e";
      CharacterCodes2[CharacterCodes2["f"] = 102] = "f";
      CharacterCodes2[CharacterCodes2["g"] = 103] = "g";
      CharacterCodes2[CharacterCodes2["h"] = 104] = "h";
      CharacterCodes2[CharacterCodes2["i"] = 105] = "i";
      CharacterCodes2[CharacterCodes2["j"] = 106] = "j";
      CharacterCodes2[CharacterCodes2["k"] = 107] = "k";
      CharacterCodes2[CharacterCodes2["l"] = 108] = "l";
      CharacterCodes2[CharacterCodes2["m"] = 109] = "m";
      CharacterCodes2[CharacterCodes2["n"] = 110] = "n";
      CharacterCodes2[CharacterCodes2["o"] = 111] = "o";
      CharacterCodes2[CharacterCodes2["p"] = 112] = "p";
      CharacterCodes2[CharacterCodes2["q"] = 113] = "q";
      CharacterCodes2[CharacterCodes2["r"] = 114] = "r";
      CharacterCodes2[CharacterCodes2["s"] = 115] = "s";
      CharacterCodes2[CharacterCodes2["t"] = 116] = "t";
      CharacterCodes2[CharacterCodes2["u"] = 117] = "u";
      CharacterCodes2[CharacterCodes2["v"] = 118] = "v";
      CharacterCodes2[CharacterCodes2["w"] = 119] = "w";
      CharacterCodes2[CharacterCodes2["x"] = 120] = "x";
      CharacterCodes2[CharacterCodes2["y"] = 121] = "y";
      CharacterCodes2[CharacterCodes2["z"] = 122] = "z";
      CharacterCodes2[CharacterCodes2["A"] = 65] = "A";
      CharacterCodes2[CharacterCodes2["B"] = 66] = "B";
      CharacterCodes2[CharacterCodes2["C"] = 67] = "C";
      CharacterCodes2[CharacterCodes2["D"] = 68] = "D";
      CharacterCodes2[CharacterCodes2["E"] = 69] = "E";
      CharacterCodes2[CharacterCodes2["F"] = 70] = "F";
      CharacterCodes2[CharacterCodes2["G"] = 71] = "G";
      CharacterCodes2[CharacterCodes2["H"] = 72] = "H";
      CharacterCodes2[CharacterCodes2["I"] = 73] = "I";
      CharacterCodes2[CharacterCodes2["J"] = 74] = "J";
      CharacterCodes2[CharacterCodes2["K"] = 75] = "K";
      CharacterCodes2[CharacterCodes2["L"] = 76] = "L";
      CharacterCodes2[CharacterCodes2["M"] = 77] = "M";
      CharacterCodes2[CharacterCodes2["N"] = 78] = "N";
      CharacterCodes2[CharacterCodes2["O"] = 79] = "O";
      CharacterCodes2[CharacterCodes2["P"] = 80] = "P";
      CharacterCodes2[CharacterCodes2["Q"] = 81] = "Q";
      CharacterCodes2[CharacterCodes2["R"] = 82] = "R";
      CharacterCodes2[CharacterCodes2["S"] = 83] = "S";
      CharacterCodes2[CharacterCodes2["T"] = 84] = "T";
      CharacterCodes2[CharacterCodes2["U"] = 85] = "U";
      CharacterCodes2[CharacterCodes2["V"] = 86] = "V";
      CharacterCodes2[CharacterCodes2["W"] = 87] = "W";
      CharacterCodes2[CharacterCodes2["X"] = 88] = "X";
      CharacterCodes2[CharacterCodes2["Y"] = 89] = "Y";
      CharacterCodes2[CharacterCodes2["Z"] = 90] = "Z";
      CharacterCodes2[CharacterCodes2["ampersand"] = 38] = "ampersand";
      CharacterCodes2[CharacterCodes2["asterisk"] = 42] = "asterisk";
      CharacterCodes2[CharacterCodes2["at"] = 64] = "at";
      CharacterCodes2[CharacterCodes2["backslash"] = 92] = "backslash";
      CharacterCodes2[CharacterCodes2["backtick"] = 96] = "backtick";
      CharacterCodes2[CharacterCodes2["bar"] = 124] = "bar";
      CharacterCodes2[CharacterCodes2["caret"] = 94] = "caret";
      CharacterCodes2[CharacterCodes2["closeBrace"] = 125] = "closeBrace";
      CharacterCodes2[CharacterCodes2["closeBracket"] = 93] = "closeBracket";
      CharacterCodes2[CharacterCodes2["closeParen"] = 41] = "closeParen";
      CharacterCodes2[CharacterCodes2["colon"] = 58] = "colon";
      CharacterCodes2[CharacterCodes2["comma"] = 44] = "comma";
      CharacterCodes2[CharacterCodes2["dot"] = 46] = "dot";
      CharacterCodes2[CharacterCodes2["doubleQuote"] = 34] = "doubleQuote";
      CharacterCodes2[CharacterCodes2["equals"] = 61] = "equals";
      CharacterCodes2[CharacterCodes2["exclamation"] = 33] = "exclamation";
      CharacterCodes2[CharacterCodes2["greaterThan"] = 62] = "greaterThan";
      CharacterCodes2[CharacterCodes2["hash"] = 35] = "hash";
      CharacterCodes2[CharacterCodes2["lessThan"] = 60] = "lessThan";
      CharacterCodes2[CharacterCodes2["minus"] = 45] = "minus";
      CharacterCodes2[CharacterCodes2["openBrace"] = 123] = "openBrace";
      CharacterCodes2[CharacterCodes2["openBracket"] = 91] = "openBracket";
      CharacterCodes2[CharacterCodes2["openParen"] = 40] = "openParen";
      CharacterCodes2[CharacterCodes2["percent"] = 37] = "percent";
      CharacterCodes2[CharacterCodes2["plus"] = 43] = "plus";
      CharacterCodes2[CharacterCodes2["question"] = 63] = "question";
      CharacterCodes2[CharacterCodes2["semicolon"] = 59] = "semicolon";
      CharacterCodes2[CharacterCodes2["singleQuote"] = 39] = "singleQuote";
      CharacterCodes2[CharacterCodes2["slash"] = 47] = "slash";
      CharacterCodes2[CharacterCodes2["tilde"] = 126] = "tilde";
      CharacterCodes2[CharacterCodes2["backspace"] = 8] = "backspace";
      CharacterCodes2[CharacterCodes2["formFeed"] = 12] = "formFeed";
      CharacterCodes2[CharacterCodes2["byteOrderMark"] = 65279] = "byteOrderMark";
      CharacterCodes2[CharacterCodes2["tab"] = 9] = "tab";
      CharacterCodes2[CharacterCodes2["verticalTab"] = 11] = "verticalTab";
    })(CharacterCodes = ts2.CharacterCodes || (ts2.CharacterCodes = {}));
    var Extension;
    (function(Extension2) {
      Extension2["Ts"] = ".ts";
      Extension2["Tsx"] = ".tsx";
      Extension2["Dts"] = ".d.ts";
      Extension2["Js"] = ".js";
      Extension2["Jsx"] = ".jsx";
      Extension2["Json"] = ".json";
      Extension2["TsBuildInfo"] = ".tsbuildinfo";
    })(Extension = ts2.Extension || (ts2.Extension = {}));
    var TransformFlags;
    (function(TransformFlags2) {
      TransformFlags2[TransformFlags2["None"] = 0] = "None";
      TransformFlags2[TransformFlags2["ContainsTypeScript"] = 1] = "ContainsTypeScript";
      TransformFlags2[TransformFlags2["ContainsJsx"] = 2] = "ContainsJsx";
      TransformFlags2[TransformFlags2["ContainsESNext"] = 4] = "ContainsESNext";
      TransformFlags2[TransformFlags2["ContainsES2021"] = 8] = "ContainsES2021";
      TransformFlags2[TransformFlags2["ContainsES2020"] = 16] = "ContainsES2020";
      TransformFlags2[TransformFlags2["ContainsES2019"] = 32] = "ContainsES2019";
      TransformFlags2[TransformFlags2["ContainsES2018"] = 64] = "ContainsES2018";
      TransformFlags2[TransformFlags2["ContainsES2017"] = 128] = "ContainsES2017";
      TransformFlags2[TransformFlags2["ContainsES2016"] = 256] = "ContainsES2016";
      TransformFlags2[TransformFlags2["ContainsES2015"] = 512] = "ContainsES2015";
      TransformFlags2[TransformFlags2["ContainsGenerator"] = 1024] = "ContainsGenerator";
      TransformFlags2[TransformFlags2["ContainsDestructuringAssignment"] = 2048] = "ContainsDestructuringAssignment";
      TransformFlags2[TransformFlags2["ContainsTypeScriptClassSyntax"] = 4096] = "ContainsTypeScriptClassSyntax";
      TransformFlags2[TransformFlags2["ContainsLexicalThis"] = 8192] = "ContainsLexicalThis";
      TransformFlags2[TransformFlags2["ContainsRestOrSpread"] = 16384] = "ContainsRestOrSpread";
      TransformFlags2[TransformFlags2["ContainsObjectRestOrSpread"] = 32768] = "ContainsObjectRestOrSpread";
      TransformFlags2[TransformFlags2["ContainsComputedPropertyName"] = 65536] = "ContainsComputedPropertyName";
      TransformFlags2[TransformFlags2["ContainsBlockScopedBinding"] = 131072] = "ContainsBlockScopedBinding";
      TransformFlags2[TransformFlags2["ContainsBindingPattern"] = 262144] = "ContainsBindingPattern";
      TransformFlags2[TransformFlags2["ContainsYield"] = 524288] = "ContainsYield";
      TransformFlags2[TransformFlags2["ContainsAwait"] = 1048576] = "ContainsAwait";
      TransformFlags2[TransformFlags2["ContainsHoistedDeclarationOrCompletion"] = 2097152] = "ContainsHoistedDeclarationOrCompletion";
      TransformFlags2[TransformFlags2["ContainsDynamicImport"] = 4194304] = "ContainsDynamicImport";
      TransformFlags2[TransformFlags2["ContainsClassFields"] = 8388608] = "ContainsClassFields";
      TransformFlags2[TransformFlags2["ContainsPossibleTopLevelAwait"] = 16777216] = "ContainsPossibleTopLevelAwait";
      TransformFlags2[TransformFlags2["ContainsLexicalSuper"] = 33554432] = "ContainsLexicalSuper";
      TransformFlags2[TransformFlags2["ContainsUpdateExpressionForIdentifier"] = 67108864] = "ContainsUpdateExpressionForIdentifier";
      TransformFlags2[TransformFlags2["HasComputedFlags"] = 536870912] = "HasComputedFlags";
      TransformFlags2[TransformFlags2["AssertTypeScript"] = 1] = "AssertTypeScript";
      TransformFlags2[TransformFlags2["AssertJsx"] = 2] = "AssertJsx";
      TransformFlags2[TransformFlags2["AssertESNext"] = 4] = "AssertESNext";
      TransformFlags2[TransformFlags2["AssertES2021"] = 8] = "AssertES2021";
      TransformFlags2[TransformFlags2["AssertES2020"] = 16] = "AssertES2020";
      TransformFlags2[TransformFlags2["AssertES2019"] = 32] = "AssertES2019";
      TransformFlags2[TransformFlags2["AssertES2018"] = 64] = "AssertES2018";
      TransformFlags2[TransformFlags2["AssertES2017"] = 128] = "AssertES2017";
      TransformFlags2[TransformFlags2["AssertES2016"] = 256] = "AssertES2016";
      TransformFlags2[TransformFlags2["AssertES2015"] = 512] = "AssertES2015";
      TransformFlags2[TransformFlags2["AssertGenerator"] = 1024] = "AssertGenerator";
      TransformFlags2[TransformFlags2["AssertDestructuringAssignment"] = 2048] = "AssertDestructuringAssignment";
      TransformFlags2[TransformFlags2["OuterExpressionExcludes"] = 536870912] = "OuterExpressionExcludes";
      TransformFlags2[TransformFlags2["PropertyAccessExcludes"] = 536870912] = "PropertyAccessExcludes";
      TransformFlags2[TransformFlags2["NodeExcludes"] = 536870912] = "NodeExcludes";
      TransformFlags2[TransformFlags2["ArrowFunctionExcludes"] = 557748224] = "ArrowFunctionExcludes";
      TransformFlags2[TransformFlags2["FunctionExcludes"] = 591310848] = "FunctionExcludes";
      TransformFlags2[TransformFlags2["ConstructorExcludes"] = 591306752] = "ConstructorExcludes";
      TransformFlags2[TransformFlags2["MethodOrAccessorExcludes"] = 574529536] = "MethodOrAccessorExcludes";
      TransformFlags2[TransformFlags2["PropertyExcludes"] = 570433536] = "PropertyExcludes";
      TransformFlags2[TransformFlags2["ClassExcludes"] = 536940544] = "ClassExcludes";
      TransformFlags2[TransformFlags2["ModuleExcludes"] = 589443072] = "ModuleExcludes";
      TransformFlags2[TransformFlags2["TypeExcludes"] = -2] = "TypeExcludes";
      TransformFlags2[TransformFlags2["ObjectLiteralExcludes"] = 536973312] = "ObjectLiteralExcludes";
      TransformFlags2[TransformFlags2["ArrayLiteralOrCallOrNewExcludes"] = 536887296] = "ArrayLiteralOrCallOrNewExcludes";
      TransformFlags2[TransformFlags2["VariableDeclarationListExcludes"] = 537165824] = "VariableDeclarationListExcludes";
      TransformFlags2[TransformFlags2["ParameterExcludes"] = 536870912] = "ParameterExcludes";
      TransformFlags2[TransformFlags2["CatchClauseExcludes"] = 536903680] = "CatchClauseExcludes";
      TransformFlags2[TransformFlags2["BindingPatternExcludes"] = 536887296] = "BindingPatternExcludes";
      TransformFlags2[TransformFlags2["ContainsLexicalThisOrSuper"] = 33562624] = "ContainsLexicalThisOrSuper";
      TransformFlags2[TransformFlags2["PropertyNamePropagatingFlags"] = 33562624] = "PropertyNamePropagatingFlags";
    })(TransformFlags = ts2.TransformFlags || (ts2.TransformFlags = {}));
    var EmitFlags;
    (function(EmitFlags2) {
      EmitFlags2[EmitFlags2["None"] = 0] = "None";
      EmitFlags2[EmitFlags2["SingleLine"] = 1] = "SingleLine";
      EmitFlags2[EmitFlags2["AdviseOnEmitNode"] = 2] = "AdviseOnEmitNode";
      EmitFlags2[EmitFlags2["NoSubstitution"] = 4] = "NoSubstitution";
      EmitFlags2[EmitFlags2["CapturesThis"] = 8] = "CapturesThis";
      EmitFlags2[EmitFlags2["NoLeadingSourceMap"] = 16] = "NoLeadingSourceMap";
      EmitFlags2[EmitFlags2["NoTrailingSourceMap"] = 32] = "NoTrailingSourceMap";
      EmitFlags2[EmitFlags2["NoSourceMap"] = 48] = "NoSourceMap";
      EmitFlags2[EmitFlags2["NoNestedSourceMaps"] = 64] = "NoNestedSourceMaps";
      EmitFlags2[EmitFlags2["NoTokenLeadingSourceMaps"] = 128] = "NoTokenLeadingSourceMaps";
      EmitFlags2[EmitFlags2["NoTokenTrailingSourceMaps"] = 256] = "NoTokenTrailingSourceMaps";
      EmitFlags2[EmitFlags2["NoTokenSourceMaps"] = 384] = "NoTokenSourceMaps";
      EmitFlags2[EmitFlags2["NoLeadingComments"] = 512] = "NoLeadingComments";
      EmitFlags2[EmitFlags2["NoTrailingComments"] = 1024] = "NoTrailingComments";
      EmitFlags2[EmitFlags2["NoComments"] = 1536] = "NoComments";
      EmitFlags2[EmitFlags2["NoNestedComments"] = 2048] = "NoNestedComments";
      EmitFlags2[EmitFlags2["HelperName"] = 4096] = "HelperName";
      EmitFlags2[EmitFlags2["ExportName"] = 8192] = "ExportName";
      EmitFlags2[EmitFlags2["LocalName"] = 16384] = "LocalName";
      EmitFlags2[EmitFlags2["InternalName"] = 32768] = "InternalName";
      EmitFlags2[EmitFlags2["Indented"] = 65536] = "Indented";
      EmitFlags2[EmitFlags2["NoIndentation"] = 131072] = "NoIndentation";
      EmitFlags2[EmitFlags2["AsyncFunctionBody"] = 262144] = "AsyncFunctionBody";
      EmitFlags2[EmitFlags2["ReuseTempVariableScope"] = 524288] = "ReuseTempVariableScope";
      EmitFlags2[EmitFlags2["CustomPrologue"] = 1048576] = "CustomPrologue";
      EmitFlags2[EmitFlags2["NoHoisting"] = 2097152] = "NoHoisting";
      EmitFlags2[EmitFlags2["HasEndOfDeclarationMarker"] = 4194304] = "HasEndOfDeclarationMarker";
      EmitFlags2[EmitFlags2["Iterator"] = 8388608] = "Iterator";
      EmitFlags2[EmitFlags2["NoAsciiEscaping"] = 16777216] = "NoAsciiEscaping";
      EmitFlags2[EmitFlags2["TypeScriptClassWrapper"] = 33554432] = "TypeScriptClassWrapper";
      EmitFlags2[EmitFlags2["NeverApplyImportHelper"] = 67108864] = "NeverApplyImportHelper";
      EmitFlags2[EmitFlags2["IgnoreSourceNewlines"] = 134217728] = "IgnoreSourceNewlines";
      EmitFlags2[EmitFlags2["Immutable"] = 268435456] = "Immutable";
      EmitFlags2[EmitFlags2["IndirectCall"] = 536870912] = "IndirectCall";
    })(EmitFlags = ts2.EmitFlags || (ts2.EmitFlags = {}));
    var ExternalEmitHelpers;
    (function(ExternalEmitHelpers2) {
      ExternalEmitHelpers2[ExternalEmitHelpers2["Extends"] = 1] = "Extends";
      ExternalEmitHelpers2[ExternalEmitHelpers2["Assign"] = 2] = "Assign";
      ExternalEmitHelpers2[ExternalEmitHelpers2["Rest"] = 4] = "Rest";
      ExternalEmitHelpers2[ExternalEmitHelpers2["Decorate"] = 8] = "Decorate";
      ExternalEmitHelpers2[ExternalEmitHelpers2["Metadata"] = 16] = "Metadata";
      ExternalEmitHelpers2[ExternalEmitHelpers2["Param"] = 32] = "Param";
      ExternalEmitHelpers2[ExternalEmitHelpers2["Awaiter"] = 64] = "Awaiter";
      ExternalEmitHelpers2[ExternalEmitHelpers2["Generator"] = 128] = "Generator";
      ExternalEmitHelpers2[ExternalEmitHelpers2["Values"] = 256] = "Values";
      ExternalEmitHelpers2[ExternalEmitHelpers2["Read"] = 512] = "Read";
      ExternalEmitHelpers2[ExternalEmitHelpers2["SpreadArray"] = 1024] = "SpreadArray";
      ExternalEmitHelpers2[ExternalEmitHelpers2["Await"] = 2048] = "Await";
      ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncGenerator"] = 4096] = "AsyncGenerator";
      ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncDelegator"] = 8192] = "AsyncDelegator";
      ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncValues"] = 16384] = "AsyncValues";
      ExternalEmitHelpers2[ExternalEmitHelpers2["ExportStar"] = 32768] = "ExportStar";
      ExternalEmitHelpers2[ExternalEmitHelpers2["ImportStar"] = 65536] = "ImportStar";
      ExternalEmitHelpers2[ExternalEmitHelpers2["ImportDefault"] = 131072] = "ImportDefault";
      ExternalEmitHelpers2[ExternalEmitHelpers2["MakeTemplateObject"] = 262144] = "MakeTemplateObject";
      ExternalEmitHelpers2[ExternalEmitHelpers2["ClassPrivateFieldGet"] = 524288] = "ClassPrivateFieldGet";
      ExternalEmitHelpers2[ExternalEmitHelpers2["ClassPrivateFieldSet"] = 1048576] = "ClassPrivateFieldSet";
      ExternalEmitHelpers2[ExternalEmitHelpers2["CreateBinding"] = 2097152] = "CreateBinding";
      ExternalEmitHelpers2[ExternalEmitHelpers2["FirstEmitHelper"] = 1] = "FirstEmitHelper";
      ExternalEmitHelpers2[ExternalEmitHelpers2["LastEmitHelper"] = 2097152] = "LastEmitHelper";
      ExternalEmitHelpers2[ExternalEmitHelpers2["ForOfIncludes"] = 256] = "ForOfIncludes";
      ExternalEmitHelpers2[ExternalEmitHelpers2["ForAwaitOfIncludes"] = 16384] = "ForAwaitOfIncludes";
      ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncGeneratorIncludes"] = 6144] = "AsyncGeneratorIncludes";
      ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncDelegatorIncludes"] = 26624] = "AsyncDelegatorIncludes";
      ExternalEmitHelpers2[ExternalEmitHelpers2["SpreadIncludes"] = 1536] = "SpreadIncludes";
    })(ExternalEmitHelpers = ts2.ExternalEmitHelpers || (ts2.ExternalEmitHelpers = {}));
    var EmitHint;
    (function(EmitHint2) {
      EmitHint2[EmitHint2["SourceFile"] = 0] = "SourceFile";
      EmitHint2[EmitHint2["Expression"] = 1] = "Expression";
      EmitHint2[EmitHint2["IdentifierName"] = 2] = "IdentifierName";
      EmitHint2[EmitHint2["MappedTypeParameter"] = 3] = "MappedTypeParameter";
      EmitHint2[EmitHint2["Unspecified"] = 4] = "Unspecified";
      EmitHint2[EmitHint2["EmbeddedStatement"] = 5] = "EmbeddedStatement";
      EmitHint2[EmitHint2["JsxAttributeValue"] = 6] = "JsxAttributeValue";
    })(EmitHint = ts2.EmitHint || (ts2.EmitHint = {}));
    var OuterExpressionKinds;
    (function(OuterExpressionKinds2) {
      OuterExpressionKinds2[OuterExpressionKinds2["Parentheses"] = 1] = "Parentheses";
      OuterExpressionKinds2[OuterExpressionKinds2["TypeAssertions"] = 2] = "TypeAssertions";
      OuterExpressionKinds2[OuterExpressionKinds2["NonNullAssertions"] = 4] = "NonNullAssertions";
      OuterExpressionKinds2[OuterExpressionKinds2["PartiallyEmittedExpressions"] = 8] = "PartiallyEmittedExpressions";
      OuterExpressionKinds2[OuterExpressionKinds2["Assertions"] = 6] = "Assertions";
      OuterExpressionKinds2[OuterExpressionKinds2["All"] = 15] = "All";
    })(OuterExpressionKinds = ts2.OuterExpressionKinds || (ts2.OuterExpressionKinds = {}));
    var LexicalEnvironmentFlags;
    (function(LexicalEnvironmentFlags2) {
      LexicalEnvironmentFlags2[LexicalEnvironmentFlags2["None"] = 0] = "None";
      LexicalEnvironmentFlags2[LexicalEnvironmentFlags2["InParameters"] = 1] = "InParameters";
      LexicalEnvironmentFlags2[LexicalEnvironmentFlags2["VariablesHoistedInParameters"] = 2] = "VariablesHoistedInParameters";
    })(LexicalEnvironmentFlags = ts2.LexicalEnvironmentFlags || (ts2.LexicalEnvironmentFlags = {}));
    var BundleFileSectionKind;
    (function(BundleFileSectionKind2) {
      BundleFileSectionKind2["Prologue"] = "prologue";
      BundleFileSectionKind2["EmitHelpers"] = "emitHelpers";
      BundleFileSectionKind2["NoDefaultLib"] = "no-default-lib";
      BundleFileSectionKind2["Reference"] = "reference";
      BundleFileSectionKind2["Type"] = "type";
      BundleFileSectionKind2["Lib"] = "lib";
      BundleFileSectionKind2["Prepend"] = "prepend";
      BundleFileSectionKind2["Text"] = "text";
      BundleFileSectionKind2["Internal"] = "internal";
    })(BundleFileSectionKind = ts2.BundleFileSectionKind || (ts2.BundleFileSectionKind = {}));
    var ListFormat;
    (function(ListFormat2) {
      ListFormat2[ListFormat2["None"] = 0] = "None";
      ListFormat2[ListFormat2["SingleLine"] = 0] = "SingleLine";
      ListFormat2[ListFormat2["MultiLine"] = 1] = "MultiLine";
      ListFormat2[ListFormat2["PreserveLines"] = 2] = "PreserveLines";
      ListFormat2[ListFormat2["LinesMask"] = 3] = "LinesMask";
      ListFormat2[ListFormat2["NotDelimited"] = 0] = "NotDelimited";
      ListFormat2[ListFormat2["BarDelimited"] = 4] = "BarDelimited";
      ListFormat2[ListFormat2["AmpersandDelimited"] = 8] = "AmpersandDelimited";
      ListFormat2[ListFormat2["CommaDelimited"] = 16] = "CommaDelimited";
      ListFormat2[ListFormat2["AsteriskDelimited"] = 32] = "AsteriskDelimited";
      ListFormat2[ListFormat2["DelimitersMask"] = 60] = "DelimitersMask";
      ListFormat2[ListFormat2["AllowTrailingComma"] = 64] = "AllowTrailingComma";
      ListFormat2[ListFormat2["Indented"] = 128] = "Indented";
      ListFormat2[ListFormat2["SpaceBetweenBraces"] = 256] = "SpaceBetweenBraces";
      ListFormat2[ListFormat2["SpaceBetweenSiblings"] = 512] = "SpaceBetweenSiblings";
      ListFormat2[ListFormat2["Braces"] = 1024] = "Braces";
      ListFormat2[ListFormat2["Parenthesis"] = 2048] = "Parenthesis";
      ListFormat2[ListFormat2["AngleBrackets"] = 4096] = "AngleBrackets";
      ListFormat2[ListFormat2["SquareBrackets"] = 8192] = "SquareBrackets";
      ListFormat2[ListFormat2["BracketsMask"] = 15360] = "BracketsMask";
      ListFormat2[ListFormat2["OptionalIfUndefined"] = 16384] = "OptionalIfUndefined";
      ListFormat2[ListFormat2["OptionalIfEmpty"] = 32768] = "OptionalIfEmpty";
      ListFormat2[ListFormat2["Optional"] = 49152] = "Optional";
      ListFormat2[ListFormat2["PreferNewLine"] = 65536] = "PreferNewLine";
      ListFormat2[ListFormat2["NoTrailingNewLine"] = 131072] = "NoTrailingNewLine";
      ListFormat2[ListFormat2["NoInterveningComments"] = 262144] = "NoInterveningComments";
      ListFormat2[ListFormat2["NoSpaceIfEmpty"] = 524288] = "NoSpaceIfEmpty";
      ListFormat2[ListFormat2["SingleElement"] = 1048576] = "SingleElement";
      ListFormat2[ListFormat2["SpaceAfterList"] = 2097152] = "SpaceAfterList";
      ListFormat2[ListFormat2["Modifiers"] = 262656] = "Modifiers";
      ListFormat2[ListFormat2["HeritageClauses"] = 512] = "HeritageClauses";
      ListFormat2[ListFormat2["SingleLineTypeLiteralMembers"] = 768] = "SingleLineTypeLiteralMembers";
      ListFormat2[ListFormat2["MultiLineTypeLiteralMembers"] = 32897] = "MultiLineTypeLiteralMembers";
      ListFormat2[ListFormat2["SingleLineTupleTypeElements"] = 528] = "SingleLineTupleTypeElements";
      ListFormat2[ListFormat2["MultiLineTupleTypeElements"] = 657] = "MultiLineTupleTypeElements";
      ListFormat2[ListFormat2["UnionTypeConstituents"] = 516] = "UnionTypeConstituents";
      ListFormat2[ListFormat2["IntersectionTypeConstituents"] = 520] = "IntersectionTypeConstituents";
      ListFormat2[ListFormat2["ObjectBindingPatternElements"] = 525136] = "ObjectBindingPatternElements";
      ListFormat2[ListFormat2["ArrayBindingPatternElements"] = 524880] = "ArrayBindingPatternElements";
      ListFormat2[ListFormat2["ObjectLiteralExpressionProperties"] = 526226] = "ObjectLiteralExpressionProperties";
      ListFormat2[ListFormat2["ArrayLiteralExpressionElements"] = 8914] = "ArrayLiteralExpressionElements";
      ListFormat2[ListFormat2["CommaListElements"] = 528] = "CommaListElements";
      ListFormat2[ListFormat2["CallExpressionArguments"] = 2576] = "CallExpressionArguments";
      ListFormat2[ListFormat2["NewExpressionArguments"] = 18960] = "NewExpressionArguments";
      ListFormat2[ListFormat2["TemplateExpressionSpans"] = 262144] = "TemplateExpressionSpans";
      ListFormat2[ListFormat2["SingleLineBlockStatements"] = 768] = "SingleLineBlockStatements";
      ListFormat2[ListFormat2["MultiLineBlockStatements"] = 129] = "MultiLineBlockStatements";
      ListFormat2[ListFormat2["VariableDeclarationList"] = 528] = "VariableDeclarationList";
      ListFormat2[ListFormat2["SingleLineFunctionBodyStatements"] = 768] = "SingleLineFunctionBodyStatements";
      ListFormat2[ListFormat2["MultiLineFunctionBodyStatements"] = 1] = "MultiLineFunctionBodyStatements";
      ListFormat2[ListFormat2["ClassHeritageClauses"] = 0] = "ClassHeritageClauses";
      ListFormat2[ListFormat2["ClassMembers"] = 129] = "ClassMembers";
      ListFormat2[ListFormat2["InterfaceMembers"] = 129] = "InterfaceMembers";
      ListFormat2[ListFormat2["EnumMembers"] = 145] = "EnumMembers";
      ListFormat2[ListFormat2["CaseBlockClauses"] = 129] = "CaseBlockClauses";
      ListFormat2[ListFormat2["NamedImportsOrExportsElements"] = 525136] = "NamedImportsOrExportsElements";
      ListFormat2[ListFormat2["JsxElementOrFragmentChildren"] = 262144] = "JsxElementOrFragmentChildren";
      ListFormat2[ListFormat2["JsxElementAttributes"] = 262656] = "JsxElementAttributes";
      ListFormat2[ListFormat2["CaseOrDefaultClauseStatements"] = 163969] = "CaseOrDefaultClauseStatements";
      ListFormat2[ListFormat2["HeritageClauseTypes"] = 528] = "HeritageClauseTypes";
      ListFormat2[ListFormat2["SourceFileStatements"] = 131073] = "SourceFileStatements";
      ListFormat2[ListFormat2["Decorators"] = 2146305] = "Decorators";
      ListFormat2[ListFormat2["TypeArguments"] = 53776] = "TypeArguments";
      ListFormat2[ListFormat2["TypeParameters"] = 53776] = "TypeParameters";
      ListFormat2[ListFormat2["Parameters"] = 2576] = "Parameters";
      ListFormat2[ListFormat2["IndexSignatureParameters"] = 8848] = "IndexSignatureParameters";
      ListFormat2[ListFormat2["JSDocComment"] = 33] = "JSDocComment";
    })(ListFormat = ts2.ListFormat || (ts2.ListFormat = {}));
    var PragmaKindFlags;
    (function(PragmaKindFlags2) {
      PragmaKindFlags2[PragmaKindFlags2["None"] = 0] = "None";
      PragmaKindFlags2[PragmaKindFlags2["TripleSlashXML"] = 1] = "TripleSlashXML";
      PragmaKindFlags2[PragmaKindFlags2["SingleLine"] = 2] = "SingleLine";
      PragmaKindFlags2[PragmaKindFlags2["MultiLine"] = 4] = "MultiLine";
      PragmaKindFlags2[PragmaKindFlags2["All"] = 7] = "All";
      PragmaKindFlags2[PragmaKindFlags2["Default"] = 7] = "Default";
    })(PragmaKindFlags = ts2.PragmaKindFlags || (ts2.PragmaKindFlags = {}));
    ts2.commentPragmas = {
      "reference": {
        args: [
          { name: "types", optional: true, captureSpan: true },
          { name: "lib", optional: true, captureSpan: true },
          { name: "path", optional: true, captureSpan: true },
          { name: "no-default-lib", optional: true }
        ],
        kind: 1
      },
      "amd-dependency": {
        args: [{ name: "path" }, { name: "name", optional: true }],
        kind: 1
      },
      "amd-module": {
        args: [{ name: "name" }],
        kind: 1
      },
      "ts-check": {
        kind: 2
      },
      "ts-nocheck": {
        kind: 2
      },
      "jsx": {
        args: [{ name: "factory" }],
        kind: 4
      },
      "jsxfrag": {
        args: [{ name: "factory" }],
        kind: 4
      },
      "jsximportsource": {
        args: [{ name: "factory" }],
        kind: 4
      },
      "jsxruntime": {
        args: [{ name: "factory" }],
        kind: 4
      }
    };
  })(ts || (ts = {}));
  var ts;
  (function(ts2) {
    ts2.directorySeparator = "/";
    ts2.altDirectorySeparator = "\\";
    var urlSchemeSeparator = "://";
    var backslashRegExp = /\\/g;
    function isAnyDirectorySeparator(charCode) {
      return charCode === 47 || charCode === 92;
    }
    ts2.isAnyDirectorySeparator = isAnyDirectorySeparator;
    function isUrl(path) {
      return getEncodedRootLength(path) < 0;
    }
    ts2.isUrl = isUrl;
    function isRootedDiskPath(path) {
      return getEncodedRootLength(path) > 0;
    }
    ts2.isRootedDiskPath = isRootedDiskPath;
    function isDiskPathRoot(path) {
      var rootLength = getEncodedRootLength(path);
      return rootLength > 0 && rootLength === path.length;
    }
    ts2.isDiskPathRoot = isDiskPathRoot;
    function pathIsAbsolute(path) {
      return getEncodedRootLength(path) !== 0;
    }
    ts2.pathIsAbsolute = pathIsAbsolute;
    function pathIsRelative(path) {
      return /^\.\.?($|[\\/])/.test(path);
    }
    ts2.pathIsRelative = pathIsRelative;
    function pathIsBareSpecifier(path) {
      return !pathIsAbsolute(path) && !pathIsRelative(path);
    }
    ts2.pathIsBareSpecifier = pathIsBareSpecifier;
    function hasExtension(fileName) {
      return ts2.stringContains(getBaseFileName(fileName), ".");
    }
    ts2.hasExtension = hasExtension;
    function fileExtensionIs(path, extension) {
      return path.length > extension.length && ts2.endsWith(path, extension);
    }
    ts2.fileExtensionIs = fileExtensionIs;
    function fileExtensionIsOneOf(path, extensions) {
      for (var _i = 0, extensions_1 = extensions; _i < extensions_1.length; _i++) {
        var extension = extensions_1[_i];
        if (fileExtensionIs(path, extension)) {
          return true;
        }
      }
      return false;
    }
    ts2.fileExtensionIsOneOf = fileExtensionIsOneOf;
    function hasTrailingDirectorySeparator(path) {
      return path.length > 0 && isAnyDirectorySeparator(path.charCodeAt(path.length - 1));
    }
    ts2.hasTrailingDirectorySeparator = hasTrailingDirectorySeparator;
    function isVolumeCharacter(charCode) {
      return charCode >= 97 && charCode <= 122 || charCode >= 65 && charCode <= 90;
    }
    function getFileUrlVolumeSeparatorEnd(url, start) {
      var ch0 = url.charCodeAt(start);
      if (ch0 === 58)
        return start + 1;
      if (ch0 === 37 && url.charCodeAt(start + 1) === 51) {
        var ch2 = url.charCodeAt(start + 2);
        if (ch2 === 97 || ch2 === 65)
          return start + 3;
      }
      return -1;
    }
    function getEncodedRootLength(path) {
      if (!path)
        return 0;
      var ch0 = path.charCodeAt(0);
      if (ch0 === 47 || ch0 === 92) {
        if (path.charCodeAt(1) !== ch0)
          return 1;
        var p1 = path.indexOf(ch0 === 47 ? ts2.directorySeparator : ts2.altDirectorySeparator, 2);
        if (p1 < 0)
          return path.length;
        return p1 + 1;
      }
      if (isVolumeCharacter(ch0) && path.charCodeAt(1) === 58) {
        var ch2 = path.charCodeAt(2);
        if (ch2 === 47 || ch2 === 92)
          return 3;
        if (path.length === 2)
          return 2;
      }
      var schemeEnd = path.indexOf(urlSchemeSeparator);
      if (schemeEnd !== -1) {
        var authorityStart = schemeEnd + urlSchemeSeparator.length;
        var authorityEnd = path.indexOf(ts2.directorySeparator, authorityStart);
        if (authorityEnd !== -1) {
          var scheme = path.slice(0, schemeEnd);
          var authority = path.slice(authorityStart, authorityEnd);
          if (scheme === "file" && (authority === "" || authority === "localhost") && isVolumeCharacter(path.charCodeAt(authorityEnd + 1))) {
            var volumeSeparatorEnd = getFileUrlVolumeSeparatorEnd(path, authorityEnd + 2);
            if (volumeSeparatorEnd !== -1) {
              if (path.charCodeAt(volumeSeparatorEnd) === 47) {
                return ~(volumeSeparatorEnd + 1);
              }
              if (volumeSeparatorEnd === path.length) {
                return ~volumeSeparatorEnd;
              }
            }
          }
          return ~(authorityEnd + 1);
        }
        return ~path.length;
      }
      return 0;
    }
    function getRootLength(path) {
      var rootLength = getEncodedRootLength(path);
      return rootLength < 0 ? ~rootLength : rootLength;
    }
    ts2.getRootLength = getRootLength;
    function getDirectoryPath(path) {
      path = normalizeSlashes(path);
      var rootLength = getRootLength(path);
      if (rootLength === path.length)
        return path;
      path = removeTrailingDirectorySeparator(path);
      return path.slice(0, Math.max(rootLength, path.lastIndexOf(ts2.directorySeparator)));
    }
    ts2.getDirectoryPath = getDirectoryPath;
    function getBaseFileName(path, extensions, ignoreCase) {
      path = normalizeSlashes(path);
      var rootLength = getRootLength(path);
      if (rootLength === path.length)
        return "";
      path = removeTrailingDirectorySeparator(path);
      var name = path.slice(Math.max(getRootLength(path), path.lastIndexOf(ts2.directorySeparator) + 1));
      var extension = extensions !== void 0 && ignoreCase !== void 0 ? getAnyExtensionFromPath(name, extensions, ignoreCase) : void 0;
      return extension ? name.slice(0, name.length - extension.length) : name;
    }
    ts2.getBaseFileName = getBaseFileName;
    function tryGetExtensionFromPath(path, extension, stringEqualityComparer) {
      if (!ts2.startsWith(extension, "."))
        extension = "." + extension;
      if (path.length >= extension.length && path.charCodeAt(path.length - extension.length) === 46) {
        var pathExtension = path.slice(path.length - extension.length);
        if (stringEqualityComparer(pathExtension, extension)) {
          return pathExtension;
        }
      }
    }
    function getAnyExtensionFromPathWorker(path, extensions, stringEqualityComparer) {
      if (typeof extensions === "string") {
        return tryGetExtensionFromPath(path, extensions, stringEqualityComparer) || "";
      }
      for (var _i = 0, extensions_2 = extensions; _i < extensions_2.length; _i++) {
        var extension = extensions_2[_i];
        var result = tryGetExtensionFromPath(path, extension, stringEqualityComparer);
        if (result)
          return result;
      }
      return "";
    }
    function getAnyExtensionFromPath(path, extensions, ignoreCase) {
      if (extensions) {
        return getAnyExtensionFromPathWorker(removeTrailingDirectorySeparator(path), extensions, ignoreCase ? ts2.equateStringsCaseInsensitive : ts2.equateStringsCaseSensitive);
      }
      var baseFileName = getBaseFileName(path);
      var extensionIndex = baseFileName.lastIndexOf(".");
      if (extensionIndex >= 0) {
        return baseFileName.substring(extensionIndex);
      }
      return "";
    }
    ts2.getAnyExtensionFromPath = getAnyExtensionFromPath;
    function pathComponents(path, rootLength) {
      var root = path.substring(0, rootLength);
      var rest = path.substring(rootLength).split(ts2.directorySeparator);
      if (rest.length && !ts2.lastOrUndefined(rest))
        rest.pop();
      return __spreadArray([root], rest, true);
    }
    function getPathComponents(path, currentDirectory) {
      if (currentDirectory === void 0) {
        currentDirectory = "";
      }
      path = combinePaths(currentDirectory, path);
      return pathComponents(path, getRootLength(path));
    }
    ts2.getPathComponents = getPathComponents;
    function getPathFromPathComponents(pathComponents2) {
      if (pathComponents2.length === 0)
        return "";
      var root = pathComponents2[0] && ensureTrailingDirectorySeparator(pathComponents2[0]);
      return root + pathComponents2.slice(1).join(ts2.directorySeparator);
    }
    ts2.getPathFromPathComponents = getPathFromPathComponents;
    function normalizeSlashes(path) {
      var index = path.indexOf("\\");
      if (index === -1) {
        return path;
      }
      backslashRegExp.lastIndex = index;
      return path.replace(backslashRegExp, ts2.directorySeparator);
    }
    ts2.normalizeSlashes = normalizeSlashes;
    function reducePathComponents(components) {
      if (!ts2.some(components))
        return [];
      var reduced = [components[0]];
      for (var i = 1; i < components.length; i++) {
        var component = components[i];
        if (!component)
          continue;
        if (component === ".")
          continue;
        if (component === "..") {
          if (reduced.length > 1) {
            if (reduced[reduced.length - 1] !== "..") {
              reduced.pop();
              continue;
            }
          } else if (reduced[0])
            continue;
        }
        reduced.push(component);
      }
      return reduced;
    }
    ts2.reducePathComponents = reducePathComponents;
    function combinePaths(path) {
      var paths = [];
      for (var _i = 1; _i < arguments.length; _i++) {
        paths[_i - 1] = arguments[_i];
      }
      if (path)
        path = normalizeSlashes(path);
      for (var _a = 0, paths_1 = paths; _a < paths_1.length; _a++) {
        var relativePath = paths_1[_a];
        if (!relativePath)
          continue;
        relativePath = normalizeSlashes(relativePath);
        if (!path || getRootLength(relativePath) !== 0) {
          path = relativePath;
        } else {
          path = ensureTrailingDirectorySeparator(path) + relativePath;
        }
      }
      return path;
    }
    ts2.combinePaths = combinePaths;
    function resolvePath(path) {
      var paths = [];
      for (var _i = 1; _i < arguments.length; _i++) {
        paths[_i - 1] = arguments[_i];
      }
      return normalizePath(ts2.some(paths) ? combinePaths.apply(void 0, __spreadArray([path], paths, false)) : normalizeSlashes(path));
    }
    ts2.resolvePath = resolvePath;
    function getNormalizedPathComponents(path, currentDirectory) {
      return reducePathComponents(getPathComponents(path, currentDirectory));
    }
    ts2.getNormalizedPathComponents = getNormalizedPathComponents;
    function getNormalizedAbsolutePath(fileName, currentDirectory) {
      return getPathFromPathComponents(getNormalizedPathComponents(fileName, currentDirectory));
    }
    ts2.getNormalizedAbsolutePath = getNormalizedAbsolutePath;
    function normalizePath(path) {
      path = normalizeSlashes(path);
      if (!relativePathSegmentRegExp.test(path)) {
        return path;
      }
      var simplified = path.replace(/\/\.\//g, "/").replace(/^\.\//, "");
      if (simplified !== path) {
        path = simplified;
        if (!relativePathSegmentRegExp.test(path)) {
          return path;
        }
      }
      var normalized = getPathFromPathComponents(reducePathComponents(getPathComponents(path)));
      return normalized && hasTrailingDirectorySeparator(path) ? ensureTrailingDirectorySeparator(normalized) : normalized;
    }
    ts2.normalizePath = normalizePath;
    function getPathWithoutRoot(pathComponents2) {
      if (pathComponents2.length === 0)
        return "";
      return pathComponents2.slice(1).join(ts2.directorySeparator);
    }
    function getNormalizedAbsolutePathWithoutRoot(fileName, currentDirectory) {
      return getPathWithoutRoot(getNormalizedPathComponents(fileName, currentDirectory));
    }
    ts2.getNormalizedAbsolutePathWithoutRoot = getNormalizedAbsolutePathWithoutRoot;
    function toPath(fileName, basePath, getCanonicalFileName) {
      var nonCanonicalizedPath = isRootedDiskPath(fileName) ? normalizePath(fileName) : getNormalizedAbsolutePath(fileName, basePath);
      return getCanonicalFileName(nonCanonicalizedPath);
    }
    ts2.toPath = toPath;
    function normalizePathAndParts(path) {
      path = normalizeSlashes(path);
      var _a = reducePathComponents(getPathComponents(path)), root = _a[0], parts = _a.slice(1);
      if (parts.length) {
        var joinedParts = root + parts.join(ts2.directorySeparator);
        return { path: hasTrailingDirectorySeparator(path) ? ensureTrailingDirectorySeparator(joinedParts) : joinedParts, parts };
      } else {
        return { path: root, parts };
      }
    }
    ts2.normalizePathAndParts = normalizePathAndParts;
    function removeTrailingDirectorySeparator(path) {
      if (hasTrailingDirectorySeparator(path)) {
        return path.substr(0, path.length - 1);
      }
      return path;
    }
    ts2.removeTrailingDirectorySeparator = removeTrailingDirectorySeparator;
    function ensureTrailingDirectorySeparator(path) {
      if (!hasTrailingDirectorySeparator(path)) {
        return path + ts2.directorySeparator;
      }
      return path;
    }
    ts2.ensureTrailingDirectorySeparator = ensureTrailingDirectorySeparator;
    function ensurePathIsNonModuleName(path) {
      return !pathIsAbsolute(path) && !pathIsRelative(path) ? "./" + path : path;
    }
    ts2.ensurePathIsNonModuleName = ensurePathIsNonModuleName;
    function changeAnyExtension(path, ext, extensions, ignoreCase) {
      var pathext = extensions !== void 0 && ignoreCase !== void 0 ? getAnyExtensionFromPath(path, extensions, ignoreCase) : getAnyExtensionFromPath(path);
      return pathext ? path.slice(0, path.length - pathext.length) + (ts2.startsWith(ext, ".") ? ext : "." + ext) : path;
    }
    ts2.changeAnyExtension = changeAnyExtension;
    var relativePathSegmentRegExp = /(?:\/\/)|(?:^|\/)\.\.?(?:$|\/)/;
    function comparePathsWorker(a, b, componentComparer) {
      if (a === b)
        return 0;
      if (a === void 0)
        return -1;
      if (b === void 0)
        return 1;
      var aRoot = a.substring(0, getRootLength(a));
      var bRoot = b.substring(0, getRootLength(b));
      var result = ts2.compareStringsCaseInsensitive(aRoot, bRoot);
      if (result !== 0) {
        return result;
      }
      var aRest = a.substring(aRoot.length);
      var bRest = b.substring(bRoot.length);
      if (!relativePathSegmentRegExp.test(aRest) && !relativePathSegmentRegExp.test(bRest)) {
        return componentComparer(aRest, bRest);
      }
      var aComponents = reducePathComponents(getPathComponents(a));
      var bComponents = reducePathComponents(getPathComponents(b));
      var sharedLength = Math.min(aComponents.length, bComponents.length);
      for (var i = 1; i < sharedLength; i++) {
        var result_2 = componentComparer(aComponents[i], bComponents[i]);
        if (result_2 !== 0) {
          return result_2;
        }
      }
      return ts2.compareValues(aComponents.length, bComponents.length);
    }
    function comparePathsCaseSensitive(a, b) {
      return comparePathsWorker(a, b, ts2.compareStringsCaseSensitive);
    }
    ts2.comparePathsCaseSensitive = comparePathsCaseSensitive;
    function comparePathsCaseInsensitive(a, b) {
      return comparePathsWorker(a, b, ts2.compareStringsCaseInsensitive);
    }
    ts2.comparePathsCaseInsensitive = comparePathsCaseInsensitive;
    function comparePaths(a, b, currentDirectory, ignoreCase) {
      if (typeof currentDirectory === "string") {
        a = combinePaths(currentDirectory, a);
        b = combinePaths(currentDirectory, b);
      } else if (typeof currentDirectory === "boolean") {
        ignoreCase = currentDirectory;
      }
      return comparePathsWorker(a, b, ts2.getStringComparer(ignoreCase));
    }
    ts2.comparePaths = comparePaths;
    function containsPath(parent, child, currentDirectory, ignoreCase) {
      if (typeof currentDirectory === "string") {
        parent = combinePaths(currentDirectory, parent);
        child = combinePaths(currentDirectory, child);
      } else if (typeof currentDirectory === "boolean") {
        ignoreCase = currentDirectory;
      }
      if (parent === void 0 || child === void 0)
        return false;
      if (parent === child)
        return true;
      var parentComponents = reducePathComponents(getPathComponents(parent));
      var childComponents = reducePathComponents(getPathComponents(child));
      if (childComponents.length < parentComponents.length) {
        return false;
      }
      var componentEqualityComparer = ignoreCase ? ts2.equateStringsCaseInsensitive : ts2.equateStringsCaseSensitive;
      for (var i = 0; i < parentComponents.length; i++) {
        var equalityComparer = i === 0 ? ts2.equateStringsCaseInsensitive : componentEqualityComparer;
        if (!equalityComparer(parentComponents[i], childComponents[i])) {
          return false;
        }
      }
      return true;
    }
    ts2.containsPath = containsPath;
    function startsWithDirectory(fileName, directoryName, getCanonicalFileName) {
      var canonicalFileName = getCanonicalFileName(fileName);
      var canonicalDirectoryName = getCanonicalFileName(directoryName);
      return ts2.startsWith(canonicalFileName, canonicalDirectoryName + "/") || ts2.startsWith(canonicalFileName, canonicalDirectoryName + "\\");
    }
    ts2.startsWithDirectory = startsWithDirectory;
    function getPathComponentsRelativeTo(from, to, stringEqualityComparer, getCanonicalFileName) {
      var fromComponents = reducePathComponents(getPathComponents(from));
      var toComponents = reducePathComponents(getPathComponents(to));
      var start;
      for (start = 0; start < fromComponents.length && start < toComponents.length; start++) {
        var fromComponent = getCanonicalFileName(fromComponents[start]);
        var toComponent = getCanonicalFileName(toComponents[start]);
        var comparer = start === 0 ? ts2.equateStringsCaseInsensitive : stringEqualityComparer;
        if (!comparer(fromComponent, toComponent))
          break;
      }
      if (start === 0) {
        return toComponents;
      }
      var components = toComponents.slice(start);
      var relative = [];
      for (; start < fromComponents.length; start++) {
        relative.push("..");
      }
      return __spreadArray(__spreadArray([""], relative, true), components, true);
    }
    ts2.getPathComponentsRelativeTo = getPathComponentsRelativeTo;
    function getRelativePathFromDirectory(fromDirectory, to, getCanonicalFileNameOrIgnoreCase) {
      ts2.Debug.assert(getRootLength(fromDirectory) > 0 === getRootLength(to) > 0, "Paths must either both be absolute or both be relative");
      var getCanonicalFileName = typeof getCanonicalFileNameOrIgnoreCase === "function" ? getCanonicalFileNameOrIgnoreCase : ts2.identity;
      var ignoreCase = typeof getCanonicalFileNameOrIgnoreCase === "boolean" ? getCanonicalFileNameOrIgnoreCase : false;
      var pathComponents2 = getPathComponentsRelativeTo(fromDirectory, to, ignoreCase ? ts2.equateStringsCaseInsensitive : ts2.equateStringsCaseSensitive, getCanonicalFileName);
      return getPathFromPathComponents(pathComponents2);
    }
    ts2.getRelativePathFromDirectory = getRelativePathFromDirectory;
    function convertToRelativePath(absoluteOrRelativePath, basePath, getCanonicalFileName) {
      return !isRootedDiskPath(absoluteOrRelativePath) ? absoluteOrRelativePath : getRelativePathToDirectoryOrUrl(basePath, absoluteOrRelativePath, basePath, getCanonicalFileName, false);
    }
    ts2.convertToRelativePath = convertToRelativePath;
    function getRelativePathFromFile(from, to, getCanonicalFileName) {
      return ensurePathIsNonModuleName(getRelativePathFromDirectory(getDirectoryPath(from), to, getCanonicalFileName));
    }
    ts2.getRelativePathFromFile = getRelativePathFromFile;
    function getRelativePathToDirectoryOrUrl(directoryPathOrUrl, relativeOrAbsolutePath, currentDirectory, getCanonicalFileName, isAbsolutePathAnUrl) {
      var pathComponents2 = getPathComponentsRelativeTo(resolvePath(currentDirectory, directoryPathOrUrl), resolvePath(currentDirectory, relativeOrAbsolutePath), ts2.equateStringsCaseSensitive, getCanonicalFileName);
      var firstComponent = pathComponents2[0];
      if (isAbsolutePathAnUrl && isRootedDiskPath(firstComponent)) {
        var prefix = firstComponent.charAt(0) === ts2.directorySeparator ? "file://" : "file:///";
        pathComponents2[0] = prefix + firstComponent;
      }
      return getPathFromPathComponents(pathComponents2);
    }
    ts2.getRelativePathToDirectoryOrUrl = getRelativePathToDirectoryOrUrl;
    function forEachAncestorDirectory(directory, callback) {
      while (true) {
        var result = callback(directory);
        if (result !== void 0) {
          return result;
        }
        var parentPath = getDirectoryPath(directory);
        if (parentPath === directory) {
          return void 0;
        }
        directory = parentPath;
      }
    }
    ts2.forEachAncestorDirectory = forEachAncestorDirectory;
    function isNodeModulesDirectory(dirPath) {
      return ts2.endsWith(dirPath, "/node_modules");
    }
    ts2.isNodeModulesDirectory = isNodeModulesDirectory;
  })(ts || (ts = {}));
  var ts;
  (function(ts2) {
    function generateDjb2Hash(data) {
      var acc = 5381;
      for (var i = 0; i < data.length; i++) {
        acc = (acc << 5) + acc + data.charCodeAt(i);
      }
      return acc.toString();
    }
    ts2.generateDjb2Hash = generateDjb2Hash;
    function setStackTraceLimit() {
      if (Error.stackTraceLimit < 100) {
        Error.stackTraceLimit = 100;
      }
    }
    ts2.setStackTraceLimit = setStackTraceLimit;
    var FileWatcherEventKind;
    (function(FileWatcherEventKind2) {
      FileWatcherEventKind2[FileWatcherEventKind2["Created"] = 0] = "Created";
      FileWatcherEventKind2[FileWatcherEventKind2["Changed"] = 1] = "Changed";
      FileWatcherEventKind2[FileWatcherEventKind2["Deleted"] = 2] = "Deleted";
    })(FileWatcherEventKind = ts2.FileWatcherEventKind || (ts2.FileWatcherEventKind = {}));
    var PollingInterval;
    (function(PollingInterval2) {
      PollingInterval2[PollingInterval2["High"] = 2e3] = "High";
      PollingInterval2[PollingInterval2["Medium"] = 500] = "Medium";
      PollingInterval2[PollingInterval2["Low"] = 250] = "Low";
    })(PollingInterval = ts2.PollingInterval || (ts2.PollingInterval = {}));
    ts2.missingFileModifiedTime = new Date(0);
    function getModifiedTime(host, fileName) {
      return host.getModifiedTime(fileName) || ts2.missingFileModifiedTime;
    }
    ts2.getModifiedTime = getModifiedTime;
    function createPollingIntervalBasedLevels(levels) {
      var _a;
      return _a = {}, _a[PollingInterval.Low] = levels.Low, _a[PollingInterval.Medium] = levels.Medium, _a[PollingInterval.High] = levels.High, _a;
    }
    var defaultChunkLevels = { Low: 32, Medium: 64, High: 256 };
    var pollingChunkSize = createPollingIntervalBasedLevels(defaultChunkLevels);
    ts2.unchangedPollThresholds = createPollingIntervalBasedLevels(defaultChunkLevels);
    function setCustomPollingValues(system) {
      if (!system.getEnvironmentVariable) {
        return;
      }
      var pollingIntervalChanged = setCustomLevels("TSC_WATCH_POLLINGINTERVAL", PollingInterval);
      pollingChunkSize = getCustomPollingBasedLevels("TSC_WATCH_POLLINGCHUNKSIZE", defaultChunkLevels) || pollingChunkSize;
      ts2.unchangedPollThresholds = getCustomPollingBasedLevels("TSC_WATCH_UNCHANGEDPOLLTHRESHOLDS", defaultChunkLevels) || ts2.unchangedPollThresholds;
      function getLevel(envVar, level) {
        return system.getEnvironmentVariable(envVar + "_" + level.toUpperCase());
      }
      function getCustomLevels(baseVariable) {
        var customLevels;
        setCustomLevel("Low");
        setCustomLevel("Medium");
        setCustomLevel("High");
        return customLevels;
        function setCustomLevel(level) {
          var customLevel = getLevel(baseVariable, level);
          if (customLevel) {
            (customLevels || (customLevels = {}))[level] = Number(customLevel);
          }
        }
      }
      function setCustomLevels(baseVariable, levels) {
        var customLevels = getCustomLevels(baseVariable);
        if (customLevels) {
          setLevel("Low");
          setLevel("Medium");
          setLevel("High");
          return true;
        }
        return false;
        function setLevel(level) {
          levels[level] = customLevels[level] || levels[level];
        }
      }
      function getCustomPollingBasedLevels(baseVariable, defaultLevels) {
        var customLevels = getCustomLevels(baseVariable);
        return (pollingIntervalChanged || customLevels) && createPollingIntervalBasedLevels(customLevels ? __assign(__assign({}, defaultLevels), customLevels) : defaultLevels);
      }
    }
    ts2.setCustomPollingValues = setCustomPollingValues;
    function pollWatchedFileQueue(host, queue, pollIndex, chunkSize, callbackOnWatchFileStat) {
      var definedValueCopyToIndex = pollIndex;
      for (var canVisit = queue.length; chunkSize && canVisit; nextPollIndex(), canVisit--) {
        var watchedFile = queue[pollIndex];
        if (!watchedFile) {
          continue;
        } else if (watchedFile.isClosed) {
          queue[pollIndex] = void 0;
          continue;
        }
        chunkSize--;
        var fileChanged = onWatchedFileStat(watchedFile, getModifiedTime(host, watchedFile.fileName));
        if (watchedFile.isClosed) {
          queue[pollIndex] = void 0;
          continue;
        }
        callbackOnWatchFileStat === null || callbackOnWatchFileStat === void 0 ? void 0 : callbackOnWatchFileStat(watchedFile, pollIndex, fileChanged);
        if (queue[pollIndex]) {
          if (definedValueCopyToIndex < pollIndex) {
            queue[definedValueCopyToIndex] = watchedFile;
            queue[pollIndex] = void 0;
          }
          definedValueCopyToIndex++;
        }
      }
      return pollIndex;
      function nextPollIndex() {
        pollIndex++;
        if (pollIndex === queue.length) {
          if (definedValueCopyToIndex < pollIndex) {
            queue.length = definedValueCopyToIndex;
          }
          pollIndex = 0;
          definedValueCopyToIndex = 0;
        }
      }
    }
    function createDynamicPriorityPollingWatchFile(host) {
      var watchedFiles = [];
      var changedFilesInLastPoll = [];
      var lowPollingIntervalQueue = createPollingIntervalQueue(PollingInterval.Low);
      var mediumPollingIntervalQueue = createPollingIntervalQueue(PollingInterval.Medium);
      var highPollingIntervalQueue = createPollingIntervalQueue(PollingInterval.High);
      return watchFile;
      function watchFile(fileName, callback, defaultPollingInterval) {
        var file = {
          fileName,
          callback,
          unchangedPolls: 0,
          mtime: getModifiedTime(host, fileName)
        };
        watchedFiles.push(file);
        addToPollingIntervalQueue(file, defaultPollingInterval);
        return {
          close: function() {
            file.isClosed = true;
            ts2.unorderedRemoveItem(watchedFiles, file);
          }
        };
      }
      function createPollingIntervalQueue(pollingInterval) {
        var queue = [];
        queue.pollingInterval = pollingInterval;
        queue.pollIndex = 0;
        queue.pollScheduled = false;
        return queue;
      }
      function pollPollingIntervalQueue(queue) {
        queue.pollIndex = pollQueue(queue, queue.pollingInterval, queue.pollIndex, pollingChunkSize[queue.pollingInterval]);
        if (queue.length) {
          scheduleNextPoll(queue.pollingInterval);
        } else {
          ts2.Debug.assert(queue.pollIndex === 0);
          queue.pollScheduled = false;
        }
      }
      function pollLowPollingIntervalQueue(queue) {
        pollQueue(changedFilesInLastPoll, PollingInterval.Low, 0, changedFilesInLastPoll.length);
        pollPollingIntervalQueue(queue);
        if (!queue.pollScheduled && changedFilesInLastPoll.length) {
          scheduleNextPoll(PollingInterval.Low);
        }
      }
      function pollQueue(queue, pollingInterval, pollIndex, chunkSize) {
        return pollWatchedFileQueue(host, queue, pollIndex, chunkSize, onWatchFileStat);
        function onWatchFileStat(watchedFile, pollIndex2, fileChanged) {
          if (fileChanged) {
            watchedFile.unchangedPolls = 0;
            if (queue !== changedFilesInLastPoll) {
              queue[pollIndex2] = void 0;
              addChangedFileToLowPollingIntervalQueue(watchedFile);
            }
          } else if (watchedFile.unchangedPolls !== ts2.unchangedPollThresholds[pollingInterval]) {
            watchedFile.unchangedPolls++;
          } else if (queue === changedFilesInLastPoll) {
            watchedFile.unchangedPolls = 1;
            queue[pollIndex2] = void 0;
            addToPollingIntervalQueue(watchedFile, PollingInterval.Low);
          } else if (pollingInterval !== PollingInterval.High) {
            watchedFile.unchangedPolls++;
            queue[pollIndex2] = void 0;
            addToPollingIntervalQueue(watchedFile, pollingInterval === PollingInterval.Low ? PollingInterval.Medium : PollingInterval.High);
          }
        }
      }
      function pollingIntervalQueue(pollingInterval) {
        switch (pollingInterval) {
          case PollingInterval.Low:
            return lowPollingIntervalQueue;
          case PollingInterval.Medium:
            return mediumPollingIntervalQueue;
          case PollingInterval.High:
            return highPollingIntervalQueue;
        }
      }
      function addToPollingIntervalQueue(file, pollingInterval) {
        pollingIntervalQueue(pollingInterval).push(file);
        scheduleNextPollIfNotAlreadyScheduled(pollingInterval);
      }
      function addChangedFileToLowPollingIntervalQueue(file) {
        changedFilesInLastPoll.push(file);
        scheduleNextPollIfNotAlreadyScheduled(PollingInterval.Low);
      }
      function scheduleNextPollIfNotAlreadyScheduled(pollingInterval) {
        if (!pollingIntervalQueue(pollingInterval).pollScheduled) {
          scheduleNextPoll(pollingInterval);
        }
      }
      function scheduleNextPoll(pollingInterval) {
        pollingIntervalQueue(pollingInterval).pollScheduled = host.setTimeout(pollingInterval === PollingInterval.Low ? pollLowPollingIntervalQueue : pollPollingIntervalQueue, pollingInterval, pollingIntervalQueue(pollingInterval));
      }
    }
    ts2.createDynamicPriorityPollingWatchFile = createDynamicPriorityPollingWatchFile;
    function createUseFsEventsOnParentDirectoryWatchFile(fsWatch, useCaseSensitiveFileNames) {
      var fileWatcherCallbacks = ts2.createMultiMap();
      var dirWatchers = new ts2.Map();
      var toCanonicalName = ts2.createGetCanonicalFileName(useCaseSensitiveFileNames);
      return nonPollingWatchFile;
      function nonPollingWatchFile(fileName, callback, _pollingInterval, fallbackOptions) {
        var filePath = toCanonicalName(fileName);
        fileWatcherCallbacks.add(filePath, callback);
        var dirPath = ts2.getDirectoryPath(filePath) || ".";
        var watcher = dirWatchers.get(dirPath) || createDirectoryWatcher(ts2.getDirectoryPath(fileName) || ".", dirPath, fallbackOptions);
        watcher.referenceCount++;
        return {
          close: function() {
            if (watcher.referenceCount === 1) {
              watcher.close();
              dirWatchers.delete(dirPath);
            } else {
              watcher.referenceCount--;
            }
            fileWatcherCallbacks.remove(filePath, callback);
          }
        };
      }
      function createDirectoryWatcher(dirName, dirPath, fallbackOptions) {
        var watcher = fsWatch(dirName, 1, function(_eventName, relativeFileName) {
          if (!ts2.isString(relativeFileName)) {
            return;
          }
          var fileName = ts2.getNormalizedAbsolutePath(relativeFileName, dirName);
          var callbacks = fileName && fileWatcherCallbacks.get(toCanonicalName(fileName));
          if (callbacks) {
            for (var _i = 0, callbacks_1 = callbacks; _i < callbacks_1.length; _i++) {
              var fileCallback = callbacks_1[_i];
              fileCallback(fileName, FileWatcherEventKind.Changed);
            }
          }
        }, false, PollingInterval.Medium, fallbackOptions);
        watcher.referenceCount = 0;
        dirWatchers.set(dirPath, watcher);
        return watcher;
      }
    }
    function createFixedChunkSizePollingWatchFile(host) {
      var watchedFiles = [];
      var pollIndex = 0;
      var pollScheduled;
      return watchFile;
      function watchFile(fileName, callback) {
        var file = {
          fileName,
          callback,
          mtime: getModifiedTime(host, fileName)
        };
        watchedFiles.push(file);
        scheduleNextPoll();
        return {
          close: function() {
            file.isClosed = true;
            ts2.unorderedRemoveItem(watchedFiles, file);
          }
        };
      }
      function pollQueue() {
        pollScheduled = void 0;
        pollIndex = pollWatchedFileQueue(host, watchedFiles, pollIndex, pollingChunkSize[PollingInterval.Low]);
        scheduleNextPoll();
      }
      function scheduleNextPoll() {
        if (!watchedFiles.length || pollScheduled)
          return;
        pollScheduled = host.setTimeout(pollQueue, PollingInterval.High);
      }
    }
    function createSingleFileWatcherPerName(watchFile, useCaseSensitiveFileNames) {
      var cache = new ts2.Map();
      var callbacksCache = ts2.createMultiMap();
      var toCanonicalFileName = ts2.createGetCanonicalFileName(useCaseSensitiveFileNames);
      return function(fileName, callback, pollingInterval, options) {
        var path = toCanonicalFileName(fileName);
        var existing = cache.get(path);
        if (existing) {
          existing.refCount++;
        } else {
          cache.set(path, {
            watcher: watchFile(fileName, function(fileName2, eventKind) {
              return ts2.forEach(callbacksCache.get(path), function(cb) {
                return cb(fileName2, eventKind);
              });
            }, pollingInterval, options),
            refCount: 1
          });
        }
        callbacksCache.add(path, callback);
        return {
          close: function() {
            var watcher = ts2.Debug.checkDefined(cache.get(path));
            callbacksCache.remove(path, callback);
            watcher.refCount--;
            if (watcher.refCount)
              return;
            cache.delete(path);
            ts2.closeFileWatcherOf(watcher);
          }
        };
      };
    }
    ts2.createSingleFileWatcherPerName = createSingleFileWatcherPerName;
    function onWatchedFileStat(watchedFile, modifiedTime) {
      var oldTime = watchedFile.mtime.getTime();
      var newTime = modifiedTime.getTime();
      if (oldTime !== newTime) {
        watchedFile.mtime = modifiedTime;
        watchedFile.callback(watchedFile.fileName, getFileWatcherEventKind(oldTime, newTime));
        return true;
      }
      return false;
    }
    ts2.onWatchedFileStat = onWatchedFileStat;
    function getFileWatcherEventKind(oldTime, newTime) {
      return oldTime === 0 ? FileWatcherEventKind.Created : newTime === 0 ? FileWatcherEventKind.Deleted : FileWatcherEventKind.Changed;
    }
    ts2.getFileWatcherEventKind = getFileWatcherEventKind;
    ts2.ignoredPaths = ["/node_modules/.", "/.git", "/.#"];
    ts2.sysLog = ts2.noop;
    function setSysLog(logger) {
      ts2.sysLog = logger;
    }
    ts2.setSysLog = setSysLog;
    function createDirectoryWatcherSupportingRecursive(_a) {
      var watchDirectory = _a.watchDirectory, useCaseSensitiveFileNames = _a.useCaseSensitiveFileNames, getCurrentDirectory = _a.getCurrentDirectory, getAccessibleSortedChildDirectories = _a.getAccessibleSortedChildDirectories, directoryExists = _a.directoryExists, realpath = _a.realpath, setTimeout = _a.setTimeout, clearTimeout = _a.clearTimeout;
      var cache = new ts2.Map();
      var callbackCache = ts2.createMultiMap();
      var cacheToUpdateChildWatches = new ts2.Map();
      var timerToUpdateChildWatches;
      var filePathComparer = ts2.getStringComparer(!useCaseSensitiveFileNames);
      var toCanonicalFilePath = ts2.createGetCanonicalFileName(useCaseSensitiveFileNames);
      return function(dirName, callback, recursive, options) {
        return recursive ? createDirectoryWatcher(dirName, options, callback) : watchDirectory(dirName, callback, recursive, options);
      };
      function createDirectoryWatcher(dirName, options, callback) {
        var dirPath = toCanonicalFilePath(dirName);
        var directoryWatcher = cache.get(dirPath);
        if (directoryWatcher) {
          directoryWatcher.refCount++;
        } else {
          directoryWatcher = {
            watcher: watchDirectory(dirName, function(fileName) {
              if (isIgnoredPath(fileName, options))
                return;
              if (options === null || options === void 0 ? void 0 : options.synchronousWatchDirectory) {
                invokeCallbacks(dirPath, fileName);
                updateChildWatches(dirName, dirPath, options);
              } else {
                nonSyncUpdateChildWatches(dirName, dirPath, fileName, options);
              }
            }, false, options),
            refCount: 1,
            childWatches: ts2.emptyArray
          };
          cache.set(dirPath, directoryWatcher);
          updateChildWatches(dirName, dirPath, options);
        }
        var callbackToAdd = callback && { dirName, callback };
        if (callbackToAdd) {
          callbackCache.add(dirPath, callbackToAdd);
        }
        return {
          dirName,
          close: function() {
            var directoryWatcher2 = ts2.Debug.checkDefined(cache.get(dirPath));
            if (callbackToAdd)
              callbackCache.remove(dirPath, callbackToAdd);
            directoryWatcher2.refCount--;
            if (directoryWatcher2.refCount)
              return;
            cache.delete(dirPath);
            ts2.closeFileWatcherOf(directoryWatcher2);
            directoryWatcher2.childWatches.forEach(ts2.closeFileWatcher);
          }
        };
      }
      function invokeCallbacks(dirPath, fileNameOrInvokeMap, fileNames) {
        var fileName;
        var invokeMap;
        if (ts2.isString(fileNameOrInvokeMap)) {
          fileName = fileNameOrInvokeMap;
        } else {
          invokeMap = fileNameOrInvokeMap;
        }
        callbackCache.forEach(function(callbacks, rootDirName) {
          var _a2;
          if (invokeMap && invokeMap.get(rootDirName) === true)
            return;
          if (rootDirName === dirPath || ts2.startsWith(dirPath, rootDirName) && dirPath[rootDirName.length] === ts2.directorySeparator) {
            if (invokeMap) {
              if (fileNames) {
                var existing = invokeMap.get(rootDirName);
                if (existing) {
                  (_a2 = existing).push.apply(_a2, fileNames);
                } else {
                  invokeMap.set(rootDirName, fileNames.slice());
                }
              } else {
                invokeMap.set(rootDirName, true);
              }
            } else {
              callbacks.forEach(function(_a3) {
                var callback = _a3.callback;
                return callback(fileName);
              });
            }
          }
        });
      }
      function nonSyncUpdateChildWatches(dirName, dirPath, fileName, options) {
        var parentWatcher = cache.get(dirPath);
        if (parentWatcher && directoryExists(dirName)) {
          scheduleUpdateChildWatches(dirName, dirPath, fileName, options);
          return;
        }
        invokeCallbacks(dirPath, fileName);
        removeChildWatches(parentWatcher);
      }
      function scheduleUpdateChildWatches(dirName, dirPath, fileName, options) {
        var existing = cacheToUpdateChildWatches.get(dirPath);
        if (existing) {
          existing.fileNames.push(fileName);
        } else {
          cacheToUpdateChildWatches.set(dirPath, { dirName, options, fileNames: [fileName] });
        }
        if (timerToUpdateChildWatches) {
          clearTimeout(timerToUpdateChildWatches);
          timerToUpdateChildWatches = void 0;
        }
        timerToUpdateChildWatches = setTimeout(onTimerToUpdateChildWatches, 1e3);
      }
      function onTimerToUpdateChildWatches() {
        timerToUpdateChildWatches = void 0;
        ts2.sysLog("sysLog:: onTimerToUpdateChildWatches:: " + cacheToUpdateChildWatches.size);
        var start = ts2.timestamp();
        var invokeMap = new ts2.Map();
        while (!timerToUpdateChildWatches && cacheToUpdateChildWatches.size) {
          var result = cacheToUpdateChildWatches.entries().next();
          ts2.Debug.assert(!result.done);
          var _a2 = result.value, dirPath = _a2[0], _b = _a2[1], dirName = _b.dirName, options = _b.options, fileNames = _b.fileNames;
          cacheToUpdateChildWatches.delete(dirPath);
          var hasChanges = updateChildWatches(dirName, dirPath, options);
          invokeCallbacks(dirPath, invokeMap, hasChanges ? void 0 : fileNames);
        }
        ts2.sysLog("sysLog:: invokingWatchers:: Elapsed:: " + (ts2.timestamp() - start) + "ms:: " + cacheToUpdateChildWatches.size);
        callbackCache.forEach(function(callbacks, rootDirName) {
          var existing = invokeMap.get(rootDirName);
          if (existing) {
            callbacks.forEach(function(_a3) {
              var callback = _a3.callback, dirName2 = _a3.dirName;
              if (ts2.isArray(existing)) {
                existing.forEach(callback);
              } else {
                callback(dirName2);
              }
            });
          }
        });
        var elapsed = ts2.timestamp() - start;
        ts2.sysLog("sysLog:: Elapsed:: " + elapsed + "ms:: onTimerToUpdateChildWatches:: " + cacheToUpdateChildWatches.size + " " + timerToUpdateChildWatches);
      }
      function removeChildWatches(parentWatcher) {
        if (!parentWatcher)
          return;
        var existingChildWatches = parentWatcher.childWatches;
        parentWatcher.childWatches = ts2.emptyArray;
        for (var _i = 0, existingChildWatches_1 = existingChildWatches; _i < existingChildWatches_1.length; _i++) {
          var childWatcher = existingChildWatches_1[_i];
          childWatcher.close();
          removeChildWatches(cache.get(toCanonicalFilePath(childWatcher.dirName)));
        }
      }
      function updateChildWatches(parentDir, parentDirPath, options) {
        var parentWatcher = cache.get(parentDirPath);
        if (!parentWatcher)
          return false;
        var newChildWatches;
        var hasChanges = ts2.enumerateInsertsAndDeletes(directoryExists(parentDir) ? ts2.mapDefined(getAccessibleSortedChildDirectories(parentDir), function(child) {
          var childFullName = ts2.getNormalizedAbsolutePath(child, parentDir);
          return !isIgnoredPath(childFullName, options) && filePathComparer(childFullName, ts2.normalizePath(realpath(childFullName))) === 0 ? childFullName : void 0;
        }) : ts2.emptyArray, parentWatcher.childWatches, function(child, childWatcher) {
          return filePathComparer(child, childWatcher.dirName);
        }, createAndAddChildDirectoryWatcher, ts2.closeFileWatcher, addChildDirectoryWatcher);
        parentWatcher.childWatches = newChildWatches || ts2.emptyArray;
        return hasChanges;
        function createAndAddChildDirectoryWatcher(childName) {
          var result = createDirectoryWatcher(childName, options);
          addChildDirectoryWatcher(result);
        }
        function addChildDirectoryWatcher(childWatcher) {
          (newChildWatches || (newChildWatches = [])).push(childWatcher);
        }
      }
      function isIgnoredPath(path, options) {
        return ts2.some(ts2.ignoredPaths, function(searchPath) {
          return isInPath(path, searchPath);
        }) || isIgnoredByWatchOptions(path, options, useCaseSensitiveFileNames, getCurrentDirectory);
      }
      function isInPath(path, searchPath) {
        if (ts2.stringContains(path, searchPath))
          return true;
        if (useCaseSensitiveFileNames)
          return false;
        return ts2.stringContains(toCanonicalFilePath(path), searchPath);
      }
    }
    ts2.createDirectoryWatcherSupportingRecursive = createDirectoryWatcherSupportingRecursive;
    var FileSystemEntryKind;
    (function(FileSystemEntryKind2) {
      FileSystemEntryKind2[FileSystemEntryKind2["File"] = 0] = "File";
      FileSystemEntryKind2[FileSystemEntryKind2["Directory"] = 1] = "Directory";
    })(FileSystemEntryKind = ts2.FileSystemEntryKind || (ts2.FileSystemEntryKind = {}));
    function createFileWatcherCallback(callback) {
      return function(_fileName, eventKind) {
        return callback(eventKind === FileWatcherEventKind.Changed ? "change" : "rename", "");
      };
    }
    ts2.createFileWatcherCallback = createFileWatcherCallback;
    function createFsWatchCallbackForFileWatcherCallback(fileName, callback, fileExists) {
      return function(eventName) {
        if (eventName === "rename") {
          callback(fileName, fileExists(fileName) ? FileWatcherEventKind.Created : FileWatcherEventKind.Deleted);
        } else {
          callback(fileName, FileWatcherEventKind.Changed);
        }
      };
    }
    function isIgnoredByWatchOptions(pathToCheck, options, useCaseSensitiveFileNames, getCurrentDirectory) {
      return ((options === null || options === void 0 ? void 0 : options.excludeDirectories) || (options === null || options === void 0 ? void 0 : options.excludeFiles)) && (ts2.matchesExclude(pathToCheck, options === null || options === void 0 ? void 0 : options.excludeFiles, useCaseSensitiveFileNames, getCurrentDirectory()) || ts2.matchesExclude(pathToCheck, options === null || options === void 0 ? void 0 : options.excludeDirectories, useCaseSensitiveFileNames, getCurrentDirectory()));
    }
    function createFsWatchCallbackForDirectoryWatcherCallback(directoryName, callback, options, useCaseSensitiveFileNames, getCurrentDirectory) {
      return function(eventName, relativeFileName) {
        if (eventName === "rename") {
          var fileName = !relativeFileName ? directoryName : ts2.normalizePath(ts2.combinePaths(directoryName, relativeFileName));
          if (!relativeFileName || !isIgnoredByWatchOptions(fileName, options, useCaseSensitiveFileNames, getCurrentDirectory)) {
            callback(fileName);
          }
        }
      };
    }
    function createSystemWatchFunctions(_a) {
      var pollingWatchFile = _a.pollingWatchFile, getModifiedTime2 = _a.getModifiedTime, setTimeout = _a.setTimeout, clearTimeout = _a.clearTimeout, fsWatch = _a.fsWatch, fileExists = _a.fileExists, useCaseSensitiveFileNames = _a.useCaseSensitiveFileNames, getCurrentDirectory = _a.getCurrentDirectory, fsSupportsRecursiveFsWatch = _a.fsSupportsRecursiveFsWatch, directoryExists = _a.directoryExists, getAccessibleSortedChildDirectories = _a.getAccessibleSortedChildDirectories, realpath = _a.realpath, tscWatchFile = _a.tscWatchFile, useNonPollingWatchers = _a.useNonPollingWatchers, tscWatchDirectory = _a.tscWatchDirectory, defaultWatchFileKind = _a.defaultWatchFileKind;
      var dynamicPollingWatchFile;
      var fixedChunkSizePollingWatchFile;
      var nonPollingWatchFile;
      var hostRecursiveDirectoryWatcher;
      return {
        watchFile,
        watchDirectory
      };
      function watchFile(fileName, callback, pollingInterval, options) {
        options = updateOptionsForWatchFile(options, useNonPollingWatchers);
        var watchFileKind = ts2.Debug.checkDefined(options.watchFile);
        switch (watchFileKind) {
          case ts2.WatchFileKind.FixedPollingInterval:
            return pollingWatchFile(fileName, callback, PollingInterval.Low, void 0);
          case ts2.WatchFileKind.PriorityPollingInterval:
            return pollingWatchFile(fileName, callback, pollingInterval, void 0);
          case ts2.WatchFileKind.DynamicPriorityPolling:
            return ensureDynamicPollingWatchFile()(fileName, callback, pollingInterval, void 0);
          case ts2.WatchFileKind.FixedChunkSizePolling:
            return ensureFixedChunkSizePollingWatchFile()(fileName, callback, void 0, void 0);
          case ts2.WatchFileKind.UseFsEvents:
            return fsWatch(fileName, 0, createFsWatchCallbackForFileWatcherCallback(fileName, callback, fileExists), false, pollingInterval, ts2.getFallbackOptions(options));
          case ts2.WatchFileKind.UseFsEventsOnParentDirectory:
            if (!nonPollingWatchFile) {
              nonPollingWatchFile = createUseFsEventsOnParentDirectoryWatchFile(fsWatch, useCaseSensitiveFileNames);
            }
            return nonPollingWatchFile(fileName, callback, pollingInterval, ts2.getFallbackOptions(options));
          default:
            ts2.Debug.assertNever(watchFileKind);
        }
      }
      function ensureDynamicPollingWatchFile() {
        return dynamicPollingWatchFile || (dynamicPollingWatchFile = createDynamicPriorityPollingWatchFile({ getModifiedTime: getModifiedTime2, setTimeout }));
      }
      function ensureFixedChunkSizePollingWatchFile() {
        return fixedChunkSizePollingWatchFile || (fixedChunkSizePollingWatchFile = createFixedChunkSizePollingWatchFile({ getModifiedTime: getModifiedTime2, setTimeout }));
      }
      function updateOptionsForWatchFile(options, useNonPollingWatchers2) {
        if (options && options.watchFile !== void 0)
          return options;
        switch (tscWatchFile) {
          case "PriorityPollingInterval":
            return { watchFile: ts2.WatchFileKind.PriorityPollingInterval };
          case "DynamicPriorityPolling":
            return { watchFile: ts2.WatchFileKind.DynamicPriorityPolling };
          case "UseFsEvents":
            return generateWatchFileOptions(ts2.WatchFileKind.UseFsEvents, ts2.PollingWatchKind.PriorityInterval, options);
          case "UseFsEventsWithFallbackDynamicPolling":
            return generateWatchFileOptions(ts2.WatchFileKind.UseFsEvents, ts2.PollingWatchKind.DynamicPriority, options);
          case "UseFsEventsOnParentDirectory":
            useNonPollingWatchers2 = true;
          default:
            return useNonPollingWatchers2 ? generateWatchFileOptions(ts2.WatchFileKind.UseFsEventsOnParentDirectory, ts2.PollingWatchKind.PriorityInterval, options) : { watchFile: (defaultWatchFileKind === null || defaultWatchFileKind === void 0 ? void 0 : defaultWatchFileKind()) || ts2.WatchFileKind.FixedPollingInterval };
        }
      }
      function generateWatchFileOptions(watchFile2, fallbackPolling, options) {
        var defaultFallbackPolling = options === null || options === void 0 ? void 0 : options.fallbackPolling;
        return {
          watchFile: watchFile2,
          fallbackPolling: defaultFallbackPolling === void 0 ? fallbackPolling : defaultFallbackPolling
        };
      }
      function watchDirectory(directoryName, callback, recursive, options) {
        if (fsSupportsRecursiveFsWatch) {
          return fsWatch(directoryName, 1, createFsWatchCallbackForDirectoryWatcherCallback(directoryName, callback, options, useCaseSensitiveFileNames, getCurrentDirectory), recursive, PollingInterval.Medium, ts2.getFallbackOptions(options));
        }
        if (!hostRecursiveDirectoryWatcher) {
          hostRecursiveDirectoryWatcher = createDirectoryWatcherSupportingRecursive({
            useCaseSensitiveFileNames,
            getCurrentDirectory,
            directoryExists,
            getAccessibleSortedChildDirectories,
            watchDirectory: nonRecursiveWatchDirectory,
            realpath,
            setTimeout,
            clearTimeout
          });
        }
        return hostRecursiveDirectoryWatcher(directoryName, callback, recursive, options);
      }
      function nonRecursiveWatchDirectory(directoryName, callback, recursive, options) {
        ts2.Debug.assert(!recursive);
        var watchDirectoryOptions = updateOptionsForWatchDirectory(options);
        var watchDirectoryKind = ts2.Debug.checkDefined(watchDirectoryOptions.watchDirectory);
        switch (watchDirectoryKind) {
          case ts2.WatchDirectoryKind.FixedPollingInterval:
            return pollingWatchFile(directoryName, function() {
              return callback(directoryName);
            }, PollingInterval.Medium, void 0);
          case ts2.WatchDirectoryKind.DynamicPriorityPolling:
            return ensureDynamicPollingWatchFile()(directoryName, function() {
              return callback(directoryName);
            }, PollingInterval.Medium, void 0);
          case ts2.WatchDirectoryKind.FixedChunkSizePolling:
            return ensureFixedChunkSizePollingWatchFile()(directoryName, function() {
              return callback(directoryName);
            }, void 0, void 0);
          case ts2.WatchDirectoryKind.UseFsEvents:
            return fsWatch(directoryName, 1, createFsWatchCallbackForDirectoryWatcherCallback(directoryName, callback, options, useCaseSensitiveFileNames, getCurrentDirectory), recursive, PollingInterval.Medium, ts2.getFallbackOptions(watchDirectoryOptions));
          default:
            ts2.Debug.assertNever(watchDirectoryKind);
        }
      }
      function updateOptionsForWatchDirectory(options) {
        if (options && options.watchDirectory !== void 0)
          return options;
        switch (tscWatchDirectory) {
          case "RecursiveDirectoryUsingFsWatchFile":
            return { watchDirectory: ts2.WatchDirectoryKind.FixedPollingInterval };
          case "RecursiveDirectoryUsingDynamicPriorityPolling":
            return { watchDirectory: ts2.WatchDirectoryKind.DynamicPriorityPolling };
          default:
            var defaultFallbackPolling = options === null || options === void 0 ? void 0 : options.fallbackPolling;
            return {
              watchDirectory: ts2.WatchDirectoryKind.UseFsEvents,
              fallbackPolling: defaultFallbackPolling !== void 0 ? defaultFallbackPolling : void 0
            };
        }
      }
    }
    ts2.createSystemWatchFunctions = createSystemWatchFunctions;
    function patchWriteFileEnsuringDirectory(sys) {
      var originalWriteFile = sys.writeFile;
      sys.writeFile = function(path, data, writeBom) {
        return ts2.writeFileEnsuringDirectories(path, data, !!writeBom, function(path2, data2, writeByteOrderMark) {
          return originalWriteFile.call(sys, path2, data2, writeByteOrderMark);
        }, function(path2) {
          return sys.createDirectory(path2);
        }, function(path2) {
          return sys.directoryExists(path2);
        });
      };
    }
    ts2.patchWriteFileEnsuringDirectory = patchWriteFileEnsuringDirectory;
    function getNodeMajorVersion() {
      if (typeof process === "undefined") {
        return void 0;
      }
      var version = process.version;
      if (!version) {
        return void 0;
      }
      var dot = version.indexOf(".");
      if (dot === -1) {
        return void 0;
      }
      return parseInt(version.substring(1, dot));
    }
    ts2.getNodeMajorVersion = getNodeMajorVersion;
    ts2.sys = void 0;
    if (ts2.sys && ts2.sys.getEnvironmentVariable) {
      setCustomPollingValues(ts2.sys);
      ts2.Debug.setAssertionLevel(/^development$/i.test(ts2.sys.getEnvironmentVariable("NODE_ENV")) ? 1 : 0);
    }
    if (ts2.sys && ts2.sys.debugMode) {
      ts2.Debug.isDebugging = true;
    }
  })(ts || (ts = {}));
  var ts;
  (function(ts2) {
    function diag(code, category, key, message, reportsUnnecessary, elidedInCompatabilityPyramid, reportsDeprecated) {
      return { code, category, key, message, reportsUnnecessary, elidedInCompatabilityPyramid, reportsDeprecated };
    }
    ts2.Diagnostics = {
      Unterminated_string_literal: diag(1002, ts2.DiagnosticCategory.Error, "Unterminated_string_literal_1002", "Unterminated string literal."),
      Identifier_expected: diag(1003, ts2.DiagnosticCategory.Error, "Identifier_expected_1003", "Identifier expected."),
      _0_expected: diag(1005, ts2.DiagnosticCategory.Error, "_0_expected_1005", "'{0}' expected."),
      A_file_cannot_have_a_reference_to_itself: diag(1006, ts2.DiagnosticCategory.Error, "A_file_cannot_have_a_reference_to_itself_1006", "A file cannot have a reference to itself."),
      The_parser_expected_to_find_a_to_match_the_token_here: diag(1007, ts2.DiagnosticCategory.Error, "The_parser_expected_to_find_a_to_match_the_token_here_1007", "The parser expected to find a '}' to match the '{' token here."),
      Trailing_comma_not_allowed: diag(1009, ts2.DiagnosticCategory.Error, "Trailing_comma_not_allowed_1009", "Trailing comma not allowed."),
      Asterisk_Slash_expected: diag(1010, ts2.DiagnosticCategory.Error, "Asterisk_Slash_expected_1010", "'*/' expected."),
      An_element_access_expression_should_take_an_argument: diag(1011, ts2.DiagnosticCategory.Error, "An_element_access_expression_should_take_an_argument_1011", "An element access expression should take an argument."),
      Unexpected_token: diag(1012, ts2.DiagnosticCategory.Error, "Unexpected_token_1012", "Unexpected token."),
      A_rest_parameter_or_binding_pattern_may_not_have_a_trailing_comma: diag(1013, ts2.DiagnosticCategory.Error, "A_rest_parameter_or_binding_pattern_may_not_have_a_trailing_comma_1013", "A rest parameter or binding pattern may not have a trailing comma."),
      A_rest_parameter_must_be_last_in_a_parameter_list: diag(1014, ts2.DiagnosticCategory.Error, "A_rest_parameter_must_be_last_in_a_parameter_list_1014", "A rest parameter must be last in a parameter list."),
      Parameter_cannot_have_question_mark_and_initializer: diag(1015, ts2.DiagnosticCategory.Error, "Parameter_cannot_have_question_mark_and_initializer_1015", "Parameter cannot have question mark and initializer."),
      A_required_parameter_cannot_follow_an_optional_parameter: diag(1016, ts2.DiagnosticCategory.Error, "A_required_parameter_cannot_follow_an_optional_parameter_1016", "A required parameter cannot follow an optional parameter."),
      An_index_signature_cannot_have_a_rest_parameter: diag(1017, ts2.DiagnosticCategory.Error, "An_index_signature_cannot_have_a_rest_parameter_1017", "An index signature cannot have a rest parameter."),
      An_index_signature_parameter_cannot_have_an_accessibility_modifier: diag(1018, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_cannot_have_an_accessibility_modifier_1018", "An index signature parameter cannot have an accessibility modifier."),
      An_index_signature_parameter_cannot_have_a_question_mark: diag(1019, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_cannot_have_a_question_mark_1019", "An index signature parameter cannot have a question mark."),
      An_index_signature_parameter_cannot_have_an_initializer: diag(1020, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_cannot_have_an_initializer_1020", "An index signature parameter cannot have an initializer."),
      An_index_signature_must_have_a_type_annotation: diag(1021, ts2.DiagnosticCategory.Error, "An_index_signature_must_have_a_type_annotation_1021", "An index signature must have a type annotation."),
      An_index_signature_parameter_must_have_a_type_annotation: diag(1022, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_must_have_a_type_annotation_1022", "An index signature parameter must have a type annotation."),
      readonly_modifier_can_only_appear_on_a_property_declaration_or_index_signature: diag(1024, ts2.DiagnosticCategory.Error, "readonly_modifier_can_only_appear_on_a_property_declaration_or_index_signature_1024", "'readonly' modifier can only appear on a property declaration or index signature."),
      An_index_signature_cannot_have_a_trailing_comma: diag(1025, ts2.DiagnosticCategory.Error, "An_index_signature_cannot_have_a_trailing_comma_1025", "An index signature cannot have a trailing comma."),
      Accessibility_modifier_already_seen: diag(1028, ts2.DiagnosticCategory.Error, "Accessibility_modifier_already_seen_1028", "Accessibility modifier already seen."),
      _0_modifier_must_precede_1_modifier: diag(1029, ts2.DiagnosticCategory.Error, "_0_modifier_must_precede_1_modifier_1029", "'{0}' modifier must precede '{1}' modifier."),
      _0_modifier_already_seen: diag(1030, ts2.DiagnosticCategory.Error, "_0_modifier_already_seen_1030", "'{0}' modifier already seen."),
      _0_modifier_cannot_appear_on_class_elements_of_this_kind: diag(1031, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_class_elements_of_this_kind_1031", "'{0}' modifier cannot appear on class elements of this kind."),
      super_must_be_followed_by_an_argument_list_or_member_access: diag(1034, ts2.DiagnosticCategory.Error, "super_must_be_followed_by_an_argument_list_or_member_access_1034", "'super' must be followed by an argument list or member access."),
      Only_ambient_modules_can_use_quoted_names: diag(1035, ts2.DiagnosticCategory.Error, "Only_ambient_modules_can_use_quoted_names_1035", "Only ambient modules can use quoted names."),
      Statements_are_not_allowed_in_ambient_contexts: diag(1036, ts2.DiagnosticCategory.Error, "Statements_are_not_allowed_in_ambient_contexts_1036", "Statements are not allowed in ambient contexts."),
      A_declare_modifier_cannot_be_used_in_an_already_ambient_context: diag(1038, ts2.DiagnosticCategory.Error, "A_declare_modifier_cannot_be_used_in_an_already_ambient_context_1038", "A 'declare' modifier cannot be used in an already ambient context."),
      Initializers_are_not_allowed_in_ambient_contexts: diag(1039, ts2.DiagnosticCategory.Error, "Initializers_are_not_allowed_in_ambient_contexts_1039", "Initializers are not allowed in ambient contexts."),
      _0_modifier_cannot_be_used_in_an_ambient_context: diag(1040, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_be_used_in_an_ambient_context_1040", "'{0}' modifier cannot be used in an ambient context."),
      _0_modifier_cannot_be_used_with_a_class_declaration: diag(1041, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_be_used_with_a_class_declaration_1041", "'{0}' modifier cannot be used with a class declaration."),
      _0_modifier_cannot_be_used_here: diag(1042, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_be_used_here_1042", "'{0}' modifier cannot be used here."),
      _0_modifier_cannot_appear_on_a_data_property: diag(1043, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_data_property_1043", "'{0}' modifier cannot appear on a data property."),
      _0_modifier_cannot_appear_on_a_module_or_namespace_element: diag(1044, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_module_or_namespace_element_1044", "'{0}' modifier cannot appear on a module or namespace element."),
      A_0_modifier_cannot_be_used_with_an_interface_declaration: diag(1045, ts2.DiagnosticCategory.Error, "A_0_modifier_cannot_be_used_with_an_interface_declaration_1045", "A '{0}' modifier cannot be used with an interface declaration."),
      Top_level_declarations_in_d_ts_files_must_start_with_either_a_declare_or_export_modifier: diag(1046, ts2.DiagnosticCategory.Error, "Top_level_declarations_in_d_ts_files_must_start_with_either_a_declare_or_export_modifier_1046", "Top-level declarations in .d.ts files must start with either a 'declare' or 'export' modifier."),
      A_rest_parameter_cannot_be_optional: diag(1047, ts2.DiagnosticCategory.Error, "A_rest_parameter_cannot_be_optional_1047", "A rest parameter cannot be optional."),
      A_rest_parameter_cannot_have_an_initializer: diag(1048, ts2.DiagnosticCategory.Error, "A_rest_parameter_cannot_have_an_initializer_1048", "A rest parameter cannot have an initializer."),
      A_set_accessor_must_have_exactly_one_parameter: diag(1049, ts2.DiagnosticCategory.Error, "A_set_accessor_must_have_exactly_one_parameter_1049", "A 'set' accessor must have exactly one parameter."),
      A_set_accessor_cannot_have_an_optional_parameter: diag(1051, ts2.DiagnosticCategory.Error, "A_set_accessor_cannot_have_an_optional_parameter_1051", "A 'set' accessor cannot have an optional parameter."),
      A_set_accessor_parameter_cannot_have_an_initializer: diag(1052, ts2.DiagnosticCategory.Error, "A_set_accessor_parameter_cannot_have_an_initializer_1052", "A 'set' accessor parameter cannot have an initializer."),
      A_set_accessor_cannot_have_rest_parameter: diag(1053, ts2.DiagnosticCategory.Error, "A_set_accessor_cannot_have_rest_parameter_1053", "A 'set' accessor cannot have rest parameter."),
      A_get_accessor_cannot_have_parameters: diag(1054, ts2.DiagnosticCategory.Error, "A_get_accessor_cannot_have_parameters_1054", "A 'get' accessor cannot have parameters."),
      Type_0_is_not_a_valid_async_function_return_type_in_ES5_SlashES3_because_it_does_not_refer_to_a_Promise_compatible_constructor_value: diag(1055, ts2.DiagnosticCategory.Error, "Type_0_is_not_a_valid_async_function_return_type_in_ES5_SlashES3_because_it_does_not_refer_to_a_Prom_1055", "Type '{0}' is not a valid async function return type in ES5/ES3 because it does not refer to a Promise-compatible constructor value."),
      Accessors_are_only_available_when_targeting_ECMAScript_5_and_higher: diag(1056, ts2.DiagnosticCategory.Error, "Accessors_are_only_available_when_targeting_ECMAScript_5_and_higher_1056", "Accessors are only available when targeting ECMAScript 5 and higher."),
      An_async_function_or_method_must_have_a_valid_awaitable_return_type: diag(1057, ts2.DiagnosticCategory.Error, "An_async_function_or_method_must_have_a_valid_awaitable_return_type_1057", "An async function or method must have a valid awaitable return type."),
      The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1058, ts2.DiagnosticCategory.Error, "The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_t_1058", "The return type of an async function must either be a valid promise or must not contain a callable 'then' member."),
      A_promise_must_have_a_then_method: diag(1059, ts2.DiagnosticCategory.Error, "A_promise_must_have_a_then_method_1059", "A promise must have a 'then' method."),
      The_first_parameter_of_the_then_method_of_a_promise_must_be_a_callback: diag(1060, ts2.DiagnosticCategory.Error, "The_first_parameter_of_the_then_method_of_a_promise_must_be_a_callback_1060", "The first parameter of the 'then' method of a promise must be a callback."),
      Enum_member_must_have_initializer: diag(1061, ts2.DiagnosticCategory.Error, "Enum_member_must_have_initializer_1061", "Enum member must have initializer."),
      Type_is_referenced_directly_or_indirectly_in_the_fulfillment_callback_of_its_own_then_method: diag(1062, ts2.DiagnosticCategory.Error, "Type_is_referenced_directly_or_indirectly_in_the_fulfillment_callback_of_its_own_then_method_1062", "Type is referenced directly or indirectly in the fulfillment callback of its own 'then' method."),
      An_export_assignment_cannot_be_used_in_a_namespace: diag(1063, ts2.DiagnosticCategory.Error, "An_export_assignment_cannot_be_used_in_a_namespace_1063", "An export assignment cannot be used in a namespace."),
      The_return_type_of_an_async_function_or_method_must_be_the_global_Promise_T_type_Did_you_mean_to_write_Promise_0: diag(1064, ts2.DiagnosticCategory.Error, "The_return_type_of_an_async_function_or_method_must_be_the_global_Promise_T_type_Did_you_mean_to_wri_1064", "The return type of an async function or method must be the global Promise<T> type. Did you mean to write 'Promise<{0}>'?"),
      In_ambient_enum_declarations_member_initializer_must_be_constant_expression: diag(1066, ts2.DiagnosticCategory.Error, "In_ambient_enum_declarations_member_initializer_must_be_constant_expression_1066", "In ambient enum declarations member initializer must be constant expression."),
      Unexpected_token_A_constructor_method_accessor_or_property_was_expected: diag(1068, ts2.DiagnosticCategory.Error, "Unexpected_token_A_constructor_method_accessor_or_property_was_expected_1068", "Unexpected token. A constructor, method, accessor, or property was expected."),
      Unexpected_token_A_type_parameter_name_was_expected_without_curly_braces: diag(1069, ts2.DiagnosticCategory.Error, "Unexpected_token_A_type_parameter_name_was_expected_without_curly_braces_1069", "Unexpected token. A type parameter name was expected without curly braces."),
      _0_modifier_cannot_appear_on_a_type_member: diag(1070, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_type_member_1070", "'{0}' modifier cannot appear on a type member."),
      _0_modifier_cannot_appear_on_an_index_signature: diag(1071, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_an_index_signature_1071", "'{0}' modifier cannot appear on an index signature."),
      A_0_modifier_cannot_be_used_with_an_import_declaration: diag(1079, ts2.DiagnosticCategory.Error, "A_0_modifier_cannot_be_used_with_an_import_declaration_1079", "A '{0}' modifier cannot be used with an import declaration."),
      Invalid_reference_directive_syntax: diag(1084, ts2.DiagnosticCategory.Error, "Invalid_reference_directive_syntax_1084", "Invalid 'reference' directive syntax."),
      Octal_literals_are_not_available_when_targeting_ECMAScript_5_and_higher_Use_the_syntax_0: diag(1085, ts2.DiagnosticCategory.Error, "Octal_literals_are_not_available_when_targeting_ECMAScript_5_and_higher_Use_the_syntax_0_1085", "Octal literals are not available when targeting ECMAScript 5 and higher. Use the syntax '{0}'."),
      _0_modifier_cannot_appear_on_a_constructor_declaration: diag(1089, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_constructor_declaration_1089", "'{0}' modifier cannot appear on a constructor declaration."),
      _0_modifier_cannot_appear_on_a_parameter: diag(1090, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_parameter_1090", "'{0}' modifier cannot appear on a parameter."),
      Only_a_single_variable_declaration_is_allowed_in_a_for_in_statement: diag(1091, ts2.DiagnosticCategory.Error, "Only_a_single_variable_declaration_is_allowed_in_a_for_in_statement_1091", "Only a single variable declaration is allowed in a 'for...in' statement."),
      Type_parameters_cannot_appear_on_a_constructor_declaration: diag(1092, ts2.DiagnosticCategory.Error, "Type_parameters_cannot_appear_on_a_constructor_declaration_1092", "Type parameters cannot appear on a constructor declaration."),
      Type_annotation_cannot_appear_on_a_constructor_declaration: diag(1093, ts2.DiagnosticCategory.Error, "Type_annotation_cannot_appear_on_a_constructor_declaration_1093", "Type annotation cannot appear on a constructor declaration."),
      An_accessor_cannot_have_type_parameters: diag(1094, ts2.DiagnosticCategory.Error, "An_accessor_cannot_have_type_parameters_1094", "An accessor cannot have type parameters."),
      A_set_accessor_cannot_have_a_return_type_annotation: diag(1095, ts2.DiagnosticCategory.Error, "A_set_accessor_cannot_have_a_return_type_annotation_1095", "A 'set' accessor cannot have a return type annotation."),
      An_index_signature_must_have_exactly_one_parameter: diag(1096, ts2.DiagnosticCategory.Error, "An_index_signature_must_have_exactly_one_parameter_1096", "An index signature must have exactly one parameter."),
      _0_list_cannot_be_empty: diag(1097, ts2.DiagnosticCategory.Error, "_0_list_cannot_be_empty_1097", "'{0}' list cannot be empty."),
      Type_parameter_list_cannot_be_empty: diag(1098, ts2.DiagnosticCategory.Error, "Type_parameter_list_cannot_be_empty_1098", "Type parameter list cannot be empty."),
      Type_argument_list_cannot_be_empty: diag(1099, ts2.DiagnosticCategory.Error, "Type_argument_list_cannot_be_empty_1099", "Type argument list cannot be empty."),
      Invalid_use_of_0_in_strict_mode: diag(1100, ts2.DiagnosticCategory.Error, "Invalid_use_of_0_in_strict_mode_1100", "Invalid use of '{0}' in strict mode."),
      with_statements_are_not_allowed_in_strict_mode: diag(1101, ts2.DiagnosticCategory.Error, "with_statements_are_not_allowed_in_strict_mode_1101", "'with' statements are not allowed in strict mode."),
      delete_cannot_be_called_on_an_identifier_in_strict_mode: diag(1102, ts2.DiagnosticCategory.Error, "delete_cannot_be_called_on_an_identifier_in_strict_mode_1102", "'delete' cannot be called on an identifier in strict mode."),
      for_await_loops_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules: diag(1103, ts2.DiagnosticCategory.Error, "for_await_loops_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules_1103", "'for await' loops are only allowed within async functions and at the top levels of modules."),
      A_continue_statement_can_only_be_used_within_an_enclosing_iteration_statement: diag(1104, ts2.DiagnosticCategory.Error, "A_continue_statement_can_only_be_used_within_an_enclosing_iteration_statement_1104", "A 'continue' statement can only be used within an enclosing iteration statement."),
      A_break_statement_can_only_be_used_within_an_enclosing_iteration_or_switch_statement: diag(1105, ts2.DiagnosticCategory.Error, "A_break_statement_can_only_be_used_within_an_enclosing_iteration_or_switch_statement_1105", "A 'break' statement can only be used within an enclosing iteration or switch statement."),
      The_left_hand_side_of_a_for_of_statement_may_not_be_async: diag(1106, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_of_statement_may_not_be_async_1106", "The left-hand side of a 'for...of' statement may not be 'async'."),
      Jump_target_cannot_cross_function_boundary: diag(1107, ts2.DiagnosticCategory.Error, "Jump_target_cannot_cross_function_boundary_1107", "Jump target cannot cross function boundary."),
      A_return_statement_can_only_be_used_within_a_function_body: diag(1108, ts2.DiagnosticCategory.Error, "A_return_statement_can_only_be_used_within_a_function_body_1108", "A 'return' statement can only be used within a function body."),
      Expression_expected: diag(1109, ts2.DiagnosticCategory.Error, "Expression_expected_1109", "Expression expected."),
      Type_expected: diag(1110, ts2.DiagnosticCategory.Error, "Type_expected_1110", "Type expected."),
      A_default_clause_cannot_appear_more_than_once_in_a_switch_statement: diag(1113, ts2.DiagnosticCategory.Error, "A_default_clause_cannot_appear_more_than_once_in_a_switch_statement_1113", "A 'default' clause cannot appear more than once in a 'switch' statement."),
      Duplicate_label_0: diag(1114, ts2.DiagnosticCategory.Error, "Duplicate_label_0_1114", "Duplicate label '{0}'."),
      A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement: diag(1115, ts2.DiagnosticCategory.Error, "A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement_1115", "A 'continue' statement can only jump to a label of an enclosing iteration statement."),
      A_break_statement_can_only_jump_to_a_label_of_an_enclosing_statement: diag(1116, ts2.DiagnosticCategory.Error, "A_break_statement_can_only_jump_to_a_label_of_an_enclosing_statement_1116", "A 'break' statement can only jump to a label of an enclosing statement."),
      An_object_literal_cannot_have_multiple_properties_with_the_same_name_in_strict_mode: diag(1117, ts2.DiagnosticCategory.Error, "An_object_literal_cannot_have_multiple_properties_with_the_same_name_in_strict_mode_1117", "An object literal cannot have multiple properties with the same name in strict mode."),
      An_object_literal_cannot_have_multiple_get_Slashset_accessors_with_the_same_name: diag(1118, ts2.DiagnosticCategory.Error, "An_object_literal_cannot_have_multiple_get_Slashset_accessors_with_the_same_name_1118", "An object literal cannot have multiple get/set accessors with the same name."),
      An_object_literal_cannot_have_property_and_accessor_with_the_same_name: diag(1119, ts2.DiagnosticCategory.Error, "An_object_literal_cannot_have_property_and_accessor_with_the_same_name_1119", "An object literal cannot have property and accessor with the same name."),
      An_export_assignment_cannot_have_modifiers: diag(1120, ts2.DiagnosticCategory.Error, "An_export_assignment_cannot_have_modifiers_1120", "An export assignment cannot have modifiers."),
      Octal_literals_are_not_allowed_in_strict_mode: diag(1121, ts2.DiagnosticCategory.Error, "Octal_literals_are_not_allowed_in_strict_mode_1121", "Octal literals are not allowed in strict mode."),
      Variable_declaration_list_cannot_be_empty: diag(1123, ts2.DiagnosticCategory.Error, "Variable_declaration_list_cannot_be_empty_1123", "Variable declaration list cannot be empty."),
      Digit_expected: diag(1124, ts2.DiagnosticCategory.Error, "Digit_expected_1124", "Digit expected."),
      Hexadecimal_digit_expected: diag(1125, ts2.DiagnosticCategory.Error, "Hexadecimal_digit_expected_1125", "Hexadecimal digit expected."),
      Unexpected_end_of_text: diag(1126, ts2.DiagnosticCategory.Error, "Unexpected_end_of_text_1126", "Unexpected end of text."),
      Invalid_character: diag(1127, ts2.DiagnosticCategory.Error, "Invalid_character_1127", "Invalid character."),
      Declaration_or_statement_expected: diag(1128, ts2.DiagnosticCategory.Error, "Declaration_or_statement_expected_1128", "Declaration or statement expected."),
      Statement_expected: diag(1129, ts2.DiagnosticCategory.Error, "Statement_expected_1129", "Statement expected."),
      case_or_default_expected: diag(1130, ts2.DiagnosticCategory.Error, "case_or_default_expected_1130", "'case' or 'default' expected."),
      Property_or_signature_expected: diag(1131, ts2.DiagnosticCategory.Error, "Property_or_signature_expected_1131", "Property or signature expected."),
      Enum_member_expected: diag(1132, ts2.DiagnosticCategory.Error, "Enum_member_expected_1132", "Enum member expected."),
      Variable_declaration_expected: diag(1134, ts2.DiagnosticCategory.Error, "Variable_declaration_expected_1134", "Variable declaration expected."),
      Argument_expression_expected: diag(1135, ts2.DiagnosticCategory.Error, "Argument_expression_expected_1135", "Argument expression expected."),
      Property_assignment_expected: diag(1136, ts2.DiagnosticCategory.Error, "Property_assignment_expected_1136", "Property assignment expected."),
      Expression_or_comma_expected: diag(1137, ts2.DiagnosticCategory.Error, "Expression_or_comma_expected_1137", "Expression or comma expected."),
      Parameter_declaration_expected: diag(1138, ts2.DiagnosticCategory.Error, "Parameter_declaration_expected_1138", "Parameter declaration expected."),
      Type_parameter_declaration_expected: diag(1139, ts2.DiagnosticCategory.Error, "Type_parameter_declaration_expected_1139", "Type parameter declaration expected."),
      Type_argument_expected: diag(1140, ts2.DiagnosticCategory.Error, "Type_argument_expected_1140", "Type argument expected."),
      String_literal_expected: diag(1141, ts2.DiagnosticCategory.Error, "String_literal_expected_1141", "String literal expected."),
      Line_break_not_permitted_here: diag(1142, ts2.DiagnosticCategory.Error, "Line_break_not_permitted_here_1142", "Line break not permitted here."),
      or_expected: diag(1144, ts2.DiagnosticCategory.Error, "or_expected_1144", "'{' or ';' expected."),
      Declaration_expected: diag(1146, ts2.DiagnosticCategory.Error, "Declaration_expected_1146", "Declaration expected."),
      Import_declarations_in_a_namespace_cannot_reference_a_module: diag(1147, ts2.DiagnosticCategory.Error, "Import_declarations_in_a_namespace_cannot_reference_a_module_1147", "Import declarations in a namespace cannot reference a module."),
      Cannot_use_imports_exports_or_module_augmentations_when_module_is_none: diag(1148, ts2.DiagnosticCategory.Error, "Cannot_use_imports_exports_or_module_augmentations_when_module_is_none_1148", "Cannot use imports, exports, or module augmentations when '--module' is 'none'."),
      File_name_0_differs_from_already_included_file_name_1_only_in_casing: diag(1149, ts2.DiagnosticCategory.Error, "File_name_0_differs_from_already_included_file_name_1_only_in_casing_1149", "File name '{0}' differs from already included file name '{1}' only in casing."),
      const_declarations_must_be_initialized: diag(1155, ts2.DiagnosticCategory.Error, "const_declarations_must_be_initialized_1155", "'const' declarations must be initialized."),
      const_declarations_can_only_be_declared_inside_a_block: diag(1156, ts2.DiagnosticCategory.Error, "const_declarations_can_only_be_declared_inside_a_block_1156", "'const' declarations can only be declared inside a block."),
      let_declarations_can_only_be_declared_inside_a_block: diag(1157, ts2.DiagnosticCategory.Error, "let_declarations_can_only_be_declared_inside_a_block_1157", "'let' declarations can only be declared inside a block."),
      Unterminated_template_literal: diag(1160, ts2.DiagnosticCategory.Error, "Unterminated_template_literal_1160", "Unterminated template literal."),
      Unterminated_regular_expression_literal: diag(1161, ts2.DiagnosticCategory.Error, "Unterminated_regular_expression_literal_1161", "Unterminated regular expression literal."),
      An_object_member_cannot_be_declared_optional: diag(1162, ts2.DiagnosticCategory.Error, "An_object_member_cannot_be_declared_optional_1162", "An object member cannot be declared optional."),
      A_yield_expression_is_only_allowed_in_a_generator_body: diag(1163, ts2.DiagnosticCategory.Error, "A_yield_expression_is_only_allowed_in_a_generator_body_1163", "A 'yield' expression is only allowed in a generator body."),
      Computed_property_names_are_not_allowed_in_enums: diag(1164, ts2.DiagnosticCategory.Error, "Computed_property_names_are_not_allowed_in_enums_1164", "Computed property names are not allowed in enums."),
      A_computed_property_name_in_an_ambient_context_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1165, ts2.DiagnosticCategory.Error, "A_computed_property_name_in_an_ambient_context_must_refer_to_an_expression_whose_type_is_a_literal_t_1165", "A computed property name in an ambient context must refer to an expression whose type is a literal type or a 'unique symbol' type."),
      A_computed_property_name_in_a_class_property_declaration_must_have_a_simple_literal_type_or_a_unique_symbol_type: diag(1166, ts2.DiagnosticCategory.Error, "A_computed_property_name_in_a_class_property_declaration_must_have_a_simple_literal_type_or_a_unique_1166", "A computed property name in a class property declaration must have a simple literal type or a 'unique symbol' type."),
      A_computed_property_name_in_a_method_overload_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1168, ts2.DiagnosticCategory.Error, "A_computed_property_name_in_a_method_overload_must_refer_to_an_expression_whose_type_is_a_literal_ty_1168", "A computed property name in a method overload must refer to an expression whose type is a literal type or a 'unique symbol' type."),
      A_computed_property_name_in_an_interface_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1169, ts2.DiagnosticCategory.Error, "A_computed_property_name_in_an_interface_must_refer_to_an_expression_whose_type_is_a_literal_type_or_1169", "A computed property name in an interface must refer to an expression whose type is a literal type or a 'unique symbol' type."),
      A_computed_property_name_in_a_type_literal_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1170, ts2.DiagnosticCategory.Error, "A_computed_property_name_in_a_type_literal_must_refer_to_an_expression_whose_type_is_a_literal_type__1170", "A computed property name in a type literal must refer to an expression whose type is a literal type or a 'unique symbol' type."),
      A_comma_expression_is_not_allowed_in_a_computed_property_name: diag(1171, ts2.DiagnosticCategory.Error, "A_comma_expression_is_not_allowed_in_a_computed_property_name_1171", "A comma expression is not allowed in a computed property name."),
      extends_clause_already_seen: diag(1172, ts2.DiagnosticCategory.Error, "extends_clause_already_seen_1172", "'extends' clause already seen."),
      extends_clause_must_precede_implements_clause: diag(1173, ts2.DiagnosticCategory.Error, "extends_clause_must_precede_implements_clause_1173", "'extends' clause must precede 'implements' clause."),
      Classes_can_only_extend_a_single_class: diag(1174, ts2.DiagnosticCategory.Error, "Classes_can_only_extend_a_single_class_1174", "Classes can only extend a single class."),
      implements_clause_already_seen: diag(1175, ts2.DiagnosticCategory.Error, "implements_clause_already_seen_1175", "'implements' clause already seen."),
      Interface_declaration_cannot_have_implements_clause: diag(1176, ts2.DiagnosticCategory.Error, "Interface_declaration_cannot_have_implements_clause_1176", "Interface declaration cannot have 'implements' clause."),
      Binary_digit_expected: diag(1177, ts2.DiagnosticCategory.Error, "Binary_digit_expected_1177", "Binary digit expected."),
      Octal_digit_expected: diag(1178, ts2.DiagnosticCategory.Error, "Octal_digit_expected_1178", "Octal digit expected."),
      Unexpected_token_expected: diag(1179, ts2.DiagnosticCategory.Error, "Unexpected_token_expected_1179", "Unexpected token. '{' expected."),
      Property_destructuring_pattern_expected: diag(1180, ts2.DiagnosticCategory.Error, "Property_destructuring_pattern_expected_1180", "Property destructuring pattern expected."),
      Array_element_destructuring_pattern_expected: diag(1181, ts2.DiagnosticCategory.Error, "Array_element_destructuring_pattern_expected_1181", "Array element destructuring pattern expected."),
      A_destructuring_declaration_must_have_an_initializer: diag(1182, ts2.DiagnosticCategory.Error, "A_destructuring_declaration_must_have_an_initializer_1182", "A destructuring declaration must have an initializer."),
      An_implementation_cannot_be_declared_in_ambient_contexts: diag(1183, ts2.DiagnosticCategory.Error, "An_implementation_cannot_be_declared_in_ambient_contexts_1183", "An implementation cannot be declared in ambient contexts."),
      Modifiers_cannot_appear_here: diag(1184, ts2.DiagnosticCategory.Error, "Modifiers_cannot_appear_here_1184", "Modifiers cannot appear here."),
      Merge_conflict_marker_encountered: diag(1185, ts2.DiagnosticCategory.Error, "Merge_conflict_marker_encountered_1185", "Merge conflict marker encountered."),
      A_rest_element_cannot_have_an_initializer: diag(1186, ts2.DiagnosticCategory.Error, "A_rest_element_cannot_have_an_initializer_1186", "A rest element cannot have an initializer."),
      A_parameter_property_may_not_be_declared_using_a_binding_pattern: diag(1187, ts2.DiagnosticCategory.Error, "A_parameter_property_may_not_be_declared_using_a_binding_pattern_1187", "A parameter property may not be declared using a binding pattern."),
      Only_a_single_variable_declaration_is_allowed_in_a_for_of_statement: diag(1188, ts2.DiagnosticCategory.Error, "Only_a_single_variable_declaration_is_allowed_in_a_for_of_statement_1188", "Only a single variable declaration is allowed in a 'for...of' statement."),
      The_variable_declaration_of_a_for_in_statement_cannot_have_an_initializer: diag(1189, ts2.DiagnosticCategory.Error, "The_variable_declaration_of_a_for_in_statement_cannot_have_an_initializer_1189", "The variable declaration of a 'for...in' statement cannot have an initializer."),
      The_variable_declaration_of_a_for_of_statement_cannot_have_an_initializer: diag(1190, ts2.DiagnosticCategory.Error, "The_variable_declaration_of_a_for_of_statement_cannot_have_an_initializer_1190", "The variable declaration of a 'for...of' statement cannot have an initializer."),
      An_import_declaration_cannot_have_modifiers: diag(1191, ts2.DiagnosticCategory.Error, "An_import_declaration_cannot_have_modifiers_1191", "An import declaration cannot have modifiers."),
      Module_0_has_no_default_export: diag(1192, ts2.DiagnosticCategory.Error, "Module_0_has_no_default_export_1192", "Module '{0}' has no default export."),
      An_export_declaration_cannot_have_modifiers: diag(1193, ts2.DiagnosticCategory.Error, "An_export_declaration_cannot_have_modifiers_1193", "An export declaration cannot have modifiers."),
      Export_declarations_are_not_permitted_in_a_namespace: diag(1194, ts2.DiagnosticCategory.Error, "Export_declarations_are_not_permitted_in_a_namespace_1194", "Export declarations are not permitted in a namespace."),
      export_Asterisk_does_not_re_export_a_default: diag(1195, ts2.DiagnosticCategory.Error, "export_Asterisk_does_not_re_export_a_default_1195", "'export *' does not re-export a default."),
      Catch_clause_variable_type_annotation_must_be_any_or_unknown_if_specified: diag(1196, ts2.DiagnosticCategory.Error, "Catch_clause_variable_type_annotation_must_be_any_or_unknown_if_specified_1196", "Catch clause variable type annotation must be 'any' or 'unknown' if specified."),
      Catch_clause_variable_cannot_have_an_initializer: diag(1197, ts2.DiagnosticCategory.Error, "Catch_clause_variable_cannot_have_an_initializer_1197", "Catch clause variable cannot have an initializer."),
      An_extended_Unicode_escape_value_must_be_between_0x0_and_0x10FFFF_inclusive: diag(1198, ts2.DiagnosticCategory.Error, "An_extended_Unicode_escape_value_must_be_between_0x0_and_0x10FFFF_inclusive_1198", "An extended Unicode escape value must be between 0x0 and 0x10FFFF inclusive."),
      Unterminated_Unicode_escape_sequence: diag(1199, ts2.DiagnosticCategory.Error, "Unterminated_Unicode_escape_sequence_1199", "Unterminated Unicode escape sequence."),
      Line_terminator_not_permitted_before_arrow: diag(1200, ts2.DiagnosticCategory.Error, "Line_terminator_not_permitted_before_arrow_1200", "Line terminator not permitted before arrow."),
      Import_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_import_Asterisk_as_ns_from_mod_import_a_from_mod_import_d_from_mod_or_another_module_format_instead: diag(1202, ts2.DiagnosticCategory.Error, "Import_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_import_Asterisk_as_1202", `Import assignment cannot be used when targeting ECMAScript modules. Consider using 'import * as ns from "mod"', 'import {a} from "mod"', 'import d from "mod"', or another module format instead.`),
      Export_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_export_default_or_another_module_format_instead: diag(1203, ts2.DiagnosticCategory.Error, "Export_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_export_default_or__1203", "Export assignment cannot be used when targeting ECMAScript modules. Consider using 'export default' or another module format instead."),
      Re_exporting_a_type_when_the_isolatedModules_flag_is_provided_requires_using_export_type: diag(1205, ts2.DiagnosticCategory.Error, "Re_exporting_a_type_when_the_isolatedModules_flag_is_provided_requires_using_export_type_1205", "Re-exporting a type when the '--isolatedModules' flag is provided requires using 'export type'."),
      Decorators_are_not_valid_here: diag(1206, ts2.DiagnosticCategory.Error, "Decorators_are_not_valid_here_1206", "Decorators are not valid here."),
      Decorators_cannot_be_applied_to_multiple_get_Slashset_accessors_of_the_same_name: diag(1207, ts2.DiagnosticCategory.Error, "Decorators_cannot_be_applied_to_multiple_get_Slashset_accessors_of_the_same_name_1207", "Decorators cannot be applied to multiple get/set accessors of the same name."),
      _0_cannot_be_compiled_under_isolatedModules_because_it_is_considered_a_global_script_file_Add_an_import_export_or_an_empty_export_statement_to_make_it_a_module: diag(1208, ts2.DiagnosticCategory.Error, "_0_cannot_be_compiled_under_isolatedModules_because_it_is_considered_a_global_script_file_Add_an_imp_1208", "'{0}' cannot be compiled under '--isolatedModules' because it is considered a global script file. Add an import, export, or an empty 'export {}' statement to make it a module."),
      Code_contained_in_a_class_is_evaluated_in_JavaScript_s_strict_mode_which_does_not_allow_this_use_of_0_For_more_information_see_https_Colon_Slash_Slashdeveloper_mozilla_org_Slashen_US_Slashdocs_SlashWeb_SlashJavaScript_SlashReference_SlashStrict_mode: diag(1210, ts2.DiagnosticCategory.Error, "Code_contained_in_a_class_is_evaluated_in_JavaScript_s_strict_mode_which_does_not_allow_this_use_of__1210", "Code contained in a class is evaluated in JavaScript's strict mode which does not allow this use of '{0}'. For more information, see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Strict_mode."),
      A_class_declaration_without_the_default_modifier_must_have_a_name: diag(1211, ts2.DiagnosticCategory.Error, "A_class_declaration_without_the_default_modifier_must_have_a_name_1211", "A class declaration without the 'default' modifier must have a name."),
      Identifier_expected_0_is_a_reserved_word_in_strict_mode: diag(1212, ts2.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_in_strict_mode_1212", "Identifier expected. '{0}' is a reserved word in strict mode."),
      Identifier_expected_0_is_a_reserved_word_in_strict_mode_Class_definitions_are_automatically_in_strict_mode: diag(1213, ts2.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_in_strict_mode_Class_definitions_are_automatically_in_stric_1213", "Identifier expected. '{0}' is a reserved word in strict mode. Class definitions are automatically in strict mode."),
      Identifier_expected_0_is_a_reserved_word_in_strict_mode_Modules_are_automatically_in_strict_mode: diag(1214, ts2.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_in_strict_mode_Modules_are_automatically_in_strict_mode_1214", "Identifier expected. '{0}' is a reserved word in strict mode. Modules are automatically in strict mode."),
      Invalid_use_of_0_Modules_are_automatically_in_strict_mode: diag(1215, ts2.DiagnosticCategory.Error, "Invalid_use_of_0_Modules_are_automatically_in_strict_mode_1215", "Invalid use of '{0}'. Modules are automatically in strict mode."),
      Identifier_expected_esModule_is_reserved_as_an_exported_marker_when_transforming_ECMAScript_modules: diag(1216, ts2.DiagnosticCategory.Error, "Identifier_expected_esModule_is_reserved_as_an_exported_marker_when_transforming_ECMAScript_modules_1216", "Identifier expected. '__esModule' is reserved as an exported marker when transforming ECMAScript modules."),
      Export_assignment_is_not_supported_when_module_flag_is_system: diag(1218, ts2.DiagnosticCategory.Error, "Export_assignment_is_not_supported_when_module_flag_is_system_1218", "Export assignment is not supported when '--module' flag is 'system'."),
      Experimental_support_for_decorators_is_a_feature_that_is_subject_to_change_in_a_future_release_Set_the_experimentalDecorators_option_in_your_tsconfig_or_jsconfig_to_remove_this_warning: diag(1219, ts2.DiagnosticCategory.Error, "Experimental_support_for_decorators_is_a_feature_that_is_subject_to_change_in_a_future_release_Set_t_1219", "Experimental support for decorators is a feature that is subject to change in a future release. Set the 'experimentalDecorators' option in your 'tsconfig' or 'jsconfig' to remove this warning."),
      Generators_are_only_available_when_targeting_ECMAScript_2015_or_higher: diag(1220, ts2.DiagnosticCategory.Error, "Generators_are_only_available_when_targeting_ECMAScript_2015_or_higher_1220", "Generators are only available when targeting ECMAScript 2015 or higher."),
      Generators_are_not_allowed_in_an_ambient_context: diag(1221, ts2.DiagnosticCategory.Error, "Generators_are_not_allowed_in_an_ambient_context_1221", "Generators are not allowed in an ambient context."),
      An_overload_signature_cannot_be_declared_as_a_generator: diag(1222, ts2.DiagnosticCategory.Error, "An_overload_signature_cannot_be_declared_as_a_generator_1222", "An overload signature cannot be declared as a generator."),
      _0_tag_already_specified: diag(1223, ts2.DiagnosticCategory.Error, "_0_tag_already_specified_1223", "'{0}' tag already specified."),
      Signature_0_must_be_a_type_predicate: diag(1224, ts2.DiagnosticCategory.Error, "Signature_0_must_be_a_type_predicate_1224", "Signature '{0}' must be a type predicate."),
      Cannot_find_parameter_0: diag(1225, ts2.DiagnosticCategory.Error, "Cannot_find_parameter_0_1225", "Cannot find parameter '{0}'."),
      Type_predicate_0_is_not_assignable_to_1: diag(1226, ts2.DiagnosticCategory.Error, "Type_predicate_0_is_not_assignable_to_1_1226", "Type predicate '{0}' is not assignable to '{1}'."),
      Parameter_0_is_not_in_the_same_position_as_parameter_1: diag(1227, ts2.DiagnosticCategory.Error, "Parameter_0_is_not_in_the_same_position_as_parameter_1_1227", "Parameter '{0}' is not in the same position as parameter '{1}'."),
      A_type_predicate_is_only_allowed_in_return_type_position_for_functions_and_methods: diag(1228, ts2.DiagnosticCategory.Error, "A_type_predicate_is_only_allowed_in_return_type_position_for_functions_and_methods_1228", "A type predicate is only allowed in return type position for functions and methods."),
      A_type_predicate_cannot_reference_a_rest_parameter: diag(1229, ts2.DiagnosticCategory.Error, "A_type_predicate_cannot_reference_a_rest_parameter_1229", "A type predicate cannot reference a rest parameter."),
      A_type_predicate_cannot_reference_element_0_in_a_binding_pattern: diag(1230, ts2.DiagnosticCategory.Error, "A_type_predicate_cannot_reference_element_0_in_a_binding_pattern_1230", "A type predicate cannot reference element '{0}' in a binding pattern."),
      An_export_assignment_must_be_at_the_top_level_of_a_file_or_module_declaration: diag(1231, ts2.DiagnosticCategory.Error, "An_export_assignment_must_be_at_the_top_level_of_a_file_or_module_declaration_1231", "An export assignment must be at the top level of a file or module declaration."),
      An_import_declaration_can_only_be_used_in_a_namespace_or_module: diag(1232, ts2.DiagnosticCategory.Error, "An_import_declaration_can_only_be_used_in_a_namespace_or_module_1232", "An import declaration can only be used in a namespace or module."),
      An_export_declaration_can_only_be_used_in_a_module: diag(1233, ts2.DiagnosticCategory.Error, "An_export_declaration_can_only_be_used_in_a_module_1233", "An export declaration can only be used in a module."),
      An_ambient_module_declaration_is_only_allowed_at_the_top_level_in_a_file: diag(1234, ts2.DiagnosticCategory.Error, "An_ambient_module_declaration_is_only_allowed_at_the_top_level_in_a_file_1234", "An ambient module declaration is only allowed at the top level in a file."),
      A_namespace_declaration_is_only_allowed_in_a_namespace_or_module: diag(1235, ts2.DiagnosticCategory.Error, "A_namespace_declaration_is_only_allowed_in_a_namespace_or_module_1235", "A namespace declaration is only allowed in a namespace or module."),
      The_return_type_of_a_property_decorator_function_must_be_either_void_or_any: diag(1236, ts2.DiagnosticCategory.Error, "The_return_type_of_a_property_decorator_function_must_be_either_void_or_any_1236", "The return type of a property decorator function must be either 'void' or 'any'."),
      The_return_type_of_a_parameter_decorator_function_must_be_either_void_or_any: diag(1237, ts2.DiagnosticCategory.Error, "The_return_type_of_a_parameter_decorator_function_must_be_either_void_or_any_1237", "The return type of a parameter decorator function must be either 'void' or 'any'."),
      Unable_to_resolve_signature_of_class_decorator_when_called_as_an_expression: diag(1238, ts2.DiagnosticCategory.Error, "Unable_to_resolve_signature_of_class_decorator_when_called_as_an_expression_1238", "Unable to resolve signature of class decorator when called as an expression."),
      Unable_to_resolve_signature_of_parameter_decorator_when_called_as_an_expression: diag(1239, ts2.DiagnosticCategory.Error, "Unable_to_resolve_signature_of_parameter_decorator_when_called_as_an_expression_1239", "Unable to resolve signature of parameter decorator when called as an expression."),
      Unable_to_resolve_signature_of_property_decorator_when_called_as_an_expression: diag(1240, ts2.DiagnosticCategory.Error, "Unable_to_resolve_signature_of_property_decorator_when_called_as_an_expression_1240", "Unable to resolve signature of property decorator when called as an expression."),
      Unable_to_resolve_signature_of_method_decorator_when_called_as_an_expression: diag(1241, ts2.DiagnosticCategory.Error, "Unable_to_resolve_signature_of_method_decorator_when_called_as_an_expression_1241", "Unable to resolve signature of method decorator when called as an expression."),
      abstract_modifier_can_only_appear_on_a_class_method_or_property_declaration: diag(1242, ts2.DiagnosticCategory.Error, "abstract_modifier_can_only_appear_on_a_class_method_or_property_declaration_1242", "'abstract' modifier can only appear on a class, method, or property declaration."),
      _0_modifier_cannot_be_used_with_1_modifier: diag(1243, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_be_used_with_1_modifier_1243", "'{0}' modifier cannot be used with '{1}' modifier."),
      Abstract_methods_can_only_appear_within_an_abstract_class: diag(1244, ts2.DiagnosticCategory.Error, "Abstract_methods_can_only_appear_within_an_abstract_class_1244", "Abstract methods can only appear within an abstract class."),
      Method_0_cannot_have_an_implementation_because_it_is_marked_abstract: diag(1245, ts2.DiagnosticCategory.Error, "Method_0_cannot_have_an_implementation_because_it_is_marked_abstract_1245", "Method '{0}' cannot have an implementation because it is marked abstract."),
      An_interface_property_cannot_have_an_initializer: diag(1246, ts2.DiagnosticCategory.Error, "An_interface_property_cannot_have_an_initializer_1246", "An interface property cannot have an initializer."),
      A_type_literal_property_cannot_have_an_initializer: diag(1247, ts2.DiagnosticCategory.Error, "A_type_literal_property_cannot_have_an_initializer_1247", "A type literal property cannot have an initializer."),
      A_class_member_cannot_have_the_0_keyword: diag(1248, ts2.DiagnosticCategory.Error, "A_class_member_cannot_have_the_0_keyword_1248", "A class member cannot have the '{0}' keyword."),
      A_decorator_can_only_decorate_a_method_implementation_not_an_overload: diag(1249, ts2.DiagnosticCategory.Error, "A_decorator_can_only_decorate_a_method_implementation_not_an_overload_1249", "A decorator can only decorate a method implementation, not an overload."),
      Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5: diag(1250, ts2.DiagnosticCategory.Error, "Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_1250", "Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'."),
      Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Class_definitions_are_automatically_in_strict_mode: diag(1251, ts2.DiagnosticCategory.Error, "Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Class_d_1251", "Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'. Class definitions are automatically in strict mode."),
      Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Modules_are_automatically_in_strict_mode: diag(1252, ts2.DiagnosticCategory.Error, "Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Modules_1252", "Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'. Modules are automatically in strict mode."),
      _0_tag_cannot_be_used_independently_as_a_top_level_JSDoc_tag: diag(1253, ts2.DiagnosticCategory.Error, "_0_tag_cannot_be_used_independently_as_a_top_level_JSDoc_tag_1253", "'{0}' tag cannot be used independently as a top level JSDoc tag."),
      A_const_initializer_in_an_ambient_context_must_be_a_string_or_numeric_literal_or_literal_enum_reference: diag(1254, ts2.DiagnosticCategory.Error, "A_const_initializer_in_an_ambient_context_must_be_a_string_or_numeric_literal_or_literal_enum_refere_1254", "A 'const' initializer in an ambient context must be a string or numeric literal or literal enum reference."),
      A_definite_assignment_assertion_is_not_permitted_in_this_context: diag(1255, ts2.DiagnosticCategory.Error, "A_definite_assignment_assertion_is_not_permitted_in_this_context_1255", "A definite assignment assertion '!' is not permitted in this context."),
      A_required_element_cannot_follow_an_optional_element: diag(1257, ts2.DiagnosticCategory.Error, "A_required_element_cannot_follow_an_optional_element_1257", "A required element cannot follow an optional element."),
      A_default_export_must_be_at_the_top_level_of_a_file_or_module_declaration: diag(1258, ts2.DiagnosticCategory.Error, "A_default_export_must_be_at_the_top_level_of_a_file_or_module_declaration_1258", "A default export must be at the top level of a file or module declaration."),
      Module_0_can_only_be_default_imported_using_the_1_flag: diag(1259, ts2.DiagnosticCategory.Error, "Module_0_can_only_be_default_imported_using_the_1_flag_1259", "Module '{0}' can only be default-imported using the '{1}' flag"),
      Keywords_cannot_contain_escape_characters: diag(1260, ts2.DiagnosticCategory.Error, "Keywords_cannot_contain_escape_characters_1260", "Keywords cannot contain escape characters."),
      Already_included_file_name_0_differs_from_file_name_1_only_in_casing: diag(1261, ts2.DiagnosticCategory.Error, "Already_included_file_name_0_differs_from_file_name_1_only_in_casing_1261", "Already included file name '{0}' differs from file name '{1}' only in casing."),
      Identifier_expected_0_is_a_reserved_word_at_the_top_level_of_a_module: diag(1262, ts2.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_at_the_top_level_of_a_module_1262", "Identifier expected. '{0}' is a reserved word at the top-level of a module."),
      Declarations_with_initializers_cannot_also_have_definite_assignment_assertions: diag(1263, ts2.DiagnosticCategory.Error, "Declarations_with_initializers_cannot_also_have_definite_assignment_assertions_1263", "Declarations with initializers cannot also have definite assignment assertions."),
      Declarations_with_definite_assignment_assertions_must_also_have_type_annotations: diag(1264, ts2.DiagnosticCategory.Error, "Declarations_with_definite_assignment_assertions_must_also_have_type_annotations_1264", "Declarations with definite assignment assertions must also have type annotations."),
      A_rest_element_cannot_follow_another_rest_element: diag(1265, ts2.DiagnosticCategory.Error, "A_rest_element_cannot_follow_another_rest_element_1265", "A rest element cannot follow another rest element."),
      An_optional_element_cannot_follow_a_rest_element: diag(1266, ts2.DiagnosticCategory.Error, "An_optional_element_cannot_follow_a_rest_element_1266", "An optional element cannot follow a rest element."),
      Property_0_cannot_have_an_initializer_because_it_is_marked_abstract: diag(1267, ts2.DiagnosticCategory.Error, "Property_0_cannot_have_an_initializer_because_it_is_marked_abstract_1267", "Property '{0}' cannot have an initializer because it is marked abstract."),
      An_index_signature_parameter_type_must_be_string_number_symbol_or_a_template_literal_type: diag(1268, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_type_must_be_string_number_symbol_or_a_template_literal_type_1268", "An index signature parameter type must be 'string', 'number', 'symbol', or a template literal type."),
      with_statements_are_not_allowed_in_an_async_function_block: diag(1300, ts2.DiagnosticCategory.Error, "with_statements_are_not_allowed_in_an_async_function_block_1300", "'with' statements are not allowed in an async function block."),
      await_expressions_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules: diag(1308, ts2.DiagnosticCategory.Error, "await_expressions_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules_1308", "'await' expressions are only allowed within async functions and at the top levels of modules."),
      Did_you_mean_to_use_a_Colon_An_can_only_follow_a_property_name_when_the_containing_object_literal_is_part_of_a_destructuring_pattern: diag(1312, ts2.DiagnosticCategory.Error, "Did_you_mean_to_use_a_Colon_An_can_only_follow_a_property_name_when_the_containing_object_literal_is_1312", "Did you mean to use a ':'? An '=' can only follow a property name when the containing object literal is part of a destructuring pattern."),
      The_body_of_an_if_statement_cannot_be_the_empty_statement: diag(1313, ts2.DiagnosticCategory.Error, "The_body_of_an_if_statement_cannot_be_the_empty_statement_1313", "The body of an 'if' statement cannot be the empty statement."),
      Global_module_exports_may_only_appear_in_module_files: diag(1314, ts2.DiagnosticCategory.Error, "Global_module_exports_may_only_appear_in_module_files_1314", "Global module exports may only appear in module files."),
      Global_module_exports_may_only_appear_in_declaration_files: diag(1315, ts2.DiagnosticCategory.Error, "Global_module_exports_may_only_appear_in_declaration_files_1315", "Global module exports may only appear in declaration files."),
      Global_module_exports_may_only_appear_at_top_level: diag(1316, ts2.DiagnosticCategory.Error, "Global_module_exports_may_only_appear_at_top_level_1316", "Global module exports may only appear at top level."),
      A_parameter_property_cannot_be_declared_using_a_rest_parameter: diag(1317, ts2.DiagnosticCategory.Error, "A_parameter_property_cannot_be_declared_using_a_rest_parameter_1317", "A parameter property cannot be declared using a rest parameter."),
      An_abstract_accessor_cannot_have_an_implementation: diag(1318, ts2.DiagnosticCategory.Error, "An_abstract_accessor_cannot_have_an_implementation_1318", "An abstract accessor cannot have an implementation."),
      A_default_export_can_only_be_used_in_an_ECMAScript_style_module: diag(1319, ts2.DiagnosticCategory.Error, "A_default_export_can_only_be_used_in_an_ECMAScript_style_module_1319", "A default export can only be used in an ECMAScript-style module."),
      Type_of_await_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1320, ts2.DiagnosticCategory.Error, "Type_of_await_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member_1320", "Type of 'await' operand must either be a valid promise or must not contain a callable 'then' member."),
      Type_of_yield_operand_in_an_async_generator_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1321, ts2.DiagnosticCategory.Error, "Type_of_yield_operand_in_an_async_generator_must_either_be_a_valid_promise_or_must_not_contain_a_cal_1321", "Type of 'yield' operand in an async generator must either be a valid promise or must not contain a callable 'then' member."),
      Type_of_iterated_elements_of_a_yield_Asterisk_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1322, ts2.DiagnosticCategory.Error, "Type_of_iterated_elements_of_a_yield_Asterisk_operand_must_either_be_a_valid_promise_or_must_not_con_1322", "Type of iterated elements of a 'yield*' operand must either be a valid promise or must not contain a callable 'then' member."),
      Dynamic_imports_are_only_supported_when_the_module_flag_is_set_to_es2020_esnext_commonjs_amd_system_or_umd: diag(1323, ts2.DiagnosticCategory.Error, "Dynamic_imports_are_only_supported_when_the_module_flag_is_set_to_es2020_esnext_commonjs_amd_system__1323", "Dynamic imports are only supported when the '--module' flag is set to 'es2020', 'esnext', 'commonjs', 'amd', 'system', or 'umd'."),
      Dynamic_import_must_have_one_specifier_as_an_argument: diag(1324, ts2.DiagnosticCategory.Error, "Dynamic_import_must_have_one_specifier_as_an_argument_1324", "Dynamic import must have one specifier as an argument."),
      Specifier_of_dynamic_import_cannot_be_spread_element: diag(1325, ts2.DiagnosticCategory.Error, "Specifier_of_dynamic_import_cannot_be_spread_element_1325", "Specifier of dynamic import cannot be spread element."),
      Dynamic_import_cannot_have_type_arguments: diag(1326, ts2.DiagnosticCategory.Error, "Dynamic_import_cannot_have_type_arguments_1326", "Dynamic import cannot have type arguments."),
      String_literal_with_double_quotes_expected: diag(1327, ts2.DiagnosticCategory.Error, "String_literal_with_double_quotes_expected_1327", "String literal with double quotes expected."),
      Property_value_can_only_be_string_literal_numeric_literal_true_false_null_object_literal_or_array_literal: diag(1328, ts2.DiagnosticCategory.Error, "Property_value_can_only_be_string_literal_numeric_literal_true_false_null_object_literal_or_array_li_1328", "Property value can only be string literal, numeric literal, 'true', 'false', 'null', object literal or array literal."),
      _0_accepts_too_few_arguments_to_be_used_as_a_decorator_here_Did_you_mean_to_call_it_first_and_write_0: diag(1329, ts2.DiagnosticCategory.Error, "_0_accepts_too_few_arguments_to_be_used_as_a_decorator_here_Did_you_mean_to_call_it_first_and_write__1329", "'{0}' accepts too few arguments to be used as a decorator here. Did you mean to call it first and write '@{0}()'?"),
      A_property_of_an_interface_or_type_literal_whose_type_is_a_unique_symbol_type_must_be_readonly: diag(1330, ts2.DiagnosticCategory.Error, "A_property_of_an_interface_or_type_literal_whose_type_is_a_unique_symbol_type_must_be_readonly_1330", "A property of an interface or type literal whose type is a 'unique symbol' type must be 'readonly'."),
      A_property_of_a_class_whose_type_is_a_unique_symbol_type_must_be_both_static_and_readonly: diag(1331, ts2.DiagnosticCategory.Error, "A_property_of_a_class_whose_type_is_a_unique_symbol_type_must_be_both_static_and_readonly_1331", "A property of a class whose type is a 'unique symbol' type must be both 'static' and 'readonly'."),
      A_variable_whose_type_is_a_unique_symbol_type_must_be_const: diag(1332, ts2.DiagnosticCategory.Error, "A_variable_whose_type_is_a_unique_symbol_type_must_be_const_1332", "A variable whose type is a 'unique symbol' type must be 'const'."),
      unique_symbol_types_may_not_be_used_on_a_variable_declaration_with_a_binding_name: diag(1333, ts2.DiagnosticCategory.Error, "unique_symbol_types_may_not_be_used_on_a_variable_declaration_with_a_binding_name_1333", "'unique symbol' types may not be used on a variable declaration with a binding name."),
      unique_symbol_types_are_only_allowed_on_variables_in_a_variable_statement: diag(1334, ts2.DiagnosticCategory.Error, "unique_symbol_types_are_only_allowed_on_variables_in_a_variable_statement_1334", "'unique symbol' types are only allowed on variables in a variable statement."),
      unique_symbol_types_are_not_allowed_here: diag(1335, ts2.DiagnosticCategory.Error, "unique_symbol_types_are_not_allowed_here_1335", "'unique symbol' types are not allowed here."),
      An_index_signature_parameter_type_cannot_be_a_literal_type_or_generic_type_Consider_using_a_mapped_object_type_instead: diag(1337, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_type_cannot_be_a_literal_type_or_generic_type_Consider_using_a_mapped_o_1337", "An index signature parameter type cannot be a literal type or generic type. Consider using a mapped object type instead."),
      infer_declarations_are_only_permitted_in_the_extends_clause_of_a_conditional_type: diag(1338, ts2.DiagnosticCategory.Error, "infer_declarations_are_only_permitted_in_the_extends_clause_of_a_conditional_type_1338", "'infer' declarations are only permitted in the 'extends' clause of a conditional type."),
      Module_0_does_not_refer_to_a_value_but_is_used_as_a_value_here: diag(1339, ts2.DiagnosticCategory.Error, "Module_0_does_not_refer_to_a_value_but_is_used_as_a_value_here_1339", "Module '{0}' does not refer to a value, but is used as a value here."),
      Module_0_does_not_refer_to_a_type_but_is_used_as_a_type_here_Did_you_mean_typeof_import_0: diag(1340, ts2.DiagnosticCategory.Error, "Module_0_does_not_refer_to_a_type_but_is_used_as_a_type_here_Did_you_mean_typeof_import_0_1340", "Module '{0}' does not refer to a type, but is used as a type here. Did you mean 'typeof import('{0}')'?"),
      Type_arguments_cannot_be_used_here: diag(1342, ts2.DiagnosticCategory.Error, "Type_arguments_cannot_be_used_here_1342", "Type arguments cannot be used here."),
      The_import_meta_meta_property_is_only_allowed_when_the_module_option_is_es2020_esnext_or_system: diag(1343, ts2.DiagnosticCategory.Error, "The_import_meta_meta_property_is_only_allowed_when_the_module_option_is_es2020_esnext_or_system_1343", "The 'import.meta' meta-property is only allowed when the '--module' option is 'es2020', 'esnext', or 'system'."),
      A_label_is_not_allowed_here: diag(1344, ts2.DiagnosticCategory.Error, "A_label_is_not_allowed_here_1344", "'A label is not allowed here."),
      An_expression_of_type_void_cannot_be_tested_for_truthiness: diag(1345, ts2.DiagnosticCategory.Error, "An_expression_of_type_void_cannot_be_tested_for_truthiness_1345", "An expression of type 'void' cannot be tested for truthiness."),
      This_parameter_is_not_allowed_with_use_strict_directive: diag(1346, ts2.DiagnosticCategory.Error, "This_parameter_is_not_allowed_with_use_strict_directive_1346", "This parameter is not allowed with 'use strict' directive."),
      use_strict_directive_cannot_be_used_with_non_simple_parameter_list: diag(1347, ts2.DiagnosticCategory.Error, "use_strict_directive_cannot_be_used_with_non_simple_parameter_list_1347", "'use strict' directive cannot be used with non-simple parameter list."),
      Non_simple_parameter_declared_here: diag(1348, ts2.DiagnosticCategory.Error, "Non_simple_parameter_declared_here_1348", "Non-simple parameter declared here."),
      use_strict_directive_used_here: diag(1349, ts2.DiagnosticCategory.Error, "use_strict_directive_used_here_1349", "'use strict' directive used here."),
      Print_the_final_configuration_instead_of_building: diag(1350, ts2.DiagnosticCategory.Message, "Print_the_final_configuration_instead_of_building_1350", "Print the final configuration instead of building."),
      An_identifier_or_keyword_cannot_immediately_follow_a_numeric_literal: diag(1351, ts2.DiagnosticCategory.Error, "An_identifier_or_keyword_cannot_immediately_follow_a_numeric_literal_1351", "An identifier or keyword cannot immediately follow a numeric literal."),
      A_bigint_literal_cannot_use_exponential_notation: diag(1352, ts2.DiagnosticCategory.Error, "A_bigint_literal_cannot_use_exponential_notation_1352", "A bigint literal cannot use exponential notation."),
      A_bigint_literal_must_be_an_integer: diag(1353, ts2.DiagnosticCategory.Error, "A_bigint_literal_must_be_an_integer_1353", "A bigint literal must be an integer."),
      readonly_type_modifier_is_only_permitted_on_array_and_tuple_literal_types: diag(1354, ts2.DiagnosticCategory.Error, "readonly_type_modifier_is_only_permitted_on_array_and_tuple_literal_types_1354", "'readonly' type modifier is only permitted on array and tuple literal types."),
      A_const_assertions_can_only_be_applied_to_references_to_enum_members_or_string_number_boolean_array_or_object_literals: diag(1355, ts2.DiagnosticCategory.Error, "A_const_assertions_can_only_be_applied_to_references_to_enum_members_or_string_number_boolean_array__1355", "A 'const' assertions can only be applied to references to enum members, or string, number, boolean, array, or object literals."),
      Did_you_mean_to_mark_this_function_as_async: diag(1356, ts2.DiagnosticCategory.Error, "Did_you_mean_to_mark_this_function_as_async_1356", "Did you mean to mark this function as 'async'?"),
      An_enum_member_name_must_be_followed_by_a_or: diag(1357, ts2.DiagnosticCategory.Error, "An_enum_member_name_must_be_followed_by_a_or_1357", "An enum member name must be followed by a ',', '=', or '}'."),
      Tagged_template_expressions_are_not_permitted_in_an_optional_chain: diag(1358, ts2.DiagnosticCategory.Error, "Tagged_template_expressions_are_not_permitted_in_an_optional_chain_1358", "Tagged template expressions are not permitted in an optional chain."),
      Identifier_expected_0_is_a_reserved_word_that_cannot_be_used_here: diag(1359, ts2.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_that_cannot_be_used_here_1359", "Identifier expected. '{0}' is a reserved word that cannot be used here."),
      Did_you_mean_to_parenthesize_this_function_type: diag(1360, ts2.DiagnosticCategory.Error, "Did_you_mean_to_parenthesize_this_function_type_1360", "Did you mean to parenthesize this function type?"),
      _0_cannot_be_used_as_a_value_because_it_was_imported_using_import_type: diag(1361, ts2.DiagnosticCategory.Error, "_0_cannot_be_used_as_a_value_because_it_was_imported_using_import_type_1361", "'{0}' cannot be used as a value because it was imported using 'import type'."),
      _0_cannot_be_used_as_a_value_because_it_was_exported_using_export_type: diag(1362, ts2.DiagnosticCategory.Error, "_0_cannot_be_used_as_a_value_because_it_was_exported_using_export_type_1362", "'{0}' cannot be used as a value because it was exported using 'export type'."),
      A_type_only_import_can_specify_a_default_import_or_named_bindings_but_not_both: diag(1363, ts2.DiagnosticCategory.Error, "A_type_only_import_can_specify_a_default_import_or_named_bindings_but_not_both_1363", "A type-only import can specify a default import or named bindings, but not both."),
      Convert_to_type_only_export: diag(1364, ts2.DiagnosticCategory.Message, "Convert_to_type_only_export_1364", "Convert to type-only export"),
      Convert_all_re_exported_types_to_type_only_exports: diag(1365, ts2.DiagnosticCategory.Message, "Convert_all_re_exported_types_to_type_only_exports_1365", "Convert all re-exported types to type-only exports"),
      Split_into_two_separate_import_declarations: diag(1366, ts2.DiagnosticCategory.Message, "Split_into_two_separate_import_declarations_1366", "Split into two separate import declarations"),
      Split_all_invalid_type_only_imports: diag(1367, ts2.DiagnosticCategory.Message, "Split_all_invalid_type_only_imports_1367", "Split all invalid type-only imports"),
      Did_you_mean_0: diag(1369, ts2.DiagnosticCategory.Message, "Did_you_mean_0_1369", "Did you mean '{0}'?"),
      This_import_is_never_used_as_a_value_and_must_use_import_type_because_importsNotUsedAsValues_is_set_to_error: diag(1371, ts2.DiagnosticCategory.Error, "This_import_is_never_used_as_a_value_and_must_use_import_type_because_importsNotUsedAsValues_is_set__1371", "This import is never used as a value and must use 'import type' because 'importsNotUsedAsValues' is set to 'error'."),
      Convert_to_type_only_import: diag(1373, ts2.DiagnosticCategory.Message, "Convert_to_type_only_import_1373", "Convert to type-only import"),
      Convert_all_imports_not_used_as_a_value_to_type_only_imports: diag(1374, ts2.DiagnosticCategory.Message, "Convert_all_imports_not_used_as_a_value_to_type_only_imports_1374", "Convert all imports not used as a value to type-only imports"),
      await_expressions_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_file_has_no_imports_or_exports_Consider_adding_an_empty_export_to_make_this_file_a_module: diag(1375, ts2.DiagnosticCategory.Error, "await_expressions_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_fi_1375", "'await' expressions are only allowed at the top level of a file when that file is a module, but this file has no imports or exports. Consider adding an empty 'export {}' to make this file a module."),
      _0_was_imported_here: diag(1376, ts2.DiagnosticCategory.Message, "_0_was_imported_here_1376", "'{0}' was imported here."),
      _0_was_exported_here: diag(1377, ts2.DiagnosticCategory.Message, "_0_was_exported_here_1377", "'{0}' was exported here."),
      Top_level_await_expressions_are_only_allowed_when_the_module_option_is_set_to_esnext_or_system_and_the_target_option_is_set_to_es2017_or_higher: diag(1378, ts2.DiagnosticCategory.Error, "Top_level_await_expressions_are_only_allowed_when_the_module_option_is_set_to_esnext_or_system_and_t_1378", "Top-level 'await' expressions are only allowed when the 'module' option is set to 'esnext' or 'system', and the 'target' option is set to 'es2017' or higher."),
      An_import_alias_cannot_reference_a_declaration_that_was_exported_using_export_type: diag(1379, ts2.DiagnosticCategory.Error, "An_import_alias_cannot_reference_a_declaration_that_was_exported_using_export_type_1379", "An import alias cannot reference a declaration that was exported using 'export type'."),
      An_import_alias_cannot_reference_a_declaration_that_was_imported_using_import_type: diag(1380, ts2.DiagnosticCategory.Error, "An_import_alias_cannot_reference_a_declaration_that_was_imported_using_import_type_1380", "An import alias cannot reference a declaration that was imported using 'import type'."),
      Unexpected_token_Did_you_mean_or_rbrace: diag(1381, ts2.DiagnosticCategory.Error, "Unexpected_token_Did_you_mean_or_rbrace_1381", "Unexpected token. Did you mean `{'}'}` or `&rbrace;`?"),
      Unexpected_token_Did_you_mean_or_gt: diag(1382, ts2.DiagnosticCategory.Error, "Unexpected_token_Did_you_mean_or_gt_1382", "Unexpected token. Did you mean `{'>'}` or `&gt;`?"),
      Only_named_exports_may_use_export_type: diag(1383, ts2.DiagnosticCategory.Error, "Only_named_exports_may_use_export_type_1383", "Only named exports may use 'export type'."),
      A_new_expression_with_type_arguments_must_always_be_followed_by_a_parenthesized_argument_list: diag(1384, ts2.DiagnosticCategory.Error, "A_new_expression_with_type_arguments_must_always_be_followed_by_a_parenthesized_argument_list_1384", "A 'new' expression with type arguments must always be followed by a parenthesized argument list."),
      Function_type_notation_must_be_parenthesized_when_used_in_a_union_type: diag(1385, ts2.DiagnosticCategory.Error, "Function_type_notation_must_be_parenthesized_when_used_in_a_union_type_1385", "Function type notation must be parenthesized when used in a union type."),
      Constructor_type_notation_must_be_parenthesized_when_used_in_a_union_type: diag(1386, ts2.DiagnosticCategory.Error, "Constructor_type_notation_must_be_parenthesized_when_used_in_a_union_type_1386", "Constructor type notation must be parenthesized when used in a union type."),
      Function_type_notation_must_be_parenthesized_when_used_in_an_intersection_type: diag(1387, ts2.DiagnosticCategory.Error, "Function_type_notation_must_be_parenthesized_when_used_in_an_intersection_type_1387", "Function type notation must be parenthesized when used in an intersection type."),
      Constructor_type_notation_must_be_parenthesized_when_used_in_an_intersection_type: diag(1388, ts2.DiagnosticCategory.Error, "Constructor_type_notation_must_be_parenthesized_when_used_in_an_intersection_type_1388", "Constructor type notation must be parenthesized when used in an intersection type."),
      _0_is_not_allowed_as_a_variable_declaration_name: diag(1389, ts2.DiagnosticCategory.Error, "_0_is_not_allowed_as_a_variable_declaration_name_1389", "'{0}' is not allowed as a variable declaration name."),
      Provides_a_root_package_name_when_using_outFile_with_declarations: diag(1390, ts2.DiagnosticCategory.Message, "Provides_a_root_package_name_when_using_outFile_with_declarations_1390", "Provides a root package name when using outFile with declarations."),
      The_bundledPackageName_option_must_be_provided_when_using_outFile_and_node_module_resolution_with_declaration_emit: diag(1391, ts2.DiagnosticCategory.Error, "The_bundledPackageName_option_must_be_provided_when_using_outFile_and_node_module_resolution_with_de_1391", "The 'bundledPackageName' option must be provided when using outFile and node module resolution with declaration emit."),
      An_import_alias_cannot_use_import_type: diag(1392, ts2.DiagnosticCategory.Error, "An_import_alias_cannot_use_import_type_1392", "An import alias cannot use 'import type'"),
      Imported_via_0_from_file_1: diag(1393, ts2.DiagnosticCategory.Message, "Imported_via_0_from_file_1_1393", "Imported via {0} from file '{1}'"),
      Imported_via_0_from_file_1_with_packageId_2: diag(1394, ts2.DiagnosticCategory.Message, "Imported_via_0_from_file_1_with_packageId_2_1394", "Imported via {0} from file '{1}' with packageId '{2}'"),
      Imported_via_0_from_file_1_to_import_importHelpers_as_specified_in_compilerOptions: diag(1395, ts2.DiagnosticCategory.Message, "Imported_via_0_from_file_1_to_import_importHelpers_as_specified_in_compilerOptions_1395", "Imported via {0} from file '{1}' to import 'importHelpers' as specified in compilerOptions"),
      Imported_via_0_from_file_1_with_packageId_2_to_import_importHelpers_as_specified_in_compilerOptions: diag(1396, ts2.DiagnosticCategory.Message, "Imported_via_0_from_file_1_with_packageId_2_to_import_importHelpers_as_specified_in_compilerOptions_1396", "Imported via {0} from file '{1}' with packageId '{2}' to import 'importHelpers' as specified in compilerOptions"),
      Imported_via_0_from_file_1_to_import_jsx_and_jsxs_factory_functions: diag(1397, ts2.DiagnosticCategory.Message, "Imported_via_0_from_file_1_to_import_jsx_and_jsxs_factory_functions_1397", "Imported via {0} from file '{1}' to import 'jsx' and 'jsxs' factory functions"),
      Imported_via_0_from_file_1_with_packageId_2_to_import_jsx_and_jsxs_factory_functions: diag(1398, ts2.DiagnosticCategory.Message, "Imported_via_0_from_file_1_with_packageId_2_to_import_jsx_and_jsxs_factory_functions_1398", "Imported via {0} from file '{1}' with packageId '{2}' to import 'jsx' and 'jsxs' factory functions"),
      File_is_included_via_import_here: diag(1399, ts2.DiagnosticCategory.Message, "File_is_included_via_import_here_1399", "File is included via import here."),
      Referenced_via_0_from_file_1: diag(1400, ts2.DiagnosticCategory.Message, "Referenced_via_0_from_file_1_1400", "Referenced via '{0}' from file '{1}'"),
      File_is_included_via_reference_here: diag(1401, ts2.DiagnosticCategory.Message, "File_is_included_via_reference_here_1401", "File is included via reference here."),
      Type_library_referenced_via_0_from_file_1: diag(1402, ts2.DiagnosticCategory.Message, "Type_library_referenced_via_0_from_file_1_1402", "Type library referenced via '{0}' from file '{1}'"),
      Type_library_referenced_via_0_from_file_1_with_packageId_2: diag(1403, ts2.DiagnosticCategory.Message, "Type_library_referenced_via_0_from_file_1_with_packageId_2_1403", "Type library referenced via '{0}' from file '{1}' with packageId '{2}'"),
      File_is_included_via_type_library_reference_here: diag(1404, ts2.DiagnosticCategory.Message, "File_is_included_via_type_library_reference_here_1404", "File is included via type library reference here."),
      Library_referenced_via_0_from_file_1: diag(1405, ts2.DiagnosticCategory.Message, "Library_referenced_via_0_from_file_1_1405", "Library referenced via '{0}' from file '{1}'"),
      File_is_included_via_library_reference_here: diag(1406, ts2.DiagnosticCategory.Message, "File_is_included_via_library_reference_here_1406", "File is included via library reference here."),
      Matched_by_include_pattern_0_in_1: diag(1407, ts2.DiagnosticCategory.Message, "Matched_by_include_pattern_0_in_1_1407", "Matched by include pattern '{0}' in '{1}'"),
      File_is_matched_by_include_pattern_specified_here: diag(1408, ts2.DiagnosticCategory.Message, "File_is_matched_by_include_pattern_specified_here_1408", "File is matched by include pattern specified here."),
      Part_of_files_list_in_tsconfig_json: diag(1409, ts2.DiagnosticCategory.Message, "Part_of_files_list_in_tsconfig_json_1409", "Part of 'files' list in tsconfig.json"),
      File_is_matched_by_files_list_specified_here: diag(1410, ts2.DiagnosticCategory.Message, "File_is_matched_by_files_list_specified_here_1410", "File is matched by 'files' list specified here."),
      Output_from_referenced_project_0_included_because_1_specified: diag(1411, ts2.DiagnosticCategory.Message, "Output_from_referenced_project_0_included_because_1_specified_1411", "Output from referenced project '{0}' included because '{1}' specified"),
      Output_from_referenced_project_0_included_because_module_is_specified_as_none: diag(1412, ts2.DiagnosticCategory.Message, "Output_from_referenced_project_0_included_because_module_is_specified_as_none_1412", "Output from referenced project '{0}' included because '--module' is specified as 'none'"),
      File_is_output_from_referenced_project_specified_here: diag(1413, ts2.DiagnosticCategory.Message, "File_is_output_from_referenced_project_specified_here_1413", "File is output from referenced project specified here."),
      Source_from_referenced_project_0_included_because_1_specified: diag(1414, ts2.DiagnosticCategory.Message, "Source_from_referenced_project_0_included_because_1_specified_1414", "Source from referenced project '{0}' included because '{1}' specified"),
      Source_from_referenced_project_0_included_because_module_is_specified_as_none: diag(1415, ts2.DiagnosticCategory.Message, "Source_from_referenced_project_0_included_because_module_is_specified_as_none_1415", "Source from referenced project '{0}' included because '--module' is specified as 'none'"),
      File_is_source_from_referenced_project_specified_here: diag(1416, ts2.DiagnosticCategory.Message, "File_is_source_from_referenced_project_specified_here_1416", "File is source from referenced project specified here."),
      Entry_point_of_type_library_0_specified_in_compilerOptions: diag(1417, ts2.DiagnosticCategory.Message, "Entry_point_of_type_library_0_specified_in_compilerOptions_1417", "Entry point of type library '{0}' specified in compilerOptions"),
      Entry_point_of_type_library_0_specified_in_compilerOptions_with_packageId_1: diag(1418, ts2.DiagnosticCategory.Message, "Entry_point_of_type_library_0_specified_in_compilerOptions_with_packageId_1_1418", "Entry point of type library '{0}' specified in compilerOptions with packageId '{1}'"),
      File_is_entry_point_of_type_library_specified_here: diag(1419, ts2.DiagnosticCategory.Message, "File_is_entry_point_of_type_library_specified_here_1419", "File is entry point of type library specified here."),
      Entry_point_for_implicit_type_library_0: diag(1420, ts2.DiagnosticCategory.Message, "Entry_point_for_implicit_type_library_0_1420", "Entry point for implicit type library '{0}'"),
      Entry_point_for_implicit_type_library_0_with_packageId_1: diag(1421, ts2.DiagnosticCategory.Message, "Entry_point_for_implicit_type_library_0_with_packageId_1_1421", "Entry point for implicit type library '{0}' with packageId '{1}'"),
      Library_0_specified_in_compilerOptions: diag(1422, ts2.DiagnosticCategory.Message, "Library_0_specified_in_compilerOptions_1422", "Library '{0}' specified in compilerOptions"),
      File_is_library_specified_here: diag(1423, ts2.DiagnosticCategory.Message, "File_is_library_specified_here_1423", "File is library specified here."),
      Default_library: diag(1424, ts2.DiagnosticCategory.Message, "Default_library_1424", "Default library"),
      Default_library_for_target_0: diag(1425, ts2.DiagnosticCategory.Message, "Default_library_for_target_0_1425", "Default library for target '{0}'"),
      File_is_default_library_for_target_specified_here: diag(1426, ts2.DiagnosticCategory.Message, "File_is_default_library_for_target_specified_here_1426", "File is default library for target specified here."),
      Root_file_specified_for_compilation: diag(1427, ts2.DiagnosticCategory.Message, "Root_file_specified_for_compilation_1427", "Root file specified for compilation"),
      File_is_output_of_project_reference_source_0: diag(1428, ts2.DiagnosticCategory.Message, "File_is_output_of_project_reference_source_0_1428", "File is output of project reference source '{0}'"),
      File_redirects_to_file_0: diag(1429, ts2.DiagnosticCategory.Message, "File_redirects_to_file_0_1429", "File redirects to file '{0}'"),
      The_file_is_in_the_program_because_Colon: diag(1430, ts2.DiagnosticCategory.Message, "The_file_is_in_the_program_because_Colon_1430", "The file is in the program because:"),
      for_await_loops_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_file_has_no_imports_or_exports_Consider_adding_an_empty_export_to_make_this_file_a_module: diag(1431, ts2.DiagnosticCategory.Error, "for_await_loops_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_file_1431", "'for await' loops are only allowed at the top level of a file when that file is a module, but this file has no imports or exports. Consider adding an empty 'export {}' to make this file a module."),
      Top_level_for_await_loops_are_only_allowed_when_the_module_option_is_set_to_esnext_or_system_and_the_target_option_is_set_to_es2017_or_higher: diag(1432, ts2.DiagnosticCategory.Error, "Top_level_for_await_loops_are_only_allowed_when_the_module_option_is_set_to_esnext_or_system_and_the_1432", "Top-level 'for await' loops are only allowed when the 'module' option is set to 'esnext' or 'system', and the 'target' option is set to 'es2017' or higher."),
      Decorators_may_not_be_applied_to_this_parameters: diag(1433, ts2.DiagnosticCategory.Error, "Decorators_may_not_be_applied_to_this_parameters_1433", "Decorators may not be applied to 'this' parameters."),
      Unexpected_keyword_or_identifier: diag(1434, ts2.DiagnosticCategory.Error, "Unexpected_keyword_or_identifier_1434", "Unexpected keyword or identifier."),
      Unknown_keyword_or_identifier_Did_you_mean_0: diag(1435, ts2.DiagnosticCategory.Error, "Unknown_keyword_or_identifier_Did_you_mean_0_1435", "Unknown keyword or identifier. Did you mean '{0}'?"),
      Decorators_must_precede_the_name_and_all_keywords_of_property_declarations: diag(1436, ts2.DiagnosticCategory.Error, "Decorators_must_precede_the_name_and_all_keywords_of_property_declarations_1436", "Decorators must precede the name and all keywords of property declarations."),
      Namespace_must_be_given_a_name: diag(1437, ts2.DiagnosticCategory.Error, "Namespace_must_be_given_a_name_1437", "Namespace must be given a name."),
      Interface_must_be_given_a_name: diag(1438, ts2.DiagnosticCategory.Error, "Interface_must_be_given_a_name_1438", "Interface must be given a name."),
      Type_alias_must_be_given_a_name: diag(1439, ts2.DiagnosticCategory.Error, "Type_alias_must_be_given_a_name_1439", "Type alias must be given a name."),
      Variable_declaration_not_allowed_at_this_location: diag(1440, ts2.DiagnosticCategory.Error, "Variable_declaration_not_allowed_at_this_location_1440", "Variable declaration not allowed at this location."),
      Cannot_start_a_function_call_in_a_type_annotation: diag(1441, ts2.DiagnosticCategory.Error, "Cannot_start_a_function_call_in_a_type_annotation_1441", "Cannot start a function call in a type annotation."),
      Expected_for_property_initializer: diag(1442, ts2.DiagnosticCategory.Error, "Expected_for_property_initializer_1442", "Expected '=' for property initializer."),
      Module_declaration_names_may_only_use_or_quoted_strings: diag(1443, ts2.DiagnosticCategory.Error, "Module_declaration_names_may_only_use_or_quoted_strings_1443", `Module declaration names may only use ' or " quoted strings.`),
      The_types_of_0_are_incompatible_between_these_types: diag(2200, ts2.DiagnosticCategory.Error, "The_types_of_0_are_incompatible_between_these_types_2200", "The types of '{0}' are incompatible between these types."),
      The_types_returned_by_0_are_incompatible_between_these_types: diag(2201, ts2.DiagnosticCategory.Error, "The_types_returned_by_0_are_incompatible_between_these_types_2201", "The types returned by '{0}' are incompatible between these types."),
      Call_signature_return_types_0_and_1_are_incompatible: diag(2202, ts2.DiagnosticCategory.Error, "Call_signature_return_types_0_and_1_are_incompatible_2202", "Call signature return types '{0}' and '{1}' are incompatible.", void 0, true),
      Construct_signature_return_types_0_and_1_are_incompatible: diag(2203, ts2.DiagnosticCategory.Error, "Construct_signature_return_types_0_and_1_are_incompatible_2203", "Construct signature return types '{0}' and '{1}' are incompatible.", void 0, true),
      Call_signatures_with_no_arguments_have_incompatible_return_types_0_and_1: diag(2204, ts2.DiagnosticCategory.Error, "Call_signatures_with_no_arguments_have_incompatible_return_types_0_and_1_2204", "Call signatures with no arguments have incompatible return types '{0}' and '{1}'.", void 0, true),
      Construct_signatures_with_no_arguments_have_incompatible_return_types_0_and_1: diag(2205, ts2.DiagnosticCategory.Error, "Construct_signatures_with_no_arguments_have_incompatible_return_types_0_and_1_2205", "Construct signatures with no arguments have incompatible return types '{0}' and '{1}'.", void 0, true),
      Duplicate_identifier_0: diag(2300, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_2300", "Duplicate identifier '{0}'."),
      Initializer_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor: diag(2301, ts2.DiagnosticCategory.Error, "Initializer_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor_2301", "Initializer of instance member variable '{0}' cannot reference identifier '{1}' declared in the constructor."),
      Static_members_cannot_reference_class_type_parameters: diag(2302, ts2.DiagnosticCategory.Error, "Static_members_cannot_reference_class_type_parameters_2302", "Static members cannot reference class type parameters."),
      Circular_definition_of_import_alias_0: diag(2303, ts2.DiagnosticCategory.Error, "Circular_definition_of_import_alias_0_2303", "Circular definition of import alias '{0}'."),
      Cannot_find_name_0: diag(2304, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_2304", "Cannot find name '{0}'."),
      Module_0_has_no_exported_member_1: diag(2305, ts2.DiagnosticCategory.Error, "Module_0_has_no_exported_member_1_2305", "Module '{0}' has no exported member '{1}'."),
      File_0_is_not_a_module: diag(2306, ts2.DiagnosticCategory.Error, "File_0_is_not_a_module_2306", "File '{0}' is not a module."),
      Cannot_find_module_0_or_its_corresponding_type_declarations: diag(2307, ts2.DiagnosticCategory.Error, "Cannot_find_module_0_or_its_corresponding_type_declarations_2307", "Cannot find module '{0}' or its corresponding type declarations."),
      Module_0_has_already_exported_a_member_named_1_Consider_explicitly_re_exporting_to_resolve_the_ambiguity: diag(2308, ts2.DiagnosticCategory.Error, "Module_0_has_already_exported_a_member_named_1_Consider_explicitly_re_exporting_to_resolve_the_ambig_2308", "Module {0} has already exported a member named '{1}'. Consider explicitly re-exporting to resolve the ambiguity."),
      An_export_assignment_cannot_be_used_in_a_module_with_other_exported_elements: diag(2309, ts2.DiagnosticCategory.Error, "An_export_assignment_cannot_be_used_in_a_module_with_other_exported_elements_2309", "An export assignment cannot be used in a module with other exported elements."),
      Type_0_recursively_references_itself_as_a_base_type: diag(2310, ts2.DiagnosticCategory.Error, "Type_0_recursively_references_itself_as_a_base_type_2310", "Type '{0}' recursively references itself as a base type."),
      A_class_may_only_extend_another_class: diag(2311, ts2.DiagnosticCategory.Error, "A_class_may_only_extend_another_class_2311", "A class may only extend another class."),
      An_interface_can_only_extend_an_object_type_or_intersection_of_object_types_with_statically_known_members: diag(2312, ts2.DiagnosticCategory.Error, "An_interface_can_only_extend_an_object_type_or_intersection_of_object_types_with_statically_known_me_2312", "An interface can only extend an object type or intersection of object types with statically known members."),
      Type_parameter_0_has_a_circular_constraint: diag(2313, ts2.DiagnosticCategory.Error, "Type_parameter_0_has_a_circular_constraint_2313", "Type parameter '{0}' has a circular constraint."),
      Generic_type_0_requires_1_type_argument_s: diag(2314, ts2.DiagnosticCategory.Error, "Generic_type_0_requires_1_type_argument_s_2314", "Generic type '{0}' requires {1} type argument(s)."),
      Type_0_is_not_generic: diag(2315, ts2.DiagnosticCategory.Error, "Type_0_is_not_generic_2315", "Type '{0}' is not generic."),
      Global_type_0_must_be_a_class_or_interface_type: diag(2316, ts2.DiagnosticCategory.Error, "Global_type_0_must_be_a_class_or_interface_type_2316", "Global type '{0}' must be a class or interface type."),
      Global_type_0_must_have_1_type_parameter_s: diag(2317, ts2.DiagnosticCategory.Error, "Global_type_0_must_have_1_type_parameter_s_2317", "Global type '{0}' must have {1} type parameter(s)."),
      Cannot_find_global_type_0: diag(2318, ts2.DiagnosticCategory.Error, "Cannot_find_global_type_0_2318", "Cannot find global type '{0}'."),
      Named_property_0_of_types_1_and_2_are_not_identical: diag(2319, ts2.DiagnosticCategory.Error, "Named_property_0_of_types_1_and_2_are_not_identical_2319", "Named property '{0}' of types '{1}' and '{2}' are not identical."),
      Interface_0_cannot_simultaneously_extend_types_1_and_2: diag(2320, ts2.DiagnosticCategory.Error, "Interface_0_cannot_simultaneously_extend_types_1_and_2_2320", "Interface '{0}' cannot simultaneously extend types '{1}' and '{2}'."),
      Excessive_stack_depth_comparing_types_0_and_1: diag(2321, ts2.DiagnosticCategory.Error, "Excessive_stack_depth_comparing_types_0_and_1_2321", "Excessive stack depth comparing types '{0}' and '{1}'."),
      Type_0_is_not_assignable_to_type_1: diag(2322, ts2.DiagnosticCategory.Error, "Type_0_is_not_assignable_to_type_1_2322", "Type '{0}' is not assignable to type '{1}'."),
      Cannot_redeclare_exported_variable_0: diag(2323, ts2.DiagnosticCategory.Error, "Cannot_redeclare_exported_variable_0_2323", "Cannot redeclare exported variable '{0}'."),
      Property_0_is_missing_in_type_1: diag(2324, ts2.DiagnosticCategory.Error, "Property_0_is_missing_in_type_1_2324", "Property '{0}' is missing in type '{1}'."),
      Property_0_is_private_in_type_1_but_not_in_type_2: diag(2325, ts2.DiagnosticCategory.Error, "Property_0_is_private_in_type_1_but_not_in_type_2_2325", "Property '{0}' is private in type '{1}' but not in type '{2}'."),
      Types_of_property_0_are_incompatible: diag(2326, ts2.DiagnosticCategory.Error, "Types_of_property_0_are_incompatible_2326", "Types of property '{0}' are incompatible."),
      Property_0_is_optional_in_type_1_but_required_in_type_2: diag(2327, ts2.DiagnosticCategory.Error, "Property_0_is_optional_in_type_1_but_required_in_type_2_2327", "Property '{0}' is optional in type '{1}' but required in type '{2}'."),
      Types_of_parameters_0_and_1_are_incompatible: diag(2328, ts2.DiagnosticCategory.Error, "Types_of_parameters_0_and_1_are_incompatible_2328", "Types of parameters '{0}' and '{1}' are incompatible."),
      Index_signature_for_type_0_is_missing_in_type_1: diag(2329, ts2.DiagnosticCategory.Error, "Index_signature_for_type_0_is_missing_in_type_1_2329", "Index signature for type '{0}' is missing in type '{1}'."),
      _0_and_1_index_signatures_are_incompatible: diag(2330, ts2.DiagnosticCategory.Error, "_0_and_1_index_signatures_are_incompatible_2330", "'{0}' and '{1}' index signatures are incompatible."),
      this_cannot_be_referenced_in_a_module_or_namespace_body: diag(2331, ts2.DiagnosticCategory.Error, "this_cannot_be_referenced_in_a_module_or_namespace_body_2331", "'this' cannot be referenced in a module or namespace body."),
      this_cannot_be_referenced_in_current_location: diag(2332, ts2.DiagnosticCategory.Error, "this_cannot_be_referenced_in_current_location_2332", "'this' cannot be referenced in current location."),
      this_cannot_be_referenced_in_constructor_arguments: diag(2333, ts2.DiagnosticCategory.Error, "this_cannot_be_referenced_in_constructor_arguments_2333", "'this' cannot be referenced in constructor arguments."),
      this_cannot_be_referenced_in_a_static_property_initializer: diag(2334, ts2.DiagnosticCategory.Error, "this_cannot_be_referenced_in_a_static_property_initializer_2334", "'this' cannot be referenced in a static property initializer."),
      super_can_only_be_referenced_in_a_derived_class: diag(2335, ts2.DiagnosticCategory.Error, "super_can_only_be_referenced_in_a_derived_class_2335", "'super' can only be referenced in a derived class."),
      super_cannot_be_referenced_in_constructor_arguments: diag(2336, ts2.DiagnosticCategory.Error, "super_cannot_be_referenced_in_constructor_arguments_2336", "'super' cannot be referenced in constructor arguments."),
      Super_calls_are_not_permitted_outside_constructors_or_in_nested_functions_inside_constructors: diag(2337, ts2.DiagnosticCategory.Error, "Super_calls_are_not_permitted_outside_constructors_or_in_nested_functions_inside_constructors_2337", "Super calls are not permitted outside constructors or in nested functions inside constructors."),
      super_property_access_is_permitted_only_in_a_constructor_member_function_or_member_accessor_of_a_derived_class: diag(2338, ts2.DiagnosticCategory.Error, "super_property_access_is_permitted_only_in_a_constructor_member_function_or_member_accessor_of_a_der_2338", "'super' property access is permitted only in a constructor, member function, or member accessor of a derived class."),
      Property_0_does_not_exist_on_type_1: diag(2339, ts2.DiagnosticCategory.Error, "Property_0_does_not_exist_on_type_1_2339", "Property '{0}' does not exist on type '{1}'."),
      Only_public_and_protected_methods_of_the_base_class_are_accessible_via_the_super_keyword: diag(2340, ts2.DiagnosticCategory.Error, "Only_public_and_protected_methods_of_the_base_class_are_accessible_via_the_super_keyword_2340", "Only public and protected methods of the base class are accessible via the 'super' keyword."),
      Property_0_is_private_and_only_accessible_within_class_1: diag(2341, ts2.DiagnosticCategory.Error, "Property_0_is_private_and_only_accessible_within_class_1_2341", "Property '{0}' is private and only accessible within class '{1}'."),
      An_index_expression_argument_must_be_of_type_string_number_symbol_or_any: diag(2342, ts2.DiagnosticCategory.Error, "An_index_expression_argument_must_be_of_type_string_number_symbol_or_any_2342", "An index expression argument must be of type 'string', 'number', 'symbol', or 'any'."),
      This_syntax_requires_an_imported_helper_named_1_which_does_not_exist_in_0_Consider_upgrading_your_version_of_0: diag(2343, ts2.DiagnosticCategory.Error, "This_syntax_requires_an_imported_helper_named_1_which_does_not_exist_in_0_Consider_upgrading_your_ve_2343", "This syntax requires an imported helper named '{1}' which does not exist in '{0}'. Consider upgrading your version of '{0}'."),
      Type_0_does_not_satisfy_the_constraint_1: diag(2344, ts2.DiagnosticCategory.Error, "Type_0_does_not_satisfy_the_constraint_1_2344", "Type '{0}' does not satisfy the constraint '{1}'."),
      Argument_of_type_0_is_not_assignable_to_parameter_of_type_1: diag(2345, ts2.DiagnosticCategory.Error, "Argument_of_type_0_is_not_assignable_to_parameter_of_type_1_2345", "Argument of type '{0}' is not assignable to parameter of type '{1}'."),
      Call_target_does_not_contain_any_signatures: diag(2346, ts2.DiagnosticCategory.Error, "Call_target_does_not_contain_any_signatures_2346", "Call target does not contain any signatures."),
      Untyped_function_calls_may_not_accept_type_arguments: diag(2347, ts2.DiagnosticCategory.Error, "Untyped_function_calls_may_not_accept_type_arguments_2347", "Untyped function calls may not accept type arguments."),
      Value_of_type_0_is_not_callable_Did_you_mean_to_include_new: diag(2348, ts2.DiagnosticCategory.Error, "Value_of_type_0_is_not_callable_Did_you_mean_to_include_new_2348", "Value of type '{0}' is not callable. Did you mean to include 'new'?"),
      This_expression_is_not_callable: diag(2349, ts2.DiagnosticCategory.Error, "This_expression_is_not_callable_2349", "This expression is not callable."),
      Only_a_void_function_can_be_called_with_the_new_keyword: diag(2350, ts2.DiagnosticCategory.Error, "Only_a_void_function_can_be_called_with_the_new_keyword_2350", "Only a void function can be called with the 'new' keyword."),
      This_expression_is_not_constructable: diag(2351, ts2.DiagnosticCategory.Error, "This_expression_is_not_constructable_2351", "This expression is not constructable."),
      Conversion_of_type_0_to_type_1_may_be_a_mistake_because_neither_type_sufficiently_overlaps_with_the_other_If_this_was_intentional_convert_the_expression_to_unknown_first: diag(2352, ts2.DiagnosticCategory.Error, "Conversion_of_type_0_to_type_1_may_be_a_mistake_because_neither_type_sufficiently_overlaps_with_the__2352", "Conversion of type '{0}' to type '{1}' may be a mistake because neither type sufficiently overlaps with the other. If this was intentional, convert the expression to 'unknown' first."),
      Object_literal_may_only_specify_known_properties_and_0_does_not_exist_in_type_1: diag(2353, ts2.DiagnosticCategory.Error, "Object_literal_may_only_specify_known_properties_and_0_does_not_exist_in_type_1_2353", "Object literal may only specify known properties, and '{0}' does not exist in type '{1}'."),
      This_syntax_requires_an_imported_helper_but_module_0_cannot_be_found: diag(2354, ts2.DiagnosticCategory.Error, "This_syntax_requires_an_imported_helper_but_module_0_cannot_be_found_2354", "This syntax requires an imported helper but module '{0}' cannot be found."),
      A_function_whose_declared_type_is_neither_void_nor_any_must_return_a_value: diag(2355, ts2.DiagnosticCategory.Error, "A_function_whose_declared_type_is_neither_void_nor_any_must_return_a_value_2355", "A function whose declared type is neither 'void' nor 'any' must return a value."),
      An_arithmetic_operand_must_be_of_type_any_number_bigint_or_an_enum_type: diag(2356, ts2.DiagnosticCategory.Error, "An_arithmetic_operand_must_be_of_type_any_number_bigint_or_an_enum_type_2356", "An arithmetic operand must be of type 'any', 'number', 'bigint' or an enum type."),
      The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_or_a_property_access: diag(2357, ts2.DiagnosticCategory.Error, "The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_or_a_property_access_2357", "The operand of an increment or decrement operator must be a variable or a property access."),
      The_left_hand_side_of_an_instanceof_expression_must_be_of_type_any_an_object_type_or_a_type_parameter: diag(2358, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_an_instanceof_expression_must_be_of_type_any_an_object_type_or_a_type_paramete_2358", "The left-hand side of an 'instanceof' expression must be of type 'any', an object type or a type parameter."),
      The_right_hand_side_of_an_instanceof_expression_must_be_of_type_any_or_of_a_type_assignable_to_the_Function_interface_type: diag(2359, ts2.DiagnosticCategory.Error, "The_right_hand_side_of_an_instanceof_expression_must_be_of_type_any_or_of_a_type_assignable_to_the_F_2359", "The right-hand side of an 'instanceof' expression must be of type 'any' or of a type assignable to the 'Function' interface type."),
      The_left_hand_side_of_an_in_expression_must_be_of_type_any_string_number_or_symbol: diag(2360, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_an_in_expression_must_be_of_type_any_string_number_or_symbol_2360", "The left-hand side of an 'in' expression must be of type 'any', 'string', 'number', or 'symbol'."),
      The_right_hand_side_of_an_in_expression_must_not_be_a_primitive: diag(2361, ts2.DiagnosticCategory.Error, "The_right_hand_side_of_an_in_expression_must_not_be_a_primitive_2361", "The right-hand side of an 'in' expression must not be a primitive."),
      The_left_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type: diag(2362, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type_2362", "The left-hand side of an arithmetic operation must be of type 'any', 'number', 'bigint' or an enum type."),
      The_right_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type: diag(2363, ts2.DiagnosticCategory.Error, "The_right_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type_2363", "The right-hand side of an arithmetic operation must be of type 'any', 'number', 'bigint' or an enum type."),
      The_left_hand_side_of_an_assignment_expression_must_be_a_variable_or_a_property_access: diag(2364, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_an_assignment_expression_must_be_a_variable_or_a_property_access_2364", "The left-hand side of an assignment expression must be a variable or a property access."),
      Operator_0_cannot_be_applied_to_types_1_and_2: diag(2365, ts2.DiagnosticCategory.Error, "Operator_0_cannot_be_applied_to_types_1_and_2_2365", "Operator '{0}' cannot be applied to types '{1}' and '{2}'."),
      Function_lacks_ending_return_statement_and_return_type_does_not_include_undefined: diag(2366, ts2.DiagnosticCategory.Error, "Function_lacks_ending_return_statement_and_return_type_does_not_include_undefined_2366", "Function lacks ending return statement and return type does not include 'undefined'."),
      This_condition_will_always_return_0_since_the_types_1_and_2_have_no_overlap: diag(2367, ts2.DiagnosticCategory.Error, "This_condition_will_always_return_0_since_the_types_1_and_2_have_no_overlap_2367", "This condition will always return '{0}' since the types '{1}' and '{2}' have no overlap."),
      Type_parameter_name_cannot_be_0: diag(2368, ts2.DiagnosticCategory.Error, "Type_parameter_name_cannot_be_0_2368", "Type parameter name cannot be '{0}'."),
      A_parameter_property_is_only_allowed_in_a_constructor_implementation: diag(2369, ts2.DiagnosticCategory.Error, "A_parameter_property_is_only_allowed_in_a_constructor_implementation_2369", "A parameter property is only allowed in a constructor implementation."),
      A_rest_parameter_must_be_of_an_array_type: diag(2370, ts2.DiagnosticCategory.Error, "A_rest_parameter_must_be_of_an_array_type_2370", "A rest parameter must be of an array type."),
      A_parameter_initializer_is_only_allowed_in_a_function_or_constructor_implementation: diag(2371, ts2.DiagnosticCategory.Error, "A_parameter_initializer_is_only_allowed_in_a_function_or_constructor_implementation_2371", "A parameter initializer is only allowed in a function or constructor implementation."),
      Parameter_0_cannot_reference_itself: diag(2372, ts2.DiagnosticCategory.Error, "Parameter_0_cannot_reference_itself_2372", "Parameter '{0}' cannot reference itself."),
      Parameter_0_cannot_reference_identifier_1_declared_after_it: diag(2373, ts2.DiagnosticCategory.Error, "Parameter_0_cannot_reference_identifier_1_declared_after_it_2373", "Parameter '{0}' cannot reference identifier '{1}' declared after it."),
      Duplicate_index_signature_for_type_0: diag(2374, ts2.DiagnosticCategory.Error, "Duplicate_index_signature_for_type_0_2374", "Duplicate index signature for type '{0}'."),
      A_super_call_must_be_the_first_statement_in_the_constructor_when_a_class_contains_initialized_properties_parameter_properties_or_private_identifiers: diag(2376, ts2.DiagnosticCategory.Error, "A_super_call_must_be_the_first_statement_in_the_constructor_when_a_class_contains_initialized_proper_2376", "A 'super' call must be the first statement in the constructor when a class contains initialized properties, parameter properties, or private identifiers."),
      Constructors_for_derived_classes_must_contain_a_super_call: diag(2377, ts2.DiagnosticCategory.Error, "Constructors_for_derived_classes_must_contain_a_super_call_2377", "Constructors for derived classes must contain a 'super' call."),
      A_get_accessor_must_return_a_value: diag(2378, ts2.DiagnosticCategory.Error, "A_get_accessor_must_return_a_value_2378", "A 'get' accessor must return a value."),
      The_return_type_of_a_get_accessor_must_be_assignable_to_its_set_accessor_type: diag(2380, ts2.DiagnosticCategory.Error, "The_return_type_of_a_get_accessor_must_be_assignable_to_its_set_accessor_type_2380", "The return type of a 'get' accessor must be assignable to its 'set' accessor type"),
      A_signature_with_an_implementation_cannot_use_a_string_literal_type: diag(2381, ts2.DiagnosticCategory.Error, "A_signature_with_an_implementation_cannot_use_a_string_literal_type_2381", "A signature with an implementation cannot use a string literal type."),
      Specialized_overload_signature_is_not_assignable_to_any_non_specialized_signature: diag(2382, ts2.DiagnosticCategory.Error, "Specialized_overload_signature_is_not_assignable_to_any_non_specialized_signature_2382", "Specialized overload signature is not assignable to any non-specialized signature."),
      Overload_signatures_must_all_be_exported_or_non_exported: diag(2383, ts2.DiagnosticCategory.Error, "Overload_signatures_must_all_be_exported_or_non_exported_2383", "Overload signatures must all be exported or non-exported."),
      Overload_signatures_must_all_be_ambient_or_non_ambient: diag(2384, ts2.DiagnosticCategory.Error, "Overload_signatures_must_all_be_ambient_or_non_ambient_2384", "Overload signatures must all be ambient or non-ambient."),
      Overload_signatures_must_all_be_public_private_or_protected: diag(2385, ts2.DiagnosticCategory.Error, "Overload_signatures_must_all_be_public_private_or_protected_2385", "Overload signatures must all be public, private or protected."),
      Overload_signatures_must_all_be_optional_or_required: diag(2386, ts2.DiagnosticCategory.Error, "Overload_signatures_must_all_be_optional_or_required_2386", "Overload signatures must all be optional or required."),
      Function_overload_must_be_static: diag(2387, ts2.DiagnosticCategory.Error, "Function_overload_must_be_static_2387", "Function overload must be static."),
      Function_overload_must_not_be_static: diag(2388, ts2.DiagnosticCategory.Error, "Function_overload_must_not_be_static_2388", "Function overload must not be static."),
      Function_implementation_name_must_be_0: diag(2389, ts2.DiagnosticCategory.Error, "Function_implementation_name_must_be_0_2389", "Function implementation name must be '{0}'."),
      Constructor_implementation_is_missing: diag(2390, ts2.DiagnosticCategory.Error, "Constructor_implementation_is_missing_2390", "Constructor implementation is missing."),
      Function_implementation_is_missing_or_not_immediately_following_the_declaration: diag(2391, ts2.DiagnosticCategory.Error, "Function_implementation_is_missing_or_not_immediately_following_the_declaration_2391", "Function implementation is missing or not immediately following the declaration."),
      Multiple_constructor_implementations_are_not_allowed: diag(2392, ts2.DiagnosticCategory.Error, "Multiple_constructor_implementations_are_not_allowed_2392", "Multiple constructor implementations are not allowed."),
      Duplicate_function_implementation: diag(2393, ts2.DiagnosticCategory.Error, "Duplicate_function_implementation_2393", "Duplicate function implementation."),
      This_overload_signature_is_not_compatible_with_its_implementation_signature: diag(2394, ts2.DiagnosticCategory.Error, "This_overload_signature_is_not_compatible_with_its_implementation_signature_2394", "This overload signature is not compatible with its implementation signature."),
      Individual_declarations_in_merged_declaration_0_must_be_all_exported_or_all_local: diag(2395, ts2.DiagnosticCategory.Error, "Individual_declarations_in_merged_declaration_0_must_be_all_exported_or_all_local_2395", "Individual declarations in merged declaration '{0}' must be all exported or all local."),
      Duplicate_identifier_arguments_Compiler_uses_arguments_to_initialize_rest_parameters: diag(2396, ts2.DiagnosticCategory.Error, "Duplicate_identifier_arguments_Compiler_uses_arguments_to_initialize_rest_parameters_2396", "Duplicate identifier 'arguments'. Compiler uses 'arguments' to initialize rest parameters."),
      Declaration_name_conflicts_with_built_in_global_identifier_0: diag(2397, ts2.DiagnosticCategory.Error, "Declaration_name_conflicts_with_built_in_global_identifier_0_2397", "Declaration name conflicts with built-in global identifier '{0}'."),
      constructor_cannot_be_used_as_a_parameter_property_name: diag(2398, ts2.DiagnosticCategory.Error, "constructor_cannot_be_used_as_a_parameter_property_name_2398", "'constructor' cannot be used as a parameter property name."),
      Duplicate_identifier_this_Compiler_uses_variable_declaration_this_to_capture_this_reference: diag(2399, ts2.DiagnosticCategory.Error, "Duplicate_identifier_this_Compiler_uses_variable_declaration_this_to_capture_this_reference_2399", "Duplicate identifier '_this'. Compiler uses variable declaration '_this' to capture 'this' reference."),
      Expression_resolves_to_variable_declaration_this_that_compiler_uses_to_capture_this_reference: diag(2400, ts2.DiagnosticCategory.Error, "Expression_resolves_to_variable_declaration_this_that_compiler_uses_to_capture_this_reference_2400", "Expression resolves to variable declaration '_this' that compiler uses to capture 'this' reference."),
      Duplicate_identifier_super_Compiler_uses_super_to_capture_base_class_reference: diag(2401, ts2.DiagnosticCategory.Error, "Duplicate_identifier_super_Compiler_uses_super_to_capture_base_class_reference_2401", "Duplicate identifier '_super'. Compiler uses '_super' to capture base class reference."),
      Expression_resolves_to_super_that_compiler_uses_to_capture_base_class_reference: diag(2402, ts2.DiagnosticCategory.Error, "Expression_resolves_to_super_that_compiler_uses_to_capture_base_class_reference_2402", "Expression resolves to '_super' that compiler uses to capture base class reference."),
      Subsequent_variable_declarations_must_have_the_same_type_Variable_0_must_be_of_type_1_but_here_has_type_2: diag(2403, ts2.DiagnosticCategory.Error, "Subsequent_variable_declarations_must_have_the_same_type_Variable_0_must_be_of_type_1_but_here_has_t_2403", "Subsequent variable declarations must have the same type.  Variable '{0}' must be of type '{1}', but here has type '{2}'."),
      The_left_hand_side_of_a_for_in_statement_cannot_use_a_type_annotation: diag(2404, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_cannot_use_a_type_annotation_2404", "The left-hand side of a 'for...in' statement cannot use a type annotation."),
      The_left_hand_side_of_a_for_in_statement_must_be_of_type_string_or_any: diag(2405, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_must_be_of_type_string_or_any_2405", "The left-hand side of a 'for...in' statement must be of type 'string' or 'any'."),
      The_left_hand_side_of_a_for_in_statement_must_be_a_variable_or_a_property_access: diag(2406, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_must_be_a_variable_or_a_property_access_2406", "The left-hand side of a 'for...in' statement must be a variable or a property access."),
      The_right_hand_side_of_a_for_in_statement_must_be_of_type_any_an_object_type_or_a_type_parameter_but_here_has_type_0: diag(2407, ts2.DiagnosticCategory.Error, "The_right_hand_side_of_a_for_in_statement_must_be_of_type_any_an_object_type_or_a_type_parameter_but_2407", "The right-hand side of a 'for...in' statement must be of type 'any', an object type or a type parameter, but here has type '{0}'."),
      Setters_cannot_return_a_value: diag(2408, ts2.DiagnosticCategory.Error, "Setters_cannot_return_a_value_2408", "Setters cannot return a value."),
      Return_type_of_constructor_signature_must_be_assignable_to_the_instance_type_of_the_class: diag(2409, ts2.DiagnosticCategory.Error, "Return_type_of_constructor_signature_must_be_assignable_to_the_instance_type_of_the_class_2409", "Return type of constructor signature must be assignable to the instance type of the class."),
      The_with_statement_is_not_supported_All_symbols_in_a_with_block_will_have_type_any: diag(2410, ts2.DiagnosticCategory.Error, "The_with_statement_is_not_supported_All_symbols_in_a_with_block_will_have_type_any_2410", "The 'with' statement is not supported. All symbols in a 'with' block will have type 'any'."),
      Property_0_of_type_1_is_not_assignable_to_2_index_type_3: diag(2411, ts2.DiagnosticCategory.Error, "Property_0_of_type_1_is_not_assignable_to_2_index_type_3_2411", "Property '{0}' of type '{1}' is not assignable to '{2}' index type '{3}'."),
      _0_index_type_1_is_not_assignable_to_2_index_type_3: diag(2413, ts2.DiagnosticCategory.Error, "_0_index_type_1_is_not_assignable_to_2_index_type_3_2413", "'{0}' index type '{1}' is not assignable to '{2}' index type '{3}'."),
      Class_name_cannot_be_0: diag(2414, ts2.DiagnosticCategory.Error, "Class_name_cannot_be_0_2414", "Class name cannot be '{0}'."),
      Class_0_incorrectly_extends_base_class_1: diag(2415, ts2.DiagnosticCategory.Error, "Class_0_incorrectly_extends_base_class_1_2415", "Class '{0}' incorrectly extends base class '{1}'."),
      Property_0_in_type_1_is_not_assignable_to_the_same_property_in_base_type_2: diag(2416, ts2.DiagnosticCategory.Error, "Property_0_in_type_1_is_not_assignable_to_the_same_property_in_base_type_2_2416", "Property '{0}' in type '{1}' is not assignable to the same property in base type '{2}'."),
      Class_static_side_0_incorrectly_extends_base_class_static_side_1: diag(2417, ts2.DiagnosticCategory.Error, "Class_static_side_0_incorrectly_extends_base_class_static_side_1_2417", "Class static side '{0}' incorrectly extends base class static side '{1}'."),
      Type_of_computed_property_s_value_is_0_which_is_not_assignable_to_type_1: diag(2418, ts2.DiagnosticCategory.Error, "Type_of_computed_property_s_value_is_0_which_is_not_assignable_to_type_1_2418", "Type of computed property's value is '{0}', which is not assignable to type '{1}'."),
      Types_of_construct_signatures_are_incompatible: diag(2419, ts2.DiagnosticCategory.Error, "Types_of_construct_signatures_are_incompatible_2419", "Types of construct signatures are incompatible."),
      Class_0_incorrectly_implements_interface_1: diag(2420, ts2.DiagnosticCategory.Error, "Class_0_incorrectly_implements_interface_1_2420", "Class '{0}' incorrectly implements interface '{1}'."),
      A_class_can_only_implement_an_object_type_or_intersection_of_object_types_with_statically_known_members: diag(2422, ts2.DiagnosticCategory.Error, "A_class_can_only_implement_an_object_type_or_intersection_of_object_types_with_statically_known_memb_2422", "A class can only implement an object type or intersection of object types with statically known members."),
      Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_accessor: diag(2423, ts2.DiagnosticCategory.Error, "Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_access_2423", "Class '{0}' defines instance member function '{1}', but extended class '{2}' defines it as instance member accessor."),
      Class_0_defines_instance_member_property_1_but_extended_class_2_defines_it_as_instance_member_function: diag(2425, ts2.DiagnosticCategory.Error, "Class_0_defines_instance_member_property_1_but_extended_class_2_defines_it_as_instance_member_functi_2425", "Class '{0}' defines instance member property '{1}', but extended class '{2}' defines it as instance member function."),
      Class_0_defines_instance_member_accessor_1_but_extended_class_2_defines_it_as_instance_member_function: diag(2426, ts2.DiagnosticCategory.Error, "Class_0_defines_instance_member_accessor_1_but_extended_class_2_defines_it_as_instance_member_functi_2426", "Class '{0}' defines instance member accessor '{1}', but extended class '{2}' defines it as instance member function."),
      Interface_name_cannot_be_0: diag(2427, ts2.DiagnosticCategory.Error, "Interface_name_cannot_be_0_2427", "Interface name cannot be '{0}'."),
      All_declarations_of_0_must_have_identical_type_parameters: diag(2428, ts2.DiagnosticCategory.Error, "All_declarations_of_0_must_have_identical_type_parameters_2428", "All declarations of '{0}' must have identical type parameters."),
      Interface_0_incorrectly_extends_interface_1: diag(2430, ts2.DiagnosticCategory.Error, "Interface_0_incorrectly_extends_interface_1_2430", "Interface '{0}' incorrectly extends interface '{1}'."),
      Enum_name_cannot_be_0: diag(2431, ts2.DiagnosticCategory.Error, "Enum_name_cannot_be_0_2431", "Enum name cannot be '{0}'."),
      In_an_enum_with_multiple_declarations_only_one_declaration_can_omit_an_initializer_for_its_first_enum_element: diag(2432, ts2.DiagnosticCategory.Error, "In_an_enum_with_multiple_declarations_only_one_declaration_can_omit_an_initializer_for_its_first_enu_2432", "In an enum with multiple declarations, only one declaration can omit an initializer for its first enum element."),
      A_namespace_declaration_cannot_be_in_a_different_file_from_a_class_or_function_with_which_it_is_merged: diag(2433, ts2.DiagnosticCategory.Error, "A_namespace_declaration_cannot_be_in_a_different_file_from_a_class_or_function_with_which_it_is_merg_2433", "A namespace declaration cannot be in a different file from a class or function with which it is merged."),
      A_namespace_declaration_cannot_be_located_prior_to_a_class_or_function_with_which_it_is_merged: diag(2434, ts2.DiagnosticCategory.Error, "A_namespace_declaration_cannot_be_located_prior_to_a_class_or_function_with_which_it_is_merged_2434", "A namespace declaration cannot be located prior to a class or function with which it is merged."),
      Ambient_modules_cannot_be_nested_in_other_modules_or_namespaces: diag(2435, ts2.DiagnosticCategory.Error, "Ambient_modules_cannot_be_nested_in_other_modules_or_namespaces_2435", "Ambient modules cannot be nested in other modules or namespaces."),
      Ambient_module_declaration_cannot_specify_relative_module_name: diag(2436, ts2.DiagnosticCategory.Error, "Ambient_module_declaration_cannot_specify_relative_module_name_2436", "Ambient module declaration cannot specify relative module name."),
      Module_0_is_hidden_by_a_local_declaration_with_the_same_name: diag(2437, ts2.DiagnosticCategory.Error, "Module_0_is_hidden_by_a_local_declaration_with_the_same_name_2437", "Module '{0}' is hidden by a local declaration with the same name."),
      Import_name_cannot_be_0: diag(2438, ts2.DiagnosticCategory.Error, "Import_name_cannot_be_0_2438", "Import name cannot be '{0}'."),
      Import_or_export_declaration_in_an_ambient_module_declaration_cannot_reference_module_through_relative_module_name: diag(2439, ts2.DiagnosticCategory.Error, "Import_or_export_declaration_in_an_ambient_module_declaration_cannot_reference_module_through_relati_2439", "Import or export declaration in an ambient module declaration cannot reference module through relative module name."),
      Import_declaration_conflicts_with_local_declaration_of_0: diag(2440, ts2.DiagnosticCategory.Error, "Import_declaration_conflicts_with_local_declaration_of_0_2440", "Import declaration conflicts with local declaration of '{0}'."),
      Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module: diag(2441, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_2441", "Duplicate identifier '{0}'. Compiler reserves name '{1}' in top level scope of a module."),
      Types_have_separate_declarations_of_a_private_property_0: diag(2442, ts2.DiagnosticCategory.Error, "Types_have_separate_declarations_of_a_private_property_0_2442", "Types have separate declarations of a private property '{0}'."),
      Property_0_is_protected_but_type_1_is_not_a_class_derived_from_2: diag(2443, ts2.DiagnosticCategory.Error, "Property_0_is_protected_but_type_1_is_not_a_class_derived_from_2_2443", "Property '{0}' is protected but type '{1}' is not a class derived from '{2}'."),
      Property_0_is_protected_in_type_1_but_public_in_type_2: diag(2444, ts2.DiagnosticCategory.Error, "Property_0_is_protected_in_type_1_but_public_in_type_2_2444", "Property '{0}' is protected in type '{1}' but public in type '{2}'."),
      Property_0_is_protected_and_only_accessible_within_class_1_and_its_subclasses: diag(2445, ts2.DiagnosticCategory.Error, "Property_0_is_protected_and_only_accessible_within_class_1_and_its_subclasses_2445", "Property '{0}' is protected and only accessible within class '{1}' and its subclasses."),
      Property_0_is_protected_and_only_accessible_through_an_instance_of_class_1_This_is_an_instance_of_class_2: diag(2446, ts2.DiagnosticCategory.Error, "Property_0_is_protected_and_only_accessible_through_an_instance_of_class_1_This_is_an_instance_of_cl_2446", "Property '{0}' is protected and only accessible through an instance of class '{1}'. This is an instance of class '{2}'."),
      The_0_operator_is_not_allowed_for_boolean_types_Consider_using_1_instead: diag(2447, ts2.DiagnosticCategory.Error, "The_0_operator_is_not_allowed_for_boolean_types_Consider_using_1_instead_2447", "The '{0}' operator is not allowed for boolean types. Consider using '{1}' instead."),
      Block_scoped_variable_0_used_before_its_declaration: diag(2448, ts2.DiagnosticCategory.Error, "Block_scoped_variable_0_used_before_its_declaration_2448", "Block-scoped variable '{0}' used before its declaration."),
      Class_0_used_before_its_declaration: diag(2449, ts2.DiagnosticCategory.Error, "Class_0_used_before_its_declaration_2449", "Class '{0}' used before its declaration."),
      Enum_0_used_before_its_declaration: diag(2450, ts2.DiagnosticCategory.Error, "Enum_0_used_before_its_declaration_2450", "Enum '{0}' used before its declaration."),
      Cannot_redeclare_block_scoped_variable_0: diag(2451, ts2.DiagnosticCategory.Error, "Cannot_redeclare_block_scoped_variable_0_2451", "Cannot redeclare block-scoped variable '{0}'."),
      An_enum_member_cannot_have_a_numeric_name: diag(2452, ts2.DiagnosticCategory.Error, "An_enum_member_cannot_have_a_numeric_name_2452", "An enum member cannot have a numeric name."),
      The_type_argument_for_type_parameter_0_cannot_be_inferred_from_the_usage_Consider_specifying_the_type_arguments_explicitly: diag(2453, ts2.DiagnosticCategory.Error, "The_type_argument_for_type_parameter_0_cannot_be_inferred_from_the_usage_Consider_specifying_the_typ_2453", "The type argument for type parameter '{0}' cannot be inferred from the usage. Consider specifying the type arguments explicitly."),
      Variable_0_is_used_before_being_assigned: diag(2454, ts2.DiagnosticCategory.Error, "Variable_0_is_used_before_being_assigned_2454", "Variable '{0}' is used before being assigned."),
      Type_argument_candidate_1_is_not_a_valid_type_argument_because_it_is_not_a_supertype_of_candidate_0: diag(2455, ts2.DiagnosticCategory.Error, "Type_argument_candidate_1_is_not_a_valid_type_argument_because_it_is_not_a_supertype_of_candidate_0_2455", "Type argument candidate '{1}' is not a valid type argument because it is not a supertype of candidate '{0}'."),
      Type_alias_0_circularly_references_itself: diag(2456, ts2.DiagnosticCategory.Error, "Type_alias_0_circularly_references_itself_2456", "Type alias '{0}' circularly references itself."),
      Type_alias_name_cannot_be_0: diag(2457, ts2.DiagnosticCategory.Error, "Type_alias_name_cannot_be_0_2457", "Type alias name cannot be '{0}'."),
      An_AMD_module_cannot_have_multiple_name_assignments: diag(2458, ts2.DiagnosticCategory.Error, "An_AMD_module_cannot_have_multiple_name_assignments_2458", "An AMD module cannot have multiple name assignments."),
      Module_0_declares_1_locally_but_it_is_not_exported: diag(2459, ts2.DiagnosticCategory.Error, "Module_0_declares_1_locally_but_it_is_not_exported_2459", "Module '{0}' declares '{1}' locally, but it is not exported."),
      Module_0_declares_1_locally_but_it_is_exported_as_2: diag(2460, ts2.DiagnosticCategory.Error, "Module_0_declares_1_locally_but_it_is_exported_as_2_2460", "Module '{0}' declares '{1}' locally, but it is exported as '{2}'."),
      Type_0_is_not_an_array_type: diag(2461, ts2.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_2461", "Type '{0}' is not an array type."),
      A_rest_element_must_be_last_in_a_destructuring_pattern: diag(2462, ts2.DiagnosticCategory.Error, "A_rest_element_must_be_last_in_a_destructuring_pattern_2462", "A rest element must be last in a destructuring pattern."),
      A_binding_pattern_parameter_cannot_be_optional_in_an_implementation_signature: diag(2463, ts2.DiagnosticCategory.Error, "A_binding_pattern_parameter_cannot_be_optional_in_an_implementation_signature_2463", "A binding pattern parameter cannot be optional in an implementation signature."),
      A_computed_property_name_must_be_of_type_string_number_symbol_or_any: diag(2464, ts2.DiagnosticCategory.Error, "A_computed_property_name_must_be_of_type_string_number_symbol_or_any_2464", "A computed property name must be of type 'string', 'number', 'symbol', or 'any'."),
      this_cannot_be_referenced_in_a_computed_property_name: diag(2465, ts2.DiagnosticCategory.Error, "this_cannot_be_referenced_in_a_computed_property_name_2465", "'this' cannot be referenced in a computed property name."),
      super_cannot_be_referenced_in_a_computed_property_name: diag(2466, ts2.DiagnosticCategory.Error, "super_cannot_be_referenced_in_a_computed_property_name_2466", "'super' cannot be referenced in a computed property name."),
      A_computed_property_name_cannot_reference_a_type_parameter_from_its_containing_type: diag(2467, ts2.DiagnosticCategory.Error, "A_computed_property_name_cannot_reference_a_type_parameter_from_its_containing_type_2467", "A computed property name cannot reference a type parameter from its containing type."),
      Cannot_find_global_value_0: diag(2468, ts2.DiagnosticCategory.Error, "Cannot_find_global_value_0_2468", "Cannot find global value '{0}'."),
      The_0_operator_cannot_be_applied_to_type_symbol: diag(2469, ts2.DiagnosticCategory.Error, "The_0_operator_cannot_be_applied_to_type_symbol_2469", "The '{0}' operator cannot be applied to type 'symbol'."),
      Symbol_reference_does_not_refer_to_the_global_Symbol_constructor_object: diag(2470, ts2.DiagnosticCategory.Error, "Symbol_reference_does_not_refer_to_the_global_Symbol_constructor_object_2470", "'Symbol' reference does not refer to the global Symbol constructor object."),
      A_computed_property_name_of_the_form_0_must_be_of_type_symbol: diag(2471, ts2.DiagnosticCategory.Error, "A_computed_property_name_of_the_form_0_must_be_of_type_symbol_2471", "A computed property name of the form '{0}' must be of type 'symbol'."),
      Spread_operator_in_new_expressions_is_only_available_when_targeting_ECMAScript_5_and_higher: diag(2472, ts2.DiagnosticCategory.Error, "Spread_operator_in_new_expressions_is_only_available_when_targeting_ECMAScript_5_and_higher_2472", "Spread operator in 'new' expressions is only available when targeting ECMAScript 5 and higher."),
      Enum_declarations_must_all_be_const_or_non_const: diag(2473, ts2.DiagnosticCategory.Error, "Enum_declarations_must_all_be_const_or_non_const_2473", "Enum declarations must all be const or non-const."),
      const_enum_member_initializers_can_only_contain_literal_values_and_other_computed_enum_values: diag(2474, ts2.DiagnosticCategory.Error, "const_enum_member_initializers_can_only_contain_literal_values_and_other_computed_enum_values_2474", "const enum member initializers can only contain literal values and other computed enum values."),
      const_enums_can_only_be_used_in_property_or_index_access_expressions_or_the_right_hand_side_of_an_import_declaration_or_export_assignment_or_type_query: diag(2475, ts2.DiagnosticCategory.Error, "const_enums_can_only_be_used_in_property_or_index_access_expressions_or_the_right_hand_side_of_an_im_2475", "'const' enums can only be used in property or index access expressions or the right hand side of an import declaration or export assignment or type query."),
      A_const_enum_member_can_only_be_accessed_using_a_string_literal: diag(2476, ts2.DiagnosticCategory.Error, "A_const_enum_member_can_only_be_accessed_using_a_string_literal_2476", "A const enum member can only be accessed using a string literal."),
      const_enum_member_initializer_was_evaluated_to_a_non_finite_value: diag(2477, ts2.DiagnosticCategory.Error, "const_enum_member_initializer_was_evaluated_to_a_non_finite_value_2477", "'const' enum member initializer was evaluated to a non-finite value."),
      const_enum_member_initializer_was_evaluated_to_disallowed_value_NaN: diag(2478, ts2.DiagnosticCategory.Error, "const_enum_member_initializer_was_evaluated_to_disallowed_value_NaN_2478", "'const' enum member initializer was evaluated to disallowed value 'NaN'."),
      Property_0_does_not_exist_on_const_enum_1: diag(2479, ts2.DiagnosticCategory.Error, "Property_0_does_not_exist_on_const_enum_1_2479", "Property '{0}' does not exist on 'const' enum '{1}'."),
      let_is_not_allowed_to_be_used_as_a_name_in_let_or_const_declarations: diag(2480, ts2.DiagnosticCategory.Error, "let_is_not_allowed_to_be_used_as_a_name_in_let_or_const_declarations_2480", "'let' is not allowed to be used as a name in 'let' or 'const' declarations."),
      Cannot_initialize_outer_scoped_variable_0_in_the_same_scope_as_block_scoped_declaration_1: diag(2481, ts2.DiagnosticCategory.Error, "Cannot_initialize_outer_scoped_variable_0_in_the_same_scope_as_block_scoped_declaration_1_2481", "Cannot initialize outer scoped variable '{0}' in the same scope as block scoped declaration '{1}'."),
      The_left_hand_side_of_a_for_of_statement_cannot_use_a_type_annotation: diag(2483, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_of_statement_cannot_use_a_type_annotation_2483", "The left-hand side of a 'for...of' statement cannot use a type annotation."),
      Export_declaration_conflicts_with_exported_declaration_of_0: diag(2484, ts2.DiagnosticCategory.Error, "Export_declaration_conflicts_with_exported_declaration_of_0_2484", "Export declaration conflicts with exported declaration of '{0}'."),
      The_left_hand_side_of_a_for_of_statement_must_be_a_variable_or_a_property_access: diag(2487, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_of_statement_must_be_a_variable_or_a_property_access_2487", "The left-hand side of a 'for...of' statement must be a variable or a property access."),
      Type_0_must_have_a_Symbol_iterator_method_that_returns_an_iterator: diag(2488, ts2.DiagnosticCategory.Error, "Type_0_must_have_a_Symbol_iterator_method_that_returns_an_iterator_2488", "Type '{0}' must have a '[Symbol.iterator]()' method that returns an iterator."),
      An_iterator_must_have_a_next_method: diag(2489, ts2.DiagnosticCategory.Error, "An_iterator_must_have_a_next_method_2489", "An iterator must have a 'next()' method."),
      The_type_returned_by_the_0_method_of_an_iterator_must_have_a_value_property: diag(2490, ts2.DiagnosticCategory.Error, "The_type_returned_by_the_0_method_of_an_iterator_must_have_a_value_property_2490", "The type returned by the '{0}()' method of an iterator must have a 'value' property."),
      The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern: diag(2491, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern_2491", "The left-hand side of a 'for...in' statement cannot be a destructuring pattern."),
      Cannot_redeclare_identifier_0_in_catch_clause: diag(2492, ts2.DiagnosticCategory.Error, "Cannot_redeclare_identifier_0_in_catch_clause_2492", "Cannot redeclare identifier '{0}' in catch clause."),
      Tuple_type_0_of_length_1_has_no_element_at_index_2: diag(2493, ts2.DiagnosticCategory.Error, "Tuple_type_0_of_length_1_has_no_element_at_index_2_2493", "Tuple type '{0}' of length '{1}' has no element at index '{2}'."),
      Using_a_string_in_a_for_of_statement_is_only_supported_in_ECMAScript_5_and_higher: diag(2494, ts2.DiagnosticCategory.Error, "Using_a_string_in_a_for_of_statement_is_only_supported_in_ECMAScript_5_and_higher_2494", "Using a string in a 'for...of' statement is only supported in ECMAScript 5 and higher."),
      Type_0_is_not_an_array_type_or_a_string_type: diag(2495, ts2.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_or_a_string_type_2495", "Type '{0}' is not an array type or a string type."),
      The_arguments_object_cannot_be_referenced_in_an_arrow_function_in_ES3_and_ES5_Consider_using_a_standard_function_expression: diag(2496, ts2.DiagnosticCategory.Error, "The_arguments_object_cannot_be_referenced_in_an_arrow_function_in_ES3_and_ES5_Consider_using_a_stand_2496", "The 'arguments' object cannot be referenced in an arrow function in ES3 and ES5. Consider using a standard function expression."),
      This_module_can_only_be_referenced_with_ECMAScript_imports_Slashexports_by_turning_on_the_0_flag_and_referencing_its_default_export: diag(2497, ts2.DiagnosticCategory.Error, "This_module_can_only_be_referenced_with_ECMAScript_imports_Slashexports_by_turning_on_the_0_flag_and_2497", "This module can only be referenced with ECMAScript imports/exports by turning on the '{0}' flag and referencing its default export."),
      Module_0_uses_export_and_cannot_be_used_with_export_Asterisk: diag(2498, ts2.DiagnosticCategory.Error, "Module_0_uses_export_and_cannot_be_used_with_export_Asterisk_2498", "Module '{0}' uses 'export =' and cannot be used with 'export *'."),
      An_interface_can_only_extend_an_identifier_Slashqualified_name_with_optional_type_arguments: diag(2499, ts2.DiagnosticCategory.Error, "An_interface_can_only_extend_an_identifier_Slashqualified_name_with_optional_type_arguments_2499", "An interface can only extend an identifier/qualified-name with optional type arguments."),
      A_class_can_only_implement_an_identifier_Slashqualified_name_with_optional_type_arguments: diag(2500, ts2.DiagnosticCategory.Error, "A_class_can_only_implement_an_identifier_Slashqualified_name_with_optional_type_arguments_2500", "A class can only implement an identifier/qualified-name with optional type arguments."),
      A_rest_element_cannot_contain_a_binding_pattern: diag(2501, ts2.DiagnosticCategory.Error, "A_rest_element_cannot_contain_a_binding_pattern_2501", "A rest element cannot contain a binding pattern."),
      _0_is_referenced_directly_or_indirectly_in_its_own_type_annotation: diag(2502, ts2.DiagnosticCategory.Error, "_0_is_referenced_directly_or_indirectly_in_its_own_type_annotation_2502", "'{0}' is referenced directly or indirectly in its own type annotation."),
      Cannot_find_namespace_0: diag(2503, ts2.DiagnosticCategory.Error, "Cannot_find_namespace_0_2503", "Cannot find namespace '{0}'."),
      Type_0_must_have_a_Symbol_asyncIterator_method_that_returns_an_async_iterator: diag(2504, ts2.DiagnosticCategory.Error, "Type_0_must_have_a_Symbol_asyncIterator_method_that_returns_an_async_iterator_2504", "Type '{0}' must have a '[Symbol.asyncIterator]()' method that returns an async iterator."),
      A_generator_cannot_have_a_void_type_annotation: diag(2505, ts2.DiagnosticCategory.Error, "A_generator_cannot_have_a_void_type_annotation_2505", "A generator cannot have a 'void' type annotation."),
      _0_is_referenced_directly_or_indirectly_in_its_own_base_expression: diag(2506, ts2.DiagnosticCategory.Error, "_0_is_referenced_directly_or_indirectly_in_its_own_base_expression_2506", "'{0}' is referenced directly or indirectly in its own base expression."),
      Type_0_is_not_a_constructor_function_type: diag(2507, ts2.DiagnosticCategory.Error, "Type_0_is_not_a_constructor_function_type_2507", "Type '{0}' is not a constructor function type."),
      No_base_constructor_has_the_specified_number_of_type_arguments: diag(2508, ts2.DiagnosticCategory.Error, "No_base_constructor_has_the_specified_number_of_type_arguments_2508", "No base constructor has the specified number of type arguments."),
      Base_constructor_return_type_0_is_not_an_object_type_or_intersection_of_object_types_with_statically_known_members: diag(2509, ts2.DiagnosticCategory.Error, "Base_constructor_return_type_0_is_not_an_object_type_or_intersection_of_object_types_with_statically_2509", "Base constructor return type '{0}' is not an object type or intersection of object types with statically known members."),
      Base_constructors_must_all_have_the_same_return_type: diag(2510, ts2.DiagnosticCategory.Error, "Base_constructors_must_all_have_the_same_return_type_2510", "Base constructors must all have the same return type."),
      Cannot_create_an_instance_of_an_abstract_class: diag(2511, ts2.DiagnosticCategory.Error, "Cannot_create_an_instance_of_an_abstract_class_2511", "Cannot create an instance of an abstract class."),
      Overload_signatures_must_all_be_abstract_or_non_abstract: diag(2512, ts2.DiagnosticCategory.Error, "Overload_signatures_must_all_be_abstract_or_non_abstract_2512", "Overload signatures must all be abstract or non-abstract."),
      Abstract_method_0_in_class_1_cannot_be_accessed_via_super_expression: diag(2513, ts2.DiagnosticCategory.Error, "Abstract_method_0_in_class_1_cannot_be_accessed_via_super_expression_2513", "Abstract method '{0}' in class '{1}' cannot be accessed via super expression."),
      Classes_containing_abstract_methods_must_be_marked_abstract: diag(2514, ts2.DiagnosticCategory.Error, "Classes_containing_abstract_methods_must_be_marked_abstract_2514", "Classes containing abstract methods must be marked abstract."),
      Non_abstract_class_0_does_not_implement_inherited_abstract_member_1_from_class_2: diag(2515, ts2.DiagnosticCategory.Error, "Non_abstract_class_0_does_not_implement_inherited_abstract_member_1_from_class_2_2515", "Non-abstract class '{0}' does not implement inherited abstract member '{1}' from class '{2}'."),
      All_declarations_of_an_abstract_method_must_be_consecutive: diag(2516, ts2.DiagnosticCategory.Error, "All_declarations_of_an_abstract_method_must_be_consecutive_2516", "All declarations of an abstract method must be consecutive."),
      Cannot_assign_an_abstract_constructor_type_to_a_non_abstract_constructor_type: diag(2517, ts2.DiagnosticCategory.Error, "Cannot_assign_an_abstract_constructor_type_to_a_non_abstract_constructor_type_2517", "Cannot assign an abstract constructor type to a non-abstract constructor type."),
      A_this_based_type_guard_is_not_compatible_with_a_parameter_based_type_guard: diag(2518, ts2.DiagnosticCategory.Error, "A_this_based_type_guard_is_not_compatible_with_a_parameter_based_type_guard_2518", "A 'this'-based type guard is not compatible with a parameter-based type guard."),
      An_async_iterator_must_have_a_next_method: diag(2519, ts2.DiagnosticCategory.Error, "An_async_iterator_must_have_a_next_method_2519", "An async iterator must have a 'next()' method."),
      Duplicate_identifier_0_Compiler_uses_declaration_1_to_support_async_functions: diag(2520, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_Compiler_uses_declaration_1_to_support_async_functions_2520", "Duplicate identifier '{0}'. Compiler uses declaration '{1}' to support async functions."),
      Expression_resolves_to_variable_declaration_0_that_compiler_uses_to_support_async_functions: diag(2521, ts2.DiagnosticCategory.Error, "Expression_resolves_to_variable_declaration_0_that_compiler_uses_to_support_async_functions_2521", "Expression resolves to variable declaration '{0}' that compiler uses to support async functions."),
      The_arguments_object_cannot_be_referenced_in_an_async_function_or_method_in_ES3_and_ES5_Consider_using_a_standard_function_or_method: diag(2522, ts2.DiagnosticCategory.Error, "The_arguments_object_cannot_be_referenced_in_an_async_function_or_method_in_ES3_and_ES5_Consider_usi_2522", "The 'arguments' object cannot be referenced in an async function or method in ES3 and ES5. Consider using a standard function or method."),
      yield_expressions_cannot_be_used_in_a_parameter_initializer: diag(2523, ts2.DiagnosticCategory.Error, "yield_expressions_cannot_be_used_in_a_parameter_initializer_2523", "'yield' expressions cannot be used in a parameter initializer."),
      await_expressions_cannot_be_used_in_a_parameter_initializer: diag(2524, ts2.DiagnosticCategory.Error, "await_expressions_cannot_be_used_in_a_parameter_initializer_2524", "'await' expressions cannot be used in a parameter initializer."),
      Initializer_provides_no_value_for_this_binding_element_and_the_binding_element_has_no_default_value: diag(2525, ts2.DiagnosticCategory.Error, "Initializer_provides_no_value_for_this_binding_element_and_the_binding_element_has_no_default_value_2525", "Initializer provides no value for this binding element and the binding element has no default value."),
      A_this_type_is_available_only_in_a_non_static_member_of_a_class_or_interface: diag(2526, ts2.DiagnosticCategory.Error, "A_this_type_is_available_only_in_a_non_static_member_of_a_class_or_interface_2526", "A 'this' type is available only in a non-static member of a class or interface."),
      The_inferred_type_of_0_references_an_inaccessible_1_type_A_type_annotation_is_necessary: diag(2527, ts2.DiagnosticCategory.Error, "The_inferred_type_of_0_references_an_inaccessible_1_type_A_type_annotation_is_necessary_2527", "The inferred type of '{0}' references an inaccessible '{1}' type. A type annotation is necessary."),
      A_module_cannot_have_multiple_default_exports: diag(2528, ts2.DiagnosticCategory.Error, "A_module_cannot_have_multiple_default_exports_2528", "A module cannot have multiple default exports."),
      Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_containing_async_functions: diag(2529, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_containing_async_func_2529", "Duplicate identifier '{0}'. Compiler reserves name '{1}' in top level scope of a module containing async functions."),
      Property_0_is_incompatible_with_index_signature: diag(2530, ts2.DiagnosticCategory.Error, "Property_0_is_incompatible_with_index_signature_2530", "Property '{0}' is incompatible with index signature."),
      Object_is_possibly_null: diag(2531, ts2.DiagnosticCategory.Error, "Object_is_possibly_null_2531", "Object is possibly 'null'."),
      Object_is_possibly_undefined: diag(2532, ts2.DiagnosticCategory.Error, "Object_is_possibly_undefined_2532", "Object is possibly 'undefined'."),
      Object_is_possibly_null_or_undefined: diag(2533, ts2.DiagnosticCategory.Error, "Object_is_possibly_null_or_undefined_2533", "Object is possibly 'null' or 'undefined'."),
      A_function_returning_never_cannot_have_a_reachable_end_point: diag(2534, ts2.DiagnosticCategory.Error, "A_function_returning_never_cannot_have_a_reachable_end_point_2534", "A function returning 'never' cannot have a reachable end point."),
      Enum_type_0_has_members_with_initializers_that_are_not_literals: diag(2535, ts2.DiagnosticCategory.Error, "Enum_type_0_has_members_with_initializers_that_are_not_literals_2535", "Enum type '{0}' has members with initializers that are not literals."),
      Type_0_cannot_be_used_to_index_type_1: diag(2536, ts2.DiagnosticCategory.Error, "Type_0_cannot_be_used_to_index_type_1_2536", "Type '{0}' cannot be used to index type '{1}'."),
      Type_0_has_no_matching_index_signature_for_type_1: diag(2537, ts2.DiagnosticCategory.Error, "Type_0_has_no_matching_index_signature_for_type_1_2537", "Type '{0}' has no matching index signature for type '{1}'."),
      Type_0_cannot_be_used_as_an_index_type: diag(2538, ts2.DiagnosticCategory.Error, "Type_0_cannot_be_used_as_an_index_type_2538", "Type '{0}' cannot be used as an index type."),
      Cannot_assign_to_0_because_it_is_not_a_variable: diag(2539, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_not_a_variable_2539", "Cannot assign to '{0}' because it is not a variable."),
      Cannot_assign_to_0_because_it_is_a_read_only_property: diag(2540, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_a_read_only_property_2540", "Cannot assign to '{0}' because it is a read-only property."),
      The_target_of_an_assignment_must_be_a_variable_or_a_property_access: diag(2541, ts2.DiagnosticCategory.Error, "The_target_of_an_assignment_must_be_a_variable_or_a_property_access_2541", "The target of an assignment must be a variable or a property access."),
      Index_signature_in_type_0_only_permits_reading: diag(2542, ts2.DiagnosticCategory.Error, "Index_signature_in_type_0_only_permits_reading_2542", "Index signature in type '{0}' only permits reading."),
      Duplicate_identifier_newTarget_Compiler_uses_variable_declaration_newTarget_to_capture_new_target_meta_property_reference: diag(2543, ts2.DiagnosticCategory.Error, "Duplicate_identifier_newTarget_Compiler_uses_variable_declaration_newTarget_to_capture_new_target_me_2543", "Duplicate identifier '_newTarget'. Compiler uses variable declaration '_newTarget' to capture 'new.target' meta-property reference."),
      Expression_resolves_to_variable_declaration_newTarget_that_compiler_uses_to_capture_new_target_meta_property_reference: diag(2544, ts2.DiagnosticCategory.Error, "Expression_resolves_to_variable_declaration_newTarget_that_compiler_uses_to_capture_new_target_meta__2544", "Expression resolves to variable declaration '_newTarget' that compiler uses to capture 'new.target' meta-property reference."),
      A_mixin_class_must_have_a_constructor_with_a_single_rest_parameter_of_type_any: diag(2545, ts2.DiagnosticCategory.Error, "A_mixin_class_must_have_a_constructor_with_a_single_rest_parameter_of_type_any_2545", "A mixin class must have a constructor with a single rest parameter of type 'any[]'."),
      The_type_returned_by_the_0_method_of_an_async_iterator_must_be_a_promise_for_a_type_with_a_value_property: diag(2547, ts2.DiagnosticCategory.Error, "The_type_returned_by_the_0_method_of_an_async_iterator_must_be_a_promise_for_a_type_with_a_value_pro_2547", "The type returned by the '{0}()' method of an async iterator must be a promise for a type with a 'value' property."),
      Type_0_is_not_an_array_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator: diag(2548, ts2.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator_2548", "Type '{0}' is not an array type or does not have a '[Symbol.iterator]()' method that returns an iterator."),
      Type_0_is_not_an_array_type_or_a_string_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator: diag(2549, ts2.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_or_a_string_type_or_does_not_have_a_Symbol_iterator_method_that_returns__2549", "Type '{0}' is not an array type or a string type or does not have a '[Symbol.iterator]()' method that returns an iterator."),
      Property_0_does_not_exist_on_type_1_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_2_or_later: diag(2550, ts2.DiagnosticCategory.Error, "Property_0_does_not_exist_on_type_1_Do_you_need_to_change_your_target_library_Try_changing_the_lib_c_2550", "Property '{0}' does not exist on type '{1}'. Do you need to change your target library? Try changing the 'lib' compiler option to '{2}' or later."),
      Property_0_does_not_exist_on_type_1_Did_you_mean_2: diag(2551, ts2.DiagnosticCategory.Error, "Property_0_does_not_exist_on_type_1_Did_you_mean_2_2551", "Property '{0}' does not exist on type '{1}'. Did you mean '{2}'?"),
      Cannot_find_name_0_Did_you_mean_1: diag(2552, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Did_you_mean_1_2552", "Cannot find name '{0}'. Did you mean '{1}'?"),
      Computed_values_are_not_permitted_in_an_enum_with_string_valued_members: diag(2553, ts2.DiagnosticCategory.Error, "Computed_values_are_not_permitted_in_an_enum_with_string_valued_members_2553", "Computed values are not permitted in an enum with string valued members."),
      Expected_0_arguments_but_got_1: diag(2554, ts2.DiagnosticCategory.Error, "Expected_0_arguments_but_got_1_2554", "Expected {0} arguments, but got {1}."),
      Expected_at_least_0_arguments_but_got_1: diag(2555, ts2.DiagnosticCategory.Error, "Expected_at_least_0_arguments_but_got_1_2555", "Expected at least {0} arguments, but got {1}."),
      A_spread_argument_must_either_have_a_tuple_type_or_be_passed_to_a_rest_parameter: diag(2556, ts2.DiagnosticCategory.Error, "A_spread_argument_must_either_have_a_tuple_type_or_be_passed_to_a_rest_parameter_2556", "A spread argument must either have a tuple type or be passed to a rest parameter."),
      Expected_0_type_arguments_but_got_1: diag(2558, ts2.DiagnosticCategory.Error, "Expected_0_type_arguments_but_got_1_2558", "Expected {0} type arguments, but got {1}."),
      Type_0_has_no_properties_in_common_with_type_1: diag(2559, ts2.DiagnosticCategory.Error, "Type_0_has_no_properties_in_common_with_type_1_2559", "Type '{0}' has no properties in common with type '{1}'."),
      Value_of_type_0_has_no_properties_in_common_with_type_1_Did_you_mean_to_call_it: diag(2560, ts2.DiagnosticCategory.Error, "Value_of_type_0_has_no_properties_in_common_with_type_1_Did_you_mean_to_call_it_2560", "Value of type '{0}' has no properties in common with type '{1}'. Did you mean to call it?"),
      Object_literal_may_only_specify_known_properties_but_0_does_not_exist_in_type_1_Did_you_mean_to_write_2: diag(2561, ts2.DiagnosticCategory.Error, "Object_literal_may_only_specify_known_properties_but_0_does_not_exist_in_type_1_Did_you_mean_to_writ_2561", "Object literal may only specify known properties, but '{0}' does not exist in type '{1}'. Did you mean to write '{2}'?"),
      Base_class_expressions_cannot_reference_class_type_parameters: diag(2562, ts2.DiagnosticCategory.Error, "Base_class_expressions_cannot_reference_class_type_parameters_2562", "Base class expressions cannot reference class type parameters."),
      The_containing_function_or_module_body_is_too_large_for_control_flow_analysis: diag(2563, ts2.DiagnosticCategory.Error, "The_containing_function_or_module_body_is_too_large_for_control_flow_analysis_2563", "The containing function or module body is too large for control flow analysis."),
      Property_0_has_no_initializer_and_is_not_definitely_assigned_in_the_constructor: diag(2564, ts2.DiagnosticCategory.Error, "Property_0_has_no_initializer_and_is_not_definitely_assigned_in_the_constructor_2564", "Property '{0}' has no initializer and is not definitely assigned in the constructor."),
      Property_0_is_used_before_being_assigned: diag(2565, ts2.DiagnosticCategory.Error, "Property_0_is_used_before_being_assigned_2565", "Property '{0}' is used before being assigned."),
      A_rest_element_cannot_have_a_property_name: diag(2566, ts2.DiagnosticCategory.Error, "A_rest_element_cannot_have_a_property_name_2566", "A rest element cannot have a property name."),
      Enum_declarations_can_only_merge_with_namespace_or_other_enum_declarations: diag(2567, ts2.DiagnosticCategory.Error, "Enum_declarations_can_only_merge_with_namespace_or_other_enum_declarations_2567", "Enum declarations can only merge with namespace or other enum declarations."),
      Property_0_may_not_exist_on_type_1_Did_you_mean_2: diag(2568, ts2.DiagnosticCategory.Error, "Property_0_may_not_exist_on_type_1_Did_you_mean_2_2568", "Property '{0}' may not exist on type '{1}'. Did you mean '{2}'?"),
      Type_0_is_not_an_array_type_or_a_string_type_Use_compiler_option_downlevelIteration_to_allow_iterating_of_iterators: diag(2569, ts2.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_or_a_string_type_Use_compiler_option_downlevelIteration_to_allow_iterati_2569", "Type '{0}' is not an array type or a string type. Use compiler option '--downlevelIteration' to allow iterating of iterators."),
      Could_not_find_name_0_Did_you_mean_1: diag(2570, ts2.DiagnosticCategory.Error, "Could_not_find_name_0_Did_you_mean_1_2570", "Could not find name '{0}'. Did you mean '{1}'?"),
      Object_is_of_type_unknown: diag(2571, ts2.DiagnosticCategory.Error, "Object_is_of_type_unknown_2571", "Object is of type 'unknown'."),
      Rest_signatures_are_incompatible: diag(2572, ts2.DiagnosticCategory.Error, "Rest_signatures_are_incompatible_2572", "Rest signatures are incompatible."),
      Property_0_is_incompatible_with_rest_element_type: diag(2573, ts2.DiagnosticCategory.Error, "Property_0_is_incompatible_with_rest_element_type_2573", "Property '{0}' is incompatible with rest element type."),
      A_rest_element_type_must_be_an_array_type: diag(2574, ts2.DiagnosticCategory.Error, "A_rest_element_type_must_be_an_array_type_2574", "A rest element type must be an array type."),
      No_overload_expects_0_arguments_but_overloads_do_exist_that_expect_either_1_or_2_arguments: diag(2575, ts2.DiagnosticCategory.Error, "No_overload_expects_0_arguments_but_overloads_do_exist_that_expect_either_1_or_2_arguments_2575", "No overload expects {0} arguments, but overloads do exist that expect either {1} or {2} arguments."),
      Property_0_does_not_exist_on_type_1_Did_you_mean_to_access_the_static_member_2_instead: diag(2576, ts2.DiagnosticCategory.Error, "Property_0_does_not_exist_on_type_1_Did_you_mean_to_access_the_static_member_2_instead_2576", "Property '{0}' does not exist on type '{1}'. Did you mean to access the static member '{2}' instead?"),
      Return_type_annotation_circularly_references_itself: diag(2577, ts2.DiagnosticCategory.Error, "Return_type_annotation_circularly_references_itself_2577", "Return type annotation circularly references itself."),
      Unused_ts_expect_error_directive: diag(2578, ts2.DiagnosticCategory.Error, "Unused_ts_expect_error_directive_2578", "Unused '@ts-expect-error' directive."),
      Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_save_dev_types_Slashnode: diag(2580, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_save_dev_types_Slashno_2580", "Cannot find name '{0}'. Do you need to install type definitions for node? Try `npm i --save-dev @types/node`."),
      Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_save_dev_types_Slashjquery: diag(2581, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_save_dev_types_Slash_2581", "Cannot find name '{0}'. Do you need to install type definitions for jQuery? Try `npm i --save-dev @types/jquery`."),
      Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_save_dev_types_Slashjest_or_npm_i_save_dev_types_Slashmocha: diag(2582, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_save_dev_type_2582", "Cannot find name '{0}'. Do you need to install type definitions for a test runner? Try `npm i --save-dev @types/jest` or `npm i --save-dev @types/mocha`."),
      Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_1_or_later: diag(2583, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_2583", "Cannot find name '{0}'. Do you need to change your target library? Try changing the 'lib' compiler option to '{1}' or later."),
      Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_include_dom: diag(2584, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_2584", "Cannot find name '{0}'. Do you need to change your target library? Try changing the 'lib' compiler option to include 'dom'."),
      _0_only_refers_to_a_type_but_is_being_used_as_a_value_here_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_es2015_or_later: diag(2585, ts2.DiagnosticCategory.Error, "_0_only_refers_to_a_type_but_is_being_used_as_a_value_here_Do_you_need_to_change_your_target_library_2585", "'{0}' only refers to a type, but is being used as a value here. Do you need to change your target library? Try changing the 'lib' compiler option to es2015 or later."),
      Enum_type_0_circularly_references_itself: diag(2586, ts2.DiagnosticCategory.Error, "Enum_type_0_circularly_references_itself_2586", "Enum type '{0}' circularly references itself."),
      JSDoc_type_0_circularly_references_itself: diag(2587, ts2.DiagnosticCategory.Error, "JSDoc_type_0_circularly_references_itself_2587", "JSDoc type '{0}' circularly references itself."),
      Cannot_assign_to_0_because_it_is_a_constant: diag(2588, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_a_constant_2588", "Cannot assign to '{0}' because it is a constant."),
      Type_instantiation_is_excessively_deep_and_possibly_infinite: diag(2589, ts2.DiagnosticCategory.Error, "Type_instantiation_is_excessively_deep_and_possibly_infinite_2589", "Type instantiation is excessively deep and possibly infinite."),
      Expression_produces_a_union_type_that_is_too_complex_to_represent: diag(2590, ts2.DiagnosticCategory.Error, "Expression_produces_a_union_type_that_is_too_complex_to_represent_2590", "Expression produces a union type that is too complex to represent."),
      Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_save_dev_types_Slashnode_and_then_add_node_to_the_types_field_in_your_tsconfig: diag(2591, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_save_dev_types_Slashno_2591", "Cannot find name '{0}'. Do you need to install type definitions for node? Try `npm i --save-dev @types/node` and then add 'node' to the types field in your tsconfig."),
      Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_save_dev_types_Slashjquery_and_then_add_jquery_to_the_types_field_in_your_tsconfig: diag(2592, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_save_dev_types_Slash_2592", "Cannot find name '{0}'. Do you need to install type definitions for jQuery? Try `npm i --save-dev @types/jquery` and then add 'jquery' to the types field in your tsconfig."),
      Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_save_dev_types_Slashjest_or_npm_i_save_dev_types_Slashmocha_and_then_add_jest_or_mocha_to_the_types_field_in_your_tsconfig: diag(2593, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_save_dev_type_2593", "Cannot find name '{0}'. Do you need to install type definitions for a test runner? Try `npm i --save-dev @types/jest` or `npm i --save-dev @types/mocha` and then add 'jest' or 'mocha' to the types field in your tsconfig."),
      This_module_is_declared_with_using_export_and_can_only_be_used_with_a_default_import_when_using_the_0_flag: diag(2594, ts2.DiagnosticCategory.Error, "This_module_is_declared_with_using_export_and_can_only_be_used_with_a_default_import_when_using_the__2594", "This module is declared with using 'export =', and can only be used with a default import when using the '{0}' flag."),
      _0_can_only_be_imported_by_using_a_default_import: diag(2595, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_using_a_default_import_2595", "'{0}' can only be imported by using a default import."),
      _0_can_only_be_imported_by_turning_on_the_esModuleInterop_flag_and_using_a_default_import: diag(2596, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_turning_on_the_esModuleInterop_flag_and_using_a_default_import_2596", "'{0}' can only be imported by turning on the 'esModuleInterop' flag and using a default import."),
      _0_can_only_be_imported_by_using_a_require_call_or_by_using_a_default_import: diag(2597, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_using_a_require_call_or_by_using_a_default_import_2597", "'{0}' can only be imported by using a 'require' call or by using a default import."),
      _0_can_only_be_imported_by_using_a_require_call_or_by_turning_on_the_esModuleInterop_flag_and_using_a_default_import: diag(2598, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_using_a_require_call_or_by_turning_on_the_esModuleInterop_flag_and_using__2598", "'{0}' can only be imported by using a 'require' call or by turning on the 'esModuleInterop' flag and using a default import."),
      JSX_element_attributes_type_0_may_not_be_a_union_type: diag(2600, ts2.DiagnosticCategory.Error, "JSX_element_attributes_type_0_may_not_be_a_union_type_2600", "JSX element attributes type '{0}' may not be a union type."),
      The_return_type_of_a_JSX_element_constructor_must_return_an_object_type: diag(2601, ts2.DiagnosticCategory.Error, "The_return_type_of_a_JSX_element_constructor_must_return_an_object_type_2601", "The return type of a JSX element constructor must return an object type."),
      JSX_element_implicitly_has_type_any_because_the_global_type_JSX_Element_does_not_exist: diag(2602, ts2.DiagnosticCategory.Error, "JSX_element_implicitly_has_type_any_because_the_global_type_JSX_Element_does_not_exist_2602", "JSX element implicitly has type 'any' because the global type 'JSX.Element' does not exist."),
      Property_0_in_type_1_is_not_assignable_to_type_2: diag(2603, ts2.DiagnosticCategory.Error, "Property_0_in_type_1_is_not_assignable_to_type_2_2603", "Property '{0}' in type '{1}' is not assignable to type '{2}'."),
      JSX_element_type_0_does_not_have_any_construct_or_call_signatures: diag(2604, ts2.DiagnosticCategory.Error, "JSX_element_type_0_does_not_have_any_construct_or_call_signatures_2604", "JSX element type '{0}' does not have any construct or call signatures."),
      JSX_element_type_0_is_not_a_constructor_function_for_JSX_elements: diag(2605, ts2.DiagnosticCategory.Error, "JSX_element_type_0_is_not_a_constructor_function_for_JSX_elements_2605", "JSX element type '{0}' is not a constructor function for JSX elements."),
      Property_0_of_JSX_spread_attribute_is_not_assignable_to_target_property: diag(2606, ts2.DiagnosticCategory.Error, "Property_0_of_JSX_spread_attribute_is_not_assignable_to_target_property_2606", "Property '{0}' of JSX spread attribute is not assignable to target property."),
      JSX_element_class_does_not_support_attributes_because_it_does_not_have_a_0_property: diag(2607, ts2.DiagnosticCategory.Error, "JSX_element_class_does_not_support_attributes_because_it_does_not_have_a_0_property_2607", "JSX element class does not support attributes because it does not have a '{0}' property."),
      The_global_type_JSX_0_may_not_have_more_than_one_property: diag(2608, ts2.DiagnosticCategory.Error, "The_global_type_JSX_0_may_not_have_more_than_one_property_2608", "The global type 'JSX.{0}' may not have more than one property."),
      JSX_spread_child_must_be_an_array_type: diag(2609, ts2.DiagnosticCategory.Error, "JSX_spread_child_must_be_an_array_type_2609", "JSX spread child must be an array type."),
      _0_is_defined_as_an_accessor_in_class_1_but_is_overridden_here_in_2_as_an_instance_property: diag(2610, ts2.DiagnosticCategory.Error, "_0_is_defined_as_an_accessor_in_class_1_but_is_overridden_here_in_2_as_an_instance_property_2610", "'{0}' is defined as an accessor in class '{1}', but is overridden here in '{2}' as an instance property."),
      _0_is_defined_as_a_property_in_class_1_but_is_overridden_here_in_2_as_an_accessor: diag(2611, ts2.DiagnosticCategory.Error, "_0_is_defined_as_a_property_in_class_1_but_is_overridden_here_in_2_as_an_accessor_2611", "'{0}' is defined as a property in class '{1}', but is overridden here in '{2}' as an accessor."),
      Property_0_will_overwrite_the_base_property_in_1_If_this_is_intentional_add_an_initializer_Otherwise_add_a_declare_modifier_or_remove_the_redundant_declaration: diag(2612, ts2.DiagnosticCategory.Error, "Property_0_will_overwrite_the_base_property_in_1_If_this_is_intentional_add_an_initializer_Otherwise_2612", "Property '{0}' will overwrite the base property in '{1}'. If this is intentional, add an initializer. Otherwise, add a 'declare' modifier or remove the redundant declaration."),
      Module_0_has_no_default_export_Did_you_mean_to_use_import_1_from_0_instead: diag(2613, ts2.DiagnosticCategory.Error, "Module_0_has_no_default_export_Did_you_mean_to_use_import_1_from_0_instead_2613", "Module '{0}' has no default export. Did you mean to use 'import { {1} } from {0}' instead?"),
      Module_0_has_no_exported_member_1_Did_you_mean_to_use_import_1_from_0_instead: diag(2614, ts2.DiagnosticCategory.Error, "Module_0_has_no_exported_member_1_Did_you_mean_to_use_import_1_from_0_instead_2614", "Module '{0}' has no exported member '{1}'. Did you mean to use 'import {1} from {0}' instead?"),
      Type_of_property_0_circularly_references_itself_in_mapped_type_1: diag(2615, ts2.DiagnosticCategory.Error, "Type_of_property_0_circularly_references_itself_in_mapped_type_1_2615", "Type of property '{0}' circularly references itself in mapped type '{1}'."),
      _0_can_only_be_imported_by_using_import_1_require_2_or_a_default_import: diag(2616, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_using_import_1_require_2_or_a_default_import_2616", "'{0}' can only be imported by using 'import {1} = require({2})' or a default import."),
      _0_can_only_be_imported_by_using_import_1_require_2_or_by_turning_on_the_esModuleInterop_flag_and_using_a_default_import: diag(2617, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_using_import_1_require_2_or_by_turning_on_the_esModuleInterop_flag_and_us_2617", "'{0}' can only be imported by using 'import {1} = require({2})' or by turning on the 'esModuleInterop' flag and using a default import."),
      Source_has_0_element_s_but_target_requires_1: diag(2618, ts2.DiagnosticCategory.Error, "Source_has_0_element_s_but_target_requires_1_2618", "Source has {0} element(s) but target requires {1}."),
      Source_has_0_element_s_but_target_allows_only_1: diag(2619, ts2.DiagnosticCategory.Error, "Source_has_0_element_s_but_target_allows_only_1_2619", "Source has {0} element(s) but target allows only {1}."),
      Target_requires_0_element_s_but_source_may_have_fewer: diag(2620, ts2.DiagnosticCategory.Error, "Target_requires_0_element_s_but_source_may_have_fewer_2620", "Target requires {0} element(s) but source may have fewer."),
      Target_allows_only_0_element_s_but_source_may_have_more: diag(2621, ts2.DiagnosticCategory.Error, "Target_allows_only_0_element_s_but_source_may_have_more_2621", "Target allows only {0} element(s) but source may have more."),
      Source_provides_no_match_for_required_element_at_position_0_in_target: diag(2623, ts2.DiagnosticCategory.Error, "Source_provides_no_match_for_required_element_at_position_0_in_target_2623", "Source provides no match for required element at position {0} in target."),
      Source_provides_no_match_for_variadic_element_at_position_0_in_target: diag(2624, ts2.DiagnosticCategory.Error, "Source_provides_no_match_for_variadic_element_at_position_0_in_target_2624", "Source provides no match for variadic element at position {0} in target."),
      Variadic_element_at_position_0_in_source_does_not_match_element_at_position_1_in_target: diag(2625, ts2.DiagnosticCategory.Error, "Variadic_element_at_position_0_in_source_does_not_match_element_at_position_1_in_target_2625", "Variadic element at position {0} in source does not match element at position {1} in target."),
      Type_at_position_0_in_source_is_not_compatible_with_type_at_position_1_in_target: diag(2626, ts2.DiagnosticCategory.Error, "Type_at_position_0_in_source_is_not_compatible_with_type_at_position_1_in_target_2626", "Type at position {0} in source is not compatible with type at position {1} in target."),
      Type_at_positions_0_through_1_in_source_is_not_compatible_with_type_at_position_2_in_target: diag(2627, ts2.DiagnosticCategory.Error, "Type_at_positions_0_through_1_in_source_is_not_compatible_with_type_at_position_2_in_target_2627", "Type at positions {0} through {1} in source is not compatible with type at position {2} in target."),
      Cannot_assign_to_0_because_it_is_an_enum: diag(2628, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_an_enum_2628", "Cannot assign to '{0}' because it is an enum."),
      Cannot_assign_to_0_because_it_is_a_class: diag(2629, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_a_class_2629", "Cannot assign to '{0}' because it is a class."),
      Cannot_assign_to_0_because_it_is_a_function: diag(2630, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_a_function_2630", "Cannot assign to '{0}' because it is a function."),
      Cannot_assign_to_0_because_it_is_a_namespace: diag(2631, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_a_namespace_2631", "Cannot assign to '{0}' because it is a namespace."),
      Cannot_assign_to_0_because_it_is_an_import: diag(2632, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_an_import_2632", "Cannot assign to '{0}' because it is an import."),
      JSX_property_access_expressions_cannot_include_JSX_namespace_names: diag(2633, ts2.DiagnosticCategory.Error, "JSX_property_access_expressions_cannot_include_JSX_namespace_names_2633", "JSX property access expressions cannot include JSX namespace names"),
      _0_index_signatures_are_incompatible: diag(2634, ts2.DiagnosticCategory.Error, "_0_index_signatures_are_incompatible_2634", "'{0}' index signatures are incompatible."),
      Cannot_augment_module_0_with_value_exports_because_it_resolves_to_a_non_module_entity: diag(2649, ts2.DiagnosticCategory.Error, "Cannot_augment_module_0_with_value_exports_because_it_resolves_to_a_non_module_entity_2649", "Cannot augment module '{0}' with value exports because it resolves to a non-module entity."),
      A_member_initializer_in_a_enum_declaration_cannot_reference_members_declared_after_it_including_members_defined_in_other_enums: diag(2651, ts2.DiagnosticCategory.Error, "A_member_initializer_in_a_enum_declaration_cannot_reference_members_declared_after_it_including_memb_2651", "A member initializer in a enum declaration cannot reference members declared after it, including members defined in other enums."),
      Merged_declaration_0_cannot_include_a_default_export_declaration_Consider_adding_a_separate_export_default_0_declaration_instead: diag(2652, ts2.DiagnosticCategory.Error, "Merged_declaration_0_cannot_include_a_default_export_declaration_Consider_adding_a_separate_export_d_2652", "Merged declaration '{0}' cannot include a default export declaration. Consider adding a separate 'export default {0}' declaration instead."),
      Non_abstract_class_expression_does_not_implement_inherited_abstract_member_0_from_class_1: diag(2653, ts2.DiagnosticCategory.Error, "Non_abstract_class_expression_does_not_implement_inherited_abstract_member_0_from_class_1_2653", "Non-abstract class expression does not implement inherited abstract member '{0}' from class '{1}'."),
      Exported_external_package_typings_file_cannot_contain_tripleslash_references_Please_contact_the_package_author_to_update_the_package_definition: diag(2654, ts2.DiagnosticCategory.Error, "Exported_external_package_typings_file_cannot_contain_tripleslash_references_Please_contact_the_pack_2654", "Exported external package typings file cannot contain tripleslash references. Please contact the package author to update the package definition."),
      Exported_external_package_typings_file_0_is_not_a_module_Please_contact_the_package_author_to_update_the_package_definition: diag(2656, ts2.DiagnosticCategory.Error, "Exported_external_package_typings_file_0_is_not_a_module_Please_contact_the_package_author_to_update_2656", "Exported external package typings file '{0}' is not a module. Please contact the package author to update the package definition."),
      JSX_expressions_must_have_one_parent_element: diag(2657, ts2.DiagnosticCategory.Error, "JSX_expressions_must_have_one_parent_element_2657", "JSX expressions must have one parent element."),
      Type_0_provides_no_match_for_the_signature_1: diag(2658, ts2.DiagnosticCategory.Error, "Type_0_provides_no_match_for_the_signature_1_2658", "Type '{0}' provides no match for the signature '{1}'."),
      super_is_only_allowed_in_members_of_object_literal_expressions_when_option_target_is_ES2015_or_higher: diag(2659, ts2.DiagnosticCategory.Error, "super_is_only_allowed_in_members_of_object_literal_expressions_when_option_target_is_ES2015_or_highe_2659", "'super' is only allowed in members of object literal expressions when option 'target' is 'ES2015' or higher."),
      super_can_only_be_referenced_in_members_of_derived_classes_or_object_literal_expressions: diag(2660, ts2.DiagnosticCategory.Error, "super_can_only_be_referenced_in_members_of_derived_classes_or_object_literal_expressions_2660", "'super' can only be referenced in members of derived classes or object literal expressions."),
      Cannot_export_0_Only_local_declarations_can_be_exported_from_a_module: diag(2661, ts2.DiagnosticCategory.Error, "Cannot_export_0_Only_local_declarations_can_be_exported_from_a_module_2661", "Cannot export '{0}'. Only local declarations can be exported from a module."),
      Cannot_find_name_0_Did_you_mean_the_static_member_1_0: diag(2662, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Did_you_mean_the_static_member_1_0_2662", "Cannot find name '{0}'. Did you mean the static member '{1}.{0}'?"),
      Cannot_find_name_0_Did_you_mean_the_instance_member_this_0: diag(2663, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Did_you_mean_the_instance_member_this_0_2663", "Cannot find name '{0}'. Did you mean the instance member 'this.{0}'?"),
      Invalid_module_name_in_augmentation_module_0_cannot_be_found: diag(2664, ts2.DiagnosticCategory.Error, "Invalid_module_name_in_augmentation_module_0_cannot_be_found_2664", "Invalid module name in augmentation, module '{0}' cannot be found."),
      Invalid_module_name_in_augmentation_Module_0_resolves_to_an_untyped_module_at_1_which_cannot_be_augmented: diag(2665, ts2.DiagnosticCategory.Error, "Invalid_module_name_in_augmentation_Module_0_resolves_to_an_untyped_module_at_1_which_cannot_be_augm_2665", "Invalid module name in augmentation. Module '{0}' resolves to an untyped module at '{1}', which cannot be augmented."),
      Exports_and_export_assignments_are_not_permitted_in_module_augmentations: diag(2666, ts2.DiagnosticCategory.Error, "Exports_and_export_assignments_are_not_permitted_in_module_augmentations_2666", "Exports and export assignments are not permitted in module augmentations."),
      Imports_are_not_permitted_in_module_augmentations_Consider_moving_them_to_the_enclosing_external_module: diag(2667, ts2.DiagnosticCategory.Error, "Imports_are_not_permitted_in_module_augmentations_Consider_moving_them_to_the_enclosing_external_mod_2667", "Imports are not permitted in module augmentations. Consider moving them to the enclosing external module."),
      export_modifier_cannot_be_applied_to_ambient_modules_and_module_augmentations_since_they_are_always_visible: diag(2668, ts2.DiagnosticCategory.Error, "export_modifier_cannot_be_applied_to_ambient_modules_and_module_augmentations_since_they_are_always__2668", "'export' modifier cannot be applied to ambient modules and module augmentations since they are always visible."),
      Augmentations_for_the_global_scope_can_only_be_directly_nested_in_external_modules_or_ambient_module_declarations: diag(2669, ts2.DiagnosticCategory.Error, "Augmentations_for_the_global_scope_can_only_be_directly_nested_in_external_modules_or_ambient_module_2669", "Augmentations for the global scope can only be directly nested in external modules or ambient module declarations."),
      Augmentations_for_the_global_scope_should_have_declare_modifier_unless_they_appear_in_already_ambient_context: diag(2670, ts2.DiagnosticCategory.Error, "Augmentations_for_the_global_scope_should_have_declare_modifier_unless_they_appear_in_already_ambien_2670", "Augmentations for the global scope should have 'declare' modifier unless they appear in already ambient context."),
      Cannot_augment_module_0_because_it_resolves_to_a_non_module_entity: diag(2671, ts2.DiagnosticCategory.Error, "Cannot_augment_module_0_because_it_resolves_to_a_non_module_entity_2671", "Cannot augment module '{0}' because it resolves to a non-module entity."),
      Cannot_assign_a_0_constructor_type_to_a_1_constructor_type: diag(2672, ts2.DiagnosticCategory.Error, "Cannot_assign_a_0_constructor_type_to_a_1_constructor_type_2672", "Cannot assign a '{0}' constructor type to a '{1}' constructor type."),
      Constructor_of_class_0_is_private_and_only_accessible_within_the_class_declaration: diag(2673, ts2.DiagnosticCategory.Error, "Constructor_of_class_0_is_private_and_only_accessible_within_the_class_declaration_2673", "Constructor of class '{0}' is private and only accessible within the class declaration."),
      Constructor_of_class_0_is_protected_and_only_accessible_within_the_class_declaration: diag(2674, ts2.DiagnosticCategory.Error, "Constructor_of_class_0_is_protected_and_only_accessible_within_the_class_declaration_2674", "Constructor of class '{0}' is protected and only accessible within the class declaration."),
      Cannot_extend_a_class_0_Class_constructor_is_marked_as_private: diag(2675, ts2.DiagnosticCategory.Error, "Cannot_extend_a_class_0_Class_constructor_is_marked_as_private_2675", "Cannot extend a class '{0}'. Class constructor is marked as private."),
      Accessors_must_both_be_abstract_or_non_abstract: diag(2676, ts2.DiagnosticCategory.Error, "Accessors_must_both_be_abstract_or_non_abstract_2676", "Accessors must both be abstract or non-abstract."),
      A_type_predicate_s_type_must_be_assignable_to_its_parameter_s_type: diag(2677, ts2.DiagnosticCategory.Error, "A_type_predicate_s_type_must_be_assignable_to_its_parameter_s_type_2677", "A type predicate's type must be assignable to its parameter's type."),
      Type_0_is_not_comparable_to_type_1: diag(2678, ts2.DiagnosticCategory.Error, "Type_0_is_not_comparable_to_type_1_2678", "Type '{0}' is not comparable to type '{1}'."),
      A_function_that_is_called_with_the_new_keyword_cannot_have_a_this_type_that_is_void: diag(2679, ts2.DiagnosticCategory.Error, "A_function_that_is_called_with_the_new_keyword_cannot_have_a_this_type_that_is_void_2679", "A function that is called with the 'new' keyword cannot have a 'this' type that is 'void'."),
      A_0_parameter_must_be_the_first_parameter: diag(2680, ts2.DiagnosticCategory.Error, "A_0_parameter_must_be_the_first_parameter_2680", "A '{0}' parameter must be the first parameter."),
      A_constructor_cannot_have_a_this_parameter: diag(2681, ts2.DiagnosticCategory.Error, "A_constructor_cannot_have_a_this_parameter_2681", "A constructor cannot have a 'this' parameter."),
      get_and_set_accessor_must_have_the_same_this_type: diag(2682, ts2.DiagnosticCategory.Error, "get_and_set_accessor_must_have_the_same_this_type_2682", "'get' and 'set' accessor must have the same 'this' type."),
      this_implicitly_has_type_any_because_it_does_not_have_a_type_annotation: diag(2683, ts2.DiagnosticCategory.Error, "this_implicitly_has_type_any_because_it_does_not_have_a_type_annotation_2683", "'this' implicitly has type 'any' because it does not have a type annotation."),
      The_this_context_of_type_0_is_not_assignable_to_method_s_this_of_type_1: diag(2684, ts2.DiagnosticCategory.Error, "The_this_context_of_type_0_is_not_assignable_to_method_s_this_of_type_1_2684", "The 'this' context of type '{0}' is not assignable to method's 'this' of type '{1}'."),
      The_this_types_of_each_signature_are_incompatible: diag(2685, ts2.DiagnosticCategory.Error, "The_this_types_of_each_signature_are_incompatible_2685", "The 'this' types of each signature are incompatible."),
      _0_refers_to_a_UMD_global_but_the_current_file_is_a_module_Consider_adding_an_import_instead: diag(2686, ts2.DiagnosticCategory.Error, "_0_refers_to_a_UMD_global_but_the_current_file_is_a_module_Consider_adding_an_import_instead_2686", "'{0}' refers to a UMD global, but the current file is a module. Consider adding an import instead."),
      All_declarations_of_0_must_have_identical_modifiers: diag(2687, ts2.DiagnosticCategory.Error, "All_declarations_of_0_must_have_identical_modifiers_2687", "All declarations of '{0}' must have identical modifiers."),
      Cannot_find_type_definition_file_for_0: diag(2688, ts2.DiagnosticCategory.Error, "Cannot_find_type_definition_file_for_0_2688", "Cannot find type definition file for '{0}'."),
      Cannot_extend_an_interface_0_Did_you_mean_implements: diag(2689, ts2.DiagnosticCategory.Error, "Cannot_extend_an_interface_0_Did_you_mean_implements_2689", "Cannot extend an interface '{0}'. Did you mean 'implements'?"),
      _0_only_refers_to_a_type_but_is_being_used_as_a_value_here_Did_you_mean_to_use_1_in_0: diag(2690, ts2.DiagnosticCategory.Error, "_0_only_refers_to_a_type_but_is_being_used_as_a_value_here_Did_you_mean_to_use_1_in_0_2690", "'{0}' only refers to a type, but is being used as a value here. Did you mean to use '{1} in {0}'?"),
      An_import_path_cannot_end_with_a_0_extension_Consider_importing_1_instead: diag(2691, ts2.DiagnosticCategory.Error, "An_import_path_cannot_end_with_a_0_extension_Consider_importing_1_instead_2691", "An import path cannot end with a '{0}' extension. Consider importing '{1}' instead."),
      _0_is_a_primitive_but_1_is_a_wrapper_object_Prefer_using_0_when_possible: diag(2692, ts2.DiagnosticCategory.Error, "_0_is_a_primitive_but_1_is_a_wrapper_object_Prefer_using_0_when_possible_2692", "'{0}' is a primitive, but '{1}' is a wrapper object. Prefer using '{0}' when possible."),
      _0_only_refers_to_a_type_but_is_being_used_as_a_value_here: diag(2693, ts2.DiagnosticCategory.Error, "_0_only_refers_to_a_type_but_is_being_used_as_a_value_here_2693", "'{0}' only refers to a type, but is being used as a value here."),
      Namespace_0_has_no_exported_member_1: diag(2694, ts2.DiagnosticCategory.Error, "Namespace_0_has_no_exported_member_1_2694", "Namespace '{0}' has no exported member '{1}'."),
      Left_side_of_comma_operator_is_unused_and_has_no_side_effects: diag(2695, ts2.DiagnosticCategory.Error, "Left_side_of_comma_operator_is_unused_and_has_no_side_effects_2695", "Left side of comma operator is unused and has no side effects.", true),
      The_Object_type_is_assignable_to_very_few_other_types_Did_you_mean_to_use_the_any_type_instead: diag(2696, ts2.DiagnosticCategory.Error, "The_Object_type_is_assignable_to_very_few_other_types_Did_you_mean_to_use_the_any_type_instead_2696", "The 'Object' type is assignable to very few other types. Did you mean to use the 'any' type instead?"),
      An_async_function_or_method_must_return_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES2015_in_your_lib_option: diag(2697, ts2.DiagnosticCategory.Error, "An_async_function_or_method_must_return_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_in_2697", "An async function or method must return a 'Promise'. Make sure you have a declaration for 'Promise' or include 'ES2015' in your '--lib' option."),
      Spread_types_may_only_be_created_from_object_types: diag(2698, ts2.DiagnosticCategory.Error, "Spread_types_may_only_be_created_from_object_types_2698", "Spread types may only be created from object types."),
      Static_property_0_conflicts_with_built_in_property_Function_0_of_constructor_function_1: diag(2699, ts2.DiagnosticCategory.Error, "Static_property_0_conflicts_with_built_in_property_Function_0_of_constructor_function_1_2699", "Static property '{0}' conflicts with built-in property 'Function.{0}' of constructor function '{1}'."),
      Rest_types_may_only_be_created_from_object_types: diag(2700, ts2.DiagnosticCategory.Error, "Rest_types_may_only_be_created_from_object_types_2700", "Rest types may only be created from object types."),
      The_target_of_an_object_rest_assignment_must_be_a_variable_or_a_property_access: diag(2701, ts2.DiagnosticCategory.Error, "The_target_of_an_object_rest_assignment_must_be_a_variable_or_a_property_access_2701", "The target of an object rest assignment must be a variable or a property access."),
      _0_only_refers_to_a_type_but_is_being_used_as_a_namespace_here: diag(2702, ts2.DiagnosticCategory.Error, "_0_only_refers_to_a_type_but_is_being_used_as_a_namespace_here_2702", "'{0}' only refers to a type, but is being used as a namespace here."),
      The_operand_of_a_delete_operator_must_be_a_property_reference: diag(2703, ts2.DiagnosticCategory.Error, "The_operand_of_a_delete_operator_must_be_a_property_reference_2703", "The operand of a 'delete' operator must be a property reference."),
      The_operand_of_a_delete_operator_cannot_be_a_read_only_property: diag(2704, ts2.DiagnosticCategory.Error, "The_operand_of_a_delete_operator_cannot_be_a_read_only_property_2704", "The operand of a 'delete' operator cannot be a read-only property."),
      An_async_function_or_method_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declaration_for_the_Promise_constructor_or_include_ES2015_in_your_lib_option: diag(2705, ts2.DiagnosticCategory.Error, "An_async_function_or_method_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_de_2705", "An async function or method in ES5/ES3 requires the 'Promise' constructor.  Make sure you have a declaration for the 'Promise' constructor or include 'ES2015' in your '--lib' option."),
      Required_type_parameters_may_not_follow_optional_type_parameters: diag(2706, ts2.DiagnosticCategory.Error, "Required_type_parameters_may_not_follow_optional_type_parameters_2706", "Required type parameters may not follow optional type parameters."),
      Generic_type_0_requires_between_1_and_2_type_arguments: diag(2707, ts2.DiagnosticCategory.Error, "Generic_type_0_requires_between_1_and_2_type_arguments_2707", "Generic type '{0}' requires between {1} and {2} type arguments."),
      Cannot_use_namespace_0_as_a_value: diag(2708, ts2.DiagnosticCategory.Error, "Cannot_use_namespace_0_as_a_value_2708", "Cannot use namespace '{0}' as a value."),
      Cannot_use_namespace_0_as_a_type: diag(2709, ts2.DiagnosticCategory.Error, "Cannot_use_namespace_0_as_a_type_2709", "Cannot use namespace '{0}' as a type."),
      _0_are_specified_twice_The_attribute_named_0_will_be_overwritten: diag(2710, ts2.DiagnosticCategory.Error, "_0_are_specified_twice_The_attribute_named_0_will_be_overwritten_2710", "'{0}' are specified twice. The attribute named '{0}' will be overwritten."),
      A_dynamic_import_call_returns_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES2015_in_your_lib_option: diag(2711, ts2.DiagnosticCategory.Error, "A_dynamic_import_call_returns_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES20_2711", "A dynamic import call returns a 'Promise'. Make sure you have a declaration for 'Promise' or include 'ES2015' in your '--lib' option."),
      A_dynamic_import_call_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declaration_for_the_Promise_constructor_or_include_ES2015_in_your_lib_option: diag(2712, ts2.DiagnosticCategory.Error, "A_dynamic_import_call_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declarat_2712", "A dynamic import call in ES5/ES3 requires the 'Promise' constructor.  Make sure you have a declaration for the 'Promise' constructor or include 'ES2015' in your '--lib' option."),
      Cannot_access_0_1_because_0_is_a_type_but_not_a_namespace_Did_you_mean_to_retrieve_the_type_of_the_property_1_in_0_with_0_1: diag(2713, ts2.DiagnosticCategory.Error, "Cannot_access_0_1_because_0_is_a_type_but_not_a_namespace_Did_you_mean_to_retrieve_the_type_of_the_p_2713", `Cannot access '{0}.{1}' because '{0}' is a type, but not a namespace. Did you mean to retrieve the type of the property '{1}' in '{0}' with '{0}["{1}"]'?`),
      The_expression_of_an_export_assignment_must_be_an_identifier_or_qualified_name_in_an_ambient_context: diag(2714, ts2.DiagnosticCategory.Error, "The_expression_of_an_export_assignment_must_be_an_identifier_or_qualified_name_in_an_ambient_context_2714", "The expression of an export assignment must be an identifier or qualified name in an ambient context."),
      Abstract_property_0_in_class_1_cannot_be_accessed_in_the_constructor: diag(2715, ts2.DiagnosticCategory.Error, "Abstract_property_0_in_class_1_cannot_be_accessed_in_the_constructor_2715", "Abstract property '{0}' in class '{1}' cannot be accessed in the constructor."),
      Type_parameter_0_has_a_circular_default: diag(2716, ts2.DiagnosticCategory.Error, "Type_parameter_0_has_a_circular_default_2716", "Type parameter '{0}' has a circular default."),
      Subsequent_property_declarations_must_have_the_same_type_Property_0_must_be_of_type_1_but_here_has_type_2: diag(2717, ts2.DiagnosticCategory.Error, "Subsequent_property_declarations_must_have_the_same_type_Property_0_must_be_of_type_1_but_here_has_t_2717", "Subsequent property declarations must have the same type.  Property '{0}' must be of type '{1}', but here has type '{2}'."),
      Duplicate_property_0: diag(2718, ts2.DiagnosticCategory.Error, "Duplicate_property_0_2718", "Duplicate property '{0}'."),
      Type_0_is_not_assignable_to_type_1_Two_different_types_with_this_name_exist_but_they_are_unrelated: diag(2719, ts2.DiagnosticCategory.Error, "Type_0_is_not_assignable_to_type_1_Two_different_types_with_this_name_exist_but_they_are_unrelated_2719", "Type '{0}' is not assignable to type '{1}'. Two different types with this name exist, but they are unrelated."),
      Class_0_incorrectly_implements_class_1_Did_you_mean_to_extend_1_and_inherit_its_members_as_a_subclass: diag(2720, ts2.DiagnosticCategory.Error, "Class_0_incorrectly_implements_class_1_Did_you_mean_to_extend_1_and_inherit_its_members_as_a_subclas_2720", "Class '{0}' incorrectly implements class '{1}'. Did you mean to extend '{1}' and inherit its members as a subclass?"),
      Cannot_invoke_an_object_which_is_possibly_null: diag(2721, ts2.DiagnosticCategory.Error, "Cannot_invoke_an_object_which_is_possibly_null_2721", "Cannot invoke an object which is possibly 'null'."),
      Cannot_invoke_an_object_which_is_possibly_undefined: diag(2722, ts2.DiagnosticCategory.Error, "Cannot_invoke_an_object_which_is_possibly_undefined_2722", "Cannot invoke an object which is possibly 'undefined'."),
      Cannot_invoke_an_object_which_is_possibly_null_or_undefined: diag(2723, ts2.DiagnosticCategory.Error, "Cannot_invoke_an_object_which_is_possibly_null_or_undefined_2723", "Cannot invoke an object which is possibly 'null' or 'undefined'."),
      _0_has_no_exported_member_named_1_Did_you_mean_2: diag(2724, ts2.DiagnosticCategory.Error, "_0_has_no_exported_member_named_1_Did_you_mean_2_2724", "'{0}' has no exported member named '{1}'. Did you mean '{2}'?"),
      Class_name_cannot_be_Object_when_targeting_ES5_with_module_0: diag(2725, ts2.DiagnosticCategory.Error, "Class_name_cannot_be_Object_when_targeting_ES5_with_module_0_2725", "Class name cannot be 'Object' when targeting ES5 with module {0}."),
      Cannot_find_lib_definition_for_0: diag(2726, ts2.DiagnosticCategory.Error, "Cannot_find_lib_definition_for_0_2726", "Cannot find lib definition for '{0}'."),
      Cannot_find_lib_definition_for_0_Did_you_mean_1: diag(2727, ts2.DiagnosticCategory.Error, "Cannot_find_lib_definition_for_0_Did_you_mean_1_2727", "Cannot find lib definition for '{0}'. Did you mean '{1}'?"),
      _0_is_declared_here: diag(2728, ts2.DiagnosticCategory.Message, "_0_is_declared_here_2728", "'{0}' is declared here."),
      Property_0_is_used_before_its_initialization: diag(2729, ts2.DiagnosticCategory.Error, "Property_0_is_used_before_its_initialization_2729", "Property '{0}' is used before its initialization."),
      An_arrow_function_cannot_have_a_this_parameter: diag(2730, ts2.DiagnosticCategory.Error, "An_arrow_function_cannot_have_a_this_parameter_2730", "An arrow function cannot have a 'this' parameter."),
      Implicit_conversion_of_a_symbol_to_a_string_will_fail_at_runtime_Consider_wrapping_this_expression_in_String: diag(2731, ts2.DiagnosticCategory.Error, "Implicit_conversion_of_a_symbol_to_a_string_will_fail_at_runtime_Consider_wrapping_this_expression_i_2731", "Implicit conversion of a 'symbol' to a 'string' will fail at runtime. Consider wrapping this expression in 'String(...)'."),
      Cannot_find_module_0_Consider_using_resolveJsonModule_to_import_module_with_json_extension: diag(2732, ts2.DiagnosticCategory.Error, "Cannot_find_module_0_Consider_using_resolveJsonModule_to_import_module_with_json_extension_2732", "Cannot find module '{0}'. Consider using '--resolveJsonModule' to import module with '.json' extension."),
      Property_0_was_also_declared_here: diag(2733, ts2.DiagnosticCategory.Error, "Property_0_was_also_declared_here_2733", "Property '{0}' was also declared here."),
      Are_you_missing_a_semicolon: diag(2734, ts2.DiagnosticCategory.Error, "Are_you_missing_a_semicolon_2734", "Are you missing a semicolon?"),
      Did_you_mean_for_0_to_be_constrained_to_type_new_args_Colon_any_1: diag(2735, ts2.DiagnosticCategory.Error, "Did_you_mean_for_0_to_be_constrained_to_type_new_args_Colon_any_1_2735", "Did you mean for '{0}' to be constrained to type 'new (...args: any[]) => {1}'?"),
      Operator_0_cannot_be_applied_to_type_1: diag(2736, ts2.DiagnosticCategory.Error, "Operator_0_cannot_be_applied_to_type_1_2736", "Operator '{0}' cannot be applied to type '{1}'."),
      BigInt_literals_are_not_available_when_targeting_lower_than_ES2020: diag(2737, ts2.DiagnosticCategory.Error, "BigInt_literals_are_not_available_when_targeting_lower_than_ES2020_2737", "BigInt literals are not available when targeting lower than ES2020."),
      An_outer_value_of_this_is_shadowed_by_this_container: diag(2738, ts2.DiagnosticCategory.Message, "An_outer_value_of_this_is_shadowed_by_this_container_2738", "An outer value of 'this' is shadowed by this container."),
      Type_0_is_missing_the_following_properties_from_type_1_Colon_2: diag(2739, ts2.DiagnosticCategory.Error, "Type_0_is_missing_the_following_properties_from_type_1_Colon_2_2739", "Type '{0}' is missing the following properties from type '{1}': {2}"),
      Type_0_is_missing_the_following_properties_from_type_1_Colon_2_and_3_more: diag(2740, ts2.DiagnosticCategory.Error, "Type_0_is_missing_the_following_properties_from_type_1_Colon_2_and_3_more_2740", "Type '{0}' is missing the following properties from type '{1}': {2}, and {3} more."),
      Property_0_is_missing_in_type_1_but_required_in_type_2: diag(2741, ts2.DiagnosticCategory.Error, "Property_0_is_missing_in_type_1_but_required_in_type_2_2741", "Property '{0}' is missing in type '{1}' but required in type '{2}'."),
      The_inferred_type_of_0_cannot_be_named_without_a_reference_to_1_This_is_likely_not_portable_A_type_annotation_is_necessary: diag(2742, ts2.DiagnosticCategory.Error, "The_inferred_type_of_0_cannot_be_named_without_a_reference_to_1_This_is_likely_not_portable_A_type_a_2742", "The inferred type of '{0}' cannot be named without a reference to '{1}'. This is likely not portable. A type annotation is necessary."),
      No_overload_expects_0_type_arguments_but_overloads_do_exist_that_expect_either_1_or_2_type_arguments: diag(2743, ts2.DiagnosticCategory.Error, "No_overload_expects_0_type_arguments_but_overloads_do_exist_that_expect_either_1_or_2_type_arguments_2743", "No overload expects {0} type arguments, but overloads do exist that expect either {1} or {2} type arguments."),
      Type_parameter_defaults_can_only_reference_previously_declared_type_parameters: diag(2744, ts2.DiagnosticCategory.Error, "Type_parameter_defaults_can_only_reference_previously_declared_type_parameters_2744", "Type parameter defaults can only reference previously declared type parameters."),
      This_JSX_tag_s_0_prop_expects_type_1_which_requires_multiple_children_but_only_a_single_child_was_provided: diag(2745, ts2.DiagnosticCategory.Error, "This_JSX_tag_s_0_prop_expects_type_1_which_requires_multiple_children_but_only_a_single_child_was_pr_2745", "This JSX tag's '{0}' prop expects type '{1}' which requires multiple children, but only a single child was provided."),
      This_JSX_tag_s_0_prop_expects_a_single_child_of_type_1_but_multiple_children_were_provided: diag(2746, ts2.DiagnosticCategory.Error, "This_JSX_tag_s_0_prop_expects_a_single_child_of_type_1_but_multiple_children_were_provided_2746", "This JSX tag's '{0}' prop expects a single child of type '{1}', but multiple children were provided."),
      _0_components_don_t_accept_text_as_child_elements_Text_in_JSX_has_the_type_string_but_the_expected_type_of_1_is_2: diag(2747, ts2.DiagnosticCategory.Error, "_0_components_don_t_accept_text_as_child_elements_Text_in_JSX_has_the_type_string_but_the_expected_t_2747", "'{0}' components don't accept text as child elements. Text in JSX has the type 'string', but the expected type of '{1}' is '{2}'."),
      Cannot_access_ambient_const_enums_when_the_isolatedModules_flag_is_provided: diag(2748, ts2.DiagnosticCategory.Error, "Cannot_access_ambient_const_enums_when_the_isolatedModules_flag_is_provided_2748", "Cannot access ambient const enums when the '--isolatedModules' flag is provided."),
      _0_refers_to_a_value_but_is_being_used_as_a_type_here_Did_you_mean_typeof_0: diag(2749, ts2.DiagnosticCategory.Error, "_0_refers_to_a_value_but_is_being_used_as_a_type_here_Did_you_mean_typeof_0_2749", "'{0}' refers to a value, but is being used as a type here. Did you mean 'typeof {0}'?"),
      The_implementation_signature_is_declared_here: diag(2750, ts2.DiagnosticCategory.Error, "The_implementation_signature_is_declared_here_2750", "The implementation signature is declared here."),
      Circularity_originates_in_type_at_this_location: diag(2751, ts2.DiagnosticCategory.Error, "Circularity_originates_in_type_at_this_location_2751", "Circularity originates in type at this location."),
      The_first_export_default_is_here: diag(2752, ts2.DiagnosticCategory.Error, "The_first_export_default_is_here_2752", "The first export default is here."),
      Another_export_default_is_here: diag(2753, ts2.DiagnosticCategory.Error, "Another_export_default_is_here_2753", "Another export default is here."),
      super_may_not_use_type_arguments: diag(2754, ts2.DiagnosticCategory.Error, "super_may_not_use_type_arguments_2754", "'super' may not use type arguments."),
      No_constituent_of_type_0_is_callable: diag(2755, ts2.DiagnosticCategory.Error, "No_constituent_of_type_0_is_callable_2755", "No constituent of type '{0}' is callable."),
      Not_all_constituents_of_type_0_are_callable: diag(2756, ts2.DiagnosticCategory.Error, "Not_all_constituents_of_type_0_are_callable_2756", "Not all constituents of type '{0}' are callable."),
      Type_0_has_no_call_signatures: diag(2757, ts2.DiagnosticCategory.Error, "Type_0_has_no_call_signatures_2757", "Type '{0}' has no call signatures."),
      Each_member_of_the_union_type_0_has_signatures_but_none_of_those_signatures_are_compatible_with_each_other: diag(2758, ts2.DiagnosticCategory.Error, "Each_member_of_the_union_type_0_has_signatures_but_none_of_those_signatures_are_compatible_with_each_2758", "Each member of the union type '{0}' has signatures, but none of those signatures are compatible with each other."),
      No_constituent_of_type_0_is_constructable: diag(2759, ts2.DiagnosticCategory.Error, "No_constituent_of_type_0_is_constructable_2759", "No constituent of type '{0}' is constructable."),
      Not_all_constituents_of_type_0_are_constructable: diag(2760, ts2.DiagnosticCategory.Error, "Not_all_constituents_of_type_0_are_constructable_2760", "Not all constituents of type '{0}' are constructable."),
      Type_0_has_no_construct_signatures: diag(2761, ts2.DiagnosticCategory.Error, "Type_0_has_no_construct_signatures_2761", "Type '{0}' has no construct signatures."),
      Each_member_of_the_union_type_0_has_construct_signatures_but_none_of_those_signatures_are_compatible_with_each_other: diag(2762, ts2.DiagnosticCategory.Error, "Each_member_of_the_union_type_0_has_construct_signatures_but_none_of_those_signatures_are_compatible_2762", "Each member of the union type '{0}' has construct signatures, but none of those signatures are compatible with each other."),
      Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_for_of_will_always_send_0: diag(2763, ts2.DiagnosticCategory.Error, "Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_for_of_will_always_s_2763", "Cannot iterate value because the 'next' method of its iterator expects type '{1}', but for-of will always send '{0}'."),
      Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_spread_will_always_send_0: diag(2764, ts2.DiagnosticCategory.Error, "Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_spread_will_al_2764", "Cannot iterate value because the 'next' method of its iterator expects type '{1}', but array spread will always send '{0}'."),
      Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_destructuring_will_always_send_0: diag(2765, ts2.DiagnosticCategory.Error, "Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_destructuring__2765", "Cannot iterate value because the 'next' method of its iterator expects type '{1}', but array destructuring will always send '{0}'."),
      Cannot_delegate_iteration_to_value_because_the_next_method_of_its_iterator_expects_type_1_but_the_containing_generator_will_always_send_0: diag(2766, ts2.DiagnosticCategory.Error, "Cannot_delegate_iteration_to_value_because_the_next_method_of_its_iterator_expects_type_1_but_the_co_2766", "Cannot delegate iteration to value because the 'next' method of its iterator expects type '{1}', but the containing generator will always send '{0}'."),
      The_0_property_of_an_iterator_must_be_a_method: diag(2767, ts2.DiagnosticCategory.Error, "The_0_property_of_an_iterator_must_be_a_method_2767", "The '{0}' property of an iterator must be a method."),
      The_0_property_of_an_async_iterator_must_be_a_method: diag(2768, ts2.DiagnosticCategory.Error, "The_0_property_of_an_async_iterator_must_be_a_method_2768", "The '{0}' property of an async iterator must be a method."),
      No_overload_matches_this_call: diag(2769, ts2.DiagnosticCategory.Error, "No_overload_matches_this_call_2769", "No overload matches this call."),
      The_last_overload_gave_the_following_error: diag(2770, ts2.DiagnosticCategory.Error, "The_last_overload_gave_the_following_error_2770", "The last overload gave the following error."),
      The_last_overload_is_declared_here: diag(2771, ts2.DiagnosticCategory.Error, "The_last_overload_is_declared_here_2771", "The last overload is declared here."),
      Overload_0_of_1_2_gave_the_following_error: diag(2772, ts2.DiagnosticCategory.Error, "Overload_0_of_1_2_gave_the_following_error_2772", "Overload {0} of {1}, '{2}', gave the following error."),
      Did_you_forget_to_use_await: diag(2773, ts2.DiagnosticCategory.Error, "Did_you_forget_to_use_await_2773", "Did you forget to use 'await'?"),
      This_condition_will_always_return_true_since_this_function_is_always_defined_Did_you_mean_to_call_it_instead: diag(2774, ts2.DiagnosticCategory.Error, "This_condition_will_always_return_true_since_this_function_is_always_defined_Did_you_mean_to_call_it_2774", "This condition will always return true since this function is always defined. Did you mean to call it instead?"),
      Assertions_require_every_name_in_the_call_target_to_be_declared_with_an_explicit_type_annotation: diag(2775, ts2.DiagnosticCategory.Error, "Assertions_require_every_name_in_the_call_target_to_be_declared_with_an_explicit_type_annotation_2775", "Assertions require every name in the call target to be declared with an explicit type annotation."),
      Assertions_require_the_call_target_to_be_an_identifier_or_qualified_name: diag(2776, ts2.DiagnosticCategory.Error, "Assertions_require_the_call_target_to_be_an_identifier_or_qualified_name_2776", "Assertions require the call target to be an identifier or qualified name."),
      The_operand_of_an_increment_or_decrement_operator_may_not_be_an_optional_property_access: diag(2777, ts2.DiagnosticCategory.Error, "The_operand_of_an_increment_or_decrement_operator_may_not_be_an_optional_property_access_2777", "The operand of an increment or decrement operator may not be an optional property access."),
      The_target_of_an_object_rest_assignment_may_not_be_an_optional_property_access: diag(2778, ts2.DiagnosticCategory.Error, "The_target_of_an_object_rest_assignment_may_not_be_an_optional_property_access_2778", "The target of an object rest assignment may not be an optional property access."),
      The_left_hand_side_of_an_assignment_expression_may_not_be_an_optional_property_access: diag(2779, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_an_assignment_expression_may_not_be_an_optional_property_access_2779", "The left-hand side of an assignment expression may not be an optional property access."),
      The_left_hand_side_of_a_for_in_statement_may_not_be_an_optional_property_access: diag(2780, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_may_not_be_an_optional_property_access_2780", "The left-hand side of a 'for...in' statement may not be an optional property access."),
      The_left_hand_side_of_a_for_of_statement_may_not_be_an_optional_property_access: diag(2781, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_of_statement_may_not_be_an_optional_property_access_2781", "The left-hand side of a 'for...of' statement may not be an optional property access."),
      _0_needs_an_explicit_type_annotation: diag(2782, ts2.DiagnosticCategory.Message, "_0_needs_an_explicit_type_annotation_2782", "'{0}' needs an explicit type annotation."),
      _0_is_specified_more_than_once_so_this_usage_will_be_overwritten: diag(2783, ts2.DiagnosticCategory.Error, "_0_is_specified_more_than_once_so_this_usage_will_be_overwritten_2783", "'{0}' is specified more than once, so this usage will be overwritten."),
      get_and_set_accessors_cannot_declare_this_parameters: diag(2784, ts2.DiagnosticCategory.Error, "get_and_set_accessors_cannot_declare_this_parameters_2784", "'get' and 'set' accessors cannot declare 'this' parameters."),
      This_spread_always_overwrites_this_property: diag(2785, ts2.DiagnosticCategory.Error, "This_spread_always_overwrites_this_property_2785", "This spread always overwrites this property."),
      _0_cannot_be_used_as_a_JSX_component: diag(2786, ts2.DiagnosticCategory.Error, "_0_cannot_be_used_as_a_JSX_component_2786", "'{0}' cannot be used as a JSX component."),
      Its_return_type_0_is_not_a_valid_JSX_element: diag(2787, ts2.DiagnosticCategory.Error, "Its_return_type_0_is_not_a_valid_JSX_element_2787", "Its return type '{0}' is not a valid JSX element."),
      Its_instance_type_0_is_not_a_valid_JSX_element: diag(2788, ts2.DiagnosticCategory.Error, "Its_instance_type_0_is_not_a_valid_JSX_element_2788", "Its instance type '{0}' is not a valid JSX element."),
      Its_element_type_0_is_not_a_valid_JSX_element: diag(2789, ts2.DiagnosticCategory.Error, "Its_element_type_0_is_not_a_valid_JSX_element_2789", "Its element type '{0}' is not a valid JSX element."),
      The_operand_of_a_delete_operator_must_be_optional: diag(2790, ts2.DiagnosticCategory.Error, "The_operand_of_a_delete_operator_must_be_optional_2790", "The operand of a 'delete' operator must be optional."),
      Exponentiation_cannot_be_performed_on_bigint_values_unless_the_target_option_is_set_to_es2016_or_later: diag(2791, ts2.DiagnosticCategory.Error, "Exponentiation_cannot_be_performed_on_bigint_values_unless_the_target_option_is_set_to_es2016_or_lat_2791", "Exponentiation cannot be performed on 'bigint' values unless the 'target' option is set to 'es2016' or later."),
      Cannot_find_module_0_Did_you_mean_to_set_the_moduleResolution_option_to_node_or_to_add_aliases_to_the_paths_option: diag(2792, ts2.DiagnosticCategory.Error, "Cannot_find_module_0_Did_you_mean_to_set_the_moduleResolution_option_to_node_or_to_add_aliases_to_th_2792", "Cannot find module '{0}'. Did you mean to set the 'moduleResolution' option to 'node', or to add aliases to the 'paths' option?"),
      The_call_would_have_succeeded_against_this_implementation_but_implementation_signatures_of_overloads_are_not_externally_visible: diag(2793, ts2.DiagnosticCategory.Error, "The_call_would_have_succeeded_against_this_implementation_but_implementation_signatures_of_overloads_2793", "The call would have succeeded against this implementation, but implementation signatures of overloads are not externally visible."),
      Expected_0_arguments_but_got_1_Did_you_forget_to_include_void_in_your_type_argument_to_Promise: diag(2794, ts2.DiagnosticCategory.Error, "Expected_0_arguments_but_got_1_Did_you_forget_to_include_void_in_your_type_argument_to_Promise_2794", "Expected {0} arguments, but got {1}. Did you forget to include 'void' in your type argument to 'Promise'?"),
      The_intrinsic_keyword_can_only_be_used_to_declare_compiler_provided_intrinsic_types: diag(2795, ts2.DiagnosticCategory.Error, "The_intrinsic_keyword_can_only_be_used_to_declare_compiler_provided_intrinsic_types_2795", "The 'intrinsic' keyword can only be used to declare compiler provided intrinsic types."),
      It_is_likely_that_you_are_missing_a_comma_to_separate_these_two_template_expressions_They_form_a_tagged_template_expression_which_cannot_be_invoked: diag(2796, ts2.DiagnosticCategory.Error, "It_is_likely_that_you_are_missing_a_comma_to_separate_these_two_template_expressions_They_form_a_tag_2796", "It is likely that you are missing a comma to separate these two template expressions. They form a tagged template expression which cannot be invoked."),
      A_mixin_class_that_extends_from_a_type_variable_containing_an_abstract_construct_signature_must_also_be_declared_abstract: diag(2797, ts2.DiagnosticCategory.Error, "A_mixin_class_that_extends_from_a_type_variable_containing_an_abstract_construct_signature_must_also_2797", "A mixin class that extends from a type variable containing an abstract construct signature must also be declared 'abstract'."),
      The_declaration_was_marked_as_deprecated_here: diag(2798, ts2.DiagnosticCategory.Error, "The_declaration_was_marked_as_deprecated_here_2798", "The declaration was marked as deprecated here."),
      Type_produces_a_tuple_type_that_is_too_large_to_represent: diag(2799, ts2.DiagnosticCategory.Error, "Type_produces_a_tuple_type_that_is_too_large_to_represent_2799", "Type produces a tuple type that is too large to represent."),
      Expression_produces_a_tuple_type_that_is_too_large_to_represent: diag(2800, ts2.DiagnosticCategory.Error, "Expression_produces_a_tuple_type_that_is_too_large_to_represent_2800", "Expression produces a tuple type that is too large to represent."),
      This_condition_will_always_return_true_since_this_0_is_always_defined: diag(2801, ts2.DiagnosticCategory.Error, "This_condition_will_always_return_true_since_this_0_is_always_defined_2801", "This condition will always return true since this '{0}' is always defined."),
      Type_0_can_only_be_iterated_through_when_using_the_downlevelIteration_flag_or_with_a_target_of_es2015_or_higher: diag(2802, ts2.DiagnosticCategory.Error, "Type_0_can_only_be_iterated_through_when_using_the_downlevelIteration_flag_or_with_a_target_of_es201_2802", "Type '{0}' can only be iterated through when using the '--downlevelIteration' flag or with a '--target' of 'es2015' or higher."),
      Cannot_assign_to_private_method_0_Private_methods_are_not_writable: diag(2803, ts2.DiagnosticCategory.Error, "Cannot_assign_to_private_method_0_Private_methods_are_not_writable_2803", "Cannot assign to private method '{0}'. Private methods are not writable."),
      Duplicate_identifier_0_Static_and_instance_elements_cannot_share_the_same_private_name: diag(2804, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_Static_and_instance_elements_cannot_share_the_same_private_name_2804", "Duplicate identifier '{0}'. Static and instance elements cannot share the same private name."),
      Static_fields_with_private_names_can_t_have_initializers_when_the_useDefineForClassFields_flag_is_not_specified_with_a_target_of_esnext_Consider_adding_the_useDefineForClassFields_flag: diag(2805, ts2.DiagnosticCategory.Error, "Static_fields_with_private_names_can_t_have_initializers_when_the_useDefineForClassFields_flag_is_no_2805", "Static fields with private names can't have initializers when the '--useDefineForClassFields' flag is not specified with a '--target' of 'esnext'. Consider adding the '--useDefineForClassFields' flag."),
      Private_accessor_was_defined_without_a_getter: diag(2806, ts2.DiagnosticCategory.Error, "Private_accessor_was_defined_without_a_getter_2806", "Private accessor was defined without a getter."),
      This_syntax_requires_an_imported_helper_named_1_with_2_parameters_which_is_not_compatible_with_the_one_in_0_Consider_upgrading_your_version_of_0: diag(2807, ts2.DiagnosticCategory.Error, "This_syntax_requires_an_imported_helper_named_1_with_2_parameters_which_is_not_compatible_with_the_o_2807", "This syntax requires an imported helper named '{1}' with {2} parameters, which is not compatible with the one in '{0}'. Consider upgrading your version of '{0}'."),
      A_get_accessor_must_be_at_least_as_accessible_as_the_setter: diag(2808, ts2.DiagnosticCategory.Error, "A_get_accessor_must_be_at_least_as_accessible_as_the_setter_2808", "A get accessor must be at least as accessible as the setter"),
      Declaration_or_statement_expected_This_follows_a_block_of_statements_so_if_you_intended_to_write_a_destructuring_assignment_you_might_need_to_wrap_the_the_whole_assignment_in_parentheses: diag(2809, ts2.DiagnosticCategory.Error, "Declaration_or_statement_expected_This_follows_a_block_of_statements_so_if_you_intended_to_write_a_d_2809", "Declaration or statement expected. This '=' follows a block of statements, so if you intended to write a destructuring assignment, you might need to wrap the the whole assignment in parentheses."),
      Property_0_may_not_be_used_in_a_static_property_s_initializer_in_the_same_class_when_target_is_esnext_and_useDefineForClassFields_is_false: diag(2810, ts2.DiagnosticCategory.Error, "Property_0_may_not_be_used_in_a_static_property_s_initializer_in_the_same_class_when_target_is_esnex_2810", "Property '{0}' may not be used in a static property's initializer in the same class when 'target' is 'esnext' and 'useDefineForClassFields' is 'false'."),
      Initializer_for_property_0: diag(2811, ts2.DiagnosticCategory.Error, "Initializer_for_property_0_2811", "Initializer for property '{0}'"),
      Property_0_does_not_exist_on_type_1_Try_changing_the_lib_compiler_option_to_include_dom: diag(2812, ts2.DiagnosticCategory.Error, "Property_0_does_not_exist_on_type_1_Try_changing_the_lib_compiler_option_to_include_dom_2812", "Property '{0}' does not exist on type '{1}'. Try changing the 'lib' compiler option to include 'dom'."),
      Class_declaration_cannot_implement_overload_list_for_0: diag(2813, ts2.DiagnosticCategory.Error, "Class_declaration_cannot_implement_overload_list_for_0_2813", "Class declaration cannot implement overload list for '{0}'."),
      Function_with_bodies_can_only_merge_with_classes_that_are_ambient: diag(2814, ts2.DiagnosticCategory.Error, "Function_with_bodies_can_only_merge_with_classes_that_are_ambient_2814", "Function with bodies can only merge with classes that are ambient."),
      arguments_cannot_be_referenced_in_property_initializers: diag(2815, ts2.DiagnosticCategory.Error, "arguments_cannot_be_referenced_in_property_initializers_2815", "'arguments' cannot be referenced in property initializers."),
      Cannot_use_this_in_a_static_property_initializer_of_a_decorated_class: diag(2816, ts2.DiagnosticCategory.Error, "Cannot_use_this_in_a_static_property_initializer_of_a_decorated_class_2816", "Cannot use 'this' in a static property initializer of a decorated class."),
      Property_0_has_no_initializer_and_is_not_definitely_assigned_in_a_class_static_block: diag(2817, ts2.DiagnosticCategory.Error, "Property_0_has_no_initializer_and_is_not_definitely_assigned_in_a_class_static_block_2817", "Property '{0}' has no initializer and is not definitely assigned in a class static block."),
      Duplicate_identifier_0_Compiler_reserves_name_1_when_emitting_super_references_in_static_initializers: diag(2818, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_Compiler_reserves_name_1_when_emitting_super_references_in_static_initializer_2818", "Duplicate identifier '{0}'. Compiler reserves name '{1}' when emitting 'super' references in static initializers."),
      Namespace_name_cannot_be_0: diag(2819, ts2.DiagnosticCategory.Error, "Namespace_name_cannot_be_0_2819", "Namespace name cannot be '{0}'."),
      Import_declaration_0_is_using_private_name_1: diag(4e3, ts2.DiagnosticCategory.Error, "Import_declaration_0_is_using_private_name_1_4000", "Import declaration '{0}' is using private name '{1}'."),
      Type_parameter_0_of_exported_class_has_or_is_using_private_name_1: diag(4002, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_exported_class_has_or_is_using_private_name_1_4002", "Type parameter '{0}' of exported class has or is using private name '{1}'."),
      Type_parameter_0_of_exported_interface_has_or_is_using_private_name_1: diag(4004, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_exported_interface_has_or_is_using_private_name_1_4004", "Type parameter '{0}' of exported interface has or is using private name '{1}'."),
      Type_parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4006, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1_4006", "Type parameter '{0}' of constructor signature from exported interface has or is using private name '{1}'."),
      Type_parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4008, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1_4008", "Type parameter '{0}' of call signature from exported interface has or is using private name '{1}'."),
      Type_parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1: diag(4010, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1_4010", "Type parameter '{0}' of public static method from exported class has or is using private name '{1}'."),
      Type_parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1: diag(4012, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1_4012", "Type parameter '{0}' of public method from exported class has or is using private name '{1}'."),
      Type_parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1: diag(4014, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1_4014", "Type parameter '{0}' of method from exported interface has or is using private name '{1}'."),
      Type_parameter_0_of_exported_function_has_or_is_using_private_name_1: diag(4016, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_exported_function_has_or_is_using_private_name_1_4016", "Type parameter '{0}' of exported function has or is using private name '{1}'."),
      Implements_clause_of_exported_class_0_has_or_is_using_private_name_1: diag(4019, ts2.DiagnosticCategory.Error, "Implements_clause_of_exported_class_0_has_or_is_using_private_name_1_4019", "Implements clause of exported class '{0}' has or is using private name '{1}'."),
      extends_clause_of_exported_class_0_has_or_is_using_private_name_1: diag(4020, ts2.DiagnosticCategory.Error, "extends_clause_of_exported_class_0_has_or_is_using_private_name_1_4020", "'extends' clause of exported class '{0}' has or is using private name '{1}'."),
      extends_clause_of_exported_class_has_or_is_using_private_name_0: diag(4021, ts2.DiagnosticCategory.Error, "extends_clause_of_exported_class_has_or_is_using_private_name_0_4021", "'extends' clause of exported class has or is using private name '{0}'."),
      extends_clause_of_exported_interface_0_has_or_is_using_private_name_1: diag(4022, ts2.DiagnosticCategory.Error, "extends_clause_of_exported_interface_0_has_or_is_using_private_name_1_4022", "'extends' clause of exported interface '{0}' has or is using private name '{1}'."),
      Exported_variable_0_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4023, ts2.DiagnosticCategory.Error, "Exported_variable_0_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4023", "Exported variable '{0}' has or is using name '{1}' from external module {2} but cannot be named."),
      Exported_variable_0_has_or_is_using_name_1_from_private_module_2: diag(4024, ts2.DiagnosticCategory.Error, "Exported_variable_0_has_or_is_using_name_1_from_private_module_2_4024", "Exported variable '{0}' has or is using name '{1}' from private module '{2}'."),
      Exported_variable_0_has_or_is_using_private_name_1: diag(4025, ts2.DiagnosticCategory.Error, "Exported_variable_0_has_or_is_using_private_name_1_4025", "Exported variable '{0}' has or is using private name '{1}'."),
      Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4026, ts2.DiagnosticCategory.Error, "Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot__4026", "Public static property '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
      Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4027, ts2.DiagnosticCategory.Error, "Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4027", "Public static property '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
      Public_static_property_0_of_exported_class_has_or_is_using_private_name_1: diag(4028, ts2.DiagnosticCategory.Error, "Public_static_property_0_of_exported_class_has_or_is_using_private_name_1_4028", "Public static property '{0}' of exported class has or is using private name '{1}'."),
      Public_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4029, ts2.DiagnosticCategory.Error, "Public_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_name_4029", "Public property '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
      Public_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4030, ts2.DiagnosticCategory.Error, "Public_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4030", "Public property '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
      Public_property_0_of_exported_class_has_or_is_using_private_name_1: diag(4031, ts2.DiagnosticCategory.Error, "Public_property_0_of_exported_class_has_or_is_using_private_name_1_4031", "Public property '{0}' of exported class has or is using private name '{1}'."),
      Property_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4032, ts2.DiagnosticCategory.Error, "Property_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2_4032", "Property '{0}' of exported interface has or is using name '{1}' from private module '{2}'."),
      Property_0_of_exported_interface_has_or_is_using_private_name_1: diag(4033, ts2.DiagnosticCategory.Error, "Property_0_of_exported_interface_has_or_is_using_private_name_1_4033", "Property '{0}' of exported interface has or is using private name '{1}'."),
      Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4034, ts2.DiagnosticCategory.Error, "Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_name_1_from_private_mod_4034", "Parameter type of public static setter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
      Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_private_name_1: diag(4035, ts2.DiagnosticCategory.Error, "Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_private_name_1_4035", "Parameter type of public static setter '{0}' from exported class has or is using private name '{1}'."),
      Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4036, ts2.DiagnosticCategory.Error, "Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2_4036", "Parameter type of public setter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
      Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_private_name_1: diag(4037, ts2.DiagnosticCategory.Error, "Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_private_name_1_4037", "Parameter type of public setter '{0}' from exported class has or is using private name '{1}'."),
      Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4038, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_external_modul_4038", "Return type of public static getter '{0}' from exported class has or is using name '{1}' from external module {2} but cannot be named."),
      Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4039, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_4039", "Return type of public static getter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
      Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_private_name_1: diag(4040, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_private_name_1_4040", "Return type of public static getter '{0}' from exported class has or is using private name '{1}'."),
      Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4041, ts2.DiagnosticCategory.Error, "Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_4041", "Return type of public getter '{0}' from exported class has or is using name '{1}' from external module {2} but cannot be named."),
      Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4042, ts2.DiagnosticCategory.Error, "Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2_4042", "Return type of public getter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
      Return_type_of_public_getter_0_from_exported_class_has_or_is_using_private_name_1: diag(4043, ts2.DiagnosticCategory.Error, "Return_type_of_public_getter_0_from_exported_class_has_or_is_using_private_name_1_4043", "Return type of public getter '{0}' from exported class has or is using private name '{1}'."),
      Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4044, ts2.DiagnosticCategory.Error, "Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_name_0_from_private_mod_4044", "Return type of constructor signature from exported interface has or is using name '{0}' from private module '{1}'."),
      Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_0: diag(4045, ts2.DiagnosticCategory.Error, "Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_0_4045", "Return type of constructor signature from exported interface has or is using private name '{0}'."),
      Return_type_of_call_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4046, ts2.DiagnosticCategory.Error, "Return_type_of_call_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4046", "Return type of call signature from exported interface has or is using name '{0}' from private module '{1}'."),
      Return_type_of_call_signature_from_exported_interface_has_or_is_using_private_name_0: diag(4047, ts2.DiagnosticCategory.Error, "Return_type_of_call_signature_from_exported_interface_has_or_is_using_private_name_0_4047", "Return type of call signature from exported interface has or is using private name '{0}'."),
      Return_type_of_index_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4048, ts2.DiagnosticCategory.Error, "Return_type_of_index_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4048", "Return type of index signature from exported interface has or is using name '{0}' from private module '{1}'."),
      Return_type_of_index_signature_from_exported_interface_has_or_is_using_private_name_0: diag(4049, ts2.DiagnosticCategory.Error, "Return_type_of_index_signature_from_exported_interface_has_or_is_using_private_name_0_4049", "Return type of index signature from exported interface has or is using private name '{0}'."),
      Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: diag(4050, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_external_module__4050", "Return type of public static method from exported class has or is using name '{0}' from external module {1} but cannot be named."),
      Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_private_module_1: diag(4051, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_private_module_1_4051", "Return type of public static method from exported class has or is using name '{0}' from private module '{1}'."),
      Return_type_of_public_static_method_from_exported_class_has_or_is_using_private_name_0: diag(4052, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_method_from_exported_class_has_or_is_using_private_name_0_4052", "Return type of public static method from exported class has or is using private name '{0}'."),
      Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: diag(4053, ts2.DiagnosticCategory.Error, "Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_c_4053", "Return type of public method from exported class has or is using name '{0}' from external module {1} but cannot be named."),
      Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_private_module_1: diag(4054, ts2.DiagnosticCategory.Error, "Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_private_module_1_4054", "Return type of public method from exported class has or is using name '{0}' from private module '{1}'."),
      Return_type_of_public_method_from_exported_class_has_or_is_using_private_name_0: diag(4055, ts2.DiagnosticCategory.Error, "Return_type_of_public_method_from_exported_class_has_or_is_using_private_name_0_4055", "Return type of public method from exported class has or is using private name '{0}'."),
      Return_type_of_method_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4056, ts2.DiagnosticCategory.Error, "Return_type_of_method_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4056", "Return type of method from exported interface has or is using name '{0}' from private module '{1}'."),
      Return_type_of_method_from_exported_interface_has_or_is_using_private_name_0: diag(4057, ts2.DiagnosticCategory.Error, "Return_type_of_method_from_exported_interface_has_or_is_using_private_name_0_4057", "Return type of method from exported interface has or is using private name '{0}'."),
      Return_type_of_exported_function_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: diag(4058, ts2.DiagnosticCategory.Error, "Return_type_of_exported_function_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named_4058", "Return type of exported function has or is using name '{0}' from external module {1} but cannot be named."),
      Return_type_of_exported_function_has_or_is_using_name_0_from_private_module_1: diag(4059, ts2.DiagnosticCategory.Error, "Return_type_of_exported_function_has_or_is_using_name_0_from_private_module_1_4059", "Return type of exported function has or is using name '{0}' from private module '{1}'."),
      Return_type_of_exported_function_has_or_is_using_private_name_0: diag(4060, ts2.DiagnosticCategory.Error, "Return_type_of_exported_function_has_or_is_using_private_name_0_4060", "Return type of exported function has or is using private name '{0}'."),
      Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4061, ts2.DiagnosticCategory.Error, "Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_can_4061", "Parameter '{0}' of constructor from exported class has or is using name '{1}' from external module {2} but cannot be named."),
      Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4062, ts2.DiagnosticCategory.Error, "Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_private_module_2_4062", "Parameter '{0}' of constructor from exported class has or is using name '{1}' from private module '{2}'."),
      Parameter_0_of_constructor_from_exported_class_has_or_is_using_private_name_1: diag(4063, ts2.DiagnosticCategory.Error, "Parameter_0_of_constructor_from_exported_class_has_or_is_using_private_name_1_4063", "Parameter '{0}' of constructor from exported class has or is using private name '{1}'."),
      Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4064, ts2.DiagnosticCategory.Error, "Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_name_1_from_private_mod_4064", "Parameter '{0}' of constructor signature from exported interface has or is using name '{1}' from private module '{2}'."),
      Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4065, ts2.DiagnosticCategory.Error, "Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1_4065", "Parameter '{0}' of constructor signature from exported interface has or is using private name '{1}'."),
      Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4066, ts2.DiagnosticCategory.Error, "Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4066", "Parameter '{0}' of call signature from exported interface has or is using name '{1}' from private module '{2}'."),
      Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4067, ts2.DiagnosticCategory.Error, "Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1_4067", "Parameter '{0}' of call signature from exported interface has or is using private name '{1}'."),
      Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4068, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_external_module__4068", "Parameter '{0}' of public static method from exported class has or is using name '{1}' from external module {2} but cannot be named."),
      Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4069, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_private_module_2_4069", "Parameter '{0}' of public static method from exported class has or is using name '{1}' from private module '{2}'."),
      Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1: diag(4070, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1_4070", "Parameter '{0}' of public static method from exported class has or is using private name '{1}'."),
      Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4071, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_c_4071", "Parameter '{0}' of public method from exported class has or is using name '{1}' from external module {2} but cannot be named."),
      Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4072, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_private_module_2_4072", "Parameter '{0}' of public method from exported class has or is using name '{1}' from private module '{2}'."),
      Parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1: diag(4073, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1_4073", "Parameter '{0}' of public method from exported class has or is using private name '{1}'."),
      Parameter_0_of_method_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4074, ts2.DiagnosticCategory.Error, "Parameter_0_of_method_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4074", "Parameter '{0}' of method from exported interface has or is using name '{1}' from private module '{2}'."),
      Parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1: diag(4075, ts2.DiagnosticCategory.Error, "Parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1_4075", "Parameter '{0}' of method from exported interface has or is using private name '{1}'."),
      Parameter_0_of_exported_function_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4076, ts2.DiagnosticCategory.Error, "Parameter_0_of_exported_function_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4076", "Parameter '{0}' of exported function has or is using name '{1}' from external module {2} but cannot be named."),
      Parameter_0_of_exported_function_has_or_is_using_name_1_from_private_module_2: diag(4077, ts2.DiagnosticCategory.Error, "Parameter_0_of_exported_function_has_or_is_using_name_1_from_private_module_2_4077", "Parameter '{0}' of exported function has or is using name '{1}' from private module '{2}'."),
      Parameter_0_of_exported_function_has_or_is_using_private_name_1: diag(4078, ts2.DiagnosticCategory.Error, "Parameter_0_of_exported_function_has_or_is_using_private_name_1_4078", "Parameter '{0}' of exported function has or is using private name '{1}'."),
      Exported_type_alias_0_has_or_is_using_private_name_1: diag(4081, ts2.DiagnosticCategory.Error, "Exported_type_alias_0_has_or_is_using_private_name_1_4081", "Exported type alias '{0}' has or is using private name '{1}'."),
      Default_export_of_the_module_has_or_is_using_private_name_0: diag(4082, ts2.DiagnosticCategory.Error, "Default_export_of_the_module_has_or_is_using_private_name_0_4082", "Default export of the module has or is using private name '{0}'."),
      Type_parameter_0_of_exported_type_alias_has_or_is_using_private_name_1: diag(4083, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_exported_type_alias_has_or_is_using_private_name_1_4083", "Type parameter '{0}' of exported type alias has or is using private name '{1}'."),
      Exported_type_alias_0_has_or_is_using_private_name_1_from_module_2: diag(4084, ts2.DiagnosticCategory.Error, "Exported_type_alias_0_has_or_is_using_private_name_1_from_module_2_4084", "Exported type alias '{0}' has or is using private name '{1}' from module {2}."),
      Conflicting_definitions_for_0_found_at_1_and_2_Consider_installing_a_specific_version_of_this_library_to_resolve_the_conflict: diag(4090, ts2.DiagnosticCategory.Error, "Conflicting_definitions_for_0_found_at_1_and_2_Consider_installing_a_specific_version_of_this_librar_4090", "Conflicting definitions for '{0}' found at '{1}' and '{2}'. Consider installing a specific version of this library to resolve the conflict."),
      Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4091, ts2.DiagnosticCategory.Error, "Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4091", "Parameter '{0}' of index signature from exported interface has or is using name '{1}' from private module '{2}'."),
      Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4092, ts2.DiagnosticCategory.Error, "Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_private_name_1_4092", "Parameter '{0}' of index signature from exported interface has or is using private name '{1}'."),
      Property_0_of_exported_class_expression_may_not_be_private_or_protected: diag(4094, ts2.DiagnosticCategory.Error, "Property_0_of_exported_class_expression_may_not_be_private_or_protected_4094", "Property '{0}' of exported class expression may not be private or protected."),
      Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4095, ts2.DiagnosticCategory.Error, "Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_4095", "Public static method '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
      Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4096, ts2.DiagnosticCategory.Error, "Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4096", "Public static method '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
      Public_static_method_0_of_exported_class_has_or_is_using_private_name_1: diag(4097, ts2.DiagnosticCategory.Error, "Public_static_method_0_of_exported_class_has_or_is_using_private_name_1_4097", "Public static method '{0}' of exported class has or is using private name '{1}'."),
      Public_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4098, ts2.DiagnosticCategory.Error, "Public_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4098", "Public method '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
      Public_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4099, ts2.DiagnosticCategory.Error, "Public_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4099", "Public method '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
      Public_method_0_of_exported_class_has_or_is_using_private_name_1: diag(4100, ts2.DiagnosticCategory.Error, "Public_method_0_of_exported_class_has_or_is_using_private_name_1_4100", "Public method '{0}' of exported class has or is using private name '{1}'."),
      Method_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4101, ts2.DiagnosticCategory.Error, "Method_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2_4101", "Method '{0}' of exported interface has or is using name '{1}' from private module '{2}'."),
      Method_0_of_exported_interface_has_or_is_using_private_name_1: diag(4102, ts2.DiagnosticCategory.Error, "Method_0_of_exported_interface_has_or_is_using_private_name_1_4102", "Method '{0}' of exported interface has or is using private name '{1}'."),
      Type_parameter_0_of_exported_mapped_object_type_is_using_private_name_1: diag(4103, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_exported_mapped_object_type_is_using_private_name_1_4103", "Type parameter '{0}' of exported mapped object type is using private name '{1}'."),
      The_type_0_is_readonly_and_cannot_be_assigned_to_the_mutable_type_1: diag(4104, ts2.DiagnosticCategory.Error, "The_type_0_is_readonly_and_cannot_be_assigned_to_the_mutable_type_1_4104", "The type '{0}' is 'readonly' and cannot be assigned to the mutable type '{1}'."),
      Private_or_protected_member_0_cannot_be_accessed_on_a_type_parameter: diag(4105, ts2.DiagnosticCategory.Error, "Private_or_protected_member_0_cannot_be_accessed_on_a_type_parameter_4105", "Private or protected member '{0}' cannot be accessed on a type parameter."),
      Parameter_0_of_accessor_has_or_is_using_private_name_1: diag(4106, ts2.DiagnosticCategory.Error, "Parameter_0_of_accessor_has_or_is_using_private_name_1_4106", "Parameter '{0}' of accessor has or is using private name '{1}'."),
      Parameter_0_of_accessor_has_or_is_using_name_1_from_private_module_2: diag(4107, ts2.DiagnosticCategory.Error, "Parameter_0_of_accessor_has_or_is_using_name_1_from_private_module_2_4107", "Parameter '{0}' of accessor has or is using name '{1}' from private module '{2}'."),
      Parameter_0_of_accessor_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4108, ts2.DiagnosticCategory.Error, "Parameter_0_of_accessor_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4108", "Parameter '{0}' of accessor has or is using name '{1}' from external module '{2}' but cannot be named."),
      Type_arguments_for_0_circularly_reference_themselves: diag(4109, ts2.DiagnosticCategory.Error, "Type_arguments_for_0_circularly_reference_themselves_4109", "Type arguments for '{0}' circularly reference themselves."),
      Tuple_type_arguments_circularly_reference_themselves: diag(4110, ts2.DiagnosticCategory.Error, "Tuple_type_arguments_circularly_reference_themselves_4110", "Tuple type arguments circularly reference themselves."),
      Property_0_comes_from_an_index_signature_so_it_must_be_accessed_with_0: diag(4111, ts2.DiagnosticCategory.Error, "Property_0_comes_from_an_index_signature_so_it_must_be_accessed_with_0_4111", "Property '{0}' comes from an index signature, so it must be accessed with ['{0}']."),
      This_member_cannot_have_an_override_modifier_because_its_containing_class_0_does_not_extend_another_class: diag(4112, ts2.DiagnosticCategory.Error, "This_member_cannot_have_an_override_modifier_because_its_containing_class_0_does_not_extend_another__4112", "This member cannot have an 'override' modifier because its containing class '{0}' does not extend another class."),
      This_member_cannot_have_an_override_modifier_because_it_is_not_declared_in_the_base_class_0: diag(4113, ts2.DiagnosticCategory.Error, "This_member_cannot_have_an_override_modifier_because_it_is_not_declared_in_the_base_class_0_4113", "This member cannot have an 'override' modifier because it is not declared in the base class '{0}'."),
      This_member_must_have_an_override_modifier_because_it_overrides_a_member_in_the_base_class_0: diag(4114, ts2.DiagnosticCategory.Error, "This_member_must_have_an_override_modifier_because_it_overrides_a_member_in_the_base_class_0_4114", "This member must have an 'override' modifier because it overrides a member in the base class '{0}'."),
      This_parameter_property_must_have_an_override_modifier_because_it_overrides_a_member_in_base_class_0: diag(4115, ts2.DiagnosticCategory.Error, "This_parameter_property_must_have_an_override_modifier_because_it_overrides_a_member_in_base_class_0_4115", "This parameter property must have an 'override' modifier because it overrides a member in base class '{0}'."),
      This_member_must_have_an_override_modifier_because_it_overrides_an_abstract_method_that_is_declared_in_the_base_class_0: diag(4116, ts2.DiagnosticCategory.Error, "This_member_must_have_an_override_modifier_because_it_overrides_an_abstract_method_that_is_declared__4116", "This member must have an 'override' modifier because it overrides an abstract method that is declared in the base class '{0}'."),
      This_member_cannot_have_an_override_modifier_because_it_is_not_declared_in_the_base_class_0_Did_you_mean_1: diag(4117, ts2.DiagnosticCategory.Error, "This_member_cannot_have_an_override_modifier_because_it_is_not_declared_in_the_base_class_0_Did_you__4117", "This member cannot have an 'override' modifier because it is not declared in the base class '{0}'. Did you mean '{1}'?"),
      The_type_of_this_node_cannot_be_serialized_because_its_property_0_cannot_be_serialized: diag(4118, ts2.DiagnosticCategory.Error, "The_type_of_this_node_cannot_be_serialized_because_its_property_0_cannot_be_serialized_4118", "The type of this node cannot be serialized because its property '{0}' cannot be serialized."),
      The_current_host_does_not_support_the_0_option: diag(5001, ts2.DiagnosticCategory.Error, "The_current_host_does_not_support_the_0_option_5001", "The current host does not support the '{0}' option."),
      Cannot_find_the_common_subdirectory_path_for_the_input_files: diag(5009, ts2.DiagnosticCategory.Error, "Cannot_find_the_common_subdirectory_path_for_the_input_files_5009", "Cannot find the common subdirectory path for the input files."),
      File_specification_cannot_end_in_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0: diag(5010, ts2.DiagnosticCategory.Error, "File_specification_cannot_end_in_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0_5010", "File specification cannot end in a recursive directory wildcard ('**'): '{0}'."),
      Cannot_read_file_0_Colon_1: diag(5012, ts2.DiagnosticCategory.Error, "Cannot_read_file_0_Colon_1_5012", "Cannot read file '{0}': {1}."),
      Failed_to_parse_file_0_Colon_1: diag(5014, ts2.DiagnosticCategory.Error, "Failed_to_parse_file_0_Colon_1_5014", "Failed to parse file '{0}': {1}."),
      Unknown_compiler_option_0: diag(5023, ts2.DiagnosticCategory.Error, "Unknown_compiler_option_0_5023", "Unknown compiler option '{0}'."),
      Compiler_option_0_requires_a_value_of_type_1: diag(5024, ts2.DiagnosticCategory.Error, "Compiler_option_0_requires_a_value_of_type_1_5024", "Compiler option '{0}' requires a value of type {1}."),
      Unknown_compiler_option_0_Did_you_mean_1: diag(5025, ts2.DiagnosticCategory.Error, "Unknown_compiler_option_0_Did_you_mean_1_5025", "Unknown compiler option '{0}'. Did you mean '{1}'?"),
      Could_not_write_file_0_Colon_1: diag(5033, ts2.DiagnosticCategory.Error, "Could_not_write_file_0_Colon_1_5033", "Could not write file '{0}': {1}."),
      Option_project_cannot_be_mixed_with_source_files_on_a_command_line: diag(5042, ts2.DiagnosticCategory.Error, "Option_project_cannot_be_mixed_with_source_files_on_a_command_line_5042", "Option 'project' cannot be mixed with source files on a command line."),
      Option_isolatedModules_can_only_be_used_when_either_option_module_is_provided_or_option_target_is_ES2015_or_higher: diag(5047, ts2.DiagnosticCategory.Error, "Option_isolatedModules_can_only_be_used_when_either_option_module_is_provided_or_option_target_is_ES_5047", "Option 'isolatedModules' can only be used when either option '--module' is provided or option 'target' is 'ES2015' or higher."),
      Option_0_cannot_be_specified_when_option_target_is_ES3: diag(5048, ts2.DiagnosticCategory.Error, "Option_0_cannot_be_specified_when_option_target_is_ES3_5048", "Option '{0}' cannot be specified when option 'target' is 'ES3'."),
      Option_0_can_only_be_used_when_either_option_inlineSourceMap_or_option_sourceMap_is_provided: diag(5051, ts2.DiagnosticCategory.Error, "Option_0_can_only_be_used_when_either_option_inlineSourceMap_or_option_sourceMap_is_provided_5051", "Option '{0} can only be used when either option '--inlineSourceMap' or option '--sourceMap' is provided."),
      Option_0_cannot_be_specified_without_specifying_option_1: diag(5052, ts2.DiagnosticCategory.Error, "Option_0_cannot_be_specified_without_specifying_option_1_5052", "Option '{0}' cannot be specified without specifying option '{1}'."),
      Option_0_cannot_be_specified_with_option_1: diag(5053, ts2.DiagnosticCategory.Error, "Option_0_cannot_be_specified_with_option_1_5053", "Option '{0}' cannot be specified with option '{1}'."),
      A_tsconfig_json_file_is_already_defined_at_Colon_0: diag(5054, ts2.DiagnosticCategory.Error, "A_tsconfig_json_file_is_already_defined_at_Colon_0_5054", "A 'tsconfig.json' file is already defined at: '{0}'."),
      Cannot_write_file_0_because_it_would_overwrite_input_file: diag(5055, ts2.DiagnosticCategory.Error, "Cannot_write_file_0_because_it_would_overwrite_input_file_5055", "Cannot write file '{0}' because it would overwrite input file."),
      Cannot_write_file_0_because_it_would_be_overwritten_by_multiple_input_files: diag(5056, ts2.DiagnosticCategory.Error, "Cannot_write_file_0_because_it_would_be_overwritten_by_multiple_input_files_5056", "Cannot write file '{0}' because it would be overwritten by multiple input files."),
      Cannot_find_a_tsconfig_json_file_at_the_specified_directory_Colon_0: diag(5057, ts2.DiagnosticCategory.Error, "Cannot_find_a_tsconfig_json_file_at_the_specified_directory_Colon_0_5057", "Cannot find a tsconfig.json file at the specified directory: '{0}'."),
      The_specified_path_does_not_exist_Colon_0: diag(5058, ts2.DiagnosticCategory.Error, "The_specified_path_does_not_exist_Colon_0_5058", "The specified path does not exist: '{0}'."),
      Invalid_value_for_reactNamespace_0_is_not_a_valid_identifier: diag(5059, ts2.DiagnosticCategory.Error, "Invalid_value_for_reactNamespace_0_is_not_a_valid_identifier_5059", "Invalid value for '--reactNamespace'. '{0}' is not a valid identifier."),
      Pattern_0_can_have_at_most_one_Asterisk_character: diag(5061, ts2.DiagnosticCategory.Error, "Pattern_0_can_have_at_most_one_Asterisk_character_5061", "Pattern '{0}' can have at most one '*' character."),
      Substitution_0_in_pattern_1_can_have_at_most_one_Asterisk_character: diag(5062, ts2.DiagnosticCategory.Error, "Substitution_0_in_pattern_1_can_have_at_most_one_Asterisk_character_5062", "Substitution '{0}' in pattern '{1}' can have at most one '*' character."),
      Substitutions_for_pattern_0_should_be_an_array: diag(5063, ts2.DiagnosticCategory.Error, "Substitutions_for_pattern_0_should_be_an_array_5063", "Substitutions for pattern '{0}' should be an array."),
      Substitution_0_for_pattern_1_has_incorrect_type_expected_string_got_2: diag(5064, ts2.DiagnosticCategory.Error, "Substitution_0_for_pattern_1_has_incorrect_type_expected_string_got_2_5064", "Substitution '{0}' for pattern '{1}' has incorrect type, expected 'string', got '{2}'."),
      File_specification_cannot_contain_a_parent_directory_that_appears_after_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0: diag(5065, ts2.DiagnosticCategory.Error, "File_specification_cannot_contain_a_parent_directory_that_appears_after_a_recursive_directory_wildca_5065", "File specification cannot contain a parent directory ('..') that appears after a recursive directory wildcard ('**'): '{0}'."),
      Substitutions_for_pattern_0_shouldn_t_be_an_empty_array: diag(5066, ts2.DiagnosticCategory.Error, "Substitutions_for_pattern_0_shouldn_t_be_an_empty_array_5066", "Substitutions for pattern '{0}' shouldn't be an empty array."),
      Invalid_value_for_jsxFactory_0_is_not_a_valid_identifier_or_qualified_name: diag(5067, ts2.DiagnosticCategory.Error, "Invalid_value_for_jsxFactory_0_is_not_a_valid_identifier_or_qualified_name_5067", "Invalid value for 'jsxFactory'. '{0}' is not a valid identifier or qualified-name."),
      Adding_a_tsconfig_json_file_will_help_organize_projects_that_contain_both_TypeScript_and_JavaScript_files_Learn_more_at_https_Colon_Slash_Slashaka_ms_Slashtsconfig: diag(5068, ts2.DiagnosticCategory.Error, "Adding_a_tsconfig_json_file_will_help_organize_projects_that_contain_both_TypeScript_and_JavaScript__5068", "Adding a tsconfig.json file will help organize projects that contain both TypeScript and JavaScript files. Learn more at https://aka.ms/tsconfig."),
      Option_0_cannot_be_specified_without_specifying_option_1_or_option_2: diag(5069, ts2.DiagnosticCategory.Error, "Option_0_cannot_be_specified_without_specifying_option_1_or_option_2_5069", "Option '{0}' cannot be specified without specifying option '{1}' or option '{2}'."),
      Option_resolveJsonModule_cannot_be_specified_without_node_module_resolution_strategy: diag(5070, ts2.DiagnosticCategory.Error, "Option_resolveJsonModule_cannot_be_specified_without_node_module_resolution_strategy_5070", "Option '--resolveJsonModule' cannot be specified without 'node' module resolution strategy."),
      Option_resolveJsonModule_can_only_be_specified_when_module_code_generation_is_commonjs_amd_es2015_or_esNext: diag(5071, ts2.DiagnosticCategory.Error, "Option_resolveJsonModule_can_only_be_specified_when_module_code_generation_is_commonjs_amd_es2015_or_5071", "Option '--resolveJsonModule' can only be specified when module code generation is 'commonjs', 'amd', 'es2015' or 'esNext'."),
      Unknown_build_option_0: diag(5072, ts2.DiagnosticCategory.Error, "Unknown_build_option_0_5072", "Unknown build option '{0}'."),
      Build_option_0_requires_a_value_of_type_1: diag(5073, ts2.DiagnosticCategory.Error, "Build_option_0_requires_a_value_of_type_1_5073", "Build option '{0}' requires a value of type {1}."),
      Option_incremental_can_only_be_specified_using_tsconfig_emitting_to_single_file_or_when_option_tsBuildInfoFile_is_specified: diag(5074, ts2.DiagnosticCategory.Error, "Option_incremental_can_only_be_specified_using_tsconfig_emitting_to_single_file_or_when_option_tsBui_5074", "Option '--incremental' can only be specified using tsconfig, emitting to single file or when option '--tsBuildInfoFile' is specified."),
      _0_is_assignable_to_the_constraint_of_type_1_but_1_could_be_instantiated_with_a_different_subtype_of_constraint_2: diag(5075, ts2.DiagnosticCategory.Error, "_0_is_assignable_to_the_constraint_of_type_1_but_1_could_be_instantiated_with_a_different_subtype_of_5075", "'{0}' is assignable to the constraint of type '{1}', but '{1}' could be instantiated with a different subtype of constraint '{2}'."),
      _0_and_1_operations_cannot_be_mixed_without_parentheses: diag(5076, ts2.DiagnosticCategory.Error, "_0_and_1_operations_cannot_be_mixed_without_parentheses_5076", "'{0}' and '{1}' operations cannot be mixed without parentheses."),
      Unknown_build_option_0_Did_you_mean_1: diag(5077, ts2.DiagnosticCategory.Error, "Unknown_build_option_0_Did_you_mean_1_5077", "Unknown build option '{0}'. Did you mean '{1}'?"),
      Unknown_watch_option_0: diag(5078, ts2.DiagnosticCategory.Error, "Unknown_watch_option_0_5078", "Unknown watch option '{0}'."),
      Unknown_watch_option_0_Did_you_mean_1: diag(5079, ts2.DiagnosticCategory.Error, "Unknown_watch_option_0_Did_you_mean_1_5079", "Unknown watch option '{0}'. Did you mean '{1}'?"),
      Watch_option_0_requires_a_value_of_type_1: diag(5080, ts2.DiagnosticCategory.Error, "Watch_option_0_requires_a_value_of_type_1_5080", "Watch option '{0}' requires a value of type {1}."),
      Cannot_find_a_tsconfig_json_file_at_the_current_directory_Colon_0: diag(5081, ts2.DiagnosticCategory.Error, "Cannot_find_a_tsconfig_json_file_at_the_current_directory_Colon_0_5081", "Cannot find a tsconfig.json file at the current directory: {0}."),
      _0_could_be_instantiated_with_an_arbitrary_type_which_could_be_unrelated_to_1: diag(5082, ts2.DiagnosticCategory.Error, "_0_could_be_instantiated_with_an_arbitrary_type_which_could_be_unrelated_to_1_5082", "'{0}' could be instantiated with an arbitrary type which could be unrelated to '{1}'."),
      Cannot_read_file_0: diag(5083, ts2.DiagnosticCategory.Error, "Cannot_read_file_0_5083", "Cannot read file '{0}'."),
      Tuple_members_must_all_have_names_or_all_not_have_names: diag(5084, ts2.DiagnosticCategory.Error, "Tuple_members_must_all_have_names_or_all_not_have_names_5084", "Tuple members must all have names or all not have names."),
      A_tuple_member_cannot_be_both_optional_and_rest: diag(5085, ts2.DiagnosticCategory.Error, "A_tuple_member_cannot_be_both_optional_and_rest_5085", "A tuple member cannot be both optional and rest."),
      A_labeled_tuple_element_is_declared_as_optional_with_a_question_mark_after_the_name_and_before_the_colon_rather_than_after_the_type: diag(5086, ts2.DiagnosticCategory.Error, "A_labeled_tuple_element_is_declared_as_optional_with_a_question_mark_after_the_name_and_before_the_c_5086", "A labeled tuple element is declared as optional with a question mark after the name and before the colon, rather than after the type."),
      A_labeled_tuple_element_is_declared_as_rest_with_a_before_the_name_rather_than_before_the_type: diag(5087, ts2.DiagnosticCategory.Error, "A_labeled_tuple_element_is_declared_as_rest_with_a_before_the_name_rather_than_before_the_type_5087", "A labeled tuple element is declared as rest with a '...' before the name, rather than before the type."),
      The_inferred_type_of_0_references_a_type_with_a_cyclic_structure_which_cannot_be_trivially_serialized_A_type_annotation_is_necessary: diag(5088, ts2.DiagnosticCategory.Error, "The_inferred_type_of_0_references_a_type_with_a_cyclic_structure_which_cannot_be_trivially_serialize_5088", "The inferred type of '{0}' references a type with a cyclic structure which cannot be trivially serialized. A type annotation is necessary."),
      Option_0_cannot_be_specified_when_option_jsx_is_1: diag(5089, ts2.DiagnosticCategory.Error, "Option_0_cannot_be_specified_when_option_jsx_is_1_5089", "Option '{0}' cannot be specified when option 'jsx' is '{1}'."),
      Non_relative_paths_are_not_allowed_when_baseUrl_is_not_set_Did_you_forget_a_leading_Slash: diag(5090, ts2.DiagnosticCategory.Error, "Non_relative_paths_are_not_allowed_when_baseUrl_is_not_set_Did_you_forget_a_leading_Slash_5090", "Non-relative paths are not allowed when 'baseUrl' is not set. Did you forget a leading './'?"),
      Option_preserveConstEnums_cannot_be_disabled_when_isolatedModules_is_enabled: diag(5091, ts2.DiagnosticCategory.Error, "Option_preserveConstEnums_cannot_be_disabled_when_isolatedModules_is_enabled_5091", "Option 'preserveConstEnums' cannot be disabled when 'isolatedModules' is enabled."),
      The_root_value_of_a_0_file_must_be_an_object: diag(5092, ts2.DiagnosticCategory.Error, "The_root_value_of_a_0_file_must_be_an_object_5092", "The root value of a '{0}' file must be an object."),
      Compiler_option_0_may_only_be_used_with_build: diag(5093, ts2.DiagnosticCategory.Error, "Compiler_option_0_may_only_be_used_with_build_5093", "Compiler option '--{0}' may only be used with '--build'."),
      Compiler_option_0_may_not_be_used_with_build: diag(5094, ts2.DiagnosticCategory.Error, "Compiler_option_0_may_not_be_used_with_build_5094", "Compiler option '--{0}' may not be used with '--build'."),
      Generates_a_sourcemap_for_each_corresponding_d_ts_file: diag(6e3, ts2.DiagnosticCategory.Message, "Generates_a_sourcemap_for_each_corresponding_d_ts_file_6000", "Generates a sourcemap for each corresponding '.d.ts' file."),
      Concatenate_and_emit_output_to_single_file: diag(6001, ts2.DiagnosticCategory.Message, "Concatenate_and_emit_output_to_single_file_6001", "Concatenate and emit output to single file."),
      Generates_corresponding_d_ts_file: diag(6002, ts2.DiagnosticCategory.Message, "Generates_corresponding_d_ts_file_6002", "Generates corresponding '.d.ts' file."),
      Specify_the_location_where_debugger_should_locate_map_files_instead_of_generated_locations: diag(6655, ts2.DiagnosticCategory.Message, "Specify_the_location_where_debugger_should_locate_map_files_instead_of_generated_locations_6655", "Specify the location where debugger should locate map files instead of generated locations."),
      Specify_the_location_where_debugger_should_locate_TypeScript_files_instead_of_source_locations: diag(6004, ts2.DiagnosticCategory.Message, "Specify_the_location_where_debugger_should_locate_TypeScript_files_instead_of_source_locations_6004", "Specify the location where debugger should locate TypeScript files instead of source locations."),
      Watch_input_files: diag(6005, ts2.DiagnosticCategory.Message, "Watch_input_files_6005", "Watch input files."),
      Redirect_output_structure_to_the_directory: diag(6006, ts2.DiagnosticCategory.Message, "Redirect_output_structure_to_the_directory_6006", "Redirect output structure to the directory."),
      Do_not_erase_const_enum_declarations_in_generated_code: diag(6007, ts2.DiagnosticCategory.Message, "Do_not_erase_const_enum_declarations_in_generated_code_6007", "Do not erase const enum declarations in generated code."),
      Do_not_emit_outputs_if_any_errors_were_reported: diag(6008, ts2.DiagnosticCategory.Message, "Do_not_emit_outputs_if_any_errors_were_reported_6008", "Do not emit outputs if any errors were reported."),
      Do_not_emit_comments_to_output: diag(6009, ts2.DiagnosticCategory.Message, "Do_not_emit_comments_to_output_6009", "Do not emit comments to output."),
      Do_not_emit_outputs: diag(6010, ts2.DiagnosticCategory.Message, "Do_not_emit_outputs_6010", "Do not emit outputs."),
      Allow_default_imports_from_modules_with_no_default_export_This_does_not_affect_code_emit_just_typechecking: diag(6011, ts2.DiagnosticCategory.Message, "Allow_default_imports_from_modules_with_no_default_export_This_does_not_affect_code_emit_just_typech_6011", "Allow default imports from modules with no default export. This does not affect code emit, just typechecking."),
      Skip_type_checking_of_declaration_files: diag(6012, ts2.DiagnosticCategory.Message, "Skip_type_checking_of_declaration_files_6012", "Skip type checking of declaration files."),
      Do_not_resolve_the_real_path_of_symlinks: diag(6013, ts2.DiagnosticCategory.Message, "Do_not_resolve_the_real_path_of_symlinks_6013", "Do not resolve the real path of symlinks."),
      Only_emit_d_ts_declaration_files: diag(6014, ts2.DiagnosticCategory.Message, "Only_emit_d_ts_declaration_files_6014", "Only emit '.d.ts' declaration files."),
      Specify_ECMAScript_target_version: diag(6015, ts2.DiagnosticCategory.Message, "Specify_ECMAScript_target_version_6015", "Specify ECMAScript target version."),
      Specify_module_code_generation: diag(6016, ts2.DiagnosticCategory.Message, "Specify_module_code_generation_6016", "Specify module code generation."),
      Print_this_message: diag(6017, ts2.DiagnosticCategory.Message, "Print_this_message_6017", "Print this message."),
      Print_the_compiler_s_version: diag(6019, ts2.DiagnosticCategory.Message, "Print_the_compiler_s_version_6019", "Print the compiler's version."),
      Compile_the_project_given_the_path_to_its_configuration_file_or_to_a_folder_with_a_tsconfig_json: diag(6020, ts2.DiagnosticCategory.Message, "Compile_the_project_given_the_path_to_its_configuration_file_or_to_a_folder_with_a_tsconfig_json_6020", "Compile the project given the path to its configuration file, or to a folder with a 'tsconfig.json'."),
      Syntax_Colon_0: diag(6023, ts2.DiagnosticCategory.Message, "Syntax_Colon_0_6023", "Syntax: {0}"),
      options: diag(6024, ts2.DiagnosticCategory.Message, "options_6024", "options"),
      file: diag(6025, ts2.DiagnosticCategory.Message, "file_6025", "file"),
      Examples_Colon_0: diag(6026, ts2.DiagnosticCategory.Message, "Examples_Colon_0_6026", "Examples: {0}"),
      Options_Colon: diag(6027, ts2.DiagnosticCategory.Message, "Options_Colon_6027", "Options:"),
      Version_0: diag(6029, ts2.DiagnosticCategory.Message, "Version_0_6029", "Version {0}"),
      Insert_command_line_options_and_files_from_a_file: diag(6030, ts2.DiagnosticCategory.Message, "Insert_command_line_options_and_files_from_a_file_6030", "Insert command line options and files from a file."),
      Starting_compilation_in_watch_mode: diag(6031, ts2.DiagnosticCategory.Message, "Starting_compilation_in_watch_mode_6031", "Starting compilation in watch mode..."),
      File_change_detected_Starting_incremental_compilation: diag(6032, ts2.DiagnosticCategory.Message, "File_change_detected_Starting_incremental_compilation_6032", "File change detected. Starting incremental compilation..."),
      KIND: diag(6034, ts2.DiagnosticCategory.Message, "KIND_6034", "KIND"),
      FILE: diag(6035, ts2.DiagnosticCategory.Message, "FILE_6035", "FILE"),
      VERSION: diag(6036, ts2.DiagnosticCategory.Message, "VERSION_6036", "VERSION"),
      LOCATION: diag(6037, ts2.DiagnosticCategory.Message, "LOCATION_6037", "LOCATION"),
      DIRECTORY: diag(6038, ts2.DiagnosticCategory.Message, "DIRECTORY_6038", "DIRECTORY"),
      STRATEGY: diag(6039, ts2.DiagnosticCategory.Message, "STRATEGY_6039", "STRATEGY"),
      FILE_OR_DIRECTORY: diag(6040, ts2.DiagnosticCategory.Message, "FILE_OR_DIRECTORY_6040", "FILE OR DIRECTORY"),
      Generates_corresponding_map_file: diag(6043, ts2.DiagnosticCategory.Message, "Generates_corresponding_map_file_6043", "Generates corresponding '.map' file."),
      Compiler_option_0_expects_an_argument: diag(6044, ts2.DiagnosticCategory.Error, "Compiler_option_0_expects_an_argument_6044", "Compiler option '{0}' expects an argument."),
      Unterminated_quoted_string_in_response_file_0: diag(6045, ts2.DiagnosticCategory.Error, "Unterminated_quoted_string_in_response_file_0_6045", "Unterminated quoted string in response file '{0}'."),
      Argument_for_0_option_must_be_Colon_1: diag(6046, ts2.DiagnosticCategory.Error, "Argument_for_0_option_must_be_Colon_1_6046", "Argument for '{0}' option must be: {1}."),
      Locale_must_be_of_the_form_language_or_language_territory_For_example_0_or_1: diag(6048, ts2.DiagnosticCategory.Error, "Locale_must_be_of_the_form_language_or_language_territory_For_example_0_or_1_6048", "Locale must be of the form <language> or <language>-<territory>. For example '{0}' or '{1}'."),
      Unsupported_locale_0: diag(6049, ts2.DiagnosticCategory.Error, "Unsupported_locale_0_6049", "Unsupported locale '{0}'."),
      Unable_to_open_file_0: diag(6050, ts2.DiagnosticCategory.Error, "Unable_to_open_file_0_6050", "Unable to open file '{0}'."),
      Corrupted_locale_file_0: diag(6051, ts2.DiagnosticCategory.Error, "Corrupted_locale_file_0_6051", "Corrupted locale file {0}."),
      Raise_error_on_expressions_and_declarations_with_an_implied_any_type: diag(6052, ts2.DiagnosticCategory.Message, "Raise_error_on_expressions_and_declarations_with_an_implied_any_type_6052", "Raise error on expressions and declarations with an implied 'any' type."),
      File_0_not_found: diag(6053, ts2.DiagnosticCategory.Error, "File_0_not_found_6053", "File '{0}' not found."),
      File_0_has_an_unsupported_extension_The_only_supported_extensions_are_1: diag(6054, ts2.DiagnosticCategory.Error, "File_0_has_an_unsupported_extension_The_only_supported_extensions_are_1_6054", "File '{0}' has an unsupported extension. The only supported extensions are {1}."),
      Suppress_noImplicitAny_errors_for_indexing_objects_lacking_index_signatures: diag(6055, ts2.DiagnosticCategory.Message, "Suppress_noImplicitAny_errors_for_indexing_objects_lacking_index_signatures_6055", "Suppress noImplicitAny errors for indexing objects lacking index signatures."),
      Do_not_emit_declarations_for_code_that_has_an_internal_annotation: diag(6056, ts2.DiagnosticCategory.Message, "Do_not_emit_declarations_for_code_that_has_an_internal_annotation_6056", "Do not emit declarations for code that has an '@internal' annotation."),
      Specify_the_root_directory_of_input_files_Use_to_control_the_output_directory_structure_with_outDir: diag(6058, ts2.DiagnosticCategory.Message, "Specify_the_root_directory_of_input_files_Use_to_control_the_output_directory_structure_with_outDir_6058", "Specify the root directory of input files. Use to control the output directory structure with --outDir."),
      File_0_is_not_under_rootDir_1_rootDir_is_expected_to_contain_all_source_files: diag(6059, ts2.DiagnosticCategory.Error, "File_0_is_not_under_rootDir_1_rootDir_is_expected_to_contain_all_source_files_6059", "File '{0}' is not under 'rootDir' '{1}'. 'rootDir' is expected to contain all source files."),
      Specify_the_end_of_line_sequence_to_be_used_when_emitting_files_Colon_CRLF_dos_or_LF_unix: diag(6060, ts2.DiagnosticCategory.Message, "Specify_the_end_of_line_sequence_to_be_used_when_emitting_files_Colon_CRLF_dos_or_LF_unix_6060", "Specify the end of line sequence to be used when emitting files: 'CRLF' (dos) or 'LF' (unix)."),
      NEWLINE: diag(6061, ts2.DiagnosticCategory.Message, "NEWLINE_6061", "NEWLINE"),
      Option_0_can_only_be_specified_in_tsconfig_json_file_or_set_to_null_on_command_line: diag(6064, ts2.DiagnosticCategory.Error, "Option_0_can_only_be_specified_in_tsconfig_json_file_or_set_to_null_on_command_line_6064", "Option '{0}' can only be specified in 'tsconfig.json' file or set to 'null' on command line."),
      Enables_experimental_support_for_ES7_decorators: diag(6065, ts2.DiagnosticCategory.Message, "Enables_experimental_support_for_ES7_decorators_6065", "Enables experimental support for ES7 decorators."),
      Enables_experimental_support_for_emitting_type_metadata_for_decorators: diag(6066, ts2.DiagnosticCategory.Message, "Enables_experimental_support_for_emitting_type_metadata_for_decorators_6066", "Enables experimental support for emitting type metadata for decorators."),
      Enables_experimental_support_for_ES7_async_functions: diag(6068, ts2.DiagnosticCategory.Message, "Enables_experimental_support_for_ES7_async_functions_6068", "Enables experimental support for ES7 async functions."),
      Specify_module_resolution_strategy_Colon_node_Node_js_or_classic_TypeScript_pre_1_6: diag(6069, ts2.DiagnosticCategory.Message, "Specify_module_resolution_strategy_Colon_node_Node_js_or_classic_TypeScript_pre_1_6_6069", "Specify module resolution strategy: 'node' (Node.js) or 'classic' (TypeScript pre-1.6)."),
      Initializes_a_TypeScript_project_and_creates_a_tsconfig_json_file: diag(6070, ts2.DiagnosticCategory.Message, "Initializes_a_TypeScript_project_and_creates_a_tsconfig_json_file_6070", "Initializes a TypeScript project and creates a tsconfig.json file."),
      Successfully_created_a_tsconfig_json_file: diag(6071, ts2.DiagnosticCategory.Message, "Successfully_created_a_tsconfig_json_file_6071", "Successfully created a tsconfig.json file."),
      Suppress_excess_property_checks_for_object_literals: diag(6072, ts2.DiagnosticCategory.Message, "Suppress_excess_property_checks_for_object_literals_6072", "Suppress excess property checks for object literals."),
      Stylize_errors_and_messages_using_color_and_context_experimental: diag(6073, ts2.DiagnosticCategory.Message, "Stylize_errors_and_messages_using_color_and_context_experimental_6073", "Stylize errors and messages using color and context (experimental)."),
      Do_not_report_errors_on_unused_labels: diag(6074, ts2.DiagnosticCategory.Message, "Do_not_report_errors_on_unused_labels_6074", "Do not report errors on unused labels."),
      Report_error_when_not_all_code_paths_in_function_return_a_value: diag(6075, ts2.DiagnosticCategory.Message, "Report_error_when_not_all_code_paths_in_function_return_a_value_6075", "Report error when not all code paths in function return a value."),
      Report_errors_for_fallthrough_cases_in_switch_statement: diag(6076, ts2.DiagnosticCategory.Message, "Report_errors_for_fallthrough_cases_in_switch_statement_6076", "Report errors for fallthrough cases in switch statement."),
      Do_not_report_errors_on_unreachable_code: diag(6077, ts2.DiagnosticCategory.Message, "Do_not_report_errors_on_unreachable_code_6077", "Do not report errors on unreachable code."),
      Disallow_inconsistently_cased_references_to_the_same_file: diag(6078, ts2.DiagnosticCategory.Message, "Disallow_inconsistently_cased_references_to_the_same_file_6078", "Disallow inconsistently-cased references to the same file."),
      Specify_library_files_to_be_included_in_the_compilation: diag(6079, ts2.DiagnosticCategory.Message, "Specify_library_files_to_be_included_in_the_compilation_6079", "Specify library files to be included in the compilation."),
      Specify_JSX_code_generation: diag(6080, ts2.DiagnosticCategory.Message, "Specify_JSX_code_generation_6080", "Specify JSX code generation."),
      File_0_has_an_unsupported_extension_so_skipping_it: diag(6081, ts2.DiagnosticCategory.Message, "File_0_has_an_unsupported_extension_so_skipping_it_6081", "File '{0}' has an unsupported extension, so skipping it."),
      Only_amd_and_system_modules_are_supported_alongside_0: diag(6082, ts2.DiagnosticCategory.Error, "Only_amd_and_system_modules_are_supported_alongside_0_6082", "Only 'amd' and 'system' modules are supported alongside --{0}."),
      Base_directory_to_resolve_non_absolute_module_names: diag(6083, ts2.DiagnosticCategory.Message, "Base_directory_to_resolve_non_absolute_module_names_6083", "Base directory to resolve non-absolute module names."),
      Deprecated_Use_jsxFactory_instead_Specify_the_object_invoked_for_createElement_when_targeting_react_JSX_emit: diag(6084, ts2.DiagnosticCategory.Message, "Deprecated_Use_jsxFactory_instead_Specify_the_object_invoked_for_createElement_when_targeting_react__6084", "[Deprecated] Use '--jsxFactory' instead. Specify the object invoked for createElement when targeting 'react' JSX emit"),
      Enable_tracing_of_the_name_resolution_process: diag(6085, ts2.DiagnosticCategory.Message, "Enable_tracing_of_the_name_resolution_process_6085", "Enable tracing of the name resolution process."),
      Resolving_module_0_from_1: diag(6086, ts2.DiagnosticCategory.Message, "Resolving_module_0_from_1_6086", "======== Resolving module '{0}' from '{1}'. ========"),
      Explicitly_specified_module_resolution_kind_Colon_0: diag(6087, ts2.DiagnosticCategory.Message, "Explicitly_specified_module_resolution_kind_Colon_0_6087", "Explicitly specified module resolution kind: '{0}'."),
      Module_resolution_kind_is_not_specified_using_0: diag(6088, ts2.DiagnosticCategory.Message, "Module_resolution_kind_is_not_specified_using_0_6088", "Module resolution kind is not specified, using '{0}'."),
      Module_name_0_was_successfully_resolved_to_1: diag(6089, ts2.DiagnosticCategory.Message, "Module_name_0_was_successfully_resolved_to_1_6089", "======== Module name '{0}' was successfully resolved to '{1}'. ========"),
      Module_name_0_was_not_resolved: diag(6090, ts2.DiagnosticCategory.Message, "Module_name_0_was_not_resolved_6090", "======== Module name '{0}' was not resolved. ========"),
      paths_option_is_specified_looking_for_a_pattern_to_match_module_name_0: diag(6091, ts2.DiagnosticCategory.Message, "paths_option_is_specified_looking_for_a_pattern_to_match_module_name_0_6091", "'paths' option is specified, looking for a pattern to match module name '{0}'."),
      Module_name_0_matched_pattern_1: diag(6092, ts2.DiagnosticCategory.Message, "Module_name_0_matched_pattern_1_6092", "Module name '{0}', matched pattern '{1}'."),
      Trying_substitution_0_candidate_module_location_Colon_1: diag(6093, ts2.DiagnosticCategory.Message, "Trying_substitution_0_candidate_module_location_Colon_1_6093", "Trying substitution '{0}', candidate module location: '{1}'."),
      Resolving_module_name_0_relative_to_base_url_1_2: diag(6094, ts2.DiagnosticCategory.Message, "Resolving_module_name_0_relative_to_base_url_1_2_6094", "Resolving module name '{0}' relative to base url '{1}' - '{2}'."),
      Loading_module_as_file_Slash_folder_candidate_module_location_0_target_file_type_1: diag(6095, ts2.DiagnosticCategory.Message, "Loading_module_as_file_Slash_folder_candidate_module_location_0_target_file_type_1_6095", "Loading module as file / folder, candidate module location '{0}', target file type '{1}'."),
      File_0_does_not_exist: diag(6096, ts2.DiagnosticCategory.Message, "File_0_does_not_exist_6096", "File '{0}' does not exist."),
      File_0_exist_use_it_as_a_name_resolution_result: diag(6097, ts2.DiagnosticCategory.Message, "File_0_exist_use_it_as_a_name_resolution_result_6097", "File '{0}' exist - use it as a name resolution result."),
      Loading_module_0_from_node_modules_folder_target_file_type_1: diag(6098, ts2.DiagnosticCategory.Message, "Loading_module_0_from_node_modules_folder_target_file_type_1_6098", "Loading module '{0}' from 'node_modules' folder, target file type '{1}'."),
      Found_package_json_at_0: diag(6099, ts2.DiagnosticCategory.Message, "Found_package_json_at_0_6099", "Found 'package.json' at '{0}'."),
      package_json_does_not_have_a_0_field: diag(6100, ts2.DiagnosticCategory.Message, "package_json_does_not_have_a_0_field_6100", "'package.json' does not have a '{0}' field."),
      package_json_has_0_field_1_that_references_2: diag(6101, ts2.DiagnosticCategory.Message, "package_json_has_0_field_1_that_references_2_6101", "'package.json' has '{0}' field '{1}' that references '{2}'."),
      Allow_javascript_files_to_be_compiled: diag(6102, ts2.DiagnosticCategory.Message, "Allow_javascript_files_to_be_compiled_6102", "Allow javascript files to be compiled."),
      Option_0_should_have_array_of_strings_as_a_value: diag(6103, ts2.DiagnosticCategory.Error, "Option_0_should_have_array_of_strings_as_a_value_6103", "Option '{0}' should have array of strings as a value."),
      Checking_if_0_is_the_longest_matching_prefix_for_1_2: diag(6104, ts2.DiagnosticCategory.Message, "Checking_if_0_is_the_longest_matching_prefix_for_1_2_6104", "Checking if '{0}' is the longest matching prefix for '{1}' - '{2}'."),
      Expected_type_of_0_field_in_package_json_to_be_1_got_2: diag(6105, ts2.DiagnosticCategory.Message, "Expected_type_of_0_field_in_package_json_to_be_1_got_2_6105", "Expected type of '{0}' field in 'package.json' to be '{1}', got '{2}'."),
      baseUrl_option_is_set_to_0_using_this_value_to_resolve_non_relative_module_name_1: diag(6106, ts2.DiagnosticCategory.Message, "baseUrl_option_is_set_to_0_using_this_value_to_resolve_non_relative_module_name_1_6106", "'baseUrl' option is set to '{0}', using this value to resolve non-relative module name '{1}'."),
      rootDirs_option_is_set_using_it_to_resolve_relative_module_name_0: diag(6107, ts2.DiagnosticCategory.Message, "rootDirs_option_is_set_using_it_to_resolve_relative_module_name_0_6107", "'rootDirs' option is set, using it to resolve relative module name '{0}'."),
      Longest_matching_prefix_for_0_is_1: diag(6108, ts2.DiagnosticCategory.Message, "Longest_matching_prefix_for_0_is_1_6108", "Longest matching prefix for '{0}' is '{1}'."),
      Loading_0_from_the_root_dir_1_candidate_location_2: diag(6109, ts2.DiagnosticCategory.Message, "Loading_0_from_the_root_dir_1_candidate_location_2_6109", "Loading '{0}' from the root dir '{1}', candidate location '{2}'."),
      Trying_other_entries_in_rootDirs: diag(6110, ts2.DiagnosticCategory.Message, "Trying_other_entries_in_rootDirs_6110", "Trying other entries in 'rootDirs'."),
      Module_resolution_using_rootDirs_has_failed: diag(6111, ts2.DiagnosticCategory.Message, "Module_resolution_using_rootDirs_has_failed_6111", "Module resolution using 'rootDirs' has failed."),
      Do_not_emit_use_strict_directives_in_module_output: diag(6112, ts2.DiagnosticCategory.Message, "Do_not_emit_use_strict_directives_in_module_output_6112", "Do not emit 'use strict' directives in module output."),
      Enable_strict_null_checks: diag(6113, ts2.DiagnosticCategory.Message, "Enable_strict_null_checks_6113", "Enable strict null checks."),
      Unknown_option_excludes_Did_you_mean_exclude: diag(6114, ts2.DiagnosticCategory.Error, "Unknown_option_excludes_Did_you_mean_exclude_6114", "Unknown option 'excludes'. Did you mean 'exclude'?"),
      Raise_error_on_this_expressions_with_an_implied_any_type: diag(6115, ts2.DiagnosticCategory.Message, "Raise_error_on_this_expressions_with_an_implied_any_type_6115", "Raise error on 'this' expressions with an implied 'any' type."),
      Resolving_type_reference_directive_0_containing_file_1_root_directory_2: diag(6116, ts2.DiagnosticCategory.Message, "Resolving_type_reference_directive_0_containing_file_1_root_directory_2_6116", "======== Resolving type reference directive '{0}', containing file '{1}', root directory '{2}'. ========"),
      Resolving_using_primary_search_paths: diag(6117, ts2.DiagnosticCategory.Message, "Resolving_using_primary_search_paths_6117", "Resolving using primary search paths..."),
      Resolving_from_node_modules_folder: diag(6118, ts2.DiagnosticCategory.Message, "Resolving_from_node_modules_folder_6118", "Resolving from node_modules folder..."),
      Type_reference_directive_0_was_successfully_resolved_to_1_primary_Colon_2: diag(6119, ts2.DiagnosticCategory.Message, "Type_reference_directive_0_was_successfully_resolved_to_1_primary_Colon_2_6119", "======== Type reference directive '{0}' was successfully resolved to '{1}', primary: {2}. ========"),
      Type_reference_directive_0_was_not_resolved: diag(6120, ts2.DiagnosticCategory.Message, "Type_reference_directive_0_was_not_resolved_6120", "======== Type reference directive '{0}' was not resolved. ========"),
      Resolving_with_primary_search_path_0: diag(6121, ts2.DiagnosticCategory.Message, "Resolving_with_primary_search_path_0_6121", "Resolving with primary search path '{0}'."),
      Root_directory_cannot_be_determined_skipping_primary_search_paths: diag(6122, ts2.DiagnosticCategory.Message, "Root_directory_cannot_be_determined_skipping_primary_search_paths_6122", "Root directory cannot be determined, skipping primary search paths."),
      Resolving_type_reference_directive_0_containing_file_1_root_directory_not_set: diag(6123, ts2.DiagnosticCategory.Message, "Resolving_type_reference_directive_0_containing_file_1_root_directory_not_set_6123", "======== Resolving type reference directive '{0}', containing file '{1}', root directory not set. ========"),
      Type_declaration_files_to_be_included_in_compilation: diag(6124, ts2.DiagnosticCategory.Message, "Type_declaration_files_to_be_included_in_compilation_6124", "Type declaration files to be included in compilation."),
      Looking_up_in_node_modules_folder_initial_location_0: diag(6125, ts2.DiagnosticCategory.Message, "Looking_up_in_node_modules_folder_initial_location_0_6125", "Looking up in 'node_modules' folder, initial location '{0}'."),
      Containing_file_is_not_specified_and_root_directory_cannot_be_determined_skipping_lookup_in_node_modules_folder: diag(6126, ts2.DiagnosticCategory.Message, "Containing_file_is_not_specified_and_root_directory_cannot_be_determined_skipping_lookup_in_node_mod_6126", "Containing file is not specified and root directory cannot be determined, skipping lookup in 'node_modules' folder."),
      Resolving_type_reference_directive_0_containing_file_not_set_root_directory_1: diag(6127, ts2.DiagnosticCategory.Message, "Resolving_type_reference_directive_0_containing_file_not_set_root_directory_1_6127", "======== Resolving type reference directive '{0}', containing file not set, root directory '{1}'. ========"),
      Resolving_type_reference_directive_0_containing_file_not_set_root_directory_not_set: diag(6128, ts2.DiagnosticCategory.Message, "Resolving_type_reference_directive_0_containing_file_not_set_root_directory_not_set_6128", "======== Resolving type reference directive '{0}', containing file not set, root directory not set. ========"),
      Resolving_real_path_for_0_result_1: diag(6130, ts2.DiagnosticCategory.Message, "Resolving_real_path_for_0_result_1_6130", "Resolving real path for '{0}', result '{1}'."),
      Cannot_compile_modules_using_option_0_unless_the_module_flag_is_amd_or_system: diag(6131, ts2.DiagnosticCategory.Error, "Cannot_compile_modules_using_option_0_unless_the_module_flag_is_amd_or_system_6131", "Cannot compile modules using option '{0}' unless the '--module' flag is 'amd' or 'system'."),
      File_name_0_has_a_1_extension_stripping_it: diag(6132, ts2.DiagnosticCategory.Message, "File_name_0_has_a_1_extension_stripping_it_6132", "File name '{0}' has a '{1}' extension - stripping it."),
      _0_is_declared_but_its_value_is_never_read: diag(6133, ts2.DiagnosticCategory.Error, "_0_is_declared_but_its_value_is_never_read_6133", "'{0}' is declared but its value is never read.", true),
      Report_errors_on_unused_locals: diag(6134, ts2.DiagnosticCategory.Message, "Report_errors_on_unused_locals_6134", "Report errors on unused locals."),
      Report_errors_on_unused_parameters: diag(6135, ts2.DiagnosticCategory.Message, "Report_errors_on_unused_parameters_6135", "Report errors on unused parameters."),
      The_maximum_dependency_depth_to_search_under_node_modules_and_load_JavaScript_files: diag(6136, ts2.DiagnosticCategory.Message, "The_maximum_dependency_depth_to_search_under_node_modules_and_load_JavaScript_files_6136", "The maximum dependency depth to search under node_modules and load JavaScript files."),
      Cannot_import_type_declaration_files_Consider_importing_0_instead_of_1: diag(6137, ts2.DiagnosticCategory.Error, "Cannot_import_type_declaration_files_Consider_importing_0_instead_of_1_6137", "Cannot import type declaration files. Consider importing '{0}' instead of '{1}'."),
      Property_0_is_declared_but_its_value_is_never_read: diag(6138, ts2.DiagnosticCategory.Error, "Property_0_is_declared_but_its_value_is_never_read_6138", "Property '{0}' is declared but its value is never read.", true),
      Import_emit_helpers_from_tslib: diag(6139, ts2.DiagnosticCategory.Message, "Import_emit_helpers_from_tslib_6139", "Import emit helpers from 'tslib'."),
      Auto_discovery_for_typings_is_enabled_in_project_0_Running_extra_resolution_pass_for_module_1_using_cache_location_2: diag(6140, ts2.DiagnosticCategory.Error, "Auto_discovery_for_typings_is_enabled_in_project_0_Running_extra_resolution_pass_for_module_1_using__6140", "Auto discovery for typings is enabled in project '{0}'. Running extra resolution pass for module '{1}' using cache location '{2}'."),
      Parse_in_strict_mode_and_emit_use_strict_for_each_source_file: diag(6141, ts2.DiagnosticCategory.Message, "Parse_in_strict_mode_and_emit_use_strict_for_each_source_file_6141", 'Parse in strict mode and emit "use strict" for each source file.'),
      Module_0_was_resolved_to_1_but_jsx_is_not_set: diag(6142, ts2.DiagnosticCategory.Error, "Module_0_was_resolved_to_1_but_jsx_is_not_set_6142", "Module '{0}' was resolved to '{1}', but '--jsx' is not set."),
      Module_0_was_resolved_as_locally_declared_ambient_module_in_file_1: diag(6144, ts2.DiagnosticCategory.Message, "Module_0_was_resolved_as_locally_declared_ambient_module_in_file_1_6144", "Module '{0}' was resolved as locally declared ambient module in file '{1}'."),
      Module_0_was_resolved_as_ambient_module_declared_in_1_since_this_file_was_not_modified: diag(6145, ts2.DiagnosticCategory.Message, "Module_0_was_resolved_as_ambient_module_declared_in_1_since_this_file_was_not_modified_6145", "Module '{0}' was resolved as ambient module declared in '{1}' since this file was not modified."),
      Specify_the_JSX_factory_function_to_use_when_targeting_react_JSX_emit_e_g_React_createElement_or_h: diag(6146, ts2.DiagnosticCategory.Message, "Specify_the_JSX_factory_function_to_use_when_targeting_react_JSX_emit_e_g_React_createElement_or_h_6146", "Specify the JSX factory function to use when targeting 'react' JSX emit, e.g. 'React.createElement' or 'h'."),
      Resolution_for_module_0_was_found_in_cache_from_location_1: diag(6147, ts2.DiagnosticCategory.Message, "Resolution_for_module_0_was_found_in_cache_from_location_1_6147", "Resolution for module '{0}' was found in cache from location '{1}'."),
      Directory_0_does_not_exist_skipping_all_lookups_in_it: diag(6148, ts2.DiagnosticCategory.Message, "Directory_0_does_not_exist_skipping_all_lookups_in_it_6148", "Directory '{0}' does not exist, skipping all lookups in it."),
      Show_diagnostic_information: diag(6149, ts2.DiagnosticCategory.Message, "Show_diagnostic_information_6149", "Show diagnostic information."),
      Show_verbose_diagnostic_information: diag(6150, ts2.DiagnosticCategory.Message, "Show_verbose_diagnostic_information_6150", "Show verbose diagnostic information."),
      Emit_a_single_file_with_source_maps_instead_of_having_a_separate_file: diag(6151, ts2.DiagnosticCategory.Message, "Emit_a_single_file_with_source_maps_instead_of_having_a_separate_file_6151", "Emit a single file with source maps instead of having a separate file."),
      Emit_the_source_alongside_the_sourcemaps_within_a_single_file_requires_inlineSourceMap_or_sourceMap_to_be_set: diag(6152, ts2.DiagnosticCategory.Message, "Emit_the_source_alongside_the_sourcemaps_within_a_single_file_requires_inlineSourceMap_or_sourceMap__6152", "Emit the source alongside the sourcemaps within a single file; requires '--inlineSourceMap' or '--sourceMap' to be set."),
      Transpile_each_file_as_a_separate_module_similar_to_ts_transpileModule: diag(6153, ts2.DiagnosticCategory.Message, "Transpile_each_file_as_a_separate_module_similar_to_ts_transpileModule_6153", "Transpile each file as a separate module (similar to 'ts.transpileModule')."),
      Print_names_of_generated_files_part_of_the_compilation: diag(6154, ts2.DiagnosticCategory.Message, "Print_names_of_generated_files_part_of_the_compilation_6154", "Print names of generated files part of the compilation."),
      Print_names_of_files_part_of_the_compilation: diag(6155, ts2.DiagnosticCategory.Message, "Print_names_of_files_part_of_the_compilation_6155", "Print names of files part of the compilation."),
      The_locale_used_when_displaying_messages_to_the_user_e_g_en_us: diag(6156, ts2.DiagnosticCategory.Message, "The_locale_used_when_displaying_messages_to_the_user_e_g_en_us_6156", "The locale used when displaying messages to the user (e.g. 'en-us')"),
      Do_not_generate_custom_helper_functions_like_extends_in_compiled_output: diag(6157, ts2.DiagnosticCategory.Message, "Do_not_generate_custom_helper_functions_like_extends_in_compiled_output_6157", "Do not generate custom helper functions like '__extends' in compiled output."),
      Do_not_include_the_default_library_file_lib_d_ts: diag(6158, ts2.DiagnosticCategory.Message, "Do_not_include_the_default_library_file_lib_d_ts_6158", "Do not include the default library file (lib.d.ts)."),
      Do_not_add_triple_slash_references_or_imported_modules_to_the_list_of_compiled_files: diag(6159, ts2.DiagnosticCategory.Message, "Do_not_add_triple_slash_references_or_imported_modules_to_the_list_of_compiled_files_6159", "Do not add triple-slash references or imported modules to the list of compiled files."),
      Deprecated_Use_skipLibCheck_instead_Skip_type_checking_of_default_library_declaration_files: diag(6160, ts2.DiagnosticCategory.Message, "Deprecated_Use_skipLibCheck_instead_Skip_type_checking_of_default_library_declaration_files_6160", "[Deprecated] Use '--skipLibCheck' instead. Skip type checking of default library declaration files."),
      List_of_folders_to_include_type_definitions_from: diag(6161, ts2.DiagnosticCategory.Message, "List_of_folders_to_include_type_definitions_from_6161", "List of folders to include type definitions from."),
      Disable_size_limitations_on_JavaScript_projects: diag(6162, ts2.DiagnosticCategory.Message, "Disable_size_limitations_on_JavaScript_projects_6162", "Disable size limitations on JavaScript projects."),
      The_character_set_of_the_input_files: diag(6163, ts2.DiagnosticCategory.Message, "The_character_set_of_the_input_files_6163", "The character set of the input files."),
      Emit_a_UTF_8_Byte_Order_Mark_BOM_in_the_beginning_of_output_files: diag(6622, ts2.DiagnosticCategory.Message, "Emit_a_UTF_8_Byte_Order_Mark_BOM_in_the_beginning_of_output_files_6622", "Emit a UTF-8 Byte Order Mark (BOM) in the beginning of output files."),
      Do_not_truncate_error_messages: diag(6165, ts2.DiagnosticCategory.Message, "Do_not_truncate_error_messages_6165", "Do not truncate error messages."),
      Output_directory_for_generated_declaration_files: diag(6166, ts2.DiagnosticCategory.Message, "Output_directory_for_generated_declaration_files_6166", "Output directory for generated declaration files."),
      A_series_of_entries_which_re_map_imports_to_lookup_locations_relative_to_the_baseUrl: diag(6167, ts2.DiagnosticCategory.Message, "A_series_of_entries_which_re_map_imports_to_lookup_locations_relative_to_the_baseUrl_6167", "A series of entries which re-map imports to lookup locations relative to the 'baseUrl'."),
      List_of_root_folders_whose_combined_content_represents_the_structure_of_the_project_at_runtime: diag(6168, ts2.DiagnosticCategory.Message, "List_of_root_folders_whose_combined_content_represents_the_structure_of_the_project_at_runtime_6168", "List of root folders whose combined content represents the structure of the project at runtime."),
      Show_all_compiler_options: diag(6169, ts2.DiagnosticCategory.Message, "Show_all_compiler_options_6169", "Show all compiler options."),
      Deprecated_Use_outFile_instead_Concatenate_and_emit_output_to_single_file: diag(6170, ts2.DiagnosticCategory.Message, "Deprecated_Use_outFile_instead_Concatenate_and_emit_output_to_single_file_6170", "[Deprecated] Use '--outFile' instead. Concatenate and emit output to single file"),
      Command_line_Options: diag(6171, ts2.DiagnosticCategory.Message, "Command_line_Options_6171", "Command-line Options"),
      Provide_full_support_for_iterables_in_for_of_spread_and_destructuring_when_targeting_ES5_or_ES3: diag(6179, ts2.DiagnosticCategory.Message, "Provide_full_support_for_iterables_in_for_of_spread_and_destructuring_when_targeting_ES5_or_ES3_6179", "Provide full support for iterables in 'for-of', spread, and destructuring when targeting 'ES5' or 'ES3'."),
      Enable_all_strict_type_checking_options: diag(6180, ts2.DiagnosticCategory.Message, "Enable_all_strict_type_checking_options_6180", "Enable all strict type-checking options."),
      List_of_language_service_plugins: diag(6181, ts2.DiagnosticCategory.Message, "List_of_language_service_plugins_6181", "List of language service plugins."),
      Scoped_package_detected_looking_in_0: diag(6182, ts2.DiagnosticCategory.Message, "Scoped_package_detected_looking_in_0_6182", "Scoped package detected, looking in '{0}'"),
      Reusing_resolution_of_module_0_from_1_of_old_program_it_was_successfully_resolved_to_2: diag(6183, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_module_0_from_1_of_old_program_it_was_successfully_resolved_to_2_6183", "Reusing resolution of module '{0}' from '{1}' of old program, it was successfully resolved to '{2}'."),
      Reusing_resolution_of_module_0_from_1_of_old_program_it_was_successfully_resolved_to_2_with_Package_ID_3: diag(6184, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_module_0_from_1_of_old_program_it_was_successfully_resolved_to_2_with_Package__6184", "Reusing resolution of module '{0}' from '{1}' of old program, it was successfully resolved to '{2}' with Package ID '{3}'."),
      Enable_strict_checking_of_function_types: diag(6186, ts2.DiagnosticCategory.Message, "Enable_strict_checking_of_function_types_6186", "Enable strict checking of function types."),
      Enable_strict_checking_of_property_initialization_in_classes: diag(6187, ts2.DiagnosticCategory.Message, "Enable_strict_checking_of_property_initialization_in_classes_6187", "Enable strict checking of property initialization in classes."),
      Numeric_separators_are_not_allowed_here: diag(6188, ts2.DiagnosticCategory.Error, "Numeric_separators_are_not_allowed_here_6188", "Numeric separators are not allowed here."),
      Multiple_consecutive_numeric_separators_are_not_permitted: diag(6189, ts2.DiagnosticCategory.Error, "Multiple_consecutive_numeric_separators_are_not_permitted_6189", "Multiple consecutive numeric separators are not permitted."),
      Whether_to_keep_outdated_console_output_in_watch_mode_instead_of_clearing_the_screen: diag(6191, ts2.DiagnosticCategory.Message, "Whether_to_keep_outdated_console_output_in_watch_mode_instead_of_clearing_the_screen_6191", "Whether to keep outdated console output in watch mode instead of clearing the screen."),
      All_imports_in_import_declaration_are_unused: diag(6192, ts2.DiagnosticCategory.Error, "All_imports_in_import_declaration_are_unused_6192", "All imports in import declaration are unused.", true),
      Found_1_error_Watching_for_file_changes: diag(6193, ts2.DiagnosticCategory.Message, "Found_1_error_Watching_for_file_changes_6193", "Found 1 error. Watching for file changes."),
      Found_0_errors_Watching_for_file_changes: diag(6194, ts2.DiagnosticCategory.Message, "Found_0_errors_Watching_for_file_changes_6194", "Found {0} errors. Watching for file changes."),
      Resolve_keyof_to_string_valued_property_names_only_no_numbers_or_symbols: diag(6195, ts2.DiagnosticCategory.Message, "Resolve_keyof_to_string_valued_property_names_only_no_numbers_or_symbols_6195", "Resolve 'keyof' to string valued property names only (no numbers or symbols)."),
      _0_is_declared_but_never_used: diag(6196, ts2.DiagnosticCategory.Error, "_0_is_declared_but_never_used_6196", "'{0}' is declared but never used.", true),
      Include_modules_imported_with_json_extension: diag(6197, ts2.DiagnosticCategory.Message, "Include_modules_imported_with_json_extension_6197", "Include modules imported with '.json' extension"),
      All_destructured_elements_are_unused: diag(6198, ts2.DiagnosticCategory.Error, "All_destructured_elements_are_unused_6198", "All destructured elements are unused.", true),
      All_variables_are_unused: diag(6199, ts2.DiagnosticCategory.Error, "All_variables_are_unused_6199", "All variables are unused.", true),
      Definitions_of_the_following_identifiers_conflict_with_those_in_another_file_Colon_0: diag(6200, ts2.DiagnosticCategory.Error, "Definitions_of_the_following_identifiers_conflict_with_those_in_another_file_Colon_0_6200", "Definitions of the following identifiers conflict with those in another file: {0}"),
      Conflicts_are_in_this_file: diag(6201, ts2.DiagnosticCategory.Message, "Conflicts_are_in_this_file_6201", "Conflicts are in this file."),
      Project_references_may_not_form_a_circular_graph_Cycle_detected_Colon_0: diag(6202, ts2.DiagnosticCategory.Error, "Project_references_may_not_form_a_circular_graph_Cycle_detected_Colon_0_6202", "Project references may not form a circular graph. Cycle detected: {0}"),
      _0_was_also_declared_here: diag(6203, ts2.DiagnosticCategory.Message, "_0_was_also_declared_here_6203", "'{0}' was also declared here."),
      and_here: diag(6204, ts2.DiagnosticCategory.Message, "and_here_6204", "and here."),
      All_type_parameters_are_unused: diag(6205, ts2.DiagnosticCategory.Error, "All_type_parameters_are_unused_6205", "All type parameters are unused."),
      package_json_has_a_typesVersions_field_with_version_specific_path_mappings: diag(6206, ts2.DiagnosticCategory.Message, "package_json_has_a_typesVersions_field_with_version_specific_path_mappings_6206", "'package.json' has a 'typesVersions' field with version-specific path mappings."),
      package_json_does_not_have_a_typesVersions_entry_that_matches_version_0: diag(6207, ts2.DiagnosticCategory.Message, "package_json_does_not_have_a_typesVersions_entry_that_matches_version_0_6207", "'package.json' does not have a 'typesVersions' entry that matches version '{0}'."),
      package_json_has_a_typesVersions_entry_0_that_matches_compiler_version_1_looking_for_a_pattern_to_match_module_name_2: diag(6208, ts2.DiagnosticCategory.Message, "package_json_has_a_typesVersions_entry_0_that_matches_compiler_version_1_looking_for_a_pattern_to_ma_6208", "'package.json' has a 'typesVersions' entry '{0}' that matches compiler version '{1}', looking for a pattern to match module name '{2}'."),
      package_json_has_a_typesVersions_entry_0_that_is_not_a_valid_semver_range: diag(6209, ts2.DiagnosticCategory.Message, "package_json_has_a_typesVersions_entry_0_that_is_not_a_valid_semver_range_6209", "'package.json' has a 'typesVersions' entry '{0}' that is not a valid semver range."),
      An_argument_for_0_was_not_provided: diag(6210, ts2.DiagnosticCategory.Message, "An_argument_for_0_was_not_provided_6210", "An argument for '{0}' was not provided."),
      An_argument_matching_this_binding_pattern_was_not_provided: diag(6211, ts2.DiagnosticCategory.Message, "An_argument_matching_this_binding_pattern_was_not_provided_6211", "An argument matching this binding pattern was not provided."),
      Did_you_mean_to_call_this_expression: diag(6212, ts2.DiagnosticCategory.Message, "Did_you_mean_to_call_this_expression_6212", "Did you mean to call this expression?"),
      Did_you_mean_to_use_new_with_this_expression: diag(6213, ts2.DiagnosticCategory.Message, "Did_you_mean_to_use_new_with_this_expression_6213", "Did you mean to use 'new' with this expression?"),
      Enable_strict_bind_call_and_apply_methods_on_functions: diag(6214, ts2.DiagnosticCategory.Message, "Enable_strict_bind_call_and_apply_methods_on_functions_6214", "Enable strict 'bind', 'call', and 'apply' methods on functions."),
      Using_compiler_options_of_project_reference_redirect_0: diag(6215, ts2.DiagnosticCategory.Message, "Using_compiler_options_of_project_reference_redirect_0_6215", "Using compiler options of project reference redirect '{0}'."),
      Found_1_error: diag(6216, ts2.DiagnosticCategory.Message, "Found_1_error_6216", "Found 1 error."),
      Found_0_errors: diag(6217, ts2.DiagnosticCategory.Message, "Found_0_errors_6217", "Found {0} errors."),
      Module_name_0_was_successfully_resolved_to_1_with_Package_ID_2: diag(6218, ts2.DiagnosticCategory.Message, "Module_name_0_was_successfully_resolved_to_1_with_Package_ID_2_6218", "======== Module name '{0}' was successfully resolved to '{1}' with Package ID '{2}'. ========"),
      Type_reference_directive_0_was_successfully_resolved_to_1_with_Package_ID_2_primary_Colon_3: diag(6219, ts2.DiagnosticCategory.Message, "Type_reference_directive_0_was_successfully_resolved_to_1_with_Package_ID_2_primary_Colon_3_6219", "======== Type reference directive '{0}' was successfully resolved to '{1}' with Package ID '{2}', primary: {3}. ========"),
      package_json_had_a_falsy_0_field: diag(6220, ts2.DiagnosticCategory.Message, "package_json_had_a_falsy_0_field_6220", "'package.json' had a falsy '{0}' field."),
      Disable_use_of_source_files_instead_of_declaration_files_from_referenced_projects: diag(6221, ts2.DiagnosticCategory.Message, "Disable_use_of_source_files_instead_of_declaration_files_from_referenced_projects_6221", "Disable use of source files instead of declaration files from referenced projects."),
      Emit_class_fields_with_Define_instead_of_Set: diag(6222, ts2.DiagnosticCategory.Message, "Emit_class_fields_with_Define_instead_of_Set_6222", "Emit class fields with Define instead of Set."),
      Generates_a_CPU_profile: diag(6223, ts2.DiagnosticCategory.Message, "Generates_a_CPU_profile_6223", "Generates a CPU profile."),
      Disable_solution_searching_for_this_project: diag(6224, ts2.DiagnosticCategory.Message, "Disable_solution_searching_for_this_project_6224", "Disable solution searching for this project."),
      Specify_strategy_for_watching_file_Colon_FixedPollingInterval_default_PriorityPollingInterval_DynamicPriorityPolling_FixedChunkSizePolling_UseFsEvents_UseFsEventsOnParentDirectory: diag(6225, ts2.DiagnosticCategory.Message, "Specify_strategy_for_watching_file_Colon_FixedPollingInterval_default_PriorityPollingInterval_Dynami_6225", "Specify strategy for watching file: 'FixedPollingInterval' (default), 'PriorityPollingInterval', 'DynamicPriorityPolling', 'FixedChunkSizePolling', 'UseFsEvents', 'UseFsEventsOnParentDirectory'."),
      Specify_strategy_for_watching_directory_on_platforms_that_don_t_support_recursive_watching_natively_Colon_UseFsEvents_default_FixedPollingInterval_DynamicPriorityPolling_FixedChunkSizePolling: diag(6226, ts2.DiagnosticCategory.Message, "Specify_strategy_for_watching_directory_on_platforms_that_don_t_support_recursive_watching_natively__6226", "Specify strategy for watching directory on platforms that don't support recursive watching natively: 'UseFsEvents' (default), 'FixedPollingInterval', 'DynamicPriorityPolling', 'FixedChunkSizePolling'."),
      Specify_strategy_for_creating_a_polling_watch_when_it_fails_to_create_using_file_system_events_Colon_FixedInterval_default_PriorityInterval_DynamicPriority_FixedChunkSize: diag(6227, ts2.DiagnosticCategory.Message, "Specify_strategy_for_creating_a_polling_watch_when_it_fails_to_create_using_file_system_events_Colon_6227", "Specify strategy for creating a polling watch when it fails to create using file system events: 'FixedInterval' (default), 'PriorityInterval', 'DynamicPriority', 'FixedChunkSize'."),
      Tag_0_expects_at_least_1_arguments_but_the_JSX_factory_2_provides_at_most_3: diag(6229, ts2.DiagnosticCategory.Error, "Tag_0_expects_at_least_1_arguments_but_the_JSX_factory_2_provides_at_most_3_6229", "Tag '{0}' expects at least '{1}' arguments, but the JSX factory '{2}' provides at most '{3}'."),
      Option_0_can_only_be_specified_in_tsconfig_json_file_or_set_to_false_or_null_on_command_line: diag(6230, ts2.DiagnosticCategory.Error, "Option_0_can_only_be_specified_in_tsconfig_json_file_or_set_to_false_or_null_on_command_line_6230", "Option '{0}' can only be specified in 'tsconfig.json' file or set to 'false' or 'null' on command line."),
      Could_not_resolve_the_path_0_with_the_extensions_Colon_1: diag(6231, ts2.DiagnosticCategory.Error, "Could_not_resolve_the_path_0_with_the_extensions_Colon_1_6231", "Could not resolve the path '{0}' with the extensions: {1}."),
      Declaration_augments_declaration_in_another_file_This_cannot_be_serialized: diag(6232, ts2.DiagnosticCategory.Error, "Declaration_augments_declaration_in_another_file_This_cannot_be_serialized_6232", "Declaration augments declaration in another file. This cannot be serialized."),
      This_is_the_declaration_being_augmented_Consider_moving_the_augmenting_declaration_into_the_same_file: diag(6233, ts2.DiagnosticCategory.Error, "This_is_the_declaration_being_augmented_Consider_moving_the_augmenting_declaration_into_the_same_fil_6233", "This is the declaration being augmented. Consider moving the augmenting declaration into the same file."),
      This_expression_is_not_callable_because_it_is_a_get_accessor_Did_you_mean_to_use_it_without: diag(6234, ts2.DiagnosticCategory.Error, "This_expression_is_not_callable_because_it_is_a_get_accessor_Did_you_mean_to_use_it_without_6234", "This expression is not callable because it is a 'get' accessor. Did you mean to use it without '()'?"),
      Disable_loading_referenced_projects: diag(6235, ts2.DiagnosticCategory.Message, "Disable_loading_referenced_projects_6235", "Disable loading referenced projects."),
      Arguments_for_the_rest_parameter_0_were_not_provided: diag(6236, ts2.DiagnosticCategory.Error, "Arguments_for_the_rest_parameter_0_were_not_provided_6236", "Arguments for the rest parameter '{0}' were not provided."),
      Generates_an_event_trace_and_a_list_of_types: diag(6237, ts2.DiagnosticCategory.Message, "Generates_an_event_trace_and_a_list_of_types_6237", "Generates an event trace and a list of types."),
      Specify_the_module_specifier_to_be_used_to_import_the_jsx_and_jsxs_factory_functions_from_eg_react: diag(6238, ts2.DiagnosticCategory.Error, "Specify_the_module_specifier_to_be_used_to_import_the_jsx_and_jsxs_factory_functions_from_eg_react_6238", "Specify the module specifier to be used to import the 'jsx' and 'jsxs' factory functions from. eg, react"),
      File_0_exists_according_to_earlier_cached_lookups: diag(6239, ts2.DiagnosticCategory.Message, "File_0_exists_according_to_earlier_cached_lookups_6239", "File '{0}' exists according to earlier cached lookups."),
      File_0_does_not_exist_according_to_earlier_cached_lookups: diag(6240, ts2.DiagnosticCategory.Message, "File_0_does_not_exist_according_to_earlier_cached_lookups_6240", "File '{0}' does not exist according to earlier cached lookups."),
      Resolution_for_type_reference_directive_0_was_found_in_cache_from_location_1: diag(6241, ts2.DiagnosticCategory.Message, "Resolution_for_type_reference_directive_0_was_found_in_cache_from_location_1_6241", "Resolution for type reference directive '{0}' was found in cache from location '{1}'."),
      Resolving_type_reference_directive_0_containing_file_1: diag(6242, ts2.DiagnosticCategory.Message, "Resolving_type_reference_directive_0_containing_file_1_6242", "======== Resolving type reference directive '{0}', containing file '{1}'. ========"),
      Interpret_optional_property_types_as_written_rather_than_adding_undefined: diag(6243, ts2.DiagnosticCategory.Message, "Interpret_optional_property_types_as_written_rather_than_adding_undefined_6243", "Interpret optional property types as written, rather than adding 'undefined'."),
      Modules: diag(6244, ts2.DiagnosticCategory.Message, "Modules_6244", "Modules"),
      File_Management: diag(6245, ts2.DiagnosticCategory.Message, "File_Management_6245", "File Management"),
      Emit: diag(6246, ts2.DiagnosticCategory.Message, "Emit_6246", "Emit"),
      JavaScript_Support: diag(6247, ts2.DiagnosticCategory.Message, "JavaScript_Support_6247", "JavaScript Support"),
      Type_Checking: diag(6248, ts2.DiagnosticCategory.Message, "Type_Checking_6248", "Type Checking"),
      Editor_Support: diag(6249, ts2.DiagnosticCategory.Message, "Editor_Support_6249", "Editor Support"),
      Watch_and_Build_Modes: diag(6250, ts2.DiagnosticCategory.Message, "Watch_and_Build_Modes_6250", "Watch and Build Modes"),
      Compiler_Diagnostics: diag(6251, ts2.DiagnosticCategory.Message, "Compiler_Diagnostics_6251", "Compiler Diagnostics"),
      Interop_Constraints: diag(6252, ts2.DiagnosticCategory.Message, "Interop_Constraints_6252", "Interop Constraints"),
      Backwards_Compatibility: diag(6253, ts2.DiagnosticCategory.Message, "Backwards_Compatibility_6253", "Backwards Compatibility"),
      Language_and_Environment: diag(6254, ts2.DiagnosticCategory.Message, "Language_and_Environment_6254", "Language and Environment"),
      Projects: diag(6255, ts2.DiagnosticCategory.Message, "Projects_6255", "Projects"),
      Output_Formatting: diag(6256, ts2.DiagnosticCategory.Message, "Output_Formatting_6256", "Output Formatting"),
      Completeness: diag(6257, ts2.DiagnosticCategory.Message, "Completeness_6257", "Completeness"),
      Projects_to_reference: diag(6300, ts2.DiagnosticCategory.Message, "Projects_to_reference_6300", "Projects to reference"),
      Enable_project_compilation: diag(6302, ts2.DiagnosticCategory.Message, "Enable_project_compilation_6302", "Enable project compilation"),
      Composite_projects_may_not_disable_declaration_emit: diag(6304, ts2.DiagnosticCategory.Error, "Composite_projects_may_not_disable_declaration_emit_6304", "Composite projects may not disable declaration emit."),
      Output_file_0_has_not_been_built_from_source_file_1: diag(6305, ts2.DiagnosticCategory.Error, "Output_file_0_has_not_been_built_from_source_file_1_6305", "Output file '{0}' has not been built from source file '{1}'."),
      Referenced_project_0_must_have_setting_composite_Colon_true: diag(6306, ts2.DiagnosticCategory.Error, "Referenced_project_0_must_have_setting_composite_Colon_true_6306", `Referenced project '{0}' must have setting "composite": true.`),
      File_0_is_not_listed_within_the_file_list_of_project_1_Projects_must_list_all_files_or_use_an_include_pattern: diag(6307, ts2.DiagnosticCategory.Error, "File_0_is_not_listed_within_the_file_list_of_project_1_Projects_must_list_all_files_or_use_an_includ_6307", "File '{0}' is not listed within the file list of project '{1}'. Projects must list all files or use an 'include' pattern."),
      Cannot_prepend_project_0_because_it_does_not_have_outFile_set: diag(6308, ts2.DiagnosticCategory.Error, "Cannot_prepend_project_0_because_it_does_not_have_outFile_set_6308", "Cannot prepend project '{0}' because it does not have 'outFile' set"),
      Output_file_0_from_project_1_does_not_exist: diag(6309, ts2.DiagnosticCategory.Error, "Output_file_0_from_project_1_does_not_exist_6309", "Output file '{0}' from project '{1}' does not exist"),
      Referenced_project_0_may_not_disable_emit: diag(6310, ts2.DiagnosticCategory.Error, "Referenced_project_0_may_not_disable_emit_6310", "Referenced project '{0}' may not disable emit."),
      Project_0_is_out_of_date_because_oldest_output_1_is_older_than_newest_input_2: diag(6350, ts2.DiagnosticCategory.Message, "Project_0_is_out_of_date_because_oldest_output_1_is_older_than_newest_input_2_6350", "Project '{0}' is out of date because oldest output '{1}' is older than newest input '{2}'"),
      Project_0_is_up_to_date_because_newest_input_1_is_older_than_oldest_output_2: diag(6351, ts2.DiagnosticCategory.Message, "Project_0_is_up_to_date_because_newest_input_1_is_older_than_oldest_output_2_6351", "Project '{0}' is up to date because newest input '{1}' is older than oldest output '{2}'"),
      Project_0_is_out_of_date_because_output_file_1_does_not_exist: diag(6352, ts2.DiagnosticCategory.Message, "Project_0_is_out_of_date_because_output_file_1_does_not_exist_6352", "Project '{0}' is out of date because output file '{1}' does not exist"),
      Project_0_is_out_of_date_because_its_dependency_1_is_out_of_date: diag(6353, ts2.DiagnosticCategory.Message, "Project_0_is_out_of_date_because_its_dependency_1_is_out_of_date_6353", "Project '{0}' is out of date because its dependency '{1}' is out of date"),
      Project_0_is_up_to_date_with_d_ts_files_from_its_dependencies: diag(6354, ts2.DiagnosticCategory.Message, "Project_0_is_up_to_date_with_d_ts_files_from_its_dependencies_6354", "Project '{0}' is up to date with .d.ts files from its dependencies"),
      Projects_in_this_build_Colon_0: diag(6355, ts2.DiagnosticCategory.Message, "Projects_in_this_build_Colon_0_6355", "Projects in this build: {0}"),
      A_non_dry_build_would_delete_the_following_files_Colon_0: diag(6356, ts2.DiagnosticCategory.Message, "A_non_dry_build_would_delete_the_following_files_Colon_0_6356", "A non-dry build would delete the following files: {0}"),
      A_non_dry_build_would_build_project_0: diag(6357, ts2.DiagnosticCategory.Message, "A_non_dry_build_would_build_project_0_6357", "A non-dry build would build project '{0}'"),
      Building_project_0: diag(6358, ts2.DiagnosticCategory.Message, "Building_project_0_6358", "Building project '{0}'..."),
      Updating_output_timestamps_of_project_0: diag(6359, ts2.DiagnosticCategory.Message, "Updating_output_timestamps_of_project_0_6359", "Updating output timestamps of project '{0}'..."),
      delete_this_Project_0_is_up_to_date_because_it_was_previously_built: diag(6360, ts2.DiagnosticCategory.Message, "delete_this_Project_0_is_up_to_date_because_it_was_previously_built_6360", "delete this - Project '{0}' is up to date because it was previously built"),
      Project_0_is_up_to_date: diag(6361, ts2.DiagnosticCategory.Message, "Project_0_is_up_to_date_6361", "Project '{0}' is up to date"),
      Skipping_build_of_project_0_because_its_dependency_1_has_errors: diag(6362, ts2.DiagnosticCategory.Message, "Skipping_build_of_project_0_because_its_dependency_1_has_errors_6362", "Skipping build of project '{0}' because its dependency '{1}' has errors"),
      Project_0_can_t_be_built_because_its_dependency_1_has_errors: diag(6363, ts2.DiagnosticCategory.Message, "Project_0_can_t_be_built_because_its_dependency_1_has_errors_6363", "Project '{0}' can't be built because its dependency '{1}' has errors"),
      Build_one_or_more_projects_and_their_dependencies_if_out_of_date: diag(6364, ts2.DiagnosticCategory.Message, "Build_one_or_more_projects_and_their_dependencies_if_out_of_date_6364", "Build one or more projects and their dependencies, if out of date"),
      Delete_the_outputs_of_all_projects: diag(6365, ts2.DiagnosticCategory.Message, "Delete_the_outputs_of_all_projects_6365", "Delete the outputs of all projects"),
      Show_what_would_be_built_or_deleted_if_specified_with_clean: diag(6367, ts2.DiagnosticCategory.Message, "Show_what_would_be_built_or_deleted_if_specified_with_clean_6367", "Show what would be built (or deleted, if specified with '--clean')"),
      Option_build_must_be_the_first_command_line_argument: diag(6369, ts2.DiagnosticCategory.Error, "Option_build_must_be_the_first_command_line_argument_6369", "Option '--build' must be the first command line argument."),
      Options_0_and_1_cannot_be_combined: diag(6370, ts2.DiagnosticCategory.Error, "Options_0_and_1_cannot_be_combined_6370", "Options '{0}' and '{1}' cannot be combined."),
      Updating_unchanged_output_timestamps_of_project_0: diag(6371, ts2.DiagnosticCategory.Message, "Updating_unchanged_output_timestamps_of_project_0_6371", "Updating unchanged output timestamps of project '{0}'..."),
      Project_0_is_out_of_date_because_output_of_its_dependency_1_has_changed: diag(6372, ts2.DiagnosticCategory.Message, "Project_0_is_out_of_date_because_output_of_its_dependency_1_has_changed_6372", "Project '{0}' is out of date because output of its dependency '{1}' has changed"),
      Updating_output_of_project_0: diag(6373, ts2.DiagnosticCategory.Message, "Updating_output_of_project_0_6373", "Updating output of project '{0}'..."),
      A_non_dry_build_would_update_timestamps_for_output_of_project_0: diag(6374, ts2.DiagnosticCategory.Message, "A_non_dry_build_would_update_timestamps_for_output_of_project_0_6374", "A non-dry build would update timestamps for output of project '{0}'"),
      A_non_dry_build_would_update_output_of_project_0: diag(6375, ts2.DiagnosticCategory.Message, "A_non_dry_build_would_update_output_of_project_0_6375", "A non-dry build would update output of project '{0}'"),
      Cannot_update_output_of_project_0_because_there_was_error_reading_file_1: diag(6376, ts2.DiagnosticCategory.Message, "Cannot_update_output_of_project_0_because_there_was_error_reading_file_1_6376", "Cannot update output of project '{0}' because there was error reading file '{1}'"),
      Cannot_write_file_0_because_it_will_overwrite_tsbuildinfo_file_generated_by_referenced_project_1: diag(6377, ts2.DiagnosticCategory.Error, "Cannot_write_file_0_because_it_will_overwrite_tsbuildinfo_file_generated_by_referenced_project_1_6377", "Cannot write file '{0}' because it will overwrite '.tsbuildinfo' file generated by referenced project '{1}'"),
      Enable_incremental_compilation: diag(6378, ts2.DiagnosticCategory.Message, "Enable_incremental_compilation_6378", "Enable incremental compilation"),
      Composite_projects_may_not_disable_incremental_compilation: diag(6379, ts2.DiagnosticCategory.Error, "Composite_projects_may_not_disable_incremental_compilation_6379", "Composite projects may not disable incremental compilation."),
      Specify_file_to_store_incremental_compilation_information: diag(6380, ts2.DiagnosticCategory.Message, "Specify_file_to_store_incremental_compilation_information_6380", "Specify file to store incremental compilation information"),
      Project_0_is_out_of_date_because_output_for_it_was_generated_with_version_1_that_differs_with_current_version_2: diag(6381, ts2.DiagnosticCategory.Message, "Project_0_is_out_of_date_because_output_for_it_was_generated_with_version_1_that_differs_with_curren_6381", "Project '{0}' is out of date because output for it was generated with version '{1}' that differs with current version '{2}'"),
      Skipping_build_of_project_0_because_its_dependency_1_was_not_built: diag(6382, ts2.DiagnosticCategory.Message, "Skipping_build_of_project_0_because_its_dependency_1_was_not_built_6382", "Skipping build of project '{0}' because its dependency '{1}' was not built"),
      Project_0_can_t_be_built_because_its_dependency_1_was_not_built: diag(6383, ts2.DiagnosticCategory.Message, "Project_0_can_t_be_built_because_its_dependency_1_was_not_built_6383", "Project '{0}' can't be built because its dependency '{1}' was not built"),
      Have_recompiles_in_incremental_and_watch_assume_that_changes_within_a_file_will_only_affect_files_directly_depending_on_it: diag(6384, ts2.DiagnosticCategory.Message, "Have_recompiles_in_incremental_and_watch_assume_that_changes_within_a_file_will_only_affect_files_di_6384", "Have recompiles in '--incremental' and '--watch' assume that changes within a file will only affect files directly depending on it."),
      _0_is_deprecated: diag(6385, ts2.DiagnosticCategory.Suggestion, "_0_is_deprecated_6385", "'{0}' is deprecated.", void 0, void 0, true),
      Performance_timings_for_diagnostics_or_extendedDiagnostics_are_not_available_in_this_session_A_native_implementation_of_the_Web_Performance_API_could_not_be_found: diag(6386, ts2.DiagnosticCategory.Message, "Performance_timings_for_diagnostics_or_extendedDiagnostics_are_not_available_in_this_session_A_nativ_6386", "Performance timings for '--diagnostics' or '--extendedDiagnostics' are not available in this session. A native implementation of the Web Performance API could not be found."),
      The_signature_0_of_1_is_deprecated: diag(6387, ts2.DiagnosticCategory.Suggestion, "The_signature_0_of_1_is_deprecated_6387", "The signature '{0}' of '{1}' is deprecated.", void 0, void 0, true),
      Project_0_is_being_forcibly_rebuilt: diag(6388, ts2.DiagnosticCategory.Message, "Project_0_is_being_forcibly_rebuilt_6388", "Project '{0}' is being forcibly rebuilt"),
      Reusing_resolution_of_module_0_from_1_of_old_program_it_was_not_resolved: diag(6389, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_module_0_from_1_of_old_program_it_was_not_resolved_6389", "Reusing resolution of module '{0}' from '{1}' of old program, it was not resolved."),
      Reusing_resolution_of_type_reference_directive_0_from_1_of_old_program_it_was_successfully_resolved_to_2: diag(6390, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_type_reference_directive_0_from_1_of_old_program_it_was_successfully_resolved__6390", "Reusing resolution of type reference directive '{0}' from '{1}' of old program, it was successfully resolved to '{2}'."),
      Reusing_resolution_of_type_reference_directive_0_from_1_of_old_program_it_was_successfully_resolved_to_2_with_Package_ID_3: diag(6391, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_type_reference_directive_0_from_1_of_old_program_it_was_successfully_resolved__6391", "Reusing resolution of type reference directive '{0}' from '{1}' of old program, it was successfully resolved to '{2}' with Package ID '{3}'."),
      Reusing_resolution_of_type_reference_directive_0_from_1_of_old_program_it_was_not_resolved: diag(6392, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_type_reference_directive_0_from_1_of_old_program_it_was_not_resolved_6392", "Reusing resolution of type reference directive '{0}' from '{1}' of old program, it was not resolved."),
      Reusing_resolution_of_module_0_from_1_found_in_cache_from_location_2_it_was_successfully_resolved_to_3: diag(6393, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_module_0_from_1_found_in_cache_from_location_2_it_was_successfully_resolved_to_6393", "Reusing resolution of module '{0}' from '{1}' found in cache from location '{2}', it was successfully resolved to '{3}'."),
      Reusing_resolution_of_module_0_from_1_found_in_cache_from_location_2_it_was_successfully_resolved_to_3_with_Package_ID_4: diag(6394, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_module_0_from_1_found_in_cache_from_location_2_it_was_successfully_resolved_to_6394", "Reusing resolution of module '{0}' from '{1}' found in cache from location '{2}', it was successfully resolved to '{3}' with Package ID '{4}'."),
      Reusing_resolution_of_module_0_from_1_found_in_cache_from_location_2_it_was_not_resolved: diag(6395, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_module_0_from_1_found_in_cache_from_location_2_it_was_not_resolved_6395", "Reusing resolution of module '{0}' from '{1}' found in cache from location '{2}', it was not resolved."),
      Reusing_resolution_of_type_reference_directive_0_from_1_found_in_cache_from_location_2_it_was_successfully_resolved_to_3: diag(6396, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_type_reference_directive_0_from_1_found_in_cache_from_location_2_it_was_succes_6396", "Reusing resolution of type reference directive '{0}' from '{1}' found in cache from location '{2}', it was successfully resolved to '{3}'."),
      Reusing_resolution_of_type_reference_directive_0_from_1_found_in_cache_from_location_2_it_was_successfully_resolved_to_3_with_Package_ID_4: diag(6397, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_type_reference_directive_0_from_1_found_in_cache_from_location_2_it_was_succes_6397", "Reusing resolution of type reference directive '{0}' from '{1}' found in cache from location '{2}', it was successfully resolved to '{3}' with Package ID '{4}'."),
      Reusing_resolution_of_type_reference_directive_0_from_1_found_in_cache_from_location_2_it_was_not_resolved: diag(6398, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_type_reference_directive_0_from_1_found_in_cache_from_location_2_it_was_not_re_6398", "Reusing resolution of type reference directive '{0}' from '{1}' found in cache from location '{2}', it was not resolved."),
      The_expected_type_comes_from_property_0_which_is_declared_here_on_type_1: diag(6500, ts2.DiagnosticCategory.Message, "The_expected_type_comes_from_property_0_which_is_declared_here_on_type_1_6500", "The expected type comes from property '{0}' which is declared here on type '{1}'"),
      The_expected_type_comes_from_this_index_signature: diag(6501, ts2.DiagnosticCategory.Message, "The_expected_type_comes_from_this_index_signature_6501", "The expected type comes from this index signature."),
      The_expected_type_comes_from_the_return_type_of_this_signature: diag(6502, ts2.DiagnosticCategory.Message, "The_expected_type_comes_from_the_return_type_of_this_signature_6502", "The expected type comes from the return type of this signature."),
      Print_names_of_files_that_are_part_of_the_compilation_and_then_stop_processing: diag(6503, ts2.DiagnosticCategory.Message, "Print_names_of_files_that_are_part_of_the_compilation_and_then_stop_processing_6503", "Print names of files that are part of the compilation and then stop processing."),
      File_0_is_a_JavaScript_file_Did_you_mean_to_enable_the_allowJs_option: diag(6504, ts2.DiagnosticCategory.Error, "File_0_is_a_JavaScript_file_Did_you_mean_to_enable_the_allowJs_option_6504", "File '{0}' is a JavaScript file. Did you mean to enable the 'allowJs' option?"),
      Print_names_of_files_and_the_reason_they_are_part_of_the_compilation: diag(6505, ts2.DiagnosticCategory.Message, "Print_names_of_files_and_the_reason_they_are_part_of_the_compilation_6505", "Print names of files and the reason they are part of the compilation."),
      Consider_adding_a_declare_modifier_to_this_class: diag(6506, ts2.DiagnosticCategory.Message, "Consider_adding_a_declare_modifier_to_this_class_6506", "Consider adding a 'declare' modifier to this class."),
      Allow_JavaScript_files_to_be_a_part_of_your_program_Use_the_checkJS_option_to_get_errors_from_these_files: diag(6600, ts2.DiagnosticCategory.Message, "Allow_JavaScript_files_to_be_a_part_of_your_program_Use_the_checkJS_option_to_get_errors_from_these__6600", "Allow JavaScript files to be a part of your program. Use the `checkJS` option to get errors from these files."),
      Allow_import_x_from_y_when_a_module_doesn_t_have_a_default_export: diag(6601, ts2.DiagnosticCategory.Message, "Allow_import_x_from_y_when_a_module_doesn_t_have_a_default_export_6601", "Allow 'import x from y' when a module doesn't have a default export."),
      Allow_accessing_UMD_globals_from_modules: diag(6602, ts2.DiagnosticCategory.Message, "Allow_accessing_UMD_globals_from_modules_6602", "Allow accessing UMD globals from modules."),
      Disable_error_reporting_for_unreachable_code: diag(6603, ts2.DiagnosticCategory.Message, "Disable_error_reporting_for_unreachable_code_6603", "Disable error reporting for unreachable code."),
      Disable_error_reporting_for_unused_labels: diag(6604, ts2.DiagnosticCategory.Message, "Disable_error_reporting_for_unused_labels_6604", "Disable error reporting for unused labels."),
      Ensure_use_strict_is_always_emitted: diag(6605, ts2.DiagnosticCategory.Message, "Ensure_use_strict_is_always_emitted_6605", "Ensure 'use strict' is always emitted."),
      Have_recompiles_in_projects_that_use_incremental_and_watch_mode_assume_that_changes_within_a_file_will_only_affect_files_directly_depending_on_it: diag(6606, ts2.DiagnosticCategory.Message, "Have_recompiles_in_projects_that_use_incremental_and_watch_mode_assume_that_changes_within_a_file_wi_6606", "Have recompiles in projects that use `incremental` and `watch` mode assume that changes within a file will only affect files directly depending on it."),
      Specify_the_base_directory_to_resolve_non_relative_module_names: diag(6607, ts2.DiagnosticCategory.Message, "Specify_the_base_directory_to_resolve_non_relative_module_names_6607", "Specify the base directory to resolve non-relative module names."),
      No_longer_supported_In_early_versions_manually_set_the_text_encoding_for_reading_files: diag(6608, ts2.DiagnosticCategory.Message, "No_longer_supported_In_early_versions_manually_set_the_text_encoding_for_reading_files_6608", "No longer supported. In early versions, manually set the text encoding for reading files."),
      Enable_error_reporting_in_type_checked_JavaScript_files: diag(6609, ts2.DiagnosticCategory.Message, "Enable_error_reporting_in_type_checked_JavaScript_files_6609", "Enable error reporting in type-checked JavaScript files."),
      Enable_constraints_that_allow_a_TypeScript_project_to_be_used_with_project_references: diag(6611, ts2.DiagnosticCategory.Message, "Enable_constraints_that_allow_a_TypeScript_project_to_be_used_with_project_references_6611", "Enable constraints that allow a TypeScript project to be used with project references."),
      Generate_d_ts_files_from_TypeScript_and_JavaScript_files_in_your_project: diag(6612, ts2.DiagnosticCategory.Message, "Generate_d_ts_files_from_TypeScript_and_JavaScript_files_in_your_project_6612", "Generate .d.ts files from TypeScript and JavaScript files in your project."),
      Specify_the_output_directory_for_generated_declaration_files: diag(6613, ts2.DiagnosticCategory.Message, "Specify_the_output_directory_for_generated_declaration_files_6613", "Specify the output directory for generated declaration files."),
      Create_sourcemaps_for_d_ts_files: diag(6614, ts2.DiagnosticCategory.Message, "Create_sourcemaps_for_d_ts_files_6614", "Create sourcemaps for d.ts files."),
      Output_compiler_performance_information_after_building: diag(6615, ts2.DiagnosticCategory.Message, "Output_compiler_performance_information_after_building_6615", "Output compiler performance information after building."),
      Disables_inference_for_type_acquisition_by_looking_at_filenames_in_a_project: diag(6616, ts2.DiagnosticCategory.Message, "Disables_inference_for_type_acquisition_by_looking_at_filenames_in_a_project_6616", "Disables inference for type acquisition by looking at filenames in a project."),
      Reduce_the_number_of_projects_loaded_automatically_by_TypeScript: diag(6617, ts2.DiagnosticCategory.Message, "Reduce_the_number_of_projects_loaded_automatically_by_TypeScript_6617", "Reduce the number of projects loaded automatically by TypeScript."),
      Remove_the_20mb_cap_on_total_source_code_size_for_JavaScript_files_in_the_TypeScript_language_server: diag(6618, ts2.DiagnosticCategory.Message, "Remove_the_20mb_cap_on_total_source_code_size_for_JavaScript_files_in_the_TypeScript_language_server_6618", "Remove the 20mb cap on total source code size for JavaScript files in the TypeScript language server."),
      Opt_a_project_out_of_multi_project_reference_checking_when_editing: diag(6619, ts2.DiagnosticCategory.Message, "Opt_a_project_out_of_multi_project_reference_checking_when_editing_6619", "Opt a project out of multi-project reference checking when editing."),
      Disable_preferring_source_files_instead_of_declaration_files_when_referencing_composite_projects: diag(6620, ts2.DiagnosticCategory.Message, "Disable_preferring_source_files_instead_of_declaration_files_when_referencing_composite_projects_6620", "Disable preferring source files instead of declaration files when referencing composite projects"),
      Emit_more_compliant_but_verbose_and_less_performant_JavaScript_for_iteration: diag(6621, ts2.DiagnosticCategory.Message, "Emit_more_compliant_but_verbose_and_less_performant_JavaScript_for_iteration_6621", "Emit more compliant, but verbose and less performant JavaScript for iteration."),
      Only_output_d_ts_files_and_not_JavaScript_files: diag(6623, ts2.DiagnosticCategory.Message, "Only_output_d_ts_files_and_not_JavaScript_files_6623", "Only output d.ts files and not JavaScript files."),
      Emit_design_type_metadata_for_decorated_declarations_in_source_files: diag(6624, ts2.DiagnosticCategory.Message, "Emit_design_type_metadata_for_decorated_declarations_in_source_files_6624", "Emit design-type metadata for decorated declarations in source files."),
      Disable_the_type_acquisition_for_JavaScript_projects: diag(6625, ts2.DiagnosticCategory.Message, "Disable_the_type_acquisition_for_JavaScript_projects_6625", "Disable the type acquisition for JavaScript projects"),
      Emit_additional_JavaScript_to_ease_support_for_importing_CommonJS_modules_This_enables_allowSyntheticDefaultImports_for_type_compatibility: diag(6626, ts2.DiagnosticCategory.Message, "Emit_additional_JavaScript_to_ease_support_for_importing_CommonJS_modules_This_enables_allowSyntheti_6626", "Emit additional JavaScript to ease support for importing CommonJS modules. This enables `allowSyntheticDefaultImports` for type compatibility."),
      Filters_results_from_the_include_option: diag(6627, ts2.DiagnosticCategory.Message, "Filters_results_from_the_include_option_6627", "Filters results from the `include` option."),
      Remove_a_list_of_directories_from_the_watch_process: diag(6628, ts2.DiagnosticCategory.Message, "Remove_a_list_of_directories_from_the_watch_process_6628", "Remove a list of directories from the watch process."),
      Remove_a_list_of_files_from_the_watch_mode_s_processing: diag(6629, ts2.DiagnosticCategory.Message, "Remove_a_list_of_files_from_the_watch_mode_s_processing_6629", "Remove a list of files from the watch mode's processing."),
      Enable_experimental_support_for_TC39_stage_2_draft_decorators: diag(6630, ts2.DiagnosticCategory.Message, "Enable_experimental_support_for_TC39_stage_2_draft_decorators_6630", "Enable experimental support for TC39 stage 2 draft decorators."),
      Print_files_read_during_the_compilation_including_why_it_was_included: diag(6631, ts2.DiagnosticCategory.Message, "Print_files_read_during_the_compilation_including_why_it_was_included_6631", "Print files read during the compilation including why it was included."),
      Output_more_detailed_compiler_performance_information_after_building: diag(6632, ts2.DiagnosticCategory.Message, "Output_more_detailed_compiler_performance_information_after_building_6632", "Output more detailed compiler performance information after building."),
      Specify_one_or_more_path_or_node_module_references_to_base_configuration_files_from_which_settings_are_inherited: diag(6633, ts2.DiagnosticCategory.Message, "Specify_one_or_more_path_or_node_module_references_to_base_configuration_files_from_which_settings_a_6633", "Specify one or more path or node module references to base configuration files from which settings are inherited."),
      Specify_what_approach_the_watcher_should_use_if_the_system_runs_out_of_native_file_watchers: diag(6634, ts2.DiagnosticCategory.Message, "Specify_what_approach_the_watcher_should_use_if_the_system_runs_out_of_native_file_watchers_6634", "Specify what approach the watcher should use if the system runs out of native file watchers."),
      Include_a_list_of_files_This_does_not_support_glob_patterns_as_opposed_to_include: diag(6635, ts2.DiagnosticCategory.Message, "Include_a_list_of_files_This_does_not_support_glob_patterns_as_opposed_to_include_6635", "Include a list of files. This does not support glob patterns, as opposed to `include`."),
      Build_all_projects_including_those_that_appear_to_be_up_to_date: diag(6636, ts2.DiagnosticCategory.Message, "Build_all_projects_including_those_that_appear_to_be_up_to_date_6636", "Build all projects, including those that appear to be up to date"),
      Ensure_that_casing_is_correct_in_imports: diag(6637, ts2.DiagnosticCategory.Message, "Ensure_that_casing_is_correct_in_imports_6637", "Ensure that casing is correct in imports."),
      Emit_a_v8_CPU_profile_of_the_compiler_run_for_debugging: diag(6638, ts2.DiagnosticCategory.Message, "Emit_a_v8_CPU_profile_of_the_compiler_run_for_debugging_6638", "Emit a v8 CPU profile of the compiler run for debugging."),
      Allow_importing_helper_functions_from_tslib_once_per_project_instead_of_including_them_per_file: diag(6639, ts2.DiagnosticCategory.Message, "Allow_importing_helper_functions_from_tslib_once_per_project_instead_of_including_them_per_file_6639", "Allow importing helper functions from tslib once per project, instead of including them per-file."),
      Specify_a_list_of_glob_patterns_that_match_files_to_be_included_in_compilation: diag(6641, ts2.DiagnosticCategory.Message, "Specify_a_list_of_glob_patterns_that_match_files_to_be_included_in_compilation_6641", "Specify a list of glob patterns that match files to be included in compilation."),
      Save_tsbuildinfo_files_to_allow_for_incremental_compilation_of_projects: diag(6642, ts2.DiagnosticCategory.Message, "Save_tsbuildinfo_files_to_allow_for_incremental_compilation_of_projects_6642", "Save .tsbuildinfo files to allow for incremental compilation of projects."),
      Include_sourcemap_files_inside_the_emitted_JavaScript: diag(6643, ts2.DiagnosticCategory.Message, "Include_sourcemap_files_inside_the_emitted_JavaScript_6643", "Include sourcemap files inside the emitted JavaScript."),
      Include_source_code_in_the_sourcemaps_inside_the_emitted_JavaScript: diag(6644, ts2.DiagnosticCategory.Message, "Include_source_code_in_the_sourcemaps_inside_the_emitted_JavaScript_6644", "Include source code in the sourcemaps inside the emitted JavaScript."),
      Ensure_that_each_file_can_be_safely_transpiled_without_relying_on_other_imports: diag(6645, ts2.DiagnosticCategory.Message, "Ensure_that_each_file_can_be_safely_transpiled_without_relying_on_other_imports_6645", "Ensure that each file can be safely transpiled without relying on other imports."),
      Specify_what_JSX_code_is_generated: diag(6646, ts2.DiagnosticCategory.Message, "Specify_what_JSX_code_is_generated_6646", "Specify what JSX code is generated."),
      Specify_the_JSX_factory_function_used_when_targeting_React_JSX_emit_e_g_React_createElement_or_h: diag(6647, ts2.DiagnosticCategory.Message, "Specify_the_JSX_factory_function_used_when_targeting_React_JSX_emit_e_g_React_createElement_or_h_6647", "Specify the JSX factory function used when targeting React JSX emit, e.g. 'React.createElement' or 'h'"),
      Specify_the_JSX_Fragment_reference_used_for_fragments_when_targeting_React_JSX_emit_e_g_React_Fragment_or_Fragment: diag(6648, ts2.DiagnosticCategory.Message, "Specify_the_JSX_Fragment_reference_used_for_fragments_when_targeting_React_JSX_emit_e_g_React_Fragme_6648", "Specify the JSX Fragment reference used for fragments when targeting React JSX emit e.g. 'React.Fragment' or 'Fragment'."),
      Specify_module_specifier_used_to_import_the_JSX_factory_functions_when_using_jsx_Colon_react_jsx_Asterisk: diag(6649, ts2.DiagnosticCategory.Message, "Specify_module_specifier_used_to_import_the_JSX_factory_functions_when_using_jsx_Colon_react_jsx_Ast_6649", "Specify module specifier used to import the JSX factory functions when using `jsx: react-jsx*`.`"),
      Make_keyof_only_return_strings_instead_of_string_numbers_or_symbols_Legacy_option: diag(6650, ts2.DiagnosticCategory.Message, "Make_keyof_only_return_strings_instead_of_string_numbers_or_symbols_Legacy_option_6650", "Make keyof only return strings instead of string, numbers or symbols. Legacy option."),
      Specify_a_set_of_bundled_library_declaration_files_that_describe_the_target_runtime_environment: diag(6651, ts2.DiagnosticCategory.Message, "Specify_a_set_of_bundled_library_declaration_files_that_describe_the_target_runtime_environment_6651", "Specify a set of bundled library declaration files that describe the target runtime environment."),
      Print_the_names_of_emitted_files_after_a_compilation: diag(6652, ts2.DiagnosticCategory.Message, "Print_the_names_of_emitted_files_after_a_compilation_6652", "Print the names of emitted files after a compilation."),
      Print_all_of_the_files_read_during_the_compilation: diag(6653, ts2.DiagnosticCategory.Message, "Print_all_of_the_files_read_during_the_compilation_6653", "Print all of the files read during the compilation."),
      Set_the_language_of_the_messaging_from_TypeScript_This_does_not_affect_emit: diag(6654, ts2.DiagnosticCategory.Message, "Set_the_language_of_the_messaging_from_TypeScript_This_does_not_affect_emit_6654", "Set the language of the messaging from TypeScript. This does not affect emit."),
      Specify_the_maximum_folder_depth_used_for_checking_JavaScript_files_from_node_modules_Only_applicable_with_allowJs: diag(6656, ts2.DiagnosticCategory.Message, "Specify_the_maximum_folder_depth_used_for_checking_JavaScript_files_from_node_modules_Only_applicabl_6656", "Specify the maximum folder depth used for checking JavaScript files from `node_modules`. Only applicable with `allowJs`."),
      Specify_what_module_code_is_generated: diag(6657, ts2.DiagnosticCategory.Message, "Specify_what_module_code_is_generated_6657", "Specify what module code is generated."),
      Specify_how_TypeScript_looks_up_a_file_from_a_given_module_specifier: diag(6658, ts2.DiagnosticCategory.Message, "Specify_how_TypeScript_looks_up_a_file_from_a_given_module_specifier_6658", "Specify how TypeScript looks up a file from a given module specifier."),
      Set_the_newline_character_for_emitting_files: diag(6659, ts2.DiagnosticCategory.Message, "Set_the_newline_character_for_emitting_files_6659", "Set the newline character for emitting files."),
      Disable_emitting_files_from_a_compilation: diag(6660, ts2.DiagnosticCategory.Message, "Disable_emitting_files_from_a_compilation_6660", "Disable emitting files from a compilation."),
      Disable_generating_custom_helper_functions_like_extends_in_compiled_output: diag(6661, ts2.DiagnosticCategory.Message, "Disable_generating_custom_helper_functions_like_extends_in_compiled_output_6661", "Disable generating custom helper functions like `__extends` in compiled output."),
      Disable_emitting_files_if_any_type_checking_errors_are_reported: diag(6662, ts2.DiagnosticCategory.Message, "Disable_emitting_files_if_any_type_checking_errors_are_reported_6662", "Disable emitting files if any type checking errors are reported."),
      Disable_truncating_types_in_error_messages: diag(6663, ts2.DiagnosticCategory.Message, "Disable_truncating_types_in_error_messages_6663", "Disable truncating types in error messages."),
      Enable_error_reporting_for_fallthrough_cases_in_switch_statements: diag(6664, ts2.DiagnosticCategory.Message, "Enable_error_reporting_for_fallthrough_cases_in_switch_statements_6664", "Enable error reporting for fallthrough cases in switch statements."),
      Enable_error_reporting_for_expressions_and_declarations_with_an_implied_any_type: diag(6665, ts2.DiagnosticCategory.Message, "Enable_error_reporting_for_expressions_and_declarations_with_an_implied_any_type_6665", "Enable error reporting for expressions and declarations with an implied `any` type.."),
      Ensure_overriding_members_in_derived_classes_are_marked_with_an_override_modifier: diag(6666, ts2.DiagnosticCategory.Message, "Ensure_overriding_members_in_derived_classes_are_marked_with_an_override_modifier_6666", "Ensure overriding members in derived classes are marked with an override modifier."),
      Enable_error_reporting_for_codepaths_that_do_not_explicitly_return_in_a_function: diag(6667, ts2.DiagnosticCategory.Message, "Enable_error_reporting_for_codepaths_that_do_not_explicitly_return_in_a_function_6667", "Enable error reporting for codepaths that do not explicitly return in a function."),
      Enable_error_reporting_when_this_is_given_the_type_any: diag(6668, ts2.DiagnosticCategory.Message, "Enable_error_reporting_when_this_is_given_the_type_any_6668", "Enable error reporting when `this` is given the type `any`."),
      Disable_adding_use_strict_directives_in_emitted_JavaScript_files: diag(6669, ts2.DiagnosticCategory.Message, "Disable_adding_use_strict_directives_in_emitted_JavaScript_files_6669", "Disable adding 'use strict' directives in emitted JavaScript files."),
      Disable_including_any_library_files_including_the_default_lib_d_ts: diag(6670, ts2.DiagnosticCategory.Message, "Disable_including_any_library_files_including_the_default_lib_d_ts_6670", "Disable including any library files, including the default lib.d.ts."),
      Enforces_using_indexed_accessors_for_keys_declared_using_an_indexed_type: diag(6671, ts2.DiagnosticCategory.Message, "Enforces_using_indexed_accessors_for_keys_declared_using_an_indexed_type_6671", "Enforces using indexed accessors for keys declared using an indexed type"),
      Disallow_import_s_require_s_or_reference_s_from_expanding_the_number_of_files_TypeScript_should_add_to_a_project: diag(6672, ts2.DiagnosticCategory.Message, "Disallow_import_s_require_s_or_reference_s_from_expanding_the_number_of_files_TypeScript_should_add__6672", "Disallow `import`s, `require`s or `<reference>`s from expanding the number of files TypeScript should add to a project."),
      Disable_strict_checking_of_generic_signatures_in_function_types: diag(6673, ts2.DiagnosticCategory.Message, "Disable_strict_checking_of_generic_signatures_in_function_types_6673", "Disable strict checking of generic signatures in function types."),
      Add_undefined_to_a_type_when_accessed_using_an_index: diag(6674, ts2.DiagnosticCategory.Message, "Add_undefined_to_a_type_when_accessed_using_an_index_6674", "Add `undefined` to a type when accessed using an index."),
      Enable_error_reporting_when_a_local_variables_aren_t_read: diag(6675, ts2.DiagnosticCategory.Message, "Enable_error_reporting_when_a_local_variables_aren_t_read_6675", "Enable error reporting when a local variables aren't read."),
      Raise_an_error_when_a_function_parameter_isn_t_read: diag(6676, ts2.DiagnosticCategory.Message, "Raise_an_error_when_a_function_parameter_isn_t_read_6676", "Raise an error when a function parameter isn't read"),
      Deprecated_setting_Use_outFile_instead: diag(6677, ts2.DiagnosticCategory.Message, "Deprecated_setting_Use_outFile_instead_6677", "Deprecated setting. Use `outFile` instead."),
      Specify_an_output_folder_for_all_emitted_files: diag(6678, ts2.DiagnosticCategory.Message, "Specify_an_output_folder_for_all_emitted_files_6678", "Specify an output folder for all emitted files."),
      Specify_a_file_that_bundles_all_outputs_into_one_JavaScript_file_If_declaration_is_true_also_designates_a_file_that_bundles_all_d_ts_output: diag(6679, ts2.DiagnosticCategory.Message, "Specify_a_file_that_bundles_all_outputs_into_one_JavaScript_file_If_declaration_is_true_also_designa_6679", "Specify a file that bundles all outputs into one JavaScript file. If `declaration` is true, also designates a file that bundles all .d.ts output."),
      Specify_a_set_of_entries_that_re_map_imports_to_additional_lookup_locations: diag(6680, ts2.DiagnosticCategory.Message, "Specify_a_set_of_entries_that_re_map_imports_to_additional_lookup_locations_6680", "Specify a set of entries that re-map imports to additional lookup locations."),
      Specify_a_list_of_language_service_plugins_to_include: diag(6681, ts2.DiagnosticCategory.Message, "Specify_a_list_of_language_service_plugins_to_include_6681", "Specify a list of language service plugins to include."),
      Disable_erasing_const_enum_declarations_in_generated_code: diag(6682, ts2.DiagnosticCategory.Message, "Disable_erasing_const_enum_declarations_in_generated_code_6682", "Disable erasing `const enum` declarations in generated code."),
      Disable_resolving_symlinks_to_their_realpath_This_correlates_to_the_same_flag_in_node: diag(6683, ts2.DiagnosticCategory.Message, "Disable_resolving_symlinks_to_their_realpath_This_correlates_to_the_same_flag_in_node_6683", "Disable resolving symlinks to their realpath. This correlates to the same flag in node."),
      Disable_wiping_the_console_in_watch_mode: diag(6684, ts2.DiagnosticCategory.Message, "Disable_wiping_the_console_in_watch_mode_6684", "Disable wiping the console in watch mode"),
      Enable_color_and_formatting_in_TypeScript_s_output_to_make_compiler_errors_easier_to_read: diag(6685, ts2.DiagnosticCategory.Message, "Enable_color_and_formatting_in_TypeScript_s_output_to_make_compiler_errors_easier_to_read_6685", "Enable color and formatting in TypeScript's output to make compiler errors easier to read"),
      Specify_the_object_invoked_for_createElement_This_only_applies_when_targeting_react_JSX_emit: diag(6686, ts2.DiagnosticCategory.Message, "Specify_the_object_invoked_for_createElement_This_only_applies_when_targeting_react_JSX_emit_6686", "Specify the object invoked for `createElement`. This only applies when targeting `react` JSX emit."),
      Specify_an_array_of_objects_that_specify_paths_for_projects_Used_in_project_references: diag(6687, ts2.DiagnosticCategory.Message, "Specify_an_array_of_objects_that_specify_paths_for_projects_Used_in_project_references_6687", "Specify an array of objects that specify paths for projects. Used in project references."),
      Disable_emitting_comments: diag(6688, ts2.DiagnosticCategory.Message, "Disable_emitting_comments_6688", "Disable emitting comments."),
      Enable_importing_json_files: diag(6689, ts2.DiagnosticCategory.Message, "Enable_importing_json_files_6689", "Enable importing .json files"),
      Specify_the_root_folder_within_your_source_files: diag(6690, ts2.DiagnosticCategory.Message, "Specify_the_root_folder_within_your_source_files_6690", "Specify the root folder within your source files."),
      Allow_multiple_folders_to_be_treated_as_one_when_resolving_modules: diag(6691, ts2.DiagnosticCategory.Message, "Allow_multiple_folders_to_be_treated_as_one_when_resolving_modules_6691", "Allow multiple folders to be treated as one when resolving modules."),
      Skip_type_checking_d_ts_files_that_are_included_with_TypeScript: diag(6692, ts2.DiagnosticCategory.Message, "Skip_type_checking_d_ts_files_that_are_included_with_TypeScript_6692", "Skip type checking .d.ts files that are included with TypeScript."),
      Skip_type_checking_all_d_ts_files: diag(6693, ts2.DiagnosticCategory.Message, "Skip_type_checking_all_d_ts_files_6693", "Skip type checking all .d.ts files."),
      Create_source_map_files_for_emitted_JavaScript_files: diag(6694, ts2.DiagnosticCategory.Message, "Create_source_map_files_for_emitted_JavaScript_files_6694", "Create source map files for emitted JavaScript files."),
      Specify_the_root_path_for_debuggers_to_find_the_reference_source_code: diag(6695, ts2.DiagnosticCategory.Message, "Specify_the_root_path_for_debuggers_to_find_the_reference_source_code_6695", "Specify the root path for debuggers to find the reference source code."),
      Check_that_the_arguments_for_bind_call_and_apply_methods_match_the_original_function: diag(6697, ts2.DiagnosticCategory.Message, "Check_that_the_arguments_for_bind_call_and_apply_methods_match_the_original_function_6697", "Check that the arguments for `bind`, `call`, and `apply` methods match the original function."),
      When_assigning_functions_check_to_ensure_parameters_and_the_return_values_are_subtype_compatible: diag(6698, ts2.DiagnosticCategory.Message, "When_assigning_functions_check_to_ensure_parameters_and_the_return_values_are_subtype_compatible_6698", "When assigning functions, check to ensure parameters and the return values are subtype-compatible."),
      When_type_checking_take_into_account_null_and_undefined: diag(6699, ts2.DiagnosticCategory.Message, "When_type_checking_take_into_account_null_and_undefined_6699", "When type checking, take into account `null` and `undefined`."),
      Check_for_class_properties_that_are_declared_but_not_set_in_the_constructor: diag(6700, ts2.DiagnosticCategory.Message, "Check_for_class_properties_that_are_declared_but_not_set_in_the_constructor_6700", "Check for class properties that are declared but not set in the constructor."),
      Disable_emitting_declarations_that_have_internal_in_their_JSDoc_comments: diag(6701, ts2.DiagnosticCategory.Message, "Disable_emitting_declarations_that_have_internal_in_their_JSDoc_comments_6701", "Disable emitting declarations that have `@internal` in their JSDoc comments."),
      Disable_reporting_of_excess_property_errors_during_the_creation_of_object_literals: diag(6702, ts2.DiagnosticCategory.Message, "Disable_reporting_of_excess_property_errors_during_the_creation_of_object_literals_6702", "Disable reporting of excess property errors during the creation of object literals."),
      Suppress_noImplicitAny_errors_when_indexing_objects_that_lack_index_signatures: diag(6703, ts2.DiagnosticCategory.Message, "Suppress_noImplicitAny_errors_when_indexing_objects_that_lack_index_signatures_6703", "Suppress `noImplicitAny` errors when indexing objects that lack index signatures."),
      Synchronously_call_callbacks_and_update_the_state_of_directory_watchers_on_platforms_that_don_t_support_recursive_watching_natively: diag(6704, ts2.DiagnosticCategory.Message, "Synchronously_call_callbacks_and_update_the_state_of_directory_watchers_on_platforms_that_don_t_supp_6704", "Synchronously call callbacks and update the state of directory watchers on platforms that don`t support recursive watching natively."),
      Set_the_JavaScript_language_version_for_emitted_JavaScript_and_include_compatible_library_declarations: diag(6705, ts2.DiagnosticCategory.Message, "Set_the_JavaScript_language_version_for_emitted_JavaScript_and_include_compatible_library_declaratio_6705", "Set the JavaScript language version for emitted JavaScript and include compatible library declarations."),
      Log_paths_used_during_the_moduleResolution_process: diag(6706, ts2.DiagnosticCategory.Message, "Log_paths_used_during_the_moduleResolution_process_6706", "Log paths used during the `moduleResolution` process."),
      Specify_the_folder_for_tsbuildinfo_incremental_compilation_files: diag(6707, ts2.DiagnosticCategory.Message, "Specify_the_folder_for_tsbuildinfo_incremental_compilation_files_6707", "Specify the folder for .tsbuildinfo incremental compilation files."),
      Specify_options_for_automatic_acquisition_of_declaration_files: diag(6709, ts2.DiagnosticCategory.Message, "Specify_options_for_automatic_acquisition_of_declaration_files_6709", "Specify options for automatic acquisition of declaration files."),
      Specify_multiple_folders_that_act_like_Slashnode_modules_Slash_types: diag(6710, ts2.DiagnosticCategory.Message, "Specify_multiple_folders_that_act_like_Slashnode_modules_Slash_types_6710", "Specify multiple folders that act like `./node_modules/@types`."),
      Specify_type_package_names_to_be_included_without_being_referenced_in_a_source_file: diag(6711, ts2.DiagnosticCategory.Message, "Specify_type_package_names_to_be_included_without_being_referenced_in_a_source_file_6711", "Specify type package names to be included without being referenced in a source file."),
      Emit_ECMAScript_standard_compliant_class_fields: diag(6712, ts2.DiagnosticCategory.Message, "Emit_ECMAScript_standard_compliant_class_fields_6712", "Emit ECMAScript-standard-compliant class fields."),
      Enable_verbose_logging: diag(6713, ts2.DiagnosticCategory.Message, "Enable_verbose_logging_6713", "Enable verbose logging"),
      Specify_how_directories_are_watched_on_systems_that_lack_recursive_file_watching_functionality: diag(6714, ts2.DiagnosticCategory.Message, "Specify_how_directories_are_watched_on_systems_that_lack_recursive_file_watching_functionality_6714", "Specify how directories are watched on systems that lack recursive file-watching functionality."),
      Specify_how_the_TypeScript_watch_mode_works: diag(6715, ts2.DiagnosticCategory.Message, "Specify_how_the_TypeScript_watch_mode_works_6715", "Specify how the TypeScript watch mode works."),
      Include_undefined_in_index_signature_results: diag(6716, ts2.DiagnosticCategory.Message, "Include_undefined_in_index_signature_results_6716", "Include 'undefined' in index signature results"),
      Require_undeclared_properties_from_index_signatures_to_use_element_accesses: diag(6717, ts2.DiagnosticCategory.Message, "Require_undeclared_properties_from_index_signatures_to_use_element_accesses_6717", "Require undeclared properties from index signatures to use element accesses."),
      Specify_emit_Slashchecking_behavior_for_imports_that_are_only_used_for_types: diag(6718, ts2.DiagnosticCategory.Message, "Specify_emit_Slashchecking_behavior_for_imports_that_are_only_used_for_types_6718", "Specify emit/checking behavior for imports that are only used for types"),
      Type_catch_clause_variables_as_unknown_instead_of_any: diag(6803, ts2.DiagnosticCategory.Message, "Type_catch_clause_variables_as_unknown_instead_of_any_6803", "Type catch clause variables as 'unknown' instead of 'any'."),
      one_of_Colon: diag(6900, ts2.DiagnosticCategory.Message, "one_of_Colon_6900", "one of:"),
      one_or_more_Colon: diag(6901, ts2.DiagnosticCategory.Message, "one_or_more_Colon_6901", "one or more:"),
      type_Colon: diag(6902, ts2.DiagnosticCategory.Message, "type_Colon_6902", "type:"),
      default_Colon: diag(6903, ts2.DiagnosticCategory.Message, "default_Colon_6903", "default:"),
      module_system_or_esModuleInterop: diag(6904, ts2.DiagnosticCategory.Message, "module_system_or_esModuleInterop_6904", 'module === "system" or esModuleInterop'),
      false_unless_strict_is_set: diag(6905, ts2.DiagnosticCategory.Message, "false_unless_strict_is_set_6905", "`false`, unless `strict` is set"),
      false_unless_composite_is_set: diag(6906, ts2.DiagnosticCategory.Message, "false_unless_composite_is_set_6906", "`false`, unless `composite` is set"),
      node_modules_bower_components_jspm_packages_plus_the_value_of_outDir_if_one_is_specified: diag(6907, ts2.DiagnosticCategory.Message, "node_modules_bower_components_jspm_packages_plus_the_value_of_outDir_if_one_is_specified_6907", '`["node_modules", "bower_components", "jspm_packages"]`, plus the value of `outDir` if one is specified.'),
      if_files_is_specified_otherwise_Asterisk_Asterisk_Slash_Asterisk: diag(6908, ts2.DiagnosticCategory.Message, "if_files_is_specified_otherwise_Asterisk_Asterisk_Slash_Asterisk_6908", '`[]` if `files` is specified, otherwise `["**/*"]`'),
      true_if_composite_false_otherwise: diag(6909, ts2.DiagnosticCategory.Message, "true_if_composite_false_otherwise_6909", "`true` if `composite`, `false` otherwise"),
      module_AMD_or_UMD_or_System_or_ES6_then_Classic_Otherwise_Node: diag(69010, ts2.DiagnosticCategory.Message, "module_AMD_or_UMD_or_System_or_ES6_then_Classic_Otherwise_Node_69010", "module === `AMD` or `UMD` or `System` or `ES6`, then `Classic`, Otherwise `Node`"),
      Computed_from_the_list_of_input_files: diag(6911, ts2.DiagnosticCategory.Message, "Computed_from_the_list_of_input_files_6911", "Computed from the list of input files"),
      Platform_specific: diag(6912, ts2.DiagnosticCategory.Message, "Platform_specific_6912", "Platform specific"),
      You_can_learn_about_all_of_the_compiler_options_at_0: diag(6913, ts2.DiagnosticCategory.Message, "You_can_learn_about_all_of_the_compiler_options_at_0_6913", "You can learn about all of the compiler options at {0}"),
      Including_watch_w_will_start_watching_the_current_project_for_the_file_changes_Once_set_you_can_config_watch_mode_with_Colon: diag(6914, ts2.DiagnosticCategory.Message, "Including_watch_w_will_start_watching_the_current_project_for_the_file_changes_Once_set_you_can_conf_6914", "Including --watch, -w will start watching the current project for the file changes. Once set, you can config watch mode with:"),
      Using_build_b_will_make_tsc_behave_more_like_a_build_orchestrator_than_a_compiler_This_is_used_to_trigger_building_composite_projects_which_you_can_learn_more_about_at_0: diag(6915, ts2.DiagnosticCategory.Message, "Using_build_b_will_make_tsc_behave_more_like_a_build_orchestrator_than_a_compiler_This_is_used_to_tr_6915", "Using --build, -b will make tsc behave more like a build orchestrator than a compiler. This is used to trigger building composite projects which you can learn more about at {0}"),
      COMMON_COMMANDS: diag(6916, ts2.DiagnosticCategory.Message, "COMMON_COMMANDS_6916", "COMMON COMMANDS"),
      ALL_COMPILER_OPTIONS: diag(6917, ts2.DiagnosticCategory.Message, "ALL_COMPILER_OPTIONS_6917", "ALL COMPILER OPTIONS"),
      WATCH_OPTIONS: diag(6918, ts2.DiagnosticCategory.Message, "WATCH_OPTIONS_6918", "WATCH OPTIONS"),
      BUILD_OPTIONS: diag(6919, ts2.DiagnosticCategory.Message, "BUILD_OPTIONS_6919", "BUILD OPTIONS"),
      COMMON_COMPILER_OPTIONS: diag(6920, ts2.DiagnosticCategory.Message, "COMMON_COMPILER_OPTIONS_6920", "COMMON COMPILER OPTIONS"),
      COMMAND_LINE_FLAGS: diag(6921, ts2.DiagnosticCategory.Message, "COMMAND_LINE_FLAGS_6921", "COMMAND LINE FLAGS"),
      tsc_Colon_The_TypeScript_Compiler: diag(6922, ts2.DiagnosticCategory.Message, "tsc_Colon_The_TypeScript_Compiler_6922", "tsc: The TypeScript Compiler"),
      Compiles_the_current_project_tsconfig_json_in_the_working_directory: diag(6923, ts2.DiagnosticCategory.Message, "Compiles_the_current_project_tsconfig_json_in_the_working_directory_6923", "Compiles the current project (tsconfig.json in the working directory.)"),
      Ignoring_tsconfig_json_compiles_the_specified_files_with_default_compiler_options: diag(6924, ts2.DiagnosticCategory.Message, "Ignoring_tsconfig_json_compiles_the_specified_files_with_default_compiler_options_6924", "Ignoring tsconfig.json, compiles the specified files with default compiler options."),
      Build_a_composite_project_in_the_working_directory: diag(6925, ts2.DiagnosticCategory.Message, "Build_a_composite_project_in_the_working_directory_6925", "Build a composite project in the working directory."),
      Creates_a_tsconfig_json_with_the_recommended_settings_in_the_working_directory: diag(6926, ts2.DiagnosticCategory.Message, "Creates_a_tsconfig_json_with_the_recommended_settings_in_the_working_directory_6926", "Creates a tsconfig.json with the recommended settings in the working directory."),
      Compiles_the_TypeScript_project_located_at_the_specified_path: diag(6927, ts2.DiagnosticCategory.Message, "Compiles_the_TypeScript_project_located_at_the_specified_path_6927", "Compiles the TypeScript project located at the specified path."),
      An_expanded_version_of_this_information_showing_all_possible_compiler_options: diag(6928, ts2.DiagnosticCategory.Message, "An_expanded_version_of_this_information_showing_all_possible_compiler_options_6928", "An expanded version of this information, showing all possible compiler options"),
      Compiles_the_current_project_with_additional_settings: diag(6929, ts2.DiagnosticCategory.Message, "Compiles_the_current_project_with_additional_settings_6929", "Compiles the current project, with additional settings."),
      Variable_0_implicitly_has_an_1_type: diag(7005, ts2.DiagnosticCategory.Error, "Variable_0_implicitly_has_an_1_type_7005", "Variable '{0}' implicitly has an '{1}' type."),
      Parameter_0_implicitly_has_an_1_type: diag(7006, ts2.DiagnosticCategory.Error, "Parameter_0_implicitly_has_an_1_type_7006", "Parameter '{0}' implicitly has an '{1}' type."),
      Member_0_implicitly_has_an_1_type: diag(7008, ts2.DiagnosticCategory.Error, "Member_0_implicitly_has_an_1_type_7008", "Member '{0}' implicitly has an '{1}' type."),
      new_expression_whose_target_lacks_a_construct_signature_implicitly_has_an_any_type: diag(7009, ts2.DiagnosticCategory.Error, "new_expression_whose_target_lacks_a_construct_signature_implicitly_has_an_any_type_7009", "'new' expression, whose target lacks a construct signature, implicitly has an 'any' type."),
      _0_which_lacks_return_type_annotation_implicitly_has_an_1_return_type: diag(7010, ts2.DiagnosticCategory.Error, "_0_which_lacks_return_type_annotation_implicitly_has_an_1_return_type_7010", "'{0}', which lacks return-type annotation, implicitly has an '{1}' return type."),
      Function_expression_which_lacks_return_type_annotation_implicitly_has_an_0_return_type: diag(7011, ts2.DiagnosticCategory.Error, "Function_expression_which_lacks_return_type_annotation_implicitly_has_an_0_return_type_7011", "Function expression, which lacks return-type annotation, implicitly has an '{0}' return type."),
      Construct_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type: diag(7013, ts2.DiagnosticCategory.Error, "Construct_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type_7013", "Construct signature, which lacks return-type annotation, implicitly has an 'any' return type."),
      Function_type_which_lacks_return_type_annotation_implicitly_has_an_0_return_type: diag(7014, ts2.DiagnosticCategory.Error, "Function_type_which_lacks_return_type_annotation_implicitly_has_an_0_return_type_7014", "Function type, which lacks return-type annotation, implicitly has an '{0}' return type."),
      Element_implicitly_has_an_any_type_because_index_expression_is_not_of_type_number: diag(7015, ts2.DiagnosticCategory.Error, "Element_implicitly_has_an_any_type_because_index_expression_is_not_of_type_number_7015", "Element implicitly has an 'any' type because index expression is not of type 'number'."),
      Could_not_find_a_declaration_file_for_module_0_1_implicitly_has_an_any_type: diag(7016, ts2.DiagnosticCategory.Error, "Could_not_find_a_declaration_file_for_module_0_1_implicitly_has_an_any_type_7016", "Could not find a declaration file for module '{0}'. '{1}' implicitly has an 'any' type."),
      Element_implicitly_has_an_any_type_because_type_0_has_no_index_signature: diag(7017, ts2.DiagnosticCategory.Error, "Element_implicitly_has_an_any_type_because_type_0_has_no_index_signature_7017", "Element implicitly has an 'any' type because type '{0}' has no index signature."),
      Object_literal_s_property_0_implicitly_has_an_1_type: diag(7018, ts2.DiagnosticCategory.Error, "Object_literal_s_property_0_implicitly_has_an_1_type_7018", "Object literal's property '{0}' implicitly has an '{1}' type."),
      Rest_parameter_0_implicitly_has_an_any_type: diag(7019, ts2.DiagnosticCategory.Error, "Rest_parameter_0_implicitly_has_an_any_type_7019", "Rest parameter '{0}' implicitly has an 'any[]' type."),
      Call_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type: diag(7020, ts2.DiagnosticCategory.Error, "Call_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type_7020", "Call signature, which lacks return-type annotation, implicitly has an 'any' return type."),
      _0_implicitly_has_type_any_because_it_does_not_have_a_type_annotation_and_is_referenced_directly_or_indirectly_in_its_own_initializer: diag(7022, ts2.DiagnosticCategory.Error, "_0_implicitly_has_type_any_because_it_does_not_have_a_type_annotation_and_is_referenced_directly_or__7022", "'{0}' implicitly has type 'any' because it does not have a type annotation and is referenced directly or indirectly in its own initializer."),
      _0_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_referenced_directly_or_indirectly_in_one_of_its_return_expressions: diag(7023, ts2.DiagnosticCategory.Error, "_0_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_reference_7023", "'{0}' implicitly has return type 'any' because it does not have a return type annotation and is referenced directly or indirectly in one of its return expressions."),
      Function_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_referenced_directly_or_indirectly_in_one_of_its_return_expressions: diag(7024, ts2.DiagnosticCategory.Error, "Function_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_ref_7024", "Function implicitly has return type 'any' because it does not have a return type annotation and is referenced directly or indirectly in one of its return expressions."),
      Generator_implicitly_has_yield_type_0_because_it_does_not_yield_any_values_Consider_supplying_a_return_type_annotation: diag(7025, ts2.DiagnosticCategory.Error, "Generator_implicitly_has_yield_type_0_because_it_does_not_yield_any_values_Consider_supplying_a_retu_7025", "Generator implicitly has yield type '{0}' because it does not yield any values. Consider supplying a return type annotation."),
      JSX_element_implicitly_has_type_any_because_no_interface_JSX_0_exists: diag(7026, ts2.DiagnosticCategory.Error, "JSX_element_implicitly_has_type_any_because_no_interface_JSX_0_exists_7026", "JSX element implicitly has type 'any' because no interface 'JSX.{0}' exists."),
      Unreachable_code_detected: diag(7027, ts2.DiagnosticCategory.Error, "Unreachable_code_detected_7027", "Unreachable code detected.", true),
      Unused_label: diag(7028, ts2.DiagnosticCategory.Error, "Unused_label_7028", "Unused label.", true),
      Fallthrough_case_in_switch: diag(7029, ts2.DiagnosticCategory.Error, "Fallthrough_case_in_switch_7029", "Fallthrough case in switch."),
      Not_all_code_paths_return_a_value: diag(7030, ts2.DiagnosticCategory.Error, "Not_all_code_paths_return_a_value_7030", "Not all code paths return a value."),
      Binding_element_0_implicitly_has_an_1_type: diag(7031, ts2.DiagnosticCategory.Error, "Binding_element_0_implicitly_has_an_1_type_7031", "Binding element '{0}' implicitly has an '{1}' type."),
      Property_0_implicitly_has_type_any_because_its_set_accessor_lacks_a_parameter_type_annotation: diag(7032, ts2.DiagnosticCategory.Error, "Property_0_implicitly_has_type_any_because_its_set_accessor_lacks_a_parameter_type_annotation_7032", "Property '{0}' implicitly has type 'any', because its set accessor lacks a parameter type annotation."),
      Property_0_implicitly_has_type_any_because_its_get_accessor_lacks_a_return_type_annotation: diag(7033, ts2.DiagnosticCategory.Error, "Property_0_implicitly_has_type_any_because_its_get_accessor_lacks_a_return_type_annotation_7033", "Property '{0}' implicitly has type 'any', because its get accessor lacks a return type annotation."),
      Variable_0_implicitly_has_type_1_in_some_locations_where_its_type_cannot_be_determined: diag(7034, ts2.DiagnosticCategory.Error, "Variable_0_implicitly_has_type_1_in_some_locations_where_its_type_cannot_be_determined_7034", "Variable '{0}' implicitly has type '{1}' in some locations where its type cannot be determined."),
      Try_npm_i_save_dev_types_Slash_1_if_it_exists_or_add_a_new_declaration_d_ts_file_containing_declare_module_0: diag(7035, ts2.DiagnosticCategory.Error, "Try_npm_i_save_dev_types_Slash_1_if_it_exists_or_add_a_new_declaration_d_ts_file_containing_declare__7035", "Try `npm i --save-dev @types/{1}` if it exists or add a new declaration (.d.ts) file containing `declare module '{0}';`"),
      Dynamic_import_s_specifier_must_be_of_type_string_but_here_has_type_0: diag(7036, ts2.DiagnosticCategory.Error, "Dynamic_import_s_specifier_must_be_of_type_string_but_here_has_type_0_7036", "Dynamic import's specifier must be of type 'string', but here has type '{0}'."),
      Enables_emit_interoperability_between_CommonJS_and_ES_Modules_via_creation_of_namespace_objects_for_all_imports_Implies_allowSyntheticDefaultImports: diag(7037, ts2.DiagnosticCategory.Message, "Enables_emit_interoperability_between_CommonJS_and_ES_Modules_via_creation_of_namespace_objects_for__7037", "Enables emit interoperability between CommonJS and ES Modules via creation of namespace objects for all imports. Implies 'allowSyntheticDefaultImports'."),
      Type_originates_at_this_import_A_namespace_style_import_cannot_be_called_or_constructed_and_will_cause_a_failure_at_runtime_Consider_using_a_default_import_or_import_require_here_instead: diag(7038, ts2.DiagnosticCategory.Message, "Type_originates_at_this_import_A_namespace_style_import_cannot_be_called_or_constructed_and_will_cau_7038", "Type originates at this import. A namespace-style import cannot be called or constructed, and will cause a failure at runtime. Consider using a default import or import require here instead."),
      Mapped_object_type_implicitly_has_an_any_template_type: diag(7039, ts2.DiagnosticCategory.Error, "Mapped_object_type_implicitly_has_an_any_template_type_7039", "Mapped object type implicitly has an 'any' template type."),
      If_the_0_package_actually_exposes_this_module_consider_sending_a_pull_request_to_amend_https_Colon_Slash_Slashgithub_com_SlashDefinitelyTyped_SlashDefinitelyTyped_Slashtree_Slashmaster_Slashtypes_Slash_1: diag(7040, ts2.DiagnosticCategory.Error, "If_the_0_package_actually_exposes_this_module_consider_sending_a_pull_request_to_amend_https_Colon_S_7040", "If the '{0}' package actually exposes this module, consider sending a pull request to amend 'https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/{1}'"),
      The_containing_arrow_function_captures_the_global_value_of_this: diag(7041, ts2.DiagnosticCategory.Error, "The_containing_arrow_function_captures_the_global_value_of_this_7041", "The containing arrow function captures the global value of 'this'."),
      Module_0_was_resolved_to_1_but_resolveJsonModule_is_not_used: diag(7042, ts2.DiagnosticCategory.Error, "Module_0_was_resolved_to_1_but_resolveJsonModule_is_not_used_7042", "Module '{0}' was resolved to '{1}', but '--resolveJsonModule' is not used."),
      Variable_0_implicitly_has_an_1_type_but_a_better_type_may_be_inferred_from_usage: diag(7043, ts2.DiagnosticCategory.Suggestion, "Variable_0_implicitly_has_an_1_type_but_a_better_type_may_be_inferred_from_usage_7043", "Variable '{0}' implicitly has an '{1}' type, but a better type may be inferred from usage."),
      Parameter_0_implicitly_has_an_1_type_but_a_better_type_may_be_inferred_from_usage: diag(7044, ts2.DiagnosticCategory.Suggestion, "Parameter_0_implicitly_has_an_1_type_but_a_better_type_may_be_inferred_from_usage_7044", "Parameter '{0}' implicitly has an '{1}' type, but a better type may be inferred from usage."),
      Member_0_implicitly_has_an_1_type_but_a_better_type_may_be_inferred_from_usage: diag(7045, ts2.DiagnosticCategory.Suggestion, "Member_0_implicitly_has_an_1_type_but_a_better_type_may_be_inferred_from_usage_7045", "Member '{0}' implicitly has an '{1}' type, but a better type may be inferred from usage."),
      Variable_0_implicitly_has_type_1_in_some_locations_but_a_better_type_may_be_inferred_from_usage: diag(7046, ts2.DiagnosticCategory.Suggestion, "Variable_0_implicitly_has_type_1_in_some_locations_but_a_better_type_may_be_inferred_from_usage_7046", "Variable '{0}' implicitly has type '{1}' in some locations, but a better type may be inferred from usage."),
      Rest_parameter_0_implicitly_has_an_any_type_but_a_better_type_may_be_inferred_from_usage: diag(7047, ts2.DiagnosticCategory.Suggestion, "Rest_parameter_0_implicitly_has_an_any_type_but_a_better_type_may_be_inferred_from_usage_7047", "Rest parameter '{0}' implicitly has an 'any[]' type, but a better type may be inferred from usage."),
      Property_0_implicitly_has_type_any_but_a_better_type_for_its_get_accessor_may_be_inferred_from_usage: diag(7048, ts2.DiagnosticCategory.Suggestion, "Property_0_implicitly_has_type_any_but_a_better_type_for_its_get_accessor_may_be_inferred_from_usage_7048", "Property '{0}' implicitly has type 'any', but a better type for its get accessor may be inferred from usage."),
      Property_0_implicitly_has_type_any_but_a_better_type_for_its_set_accessor_may_be_inferred_from_usage: diag(7049, ts2.DiagnosticCategory.Suggestion, "Property_0_implicitly_has_type_any_but_a_better_type_for_its_set_accessor_may_be_inferred_from_usage_7049", "Property '{0}' implicitly has type 'any', but a better type for its set accessor may be inferred from usage."),
      _0_implicitly_has_an_1_return_type_but_a_better_type_may_be_inferred_from_usage: diag(7050, ts2.DiagnosticCategory.Suggestion, "_0_implicitly_has_an_1_return_type_but_a_better_type_may_be_inferred_from_usage_7050", "'{0}' implicitly has an '{1}' return type, but a better type may be inferred from usage."),
      Parameter_has_a_name_but_no_type_Did_you_mean_0_Colon_1: diag(7051, ts2.DiagnosticCategory.Error, "Parameter_has_a_name_but_no_type_Did_you_mean_0_Colon_1_7051", "Parameter has a name but no type. Did you mean '{0}: {1}'?"),
      Element_implicitly_has_an_any_type_because_type_0_has_no_index_signature_Did_you_mean_to_call_1: diag(7052, ts2.DiagnosticCategory.Error, "Element_implicitly_has_an_any_type_because_type_0_has_no_index_signature_Did_you_mean_to_call_1_7052", "Element implicitly has an 'any' type because type '{0}' has no index signature. Did you mean to call '{1}'?"),
      Element_implicitly_has_an_any_type_because_expression_of_type_0_can_t_be_used_to_index_type_1: diag(7053, ts2.DiagnosticCategory.Error, "Element_implicitly_has_an_any_type_because_expression_of_type_0_can_t_be_used_to_index_type_1_7053", "Element implicitly has an 'any' type because expression of type '{0}' can't be used to index type '{1}'."),
      No_index_signature_with_a_parameter_of_type_0_was_found_on_type_1: diag(7054, ts2.DiagnosticCategory.Error, "No_index_signature_with_a_parameter_of_type_0_was_found_on_type_1_7054", "No index signature with a parameter of type '{0}' was found on type '{1}'."),
      _0_which_lacks_return_type_annotation_implicitly_has_an_1_yield_type: diag(7055, ts2.DiagnosticCategory.Error, "_0_which_lacks_return_type_annotation_implicitly_has_an_1_yield_type_7055", "'{0}', which lacks return-type annotation, implicitly has an '{1}' yield type."),
      The_inferred_type_of_this_node_exceeds_the_maximum_length_the_compiler_will_serialize_An_explicit_type_annotation_is_needed: diag(7056, ts2.DiagnosticCategory.Error, "The_inferred_type_of_this_node_exceeds_the_maximum_length_the_compiler_will_serialize_An_explicit_ty_7056", "The inferred type of this node exceeds the maximum length the compiler will serialize. An explicit type annotation is needed."),
      yield_expression_implicitly_results_in_an_any_type_because_its_containing_generator_lacks_a_return_type_annotation: diag(7057, ts2.DiagnosticCategory.Error, "yield_expression_implicitly_results_in_an_any_type_because_its_containing_generator_lacks_a_return_t_7057", "'yield' expression implicitly results in an 'any' type because its containing generator lacks a return-type annotation."),
      You_cannot_rename_this_element: diag(8e3, ts2.DiagnosticCategory.Error, "You_cannot_rename_this_element_8000", "You cannot rename this element."),
      You_cannot_rename_elements_that_are_defined_in_the_standard_TypeScript_library: diag(8001, ts2.DiagnosticCategory.Error, "You_cannot_rename_elements_that_are_defined_in_the_standard_TypeScript_library_8001", "You cannot rename elements that are defined in the standard TypeScript library."),
      import_can_only_be_used_in_TypeScript_files: diag(8002, ts2.DiagnosticCategory.Error, "import_can_only_be_used_in_TypeScript_files_8002", "'import ... =' can only be used in TypeScript files."),
      export_can_only_be_used_in_TypeScript_files: diag(8003, ts2.DiagnosticCategory.Error, "export_can_only_be_used_in_TypeScript_files_8003", "'export =' can only be used in TypeScript files."),
      Type_parameter_declarations_can_only_be_used_in_TypeScript_files: diag(8004, ts2.DiagnosticCategory.Error, "Type_parameter_declarations_can_only_be_used_in_TypeScript_files_8004", "Type parameter declarations can only be used in TypeScript files."),
      implements_clauses_can_only_be_used_in_TypeScript_files: diag(8005, ts2.DiagnosticCategory.Error, "implements_clauses_can_only_be_used_in_TypeScript_files_8005", "'implements' clauses can only be used in TypeScript files."),
      _0_declarations_can_only_be_used_in_TypeScript_files: diag(8006, ts2.DiagnosticCategory.Error, "_0_declarations_can_only_be_used_in_TypeScript_files_8006", "'{0}' declarations can only be used in TypeScript files."),
      Type_aliases_can_only_be_used_in_TypeScript_files: diag(8008, ts2.DiagnosticCategory.Error, "Type_aliases_can_only_be_used_in_TypeScript_files_8008", "Type aliases can only be used in TypeScript files."),
      The_0_modifier_can_only_be_used_in_TypeScript_files: diag(8009, ts2.DiagnosticCategory.Error, "The_0_modifier_can_only_be_used_in_TypeScript_files_8009", "The '{0}' modifier can only be used in TypeScript files."),
      Type_annotations_can_only_be_used_in_TypeScript_files: diag(8010, ts2.DiagnosticCategory.Error, "Type_annotations_can_only_be_used_in_TypeScript_files_8010", "Type annotations can only be used in TypeScript files."),
      Type_arguments_can_only_be_used_in_TypeScript_files: diag(8011, ts2.DiagnosticCategory.Error, "Type_arguments_can_only_be_used_in_TypeScript_files_8011", "Type arguments can only be used in TypeScript files."),
      Parameter_modifiers_can_only_be_used_in_TypeScript_files: diag(8012, ts2.DiagnosticCategory.Error, "Parameter_modifiers_can_only_be_used_in_TypeScript_files_8012", "Parameter modifiers can only be used in TypeScript files."),
      Non_null_assertions_can_only_be_used_in_TypeScript_files: diag(8013, ts2.DiagnosticCategory.Error, "Non_null_assertions_can_only_be_used_in_TypeScript_files_8013", "Non-null assertions can only be used in TypeScript files."),
      Type_assertion_expressions_can_only_be_used_in_TypeScript_files: diag(8016, ts2.DiagnosticCategory.Error, "Type_assertion_expressions_can_only_be_used_in_TypeScript_files_8016", "Type assertion expressions can only be used in TypeScript files."),
      Octal_literal_types_must_use_ES2015_syntax_Use_the_syntax_0: diag(8017, ts2.DiagnosticCategory.Error, "Octal_literal_types_must_use_ES2015_syntax_Use_the_syntax_0_8017", "Octal literal types must use ES2015 syntax. Use the syntax '{0}'."),
      Octal_literals_are_not_allowed_in_enums_members_initializer_Use_the_syntax_0: diag(8018, ts2.DiagnosticCategory.Error, "Octal_literals_are_not_allowed_in_enums_members_initializer_Use_the_syntax_0_8018", "Octal literals are not allowed in enums members initializer. Use the syntax '{0}'."),
      Report_errors_in_js_files: diag(8019, ts2.DiagnosticCategory.Message, "Report_errors_in_js_files_8019", "Report errors in .js files."),
      JSDoc_types_can_only_be_used_inside_documentation_comments: diag(8020, ts2.DiagnosticCategory.Error, "JSDoc_types_can_only_be_used_inside_documentation_comments_8020", "JSDoc types can only be used inside documentation comments."),
      JSDoc_typedef_tag_should_either_have_a_type_annotation_or_be_followed_by_property_or_member_tags: diag(8021, ts2.DiagnosticCategory.Error, "JSDoc_typedef_tag_should_either_have_a_type_annotation_or_be_followed_by_property_or_member_tags_8021", "JSDoc '@typedef' tag should either have a type annotation or be followed by '@property' or '@member' tags."),
      JSDoc_0_is_not_attached_to_a_class: diag(8022, ts2.DiagnosticCategory.Error, "JSDoc_0_is_not_attached_to_a_class_8022", "JSDoc '@{0}' is not attached to a class."),
      JSDoc_0_1_does_not_match_the_extends_2_clause: diag(8023, ts2.DiagnosticCategory.Error, "JSDoc_0_1_does_not_match_the_extends_2_clause_8023", "JSDoc '@{0} {1}' does not match the 'extends {2}' clause."),
      JSDoc_param_tag_has_name_0_but_there_is_no_parameter_with_that_name: diag(8024, ts2.DiagnosticCategory.Error, "JSDoc_param_tag_has_name_0_but_there_is_no_parameter_with_that_name_8024", "JSDoc '@param' tag has name '{0}', but there is no parameter with that name."),
      Class_declarations_cannot_have_more_than_one_augments_or_extends_tag: diag(8025, ts2.DiagnosticCategory.Error, "Class_declarations_cannot_have_more_than_one_augments_or_extends_tag_8025", "Class declarations cannot have more than one '@augments' or '@extends' tag."),
      Expected_0_type_arguments_provide_these_with_an_extends_tag: diag(8026, ts2.DiagnosticCategory.Error, "Expected_0_type_arguments_provide_these_with_an_extends_tag_8026", "Expected {0} type arguments; provide these with an '@extends' tag."),
      Expected_0_1_type_arguments_provide_these_with_an_extends_tag: diag(8027, ts2.DiagnosticCategory.Error, "Expected_0_1_type_arguments_provide_these_with_an_extends_tag_8027", "Expected {0}-{1} type arguments; provide these with an '@extends' tag."),
      JSDoc_may_only_appear_in_the_last_parameter_of_a_signature: diag(8028, ts2.DiagnosticCategory.Error, "JSDoc_may_only_appear_in_the_last_parameter_of_a_signature_8028", "JSDoc '...' may only appear in the last parameter of a signature."),
      JSDoc_param_tag_has_name_0_but_there_is_no_parameter_with_that_name_It_would_match_arguments_if_it_had_an_array_type: diag(8029, ts2.DiagnosticCategory.Error, "JSDoc_param_tag_has_name_0_but_there_is_no_parameter_with_that_name_It_would_match_arguments_if_it_h_8029", "JSDoc '@param' tag has name '{0}', but there is no parameter with that name. It would match 'arguments' if it had an array type."),
      The_type_of_a_function_declaration_must_match_the_function_s_signature: diag(8030, ts2.DiagnosticCategory.Error, "The_type_of_a_function_declaration_must_match_the_function_s_signature_8030", "The type of a function declaration must match the function's signature."),
      You_cannot_rename_a_module_via_a_global_import: diag(8031, ts2.DiagnosticCategory.Error, "You_cannot_rename_a_module_via_a_global_import_8031", "You cannot rename a module via a global import."),
      Qualified_name_0_is_not_allowed_without_a_leading_param_object_1: diag(8032, ts2.DiagnosticCategory.Error, "Qualified_name_0_is_not_allowed_without_a_leading_param_object_1_8032", "Qualified name '{0}' is not allowed without a leading '@param {object} {1}'."),
      A_JSDoc_typedef_comment_may_not_contain_multiple_type_tags: diag(8033, ts2.DiagnosticCategory.Error, "A_JSDoc_typedef_comment_may_not_contain_multiple_type_tags_8033", "A JSDoc '@typedef' comment may not contain multiple '@type' tags."),
      The_tag_was_first_specified_here: diag(8034, ts2.DiagnosticCategory.Error, "The_tag_was_first_specified_here_8034", "The tag was first specified here."),
      Only_identifiers_Slashqualified_names_with_optional_type_arguments_are_currently_supported_in_a_class_extends_clause: diag(9002, ts2.DiagnosticCategory.Error, "Only_identifiers_Slashqualified_names_with_optional_type_arguments_are_currently_supported_in_a_clas_9002", "Only identifiers/qualified-names with optional type arguments are currently supported in a class 'extends' clause."),
      class_expressions_are_not_currently_supported: diag(9003, ts2.DiagnosticCategory.Error, "class_expressions_are_not_currently_supported_9003", "'class' expressions are not currently supported."),
      Language_service_is_disabled: diag(9004, ts2.DiagnosticCategory.Error, "Language_service_is_disabled_9004", "Language service is disabled."),
      Declaration_emit_for_this_file_requires_using_private_name_0_An_explicit_type_annotation_may_unblock_declaration_emit: diag(9005, ts2.DiagnosticCategory.Error, "Declaration_emit_for_this_file_requires_using_private_name_0_An_explicit_type_annotation_may_unblock_9005", "Declaration emit for this file requires using private name '{0}'. An explicit type annotation may unblock declaration emit."),
      Declaration_emit_for_this_file_requires_using_private_name_0_from_module_1_An_explicit_type_annotation_may_unblock_declaration_emit: diag(9006, ts2.DiagnosticCategory.Error, "Declaration_emit_for_this_file_requires_using_private_name_0_from_module_1_An_explicit_type_annotati_9006", "Declaration emit for this file requires using private name '{0}' from module '{1}'. An explicit type annotation may unblock declaration emit."),
      JSX_attributes_must_only_be_assigned_a_non_empty_expression: diag(17e3, ts2.DiagnosticCategory.Error, "JSX_attributes_must_only_be_assigned_a_non_empty_expression_17000", "JSX attributes must only be assigned a non-empty 'expression'."),
      JSX_elements_cannot_have_multiple_attributes_with_the_same_name: diag(17001, ts2.DiagnosticCategory.Error, "JSX_elements_cannot_have_multiple_attributes_with_the_same_name_17001", "JSX elements cannot have multiple attributes with the same name."),
      Expected_corresponding_JSX_closing_tag_for_0: diag(17002, ts2.DiagnosticCategory.Error, "Expected_corresponding_JSX_closing_tag_for_0_17002", "Expected corresponding JSX closing tag for '{0}'."),
      JSX_attribute_expected: diag(17003, ts2.DiagnosticCategory.Error, "JSX_attribute_expected_17003", "JSX attribute expected."),
      Cannot_use_JSX_unless_the_jsx_flag_is_provided: diag(17004, ts2.DiagnosticCategory.Error, "Cannot_use_JSX_unless_the_jsx_flag_is_provided_17004", "Cannot use JSX unless the '--jsx' flag is provided."),
      A_constructor_cannot_contain_a_super_call_when_its_class_extends_null: diag(17005, ts2.DiagnosticCategory.Error, "A_constructor_cannot_contain_a_super_call_when_its_class_extends_null_17005", "A constructor cannot contain a 'super' call when its class extends 'null'."),
      An_unary_expression_with_the_0_operator_is_not_allowed_in_the_left_hand_side_of_an_exponentiation_expression_Consider_enclosing_the_expression_in_parentheses: diag(17006, ts2.DiagnosticCategory.Error, "An_unary_expression_with_the_0_operator_is_not_allowed_in_the_left_hand_side_of_an_exponentiation_ex_17006", "An unary expression with the '{0}' operator is not allowed in the left-hand side of an exponentiation expression. Consider enclosing the expression in parentheses."),
      A_type_assertion_expression_is_not_allowed_in_the_left_hand_side_of_an_exponentiation_expression_Consider_enclosing_the_expression_in_parentheses: diag(17007, ts2.DiagnosticCategory.Error, "A_type_assertion_expression_is_not_allowed_in_the_left_hand_side_of_an_exponentiation_expression_Con_17007", "A type assertion expression is not allowed in the left-hand side of an exponentiation expression. Consider enclosing the expression in parentheses."),
      JSX_element_0_has_no_corresponding_closing_tag: diag(17008, ts2.DiagnosticCategory.Error, "JSX_element_0_has_no_corresponding_closing_tag_17008", "JSX element '{0}' has no corresponding closing tag."),
      super_must_be_called_before_accessing_this_in_the_constructor_of_a_derived_class: diag(17009, ts2.DiagnosticCategory.Error, "super_must_be_called_before_accessing_this_in_the_constructor_of_a_derived_class_17009", "'super' must be called before accessing 'this' in the constructor of a derived class."),
      Unknown_type_acquisition_option_0: diag(17010, ts2.DiagnosticCategory.Error, "Unknown_type_acquisition_option_0_17010", "Unknown type acquisition option '{0}'."),
      super_must_be_called_before_accessing_a_property_of_super_in_the_constructor_of_a_derived_class: diag(17011, ts2.DiagnosticCategory.Error, "super_must_be_called_before_accessing_a_property_of_super_in_the_constructor_of_a_derived_class_17011", "'super' must be called before accessing a property of 'super' in the constructor of a derived class."),
      _0_is_not_a_valid_meta_property_for_keyword_1_Did_you_mean_2: diag(17012, ts2.DiagnosticCategory.Error, "_0_is_not_a_valid_meta_property_for_keyword_1_Did_you_mean_2_17012", "'{0}' is not a valid meta-property for keyword '{1}'. Did you mean '{2}'?"),
      Meta_property_0_is_only_allowed_in_the_body_of_a_function_declaration_function_expression_or_constructor: diag(17013, ts2.DiagnosticCategory.Error, "Meta_property_0_is_only_allowed_in_the_body_of_a_function_declaration_function_expression_or_constru_17013", "Meta-property '{0}' is only allowed in the body of a function declaration, function expression, or constructor."),
      JSX_fragment_has_no_corresponding_closing_tag: diag(17014, ts2.DiagnosticCategory.Error, "JSX_fragment_has_no_corresponding_closing_tag_17014", "JSX fragment has no corresponding closing tag."),
      Expected_corresponding_closing_tag_for_JSX_fragment: diag(17015, ts2.DiagnosticCategory.Error, "Expected_corresponding_closing_tag_for_JSX_fragment_17015", "Expected corresponding closing tag for JSX fragment."),
      The_jsxFragmentFactory_compiler_option_must_be_provided_to_use_JSX_fragments_with_the_jsxFactory_compiler_option: diag(17016, ts2.DiagnosticCategory.Error, "The_jsxFragmentFactory_compiler_option_must_be_provided_to_use_JSX_fragments_with_the_jsxFactory_com_17016", "The 'jsxFragmentFactory' compiler option must be provided to use JSX fragments with the 'jsxFactory' compiler option."),
      An_jsxFrag_pragma_is_required_when_using_an_jsx_pragma_with_JSX_fragments: diag(17017, ts2.DiagnosticCategory.Error, "An_jsxFrag_pragma_is_required_when_using_an_jsx_pragma_with_JSX_fragments_17017", "An @jsxFrag pragma is required when using an @jsx pragma with JSX fragments."),
      Unknown_type_acquisition_option_0_Did_you_mean_1: diag(17018, ts2.DiagnosticCategory.Error, "Unknown_type_acquisition_option_0_Did_you_mean_1_17018", "Unknown type acquisition option '{0}'. Did you mean '{1}'?"),
      Circularity_detected_while_resolving_configuration_Colon_0: diag(18e3, ts2.DiagnosticCategory.Error, "Circularity_detected_while_resolving_configuration_Colon_0_18000", "Circularity detected while resolving configuration: {0}"),
      A_path_in_an_extends_option_must_be_relative_or_rooted_but_0_is_not: diag(18001, ts2.DiagnosticCategory.Error, "A_path_in_an_extends_option_must_be_relative_or_rooted_but_0_is_not_18001", "A path in an 'extends' option must be relative or rooted, but '{0}' is not."),
      The_files_list_in_config_file_0_is_empty: diag(18002, ts2.DiagnosticCategory.Error, "The_files_list_in_config_file_0_is_empty_18002", "The 'files' list in config file '{0}' is empty."),
      No_inputs_were_found_in_config_file_0_Specified_include_paths_were_1_and_exclude_paths_were_2: diag(18003, ts2.DiagnosticCategory.Error, "No_inputs_were_found_in_config_file_0_Specified_include_paths_were_1_and_exclude_paths_were_2_18003", "No inputs were found in config file '{0}'. Specified 'include' paths were '{1}' and 'exclude' paths were '{2}'."),
      File_is_a_CommonJS_module_it_may_be_converted_to_an_ES6_module: diag(80001, ts2.DiagnosticCategory.Suggestion, "File_is_a_CommonJS_module_it_may_be_converted_to_an_ES6_module_80001", "File is a CommonJS module; it may be converted to an ES6 module."),
      This_constructor_function_may_be_converted_to_a_class_declaration: diag(80002, ts2.DiagnosticCategory.Suggestion, "This_constructor_function_may_be_converted_to_a_class_declaration_80002", "This constructor function may be converted to a class declaration."),
      Import_may_be_converted_to_a_default_import: diag(80003, ts2.DiagnosticCategory.Suggestion, "Import_may_be_converted_to_a_default_import_80003", "Import may be converted to a default import."),
      JSDoc_types_may_be_moved_to_TypeScript_types: diag(80004, ts2.DiagnosticCategory.Suggestion, "JSDoc_types_may_be_moved_to_TypeScript_types_80004", "JSDoc types may be moved to TypeScript types."),
      require_call_may_be_converted_to_an_import: diag(80005, ts2.DiagnosticCategory.Suggestion, "require_call_may_be_converted_to_an_import_80005", "'require' call may be converted to an import."),
      This_may_be_converted_to_an_async_function: diag(80006, ts2.DiagnosticCategory.Suggestion, "This_may_be_converted_to_an_async_function_80006", "This may be converted to an async function."),
      await_has_no_effect_on_the_type_of_this_expression: diag(80007, ts2.DiagnosticCategory.Suggestion, "await_has_no_effect_on_the_type_of_this_expression_80007", "'await' has no effect on the type of this expression."),
      Numeric_literals_with_absolute_values_equal_to_2_53_or_greater_are_too_large_to_be_represented_accurately_as_integers: diag(80008, ts2.DiagnosticCategory.Suggestion, "Numeric_literals_with_absolute_values_equal_to_2_53_or_greater_are_too_large_to_be_represented_accur_80008", "Numeric literals with absolute values equal to 2^53 or greater are too large to be represented accurately as integers."),
      Add_missing_super_call: diag(90001, ts2.DiagnosticCategory.Message, "Add_missing_super_call_90001", "Add missing 'super()' call"),
      Make_super_call_the_first_statement_in_the_constructor: diag(90002, ts2.DiagnosticCategory.Message, "Make_super_call_the_first_statement_in_the_constructor_90002", "Make 'super()' call the first statement in the constructor"),
      Change_extends_to_implements: diag(90003, ts2.DiagnosticCategory.Message, "Change_extends_to_implements_90003", "Change 'extends' to 'implements'"),
      Remove_unused_declaration_for_Colon_0: diag(90004, ts2.DiagnosticCategory.Message, "Remove_unused_declaration_for_Colon_0_90004", "Remove unused declaration for: '{0}'"),
      Remove_import_from_0: diag(90005, ts2.DiagnosticCategory.Message, "Remove_import_from_0_90005", "Remove import from '{0}'"),
      Implement_interface_0: diag(90006, ts2.DiagnosticCategory.Message, "Implement_interface_0_90006", "Implement interface '{0}'"),
      Implement_inherited_abstract_class: diag(90007, ts2.DiagnosticCategory.Message, "Implement_inherited_abstract_class_90007", "Implement inherited abstract class"),
      Add_0_to_unresolved_variable: diag(90008, ts2.DiagnosticCategory.Message, "Add_0_to_unresolved_variable_90008", "Add '{0}.' to unresolved variable"),
      Remove_variable_statement: diag(90010, ts2.DiagnosticCategory.Message, "Remove_variable_statement_90010", "Remove variable statement"),
      Remove_template_tag: diag(90011, ts2.DiagnosticCategory.Message, "Remove_template_tag_90011", "Remove template tag"),
      Remove_type_parameters: diag(90012, ts2.DiagnosticCategory.Message, "Remove_type_parameters_90012", "Remove type parameters"),
      Import_0_from_module_1: diag(90013, ts2.DiagnosticCategory.Message, "Import_0_from_module_1_90013", `Import '{0}' from module "{1}"`),
      Change_0_to_1: diag(90014, ts2.DiagnosticCategory.Message, "Change_0_to_1_90014", "Change '{0}' to '{1}'"),
      Add_0_to_existing_import_declaration_from_1: diag(90015, ts2.DiagnosticCategory.Message, "Add_0_to_existing_import_declaration_from_1_90015", `Add '{0}' to existing import declaration from "{1}"`),
      Declare_property_0: diag(90016, ts2.DiagnosticCategory.Message, "Declare_property_0_90016", "Declare property '{0}'"),
      Add_index_signature_for_property_0: diag(90017, ts2.DiagnosticCategory.Message, "Add_index_signature_for_property_0_90017", "Add index signature for property '{0}'"),
      Disable_checking_for_this_file: diag(90018, ts2.DiagnosticCategory.Message, "Disable_checking_for_this_file_90018", "Disable checking for this file"),
      Ignore_this_error_message: diag(90019, ts2.DiagnosticCategory.Message, "Ignore_this_error_message_90019", "Ignore this error message"),
      Initialize_property_0_in_the_constructor: diag(90020, ts2.DiagnosticCategory.Message, "Initialize_property_0_in_the_constructor_90020", "Initialize property '{0}' in the constructor"),
      Initialize_static_property_0: diag(90021, ts2.DiagnosticCategory.Message, "Initialize_static_property_0_90021", "Initialize static property '{0}'"),
      Change_spelling_to_0: diag(90022, ts2.DiagnosticCategory.Message, "Change_spelling_to_0_90022", "Change spelling to '{0}'"),
      Declare_method_0: diag(90023, ts2.DiagnosticCategory.Message, "Declare_method_0_90023", "Declare method '{0}'"),
      Declare_static_method_0: diag(90024, ts2.DiagnosticCategory.Message, "Declare_static_method_0_90024", "Declare static method '{0}'"),
      Prefix_0_with_an_underscore: diag(90025, ts2.DiagnosticCategory.Message, "Prefix_0_with_an_underscore_90025", "Prefix '{0}' with an underscore"),
      Rewrite_as_the_indexed_access_type_0: diag(90026, ts2.DiagnosticCategory.Message, "Rewrite_as_the_indexed_access_type_0_90026", "Rewrite as the indexed access type '{0}'"),
      Declare_static_property_0: diag(90027, ts2.DiagnosticCategory.Message, "Declare_static_property_0_90027", "Declare static property '{0}'"),
      Call_decorator_expression: diag(90028, ts2.DiagnosticCategory.Message, "Call_decorator_expression_90028", "Call decorator expression"),
      Add_async_modifier_to_containing_function: diag(90029, ts2.DiagnosticCategory.Message, "Add_async_modifier_to_containing_function_90029", "Add async modifier to containing function"),
      Replace_infer_0_with_unknown: diag(90030, ts2.DiagnosticCategory.Message, "Replace_infer_0_with_unknown_90030", "Replace 'infer {0}' with 'unknown'"),
      Replace_all_unused_infer_with_unknown: diag(90031, ts2.DiagnosticCategory.Message, "Replace_all_unused_infer_with_unknown_90031", "Replace all unused 'infer' with 'unknown'"),
      Import_default_0_from_module_1: diag(90032, ts2.DiagnosticCategory.Message, "Import_default_0_from_module_1_90032", `Import default '{0}' from module "{1}"`),
      Add_default_import_0_to_existing_import_declaration_from_1: diag(90033, ts2.DiagnosticCategory.Message, "Add_default_import_0_to_existing_import_declaration_from_1_90033", `Add default import '{0}' to existing import declaration from "{1}"`),
      Add_parameter_name: diag(90034, ts2.DiagnosticCategory.Message, "Add_parameter_name_90034", "Add parameter name"),
      Declare_private_property_0: diag(90035, ts2.DiagnosticCategory.Message, "Declare_private_property_0_90035", "Declare private property '{0}'"),
      Replace_0_with_Promise_1: diag(90036, ts2.DiagnosticCategory.Message, "Replace_0_with_Promise_1_90036", "Replace '{0}' with 'Promise<{1}>'"),
      Fix_all_incorrect_return_type_of_an_async_functions: diag(90037, ts2.DiagnosticCategory.Message, "Fix_all_incorrect_return_type_of_an_async_functions_90037", "Fix all incorrect return type of an async functions"),
      Declare_private_method_0: diag(90038, ts2.DiagnosticCategory.Message, "Declare_private_method_0_90038", "Declare private method '{0}'"),
      Remove_unused_destructuring_declaration: diag(90039, ts2.DiagnosticCategory.Message, "Remove_unused_destructuring_declaration_90039", "Remove unused destructuring declaration"),
      Remove_unused_declarations_for_Colon_0: diag(90041, ts2.DiagnosticCategory.Message, "Remove_unused_declarations_for_Colon_0_90041", "Remove unused declarations for: '{0}'"),
      Declare_a_private_field_named_0: diag(90053, ts2.DiagnosticCategory.Message, "Declare_a_private_field_named_0_90053", "Declare a private field named '{0}'."),
      Convert_function_to_an_ES2015_class: diag(95001, ts2.DiagnosticCategory.Message, "Convert_function_to_an_ES2015_class_95001", "Convert function to an ES2015 class"),
      Convert_function_0_to_class: diag(95002, ts2.DiagnosticCategory.Message, "Convert_function_0_to_class_95002", "Convert function '{0}' to class"),
      Convert_0_to_1_in_0: diag(95003, ts2.DiagnosticCategory.Message, "Convert_0_to_1_in_0_95003", "Convert '{0}' to '{1} in {0}'"),
      Extract_to_0_in_1: diag(95004, ts2.DiagnosticCategory.Message, "Extract_to_0_in_1_95004", "Extract to {0} in {1}"),
      Extract_function: diag(95005, ts2.DiagnosticCategory.Message, "Extract_function_95005", "Extract function"),
      Extract_constant: diag(95006, ts2.DiagnosticCategory.Message, "Extract_constant_95006", "Extract constant"),
      Extract_to_0_in_enclosing_scope: diag(95007, ts2.DiagnosticCategory.Message, "Extract_to_0_in_enclosing_scope_95007", "Extract to {0} in enclosing scope"),
      Extract_to_0_in_1_scope: diag(95008, ts2.DiagnosticCategory.Message, "Extract_to_0_in_1_scope_95008", "Extract to {0} in {1} scope"),
      Annotate_with_type_from_JSDoc: diag(95009, ts2.DiagnosticCategory.Message, "Annotate_with_type_from_JSDoc_95009", "Annotate with type from JSDoc"),
      Annotate_with_types_from_JSDoc: diag(95010, ts2.DiagnosticCategory.Message, "Annotate_with_types_from_JSDoc_95010", "Annotate with types from JSDoc"),
      Infer_type_of_0_from_usage: diag(95011, ts2.DiagnosticCategory.Message, "Infer_type_of_0_from_usage_95011", "Infer type of '{0}' from usage"),
      Infer_parameter_types_from_usage: diag(95012, ts2.DiagnosticCategory.Message, "Infer_parameter_types_from_usage_95012", "Infer parameter types from usage"),
      Convert_to_default_import: diag(95013, ts2.DiagnosticCategory.Message, "Convert_to_default_import_95013", "Convert to default import"),
      Install_0: diag(95014, ts2.DiagnosticCategory.Message, "Install_0_95014", "Install '{0}'"),
      Replace_import_with_0: diag(95015, ts2.DiagnosticCategory.Message, "Replace_import_with_0_95015", "Replace import with '{0}'."),
      Use_synthetic_default_member: diag(95016, ts2.DiagnosticCategory.Message, "Use_synthetic_default_member_95016", "Use synthetic 'default' member."),
      Convert_to_ES6_module: diag(95017, ts2.DiagnosticCategory.Message, "Convert_to_ES6_module_95017", "Convert to ES6 module"),
      Add_undefined_type_to_property_0: diag(95018, ts2.DiagnosticCategory.Message, "Add_undefined_type_to_property_0_95018", "Add 'undefined' type to property '{0}'"),
      Add_initializer_to_property_0: diag(95019, ts2.DiagnosticCategory.Message, "Add_initializer_to_property_0_95019", "Add initializer to property '{0}'"),
      Add_definite_assignment_assertion_to_property_0: diag(95020, ts2.DiagnosticCategory.Message, "Add_definite_assignment_assertion_to_property_0_95020", "Add definite assignment assertion to property '{0}'"),
      Convert_all_type_literals_to_mapped_type: diag(95021, ts2.DiagnosticCategory.Message, "Convert_all_type_literals_to_mapped_type_95021", "Convert all type literals to mapped type"),
      Add_all_missing_members: diag(95022, ts2.DiagnosticCategory.Message, "Add_all_missing_members_95022", "Add all missing members"),
      Infer_all_types_from_usage: diag(95023, ts2.DiagnosticCategory.Message, "Infer_all_types_from_usage_95023", "Infer all types from usage"),
      Delete_all_unused_declarations: diag(95024, ts2.DiagnosticCategory.Message, "Delete_all_unused_declarations_95024", "Delete all unused declarations"),
      Prefix_all_unused_declarations_with_where_possible: diag(95025, ts2.DiagnosticCategory.Message, "Prefix_all_unused_declarations_with_where_possible_95025", "Prefix all unused declarations with '_' where possible"),
      Fix_all_detected_spelling_errors: diag(95026, ts2.DiagnosticCategory.Message, "Fix_all_detected_spelling_errors_95026", "Fix all detected spelling errors"),
      Add_initializers_to_all_uninitialized_properties: diag(95027, ts2.DiagnosticCategory.Message, "Add_initializers_to_all_uninitialized_properties_95027", "Add initializers to all uninitialized properties"),
      Add_definite_assignment_assertions_to_all_uninitialized_properties: diag(95028, ts2.DiagnosticCategory.Message, "Add_definite_assignment_assertions_to_all_uninitialized_properties_95028", "Add definite assignment assertions to all uninitialized properties"),
      Add_undefined_type_to_all_uninitialized_properties: diag(95029, ts2.DiagnosticCategory.Message, "Add_undefined_type_to_all_uninitialized_properties_95029", "Add undefined type to all uninitialized properties"),
      Change_all_jsdoc_style_types_to_TypeScript: diag(95030, ts2.DiagnosticCategory.Message, "Change_all_jsdoc_style_types_to_TypeScript_95030", "Change all jsdoc-style types to TypeScript"),
      Change_all_jsdoc_style_types_to_TypeScript_and_add_undefined_to_nullable_types: diag(95031, ts2.DiagnosticCategory.Message, "Change_all_jsdoc_style_types_to_TypeScript_and_add_undefined_to_nullable_types_95031", "Change all jsdoc-style types to TypeScript (and add '| undefined' to nullable types)"),
      Implement_all_unimplemented_interfaces: diag(95032, ts2.DiagnosticCategory.Message, "Implement_all_unimplemented_interfaces_95032", "Implement all unimplemented interfaces"),
      Install_all_missing_types_packages: diag(95033, ts2.DiagnosticCategory.Message, "Install_all_missing_types_packages_95033", "Install all missing types packages"),
      Rewrite_all_as_indexed_access_types: diag(95034, ts2.DiagnosticCategory.Message, "Rewrite_all_as_indexed_access_types_95034", "Rewrite all as indexed access types"),
      Convert_all_to_default_imports: diag(95035, ts2.DiagnosticCategory.Message, "Convert_all_to_default_imports_95035", "Convert all to default imports"),
      Make_all_super_calls_the_first_statement_in_their_constructor: diag(95036, ts2.DiagnosticCategory.Message, "Make_all_super_calls_the_first_statement_in_their_constructor_95036", "Make all 'super()' calls the first statement in their constructor"),
      Add_qualifier_to_all_unresolved_variables_matching_a_member_name: diag(95037, ts2.DiagnosticCategory.Message, "Add_qualifier_to_all_unresolved_variables_matching_a_member_name_95037", "Add qualifier to all unresolved variables matching a member name"),
      Change_all_extended_interfaces_to_implements: diag(95038, ts2.DiagnosticCategory.Message, "Change_all_extended_interfaces_to_implements_95038", "Change all extended interfaces to 'implements'"),
      Add_all_missing_super_calls: diag(95039, ts2.DiagnosticCategory.Message, "Add_all_missing_super_calls_95039", "Add all missing super calls"),
      Implement_all_inherited_abstract_classes: diag(95040, ts2.DiagnosticCategory.Message, "Implement_all_inherited_abstract_classes_95040", "Implement all inherited abstract classes"),
      Add_all_missing_async_modifiers: diag(95041, ts2.DiagnosticCategory.Message, "Add_all_missing_async_modifiers_95041", "Add all missing 'async' modifiers"),
      Add_ts_ignore_to_all_error_messages: diag(95042, ts2.DiagnosticCategory.Message, "Add_ts_ignore_to_all_error_messages_95042", "Add '@ts-ignore' to all error messages"),
      Annotate_everything_with_types_from_JSDoc: diag(95043, ts2.DiagnosticCategory.Message, "Annotate_everything_with_types_from_JSDoc_95043", "Annotate everything with types from JSDoc"),
      Add_to_all_uncalled_decorators: diag(95044, ts2.DiagnosticCategory.Message, "Add_to_all_uncalled_decorators_95044", "Add '()' to all uncalled decorators"),
      Convert_all_constructor_functions_to_classes: diag(95045, ts2.DiagnosticCategory.Message, "Convert_all_constructor_functions_to_classes_95045", "Convert all constructor functions to classes"),
      Generate_get_and_set_accessors: diag(95046, ts2.DiagnosticCategory.Message, "Generate_get_and_set_accessors_95046", "Generate 'get' and 'set' accessors"),
      Convert_require_to_import: diag(95047, ts2.DiagnosticCategory.Message, "Convert_require_to_import_95047", "Convert 'require' to 'import'"),
      Convert_all_require_to_import: diag(95048, ts2.DiagnosticCategory.Message, "Convert_all_require_to_import_95048", "Convert all 'require' to 'import'"),
      Move_to_a_new_file: diag(95049, ts2.DiagnosticCategory.Message, "Move_to_a_new_file_95049", "Move to a new file"),
      Remove_unreachable_code: diag(95050, ts2.DiagnosticCategory.Message, "Remove_unreachable_code_95050", "Remove unreachable code"),
      Remove_all_unreachable_code: diag(95051, ts2.DiagnosticCategory.Message, "Remove_all_unreachable_code_95051", "Remove all unreachable code"),
      Add_missing_typeof: diag(95052, ts2.DiagnosticCategory.Message, "Add_missing_typeof_95052", "Add missing 'typeof'"),
      Remove_unused_label: diag(95053, ts2.DiagnosticCategory.Message, "Remove_unused_label_95053", "Remove unused label"),
      Remove_all_unused_labels: diag(95054, ts2.DiagnosticCategory.Message, "Remove_all_unused_labels_95054", "Remove all unused labels"),
      Convert_0_to_mapped_object_type: diag(95055, ts2.DiagnosticCategory.Message, "Convert_0_to_mapped_object_type_95055", "Convert '{0}' to mapped object type"),
      Convert_namespace_import_to_named_imports: diag(95056, ts2.DiagnosticCategory.Message, "Convert_namespace_import_to_named_imports_95056", "Convert namespace import to named imports"),
      Convert_named_imports_to_namespace_import: diag(95057, ts2.DiagnosticCategory.Message, "Convert_named_imports_to_namespace_import_95057", "Convert named imports to namespace import"),
      Add_or_remove_braces_in_an_arrow_function: diag(95058, ts2.DiagnosticCategory.Message, "Add_or_remove_braces_in_an_arrow_function_95058", "Add or remove braces in an arrow function"),
      Add_braces_to_arrow_function: diag(95059, ts2.DiagnosticCategory.Message, "Add_braces_to_arrow_function_95059", "Add braces to arrow function"),
      Remove_braces_from_arrow_function: diag(95060, ts2.DiagnosticCategory.Message, "Remove_braces_from_arrow_function_95060", "Remove braces from arrow function"),
      Convert_default_export_to_named_export: diag(95061, ts2.DiagnosticCategory.Message, "Convert_default_export_to_named_export_95061", "Convert default export to named export"),
      Convert_named_export_to_default_export: diag(95062, ts2.DiagnosticCategory.Message, "Convert_named_export_to_default_export_95062", "Convert named export to default export"),
      Add_missing_enum_member_0: diag(95063, ts2.DiagnosticCategory.Message, "Add_missing_enum_member_0_95063", "Add missing enum member '{0}'"),
      Add_all_missing_imports: diag(95064, ts2.DiagnosticCategory.Message, "Add_all_missing_imports_95064", "Add all missing imports"),
      Convert_to_async_function: diag(95065, ts2.DiagnosticCategory.Message, "Convert_to_async_function_95065", "Convert to async function"),
      Convert_all_to_async_functions: diag(95066, ts2.DiagnosticCategory.Message, "Convert_all_to_async_functions_95066", "Convert all to async functions"),
      Add_missing_call_parentheses: diag(95067, ts2.DiagnosticCategory.Message, "Add_missing_call_parentheses_95067", "Add missing call parentheses"),
      Add_all_missing_call_parentheses: diag(95068, ts2.DiagnosticCategory.Message, "Add_all_missing_call_parentheses_95068", "Add all missing call parentheses"),
      Add_unknown_conversion_for_non_overlapping_types: diag(95069, ts2.DiagnosticCategory.Message, "Add_unknown_conversion_for_non_overlapping_types_95069", "Add 'unknown' conversion for non-overlapping types"),
      Add_unknown_to_all_conversions_of_non_overlapping_types: diag(95070, ts2.DiagnosticCategory.Message, "Add_unknown_to_all_conversions_of_non_overlapping_types_95070", "Add 'unknown' to all conversions of non-overlapping types"),
      Add_missing_new_operator_to_call: diag(95071, ts2.DiagnosticCategory.Message, "Add_missing_new_operator_to_call_95071", "Add missing 'new' operator to call"),
      Add_missing_new_operator_to_all_calls: diag(95072, ts2.DiagnosticCategory.Message, "Add_missing_new_operator_to_all_calls_95072", "Add missing 'new' operator to all calls"),
      Add_names_to_all_parameters_without_names: diag(95073, ts2.DiagnosticCategory.Message, "Add_names_to_all_parameters_without_names_95073", "Add names to all parameters without names"),
      Enable_the_experimentalDecorators_option_in_your_configuration_file: diag(95074, ts2.DiagnosticCategory.Message, "Enable_the_experimentalDecorators_option_in_your_configuration_file_95074", "Enable the 'experimentalDecorators' option in your configuration file"),
      Convert_parameters_to_destructured_object: diag(95075, ts2.DiagnosticCategory.Message, "Convert_parameters_to_destructured_object_95075", "Convert parameters to destructured object"),
      Extract_type: diag(95077, ts2.DiagnosticCategory.Message, "Extract_type_95077", "Extract type"),
      Extract_to_type_alias: diag(95078, ts2.DiagnosticCategory.Message, "Extract_to_type_alias_95078", "Extract to type alias"),
      Extract_to_typedef: diag(95079, ts2.DiagnosticCategory.Message, "Extract_to_typedef_95079", "Extract to typedef"),
      Infer_this_type_of_0_from_usage: diag(95080, ts2.DiagnosticCategory.Message, "Infer_this_type_of_0_from_usage_95080", "Infer 'this' type of '{0}' from usage"),
      Add_const_to_unresolved_variable: diag(95081, ts2.DiagnosticCategory.Message, "Add_const_to_unresolved_variable_95081", "Add 'const' to unresolved variable"),
      Add_const_to_all_unresolved_variables: diag(95082, ts2.DiagnosticCategory.Message, "Add_const_to_all_unresolved_variables_95082", "Add 'const' to all unresolved variables"),
      Add_await: diag(95083, ts2.DiagnosticCategory.Message, "Add_await_95083", "Add 'await'"),
      Add_await_to_initializer_for_0: diag(95084, ts2.DiagnosticCategory.Message, "Add_await_to_initializer_for_0_95084", "Add 'await' to initializer for '{0}'"),
      Fix_all_expressions_possibly_missing_await: diag(95085, ts2.DiagnosticCategory.Message, "Fix_all_expressions_possibly_missing_await_95085", "Fix all expressions possibly missing 'await'"),
      Remove_unnecessary_await: diag(95086, ts2.DiagnosticCategory.Message, "Remove_unnecessary_await_95086", "Remove unnecessary 'await'"),
      Remove_all_unnecessary_uses_of_await: diag(95087, ts2.DiagnosticCategory.Message, "Remove_all_unnecessary_uses_of_await_95087", "Remove all unnecessary uses of 'await'"),
      Enable_the_jsx_flag_in_your_configuration_file: diag(95088, ts2.DiagnosticCategory.Message, "Enable_the_jsx_flag_in_your_configuration_file_95088", "Enable the '--jsx' flag in your configuration file"),
      Add_await_to_initializers: diag(95089, ts2.DiagnosticCategory.Message, "Add_await_to_initializers_95089", "Add 'await' to initializers"),
      Extract_to_interface: diag(95090, ts2.DiagnosticCategory.Message, "Extract_to_interface_95090", "Extract to interface"),
      Convert_to_a_bigint_numeric_literal: diag(95091, ts2.DiagnosticCategory.Message, "Convert_to_a_bigint_numeric_literal_95091", "Convert to a bigint numeric literal"),
      Convert_all_to_bigint_numeric_literals: diag(95092, ts2.DiagnosticCategory.Message, "Convert_all_to_bigint_numeric_literals_95092", "Convert all to bigint numeric literals"),
      Convert_const_to_let: diag(95093, ts2.DiagnosticCategory.Message, "Convert_const_to_let_95093", "Convert 'const' to 'let'"),
      Prefix_with_declare: diag(95094, ts2.DiagnosticCategory.Message, "Prefix_with_declare_95094", "Prefix with 'declare'"),
      Prefix_all_incorrect_property_declarations_with_declare: diag(95095, ts2.DiagnosticCategory.Message, "Prefix_all_incorrect_property_declarations_with_declare_95095", "Prefix all incorrect property declarations with 'declare'"),
      Convert_to_template_string: diag(95096, ts2.DiagnosticCategory.Message, "Convert_to_template_string_95096", "Convert to template string"),
      Add_export_to_make_this_file_into_a_module: diag(95097, ts2.DiagnosticCategory.Message, "Add_export_to_make_this_file_into_a_module_95097", "Add 'export {}' to make this file into a module"),
      Set_the_target_option_in_your_configuration_file_to_0: diag(95098, ts2.DiagnosticCategory.Message, "Set_the_target_option_in_your_configuration_file_to_0_95098", "Set the 'target' option in your configuration file to '{0}'"),
      Set_the_module_option_in_your_configuration_file_to_0: diag(95099, ts2.DiagnosticCategory.Message, "Set_the_module_option_in_your_configuration_file_to_0_95099", "Set the 'module' option in your configuration file to '{0}'"),
      Convert_invalid_character_to_its_html_entity_code: diag(95100, ts2.DiagnosticCategory.Message, "Convert_invalid_character_to_its_html_entity_code_95100", "Convert invalid character to its html entity code"),
      Convert_all_invalid_characters_to_HTML_entity_code: diag(95101, ts2.DiagnosticCategory.Message, "Convert_all_invalid_characters_to_HTML_entity_code_95101", "Convert all invalid characters to HTML entity code"),
      Add_class_tag: diag(95102, ts2.DiagnosticCategory.Message, "Add_class_tag_95102", "Add '@class' tag"),
      Add_this_tag: diag(95103, ts2.DiagnosticCategory.Message, "Add_this_tag_95103", "Add '@this' tag"),
      Add_this_parameter: diag(95104, ts2.DiagnosticCategory.Message, "Add_this_parameter_95104", "Add 'this' parameter."),
      Convert_function_expression_0_to_arrow_function: diag(95105, ts2.DiagnosticCategory.Message, "Convert_function_expression_0_to_arrow_function_95105", "Convert function expression '{0}' to arrow function"),
      Convert_function_declaration_0_to_arrow_function: diag(95106, ts2.DiagnosticCategory.Message, "Convert_function_declaration_0_to_arrow_function_95106", "Convert function declaration '{0}' to arrow function"),
      Fix_all_implicit_this_errors: diag(95107, ts2.DiagnosticCategory.Message, "Fix_all_implicit_this_errors_95107", "Fix all implicit-'this' errors"),
      Wrap_invalid_character_in_an_expression_container: diag(95108, ts2.DiagnosticCategory.Message, "Wrap_invalid_character_in_an_expression_container_95108", "Wrap invalid character in an expression container"),
      Wrap_all_invalid_characters_in_an_expression_container: diag(95109, ts2.DiagnosticCategory.Message, "Wrap_all_invalid_characters_in_an_expression_container_95109", "Wrap all invalid characters in an expression container"),
      Visit_https_Colon_Slash_Slashaka_ms_Slashtsconfig_json_to_read_more_about_this_file: diag(95110, ts2.DiagnosticCategory.Message, "Visit_https_Colon_Slash_Slashaka_ms_Slashtsconfig_json_to_read_more_about_this_file_95110", "Visit https://aka.ms/tsconfig.json to read more about this file"),
      Add_a_return_statement: diag(95111, ts2.DiagnosticCategory.Message, "Add_a_return_statement_95111", "Add a return statement"),
      Remove_braces_from_arrow_function_body: diag(95112, ts2.DiagnosticCategory.Message, "Remove_braces_from_arrow_function_body_95112", "Remove braces from arrow function body"),
      Wrap_the_following_body_with_parentheses_which_should_be_an_object_literal: diag(95113, ts2.DiagnosticCategory.Message, "Wrap_the_following_body_with_parentheses_which_should_be_an_object_literal_95113", "Wrap the following body with parentheses which should be an object literal"),
      Add_all_missing_return_statement: diag(95114, ts2.DiagnosticCategory.Message, "Add_all_missing_return_statement_95114", "Add all missing return statement"),
      Remove_braces_from_all_arrow_function_bodies_with_relevant_issues: diag(95115, ts2.DiagnosticCategory.Message, "Remove_braces_from_all_arrow_function_bodies_with_relevant_issues_95115", "Remove braces from all arrow function bodies with relevant issues"),
      Wrap_all_object_literal_with_parentheses: diag(95116, ts2.DiagnosticCategory.Message, "Wrap_all_object_literal_with_parentheses_95116", "Wrap all object literal with parentheses"),
      Move_labeled_tuple_element_modifiers_to_labels: diag(95117, ts2.DiagnosticCategory.Message, "Move_labeled_tuple_element_modifiers_to_labels_95117", "Move labeled tuple element modifiers to labels"),
      Convert_overload_list_to_single_signature: diag(95118, ts2.DiagnosticCategory.Message, "Convert_overload_list_to_single_signature_95118", "Convert overload list to single signature"),
      Generate_get_and_set_accessors_for_all_overriding_properties: diag(95119, ts2.DiagnosticCategory.Message, "Generate_get_and_set_accessors_for_all_overriding_properties_95119", "Generate 'get' and 'set' accessors for all overriding properties"),
      Wrap_in_JSX_fragment: diag(95120, ts2.DiagnosticCategory.Message, "Wrap_in_JSX_fragment_95120", "Wrap in JSX fragment"),
      Wrap_all_unparented_JSX_in_JSX_fragment: diag(95121, ts2.DiagnosticCategory.Message, "Wrap_all_unparented_JSX_in_JSX_fragment_95121", "Wrap all unparented JSX in JSX fragment"),
      Convert_arrow_function_or_function_expression: diag(95122, ts2.DiagnosticCategory.Message, "Convert_arrow_function_or_function_expression_95122", "Convert arrow function or function expression"),
      Convert_to_anonymous_function: diag(95123, ts2.DiagnosticCategory.Message, "Convert_to_anonymous_function_95123", "Convert to anonymous function"),
      Convert_to_named_function: diag(95124, ts2.DiagnosticCategory.Message, "Convert_to_named_function_95124", "Convert to named function"),
      Convert_to_arrow_function: diag(95125, ts2.DiagnosticCategory.Message, "Convert_to_arrow_function_95125", "Convert to arrow function"),
      Remove_parentheses: diag(95126, ts2.DiagnosticCategory.Message, "Remove_parentheses_95126", "Remove parentheses"),
      Could_not_find_a_containing_arrow_function: diag(95127, ts2.DiagnosticCategory.Message, "Could_not_find_a_containing_arrow_function_95127", "Could not find a containing arrow function"),
      Containing_function_is_not_an_arrow_function: diag(95128, ts2.DiagnosticCategory.Message, "Containing_function_is_not_an_arrow_function_95128", "Containing function is not an arrow function"),
      Could_not_find_export_statement: diag(95129, ts2.DiagnosticCategory.Message, "Could_not_find_export_statement_95129", "Could not find export statement"),
      This_file_already_has_a_default_export: diag(95130, ts2.DiagnosticCategory.Message, "This_file_already_has_a_default_export_95130", "This file already has a default export"),
      Could_not_find_import_clause: diag(95131, ts2.DiagnosticCategory.Message, "Could_not_find_import_clause_95131", "Could not find import clause"),
      Could_not_find_namespace_import_or_named_imports: diag(95132, ts2.DiagnosticCategory.Message, "Could_not_find_namespace_import_or_named_imports_95132", "Could not find namespace import or named imports"),
      Selection_is_not_a_valid_type_node: diag(95133, ts2.DiagnosticCategory.Message, "Selection_is_not_a_valid_type_node_95133", "Selection is not a valid type node"),
      No_type_could_be_extracted_from_this_type_node: diag(95134, ts2.DiagnosticCategory.Message, "No_type_could_be_extracted_from_this_type_node_95134", "No type could be extracted from this type node"),
      Could_not_find_property_for_which_to_generate_accessor: diag(95135, ts2.DiagnosticCategory.Message, "Could_not_find_property_for_which_to_generate_accessor_95135", "Could not find property for which to generate accessor"),
      Name_is_not_valid: diag(95136, ts2.DiagnosticCategory.Message, "Name_is_not_valid_95136", "Name is not valid"),
      Can_only_convert_property_with_modifier: diag(95137, ts2.DiagnosticCategory.Message, "Can_only_convert_property_with_modifier_95137", "Can only convert property with modifier"),
      Switch_each_misused_0_to_1: diag(95138, ts2.DiagnosticCategory.Message, "Switch_each_misused_0_to_1_95138", "Switch each misused '{0}' to '{1}'"),
      Convert_to_optional_chain_expression: diag(95139, ts2.DiagnosticCategory.Message, "Convert_to_optional_chain_expression_95139", "Convert to optional chain expression"),
      Could_not_find_convertible_access_expression: diag(95140, ts2.DiagnosticCategory.Message, "Could_not_find_convertible_access_expression_95140", "Could not find convertible access expression"),
      Could_not_find_matching_access_expressions: diag(95141, ts2.DiagnosticCategory.Message, "Could_not_find_matching_access_expressions_95141", "Could not find matching access expressions"),
      Can_only_convert_logical_AND_access_chains: diag(95142, ts2.DiagnosticCategory.Message, "Can_only_convert_logical_AND_access_chains_95142", "Can only convert logical AND access chains"),
      Add_void_to_Promise_resolved_without_a_value: diag(95143, ts2.DiagnosticCategory.Message, "Add_void_to_Promise_resolved_without_a_value_95143", "Add 'void' to Promise resolved without a value"),
      Add_void_to_all_Promises_resolved_without_a_value: diag(95144, ts2.DiagnosticCategory.Message, "Add_void_to_all_Promises_resolved_without_a_value_95144", "Add 'void' to all Promises resolved without a value"),
      Use_element_access_for_0: diag(95145, ts2.DiagnosticCategory.Message, "Use_element_access_for_0_95145", "Use element access for '{0}'"),
      Use_element_access_for_all_undeclared_properties: diag(95146, ts2.DiagnosticCategory.Message, "Use_element_access_for_all_undeclared_properties_95146", "Use element access for all undeclared properties."),
      Delete_all_unused_imports: diag(95147, ts2.DiagnosticCategory.Message, "Delete_all_unused_imports_95147", "Delete all unused imports"),
      Infer_function_return_type: diag(95148, ts2.DiagnosticCategory.Message, "Infer_function_return_type_95148", "Infer function return type"),
      Return_type_must_be_inferred_from_a_function: diag(95149, ts2.DiagnosticCategory.Message, "Return_type_must_be_inferred_from_a_function_95149", "Return type must be inferred from a function"),
      Could_not_determine_function_return_type: diag(95150, ts2.DiagnosticCategory.Message, "Could_not_determine_function_return_type_95150", "Could not determine function return type"),
      Could_not_convert_to_arrow_function: diag(95151, ts2.DiagnosticCategory.Message, "Could_not_convert_to_arrow_function_95151", "Could not convert to arrow function"),
      Could_not_convert_to_named_function: diag(95152, ts2.DiagnosticCategory.Message, "Could_not_convert_to_named_function_95152", "Could not convert to named function"),
      Could_not_convert_to_anonymous_function: diag(95153, ts2.DiagnosticCategory.Message, "Could_not_convert_to_anonymous_function_95153", "Could not convert to anonymous function"),
      Can_only_convert_string_concatenation: diag(95154, ts2.DiagnosticCategory.Message, "Can_only_convert_string_concatenation_95154", "Can only convert string concatenation"),
      Selection_is_not_a_valid_statement_or_statements: diag(95155, ts2.DiagnosticCategory.Message, "Selection_is_not_a_valid_statement_or_statements_95155", "Selection is not a valid statement or statements"),
      Add_missing_function_declaration_0: diag(95156, ts2.DiagnosticCategory.Message, "Add_missing_function_declaration_0_95156", "Add missing function declaration '{0}'"),
      Add_all_missing_function_declarations: diag(95157, ts2.DiagnosticCategory.Message, "Add_all_missing_function_declarations_95157", "Add all missing function declarations"),
      Method_not_implemented: diag(95158, ts2.DiagnosticCategory.Message, "Method_not_implemented_95158", "Method not implemented."),
      Function_not_implemented: diag(95159, ts2.DiagnosticCategory.Message, "Function_not_implemented_95159", "Function not implemented."),
      Add_override_modifier: diag(95160, ts2.DiagnosticCategory.Message, "Add_override_modifier_95160", "Add 'override' modifier"),
      Remove_override_modifier: diag(95161, ts2.DiagnosticCategory.Message, "Remove_override_modifier_95161", "Remove 'override' modifier"),
      Add_all_missing_override_modifiers: diag(95162, ts2.DiagnosticCategory.Message, "Add_all_missing_override_modifiers_95162", "Add all missing 'override' modifiers"),
      Remove_all_unnecessary_override_modifiers: diag(95163, ts2.DiagnosticCategory.Message, "Remove_all_unnecessary_override_modifiers_95163", "Remove all unnecessary 'override' modifiers"),
      Can_only_convert_named_export: diag(95164, ts2.DiagnosticCategory.Message, "Can_only_convert_named_export_95164", "Can only convert named export"),
      Add_missing_properties: diag(95165, ts2.DiagnosticCategory.Message, "Add_missing_properties_95165", "Add missing properties"),
      Add_all_missing_properties: diag(95166, ts2.DiagnosticCategory.Message, "Add_all_missing_properties_95166", "Add all missing properties"),
      Add_missing_attributes: diag(95167, ts2.DiagnosticCategory.Message, "Add_missing_attributes_95167", "Add missing attributes"),
      Add_all_missing_attributes: diag(95168, ts2.DiagnosticCategory.Message, "Add_all_missing_attributes_95168", "Add all missing attributes"),
      No_value_exists_in_scope_for_the_shorthand_property_0_Either_declare_one_or_provide_an_initializer: diag(18004, ts2.DiagnosticCategory.Error, "No_value_exists_in_scope_for_the_shorthand_property_0_Either_declare_one_or_provide_an_initializer_18004", "No value exists in scope for the shorthand property '{0}'. Either declare one or provide an initializer."),
      Classes_may_not_have_a_field_named_constructor: diag(18006, ts2.DiagnosticCategory.Error, "Classes_may_not_have_a_field_named_constructor_18006", "Classes may not have a field named 'constructor'."),
      JSX_expressions_may_not_use_the_comma_operator_Did_you_mean_to_write_an_array: diag(18007, ts2.DiagnosticCategory.Error, "JSX_expressions_may_not_use_the_comma_operator_Did_you_mean_to_write_an_array_18007", "JSX expressions may not use the comma operator. Did you mean to write an array?"),
      Private_identifiers_cannot_be_used_as_parameters: diag(18009, ts2.DiagnosticCategory.Error, "Private_identifiers_cannot_be_used_as_parameters_18009", "Private identifiers cannot be used as parameters."),
      An_accessibility_modifier_cannot_be_used_with_a_private_identifier: diag(18010, ts2.DiagnosticCategory.Error, "An_accessibility_modifier_cannot_be_used_with_a_private_identifier_18010", "An accessibility modifier cannot be used with a private identifier."),
      The_operand_of_a_delete_operator_cannot_be_a_private_identifier: diag(18011, ts2.DiagnosticCategory.Error, "The_operand_of_a_delete_operator_cannot_be_a_private_identifier_18011", "The operand of a 'delete' operator cannot be a private identifier."),
      constructor_is_a_reserved_word: diag(18012, ts2.DiagnosticCategory.Error, "constructor_is_a_reserved_word_18012", "'#constructor' is a reserved word."),
      Property_0_is_not_accessible_outside_class_1_because_it_has_a_private_identifier: diag(18013, ts2.DiagnosticCategory.Error, "Property_0_is_not_accessible_outside_class_1_because_it_has_a_private_identifier_18013", "Property '{0}' is not accessible outside class '{1}' because it has a private identifier."),
      The_property_0_cannot_be_accessed_on_type_1_within_this_class_because_it_is_shadowed_by_another_private_identifier_with_the_same_spelling: diag(18014, ts2.DiagnosticCategory.Error, "The_property_0_cannot_be_accessed_on_type_1_within_this_class_because_it_is_shadowed_by_another_priv_18014", "The property '{0}' cannot be accessed on type '{1}' within this class because it is shadowed by another private identifier with the same spelling."),
      Property_0_in_type_1_refers_to_a_different_member_that_cannot_be_accessed_from_within_type_2: diag(18015, ts2.DiagnosticCategory.Error, "Property_0_in_type_1_refers_to_a_different_member_that_cannot_be_accessed_from_within_type_2_18015", "Property '{0}' in type '{1}' refers to a different member that cannot be accessed from within type '{2}'."),
      Private_identifiers_are_not_allowed_outside_class_bodies: diag(18016, ts2.DiagnosticCategory.Error, "Private_identifiers_are_not_allowed_outside_class_bodies_18016", "Private identifiers are not allowed outside class bodies."),
      The_shadowing_declaration_of_0_is_defined_here: diag(18017, ts2.DiagnosticCategory.Error, "The_shadowing_declaration_of_0_is_defined_here_18017", "The shadowing declaration of '{0}' is defined here"),
      The_declaration_of_0_that_you_probably_intended_to_use_is_defined_here: diag(18018, ts2.DiagnosticCategory.Error, "The_declaration_of_0_that_you_probably_intended_to_use_is_defined_here_18018", "The declaration of '{0}' that you probably intended to use is defined here"),
      _0_modifier_cannot_be_used_with_a_private_identifier: diag(18019, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_be_used_with_a_private_identifier_18019", "'{0}' modifier cannot be used with a private identifier."),
      An_enum_member_cannot_be_named_with_a_private_identifier: diag(18024, ts2.DiagnosticCategory.Error, "An_enum_member_cannot_be_named_with_a_private_identifier_18024", "An enum member cannot be named with a private identifier."),
      can_only_be_used_at_the_start_of_a_file: diag(18026, ts2.DiagnosticCategory.Error, "can_only_be_used_at_the_start_of_a_file_18026", "'#!' can only be used at the start of a file."),
      Compiler_reserves_name_0_when_emitting_private_identifier_downlevel: diag(18027, ts2.DiagnosticCategory.Error, "Compiler_reserves_name_0_when_emitting_private_identifier_downlevel_18027", "Compiler reserves name '{0}' when emitting private identifier downlevel."),
      Private_identifiers_are_only_available_when_targeting_ECMAScript_2015_and_higher: diag(18028, ts2.DiagnosticCategory.Error, "Private_identifiers_are_only_available_when_targeting_ECMAScript_2015_and_higher_18028", "Private identifiers are only available when targeting ECMAScript 2015 and higher."),
      Private_identifiers_are_not_allowed_in_variable_declarations: diag(18029, ts2.DiagnosticCategory.Error, "Private_identifiers_are_not_allowed_in_variable_declarations_18029", "Private identifiers are not allowed in variable declarations."),
      An_optional_chain_cannot_contain_private_identifiers: diag(18030, ts2.DiagnosticCategory.Error, "An_optional_chain_cannot_contain_private_identifiers_18030", "An optional chain cannot contain private identifiers."),
      The_intersection_0_was_reduced_to_never_because_property_1_has_conflicting_types_in_some_constituents: diag(18031, ts2.DiagnosticCategory.Error, "The_intersection_0_was_reduced_to_never_because_property_1_has_conflicting_types_in_some_constituent_18031", "The intersection '{0}' was reduced to 'never' because property '{1}' has conflicting types in some constituents."),
      The_intersection_0_was_reduced_to_never_because_property_1_exists_in_multiple_constituents_and_is_private_in_some: diag(18032, ts2.DiagnosticCategory.Error, "The_intersection_0_was_reduced_to_never_because_property_1_exists_in_multiple_constituents_and_is_pr_18032", "The intersection '{0}' was reduced to 'never' because property '{1}' exists in multiple constituents and is private in some."),
      Only_numeric_enums_can_have_computed_members_but_this_expression_has_type_0_If_you_do_not_need_exhaustiveness_checks_consider_using_an_object_literal_instead: diag(18033, ts2.DiagnosticCategory.Error, "Only_numeric_enums_can_have_computed_members_but_this_expression_has_type_0_If_you_do_not_need_exhau_18033", "Only numeric enums can have computed members, but this expression has type '{0}'. If you do not need exhaustiveness checks, consider using an object literal instead."),
      Specify_the_JSX_fragment_factory_function_to_use_when_targeting_react_JSX_emit_with_jsxFactory_compiler_option_is_specified_e_g_Fragment: diag(18034, ts2.DiagnosticCategory.Message, "Specify_the_JSX_fragment_factory_function_to_use_when_targeting_react_JSX_emit_with_jsxFactory_compi_18034", "Specify the JSX fragment factory function to use when targeting 'react' JSX emit with 'jsxFactory' compiler option is specified, e.g. 'Fragment'."),
      Invalid_value_for_jsxFragmentFactory_0_is_not_a_valid_identifier_or_qualified_name: diag(18035, ts2.DiagnosticCategory.Error, "Invalid_value_for_jsxFragmentFactory_0_is_not_a_valid_identifier_or_qualified_name_18035", "Invalid value for 'jsxFragmentFactory'. '{0}' is not a valid identifier or qualified-name."),
      Class_decorators_can_t_be_used_with_static_private_identifier_Consider_removing_the_experimental_decorator: diag(18036, ts2.DiagnosticCategory.Error, "Class_decorators_can_t_be_used_with_static_private_identifier_Consider_removing_the_experimental_dec_18036", "Class decorators can't be used with static private identifier. Consider removing the experimental decorator."),
      Await_expression_cannot_be_used_inside_a_class_static_block: diag(18037, ts2.DiagnosticCategory.Error, "Await_expression_cannot_be_used_inside_a_class_static_block_18037", "Await expression cannot be used inside a class static block."),
      For_await_loops_cannot_be_used_inside_a_class_static_block: diag(18038, ts2.DiagnosticCategory.Error, "For_await_loops_cannot_be_used_inside_a_class_static_block_18038", "'For await' loops cannot be used inside a class static block."),
      Invalid_use_of_0_It_cannot_be_used_inside_a_class_static_block: diag(18039, ts2.DiagnosticCategory.Error, "Invalid_use_of_0_It_cannot_be_used_inside_a_class_static_block_18039", "Invalid use of '{0}'. It cannot be used inside a class static block."),
      A_return_statement_cannot_be_used_inside_a_class_static_block: diag(18041, ts2.DiagnosticCategory.Error, "A_return_statement_cannot_be_used_inside_a_class_static_block_18041", "A 'return' statement cannot be used inside a class static block.")
    };
  })(ts || (ts = {}));
  var ts;
  (function(ts2) {
    var _a;
    function tokenIsIdentifierOrKeyword(token) {
      return token >= 79;
    }
    ts2.tokenIsIdentifierOrKeyword = tokenIsIdentifierOrKeyword;
    function tokenIsIdentifierOrKeywordOrGreaterThan(token) {
      return token === 31 || tokenIsIdentifierOrKeyword(token);
    }
    ts2.tokenIsIdentifierOrKeywordOrGreaterThan = tokenIsIdentifierOrKeywordOrGreaterThan;
    ts2.textToKeywordObj = (_a = {
      abstract: 126,
      any: 129,
      as: 127,
      asserts: 128,
      bigint: 156,
      boolean: 132,
      break: 81,
      case: 82,
      catch: 83,
      class: 84,
      continue: 86,
      const: 85
    }, _a["constructor"] = 133, _a.debugger = 87, _a.declare = 134, _a.default = 88, _a.delete = 89, _a.do = 90, _a.else = 91, _a.enum = 92, _a.export = 93, _a.extends = 94, _a.false = 95, _a.finally = 96, _a.for = 97, _a.from = 154, _a.function = 98, _a.get = 135, _a.if = 99, _a.implements = 117, _a.import = 100, _a.in = 101, _a.infer = 136, _a.instanceof = 102, _a.interface = 118, _a.intrinsic = 137, _a.is = 138, _a.keyof = 139, _a.let = 119, _a.module = 140, _a.namespace = 141, _a.never = 142, _a.new = 103, _a.null = 104, _a.number = 145, _a.object = 146, _a.package = 120, _a.private = 121, _a.protected = 122, _a.public = 123, _a.override = 157, _a.readonly = 143, _a.require = 144, _a.global = 155, _a.return = 105, _a.set = 147, _a.static = 124, _a.string = 148, _a.super = 106, _a.switch = 107, _a.symbol = 149, _a.this = 108, _a.throw = 109, _a.true = 110, _a.try = 111, _a.type = 150, _a.typeof = 112, _a.undefined = 151, _a.unique = 152, _a.unknown = 153, _a.var = 113, _a.void = 114, _a.while = 115, _a.with = 116, _a.yield = 125, _a.async = 130, _a.await = 131, _a.of = 158, _a);
    var textToKeyword = new ts2.Map(ts2.getEntries(ts2.textToKeywordObj));
    var textToToken = new ts2.Map(ts2.getEntries(__assign(__assign({}, ts2.textToKeywordObj), { "{": 18, "}": 19, "(": 20, ")": 21, "[": 22, "]": 23, ".": 24, "...": 25, ";": 26, ",": 27, "<": 29, ">": 31, "<=": 32, ">=": 33, "==": 34, "!=": 35, "===": 36, "!==": 37, "=>": 38, "+": 39, "-": 40, "**": 42, "*": 41, "/": 43, "%": 44, "++": 45, "--": 46, "<<": 47, "</": 30, ">>": 48, ">>>": 49, "&": 50, "|": 51, "^": 52, "!": 53, "~": 54, "&&": 55, "||": 56, "?": 57, "??": 60, "?.": 28, ":": 58, "=": 63, "+=": 64, "-=": 65, "*=": 66, "**=": 67, "/=": 68, "%=": 69, "<<=": 70, ">>=": 71, ">>>=": 72, "&=": 73, "|=": 74, "^=": 78, "||=": 75, "&&=": 76, "??=": 77, "@": 59, "#": 62, "`": 61 })));
    var unicodeES3IdentifierStart = [170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 543, 546, 563, 592, 685, 688, 696, 699, 705, 720, 721, 736, 740, 750, 750, 890, 890, 902, 902, 904, 906, 908, 908, 910, 929, 931, 974, 976, 983, 986, 1011, 1024, 1153, 1164, 1220, 1223, 1224, 1227, 1228, 1232, 1269, 1272, 1273, 1329, 1366, 1369, 1369, 1377, 1415, 1488, 1514, 1520, 1522, 1569, 1594, 1600, 1610, 1649, 1747, 1749, 1749, 1765, 1766, 1786, 1788, 1808, 1808, 1810, 1836, 1920, 1957, 2309, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2524, 2525, 2527, 2529, 2544, 2545, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2699, 2701, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2784, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2870, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 2997, 2999, 3001, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3123, 3125, 3129, 3168, 3169, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3294, 3294, 3296, 3297, 3333, 3340, 3342, 3344, 3346, 3368, 3370, 3385, 3424, 3425, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3635, 3648, 3654, 3713, 3714, 3716, 3716, 3719, 3720, 3722, 3722, 3725, 3725, 3732, 3735, 3737, 3743, 3745, 3747, 3749, 3749, 3751, 3751, 3754, 3755, 3757, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3805, 3840, 3840, 3904, 3911, 3913, 3946, 3976, 3979, 4096, 4129, 4131, 4135, 4137, 4138, 4176, 4181, 4256, 4293, 4304, 4342, 4352, 4441, 4447, 4514, 4520, 4601, 4608, 4614, 4616, 4678, 4680, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4742, 4744, 4744, 4746, 4749, 4752, 4782, 4784, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4814, 4816, 4822, 4824, 4846, 4848, 4878, 4880, 4880, 4882, 4885, 4888, 4894, 4896, 4934, 4936, 4954, 5024, 5108, 5121, 5740, 5743, 5750, 5761, 5786, 5792, 5866, 6016, 6067, 6176, 6263, 6272, 6312, 7680, 7835, 7840, 7929, 7936, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8319, 8319, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8497, 8499, 8505, 8544, 8579, 12293, 12295, 12321, 12329, 12337, 12341, 12344, 12346, 12353, 12436, 12445, 12446, 12449, 12538, 12540, 12542, 12549, 12588, 12593, 12686, 12704, 12727, 13312, 19893, 19968, 40869, 40960, 42124, 44032, 55203, 63744, 64045, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65019, 65136, 65138, 65140, 65140, 65142, 65276, 65313, 65338, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500];
    var unicodeES3IdentifierPart = [170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 543, 546, 563, 592, 685, 688, 696, 699, 705, 720, 721, 736, 740, 750, 750, 768, 846, 864, 866, 890, 890, 902, 902, 904, 906, 908, 908, 910, 929, 931, 974, 976, 983, 986, 1011, 1024, 1153, 1155, 1158, 1164, 1220, 1223, 1224, 1227, 1228, 1232, 1269, 1272, 1273, 1329, 1366, 1369, 1369, 1377, 1415, 1425, 1441, 1443, 1465, 1467, 1469, 1471, 1471, 1473, 1474, 1476, 1476, 1488, 1514, 1520, 1522, 1569, 1594, 1600, 1621, 1632, 1641, 1648, 1747, 1749, 1756, 1759, 1768, 1770, 1773, 1776, 1788, 1808, 1836, 1840, 1866, 1920, 1968, 2305, 2307, 2309, 2361, 2364, 2381, 2384, 2388, 2392, 2403, 2406, 2415, 2433, 2435, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2492, 2492, 2494, 2500, 2503, 2504, 2507, 2509, 2519, 2519, 2524, 2525, 2527, 2531, 2534, 2545, 2562, 2562, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2620, 2620, 2622, 2626, 2631, 2632, 2635, 2637, 2649, 2652, 2654, 2654, 2662, 2676, 2689, 2691, 2693, 2699, 2701, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2748, 2757, 2759, 2761, 2763, 2765, 2768, 2768, 2784, 2784, 2790, 2799, 2817, 2819, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2870, 2873, 2876, 2883, 2887, 2888, 2891, 2893, 2902, 2903, 2908, 2909, 2911, 2913, 2918, 2927, 2946, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 2997, 2999, 3001, 3006, 3010, 3014, 3016, 3018, 3021, 3031, 3031, 3047, 3055, 3073, 3075, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3123, 3125, 3129, 3134, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3168, 3169, 3174, 3183, 3202, 3203, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3262, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3294, 3294, 3296, 3297, 3302, 3311, 3330, 3331, 3333, 3340, 3342, 3344, 3346, 3368, 3370, 3385, 3390, 3395, 3398, 3400, 3402, 3405, 3415, 3415, 3424, 3425, 3430, 3439, 3458, 3459, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3530, 3530, 3535, 3540, 3542, 3542, 3544, 3551, 3570, 3571, 3585, 3642, 3648, 3662, 3664, 3673, 3713, 3714, 3716, 3716, 3719, 3720, 3722, 3722, 3725, 3725, 3732, 3735, 3737, 3743, 3745, 3747, 3749, 3749, 3751, 3751, 3754, 3755, 3757, 3769, 3771, 3773, 3776, 3780, 3782, 3782, 3784, 3789, 3792, 3801, 3804, 3805, 3840, 3840, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3911, 3913, 3946, 3953, 3972, 3974, 3979, 3984, 3991, 3993, 4028, 4038, 4038, 4096, 4129, 4131, 4135, 4137, 4138, 4140, 4146, 4150, 4153, 4160, 4169, 4176, 4185, 4256, 4293, 4304, 4342, 4352, 4441, 4447, 4514, 4520, 4601, 4608, 4614, 4616, 4678, 4680, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4742, 4744, 4744, 4746, 4749, 4752, 4782, 4784, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4814, 4816, 4822, 4824, 4846, 4848, 4878, 4880, 4880, 4882, 4885, 4888, 4894, 4896, 4934, 4936, 4954, 4969, 4977, 5024, 5108, 5121, 5740, 5743, 5750, 5761, 5786, 5792, 5866, 6016, 6099, 6112, 6121, 6160, 6169, 6176, 6263, 6272, 6313, 7680, 7835, 7840, 7929, 7936, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8255, 8256, 8319, 8319, 8400, 8412, 8417, 8417, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8497, 8499, 8505, 8544, 8579, 12293, 12295, 12321, 12335, 12337, 12341, 12344, 12346, 12353, 12436, 12441, 12442, 12445, 12446, 12449, 12542, 12549, 12588, 12593, 12686, 12704, 12727, 13312, 19893, 19968, 40869, 40960, 42124, 44032, 55203, 63744, 64045, 64256, 64262, 64275, 64279, 64285, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65019, 65056, 65059, 65075, 65076, 65101, 65103, 65136, 65138, 65140, 65140, 65142, 65276, 65296, 65305, 65313, 65338, 65343, 65343, 65345, 65370, 65381, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500];
    var unicodeES5IdentifierStart = [170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 880, 884, 886, 887, 890, 893, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1162, 1319, 1329, 1366, 1369, 1369, 1377, 1415, 1488, 1514, 1520, 1522, 1568, 1610, 1646, 1647, 1649, 1747, 1749, 1749, 1765, 1766, 1774, 1775, 1786, 1788, 1791, 1791, 1808, 1808, 1810, 1839, 1869, 1957, 1969, 1969, 1994, 2026, 2036, 2037, 2042, 2042, 2048, 2069, 2074, 2074, 2084, 2084, 2088, 2088, 2112, 2136, 2208, 2208, 2210, 2220, 2308, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2417, 2423, 2425, 2431, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2493, 2493, 2510, 2510, 2524, 2525, 2527, 2529, 2544, 2545, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2785, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2929, 2929, 2947, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3024, 3024, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3123, 3125, 3129, 3133, 3133, 3160, 3161, 3168, 3169, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3261, 3261, 3294, 3294, 3296, 3297, 3313, 3314, 3333, 3340, 3342, 3344, 3346, 3386, 3389, 3389, 3406, 3406, 3424, 3425, 3450, 3455, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3635, 3648, 3654, 3713, 3714, 3716, 3716, 3719, 3720, 3722, 3722, 3725, 3725, 3732, 3735, 3737, 3743, 3745, 3747, 3749, 3749, 3751, 3751, 3754, 3755, 3757, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3807, 3840, 3840, 3904, 3911, 3913, 3948, 3976, 3980, 4096, 4138, 4159, 4159, 4176, 4181, 4186, 4189, 4193, 4193, 4197, 4198, 4206, 4208, 4213, 4225, 4238, 4238, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4992, 5007, 5024, 5108, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5872, 5888, 5900, 5902, 5905, 5920, 5937, 5952, 5969, 5984, 5996, 5998, 6e3, 6016, 6067, 6103, 6103, 6108, 6108, 6176, 6263, 6272, 6312, 6314, 6314, 6320, 6389, 6400, 6428, 6480, 6509, 6512, 6516, 6528, 6571, 6593, 6599, 6656, 6678, 6688, 6740, 6823, 6823, 6917, 6963, 6981, 6987, 7043, 7072, 7086, 7087, 7098, 7141, 7168, 7203, 7245, 7247, 7258, 7293, 7401, 7404, 7406, 7409, 7413, 7414, 7424, 7615, 7680, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8305, 8305, 8319, 8319, 8336, 8348, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11310, 11312, 11358, 11360, 11492, 11499, 11502, 11506, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11648, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11823, 11823, 12293, 12295, 12321, 12329, 12337, 12341, 12344, 12348, 12353, 12438, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12589, 12593, 12686, 12704, 12730, 12784, 12799, 13312, 19893, 19968, 40908, 40960, 42124, 42192, 42237, 42240, 42508, 42512, 42527, 42538, 42539, 42560, 42606, 42623, 42647, 42656, 42735, 42775, 42783, 42786, 42888, 42891, 42894, 42896, 42899, 42912, 42922, 43e3, 43009, 43011, 43013, 43015, 43018, 43020, 43042, 43072, 43123, 43138, 43187, 43250, 43255, 43259, 43259, 43274, 43301, 43312, 43334, 43360, 43388, 43396, 43442, 43471, 43471, 43520, 43560, 43584, 43586, 43588, 43595, 43616, 43638, 43642, 43642, 43648, 43695, 43697, 43697, 43701, 43702, 43705, 43709, 43712, 43712, 43714, 43714, 43739, 43741, 43744, 43754, 43762, 43764, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43968, 44002, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65019, 65136, 65140, 65142, 65276, 65313, 65338, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500];
    var unicodeES5IdentifierPart = [170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 768, 884, 886, 887, 890, 893, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1155, 1159, 1162, 1319, 1329, 1366, 1369, 1369, 1377, 1415, 1425, 1469, 1471, 1471, 1473, 1474, 1476, 1477, 1479, 1479, 1488, 1514, 1520, 1522, 1552, 1562, 1568, 1641, 1646, 1747, 1749, 1756, 1759, 1768, 1770, 1788, 1791, 1791, 1808, 1866, 1869, 1969, 1984, 2037, 2042, 2042, 2048, 2093, 2112, 2139, 2208, 2208, 2210, 2220, 2276, 2302, 2304, 2403, 2406, 2415, 2417, 2423, 2425, 2431, 2433, 2435, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2492, 2500, 2503, 2504, 2507, 2510, 2519, 2519, 2524, 2525, 2527, 2531, 2534, 2545, 2561, 2563, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2620, 2620, 2622, 2626, 2631, 2632, 2635, 2637, 2641, 2641, 2649, 2652, 2654, 2654, 2662, 2677, 2689, 2691, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2748, 2757, 2759, 2761, 2763, 2765, 2768, 2768, 2784, 2787, 2790, 2799, 2817, 2819, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2876, 2884, 2887, 2888, 2891, 2893, 2902, 2903, 2908, 2909, 2911, 2915, 2918, 2927, 2929, 2929, 2946, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3006, 3010, 3014, 3016, 3018, 3021, 3024, 3024, 3031, 3031, 3046, 3055, 3073, 3075, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3123, 3125, 3129, 3133, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3160, 3161, 3168, 3171, 3174, 3183, 3202, 3203, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3260, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3294, 3294, 3296, 3299, 3302, 3311, 3313, 3314, 3330, 3331, 3333, 3340, 3342, 3344, 3346, 3386, 3389, 3396, 3398, 3400, 3402, 3406, 3415, 3415, 3424, 3427, 3430, 3439, 3450, 3455, 3458, 3459, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3530, 3530, 3535, 3540, 3542, 3542, 3544, 3551, 3570, 3571, 3585, 3642, 3648, 3662, 3664, 3673, 3713, 3714, 3716, 3716, 3719, 3720, 3722, 3722, 3725, 3725, 3732, 3735, 3737, 3743, 3745, 3747, 3749, 3749, 3751, 3751, 3754, 3755, 3757, 3769, 3771, 3773, 3776, 3780, 3782, 3782, 3784, 3789, 3792, 3801, 3804, 3807, 3840, 3840, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3911, 3913, 3948, 3953, 3972, 3974, 3991, 3993, 4028, 4038, 4038, 4096, 4169, 4176, 4253, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4957, 4959, 4992, 5007, 5024, 5108, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5872, 5888, 5900, 5902, 5908, 5920, 5940, 5952, 5971, 5984, 5996, 5998, 6e3, 6002, 6003, 6016, 6099, 6103, 6103, 6108, 6109, 6112, 6121, 6155, 6157, 6160, 6169, 6176, 6263, 6272, 6314, 6320, 6389, 6400, 6428, 6432, 6443, 6448, 6459, 6470, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6608, 6617, 6656, 6683, 6688, 6750, 6752, 6780, 6783, 6793, 6800, 6809, 6823, 6823, 6912, 6987, 6992, 7001, 7019, 7027, 7040, 7155, 7168, 7223, 7232, 7241, 7245, 7293, 7376, 7378, 7380, 7414, 7424, 7654, 7676, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8204, 8205, 8255, 8256, 8276, 8276, 8305, 8305, 8319, 8319, 8336, 8348, 8400, 8412, 8417, 8417, 8421, 8432, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11310, 11312, 11358, 11360, 11492, 11499, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11647, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11744, 11775, 11823, 11823, 12293, 12295, 12321, 12335, 12337, 12341, 12344, 12348, 12353, 12438, 12441, 12442, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12589, 12593, 12686, 12704, 12730, 12784, 12799, 13312, 19893, 19968, 40908, 40960, 42124, 42192, 42237, 42240, 42508, 42512, 42539, 42560, 42607, 42612, 42621, 42623, 42647, 42655, 42737, 42775, 42783, 42786, 42888, 42891, 42894, 42896, 42899, 42912, 42922, 43e3, 43047, 43072, 43123, 43136, 43204, 43216, 43225, 43232, 43255, 43259, 43259, 43264, 43309, 43312, 43347, 43360, 43388, 43392, 43456, 43471, 43481, 43520, 43574, 43584, 43597, 43600, 43609, 43616, 43638, 43642, 43643, 43648, 43714, 43739, 43741, 43744, 43759, 43762, 43766, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43968, 44010, 44012, 44013, 44016, 44025, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65019, 65024, 65039, 65056, 65062, 65075, 65076, 65101, 65103, 65136, 65140, 65142, 65276, 65296, 65305, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500];
    var unicodeESNextIdentifierStart = [65, 90, 97, 122, 170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 880, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1488, 1514, 1519, 1522, 1568, 1610, 1646, 1647, 1649, 1747, 1749, 1749, 1765, 1766, 1774, 1775, 1786, 1788, 1791, 1791, 1808, 1808, 1810, 1839, 1869, 1957, 1969, 1969, 1994, 2026, 2036, 2037, 2042, 2042, 2048, 2069, 2074, 2074, 2084, 2084, 2088, 2088, 2112, 2136, 2144, 2154, 2208, 2228, 2230, 2237, 2308, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2417, 2432, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2493, 2493, 2510, 2510, 2524, 2525, 2527, 2529, 2544, 2545, 2556, 2556, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2785, 2809, 2809, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2929, 2929, 2947, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3024, 3024, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3133, 3133, 3160, 3162, 3168, 3169, 3200, 3200, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3261, 3261, 3294, 3294, 3296, 3297, 3313, 3314, 3333, 3340, 3342, 3344, 3346, 3386, 3389, 3389, 3406, 3406, 3412, 3414, 3423, 3425, 3450, 3455, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3635, 3648, 3654, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3807, 3840, 3840, 3904, 3911, 3913, 3948, 3976, 3980, 4096, 4138, 4159, 4159, 4176, 4181, 4186, 4189, 4193, 4193, 4197, 4198, 4206, 4208, 4213, 4225, 4238, 4238, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5900, 5902, 5905, 5920, 5937, 5952, 5969, 5984, 5996, 5998, 6e3, 6016, 6067, 6103, 6103, 6108, 6108, 6176, 6264, 6272, 6312, 6314, 6314, 6320, 6389, 6400, 6430, 6480, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6656, 6678, 6688, 6740, 6823, 6823, 6917, 6963, 6981, 6987, 7043, 7072, 7086, 7087, 7098, 7141, 7168, 7203, 7245, 7247, 7258, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7401, 7404, 7406, 7411, 7413, 7414, 7418, 7418, 7424, 7615, 7680, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8305, 8305, 8319, 8319, 8336, 8348, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8472, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11310, 11312, 11358, 11360, 11492, 11499, 11502, 11506, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11648, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 12293, 12295, 12321, 12329, 12337, 12341, 12344, 12348, 12353, 12438, 12443, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12730, 12784, 12799, 13312, 19893, 19968, 40943, 40960, 42124, 42192, 42237, 42240, 42508, 42512, 42527, 42538, 42539, 42560, 42606, 42623, 42653, 42656, 42735, 42775, 42783, 42786, 42888, 42891, 42943, 42946, 42950, 42999, 43009, 43011, 43013, 43015, 43018, 43020, 43042, 43072, 43123, 43138, 43187, 43250, 43255, 43259, 43259, 43261, 43262, 43274, 43301, 43312, 43334, 43360, 43388, 43396, 43442, 43471, 43471, 43488, 43492, 43494, 43503, 43514, 43518, 43520, 43560, 43584, 43586, 43588, 43595, 43616, 43638, 43642, 43642, 43646, 43695, 43697, 43697, 43701, 43702, 43705, 43709, 43712, 43712, 43714, 43714, 43739, 43741, 43744, 43754, 43762, 43764, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43879, 43888, 44002, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65019, 65136, 65140, 65142, 65276, 65313, 65338, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66176, 66204, 66208, 66256, 66304, 66335, 66349, 66378, 66384, 66421, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 67072, 67382, 67392, 67413, 67424, 67431, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68096, 68112, 68115, 68117, 68119, 68121, 68149, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68324, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68899, 69376, 69404, 69415, 69415, 69424, 69445, 69600, 69622, 69635, 69687, 69763, 69807, 69840, 69864, 69891, 69926, 69956, 69956, 69968, 70002, 70006, 70006, 70019, 70066, 70081, 70084, 70106, 70106, 70108, 70108, 70144, 70161, 70163, 70187, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70366, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70461, 70461, 70480, 70480, 70493, 70497, 70656, 70708, 70727, 70730, 70751, 70751, 70784, 70831, 70852, 70853, 70855, 70855, 71040, 71086, 71128, 71131, 71168, 71215, 71236, 71236, 71296, 71338, 71352, 71352, 71424, 71450, 71680, 71723, 71840, 71903, 71935, 71935, 72096, 72103, 72106, 72144, 72161, 72161, 72163, 72163, 72192, 72192, 72203, 72242, 72250, 72250, 72272, 72272, 72284, 72329, 72349, 72349, 72384, 72440, 72704, 72712, 72714, 72750, 72768, 72768, 72818, 72847, 72960, 72966, 72968, 72969, 72971, 73008, 73030, 73030, 73056, 73061, 73063, 73064, 73066, 73097, 73112, 73112, 73440, 73458, 73728, 74649, 74752, 74862, 74880, 75075, 77824, 78894, 82944, 83526, 92160, 92728, 92736, 92766, 92880, 92909, 92928, 92975, 92992, 92995, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94032, 94032, 94099, 94111, 94176, 94177, 94179, 94179, 94208, 100343, 100352, 101106, 110592, 110878, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 123136, 123180, 123191, 123197, 123214, 123214, 123584, 123627, 124928, 125124, 125184, 125251, 125259, 125259, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 131072, 173782, 173824, 177972, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101];
    var unicodeESNextIdentifierPart = [48, 57, 65, 90, 95, 95, 97, 122, 170, 170, 181, 181, 183, 183, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 768, 884, 886, 887, 890, 893, 895, 895, 902, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1155, 1159, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1425, 1469, 1471, 1471, 1473, 1474, 1476, 1477, 1479, 1479, 1488, 1514, 1519, 1522, 1552, 1562, 1568, 1641, 1646, 1747, 1749, 1756, 1759, 1768, 1770, 1788, 1791, 1791, 1808, 1866, 1869, 1969, 1984, 2037, 2042, 2042, 2045, 2045, 2048, 2093, 2112, 2139, 2144, 2154, 2208, 2228, 2230, 2237, 2259, 2273, 2275, 2403, 2406, 2415, 2417, 2435, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2492, 2500, 2503, 2504, 2507, 2510, 2519, 2519, 2524, 2525, 2527, 2531, 2534, 2545, 2556, 2556, 2558, 2558, 2561, 2563, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2620, 2620, 2622, 2626, 2631, 2632, 2635, 2637, 2641, 2641, 2649, 2652, 2654, 2654, 2662, 2677, 2689, 2691, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2748, 2757, 2759, 2761, 2763, 2765, 2768, 2768, 2784, 2787, 2790, 2799, 2809, 2815, 2817, 2819, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2876, 2884, 2887, 2888, 2891, 2893, 2902, 2903, 2908, 2909, 2911, 2915, 2918, 2927, 2929, 2929, 2946, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3006, 3010, 3014, 3016, 3018, 3021, 3024, 3024, 3031, 3031, 3046, 3055, 3072, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3133, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3160, 3162, 3168, 3171, 3174, 3183, 3200, 3203, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3260, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3294, 3294, 3296, 3299, 3302, 3311, 3313, 3314, 3328, 3331, 3333, 3340, 3342, 3344, 3346, 3396, 3398, 3400, 3402, 3406, 3412, 3415, 3423, 3427, 3430, 3439, 3450, 3455, 3458, 3459, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3530, 3530, 3535, 3540, 3542, 3542, 3544, 3551, 3558, 3567, 3570, 3571, 3585, 3642, 3648, 3662, 3664, 3673, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3773, 3776, 3780, 3782, 3782, 3784, 3789, 3792, 3801, 3804, 3807, 3840, 3840, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3911, 3913, 3948, 3953, 3972, 3974, 3991, 3993, 4028, 4038, 4038, 4096, 4169, 4176, 4253, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4957, 4959, 4969, 4977, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5900, 5902, 5908, 5920, 5940, 5952, 5971, 5984, 5996, 5998, 6e3, 6002, 6003, 6016, 6099, 6103, 6103, 6108, 6109, 6112, 6121, 6155, 6157, 6160, 6169, 6176, 6264, 6272, 6314, 6320, 6389, 6400, 6430, 6432, 6443, 6448, 6459, 6470, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6608, 6618, 6656, 6683, 6688, 6750, 6752, 6780, 6783, 6793, 6800, 6809, 6823, 6823, 6832, 6845, 6912, 6987, 6992, 7001, 7019, 7027, 7040, 7155, 7168, 7223, 7232, 7241, 7245, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7376, 7378, 7380, 7418, 7424, 7673, 7675, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8255, 8256, 8276, 8276, 8305, 8305, 8319, 8319, 8336, 8348, 8400, 8412, 8417, 8417, 8421, 8432, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8472, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11310, 11312, 11358, 11360, 11492, 11499, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11647, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11744, 11775, 12293, 12295, 12321, 12335, 12337, 12341, 12344, 12348, 12353, 12438, 12441, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12730, 12784, 12799, 13312, 19893, 19968, 40943, 40960, 42124, 42192, 42237, 42240, 42508, 42512, 42539, 42560, 42607, 42612, 42621, 42623, 42737, 42775, 42783, 42786, 42888, 42891, 42943, 42946, 42950, 42999, 43047, 43072, 43123, 43136, 43205, 43216, 43225, 43232, 43255, 43259, 43259, 43261, 43309, 43312, 43347, 43360, 43388, 43392, 43456, 43471, 43481, 43488, 43518, 43520, 43574, 43584, 43597, 43600, 43609, 43616, 43638, 43642, 43714, 43739, 43741, 43744, 43759, 43762, 43766, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43879, 43888, 44010, 44012, 44013, 44016, 44025, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65019, 65024, 65039, 65056, 65071, 65075, 65076, 65101, 65103, 65136, 65140, 65142, 65276, 65296, 65305, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66045, 66045, 66176, 66204, 66208, 66256, 66272, 66272, 66304, 66335, 66349, 66378, 66384, 66426, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66720, 66729, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 67072, 67382, 67392, 67413, 67424, 67431, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68099, 68101, 68102, 68108, 68115, 68117, 68119, 68121, 68149, 68152, 68154, 68159, 68159, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68326, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68903, 68912, 68921, 69376, 69404, 69415, 69415, 69424, 69456, 69600, 69622, 69632, 69702, 69734, 69743, 69759, 69818, 69840, 69864, 69872, 69881, 69888, 69940, 69942, 69951, 69956, 69958, 69968, 70003, 70006, 70006, 70016, 70084, 70089, 70092, 70096, 70106, 70108, 70108, 70144, 70161, 70163, 70199, 70206, 70206, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70378, 70384, 70393, 70400, 70403, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70459, 70468, 70471, 70472, 70475, 70477, 70480, 70480, 70487, 70487, 70493, 70499, 70502, 70508, 70512, 70516, 70656, 70730, 70736, 70745, 70750, 70751, 70784, 70853, 70855, 70855, 70864, 70873, 71040, 71093, 71096, 71104, 71128, 71133, 71168, 71232, 71236, 71236, 71248, 71257, 71296, 71352, 71360, 71369, 71424, 71450, 71453, 71467, 71472, 71481, 71680, 71738, 71840, 71913, 71935, 71935, 72096, 72103, 72106, 72151, 72154, 72161, 72163, 72164, 72192, 72254, 72263, 72263, 72272, 72345, 72349, 72349, 72384, 72440, 72704, 72712, 72714, 72758, 72760, 72768, 72784, 72793, 72818, 72847, 72850, 72871, 72873, 72886, 72960, 72966, 72968, 72969, 72971, 73014, 73018, 73018, 73020, 73021, 73023, 73031, 73040, 73049, 73056, 73061, 73063, 73064, 73066, 73102, 73104, 73105, 73107, 73112, 73120, 73129, 73440, 73462, 73728, 74649, 74752, 74862, 74880, 75075, 77824, 78894, 82944, 83526, 92160, 92728, 92736, 92766, 92768, 92777, 92880, 92909, 92912, 92916, 92928, 92982, 92992, 92995, 93008, 93017, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94031, 94087, 94095, 94111, 94176, 94177, 94179, 94179, 94208, 100343, 100352, 101106, 110592, 110878, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 113821, 113822, 119141, 119145, 119149, 119154, 119163, 119170, 119173, 119179, 119210, 119213, 119362, 119364, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 120782, 120831, 121344, 121398, 121403, 121452, 121461, 121461, 121476, 121476, 121499, 121503, 121505, 121519, 122880, 122886, 122888, 122904, 122907, 122913, 122915, 122916, 122918, 122922, 123136, 123180, 123184, 123197, 123200, 123209, 123214, 123214, 123584, 123641, 124928, 125124, 125136, 125142, 125184, 125259, 125264, 125273, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 131072, 173782, 173824, 177972, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 917760, 917999];
    var commentDirectiveRegExSingleLine = /^\/\/\/?\s*@(ts-expect-error|ts-ignore)/;
    var commentDirectiveRegExMultiLine = /^(?:\/|\*)*\s*@(ts-expect-error|ts-ignore)/;
    function lookupInUnicodeMap(code, map) {
      if (code < map[0]) {
        return false;
      }
      var lo = 0;
      var hi = map.length;
      var mid;
      while (lo + 1 < hi) {
        mid = lo + (hi - lo) / 2;
        mid -= mid % 2;
        if (map[mid] <= code && code <= map[mid + 1]) {
          return true;
        }
        if (code < map[mid]) {
          hi = mid;
        } else {
          lo = mid + 2;
        }
      }
      return false;
    }
    function isUnicodeIdentifierStart(code, languageVersion) {
      return languageVersion >= 2 ? lookupInUnicodeMap(code, unicodeESNextIdentifierStart) : languageVersion === 1 ? lookupInUnicodeMap(code, unicodeES5IdentifierStart) : lookupInUnicodeMap(code, unicodeES3IdentifierStart);
    }
    ts2.isUnicodeIdentifierStart = isUnicodeIdentifierStart;
    function isUnicodeIdentifierPart(code, languageVersion) {
      return languageVersion >= 2 ? lookupInUnicodeMap(code, unicodeESNextIdentifierPart) : languageVersion === 1 ? lookupInUnicodeMap(code, unicodeES5IdentifierPart) : lookupInUnicodeMap(code, unicodeES3IdentifierPart);
    }
    function makeReverseMap(source) {
      var result = [];
      source.forEach(function(value, name) {
        result[value] = name;
      });
      return result;
    }
    var tokenStrings = makeReverseMap(textToToken);
    function tokenToString(t) {
      return tokenStrings[t];
    }
    ts2.tokenToString = tokenToString;
    function stringToToken(s) {
      return textToToken.get(s);
    }
    ts2.stringToToken = stringToToken;
    function computeLineStarts(text) {
      var result = new Array();
      var pos = 0;
      var lineStart = 0;
      while (pos < text.length) {
        var ch = text.charCodeAt(pos);
        pos++;
        switch (ch) {
          case 13:
            if (text.charCodeAt(pos) === 10) {
              pos++;
            }
          case 10:
            result.push(lineStart);
            lineStart = pos;
            break;
          default:
            if (ch > 127 && isLineBreak(ch)) {
              result.push(lineStart);
              lineStart = pos;
            }
            break;
        }
      }
      result.push(lineStart);
      return result;
    }
    ts2.computeLineStarts = computeLineStarts;
    function getPositionOfLineAndCharacter(sourceFile, line, character, allowEdits) {
      return sourceFile.getPositionOfLineAndCharacter ? sourceFile.getPositionOfLineAndCharacter(line, character, allowEdits) : computePositionOfLineAndCharacter(getLineStarts(sourceFile), line, character, sourceFile.text, allowEdits);
    }
    ts2.getPositionOfLineAndCharacter = getPositionOfLineAndCharacter;
    function computePositionOfLineAndCharacter(lineStarts, line, character, debugText, allowEdits) {
      if (line < 0 || line >= lineStarts.length) {
        if (allowEdits) {
          line = line < 0 ? 0 : line >= lineStarts.length ? lineStarts.length - 1 : line;
        } else {
          ts2.Debug.fail("Bad line number. Line: " + line + ", lineStarts.length: " + lineStarts.length + " , line map is correct? " + (debugText !== void 0 ? ts2.arraysEqual(lineStarts, computeLineStarts(debugText)) : "unknown"));
        }
      }
      var res = lineStarts[line] + character;
      if (allowEdits) {
        return res > lineStarts[line + 1] ? lineStarts[line + 1] : typeof debugText === "string" && res > debugText.length ? debugText.length : res;
      }
      if (line < lineStarts.length - 1) {
        ts2.Debug.assert(res < lineStarts[line + 1]);
      } else if (debugText !== void 0) {
        ts2.Debug.assert(res <= debugText.length);
      }
      return res;
    }
    ts2.computePositionOfLineAndCharacter = computePositionOfLineAndCharacter;
    function getLineStarts(sourceFile) {
      return sourceFile.lineMap || (sourceFile.lineMap = computeLineStarts(sourceFile.text));
    }
    ts2.getLineStarts = getLineStarts;
    function computeLineAndCharacterOfPosition(lineStarts, position) {
      var lineNumber = computeLineOfPosition(lineStarts, position);
      return {
        line: lineNumber,
        character: position - lineStarts[lineNumber]
      };
    }
    ts2.computeLineAndCharacterOfPosition = computeLineAndCharacterOfPosition;
    function computeLineOfPosition(lineStarts, position, lowerBound) {
      var lineNumber = ts2.binarySearch(lineStarts, position, ts2.identity, ts2.compareValues, lowerBound);
      if (lineNumber < 0) {
        lineNumber = ~lineNumber - 1;
        ts2.Debug.assert(lineNumber !== -1, "position cannot precede the beginning of the file");
      }
      return lineNumber;
    }
    ts2.computeLineOfPosition = computeLineOfPosition;
    function getLinesBetweenPositions(sourceFile, pos1, pos2) {
      if (pos1 === pos2)
        return 0;
      var lineStarts = getLineStarts(sourceFile);
      var lower = Math.min(pos1, pos2);
      var isNegative = lower === pos2;
      var upper = isNegative ? pos1 : pos2;
      var lowerLine = computeLineOfPosition(lineStarts, lower);
      var upperLine = computeLineOfPosition(lineStarts, upper, lowerLine);
      return isNegative ? lowerLine - upperLine : upperLine - lowerLine;
    }
    ts2.getLinesBetweenPositions = getLinesBetweenPositions;
    function getLineAndCharacterOfPosition(sourceFile, position) {
      return computeLineAndCharacterOfPosition(getLineStarts(sourceFile), position);
    }
    ts2.getLineAndCharacterOfPosition = getLineAndCharacterOfPosition;
    function isWhiteSpaceLike(ch) {
      return isWhiteSpaceSingleLine(ch) || isLineBreak(ch);
    }
    ts2.isWhiteSpaceLike = isWhiteSpaceLike;
    function isWhiteSpaceSingleLine(ch) {
      return ch === 32 || ch === 9 || ch === 11 || ch === 12 || ch === 160 || ch === 133 || ch === 5760 || ch >= 8192 && ch <= 8203 || ch === 8239 || ch === 8287 || ch === 12288 || ch === 65279;
    }
    ts2.isWhiteSpaceSingleLine = isWhiteSpaceSingleLine;
    function isLineBreak(ch) {
      return ch === 10 || ch === 13 || ch === 8232 || ch === 8233;
    }
    ts2.isLineBreak = isLineBreak;
    function isDigit(ch) {
      return ch >= 48 && ch <= 57;
    }
    function isHexDigit(ch) {
      return isDigit(ch) || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102;
    }
    function isCodePoint(code) {
      return code <= 1114111;
    }
    function isOctalDigit(ch) {
      return ch >= 48 && ch <= 55;
    }
    ts2.isOctalDigit = isOctalDigit;
    function couldStartTrivia(text, pos) {
      var ch = text.charCodeAt(pos);
      switch (ch) {
        case 13:
        case 10:
        case 9:
        case 11:
        case 12:
        case 32:
        case 47:
        case 60:
        case 124:
        case 61:
        case 62:
          return true;
        case 35:
          return pos === 0;
        default:
          return ch > 127;
      }
    }
    ts2.couldStartTrivia = couldStartTrivia;
    function skipTrivia(text, pos, stopAfterLineBreak, stopAtComments, inJSDoc) {
      if (ts2.positionIsSynthesized(pos)) {
        return pos;
      }
      var canConsumeStar = false;
      while (true) {
        var ch = text.charCodeAt(pos);
        switch (ch) {
          case 13:
            if (text.charCodeAt(pos + 1) === 10) {
              pos++;
            }
          case 10:
            pos++;
            if (stopAfterLineBreak) {
              return pos;
            }
            canConsumeStar = !!inJSDoc;
            continue;
          case 9:
          case 11:
          case 12:
          case 32:
            pos++;
            continue;
          case 47:
            if (stopAtComments) {
              break;
            }
            if (text.charCodeAt(pos + 1) === 47) {
              pos += 2;
              while (pos < text.length) {
                if (isLineBreak(text.charCodeAt(pos))) {
                  break;
                }
                pos++;
              }
              canConsumeStar = false;
              continue;
            }
            if (text.charCodeAt(pos + 1) === 42) {
              pos += 2;
              while (pos < text.length) {
                if (text.charCodeAt(pos) === 42 && text.charCodeAt(pos + 1) === 47) {
                  pos += 2;
                  break;
                }
                pos++;
              }
              canConsumeStar = false;
              continue;
            }
            break;
          case 60:
          case 124:
          case 61:
          case 62:
            if (isConflictMarkerTrivia(text, pos)) {
              pos = scanConflictMarkerTrivia(text, pos);
              canConsumeStar = false;
              continue;
            }
            break;
          case 35:
            if (pos === 0 && isShebangTrivia(text, pos)) {
              pos = scanShebangTrivia(text, pos);
              canConsumeStar = false;
              continue;
            }
            break;
          case 42:
            if (canConsumeStar) {
              pos++;
              canConsumeStar = false;
              continue;
            }
            break;
          default:
            if (ch > 127 && isWhiteSpaceLike(ch)) {
              pos++;
              continue;
            }
            break;
        }
        return pos;
      }
    }
    ts2.skipTrivia = skipTrivia;
    var mergeConflictMarkerLength = "<<<<<<<".length;
    function isConflictMarkerTrivia(text, pos) {
      ts2.Debug.assert(pos >= 0);
      if (pos === 0 || isLineBreak(text.charCodeAt(pos - 1))) {
        var ch = text.charCodeAt(pos);
        if (pos + mergeConflictMarkerLength < text.length) {
          for (var i = 0; i < mergeConflictMarkerLength; i++) {
            if (text.charCodeAt(pos + i) !== ch) {
              return false;
            }
          }
          return ch === 61 || text.charCodeAt(pos + mergeConflictMarkerLength) === 32;
        }
      }
      return false;
    }
    function scanConflictMarkerTrivia(text, pos, error) {
      if (error) {
        error(ts2.Diagnostics.Merge_conflict_marker_encountered, pos, mergeConflictMarkerLength);
      }
      var ch = text.charCodeAt(pos);
      var len = text.length;
      if (ch === 60 || ch === 62) {
        while (pos < len && !isLineBreak(text.charCodeAt(pos))) {
          pos++;
        }
      } else {
        ts2.Debug.assert(ch === 124 || ch === 61);
        while (pos < len) {
          var currentChar = text.charCodeAt(pos);
          if ((currentChar === 61 || currentChar === 62) && currentChar !== ch && isConflictMarkerTrivia(text, pos)) {
            break;
          }
          pos++;
        }
      }
      return pos;
    }
    var shebangTriviaRegex = /^#!.*/;
    function isShebangTrivia(text, pos) {
      ts2.Debug.assert(pos === 0);
      return shebangTriviaRegex.test(text);
    }
    ts2.isShebangTrivia = isShebangTrivia;
    function scanShebangTrivia(text, pos) {
      var shebang = shebangTriviaRegex.exec(text)[0];
      pos = pos + shebang.length;
      return pos;
    }
    ts2.scanShebangTrivia = scanShebangTrivia;
    function iterateCommentRanges(reduce, text, pos, trailing, cb, state, initial) {
      var pendingPos;
      var pendingEnd;
      var pendingKind;
      var pendingHasTrailingNewLine;
      var hasPendingCommentRange = false;
      var collecting = trailing;
      var accumulator = initial;
      if (pos === 0) {
        collecting = true;
        var shebang = getShebang(text);
        if (shebang) {
          pos = shebang.length;
        }
      }
      scan:
        while (pos >= 0 && pos < text.length) {
          var ch = text.charCodeAt(pos);
          switch (ch) {
            case 13:
              if (text.charCodeAt(pos + 1) === 10) {
                pos++;
              }
            case 10:
              pos++;
              if (trailing) {
                break scan;
              }
              collecting = true;
              if (hasPendingCommentRange) {
                pendingHasTrailingNewLine = true;
              }
              continue;
            case 9:
            case 11:
            case 12:
            case 32:
              pos++;
              continue;
            case 47:
              var nextChar = text.charCodeAt(pos + 1);
              var hasTrailingNewLine = false;
              if (nextChar === 47 || nextChar === 42) {
                var kind = nextChar === 47 ? 2 : 3;
                var startPos = pos;
                pos += 2;
                if (nextChar === 47) {
                  while (pos < text.length) {
                    if (isLineBreak(text.charCodeAt(pos))) {
                      hasTrailingNewLine = true;
                      break;
                    }
                    pos++;
                  }
                } else {
                  while (pos < text.length) {
                    if (text.charCodeAt(pos) === 42 && text.charCodeAt(pos + 1) === 47) {
                      pos += 2;
                      break;
                    }
                    pos++;
                  }
                }
                if (collecting) {
                  if (hasPendingCommentRange) {
                    accumulator = cb(pendingPos, pendingEnd, pendingKind, pendingHasTrailingNewLine, state, accumulator);
                    if (!reduce && accumulator) {
                      return accumulator;
                    }
                  }
                  pendingPos = startPos;
                  pendingEnd = pos;
                  pendingKind = kind;
                  pendingHasTrailingNewLine = hasTrailingNewLine;
                  hasPendingCommentRange = true;
                }
                continue;
              }
              break scan;
            default:
              if (ch > 127 && isWhiteSpaceLike(ch)) {
                if (hasPendingCommentRange && isLineBreak(ch)) {
                  pendingHasTrailingNewLine = true;
                }
                pos++;
                continue;
              }
              break scan;
          }
        }
      if (hasPendingCommentRange) {
        accumulator = cb(pendingPos, pendingEnd, pendingKind, pendingHasTrailingNewLine, state, accumulator);
      }
      return accumulator;
    }
    function forEachLeadingCommentRange(text, pos, cb, state) {
      return iterateCommentRanges(false, text, pos, false, cb, state);
    }
    ts2.forEachLeadingCommentRange = forEachLeadingCommentRange;
    function forEachTrailingCommentRange(text, pos, cb, state) {
      return iterateCommentRanges(false, text, pos, true, cb, state);
    }
    ts2.forEachTrailingCommentRange = forEachTrailingCommentRange;
    function reduceEachLeadingCommentRange(text, pos, cb, state, initial) {
      return iterateCommentRanges(true, text, pos, false, cb, state, initial);
    }
    ts2.reduceEachLeadingCommentRange = reduceEachLeadingCommentRange;
    function reduceEachTrailingCommentRange(text, pos, cb, state, initial) {
      return iterateCommentRanges(true, text, pos, true, cb, state, initial);
    }
    ts2.reduceEachTrailingCommentRange = reduceEachTrailingCommentRange;
    function appendCommentRange(pos, end, kind, hasTrailingNewLine, _state, comments) {
      if (!comments) {
        comments = [];
      }
      comments.push({ kind, pos, end, hasTrailingNewLine });
      return comments;
    }
    function getLeadingCommentRanges(text, pos) {
      return reduceEachLeadingCommentRange(text, pos, appendCommentRange, void 0, void 0);
    }
    ts2.getLeadingCommentRanges = getLeadingCommentRanges;
    function getTrailingCommentRanges(text, pos) {
      return reduceEachTrailingCommentRange(text, pos, appendCommentRange, void 0, void 0);
    }
    ts2.getTrailingCommentRanges = getTrailingCommentRanges;
    function getShebang(text) {
      var match = shebangTriviaRegex.exec(text);
      if (match) {
        return match[0];
      }
    }
    ts2.getShebang = getShebang;
    function isIdentifierStart(ch, languageVersion) {
      return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch === 36 || ch === 95 || ch > 127 && isUnicodeIdentifierStart(ch, languageVersion);
    }
    ts2.isIdentifierStart = isIdentifierStart;
    function isIdentifierPart(ch, languageVersion, identifierVariant) {
      return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57 || ch === 36 || ch === 95 || (identifierVariant === 1 ? ch === 45 || ch === 58 : false) || ch > 127 && isUnicodeIdentifierPart(ch, languageVersion);
    }
    ts2.isIdentifierPart = isIdentifierPart;
    function isIdentifierText(name, languageVersion, identifierVariant) {
      var ch = codePointAt(name, 0);
      if (!isIdentifierStart(ch, languageVersion)) {
        return false;
      }
      for (var i = charSize(ch); i < name.length; i += charSize(ch)) {
        if (!isIdentifierPart(ch = codePointAt(name, i), languageVersion, identifierVariant)) {
          return false;
        }
      }
      return true;
    }
    ts2.isIdentifierText = isIdentifierText;
    function createScanner(languageVersion, skipTrivia2, languageVariant, textInitial, onError, start, length) {
      if (languageVariant === void 0) {
        languageVariant = 0;
      }
      var text = textInitial;
      var pos;
      var end;
      var startPos;
      var tokenPos;
      var token;
      var tokenValue;
      var tokenFlags;
      var commentDirectives;
      var inJSDocType = 0;
      setText(text, start, length);
      var scanner = {
        getStartPos: function() {
          return startPos;
        },
        getTextPos: function() {
          return pos;
        },
        getToken: function() {
          return token;
        },
        getTokenPos: function() {
          return tokenPos;
        },
        getTokenText: function() {
          return text.substring(tokenPos, pos);
        },
        getTokenValue: function() {
          return tokenValue;
        },
        hasUnicodeEscape: function() {
          return (tokenFlags & 1024) !== 0;
        },
        hasExtendedUnicodeEscape: function() {
          return (tokenFlags & 8) !== 0;
        },
        hasPrecedingLineBreak: function() {
          return (tokenFlags & 1) !== 0;
        },
        hasPrecedingJSDocComment: function() {
          return (tokenFlags & 2) !== 0;
        },
        isIdentifier: function() {
          return token === 79 || token > 116;
        },
        isReservedWord: function() {
          return token >= 81 && token <= 116;
        },
        isUnterminated: function() {
          return (tokenFlags & 4) !== 0;
        },
        getCommentDirectives: function() {
          return commentDirectives;
        },
        getNumericLiteralFlags: function() {
          return tokenFlags & 1008;
        },
        getTokenFlags: function() {
          return tokenFlags;
        },
        reScanGreaterToken,
        reScanAsteriskEqualsToken,
        reScanSlashToken,
        reScanTemplateToken,
        reScanTemplateHeadOrNoSubstitutionTemplate,
        scanJsxIdentifier,
        scanJsxAttributeValue,
        reScanJsxAttributeValue,
        reScanJsxToken,
        reScanLessThanToken,
        reScanHashToken,
        reScanQuestionToken,
        reScanInvalidIdentifier,
        scanJsxToken,
        scanJsDocToken,
        scan,
        getText,
        clearCommentDirectives,
        setText,
        setScriptTarget,
        setLanguageVariant,
        setOnError,
        setTextPos,
        setInJSDocType,
        tryScan,
        lookAhead,
        scanRange
      };
      if (ts2.Debug.isDebugging) {
        Object.defineProperty(scanner, "__debugShowCurrentPositionInText", {
          get: function() {
            var text2 = scanner.getText();
            return text2.slice(0, scanner.getStartPos()) + "\u2551" + text2.slice(scanner.getStartPos());
          }
        });
      }
      return scanner;
      function error(message, errPos, length2) {
        if (errPos === void 0) {
          errPos = pos;
        }
        if (onError) {
          var oldPos = pos;
          pos = errPos;
          onError(message, length2 || 0);
          pos = oldPos;
        }
      }
      function scanNumberFragment() {
        var start2 = pos;
        var allowSeparator = false;
        var isPreviousTokenSeparator = false;
        var result = "";
        while (true) {
          var ch = text.charCodeAt(pos);
          if (ch === 95) {
            tokenFlags |= 512;
            if (allowSeparator) {
              allowSeparator = false;
              isPreviousTokenSeparator = true;
              result += text.substring(start2, pos);
            } else if (isPreviousTokenSeparator) {
              error(ts2.Diagnostics.Multiple_consecutive_numeric_separators_are_not_permitted, pos, 1);
            } else {
              error(ts2.Diagnostics.Numeric_separators_are_not_allowed_here, pos, 1);
            }
            pos++;
            start2 = pos;
            continue;
          }
          if (isDigit(ch)) {
            allowSeparator = true;
            isPreviousTokenSeparator = false;
            pos++;
            continue;
          }
          break;
        }
        if (text.charCodeAt(pos - 1) === 95) {
          error(ts2.Diagnostics.Numeric_separators_are_not_allowed_here, pos - 1, 1);
        }
        return result + text.substring(start2, pos);
      }
      function scanNumber() {
        var start2 = pos;
        var mainFragment = scanNumberFragment();
        var decimalFragment;
        var scientificFragment;
        if (text.charCodeAt(pos) === 46) {
          pos++;
          decimalFragment = scanNumberFragment();
        }
        var end2 = pos;
        if (text.charCodeAt(pos) === 69 || text.charCodeAt(pos) === 101) {
          pos++;
          tokenFlags |= 16;
          if (text.charCodeAt(pos) === 43 || text.charCodeAt(pos) === 45)
            pos++;
          var preNumericPart = pos;
          var finalFragment = scanNumberFragment();
          if (!finalFragment) {
            error(ts2.Diagnostics.Digit_expected);
          } else {
            scientificFragment = text.substring(end2, preNumericPart) + finalFragment;
            end2 = pos;
          }
        }
        var result;
        if (tokenFlags & 512) {
          result = mainFragment;
          if (decimalFragment) {
            result += "." + decimalFragment;
          }
          if (scientificFragment) {
            result += scientificFragment;
          }
        } else {
          result = text.substring(start2, end2);
        }
        if (decimalFragment !== void 0 || tokenFlags & 16) {
          checkForIdentifierStartAfterNumericLiteral(start2, decimalFragment === void 0 && !!(tokenFlags & 16));
          return {
            type: 8,
            value: "" + +result
          };
        } else {
          tokenValue = result;
          var type = checkBigIntSuffix();
          checkForIdentifierStartAfterNumericLiteral(start2);
          return { type, value: tokenValue };
        }
      }
      function checkForIdentifierStartAfterNumericLiteral(numericStart, isScientific) {
        if (!isIdentifierStart(codePointAt(text, pos), languageVersion)) {
          return;
        }
        var identifierStart = pos;
        var length2 = scanIdentifierParts().length;
        if (length2 === 1 && text[identifierStart] === "n") {
          if (isScientific) {
            error(ts2.Diagnostics.A_bigint_literal_cannot_use_exponential_notation, numericStart, identifierStart - numericStart + 1);
          } else {
            error(ts2.Diagnostics.A_bigint_literal_must_be_an_integer, numericStart, identifierStart - numericStart + 1);
          }
        } else {
          error(ts2.Diagnostics.An_identifier_or_keyword_cannot_immediately_follow_a_numeric_literal, identifierStart, length2);
          pos = identifierStart;
        }
      }
      function scanOctalDigits() {
        var start2 = pos;
        while (isOctalDigit(text.charCodeAt(pos))) {
          pos++;
        }
        return +text.substring(start2, pos);
      }
      function scanExactNumberOfHexDigits(count, canHaveSeparators) {
        var valueString = scanHexDigits(count, false, canHaveSeparators);
        return valueString ? parseInt(valueString, 16) : -1;
      }
      function scanMinimumNumberOfHexDigits(count, canHaveSeparators) {
        return scanHexDigits(count, true, canHaveSeparators);
      }
      function scanHexDigits(minCount, scanAsManyAsPossible, canHaveSeparators) {
        var valueChars = [];
        var allowSeparator = false;
        var isPreviousTokenSeparator = false;
        while (valueChars.length < minCount || scanAsManyAsPossible) {
          var ch = text.charCodeAt(pos);
          if (canHaveSeparators && ch === 95) {
            tokenFlags |= 512;
            if (allowSeparator) {
              allowSeparator = false;
              isPreviousTokenSeparator = true;
            } else if (isPreviousTokenSeparator) {
              error(ts2.Diagnostics.Multiple_consecutive_numeric_separators_are_not_permitted, pos, 1);
            } else {
              error(ts2.Diagnostics.Numeric_separators_are_not_allowed_here, pos, 1);
            }
            pos++;
            continue;
          }
          allowSeparator = canHaveSeparators;
          if (ch >= 65 && ch <= 70) {
            ch += 97 - 65;
          } else if (!(ch >= 48 && ch <= 57 || ch >= 97 && ch <= 102)) {
            break;
          }
          valueChars.push(ch);
          pos++;
          isPreviousTokenSeparator = false;
        }
        if (valueChars.length < minCount) {
          valueChars = [];
        }
        if (text.charCodeAt(pos - 1) === 95) {
          error(ts2.Diagnostics.Numeric_separators_are_not_allowed_here, pos - 1, 1);
        }
        return String.fromCharCode.apply(String, valueChars);
      }
      function scanString(jsxAttributeString) {
        if (jsxAttributeString === void 0) {
          jsxAttributeString = false;
        }
        var quote = text.charCodeAt(pos);
        pos++;
        var result = "";
        var start2 = pos;
        while (true) {
          if (pos >= end) {
            result += text.substring(start2, pos);
            tokenFlags |= 4;
            error(ts2.Diagnostics.Unterminated_string_literal);
            break;
          }
          var ch = text.charCodeAt(pos);
          if (ch === quote) {
            result += text.substring(start2, pos);
            pos++;
            break;
          }
          if (ch === 92 && !jsxAttributeString) {
            result += text.substring(start2, pos);
            result += scanEscapeSequence();
            start2 = pos;
            continue;
          }
          if (isLineBreak(ch) && !jsxAttributeString) {
            result += text.substring(start2, pos);
            tokenFlags |= 4;
            error(ts2.Diagnostics.Unterminated_string_literal);
            break;
          }
          pos++;
        }
        return result;
      }
      function scanTemplateAndSetTokenValue(isTaggedTemplate) {
        var startedWithBacktick = text.charCodeAt(pos) === 96;
        pos++;
        var start2 = pos;
        var contents = "";
        var resultingToken;
        while (true) {
          if (pos >= end) {
            contents += text.substring(start2, pos);
            tokenFlags |= 4;
            error(ts2.Diagnostics.Unterminated_template_literal);
            resultingToken = startedWithBacktick ? 14 : 17;
            break;
          }
          var currChar = text.charCodeAt(pos);
          if (currChar === 96) {
            contents += text.substring(start2, pos);
            pos++;
            resultingToken = startedWithBacktick ? 14 : 17;
            break;
          }
          if (currChar === 36 && pos + 1 < end && text.charCodeAt(pos + 1) === 123) {
            contents += text.substring(start2, pos);
            pos += 2;
            resultingToken = startedWithBacktick ? 15 : 16;
            break;
          }
          if (currChar === 92) {
            contents += text.substring(start2, pos);
            contents += scanEscapeSequence(isTaggedTemplate);
            start2 = pos;
            continue;
          }
          if (currChar === 13) {
            contents += text.substring(start2, pos);
            pos++;
            if (pos < end && text.charCodeAt(pos) === 10) {
              pos++;
            }
            contents += "\n";
            start2 = pos;
            continue;
          }
          pos++;
        }
        ts2.Debug.assert(resultingToken !== void 0);
        tokenValue = contents;
        return resultingToken;
      }
      function scanEscapeSequence(isTaggedTemplate) {
        var start2 = pos;
        pos++;
        if (pos >= end) {
          error(ts2.Diagnostics.Unexpected_end_of_text);
          return "";
        }
        var ch = text.charCodeAt(pos);
        pos++;
        switch (ch) {
          case 48:
            if (isTaggedTemplate && pos < end && isDigit(text.charCodeAt(pos))) {
              pos++;
              tokenFlags |= 2048;
              return text.substring(start2, pos);
            }
            return "\0";
          case 98:
            return "\b";
          case 116:
            return "	";
          case 110:
            return "\n";
          case 118:
            return "\v";
          case 102:
            return "\f";
          case 114:
            return "\r";
          case 39:
            return "'";
          case 34:
            return '"';
          case 117:
            if (isTaggedTemplate) {
              for (var escapePos = pos; escapePos < pos + 4; escapePos++) {
                if (escapePos < end && !isHexDigit(text.charCodeAt(escapePos)) && text.charCodeAt(escapePos) !== 123) {
                  pos = escapePos;
                  tokenFlags |= 2048;
                  return text.substring(start2, pos);
                }
              }
            }
            if (pos < end && text.charCodeAt(pos) === 123) {
              pos++;
              if (isTaggedTemplate && !isHexDigit(text.charCodeAt(pos))) {
                tokenFlags |= 2048;
                return text.substring(start2, pos);
              }
              if (isTaggedTemplate) {
                var savePos = pos;
                var escapedValueString = scanMinimumNumberOfHexDigits(1, false);
                var escapedValue = escapedValueString ? parseInt(escapedValueString, 16) : -1;
                if (!isCodePoint(escapedValue) || text.charCodeAt(pos) !== 125) {
                  tokenFlags |= 2048;
                  return text.substring(start2, pos);
                } else {
                  pos = savePos;
                }
              }
              tokenFlags |= 8;
              return scanExtendedUnicodeEscape();
            }
            tokenFlags |= 1024;
            return scanHexadecimalEscape(4);
          case 120:
            if (isTaggedTemplate) {
              if (!isHexDigit(text.charCodeAt(pos))) {
                tokenFlags |= 2048;
                return text.substring(start2, pos);
              } else if (!isHexDigit(text.charCodeAt(pos + 1))) {
                pos++;
                tokenFlags |= 2048;
                return text.substring(start2, pos);
              }
            }
            return scanHexadecimalEscape(2);
          case 13:
            if (pos < end && text.charCodeAt(pos) === 10) {
              pos++;
            }
          case 10:
          case 8232:
          case 8233:
            return "";
          default:
            return String.fromCharCode(ch);
        }
      }
      function scanHexadecimalEscape(numDigits) {
        var escapedValue = scanExactNumberOfHexDigits(numDigits, false);
        if (escapedValue >= 0) {
          return String.fromCharCode(escapedValue);
        } else {
          error(ts2.Diagnostics.Hexadecimal_digit_expected);
          return "";
        }
      }
      function scanExtendedUnicodeEscape() {
        var escapedValueString = scanMinimumNumberOfHexDigits(1, false);
        var escapedValue = escapedValueString ? parseInt(escapedValueString, 16) : -1;
        var isInvalidExtendedEscape = false;
        if (escapedValue < 0) {
          error(ts2.Diagnostics.Hexadecimal_digit_expected);
          isInvalidExtendedEscape = true;
        } else if (escapedValue > 1114111) {
          error(ts2.Diagnostics.An_extended_Unicode_escape_value_must_be_between_0x0_and_0x10FFFF_inclusive);
          isInvalidExtendedEscape = true;
        }
        if (pos >= end) {
          error(ts2.Diagnostics.Unexpected_end_of_text);
          isInvalidExtendedEscape = true;
        } else if (text.charCodeAt(pos) === 125) {
          pos++;
        } else {
          error(ts2.Diagnostics.Unterminated_Unicode_escape_sequence);
          isInvalidExtendedEscape = true;
        }
        if (isInvalidExtendedEscape) {
          return "";
        }
        return utf16EncodeAsString(escapedValue);
      }
      function peekUnicodeEscape() {
        if (pos + 5 < end && text.charCodeAt(pos + 1) === 117) {
          var start_1 = pos;
          pos += 2;
          var value = scanExactNumberOfHexDigits(4, false);
          pos = start_1;
          return value;
        }
        return -1;
      }
      function peekExtendedUnicodeEscape() {
        if (languageVersion >= 2 && codePointAt(text, pos + 1) === 117 && codePointAt(text, pos + 2) === 123) {
          var start_2 = pos;
          pos += 3;
          var escapedValueString = scanMinimumNumberOfHexDigits(1, false);
          var escapedValue = escapedValueString ? parseInt(escapedValueString, 16) : -1;
          pos = start_2;
          return escapedValue;
        }
        return -1;
      }
      function scanIdentifierParts() {
        var result = "";
        var start2 = pos;
        while (pos < end) {
          var ch = codePointAt(text, pos);
          if (isIdentifierPart(ch, languageVersion)) {
            pos += charSize(ch);
          } else if (ch === 92) {
            ch = peekExtendedUnicodeEscape();
            if (ch >= 0 && isIdentifierPart(ch, languageVersion)) {
              pos += 3;
              tokenFlags |= 8;
              result += scanExtendedUnicodeEscape();
              start2 = pos;
              continue;
            }
            ch = peekUnicodeEscape();
            if (!(ch >= 0 && isIdentifierPart(ch, languageVersion))) {
              break;
            }
            tokenFlags |= 1024;
            result += text.substring(start2, pos);
            result += utf16EncodeAsString(ch);
            pos += 6;
            start2 = pos;
          } else {
            break;
          }
        }
        result += text.substring(start2, pos);
        return result;
      }
      function getIdentifierToken() {
        var len = tokenValue.length;
        if (len >= 2 && len <= 12) {
          var ch = tokenValue.charCodeAt(0);
          if (ch >= 97 && ch <= 122) {
            var keyword = textToKeyword.get(tokenValue);
            if (keyword !== void 0) {
              return token = keyword;
            }
          }
        }
        return token = 79;
      }
      function scanBinaryOrOctalDigits(base) {
        var value = "";
        var separatorAllowed = false;
        var isPreviousTokenSeparator = false;
        while (true) {
          var ch = text.charCodeAt(pos);
          if (ch === 95) {
            tokenFlags |= 512;
            if (separatorAllowed) {
              separatorAllowed = false;
              isPreviousTokenSeparator = true;
            } else if (isPreviousTokenSeparator) {
              error(ts2.Diagnostics.Multiple_consecutive_numeric_separators_are_not_permitted, pos, 1);
            } else {
              error(ts2.Diagnostics.Numeric_separators_are_not_allowed_here, pos, 1);
            }
            pos++;
            continue;
          }
          separatorAllowed = true;
          if (!isDigit(ch) || ch - 48 >= base) {
            break;
          }
          value += text[pos];
          pos++;
          isPreviousTokenSeparator = false;
        }
        if (text.charCodeAt(pos - 1) === 95) {
          error(ts2.Diagnostics.Numeric_separators_are_not_allowed_here, pos - 1, 1);
        }
        return value;
      }
      function checkBigIntSuffix() {
        if (text.charCodeAt(pos) === 110) {
          tokenValue += "n";
          if (tokenFlags & 384) {
            tokenValue = ts2.parsePseudoBigInt(tokenValue) + "n";
          }
          pos++;
          return 9;
        } else {
          var numericValue = tokenFlags & 128 ? parseInt(tokenValue.slice(2), 2) : tokenFlags & 256 ? parseInt(tokenValue.slice(2), 8) : +tokenValue;
          tokenValue = "" + numericValue;
          return 8;
        }
      }
      function scan() {
        var _a2;
        startPos = pos;
        tokenFlags = 0;
        var asteriskSeen = false;
        while (true) {
          tokenPos = pos;
          if (pos >= end) {
            return token = 1;
          }
          var ch = codePointAt(text, pos);
          if (ch === 35 && pos === 0 && isShebangTrivia(text, pos)) {
            pos = scanShebangTrivia(text, pos);
            if (skipTrivia2) {
              continue;
            } else {
              return token = 6;
            }
          }
          switch (ch) {
            case 10:
            case 13:
              tokenFlags |= 1;
              if (skipTrivia2) {
                pos++;
                continue;
              } else {
                if (ch === 13 && pos + 1 < end && text.charCodeAt(pos + 1) === 10) {
                  pos += 2;
                } else {
                  pos++;
                }
                return token = 4;
              }
            case 9:
            case 11:
            case 12:
            case 32:
            case 160:
            case 5760:
            case 8192:
            case 8193:
            case 8194:
            case 8195:
            case 8196:
            case 8197:
            case 8198:
            case 8199:
            case 8200:
            case 8201:
            case 8202:
            case 8203:
            case 8239:
            case 8287:
            case 12288:
            case 65279:
              if (skipTrivia2) {
                pos++;
                continue;
              } else {
                while (pos < end && isWhiteSpaceSingleLine(text.charCodeAt(pos))) {
                  pos++;
                }
                return token = 5;
              }
            case 33:
              if (text.charCodeAt(pos + 1) === 61) {
                if (text.charCodeAt(pos + 2) === 61) {
                  return pos += 3, token = 37;
                }
                return pos += 2, token = 35;
              }
              pos++;
              return token = 53;
            case 34:
            case 39:
              tokenValue = scanString();
              return token = 10;
            case 96:
              return token = scanTemplateAndSetTokenValue(false);
            case 37:
              if (text.charCodeAt(pos + 1) === 61) {
                return pos += 2, token = 69;
              }
              pos++;
              return token = 44;
            case 38:
              if (text.charCodeAt(pos + 1) === 38) {
                if (text.charCodeAt(pos + 2) === 61) {
                  return pos += 3, token = 76;
                }
                return pos += 2, token = 55;
              }
              if (text.charCodeAt(pos + 1) === 61) {
                return pos += 2, token = 73;
              }
              pos++;
              return token = 50;
            case 40:
              pos++;
              return token = 20;
            case 41:
              pos++;
              return token = 21;
            case 42:
              if (text.charCodeAt(pos + 1) === 61) {
                return pos += 2, token = 66;
              }
              if (text.charCodeAt(pos + 1) === 42) {
                if (text.charCodeAt(pos + 2) === 61) {
                  return pos += 3, token = 67;
                }
                return pos += 2, token = 42;
              }
              pos++;
              if (inJSDocType && !asteriskSeen && tokenFlags & 1) {
                asteriskSeen = true;
                continue;
              }
              return token = 41;
            case 43:
              if (text.charCodeAt(pos + 1) === 43) {
                return pos += 2, token = 45;
              }
              if (text.charCodeAt(pos + 1) === 61) {
                return pos += 2, token = 64;
              }
              pos++;
              return token = 39;
            case 44:
              pos++;
              return token = 27;
            case 45:
              if (text.charCodeAt(pos + 1) === 45) {
                return pos += 2, token = 46;
              }
              if (text.charCodeAt(pos + 1) === 61) {
                return pos += 2, token = 65;
              }
              pos++;
              return token = 40;
            case 46:
              if (isDigit(text.charCodeAt(pos + 1))) {
                tokenValue = scanNumber().value;
                return token = 8;
              }
              if (text.charCodeAt(pos + 1) === 46 && text.charCodeAt(pos + 2) === 46) {
                return pos += 3, token = 25;
              }
              pos++;
              return token = 24;
            case 47:
              if (text.charCodeAt(pos + 1) === 47) {
                pos += 2;
                while (pos < end) {
                  if (isLineBreak(text.charCodeAt(pos))) {
                    break;
                  }
                  pos++;
                }
                commentDirectives = appendIfCommentDirective(commentDirectives, text.slice(tokenPos, pos), commentDirectiveRegExSingleLine, tokenPos);
                if (skipTrivia2) {
                  continue;
                } else {
                  return token = 2;
                }
              }
              if (text.charCodeAt(pos + 1) === 42) {
                pos += 2;
                if (text.charCodeAt(pos) === 42 && text.charCodeAt(pos + 1) !== 47) {
                  tokenFlags |= 2;
                }
                var commentClosed = false;
                var lastLineStart = tokenPos;
                while (pos < end) {
                  var ch_1 = text.charCodeAt(pos);
                  if (ch_1 === 42 && text.charCodeAt(pos + 1) === 47) {
                    pos += 2;
                    commentClosed = true;
                    break;
                  }
                  pos++;
                  if (isLineBreak(ch_1)) {
                    lastLineStart = pos;
                    tokenFlags |= 1;
                  }
                }
                commentDirectives = appendIfCommentDirective(commentDirectives, text.slice(lastLineStart, pos), commentDirectiveRegExMultiLine, lastLineStart);
                if (!commentClosed) {
                  error(ts2.Diagnostics.Asterisk_Slash_expected);
                }
                if (skipTrivia2) {
                  continue;
                } else {
                  if (!commentClosed) {
                    tokenFlags |= 4;
                  }
                  return token = 3;
                }
              }
              if (text.charCodeAt(pos + 1) === 61) {
                return pos += 2, token = 68;
              }
              pos++;
              return token = 43;
            case 48:
              if (pos + 2 < end && (text.charCodeAt(pos + 1) === 88 || text.charCodeAt(pos + 1) === 120)) {
                pos += 2;
                tokenValue = scanMinimumNumberOfHexDigits(1, true);
                if (!tokenValue) {
                  error(ts2.Diagnostics.Hexadecimal_digit_expected);
                  tokenValue = "0";
                }
                tokenValue = "0x" + tokenValue;
                tokenFlags |= 64;
                return token = checkBigIntSuffix();
              } else if (pos + 2 < end && (text.charCodeAt(pos + 1) === 66 || text.charCodeAt(pos + 1) === 98)) {
                pos += 2;
                tokenValue = scanBinaryOrOctalDigits(2);
                if (!tokenValue) {
                  error(ts2.Diagnostics.Binary_digit_expected);
                  tokenValue = "0";
                }
                tokenValue = "0b" + tokenValue;
                tokenFlags |= 128;
                return token = checkBigIntSuffix();
              } else if (pos + 2 < end && (text.charCodeAt(pos + 1) === 79 || text.charCodeAt(pos + 1) === 111)) {
                pos += 2;
                tokenValue = scanBinaryOrOctalDigits(8);
                if (!tokenValue) {
                  error(ts2.Diagnostics.Octal_digit_expected);
                  tokenValue = "0";
                }
                tokenValue = "0o" + tokenValue;
                tokenFlags |= 256;
                return token = checkBigIntSuffix();
              }
              if (pos + 1 < end && isOctalDigit(text.charCodeAt(pos + 1))) {
                tokenValue = "" + scanOctalDigits();
                tokenFlags |= 32;
                return token = 8;
              }
            case 49:
            case 50:
            case 51:
            case 52:
            case 53:
            case 54:
            case 55:
            case 56:
            case 57:
              _a2 = scanNumber(), token = _a2.type, tokenValue = _a2.value;
              return token;
            case 58:
              pos++;
              return token = 58;
            case 59:
              pos++;
              return token = 26;
            case 60:
              if (isConflictMarkerTrivia(text, pos)) {
                pos = scanConflictMarkerTrivia(text, pos, error);
                if (skipTrivia2) {
                  continue;
                } else {
                  return token = 7;
                }
              }
              if (text.charCodeAt(pos + 1) === 60) {
                if (text.charCodeAt(pos + 2) === 61) {
                  return pos += 3, token = 70;
                }
                return pos += 2, token = 47;
              }
              if (text.charCodeAt(pos + 1) === 61) {
                return pos += 2, token = 32;
              }
              if (languageVariant === 1 && text.charCodeAt(pos + 1) === 47 && text.charCodeAt(pos + 2) !== 42) {
                return pos += 2, token = 30;
              }
              pos++;
              return token = 29;
            case 61:
              if (isConflictMarkerTrivia(text, pos)) {
                pos = scanConflictMarkerTrivia(text, pos, error);
                if (skipTrivia2) {
                  continue;
                } else {
                  return token = 7;
                }
              }
              if (text.charCodeAt(pos + 1) === 61) {
                if (text.charCodeAt(pos + 2) === 61) {
                  return pos += 3, token = 36;
                }
                return pos += 2, token = 34;
              }
              if (text.charCodeAt(pos + 1) === 62) {
                return pos += 2, token = 38;
              }
              pos++;
              return token = 63;
            case 62:
              if (isConflictMarkerTrivia(text, pos)) {
                pos = scanConflictMarkerTrivia(text, pos, error);
                if (skipTrivia2) {
                  continue;
                } else {
                  return token = 7;
                }
              }
              pos++;
              return token = 31;
            case 63:
              if (text.charCodeAt(pos + 1) === 46 && !isDigit(text.charCodeAt(pos + 2))) {
                return pos += 2, token = 28;
              }
              if (text.charCodeAt(pos + 1) === 63) {
                if (text.charCodeAt(pos + 2) === 61) {
                  return pos += 3, token = 77;
                }
                return pos += 2, token = 60;
              }
              pos++;
              return token = 57;
            case 91:
              pos++;
              return token = 22;
            case 93:
              pos++;
              return token = 23;
            case 94:
              if (text.charCodeAt(pos + 1) === 61) {
                return pos += 2, token = 78;
              }
              pos++;
              return token = 52;
            case 123:
              pos++;
              return token = 18;
            case 124:
              if (isConflictMarkerTrivia(text, pos)) {
                pos = scanConflictMarkerTrivia(text, pos, error);
                if (skipTrivia2) {
                  continue;
                } else {
                  return token = 7;
                }
              }
              if (text.charCodeAt(pos + 1) === 124) {
                if (text.charCodeAt(pos + 2) === 61) {
                  return pos += 3, token = 75;
                }
                return pos += 2, token = 56;
              }
              if (text.charCodeAt(pos + 1) === 61) {
                return pos += 2, token = 74;
              }
              pos++;
              return token = 51;
            case 125:
              pos++;
              return token = 19;
            case 126:
              pos++;
              return token = 54;
            case 64:
              pos++;
              return token = 59;
            case 92:
              var extendedCookedChar = peekExtendedUnicodeEscape();
              if (extendedCookedChar >= 0 && isIdentifierStart(extendedCookedChar, languageVersion)) {
                pos += 3;
                tokenFlags |= 8;
                tokenValue = scanExtendedUnicodeEscape() + scanIdentifierParts();
                return token = getIdentifierToken();
              }
              var cookedChar = peekUnicodeEscape();
              if (cookedChar >= 0 && isIdentifierStart(cookedChar, languageVersion)) {
                pos += 6;
                tokenFlags |= 1024;
                tokenValue = String.fromCharCode(cookedChar) + scanIdentifierParts();
                return token = getIdentifierToken();
              }
              error(ts2.Diagnostics.Invalid_character);
              pos++;
              return token = 0;
            case 35:
              if (pos !== 0 && text[pos + 1] === "!") {
                error(ts2.Diagnostics.can_only_be_used_at_the_start_of_a_file);
                pos++;
                return token = 0;
              }
              if (isIdentifierStart(codePointAt(text, pos + 1), languageVersion)) {
                pos++;
                scanIdentifier(codePointAt(text, pos), languageVersion);
              } else {
                tokenValue = String.fromCharCode(codePointAt(text, pos));
                error(ts2.Diagnostics.Invalid_character, pos++, charSize(ch));
              }
              return token = 80;
            default:
              var identifierKind = scanIdentifier(ch, languageVersion);
              if (identifierKind) {
                return token = identifierKind;
              } else if (isWhiteSpaceSingleLine(ch)) {
                pos += charSize(ch);
                continue;
              } else if (isLineBreak(ch)) {
                tokenFlags |= 1;
                pos += charSize(ch);
                continue;
              }
              var size = charSize(ch);
              error(ts2.Diagnostics.Invalid_character, pos, size);
              pos += size;
              return token = 0;
          }
        }
      }
      function reScanInvalidIdentifier() {
        ts2.Debug.assert(token === 0, "'reScanInvalidIdentifier' should only be called when the current token is 'SyntaxKind.Unknown'.");
        pos = tokenPos = startPos;
        tokenFlags = 0;
        var ch = codePointAt(text, pos);
        var identifierKind = scanIdentifier(ch, 99);
        if (identifierKind) {
          return token = identifierKind;
        }
        pos += charSize(ch);
        return token;
      }
      function scanIdentifier(startCharacter, languageVersion2) {
        var ch = startCharacter;
        if (isIdentifierStart(ch, languageVersion2)) {
          pos += charSize(ch);
          while (pos < end && isIdentifierPart(ch = codePointAt(text, pos), languageVersion2))
            pos += charSize(ch);
          tokenValue = text.substring(tokenPos, pos);
          if (ch === 92) {
            tokenValue += scanIdentifierParts();
          }
          return getIdentifierToken();
        }
      }
      function reScanGreaterToken() {
        if (token === 31) {
          if (text.charCodeAt(pos) === 62) {
            if (text.charCodeAt(pos + 1) === 62) {
              if (text.charCodeAt(pos + 2) === 61) {
                return pos += 3, token = 72;
              }
              return pos += 2, token = 49;
            }
            if (text.charCodeAt(pos + 1) === 61) {
              return pos += 2, token = 71;
            }
            pos++;
            return token = 48;
          }
          if (text.charCodeAt(pos) === 61) {
            pos++;
            return token = 33;
          }
        }
        return token;
      }
      function reScanAsteriskEqualsToken() {
        ts2.Debug.assert(token === 66, "'reScanAsteriskEqualsToken' should only be called on a '*='");
        pos = tokenPos + 1;
        return token = 63;
      }
      function reScanSlashToken() {
        if (token === 43 || token === 68) {
          var p = tokenPos + 1;
          var inEscape = false;
          var inCharacterClass = false;
          while (true) {
            if (p >= end) {
              tokenFlags |= 4;
              error(ts2.Diagnostics.Unterminated_regular_expression_literal);
              break;
            }
            var ch = text.charCodeAt(p);
            if (isLineBreak(ch)) {
              tokenFlags |= 4;
              error(ts2.Diagnostics.Unterminated_regular_expression_literal);
              break;
            }
            if (inEscape) {
              inEscape = false;
            } else if (ch === 47 && !inCharacterClass) {
              p++;
              break;
            } else if (ch === 91) {
              inCharacterClass = true;
            } else if (ch === 92) {
              inEscape = true;
            } else if (ch === 93) {
              inCharacterClass = false;
            }
            p++;
          }
          while (p < end && isIdentifierPart(text.charCodeAt(p), languageVersion)) {
            p++;
          }
          pos = p;
          tokenValue = text.substring(tokenPos, pos);
          token = 13;
        }
        return token;
      }
      function appendIfCommentDirective(commentDirectives2, text2, commentDirectiveRegEx, lineStart) {
        var type = getDirectiveFromComment(ts2.trimStringStart(text2), commentDirectiveRegEx);
        if (type === void 0) {
          return commentDirectives2;
        }
        return ts2.append(commentDirectives2, {
          range: { pos: lineStart, end: pos },
          type
        });
      }
      function getDirectiveFromComment(text2, commentDirectiveRegEx) {
        var match = commentDirectiveRegEx.exec(text2);
        if (!match) {
          return void 0;
        }
        switch (match[1]) {
          case "ts-expect-error":
            return 0;
          case "ts-ignore":
            return 1;
        }
        return void 0;
      }
      function reScanTemplateToken(isTaggedTemplate) {
        ts2.Debug.assert(token === 19, "'reScanTemplateToken' should only be called on a '}'");
        pos = tokenPos;
        return token = scanTemplateAndSetTokenValue(isTaggedTemplate);
      }
      function reScanTemplateHeadOrNoSubstitutionTemplate() {
        pos = tokenPos;
        return token = scanTemplateAndSetTokenValue(true);
      }
      function reScanJsxToken(allowMultilineJsxText) {
        if (allowMultilineJsxText === void 0) {
          allowMultilineJsxText = true;
        }
        pos = tokenPos = startPos;
        return token = scanJsxToken(allowMultilineJsxText);
      }
      function reScanLessThanToken() {
        if (token === 47) {
          pos = tokenPos + 1;
          return token = 29;
        }
        return token;
      }
      function reScanHashToken() {
        if (token === 80) {
          pos = tokenPos + 1;
          return token = 62;
        }
        return token;
      }
      function reScanQuestionToken() {
        ts2.Debug.assert(token === 60, "'reScanQuestionToken' should only be called on a '??'");
        pos = tokenPos + 1;
        return token = 57;
      }
      function scanJsxToken(allowMultilineJsxText) {
        if (allowMultilineJsxText === void 0) {
          allowMultilineJsxText = true;
        }
        startPos = tokenPos = pos;
        if (pos >= end) {
          return token = 1;
        }
        var char = text.charCodeAt(pos);
        if (char === 60) {
          if (text.charCodeAt(pos + 1) === 47) {
            pos += 2;
            return token = 30;
          }
          pos++;
          return token = 29;
        }
        if (char === 123) {
          pos++;
          return token = 18;
        }
        var firstNonWhitespace = 0;
        while (pos < end) {
          char = text.charCodeAt(pos);
          if (char === 123) {
            break;
          }
          if (char === 60) {
            if (isConflictMarkerTrivia(text, pos)) {
              pos = scanConflictMarkerTrivia(text, pos, error);
              return token = 7;
            }
            break;
          }
          if (char === 62) {
            error(ts2.Diagnostics.Unexpected_token_Did_you_mean_or_gt, pos, 1);
          }
          if (char === 125) {
            error(ts2.Diagnostics.Unexpected_token_Did_you_mean_or_rbrace, pos, 1);
          }
          if (isLineBreak(char) && firstNonWhitespace === 0) {
            firstNonWhitespace = -1;
          } else if (!allowMultilineJsxText && isLineBreak(char) && firstNonWhitespace > 0) {
            break;
          } else if (!isWhiteSpaceLike(char)) {
            firstNonWhitespace = pos;
          }
          pos++;
        }
        tokenValue = text.substring(startPos, pos);
        return firstNonWhitespace === -1 ? 12 : 11;
      }
      function scanJsxIdentifier() {
        if (tokenIsIdentifierOrKeyword(token)) {
          var namespaceSeparator = false;
          while (pos < end) {
            var ch = text.charCodeAt(pos);
            if (ch === 45) {
              tokenValue += "-";
              pos++;
              continue;
            } else if (ch === 58 && !namespaceSeparator) {
              tokenValue += ":";
              pos++;
              namespaceSeparator = true;
              token = 79;
              continue;
            }
            var oldPos = pos;
            tokenValue += scanIdentifierParts();
            if (pos === oldPos) {
              break;
            }
          }
          if (tokenValue.slice(-1) === ":") {
            tokenValue = tokenValue.slice(0, -1);
            pos--;
          }
        }
        return token;
      }
      function scanJsxAttributeValue() {
        startPos = pos;
        switch (text.charCodeAt(pos)) {
          case 34:
          case 39:
            tokenValue = scanString(true);
            return token = 10;
          default:
            return scan();
        }
      }
      function reScanJsxAttributeValue() {
        pos = tokenPos = startPos;
        return scanJsxAttributeValue();
      }
      function scanJsDocToken() {
        startPos = tokenPos = pos;
        tokenFlags = 0;
        if (pos >= end) {
          return token = 1;
        }
        var ch = codePointAt(text, pos);
        pos += charSize(ch);
        switch (ch) {
          case 9:
          case 11:
          case 12:
          case 32:
            while (pos < end && isWhiteSpaceSingleLine(text.charCodeAt(pos))) {
              pos++;
            }
            return token = 5;
          case 64:
            return token = 59;
          case 13:
            if (text.charCodeAt(pos) === 10) {
              pos++;
            }
          case 10:
            tokenFlags |= 1;
            return token = 4;
          case 42:
            return token = 41;
          case 123:
            return token = 18;
          case 125:
            return token = 19;
          case 91:
            return token = 22;
          case 93:
            return token = 23;
          case 60:
            return token = 29;
          case 62:
            return token = 31;
          case 61:
            return token = 63;
          case 44:
            return token = 27;
          case 46:
            return token = 24;
          case 96:
            return token = 61;
          case 35:
            return token = 62;
          case 92:
            pos--;
            var extendedCookedChar = peekExtendedUnicodeEscape();
            if (extendedCookedChar >= 0 && isIdentifierStart(extendedCookedChar, languageVersion)) {
              pos += 3;
              tokenFlags |= 8;
              tokenValue = scanExtendedUnicodeEscape() + scanIdentifierParts();
              return token = getIdentifierToken();
            }
            var cookedChar = peekUnicodeEscape();
            if (cookedChar >= 0 && isIdentifierStart(cookedChar, languageVersion)) {
              pos += 6;
              tokenFlags |= 1024;
              tokenValue = String.fromCharCode(cookedChar) + scanIdentifierParts();
              return token = getIdentifierToken();
            }
            pos++;
            return token = 0;
        }
        if (isIdentifierStart(ch, languageVersion)) {
          var char = ch;
          while (pos < end && isIdentifierPart(char = codePointAt(text, pos), languageVersion) || text.charCodeAt(pos) === 45)
            pos += charSize(char);
          tokenValue = text.substring(tokenPos, pos);
          if (char === 92) {
            tokenValue += scanIdentifierParts();
          }
          return token = getIdentifierToken();
        } else {
          return token = 0;
        }
      }
      function speculationHelper(callback, isLookahead) {
        var savePos = pos;
        var saveStartPos = startPos;
        var saveTokenPos = tokenPos;
        var saveToken = token;
        var saveTokenValue = tokenValue;
        var saveTokenFlags = tokenFlags;
        var result = callback();
        if (!result || isLookahead) {
          pos = savePos;
          startPos = saveStartPos;
          tokenPos = saveTokenPos;
          token = saveToken;
          tokenValue = saveTokenValue;
          tokenFlags = saveTokenFlags;
        }
        return result;
      }
      function scanRange(start2, length2, callback) {
        var saveEnd = end;
        var savePos = pos;
        var saveStartPos = startPos;
        var saveTokenPos = tokenPos;
        var saveToken = token;
        var saveTokenValue = tokenValue;
        var saveTokenFlags = tokenFlags;
        var saveErrorExpectations = commentDirectives;
        setText(text, start2, length2);
        var result = callback();
        end = saveEnd;
        pos = savePos;
        startPos = saveStartPos;
        tokenPos = saveTokenPos;
        token = saveToken;
        tokenValue = saveTokenValue;
        tokenFlags = saveTokenFlags;
        commentDirectives = saveErrorExpectations;
        return result;
      }
      function lookAhead(callback) {
        return speculationHelper(callback, true);
      }
      function tryScan(callback) {
        return speculationHelper(callback, false);
      }
      function getText() {
        return text;
      }
      function clearCommentDirectives() {
        commentDirectives = void 0;
      }
      function setText(newText, start2, length2) {
        text = newText || "";
        end = length2 === void 0 ? text.length : start2 + length2;
        setTextPos(start2 || 0);
      }
      function setOnError(errorCallback) {
        onError = errorCallback;
      }
      function setScriptTarget(scriptTarget) {
        languageVersion = scriptTarget;
      }
      function setLanguageVariant(variant) {
        languageVariant = variant;
      }
      function setTextPos(textPos) {
        ts2.Debug.assert(textPos >= 0);
        pos = textPos;
        startPos = textPos;
        tokenPos = textPos;
        token = 0;
        tokenValue = void 0;
        tokenFlags = 0;
      }
      function setInJSDocType(inType) {
        inJSDocType += inType ? 1 : -1;
      }
    }
    ts2.createScanner = createScanner;
    var codePointAt = String.prototype.codePointAt ? function(s, i) {
      return s.codePointAt(i);
    } : function codePointAt2(str, i) {
      var size = str.length;
      if (i < 0 || i >= size) {
        return void 0;
      }
      var first = str.charCodeAt(i);
      if (first >= 55296 && first <= 56319 && size > i + 1) {
        var second = str.charCodeAt(i + 1);
        if (second >= 56320 && second <= 57343) {
          return (first - 55296) * 1024 + second - 56320 + 65536;
        }
      }
      return first;
    };
    function charSize(ch) {
      if (ch >= 65536) {
        return 2;
      }
      return 1;
    }
    function utf16EncodeAsStringFallback(codePoint) {
      ts2.Debug.assert(0 <= codePoint && codePoint <= 1114111);
      if (codePoint <= 65535) {
        return String.fromCharCode(codePoint);
      }
      var codeUnit1 = Math.floor((codePoint - 65536) / 1024) + 55296;
      var codeUnit2 = (codePoint - 65536) % 1024 + 56320;
      return String.fromCharCode(codeUnit1, codeUnit2);
    }
    var utf16EncodeAsStringWorker = String.fromCodePoint ? function(codePoint) {
      return String.fromCodePoint(codePoint);
    } : utf16EncodeAsStringFallback;
    function utf16EncodeAsString(codePoint) {
      return utf16EncodeAsStringWorker(codePoint);
    }
    ts2.utf16EncodeAsString = utf16EncodeAsString;
  })(ts || (ts = {}));
  var ts;
  (function(ts2) {
    function isExternalModuleNameRelative(moduleName) {
      return ts2.pathIsRelative(moduleName) || ts2.isRootedDiskPath(moduleName);
    }
    ts2.isExternalModuleNameRelative = isExternalModuleNameRelative;
    function sortAndDeduplicateDiagnostics(diagnostics) {
      return ts2.sortAndDeduplicate(diagnostics, ts2.compareDiagnostics);
    }
    ts2.sortAndDeduplicateDiagnostics = sortAndDeduplicateDiagnostics;
    function getDefaultLibFileName(options) {
      switch (options.target) {
        case 99:
          return "lib.esnext.full.d.ts";
        case 8:
          return "lib.es2021.full.d.ts";
        case 7:
          return "lib.es2020.full.d.ts";
        case 6:
          return "lib.es2019.full.d.ts";
        case 5:
          return "lib.es2018.full.d.ts";
        case 4:
          return "lib.es2017.full.d.ts";
        case 3:
          return "lib.es2016.full.d.ts";
        case 2:
          return "lib.es6.d.ts";
        default:
          return "lib.d.ts";
      }
    }
    ts2.getDefaultLibFileName = getDefaultLibFileName;
    function textSpanEnd(span) {
      return span.start + span.length;
    }
    ts2.textSpanEnd = textSpanEnd;
    function textSpanIsEmpty(span) {
      return span.length === 0;
    }
    ts2.textSpanIsEmpty = textSpanIsEmpty;
    function textSpanContainsPosition(span, position) {
      return position >= span.start && position < textSpanEnd(span);
    }
    ts2.textSpanContainsPosition = textSpanContainsPosition;
    function textRangeContainsPositionInclusive(span, position) {
      return position >= span.pos && position <= span.end;
    }
    ts2.textRangeContainsPositionInclusive = textRangeContainsPositionInclusive;
    function textSpanContainsTextSpan(span, other) {
      return other.start >= span.start && textSpanEnd(other) <= textSpanEnd(span);
    }
    ts2.textSpanContainsTextSpan = textSpanContainsTextSpan;
    function textSpanOverlapsWith(span, other) {
      return textSpanOverlap(span, other) !== void 0;
    }
    ts2.textSpanOverlapsWith = textSpanOverlapsWith;
    function textSpanOverlap(span1, span2) {
      var overlap = textSpanIntersection(span1, span2);
      return overlap && overlap.length === 0 ? void 0 : overlap;
    }
    ts2.textSpanOverlap = textSpanOverlap;
    function textSpanIntersectsWithTextSpan(span, other) {
      return decodedTextSpanIntersectsWith(span.start, span.length, other.start, other.length);
    }
    ts2.textSpanIntersectsWithTextSpan = textSpanIntersectsWithTextSpan;
    function textSpanIntersectsWith(span, start, length) {
      return decodedTextSpanIntersectsWith(span.start, span.length, start, length);
    }
    ts2.textSpanIntersectsWith = textSpanIntersectsWith;
    function decodedTextSpanIntersectsWith(start1, length1, start2, length2) {
      var end1 = start1 + length1;
      var end2 = start2 + length2;
      return start2 <= end1 && end2 >= start1;
    }
    ts2.decodedTextSpanIntersectsWith = decodedTextSpanIntersectsWith;
    function textSpanIntersectsWithPosition(span, position) {
      return position <= textSpanEnd(span) && position >= span.start;
    }
    ts2.textSpanIntersectsWithPosition = textSpanIntersectsWithPosition;
    function textSpanIntersection(span1, span2) {
      var start = Math.max(span1.start, span2.start);
      var end = Math.min(textSpanEnd(span1), textSpanEnd(span2));
      return start <= end ? createTextSpanFromBounds(start, end) : void 0;
    }
    ts2.textSpanIntersection = textSpanIntersection;
    function createTextSpan(start, length) {
      if (start < 0) {
        throw new Error("start < 0");
      }
      if (length < 0) {
        throw new Error("length < 0");
      }
      return { start, length };
    }
    ts2.createTextSpan = createTextSpan;
    function createTextSpanFromBounds(start, end) {
      return createTextSpan(start, end - start);
    }
    ts2.createTextSpanFromBounds = createTextSpanFromBounds;
    function textChangeRangeNewSpan(range) {
      return createTextSpan(range.span.start, range.newLength);
    }
    ts2.textChangeRangeNewSpan = textChangeRangeNewSpan;
    function textChangeRangeIsUnchanged(range) {
      return textSpanIsEmpty(range.span) && range.newLength === 0;
    }
    ts2.textChangeRangeIsUnchanged = textChangeRangeIsUnchanged;
    function createTextChangeRange(span, newLength) {
      if (newLength < 0) {
        throw new Error("newLength < 0");
      }
      return { span, newLength };
    }
    ts2.createTextChangeRange = createTextChangeRange;
    ts2.unchangedTextChangeRange = createTextChangeRange(createTextSpan(0, 0), 0);
    function collapseTextChangeRangesAcrossMultipleVersions(changes) {
      if (changes.length === 0) {
        return ts2.unchangedTextChangeRange;
      }
      if (changes.length === 1) {
        return changes[0];
      }
      var change0 = changes[0];
      var oldStartN = change0.span.start;
      var oldEndN = textSpanEnd(change0.span);
      var newEndN = oldStartN + change0.newLength;
      for (var i = 1; i < changes.length; i++) {
        var nextChange = changes[i];
        var oldStart1 = oldStartN;
        var oldEnd1 = oldEndN;
        var newEnd1 = newEndN;
        var oldStart2 = nextChange.span.start;
        var oldEnd2 = textSpanEnd(nextChange.span);
        var newEnd2 = oldStart2 + nextChange.newLength;
        oldStartN = Math.min(oldStart1, oldStart2);
        oldEndN = Math.max(oldEnd1, oldEnd1 + (oldEnd2 - newEnd1));
        newEndN = Math.max(newEnd2, newEnd2 + (newEnd1 - oldEnd2));
      }
      return createTextChangeRange(createTextSpanFromBounds(oldStartN, oldEndN), newEndN - oldStartN);
    }
    ts2.collapseTextChangeRangesAcrossMultipleVersions = collapseTextChangeRangesAcrossMultipleVersions;
    function getTypeParameterOwner(d) {
      if (d && d.kind === 161) {
        for (var current = d; current; current = current.parent) {
          if (isFunctionLike(current) || isClassLike(current) || current.kind === 256) {
            return current;
          }
        }
      }
    }
    ts2.getTypeParameterOwner = getTypeParameterOwner;
    function isParameterPropertyDeclaration(node, parent) {
      return ts2.hasSyntacticModifier(node, 16476) && parent.kind === 169;
    }
    ts2.isParameterPropertyDeclaration = isParameterPropertyDeclaration;
    function isEmptyBindingPattern(node) {
      if (isBindingPattern(node)) {
        return ts2.every(node.elements, isEmptyBindingElement);
      }
      return false;
    }
    ts2.isEmptyBindingPattern = isEmptyBindingPattern;
    function isEmptyBindingElement(node) {
      if (ts2.isOmittedExpression(node)) {
        return true;
      }
      return isEmptyBindingPattern(node.name);
    }
    ts2.isEmptyBindingElement = isEmptyBindingElement;
    function walkUpBindingElementsAndPatterns(binding) {
      var node = binding.parent;
      while (ts2.isBindingElement(node.parent)) {
        node = node.parent.parent;
      }
      return node.parent;
    }
    ts2.walkUpBindingElementsAndPatterns = walkUpBindingElementsAndPatterns;
    function getCombinedFlags(node, getFlags) {
      if (ts2.isBindingElement(node)) {
        node = walkUpBindingElementsAndPatterns(node);
      }
      var flags = getFlags(node);
      if (node.kind === 252) {
        node = node.parent;
      }
      if (node && node.kind === 253) {
        flags |= getFlags(node);
        node = node.parent;
      }
      if (node && node.kind === 235) {
        flags |= getFlags(node);
      }
      return flags;
    }
    function getCombinedModifierFlags(node) {
      return getCombinedFlags(node, ts2.getEffectiveModifierFlags);
    }
    ts2.getCombinedModifierFlags = getCombinedModifierFlags;
    function getCombinedNodeFlagsAlwaysIncludeJSDoc(node) {
      return getCombinedFlags(node, ts2.getEffectiveModifierFlagsAlwaysIncludeJSDoc);
    }
    ts2.getCombinedNodeFlagsAlwaysIncludeJSDoc = getCombinedNodeFlagsAlwaysIncludeJSDoc;
    function getCombinedNodeFlags(node) {
      return getCombinedFlags(node, function(n) {
        return n.flags;
      });
    }
    ts2.getCombinedNodeFlags = getCombinedNodeFlags;
    ts2.supportedLocaleDirectories = ["cs", "de", "es", "fr", "it", "ja", "ko", "pl", "pt-br", "ru", "tr", "zh-cn", "zh-tw"];
    function validateLocaleAndSetLanguage(locale, sys, errors) {
      var lowerCaseLocale = locale.toLowerCase();
      var matchResult = /^([a-z]+)([_\-]([a-z]+))?$/.exec(lowerCaseLocale);
      if (!matchResult) {
        if (errors) {
          errors.push(ts2.createCompilerDiagnostic(ts2.Diagnostics.Locale_must_be_of_the_form_language_or_language_territory_For_example_0_or_1, "en", "ja-jp"));
        }
        return;
      }
      var language = matchResult[1];
      var territory = matchResult[3];
      if (ts2.contains(ts2.supportedLocaleDirectories, lowerCaseLocale) && !trySetLanguageAndTerritory(language, territory, errors)) {
        trySetLanguageAndTerritory(language, void 0, errors);
      }
      ts2.setUILocale(locale);
      function trySetLanguageAndTerritory(language2, territory2, errors2) {
        var compilerFilePath = ts2.normalizePath(sys.getExecutingFilePath());
        var containingDirectoryPath = ts2.getDirectoryPath(compilerFilePath);
        var filePath = ts2.combinePaths(containingDirectoryPath, language2);
        if (territory2) {
          filePath = filePath + "-" + territory2;
        }
        filePath = sys.resolvePath(ts2.combinePaths(filePath, "diagnosticMessages.generated.json"));
        if (!sys.fileExists(filePath)) {
          return false;
        }
        var fileContents = "";
        try {
          fileContents = sys.readFile(filePath);
        } catch (e) {
          if (errors2) {
            errors2.push(ts2.createCompilerDiagnostic(ts2.Diagnostics.Unable_to_open_file_0, filePath));
          }
          return false;
        }
        try {
          ts2.setLocalizedDiagnosticMessages(JSON.parse(fileContents));
        } catch (_a) {
          if (errors2) {
            errors2.push(ts2.createCompilerDiagnostic(ts2.Diagnostics.Corrupted_locale_file_0, filePath));
          }
          return false;
        }
        return true;
      }
    }
    ts2.validateLocaleAndSetLanguage = validateLocaleAndSetLanguage;
    function getOriginalNode(node, nodeTest) {
      if (node) {
        while (node.original !== void 0) {
          node = node.original;
        }
      }
      return !nodeTest || nodeTest(node) ? node : void 0;
    }
    ts2.getOriginalNode = getOriginalNode;
    function findAncestor(node, callback) {
      while (node) {
        var result = callback(node);
        if (result === "quit") {
          return void 0;
        } else if (result) {
          return node;
        }
        node = node.parent;
      }
      return void 0;
    }
    ts2.findAncestor = findAncestor;
    function isParseTreeNode(node) {
      return (node.flags & 8) === 0;
    }
    ts2.isParseTreeNode = isParseTreeNode;
    function getParseTreeNode(node, nodeTest) {
      if (node === void 0 || isParseTreeNode(node)) {
        return node;
      }
      node = node.original;
      while (node) {
        if (isParseTreeNode(node)) {
          return !nodeTest || nodeTest(node) ? node : void 0;
        }
        node = node.original;
      }
    }
    ts2.getParseTreeNode = getParseTreeNode;
    function escapeLeadingUnderscores(identifier) {
      return identifier.length >= 2 && identifier.charCodeAt(0) === 95 && identifier.charCodeAt(1) === 95 ? "_" + identifier : identifier;
    }
    ts2.escapeLeadingUnderscores = escapeLeadingUnderscores;
    function unescapeLeadingUnderscores(identifier) {
      var id = identifier;
      return id.length >= 3 && id.charCodeAt(0) === 95 && id.charCodeAt(1) === 95 && id.charCodeAt(2) === 95 ? id.substr(1) : id;
    }
    ts2.unescapeLeadingUnderscores = unescapeLeadingUnderscores;
    function idText(identifierOrPrivateName) {
      return unescapeLeadingUnderscores(identifierOrPrivateName.escapedText);
    }
    ts2.idText = idText;
    function symbolName(symbol) {
      if (symbol.valueDeclaration && isPrivateIdentifierClassElementDeclaration(symbol.valueDeclaration)) {
        return idText(symbol.valueDeclaration.name);
      }
      return unescapeLeadingUnderscores(symbol.escapedName);
    }
    ts2.symbolName = symbolName;
    function nameForNamelessJSDocTypedef(declaration) {
      var hostNode = declaration.parent.parent;
      if (!hostNode) {
        return void 0;
      }
      if (isDeclaration(hostNode)) {
        return getDeclarationIdentifier(hostNode);
      }
      switch (hostNode.kind) {
        case 235:
          if (hostNode.declarationList && hostNode.declarationList.declarations[0]) {
            return getDeclarationIdentifier(hostNode.declarationList.declarations[0]);
          }
          break;
        case 236:
          var expr = hostNode.expression;
          if (expr.kind === 219 && expr.operatorToken.kind === 63) {
            expr = expr.left;
          }
          switch (expr.kind) {
            case 204:
              return expr.name;
            case 205:
              var arg = expr.argumentExpression;
              if (ts2.isIdentifier(arg)) {
                return arg;
              }
          }
          break;
        case 210: {
          return getDeclarationIdentifier(hostNode.expression);
        }
        case 248: {
          if (isDeclaration(hostNode.statement) || isExpression(hostNode.statement)) {
            return getDeclarationIdentifier(hostNode.statement);
          }
          break;
        }
      }
    }
    function getDeclarationIdentifier(node) {
      var name = getNameOfDeclaration(node);
      return name && ts2.isIdentifier(name) ? name : void 0;
    }
    function nodeHasName(statement, name) {
      if (isNamedDeclaration(statement) && ts2.isIdentifier(statement.name) && idText(statement.name) === idText(name)) {
        return true;
      }
      if (ts2.isVariableStatement(statement) && ts2.some(statement.declarationList.declarations, function(d) {
        return nodeHasName(d, name);
      })) {
        return true;
      }
      return false;
    }
    ts2.nodeHasName = nodeHasName;
    function getNameOfJSDocTypedef(declaration) {
      return declaration.name || nameForNamelessJSDocTypedef(declaration);
    }
    ts2.getNameOfJSDocTypedef = getNameOfJSDocTypedef;
    function isNamedDeclaration(node) {
      return !!node.name;
    }
    ts2.isNamedDeclaration = isNamedDeclaration;
    function getNonAssignedNameOfDeclaration(declaration) {
      switch (declaration.kind) {
        case 79:
          return declaration;
        case 342:
        case 335: {
          var name = declaration.name;
          if (name.kind === 159) {
            return name.right;
          }
          break;
        }
        case 206:
        case 219: {
          var expr_1 = declaration;
          switch (ts2.getAssignmentDeclarationKind(expr_1)) {
            case 1:
            case 4:
            case 5:
            case 3:
              return ts2.getElementOrPropertyAccessArgumentExpressionOrName(expr_1.left);
            case 7:
            case 8:
            case 9:
              return expr_1.arguments[1];
            default:
              return void 0;
          }
        }
        case 340:
          return getNameOfJSDocTypedef(declaration);
        case 334:
          return nameForNamelessJSDocTypedef(declaration);
        case 269: {
          var expression = declaration.expression;
          return ts2.isIdentifier(expression) ? expression : void 0;
        }
        case 205:
          var expr = declaration;
          if (ts2.isBindableStaticElementAccessExpression(expr)) {
            return expr.argumentExpression;
          }
      }
      return declaration.name;
    }
    ts2.getNonAssignedNameOfDeclaration = getNonAssignedNameOfDeclaration;
    function getNameOfDeclaration(declaration) {
      if (declaration === void 0)
        return void 0;
      return getNonAssignedNameOfDeclaration(declaration) || (ts2.isFunctionExpression(declaration) || ts2.isArrowFunction(declaration) || ts2.isClassExpression(declaration) ? getAssignedName(declaration) : void 0);
    }
    ts2.getNameOfDeclaration = getNameOfDeclaration;
    function getAssignedName(node) {
      if (!node.parent) {
        return void 0;
      } else if (ts2.isPropertyAssignment(node.parent) || ts2.isBindingElement(node.parent)) {
        return node.parent.name;
      } else if (ts2.isBinaryExpression(node.parent) && node === node.parent.right) {
        if (ts2.isIdentifier(node.parent.left)) {
          return node.parent.left;
        } else if (ts2.isAccessExpression(node.parent.left)) {
          return ts2.getElementOrPropertyAccessArgumentExpressionOrName(node.parent.left);
        }
      } else if (ts2.isVariableDeclaration(node.parent) && ts2.isIdentifier(node.parent.name)) {
        return node.parent.name;
      }
    }
    ts2.getAssignedName = getAssignedName;
    function getJSDocParameterTagsWorker(param, noCache) {
      if (param.name) {
        if (ts2.isIdentifier(param.name)) {
          var name_1 = param.name.escapedText;
          return getJSDocTagsWorker(param.parent, noCache).filter(function(tag) {
            return ts2.isJSDocParameterTag(tag) && ts2.isIdentifier(tag.name) && tag.name.escapedText === name_1;
          });
        } else {
          var i = param.parent.parameters.indexOf(param);
          ts2.Debug.assert(i > -1, "Parameters should always be in their parents' parameter list");
          var paramTags = getJSDocTagsWorker(param.parent, noCache).filter(ts2.isJSDocParameterTag);
          if (i < paramTags.length) {
            return [paramTags[i]];
          }
        }
      }
      return ts2.emptyArray;
    }
    function getJSDocParameterTags(param) {
      return getJSDocParameterTagsWorker(param, false);
    }
    ts2.getJSDocParameterTags = getJSDocParameterTags;
    function getJSDocParameterTagsNoCache(param) {
      return getJSDocParameterTagsWorker(param, true);
    }
    ts2.getJSDocParameterTagsNoCache = getJSDocParameterTagsNoCache;
    function getJSDocTypeParameterTagsWorker(param, noCache) {
      var name = param.name.escapedText;
      return getJSDocTagsWorker(param.parent, noCache).filter(function(tag) {
        return ts2.isJSDocTemplateTag(tag) && tag.typeParameters.some(function(tp) {
          return tp.name.escapedText === name;
        });
      });
    }
    function getJSDocTypeParameterTags(param) {
      return getJSDocTypeParameterTagsWorker(param, false);
    }
    ts2.getJSDocTypeParameterTags = getJSDocTypeParameterTags;
    function getJSDocTypeParameterTagsNoCache(param) {
      return getJSDocTypeParameterTagsWorker(param, true);
    }
    ts2.getJSDocTypeParameterTagsNoCache = getJSDocTypeParameterTagsNoCache;
    function hasJSDocParameterTags(node) {
      return !!getFirstJSDocTag(node, ts2.isJSDocParameterTag);
    }
    ts2.hasJSDocParameterTags = hasJSDocParameterTags;
    function getJSDocAugmentsTag(node) {
      return getFirstJSDocTag(node, ts2.isJSDocAugmentsTag);
    }
    ts2.getJSDocAugmentsTag = getJSDocAugmentsTag;
    function getJSDocImplementsTags(node) {
      return getAllJSDocTags(node, ts2.isJSDocImplementsTag);
    }
    ts2.getJSDocImplementsTags = getJSDocImplementsTags;
    function getJSDocClassTag(node) {
      return getFirstJSDocTag(node, ts2.isJSDocClassTag);
    }
    ts2.getJSDocClassTag = getJSDocClassTag;
    function getJSDocPublicTag(node) {
      return getFirstJSDocTag(node, ts2.isJSDocPublicTag);
    }
    ts2.getJSDocPublicTag = getJSDocPublicTag;
    function getJSDocPublicTagNoCache(node) {
      return getFirstJSDocTag(node, ts2.isJSDocPublicTag, true);
    }
    ts2.getJSDocPublicTagNoCache = getJSDocPublicTagNoCache;
    function getJSDocPrivateTag(node) {
      return getFirstJSDocTag(node, ts2.isJSDocPrivateTag);
    }
    ts2.getJSDocPrivateTag = getJSDocPrivateTag;
    function getJSDocPrivateTagNoCache(node) {
      return getFirstJSDocTag(node, ts2.isJSDocPrivateTag, true);
    }
    ts2.getJSDocPrivateTagNoCache = getJSDocPrivateTagNoCache;
    function getJSDocProtectedTag(node) {
      return getFirstJSDocTag(node, ts2.isJSDocProtectedTag);
    }
    ts2.getJSDocProtectedTag = getJSDocProtectedTag;
    function getJSDocProtectedTagNoCache(node) {
      return getFirstJSDocTag(node, ts2.isJSDocProtectedTag, true);
    }
    ts2.getJSDocProtectedTagNoCache = getJSDocProtectedTagNoCache;
    function getJSDocReadonlyTag(node) {
      return getFirstJSDocTag(node, ts2.isJSDocReadonlyTag);
    }
    ts2.getJSDocReadonlyTag = getJSDocReadonlyTag;
    function getJSDocReadonlyTagNoCache(node) {
      return getFirstJSDocTag(node, ts2.isJSDocReadonlyTag, true);
    }
    ts2.getJSDocReadonlyTagNoCache = getJSDocReadonlyTagNoCache;
    function getJSDocOverrideTagNoCache(node) {
      return getFirstJSDocTag(node, ts2.isJSDocOverrideTag, true);
    }
    ts2.getJSDocOverrideTagNoCache = getJSDocOverrideTagNoCache;
    function getJSDocDeprecatedTag(node) {
      return getFirstJSDocTag(node, ts2.isJSDocDeprecatedTag);
    }
    ts2.getJSDocDeprecatedTag = getJSDocDeprecatedTag;
    function getJSDocDeprecatedTagNoCache(node) {
      return getFirstJSDocTag(node, ts2.isJSDocDeprecatedTag, true);
    }
    ts2.getJSDocDeprecatedTagNoCache = getJSDocDeprecatedTagNoCache;
    function getJSDocEnumTag(node) {
      return getFirstJSDocTag(node, ts2.isJSDocEnumTag);
    }
    ts2.getJSDocEnumTag = getJSDocEnumTag;
    function getJSDocThisTag(node) {
      return getFirstJSDocTag(node, ts2.isJSDocThisTag);
    }
    ts2.getJSDocThisTag = getJSDocThisTag;
    function getJSDocReturnTag(node) {
      return getFirstJSDocTag(node, ts2.isJSDocReturnTag);
    }
    ts2.getJSDocReturnTag = getJSDocReturnTag;
    function getJSDocTemplateTag(node) {
      return getFirstJSDocTag(node, ts2.isJSDocTemplateTag);
    }
    ts2.getJSDocTemplateTag = getJSDocTemplateTag;
    function getJSDocTypeTag(node) {
      var tag = getFirstJSDocTag(node, ts2.isJSDocTypeTag);
      if (tag && tag.typeExpression && tag.typeExpression.type) {
        return tag;
      }
      return void 0;
    }
    ts2.getJSDocTypeTag = getJSDocTypeTag;
    function getJSDocType(node) {
      var tag = getFirstJSDocTag(node, ts2.isJSDocTypeTag);
      if (!tag && ts2.isParameter(node)) {
        tag = ts2.find(getJSDocParameterTags(node), function(tag2) {
          return !!tag2.typeExpression;
        });
      }
      return tag && tag.typeExpression && tag.typeExpression.type;
    }
    ts2.getJSDocType = getJSDocType;
    function getJSDocReturnType(node) {
      var returnTag = getJSDocReturnTag(node);
      if (returnTag && returnTag.typeExpression) {
        return returnTag.typeExpression.type;
      }
      var typeTag = getJSDocTypeTag(node);
      if (typeTag && typeTag.typeExpression) {
        var type = typeTag.typeExpression.type;
        if (ts2.isTypeLiteralNode(type)) {
          var sig = ts2.find(type.members, ts2.isCallSignatureDeclaration);
          return sig && sig.type;
        }
        if (ts2.isFunctionTypeNode(type) || ts2.isJSDocFunctionType(type)) {
          return type.type;
        }
      }
    }
    ts2.getJSDocReturnType = getJSDocReturnType;
    function getJSDocTagsWorker(node, noCache) {
      var tags = node.jsDocCache;
      if (tags === void 0 || noCache) {
        var comments = ts2.getJSDocCommentsAndTags(node, noCache);
        ts2.Debug.assert(comments.length < 2 || comments[0] !== comments[1]);
        tags = ts2.flatMap(comments, function(j) {
          return ts2.isJSDoc(j) ? j.tags : j;
        });
        if (!noCache) {
          node.jsDocCache = tags;
        }
      }
      return tags;
    }
    function getJSDocTags(node) {
      return getJSDocTagsWorker(node, false);
    }
    ts2.getJSDocTags = getJSDocTags;
    function getJSDocTagsNoCache(node) {
      return getJSDocTagsWorker(node, true);
    }
    ts2.getJSDocTagsNoCache = getJSDocTagsNoCache;
    function getFirstJSDocTag(node, predicate, noCache) {
      return ts2.find(getJSDocTagsWorker(node, noCache), predicate);
    }
    function getAllJSDocTags(node, predicate) {
      return getJSDocTags(node).filter(predicate);
    }
    ts2.getAllJSDocTags = getAllJSDocTags;
    function getAllJSDocTagsOfKind(node, kind) {
      return getJSDocTags(node).filter(function(doc) {
        return doc.kind === kind;
      });
    }
    ts2.getAllJSDocTagsOfKind = getAllJSDocTagsOfKind;
    function getTextOfJSDocComment(comment) {
      return typeof comment === "string" ? comment : comment === null || comment === void 0 ? void 0 : comment.map(function(c) {
        return c.kind === 316 ? c.text : "{@link " + (c.name ? ts2.entityNameToString(c.name) + " " : "") + c.text + "}";
      }).join("");
    }
    ts2.getTextOfJSDocComment = getTextOfJSDocComment;
    function getEffectiveTypeParameterDeclarations(node) {
      if (ts2.isJSDocSignature(node)) {
        return ts2.emptyArray;
      }
      if (ts2.isJSDocTypeAlias(node)) {
        ts2.Debug.assert(node.parent.kind === 315);
        return ts2.flatMap(node.parent.tags, function(tag) {
          return ts2.isJSDocTemplateTag(tag) ? tag.typeParameters : void 0;
        });
      }
      if (node.typeParameters) {
        return node.typeParameters;
      }
      if (ts2.isInJSFile(node)) {
        var decls = ts2.getJSDocTypeParameterDeclarations(node);
        if (decls.length) {
          return decls;
        }
        var typeTag = getJSDocType(node);
        if (typeTag && ts2.isFunctionTypeNode(typeTag) && typeTag.typeParameters) {
          return typeTag.typeParameters;
        }
      }
      return ts2.emptyArray;
    }
    ts2.getEffectiveTypeParameterDeclarations = getEffectiveTypeParameterDeclarations;
    function getEffectiveConstraintOfTypeParameter(node) {
      return node.constraint ? node.constraint : ts2.isJSDocTemplateTag(node.parent) && node === node.parent.typeParameters[0] ? node.parent.constraint : void 0;
    }
    ts2.getEffectiveConstraintOfTypeParameter = getEffectiveConstraintOfTypeParameter;
    function isMemberName(node) {
      return node.kind === 79 || node.kind === 80;
    }
    ts2.isMemberName = isMemberName;
    function isGetOrSetAccessorDeclaration(node) {
      return node.kind === 171 || node.kind === 170;
    }
    ts2.isGetOrSetAccessorDeclaration = isGetOrSetAccessorDeclaration;
    function isPropertyAccessChain(node) {
      return ts2.isPropertyAccessExpression(node) && !!(node.flags & 32);
    }
    ts2.isPropertyAccessChain = isPropertyAccessChain;
    function isElementAccessChain(node) {
      return ts2.isElementAccessExpression(node) && !!(node.flags & 32);
    }
    ts2.isElementAccessChain = isElementAccessChain;
    function isCallChain(node) {
      return ts2.isCallExpression(node) && !!(node.flags & 32);
    }
    ts2.isCallChain = isCallChain;
    function isOptionalChain(node) {
      var kind = node.kind;
      return !!(node.flags & 32) && (kind === 204 || kind === 205 || kind === 206 || kind === 228);
    }
    ts2.isOptionalChain = isOptionalChain;
    function isOptionalChainRoot(node) {
      return isOptionalChain(node) && !ts2.isNonNullExpression(node) && !!node.questionDotToken;
    }
    ts2.isOptionalChainRoot = isOptionalChainRoot;
    function isExpressionOfOptionalChainRoot(node) {
      return isOptionalChainRoot(node.parent) && node.parent.expression === node;
    }
    ts2.isExpressionOfOptionalChainRoot = isExpressionOfOptionalChainRoot;
    function isOutermostOptionalChain(node) {
      return !isOptionalChain(node.parent) || isOptionalChainRoot(node.parent) || node !== node.parent.expression;
    }
    ts2.isOutermostOptionalChain = isOutermostOptionalChain;
    function isNullishCoalesce(node) {
      return node.kind === 219 && node.operatorToken.kind === 60;
    }
    ts2.isNullishCoalesce = isNullishCoalesce;
    function isConstTypeReference(node) {
      return ts2.isTypeReferenceNode(node) && ts2.isIdentifier(node.typeName) && node.typeName.escapedText === "const" && !node.typeArguments;
    }
    ts2.isConstTypeReference = isConstTypeReference;
    function skipPartiallyEmittedExpressions(node) {
      return ts2.skipOuterExpressions(node, 8);
    }
    ts2.skipPartiallyEmittedExpressions = skipPartiallyEmittedExpressions;
    function isNonNullChain(node) {
      return ts2.isNonNullExpression(node) && !!(node.flags & 32);
    }
    ts2.isNonNullChain = isNonNullChain;
    function isBreakOrContinueStatement(node) {
      return node.kind === 244 || node.kind === 243;
    }
    ts2.isBreakOrContinueStatement = isBreakOrContinueStatement;
    function isNamedExportBindings(node) {
      return node.kind === 272 || node.kind === 271;
    }
    ts2.isNamedExportBindings = isNamedExportBindings;
    function isUnparsedTextLike(node) {
      switch (node.kind) {
        case 297:
        case 298:
          return true;
        default:
          return false;
      }
    }
    ts2.isUnparsedTextLike = isUnparsedTextLike;
    function isUnparsedNode(node) {
      return isUnparsedTextLike(node) || node.kind === 295 || node.kind === 299;
    }
    ts2.isUnparsedNode = isUnparsedNode;
    function isJSDocPropertyLikeTag(node) {
      return node.kind === 342 || node.kind === 335;
    }
    ts2.isJSDocPropertyLikeTag = isJSDocPropertyLikeTag;
    function isNode(node) {
      return isNodeKind(node.kind);
    }
    ts2.isNode = isNode;
    function isNodeKind(kind) {
      return kind >= 159;
    }
    ts2.isNodeKind = isNodeKind;
    function isTokenKind(kind) {
      return kind >= 0 && kind <= 158;
    }
    ts2.isTokenKind = isTokenKind;
    function isToken(n) {
      return isTokenKind(n.kind);
    }
    ts2.isToken = isToken;
    function isNodeArray(array) {
      return array.hasOwnProperty("pos") && array.hasOwnProperty("end");
    }
    ts2.isNodeArray = isNodeArray;
    function isLiteralKind(kind) {
      return 8 <= kind && kind <= 14;
    }
    ts2.isLiteralKind = isLiteralKind;
    function isLiteralExpression(node) {
      return isLiteralKind(node.kind);
    }
    ts2.isLiteralExpression = isLiteralExpression;
    function isTemplateLiteralKind(kind) {
      return 14 <= kind && kind <= 17;
    }
    ts2.isTemplateLiteralKind = isTemplateLiteralKind;
    function isTemplateLiteralToken(node) {
      return isTemplateLiteralKind(node.kind);
    }
    ts2.isTemplateLiteralToken = isTemplateLiteralToken;
    function isTemplateMiddleOrTemplateTail(node) {
      var kind = node.kind;
      return kind === 16 || kind === 17;
    }
    ts2.isTemplateMiddleOrTemplateTail = isTemplateMiddleOrTemplateTail;
    function isImportOrExportSpecifier(node) {
      return ts2.isImportSpecifier(node) || ts2.isExportSpecifier(node);
    }
    ts2.isImportOrExportSpecifier = isImportOrExportSpecifier;
    function isTypeOnlyImportOrExportDeclaration(node) {
      switch (node.kind) {
        case 268:
        case 273:
          return node.parent.parent.isTypeOnly;
        case 266:
          return node.parent.isTypeOnly;
        case 265:
        case 263:
          return node.isTypeOnly;
        default:
          return false;
      }
    }
    ts2.isTypeOnlyImportOrExportDeclaration = isTypeOnlyImportOrExportDeclaration;
    function isStringTextContainingNode(node) {
      return node.kind === 10 || isTemplateLiteralKind(node.kind);
    }
    ts2.isStringTextContainingNode = isStringTextContainingNode;
    function isGeneratedIdentifier(node) {
      return ts2.isIdentifier(node) && (node.autoGenerateFlags & 7) > 0;
    }
    ts2.isGeneratedIdentifier = isGeneratedIdentifier;
    function isPrivateIdentifierClassElementDeclaration(node) {
      return (ts2.isPropertyDeclaration(node) || isMethodOrAccessor(node)) && ts2.isPrivateIdentifier(node.name);
    }
    ts2.isPrivateIdentifierClassElementDeclaration = isPrivateIdentifierClassElementDeclaration;
    function isPrivateIdentifierPropertyAccessExpression(node) {
      return ts2.isPropertyAccessExpression(node) && ts2.isPrivateIdentifier(node.name);
    }
    ts2.isPrivateIdentifierPropertyAccessExpression = isPrivateIdentifierPropertyAccessExpression;
    function isModifierKind(token) {
      switch (token) {
        case 126:
        case 130:
        case 85:
        case 134:
        case 88:
        case 93:
        case 123:
        case 121:
        case 122:
        case 143:
        case 124:
        case 157:
          return true;
      }
      return false;
    }
    ts2.isModifierKind = isModifierKind;
    function isParameterPropertyModifier(kind) {
      return !!(ts2.modifierToFlag(kind) & 16476);
    }
    ts2.isParameterPropertyModifier = isParameterPropertyModifier;
    function isClassMemberModifier(idToken) {
      return isParameterPropertyModifier(idToken) || idToken === 124 || idToken === 157;
    }
    ts2.isClassMemberModifier = isClassMemberModifier;
    function isModifier(node) {
      return isModifierKind(node.kind);
    }
    ts2.isModifier = isModifier;
    function isEntityName(node) {
      var kind = node.kind;
      return kind === 159 || kind === 79;
    }
    ts2.isEntityName = isEntityName;
    function isPropertyName(node) {
      var kind = node.kind;
      return kind === 79 || kind === 80 || kind === 10 || kind === 8 || kind === 160;
    }
    ts2.isPropertyName = isPropertyName;
    function isBindingName(node) {
      var kind = node.kind;
      return kind === 79 || kind === 199 || kind === 200;
    }
    ts2.isBindingName = isBindingName;
    function isFunctionLike(node) {
      return !!node && isFunctionLikeKind(node.kind);
    }
    ts2.isFunctionLike = isFunctionLike;
    function isFunctionLikeOrClassStaticBlockDeclaration(node) {
      return !!node && (isFunctionLikeKind(node.kind) || ts2.isClassStaticBlockDeclaration(node));
    }
    ts2.isFunctionLikeOrClassStaticBlockDeclaration = isFunctionLikeOrClassStaticBlockDeclaration;
    function isFunctionLikeDeclaration(node) {
      return node && isFunctionLikeDeclarationKind(node.kind);
    }
    ts2.isFunctionLikeDeclaration = isFunctionLikeDeclaration;
    function isBooleanLiteral(node) {
      return node.kind === 110 || node.kind === 95;
    }
    ts2.isBooleanLiteral = isBooleanLiteral;
    function isFunctionLikeDeclarationKind(kind) {
      switch (kind) {
        case 254:
        case 167:
        case 169:
        case 170:
        case 171:
        case 211:
        case 212:
          return true;
        default:
          return false;
      }
    }
    function isFunctionLikeKind(kind) {
      switch (kind) {
        case 166:
        case 172:
        case 318:
        case 173:
        case 174:
        case 177:
        case 312:
        case 178:
          return true;
        default:
          return isFunctionLikeDeclarationKind(kind);
      }
    }
    ts2.isFunctionLikeKind = isFunctionLikeKind;
    function isFunctionOrModuleBlock(node) {
      return ts2.isSourceFile(node) || ts2.isModuleBlock(node) || ts2.isBlock(node) && isFunctionLike(node.parent);
    }
    ts2.isFunctionOrModuleBlock = isFunctionOrModuleBlock;
    function isClassElement(node) {
      var kind = node.kind;
      return kind === 169 || kind === 165 || kind === 167 || kind === 170 || kind === 171 || kind === 174 || kind === 168 || kind === 232;
    }
    ts2.isClassElement = isClassElement;
    function isClassLike(node) {
      return node && (node.kind === 255 || node.kind === 224);
    }
    ts2.isClassLike = isClassLike;
    function isAccessor(node) {
      return node && (node.kind === 170 || node.kind === 171);
    }
    ts2.isAccessor = isAccessor;
    function isMethodOrAccessor(node) {
      switch (node.kind) {
        case 167:
        case 170:
        case 171:
          return true;
        default:
          return false;
      }
    }
    ts2.isMethodOrAccessor = isMethodOrAccessor;
    function isTypeElement(node) {
      var kind = node.kind;
      return kind === 173 || kind === 172 || kind === 164 || kind === 166 || kind === 174;
    }
    ts2.isTypeElement = isTypeElement;
    function isClassOrTypeElement(node) {
      return isTypeElement(node) || isClassElement(node);
    }
    ts2.isClassOrTypeElement = isClassOrTypeElement;
    function isObjectLiteralElementLike(node) {
      var kind = node.kind;
      return kind === 291 || kind === 292 || kind === 293 || kind === 167 || kind === 170 || kind === 171;
    }
    ts2.isObjectLiteralElementLike = isObjectLiteralElementLike;
    function isTypeNode(node) {
      return ts2.isTypeNodeKind(node.kind);
    }
    ts2.isTypeNode = isTypeNode;
    function isFunctionOrConstructorTypeNode(node) {
      switch (node.kind) {
        case 177:
        case 178:
          return true;
      }
      return false;
    }
    ts2.isFunctionOrConstructorTypeNode = isFunctionOrConstructorTypeNode;
    function isBindingPattern(node) {
      if (node) {
        var kind = node.kind;
        return kind === 200 || kind === 199;
      }
      return false;
    }
    ts2.isBindingPattern = isBindingPattern;
    function isAssignmentPattern(node) {
      var kind = node.kind;
      return kind === 202 || kind === 203;
    }
    ts2.isAssignmentPattern = isAssignmentPattern;
    function isArrayBindingElement(node) {
      var kind = node.kind;
      return kind === 201 || kind === 225;
    }
    ts2.isArrayBindingElement = isArrayBindingElement;
    function isDeclarationBindingElement(bindingElement) {
      switch (bindingElement.kind) {
        case 252:
        case 162:
        case 201:
          return true;
      }
      return false;
    }
    ts2.isDeclarationBindingElement = isDeclarationBindingElement;
    function isBindingOrAssignmentPattern(node) {
      return isObjectBindingOrAssignmentPattern(node) || isArrayBindingOrAssignmentPattern(node);
    }
    ts2.isBindingOrAssignmentPattern = isBindingOrAssignmentPattern;
    function isObjectBindingOrAssignmentPattern(node) {
      switch (node.kind) {
        case 199:
        case 203:
          return true;
      }
      return false;
    }
    ts2.isObjectBindingOrAssignmentPattern = isObjectBindingOrAssignmentPattern;
    function isObjectBindingOrAssignmentElement(node) {
      switch (node.kind) {
        case 201:
        case 291:
        case 292:
        case 293:
          return true;
      }
      return false;
    }
    ts2.isObjectBindingOrAssignmentElement = isObjectBindingOrAssignmentElement;
    function isArrayBindingOrAssignmentPattern(node) {
      switch (node.kind) {
        case 200:
        case 202:
          return true;
      }
      return false;
    }
    ts2.isArrayBindingOrAssignmentPattern = isArrayBindingOrAssignmentPattern;
    function isPropertyAccessOrQualifiedNameOrImportTypeNode(node) {
      var kind = node.kind;
      return kind === 204 || kind === 159 || kind === 198;
    }
    ts2.isPropertyAccessOrQualifiedNameOrImportTypeNode = isPropertyAccessOrQualifiedNameOrImportTypeNode;
    function isPropertyAccessOrQualifiedName(node) {
      var kind = node.kind;
      return kind === 204 || kind === 159;
    }
    ts2.isPropertyAccessOrQualifiedName = isPropertyAccessOrQualifiedName;
    function isCallLikeExpression(node) {
      switch (node.kind) {
        case 278:
        case 277:
        case 206:
        case 207:
        case 208:
        case 163:
          return true;
        default:
          return false;
      }
    }
    ts2.isCallLikeExpression = isCallLikeExpression;
    function isCallOrNewExpression(node) {
      return node.kind === 206 || node.kind === 207;
    }
    ts2.isCallOrNewExpression = isCallOrNewExpression;
    function isTemplateLiteral(node) {
      var kind = node.kind;
      return kind === 221 || kind === 14;
    }
    ts2.isTemplateLiteral = isTemplateLiteral;
    function isLeftHandSideExpression(node) {
      return isLeftHandSideExpressionKind(skipPartiallyEmittedExpressions(node).kind);
    }
    ts2.isLeftHandSideExpression = isLeftHandSideExpression;
    function isLeftHandSideExpressionKind(kind) {
      switch (kind) {
        case 204:
        case 205:
        case 207:
        case 206:
        case 276:
        case 277:
        case 280:
        case 208:
        case 202:
        case 210:
        case 203:
        case 224:
        case 211:
        case 79:
        case 13:
        case 8:
        case 9:
        case 10:
        case 14:
        case 221:
        case 95:
        case 104:
        case 108:
        case 110:
        case 106:
        case 228:
        case 229:
        case 100:
          return true;
        default:
          return false;
      }
    }
    function isUnaryExpression(node) {
      return isUnaryExpressionKind(skipPartiallyEmittedExpressions(node).kind);
    }
    ts2.isUnaryExpression = isUnaryExpression;
    function isUnaryExpressionKind(kind) {
      switch (kind) {
        case 217:
        case 218:
        case 213:
        case 214:
        case 215:
        case 216:
        case 209:
          return true;
        default:
          return isLeftHandSideExpressionKind(kind);
      }
    }
    function isUnaryExpressionWithWrite(expr) {
      switch (expr.kind) {
        case 218:
          return true;
        case 217:
          return expr.operator === 45 || expr.operator === 46;
        default:
          return false;
      }
    }
    ts2.isUnaryExpressionWithWrite = isUnaryExpressionWithWrite;
    function isExpression(node) {
      return isExpressionKind(skipPartiallyEmittedExpressions(node).kind);
    }
    ts2.isExpression = isExpression;
    function isExpressionKind(kind) {
      switch (kind) {
        case 220:
        case 222:
        case 212:
        case 219:
        case 223:
        case 227:
        case 225:
        case 346:
        case 345:
          return true;
        default:
          return isUnaryExpressionKind(kind);
      }
    }
    function isAssertionExpression(node) {
      var kind = node.kind;
      return kind === 209 || kind === 227;
    }
    ts2.isAssertionExpression = isAssertionExpression;
    function isNotEmittedOrPartiallyEmittedNode(node) {
      return ts2.isNotEmittedStatement(node) || ts2.isPartiallyEmittedExpression(node);
    }
    ts2.isNotEmittedOrPartiallyEmittedNode = isNotEmittedOrPartiallyEmittedNode;
    function isIterationStatement(node, lookInLabeledStatements) {
      switch (node.kind) {
        case 240:
        case 241:
        case 242:
        case 238:
        case 239:
          return true;
        case 248:
          return lookInLabeledStatements && isIterationStatement(node.statement, lookInLabeledStatements);
      }
      return false;
    }
    ts2.isIterationStatement = isIterationStatement;
    function isScopeMarker(node) {
      return ts2.isExportAssignment(node) || ts2.isExportDeclaration(node);
    }
    ts2.isScopeMarker = isScopeMarker;
    function hasScopeMarker(statements) {
      return ts2.some(statements, isScopeMarker);
    }
    ts2.hasScopeMarker = hasScopeMarker;
    function needsScopeMarker(result) {
      return !ts2.isAnyImportOrReExport(result) && !ts2.isExportAssignment(result) && !ts2.hasSyntacticModifier(result, 1) && !ts2.isAmbientModule(result);
    }
    ts2.needsScopeMarker = needsScopeMarker;
    function isExternalModuleIndicator(result) {
      return ts2.isAnyImportOrReExport(result) || ts2.isExportAssignment(result) || ts2.hasSyntacticModifier(result, 1);
    }
    ts2.isExternalModuleIndicator = isExternalModuleIndicator;
    function isForInOrOfStatement(node) {
      return node.kind === 241 || node.kind === 242;
    }
    ts2.isForInOrOfStatement = isForInOrOfStatement;
    function isConciseBody(node) {
      return ts2.isBlock(node) || isExpression(node);
    }
    ts2.isConciseBody = isConciseBody;
    function isFunctionBody(node) {
      return ts2.isBlock(node);
    }
    ts2.isFunctionBody = isFunctionBody;
    function isForInitializer(node) {
      return ts2.isVariableDeclarationList(node) || isExpression(node);
    }
    ts2.isForInitializer = isForInitializer;
    function isModuleBody(node) {
      var kind = node.kind;
      return kind === 260 || kind === 259 || kind === 79;
    }
    ts2.isModuleBody = isModuleBody;
    function isNamespaceBody(node) {
      var kind = node.kind;
      return kind === 260 || kind === 259;
    }
    ts2.isNamespaceBody = isNamespaceBody;
    function isJSDocNamespaceBody(node) {
      var kind = node.kind;
      return kind === 79 || kind === 259;
    }
    ts2.isJSDocNamespaceBody = isJSDocNamespaceBody;
    function isNamedImportBindings(node) {
      var kind = node.kind;
      return kind === 267 || kind === 266;
    }
    ts2.isNamedImportBindings = isNamedImportBindings;
    function isModuleOrEnumDeclaration(node) {
      return node.kind === 259 || node.kind === 258;
    }
    ts2.isModuleOrEnumDeclaration = isModuleOrEnumDeclaration;
    function isDeclarationKind(kind) {
      return kind === 212 || kind === 201 || kind === 255 || kind === 224 || kind === 168 || kind === 169 || kind === 258 || kind === 294 || kind === 273 || kind === 254 || kind === 211 || kind === 170 || kind === 265 || kind === 263 || kind === 268 || kind === 256 || kind === 283 || kind === 167 || kind === 166 || kind === 259 || kind === 262 || kind === 266 || kind === 272 || kind === 162 || kind === 291 || kind === 165 || kind === 164 || kind === 171 || kind === 292 || kind === 257 || kind === 161 || kind === 252 || kind === 340 || kind === 333 || kind === 342;
    }
    function isDeclarationStatementKind(kind) {
      return kind === 254 || kind === 274 || kind === 255 || kind === 256 || kind === 257 || kind === 258 || kind === 259 || kind === 264 || kind === 263 || kind === 270 || kind === 269 || kind === 262;
    }
    function isStatementKindButNotDeclarationKind(kind) {
      return kind === 244 || kind === 243 || kind === 251 || kind === 238 || kind === 236 || kind === 234 || kind === 241 || kind === 242 || kind === 240 || kind === 237 || kind === 248 || kind === 245 || kind === 247 || kind === 249 || kind === 250 || kind === 235 || kind === 239 || kind === 246 || kind === 344 || kind === 348 || kind === 347;
    }
    function isDeclaration(node) {
      if (node.kind === 161) {
        return node.parent && node.parent.kind !== 339 || ts2.isInJSFile(node);
      }
      return isDeclarationKind(node.kind);
    }
    ts2.isDeclaration = isDeclaration;
    function isDeclarationStatement(node) {
      return isDeclarationStatementKind(node.kind);
    }
    ts2.isDeclarationStatement = isDeclarationStatement;
    function isStatementButNotDeclaration(node) {
      return isStatementKindButNotDeclarationKind(node.kind);
    }
    ts2.isStatementButNotDeclaration = isStatementButNotDeclaration;
    function isStatement(node) {
      var kind = node.kind;
      return isStatementKindButNotDeclarationKind(kind) || isDeclarationStatementKind(kind) || isBlockStatement(node);
    }
    ts2.isStatement = isStatement;
    function isBlockStatement(node) {
      if (node.kind !== 233)
        return false;
      if (node.parent !== void 0) {
        if (node.parent.kind === 250 || node.parent.kind === 290) {
          return false;
        }
      }
      return !ts2.isFunctionBlock(node);
    }
    function isStatementOrBlock(node) {
      var kind = node.kind;
      return isStatementKindButNotDeclarationKind(kind) || isDeclarationStatementKind(kind) || kind === 233;
    }
    ts2.isStatementOrBlock = isStatementOrBlock;
    function isModuleReference(node) {
      var kind = node.kind;
      return kind === 275 || kind === 159 || kind === 79;
    }
    ts2.isModuleReference = isModuleReference;
    function isJsxTagNameExpression(node) {
      var kind = node.kind;
      return kind === 108 || kind === 79 || kind === 204;
    }
    ts2.isJsxTagNameExpression = isJsxTagNameExpression;
    function isJsxChild(node) {
      var kind = node.kind;
      return kind === 276 || kind === 286 || kind === 277 || kind === 11 || kind === 280;
    }
    ts2.isJsxChild = isJsxChild;
    function isJsxAttributeLike(node) {
      var kind = node.kind;
      return kind === 283 || kind === 285;
    }
    ts2.isJsxAttributeLike = isJsxAttributeLike;
    function isStringLiteralOrJsxExpression(node) {
      var kind = node.kind;
      return kind === 10 || kind === 286;
    }
    ts2.isStringLiteralOrJsxExpression = isStringLiteralOrJsxExpression;
    function isJsxOpeningLikeElement(node) {
      var kind = node.kind;
      return kind === 278 || kind === 277;
    }
    ts2.isJsxOpeningLikeElement = isJsxOpeningLikeElement;
    function isCaseOrDefaultClause(node) {
      var kind = node.kind;
      return kind === 287 || kind === 288;
    }
    ts2.isCaseOrDefaultClause = isCaseOrDefaultClause;
    function isJSDocNode(node) {
      return node.kind >= 304 && node.kind <= 342;
    }
    ts2.isJSDocNode = isJSDocNode;
    function isJSDocCommentContainingNode(node) {
      return node.kind === 315 || node.kind === 314 || node.kind === 316 || isJSDocLinkLike(node) || isJSDocTag(node) || ts2.isJSDocTypeLiteral(node) || ts2.isJSDocSignature(node);
    }
    ts2.isJSDocCommentContainingNode = isJSDocCommentContainingNode;
    function isJSDocTag(node) {
      return node.kind >= 322 && node.kind <= 342;
    }
    ts2.isJSDocTag = isJSDocTag;
    function isSetAccessor(node) {
      return node.kind === 171;
    }
    ts2.isSetAccessor = isSetAccessor;
    function isGetAccessor(node) {
      return node.kind === 170;
    }
    ts2.isGetAccessor = isGetAccessor;
    function hasJSDocNodes(node) {
      var jsDoc = node.jsDoc;
      return !!jsDoc && jsDoc.length > 0;
    }
    ts2.hasJSDocNodes = hasJSDocNodes;
    function hasType(node) {
      return !!node.type;
    }
    ts2.hasType = hasType;
    function hasInitializer(node) {
      return !!node.initializer;
    }
    ts2.hasInitializer = hasInitializer;
    function hasOnlyExpressionInitializer(node) {
      switch (node.kind) {
        case 252:
        case 162:
        case 201:
        case 164:
        case 165:
        case 291:
        case 294:
          return true;
        default:
          return false;
      }
    }
    ts2.hasOnlyExpressionInitializer = hasOnlyExpressionInitializer;
    function isObjectLiteralElement(node) {
      return node.kind === 283 || node.kind === 285 || isObjectLiteralElementLike(node);
    }
    ts2.isObjectLiteralElement = isObjectLiteralElement;
    function isTypeReferenceType(node) {
      return node.kind === 176 || node.kind === 226;
    }
    ts2.isTypeReferenceType = isTypeReferenceType;
    var MAX_SMI_X86 = 1073741823;
    function guessIndentation(lines) {
      var indentation = MAX_SMI_X86;
      for (var _i = 0, lines_1 = lines; _i < lines_1.length; _i++) {
        var line = lines_1[_i];
        if (!line.length) {
          continue;
        }
        var i = 0;
        for (; i < line.length && i < indentation; i++) {
          if (!ts2.isWhiteSpaceLike(line.charCodeAt(i))) {
            break;
          }
        }
        if (i < indentation) {
          indentation = i;
        }
        if (indentation === 0) {
          return 0;
        }
      }
      return indentation === MAX_SMI_X86 ? void 0 : indentation;
    }
    ts2.guessIndentation = guessIndentation;
    function isStringLiteralLike(node) {
      return node.kind === 10 || node.kind === 14;
    }
    ts2.isStringLiteralLike = isStringLiteralLike;
    function isJSDocLinkLike(node) {
      return node.kind === 319 || node.kind === 320 || node.kind === 321;
    }
    ts2.isJSDocLinkLike = isJSDocLinkLike;
  })(ts || (ts = {}));
  var ts;
  (function(ts2) {
    ts2.resolvingEmptyArray = [];
    ts2.externalHelpersModuleNameText = "tslib";
    ts2.defaultMaximumTruncationLength = 160;
    ts2.noTruncationMaximumTruncationLength = 1e6;
    function getDeclarationOfKind(symbol, kind) {
      var declarations = symbol.declarations;
      if (declarations) {
        for (var _i = 0, declarations_1 = declarations; _i < declarations_1.length; _i++) {
          var declaration = declarations_1[_i];
          if (declaration.kind === kind) {
            return declaration;
          }
        }
      }
      return void 0;
    }
    ts2.getDeclarationOfKind = getDeclarationOfKind;
    function createUnderscoreEscapedMap() {
      return new ts2.Map();
    }
    ts2.createUnderscoreEscapedMap = createUnderscoreEscapedMap;
    function hasEntries(map) {
      return !!map && !!map.size;
    }
    ts2.hasEntries = hasEntries;
    function createSymbolTable(symbols) {
      var result = new ts2.Map();
      if (symbols) {
        for (var _i = 0, symbols_1 = symbols; _i < symbols_1.length; _i++) {
          var symbol = symbols_1[_i];
          result.set(symbol.escapedName, symbol);
        }
      }
      return result;
    }
    ts2.createSymbolTable = createSymbolTable;
    function isTransientSymbol(symbol) {
      return (symbol.flags & 33554432) !== 0;
    }
    ts2.isTransientSymbol = isTransientSymbol;
    var stringWriter = createSingleLineStringWriter();
    function createSingleLineStringWriter() {
      var str = "";
      var writeText = function(text) {
        return str += text;
      };
      return {
        getText: function() {
          return str;
        },
        write: writeText,
        rawWrite: writeText,
        writeKeyword: writeText,
        writeOperator: writeText,
        writePunctuation: writeText,
        writeSpace: writeText,
        writeStringLiteral: writeText,
        writeLiteral: writeText,
        writeParameter: writeText,
        writeProperty: writeText,
        writeSymbol: function(s, _) {
          return writeText(s);
        },
        writeTrailingSemicolon: writeText,
        writeComment: writeText,
        getTextPos: function() {
          return str.length;
        },
        getLine: function() {
          return 0;
        },
        getColumn: function() {
          return 0;
        },
        getIndent: function() {
          return 0;
        },
        isAtStartOfLine: function() {
          return false;
        },
        hasTrailingComment: function() {
          return false;
        },
        hasTrailingWhitespace: function() {
          return !!str.length && ts2.isWhiteSpaceLike(str.charCodeAt(str.length - 1));
        },
        writeLine: function() {
          return str += " ";
        },
        increaseIndent: ts2.noop,
        decreaseIndent: ts2.noop,
        clear: function() {
          return str = "";
        },
        trackSymbol: function() {
          return false;
        },
        reportInaccessibleThisError: ts2.noop,
        reportInaccessibleUniqueSymbolError: ts2.noop,
        reportPrivateInBaseOfClassExpression: ts2.noop
      };
    }
    function changesAffectModuleResolution(oldOptions, newOptions) {
      return oldOptions.configFilePath !== newOptions.configFilePath || optionsHaveModuleResolutionChanges(oldOptions, newOptions);
    }
    ts2.changesAffectModuleResolution = changesAffectModuleResolution;
    function optionsHaveModuleResolutionChanges(oldOptions, newOptions) {
      return optionsHaveChanges(oldOptions, newOptions, ts2.moduleResolutionOptionDeclarations);
    }
    ts2.optionsHaveModuleResolutionChanges = optionsHaveModuleResolutionChanges;
    function changesAffectingProgramStructure(oldOptions, newOptions) {
      return optionsHaveChanges(oldOptions, newOptions, ts2.optionsAffectingProgramStructure);
    }
    ts2.changesAffectingProgramStructure = changesAffectingProgramStructure;
    function optionsHaveChanges(oldOptions, newOptions, optionDeclarations) {
      return oldOptions !== newOptions && optionDeclarations.some(function(o) {
        return !isJsonEqual(getCompilerOptionValue(oldOptions, o), getCompilerOptionValue(newOptions, o));
      });
    }
    ts2.optionsHaveChanges = optionsHaveChanges;
    function forEachAncestor(node, callback) {
      while (true) {
        var res = callback(node);
        if (res === "quit")
          return void 0;
        if (res !== void 0)
          return res;
        if (ts2.isSourceFile(node))
          return void 0;
        node = node.parent;
      }
    }
    ts2.forEachAncestor = forEachAncestor;
    function forEachEntry(map, callback) {
      var iterator = map.entries();
      for (var iterResult = iterator.next(); !iterResult.done; iterResult = iterator.next()) {
        var _a = iterResult.value, key = _a[0], value = _a[1];
        var result = callback(value, key);
        if (result) {
          return result;
        }
      }
      return void 0;
    }
    ts2.forEachEntry = forEachEntry;
    function forEachKey(map, callback) {
      var iterator = map.keys();
      for (var iterResult = iterator.next(); !iterResult.done; iterResult = iterator.next()) {
        var result = callback(iterResult.value);
        if (result) {
          return result;
        }
      }
      return void 0;
    }
    ts2.forEachKey = forEachKey;
    function copyEntries(source, target) {
      source.forEach(function(value, key) {
        target.set(key, value);
      });
    }
    ts2.copyEntries = copyEntries;
    function usingSingleLineStringWriter(action) {
      var oldString = stringWriter.getText();
      try {
        action(stringWriter);
        return stringWriter.getText();
      } finally {
        stringWriter.clear();
        stringWriter.writeKeyword(oldString);
      }
    }
    ts2.usingSingleLineStringWriter = usingSingleLineStringWriter;
    function getFullWidth(node) {
      return node.end - node.pos;
    }
    ts2.getFullWidth = getFullWidth;
    function getResolvedModule(sourceFile, moduleNameText) {
      return sourceFile && sourceFile.resolvedModules && sourceFile.resolvedModules.get(moduleNameText);
    }
    ts2.getResolvedModule = getResolvedModule;
    function setResolvedModule(sourceFile, moduleNameText, resolvedModule) {
      if (!sourceFile.resolvedModules) {
        sourceFile.resolvedModules = new ts2.Map();
      }
      sourceFile.resolvedModules.set(moduleNameText, resolvedModule);
    }
    ts2.setResolvedModule = setResolvedModule;
    function setResolvedTypeReferenceDirective(sourceFile, typeReferenceDirectiveName, resolvedTypeReferenceDirective) {
      if (!sourceFile.resolvedTypeReferenceDirectiveNames) {
        sourceFile.resolvedTypeReferenceDirectiveNames = new ts2.Map();
      }
      sourceFile.resolvedTypeReferenceDirectiveNames.set(typeReferenceDirectiveName, resolvedTypeReferenceDirective);
    }
    ts2.setResolvedTypeReferenceDirective = setResolvedTypeReferenceDirective;
    function projectReferenceIsEqualTo(oldRef, newRef) {
      return oldRef.path === newRef.path && !oldRef.prepend === !newRef.prepend && !oldRef.circular === !newRef.circular;
    }
    ts2.projectReferenceIsEqualTo = projectReferenceIsEqualTo;
    function moduleResolutionIsEqualTo(oldResolution, newResolution) {
      return oldResolution.isExternalLibraryImport === newResolution.isExternalLibraryImport && oldResolution.extension === newResolution.extension && oldResolution.resolvedFileName === newResolution.resolvedFileName && oldResolution.originalPath === newResolution.originalPath && packageIdIsEqual(oldResolution.packageId, newResolution.packageId);
    }
    ts2.moduleResolutionIsEqualTo = moduleResolutionIsEqualTo;
    function packageIdIsEqual(a, b) {
      return a === b || !!a && !!b && a.name === b.name && a.subModuleName === b.subModuleName && a.version === b.version;
    }
    function packageIdToString(_a) {
      var name = _a.name, subModuleName = _a.subModuleName, version = _a.version;
      var fullName = subModuleName ? name + "/" + subModuleName : name;
      return fullName + "@" + version;
    }
    ts2.packageIdToString = packageIdToString;
    function typeDirectiveIsEqualTo(oldResolution, newResolution) {
      return oldResolution.resolvedFileName === newResolution.resolvedFileName && oldResolution.primary === newResolution.primary && oldResolution.originalPath === newResolution.originalPath;
    }
    ts2.typeDirectiveIsEqualTo = typeDirectiveIsEqualTo;
    function hasChangesInResolutions(names, newResolutions, oldResolutions, comparer) {
      ts2.Debug.assert(names.length === newResolutions.length);
      for (var i = 0; i < names.length; i++) {
        var newResolution = newResolutions[i];
        var oldResolution = oldResolutions && oldResolutions.get(names[i]);
        var changed = oldResolution ? !newResolution || !comparer(oldResolution, newResolution) : newResolution;
        if (changed) {
          return true;
        }
      }
      return false;
    }
    ts2.hasChangesInResolutions = hasChangesInResolutions;
    function containsParseError(node) {
      aggregateChildData(node);
      return (node.flags & 262144) !== 0;
    }
    ts2.containsParseError = containsParseError;
    function aggregateChildData(node) {
      if (!(node.flags & 524288)) {
        var thisNodeOrAnySubNodesHasError = (node.flags & 65536) !== 0 || ts2.forEachChild(node, containsParseError);
        if (thisNodeOrAnySubNodesHasError) {
          node.flags |= 262144;
        }
        node.flags |= 524288;
      }
    }
    function getSourceFileOfNode(node) {
      while (node && node.kind !== 300) {
        node = node.parent;
      }
      return node;
    }
    ts2.getSourceFileOfNode = getSourceFileOfNode;
    function getSourceFileOfModule(module2) {
      return getSourceFileOfNode(module2.valueDeclaration || getNonAugmentationDeclaration(module2));
    }
    ts2.getSourceFileOfModule = getSourceFileOfModule;
    function isStatementWithLocals(node) {
      switch (node.kind) {
        case 233:
        case 261:
        case 240:
        case 241:
        case 242:
          return true;
      }
      return false;
    }
    ts2.isStatementWithLocals = isStatementWithLocals;
    function getStartPositionOfLine(line, sourceFile) {
      ts2.Debug.assert(line >= 0);
      return ts2.getLineStarts(sourceFile)[line];
    }
    ts2.getStartPositionOfLine = getStartPositionOfLine;
    function nodePosToString(node) {
      var file = getSourceFileOfNode(node);
      var loc = ts2.getLineAndCharacterOfPosition(file, node.pos);
      return file.fileName + "(" + (loc.line + 1) + "," + (loc.character + 1) + ")";
    }
    ts2.nodePosToString = nodePosToString;
    function getEndLinePosition(line, sourceFile) {
      ts2.Debug.assert(line >= 0);
      var lineStarts = ts2.getLineStarts(sourceFile);
      var lineIndex = line;
      var sourceText = sourceFile.text;
      if (lineIndex + 1 === lineStarts.length) {
        return sourceText.length - 1;
      } else {
        var start = lineStarts[lineIndex];
        var pos = lineStarts[lineIndex + 1] - 1;
        ts2.Debug.assert(ts2.isLineBreak(sourceText.charCodeAt(pos)));
        while (start <= pos && ts2.isLineBreak(sourceText.charCodeAt(pos))) {
          pos--;
        }
        return pos;
      }
    }
    ts2.getEndLinePosition = getEndLinePosition;
    function isFileLevelUniqueName(sourceFile, name, hasGlobalName) {
      return !(hasGlobalName && hasGlobalName(name)) && !sourceFile.identifiers.has(name);
    }
    ts2.isFileLevelUniqueName = isFileLevelUniqueName;
    function nodeIsMissing(node) {
      if (node === void 0) {
        return true;
      }
      return node.pos === node.end && node.pos >= 0 && node.kind !== 1;
    }
    ts2.nodeIsMissing = nodeIsMissing;
    function nodeIsPresent(node) {
      return !nodeIsMissing(node);
    }
    ts2.nodeIsPresent = nodeIsPresent;
    function insertStatementsAfterPrologue(to, from, isPrologueDirective2) {
      if (from === void 0 || from.length === 0)
        return to;
      var statementIndex = 0;
      for (; statementIndex < to.length; ++statementIndex) {
        if (!isPrologueDirective2(to[statementIndex])) {
          break;
        }
      }
      to.splice.apply(to, __spreadArray([statementIndex, 0], from, false));
      return to;
    }
    function insertStatementAfterPrologue(to, statement, isPrologueDirective2) {
      if (statement === void 0)
        return to;
      var statementIndex = 0;
      for (; statementIndex < to.length; ++statementIndex) {
        if (!isPrologueDirective2(to[statementIndex])) {
          break;
        }
      }
      to.splice(statementIndex, 0, statement);
      return to;
    }
    function isAnyPrologueDirective(node) {
      return isPrologueDirective(node) || !!(getEmitFlags(node) & 1048576);
    }
    function insertStatementsAfterStandardPrologue(to, from) {
      return insertStatementsAfterPrologue(to, from, isPrologueDirective);
    }
    ts2.insertStatementsAfterStandardPrologue = insertStatementsAfterStandardPrologue;
    function insertStatementsAfterCustomPrologue(to, from) {
      return insertStatementsAfterPrologue(to, from, isAnyPrologueDirective);
    }
    ts2.insertStatementsAfterCustomPrologue = insertStatementsAfterCustomPrologue;
    function insertStatementAfterStandardPrologue(to, statement) {
      return insertStatementAfterPrologue(to, statement, isPrologueDirective);
    }
    ts2.insertStatementAfterStandardPrologue = insertStatementAfterStandardPrologue;
    function insertStatementAfterCustomPrologue(to, statement) {
      return insertStatementAfterPrologue(to, statement, isAnyPrologueDirective);
    }
    ts2.insertStatementAfterCustomPrologue = insertStatementAfterCustomPrologue;
    function isRecognizedTripleSlashComment(text, commentPos, commentEnd) {
      if (text.charCodeAt(commentPos + 1) === 47 && commentPos + 2 < commentEnd && text.charCodeAt(commentPos + 2) === 47) {
        var textSubStr = text.substring(commentPos, commentEnd);
        return ts2.fullTripleSlashReferencePathRegEx.test(textSubStr) || ts2.fullTripleSlashAMDReferencePathRegEx.test(textSubStr) || fullTripleSlashReferenceTypeReferenceDirectiveRegEx.test(textSubStr) || defaultLibReferenceRegEx.test(textSubStr) ? true : false;
      }
      return false;
    }
    ts2.isRecognizedTripleSlashComment = isRecognizedTripleSlashComment;
    function isPinnedComment(text, start) {
      return text.charCodeAt(start + 1) === 42 && text.charCodeAt(start + 2) === 33;
    }
    ts2.isPinnedComment = isPinnedComment;
    function createCommentDirectivesMap(sourceFile, commentDirectives) {
      var directivesByLine = new ts2.Map(commentDirectives.map(function(commentDirective) {
        return [
          "" + ts2.getLineAndCharacterOfPosition(sourceFile, commentDirective.range.end).line,
          commentDirective
        ];
      }));
      var usedLines = new ts2.Map();
      return { getUnusedExpectations, markUsed };
      function getUnusedExpectations() {
        return ts2.arrayFrom(directivesByLine.entries()).filter(function(_a) {
          var line = _a[0], directive = _a[1];
          return directive.type === 0 && !usedLines.get(line);
        }).map(function(_a) {
          var _ = _a[0], directive = _a[1];
          return directive;
        });
      }
      function markUsed(line) {
        if (!directivesByLine.has("" + line)) {
          return false;
        }
        usedLines.set("" + line, true);
        return true;
      }
    }
    ts2.createCommentDirectivesMap = createCommentDirectivesMap;
    function getTokenPosOfNode(node, sourceFile, includeJsDoc) {
      if (nodeIsMissing(node)) {
        return node.pos;
      }
      if (ts2.isJSDocNode(node) || node.kind === 11) {
        return ts2.skipTrivia((sourceFile || getSourceFileOfNode(node)).text, node.pos, false, true);
      }
      if (includeJsDoc && ts2.hasJSDocNodes(node)) {
        return getTokenPosOfNode(node.jsDoc[0], sourceFile);
      }
      if (node.kind === 343 && node._children.length > 0) {
        return getTokenPosOfNode(node._children[0], sourceFile, includeJsDoc);
      }
      return ts2.skipTrivia((sourceFile || getSourceFileOfNode(node)).text, node.pos, false, false, isInJSDoc(node));
    }
    ts2.getTokenPosOfNode = getTokenPosOfNode;
    function getNonDecoratorTokenPosOfNode(node, sourceFile) {
      if (nodeIsMissing(node) || !node.decorators) {
        return getTokenPosOfNode(node, sourceFile);
      }
      return ts2.skipTrivia((sourceFile || getSourceFileOfNode(node)).text, node.decorators.end);
    }
    ts2.getNonDecoratorTokenPosOfNode = getNonDecoratorTokenPosOfNode;
    function getSourceTextOfNodeFromSourceFile(sourceFile, node, includeTrivia) {
      if (includeTrivia === void 0) {
        includeTrivia = false;
      }
      return getTextOfNodeFromSourceText(sourceFile.text, node, includeTrivia);
    }
    ts2.getSourceTextOfNodeFromSourceFile = getSourceTextOfNodeFromSourceFile;
    function isJSDocTypeExpressionOrChild(node) {
      return !!ts2.findAncestor(node, ts2.isJSDocTypeExpression);
    }
    function isExportNamespaceAsDefaultDeclaration(node) {
      return !!(ts2.isExportDeclaration(node) && node.exportClause && ts2.isNamespaceExport(node.exportClause) && node.exportClause.name.escapedText === "default");
    }
    ts2.isExportNamespaceAsDefaultDeclaration = isExportNamespaceAsDefaultDeclaration;
    function getTextOfNodeFromSourceText(sourceText, node, includeTrivia) {
      if (includeTrivia === void 0) {
        includeTrivia = false;
      }
      if (nodeIsMissing(node)) {
        return "";
      }
      var text = sourceText.substring(includeTrivia ? node.pos : ts2.skipTrivia(sourceText, node.pos), node.end);
      if (isJSDocTypeExpressionOrChild(node)) {
        text = text.split(/\r\n|\n|\r/).map(function(line) {
          return ts2.trimStringStart(line.replace(/^\s*\*/, ""));
        }).join("\n");
      }
      return text;
    }
    ts2.getTextOfNodeFromSourceText = getTextOfNodeFromSourceText;
    function getTextOfNode(node, includeTrivia) {
      if (includeTrivia === void 0) {
        includeTrivia = false;
      }
      return getSourceTextOfNodeFromSourceFile(getSourceFileOfNode(node), node, includeTrivia);
    }
    ts2.getTextOfNode = getTextOfNode;
    function getPos(range) {
      return range.pos;
    }
    function indexOfNode(nodeArray, node) {
      return ts2.binarySearch(nodeArray, node, getPos, ts2.compareValues);
    }
    ts2.indexOfNode = indexOfNode;
    function getEmitFlags(node) {
      var emitNode = node.emitNode;
      return emitNode && emitNode.flags || 0;
    }
    ts2.getEmitFlags = getEmitFlags;
    ;
    function getScriptTargetFeatures() {
      return {
        es2015: {
          Array: ["find", "findIndex", "fill", "copyWithin", "entries", "keys", "values"],
          RegExp: ["flags", "sticky", "unicode"],
          Reflect: ["apply", "construct", "defineProperty", "deleteProperty", "get", " getOwnPropertyDescriptor", "getPrototypeOf", "has", "isExtensible", "ownKeys", "preventExtensions", "set", "setPrototypeOf"],
          ArrayConstructor: ["from", "of"],
          ObjectConstructor: ["assign", "getOwnPropertySymbols", "keys", "is", "setPrototypeOf"],
          NumberConstructor: ["isFinite", "isInteger", "isNaN", "isSafeInteger", "parseFloat", "parseInt"],
          Math: ["clz32", "imul", "sign", "log10", "log2", "log1p", "expm1", "cosh", "sinh", "tanh", "acosh", "asinh", "atanh", "hypot", "trunc", "fround", "cbrt"],
          Map: ["entries", "keys", "values"],
          Set: ["entries", "keys", "values"],
          Promise: ts2.emptyArray,
          PromiseConstructor: ["all", "race", "reject", "resolve"],
          Symbol: ["for", "keyFor"],
          WeakMap: ["entries", "keys", "values"],
          WeakSet: ["entries", "keys", "values"],
          Iterator: ts2.emptyArray,
          AsyncIterator: ts2.emptyArray,
          String: ["codePointAt", "includes", "endsWith", "normalize", "repeat", "startsWith", "anchor", "big", "blink", "bold", "fixed", "fontcolor", "fontsize", "italics", "link", "small", "strike", "sub", "sup"],
          StringConstructor: ["fromCodePoint", "raw"]
        },
        es2016: {
          Array: ["includes"]
        },
        es2017: {
          Atomics: ts2.emptyArray,
          SharedArrayBuffer: ts2.emptyArray,
          String: ["padStart", "padEnd"],
          ObjectConstructor: ["values", "entries", "getOwnPropertyDescriptors"],
          DateTimeFormat: ["formatToParts"]
        },
        es2018: {
          Promise: ["finally"],
          RegExpMatchArray: ["groups"],
          RegExpExecArray: ["groups"],
          RegExp: ["dotAll"],
          Intl: ["PluralRules"],
          AsyncIterable: ts2.emptyArray,
          AsyncIterableIterator: ts2.emptyArray,
          AsyncGenerator: ts2.emptyArray,
          AsyncGeneratorFunction: ts2.emptyArray
        },
        es2019: {
          Array: ["flat", "flatMap"],
          ObjectConstructor: ["fromEntries"],
          String: ["trimStart", "trimEnd", "trimLeft", "trimRight"],
          Symbol: ["description"]
        },
        es2020: {
          BigInt: ts2.emptyArray,
          BigInt64Array: ts2.emptyArray,
          BigUint64Array: ts2.emptyArray,
          PromiseConstructor: ["allSettled"],
          SymbolConstructor: ["matchAll"],
          String: ["matchAll"],
          DataView: ["setBigInt64", "setBigUint64", "getBigInt64", "getBigUint64"],
          RelativeTimeFormat: ["format", "formatToParts", "resolvedOptions"]
        },
        es2021: {
          PromiseConstructor: ["any"],
          String: ["replaceAll"]
        },
        esnext: {
          NumberFormat: ["formatToParts"]
        }
      };
    }
    ts2.getScriptTargetFeatures = getScriptTargetFeatures;
    var GetLiteralTextFlags;
    (function(GetLiteralTextFlags2) {
      GetLiteralTextFlags2[GetLiteralTextFlags2["None"] = 0] = "None";
      GetLiteralTextFlags2[GetLiteralTextFlags2["NeverAsciiEscape"] = 1] = "NeverAsciiEscape";
      GetLiteralTextFlags2[GetLiteralTextFlags2["JsxAttributeEscape"] = 2] = "JsxAttributeEscape";
      GetLiteralTextFlags2[GetLiteralTextFlags2["TerminateUnterminatedLiterals"] = 4] = "TerminateUnterminatedLiterals";
      GetLiteralTextFlags2[GetLiteralTextFlags2["AllowNumericSeparator"] = 8] = "AllowNumericSeparator";
    })(GetLiteralTextFlags = ts2.GetLiteralTextFlags || (ts2.GetLiteralTextFlags = {}));
    function getLiteralText(node, sourceFile, flags) {
      var _a;
      if (canUseOriginalText(node, flags)) {
        return getSourceTextOfNodeFromSourceFile(sourceFile, node);
      }
      switch (node.kind) {
        case 10: {
          var escapeText = flags & 2 ? escapeJsxAttributeString : flags & 1 || getEmitFlags(node) & 16777216 ? escapeString : escapeNonAsciiString;
          if (node.singleQuote) {
            return "'" + escapeText(node.text, 39) + "'";
          } else {
            return '"' + escapeText(node.text, 34) + '"';
          }
        }
        case 14:
        case 15:
        case 16:
        case 17: {
          var escapeText = flags & 1 || getEmitFlags(node) & 16777216 ? escapeString : escapeNonAsciiString;
          var rawText = (_a = node.rawText) !== null && _a !== void 0 ? _a : escapeTemplateSubstitution(escapeText(node.text, 96));
          switch (node.kind) {
            case 14:
              return "`" + rawText + "`";
            case 15:
              return "`" + rawText + "${";
            case 16:
              return "}" + rawText + "${";
            case 17:
              return "}" + rawText + "`";
          }
          break;
        }
        case 8:
        case 9:
          return node.text;
        case 13:
          if (flags & 4 && node.isUnterminated) {
            return node.text + (node.text.charCodeAt(node.text.length - 1) === 92 ? " /" : "/");
          }
          return node.text;
      }
      return ts2.Debug.fail("Literal kind '" + node.kind + "' not accounted for.");
    }
    ts2.getLiteralText = getLiteralText;
    function canUseOriginalText(node, flags) {
      if (nodeIsSynthesized(node) || !node.parent || flags & 4 && node.isUnterminated) {
        return false;
      }
      if (ts2.isNumericLiteral(node) && node.numericLiteralFlags & 512) {
        return !!(flags & 8);
      }
      return !ts2.isBigIntLiteral(node);
    }
    function getTextOfConstantValue(value) {
      return ts2.isString(value) ? '"' + escapeNonAsciiString(value) + '"' : "" + value;
    }
    ts2.getTextOfConstantValue = getTextOfConstantValue;
    function makeIdentifierFromModuleName(moduleName) {
      return ts2.getBaseFileName(moduleName).replace(/^(\d)/, "_$1").replace(/\W/g, "_");
    }
    ts2.makeIdentifierFromModuleName = makeIdentifierFromModuleName;
    function isBlockOrCatchScoped(declaration) {
      return (ts2.getCombinedNodeFlags(declaration) & 3) !== 0 || isCatchClauseVariableDeclarationOrBindingElement(declaration);
    }
    ts2.isBlockOrCatchScoped = isBlockOrCatchScoped;
    function isCatchClauseVariableDeclarationOrBindingElement(declaration) {
      var node = getRootDeclaration(declaration);
      return node.kind === 252 && node.parent.kind === 290;
    }
    ts2.isCatchClauseVariableDeclarationOrBindingElement = isCatchClauseVariableDeclarationOrBindingElement;
    function isAmbientModule(node) {
      return ts2.isModuleDeclaration(node) && (node.name.kind === 10 || isGlobalScopeAugmentation(node));
    }
    ts2.isAmbientModule = isAmbientModule;
    function isModuleWithStringLiteralName(node) {
      return ts2.isModuleDeclaration(node) && node.name.kind === 10;
    }
    ts2.isModuleWithStringLiteralName = isModuleWithStringLiteralName;
    function isNonGlobalAmbientModule(node) {
      return ts2.isModuleDeclaration(node) && ts2.isStringLiteral(node.name);
    }
    ts2.isNonGlobalAmbientModule = isNonGlobalAmbientModule;
    function isEffectiveModuleDeclaration(node) {
      return ts2.isModuleDeclaration(node) || ts2.isIdentifier(node);
    }
    ts2.isEffectiveModuleDeclaration = isEffectiveModuleDeclaration;
    function isShorthandAmbientModuleSymbol(moduleSymbol) {
      return isShorthandAmbientModule(moduleSymbol.valueDeclaration);
    }
    ts2.isShorthandAmbientModuleSymbol = isShorthandAmbientModuleSymbol;
    function isShorthandAmbientModule(node) {
      return !!node && node.kind === 259 && !node.body;
    }
    function isBlockScopedContainerTopLevel(node) {
      return node.kind === 300 || node.kind === 259 || ts2.isFunctionLikeOrClassStaticBlockDeclaration(node);
    }
    ts2.isBlockScopedContainerTopLevel = isBlockScopedContainerTopLevel;
    function isGlobalScopeAugmentation(module2) {
      return !!(module2.flags & 1024);
    }
    ts2.isGlobalScopeAugmentation = isGlobalScopeAugmentation;
    function isExternalModuleAugmentation(node) {
      return isAmbientModule(node) && isModuleAugmentationExternal(node);
    }
    ts2.isExternalModuleAugmentation = isExternalModuleAugmentation;
    function isModuleAugmentationExternal(node) {
      switch (node.parent.kind) {
        case 300:
          return ts2.isExternalModule(node.parent);
        case 260:
          return isAmbientModule(node.parent.parent) && ts2.isSourceFile(node.parent.parent.parent) && !ts2.isExternalModule(node.parent.parent.parent);
      }
      return false;
    }
    ts2.isModuleAugmentationExternal = isModuleAugmentationExternal;
    function getNonAugmentationDeclaration(symbol) {
      var _a;
      return (_a = symbol.declarations) === null || _a === void 0 ? void 0 : _a.find(function(d) {
        return !isExternalModuleAugmentation(d) && !(ts2.isModuleDeclaration(d) && isGlobalScopeAugmentation(d));
      });
    }
    ts2.getNonAugmentationDeclaration = getNonAugmentationDeclaration;
    function isEffectiveExternalModule(node, compilerOptions) {
      return ts2.isExternalModule(node) || compilerOptions.isolatedModules || getEmitModuleKind(compilerOptions) === ts2.ModuleKind.CommonJS && !!node.commonJsModuleIndicator;
    }
    ts2.isEffectiveExternalModule = isEffectiveExternalModule;
    function isEffectiveStrictModeSourceFile(node, compilerOptions) {
      switch (node.scriptKind) {
        case 1:
        case 3:
        case 2:
        case 4:
          break;
        default:
          return false;
      }
      if (node.isDeclarationFile) {
        return false;
      }
      if (getStrictOptionValue(compilerOptions, "alwaysStrict")) {
        return true;
      }
      if (ts2.startsWithUseStrict(node.statements)) {
        return true;
      }
      if (ts2.isExternalModule(node) || compilerOptions.isolatedModules) {
        if (getEmitModuleKind(compilerOptions) >= ts2.ModuleKind.ES2015) {
          return true;
        }
        return !compilerOptions.noImplicitUseStrict;
      }
      return false;
    }
    ts2.isEffectiveStrictModeSourceFile = isEffectiveStrictModeSourceFile;
    function isBlockScope(node, parentNode) {
      switch (node.kind) {
        case 300:
        case 261:
        case 290:
        case 259:
        case 240:
        case 241:
        case 242:
        case 169:
        case 167:
        case 170:
        case 171:
        case 254:
        case 211:
        case 212:
        case 165:
        case 168:
          return true;
        case 233:
          return !ts2.isFunctionLikeOrClassStaticBlockDeclaration(parentNode);
      }
      return false;
    }
    ts2.isBlockScope = isBlockScope;
    function isDeclarationWithTypeParameters(node) {
      switch (node.kind) {
        case 333:
        case 340:
        case 318:
          return true;
        default:
          ts2.assertType(node);
          return isDeclarationWithTypeParameterChildren(node);
      }
    }
    ts2.isDeclarationWithTypeParameters = isDeclarationWithTypeParameters;
    function isDeclarationWithTypeParameterChildren(node) {
      switch (node.kind) {
        case 172:
        case 173:
        case 166:
        case 174:
        case 177:
        case 178:
        case 312:
        case 255:
        case 224:
        case 256:
        case 257:
        case 339:
        case 254:
        case 167:
        case 169:
        case 170:
        case 171:
        case 211:
        case 212:
          return true;
        default:
          ts2.assertType(node);
          return false;
      }
    }
    ts2.isDeclarationWithTypeParameterChildren = isDeclarationWithTypeParameterChildren;
    function isAnyImportSyntax(node) {
      switch (node.kind) {
        case 264:
        case 263:
          return true;
        default:
          return false;
      }
    }
    ts2.isAnyImportSyntax = isAnyImportSyntax;
    function isLateVisibilityPaintedStatement(node) {
      switch (node.kind) {
        case 264:
        case 263:
        case 235:
        case 255:
        case 254:
        case 259:
        case 257:
        case 256:
        case 258:
          return true;
        default:
          return false;
      }
    }
    ts2.isLateVisibilityPaintedStatement = isLateVisibilityPaintedStatement;
    function hasPossibleExternalModuleReference(node) {
      return isAnyImportOrReExport(node) || ts2.isModuleDeclaration(node) || ts2.isImportTypeNode(node) || isImportCall(node);
    }
    ts2.hasPossibleExternalModuleReference = hasPossibleExternalModuleReference;
    function isAnyImportOrReExport(node) {
      return isAnyImportSyntax(node) || ts2.isExportDeclaration(node);
    }
    ts2.isAnyImportOrReExport = isAnyImportOrReExport;
    function getEnclosingBlockScopeContainer(node) {
      return ts2.findAncestor(node.parent, function(current) {
        return isBlockScope(current, current.parent);
      });
    }
    ts2.getEnclosingBlockScopeContainer = getEnclosingBlockScopeContainer;
    function forEachEnclosingBlockScopeContainer(node, cb) {
      var container = getEnclosingBlockScopeContainer(node);
      while (container) {
        cb(container);
        container = getEnclosingBlockScopeContainer(container);
      }
    }
    ts2.forEachEnclosingBlockScopeContainer = forEachEnclosingBlockScopeContainer;
    function declarationNameToString(name) {
      return !name || getFullWidth(name) === 0 ? "(Missing)" : getTextOfNode(name);
    }
    ts2.declarationNameToString = declarationNameToString;
    function getNameFromIndexInfo(info) {
      return info.declaration ? declarationNameToString(info.declaration.parameters[0].name) : void 0;
    }
    ts2.getNameFromIndexInfo = getNameFromIndexInfo;
    function isComputedNonLiteralName(name) {
      return name.kind === 160 && !isStringOrNumericLiteralLike(name.expression);
    }
    ts2.isComputedNonLiteralName = isComputedNonLiteralName;
    function getTextOfPropertyName(name) {
      switch (name.kind) {
        case 79:
        case 80:
          return name.escapedText;
        case 10:
        case 8:
        case 14:
          return ts2.escapeLeadingUnderscores(name.text);
        case 160:
          if (isStringOrNumericLiteralLike(name.expression))
            return ts2.escapeLeadingUnderscores(name.expression.text);
          return ts2.Debug.fail("Text of property name cannot be read from non-literal-valued ComputedPropertyNames");
        default:
          return ts2.Debug.assertNever(name);
      }
    }
    ts2.getTextOfPropertyName = getTextOfPropertyName;
    function entityNameToString(name) {
      switch (name.kind) {
        case 108:
          return "this";
        case 80:
        case 79:
          return getFullWidth(name) === 0 ? ts2.idText(name) : getTextOfNode(name);
        case 159:
          return entityNameToString(name.left) + "." + entityNameToString(name.right);
        case 204:
          if (ts2.isIdentifier(name.name) || ts2.isPrivateIdentifier(name.name)) {
            return entityNameToString(name.expression) + "." + entityNameToString(name.name);
          } else {
            return ts2.Debug.assertNever(name.name);
          }
        case 306:
          return entityNameToString(name.left) + entityNameToString(name.right);
        default:
          return ts2.Debug.assertNever(name);
      }
    }
    ts2.entityNameToString = entityNameToString;
    function createDiagnosticForNode(node, message, arg0, arg1, arg2, arg3) {
      var sourceFile = getSourceFileOfNode(node);
      return createDiagnosticForNodeInSourceFile(sourceFile, node, message, arg0, arg1, arg2, arg3);
    }
    ts2.createDiagnosticForNode = createDiagnosticForNode;
    function createDiagnosticForNodeArray(sourceFile, nodes, message, arg0, arg1, arg2, arg3) {
      var start = ts2.skipTrivia(sourceFile.text, nodes.pos);
      return createFileDiagnostic(sourceFile, start, nodes.end - start, message, arg0, arg1, arg2, arg3);
    }
    ts2.createDiagnosticForNodeArray = createDiagnosticForNodeArray;
    function createDiagnosticForNodeInSourceFile(sourceFile, node, message, arg0, arg1, arg2, arg3) {
      var span = getErrorSpanForNode(sourceFile, node);
      return createFileDiagnostic(sourceFile, span.start, span.length, message, arg0, arg1, arg2, arg3);
    }
    ts2.createDiagnosticForNodeInSourceFile = createDiagnosticForNodeInSourceFile;
    function createDiagnosticForNodeFromMessageChain(node, messageChain, relatedInformation) {
      var sourceFile = getSourceFileOfNode(node);
      var span = getErrorSpanForNode(sourceFile, node);
      return createFileDiagnosticFromMessageChain(sourceFile, span.start, span.length, messageChain, relatedInformation);
    }
    ts2.createDiagnosticForNodeFromMessageChain = createDiagnosticForNodeFromMessageChain;
    function assertDiagnosticLocation(file, start, length) {
      ts2.Debug.assertGreaterThanOrEqual(start, 0);
      ts2.Debug.assertGreaterThanOrEqual(length, 0);
      if (file) {
        ts2.Debug.assertLessThanOrEqual(start, file.text.length);
        ts2.Debug.assertLessThanOrEqual(start + length, file.text.length);
      }
    }
    function createFileDiagnosticFromMessageChain(file, start, length, messageChain, relatedInformation) {
      assertDiagnosticLocation(file, start, length);
      return {
        file,
        start,
        length,
        code: messageChain.code,
        category: messageChain.category,
        messageText: messageChain.next ? messageChain : messageChain.messageText,
        relatedInformation
      };
    }
    ts2.createFileDiagnosticFromMessageChain = createFileDiagnosticFromMessageChain;
    function createDiagnosticForFileFromMessageChain(sourceFile, messageChain, relatedInformation) {
      return {
        file: sourceFile,
        start: 0,
        length: 0,
        code: messageChain.code,
        category: messageChain.category,
        messageText: messageChain.next ? messageChain : messageChain.messageText,
        relatedInformation
      };
    }
    ts2.createDiagnosticForFileFromMessageChain = createDiagnosticForFileFromMessageChain;
    function createDiagnosticForRange(sourceFile, range, message) {
      return {
        file: sourceFile,
        start: range.pos,
        length: range.end - range.pos,
        code: message.code,
        category: message.category,
        messageText: message.message
      };
    }
    ts2.createDiagnosticForRange = createDiagnosticForRange;
    function getSpanOfTokenAtPosition(sourceFile, pos) {
      var scanner = ts2.createScanner(sourceFile.languageVersion, true, sourceFile.languageVariant, sourceFile.text, void 0, pos);
      scanner.scan();
      var start = scanner.getTokenPos();
      return ts2.createTextSpanFromBounds(start, scanner.getTextPos());
    }
    ts2.getSpanOfTokenAtPosition = getSpanOfTokenAtPosition;
    function getErrorSpanForArrowFunction(sourceFile, node) {
      var pos = ts2.skipTrivia(sourceFile.text, node.pos);
      if (node.body && node.body.kind === 233) {
        var startLine = ts2.getLineAndCharacterOfPosition(sourceFile, node.body.pos).line;
        var endLine = ts2.getLineAndCharacterOfPosition(sourceFile, node.body.end).line;
        if (startLine < endLine) {
          return ts2.createTextSpan(pos, getEndLinePosition(startLine, sourceFile) - pos + 1);
        }
      }
      return ts2.createTextSpanFromBounds(pos, node.end);
    }
    function getErrorSpanForNode(sourceFile, node) {
      var errorNode = node;
      switch (node.kind) {
        case 300:
          var pos_1 = ts2.skipTrivia(sourceFile.text, 0, false);
          if (pos_1 === sourceFile.text.length) {
            return ts2.createTextSpan(0, 0);
          }
          return getSpanOfTokenAtPosition(sourceFile, pos_1);
        case 252:
        case 201:
        case 255:
        case 224:
        case 256:
        case 259:
        case 258:
        case 294:
        case 254:
        case 211:
        case 167:
        case 170:
        case 171:
        case 257:
        case 165:
        case 164:
        case 266:
          errorNode = node.name;
          break;
        case 212:
          return getErrorSpanForArrowFunction(sourceFile, node);
        case 287:
        case 288:
          var start = ts2.skipTrivia(sourceFile.text, node.pos);
          var end = node.statements.length > 0 ? node.statements[0].pos : node.end;
          return ts2.createTextSpanFromBounds(start, end);
      }
      if (errorNode === void 0) {
        return getSpanOfTokenAtPosition(sourceFile, node.pos);
      }
      ts2.Debug.assert(!ts2.isJSDoc(errorNode));
      var isMissing = nodeIsMissing(errorNode);
      var pos = isMissing || ts2.isJsxText(node) ? errorNode.pos : ts2.skipTrivia(sourceFile.text, errorNode.pos);
      if (isMissing) {
        ts2.Debug.assert(pos === errorNode.pos, "This failure could trigger https://github.com/Microsoft/TypeScript/issues/20809");
        ts2.Debug.assert(pos === errorNode.end, "This failure could trigger https://github.com/Microsoft/TypeScript/issues/20809");
      } else {
        ts2.Debug.assert(pos >= errorNode.pos, "This failure could trigger https://github.com/Microsoft/TypeScript/issues/20809");
        ts2.Debug.assert(pos <= errorNode.end, "This failure could trigger https://github.com/Microsoft/TypeScript/issues/20809");
      }
      return ts2.createTextSpanFromBounds(pos, errorNode.end);
    }
    ts2.getErrorSpanForNode = getErrorSpanForNode;
    function isExternalOrCommonJsModule(file) {
      return (file.externalModuleIndicator || file.commonJsModuleIndicator) !== void 0;
    }
    ts2.isExternalOrCommonJsModule = isExternalOrCommonJsModule;
    function isJsonSourceFile(file) {
      return file.scriptKind === 6;
    }
    ts2.isJsonSourceFile = isJsonSourceFile;
    function isEnumConst(node) {
      return !!(ts2.getCombinedModifierFlags(node) & 2048);
    }
    ts2.isEnumConst = isEnumConst;
    function isDeclarationReadonly(declaration) {
      return !!(ts2.getCombinedModifierFlags(declaration) & 64 && !ts2.isParameterPropertyDeclaration(declaration, declaration.parent));
    }
    ts2.isDeclarationReadonly = isDeclarationReadonly;
    function isVarConst(node) {
      return !!(ts2.getCombinedNodeFlags(node) & 2);
    }
    ts2.isVarConst = isVarConst;
    function isLet(node) {
      return !!(ts2.getCombinedNodeFlags(node) & 1);
    }
    ts2.isLet = isLet;
    function isSuperCall(n) {
      return n.kind === 206 && n.expression.kind === 106;
    }
    ts2.isSuperCall = isSuperCall;
    function isImportCall(n) {
      return n.kind === 206 && n.expression.kind === 100;
    }
    ts2.isImportCall = isImportCall;
    function isImportMeta(n) {
      return ts2.isMetaProperty(n) && n.keywordToken === 100 && n.name.escapedText === "meta";
    }
    ts2.isImportMeta = isImportMeta;
    function isLiteralImportTypeNode(n) {
      return ts2.isImportTypeNode(n) && ts2.isLiteralTypeNode(n.argument) && ts2.isStringLiteral(n.argument.literal);
    }
    ts2.isLiteralImportTypeNode = isLiteralImportTypeNode;
    function isPrologueDirective(node) {
      return node.kind === 236 && node.expression.kind === 10;
    }
    ts2.isPrologueDirective = isPrologueDirective;
    function isCustomPrologue(node) {
      return !!(getEmitFlags(node) & 1048576);
    }
    ts2.isCustomPrologue = isCustomPrologue;
    function isHoistedFunction(node) {
      return isCustomPrologue(node) && ts2.isFunctionDeclaration(node);
    }
    ts2.isHoistedFunction = isHoistedFunction;
    function isHoistedVariable(node) {
      return ts2.isIdentifier(node.name) && !node.initializer;
    }
    function isHoistedVariableStatement(node) {
      return isCustomPrologue(node) && ts2.isVariableStatement(node) && ts2.every(node.declarationList.declarations, isHoistedVariable);
    }
    ts2.isHoistedVariableStatement = isHoistedVariableStatement;
    function getLeadingCommentRangesOfNode(node, sourceFileOfNode) {
      return node.kind !== 11 ? ts2.getLeadingCommentRanges(sourceFileOfNode.text, node.pos) : void 0;
    }
    ts2.getLeadingCommentRangesOfNode = getLeadingCommentRangesOfNode;
    function getJSDocCommentRanges(node, text) {
      var commentRanges = node.kind === 162 || node.kind === 161 || node.kind === 211 || node.kind === 212 || node.kind === 210 || node.kind === 252 ? ts2.concatenate(ts2.getTrailingCommentRanges(text, node.pos), ts2.getLeadingCommentRanges(text, node.pos)) : ts2.getLeadingCommentRanges(text, node.pos);
      return ts2.filter(commentRanges, function(comment) {
        return text.charCodeAt(comment.pos + 1) === 42 && text.charCodeAt(comment.pos + 2) === 42 && text.charCodeAt(comment.pos + 3) !== 47;
      });
    }
    ts2.getJSDocCommentRanges = getJSDocCommentRanges;
    ts2.fullTripleSlashReferencePathRegEx = /^(\/\/\/\s*<reference\s+path\s*=\s*)(('[^']*')|("[^"]*")).*?\/>/;
    var fullTripleSlashReferenceTypeReferenceDirectiveRegEx = /^(\/\/\/\s*<reference\s+types\s*=\s*)(('[^']*')|("[^"]*")).*?\/>/;
    ts2.fullTripleSlashAMDReferencePathRegEx = /^(\/\/\/\s*<amd-dependency\s+path\s*=\s*)(('[^']*')|("[^"]*")).*?\/>/;
    var defaultLibReferenceRegEx = /^(\/\/\/\s*<reference\s+no-default-lib\s*=\s*)(('[^']*')|("[^"]*"))\s*\/>/;
    function isPartOfTypeNode(node) {
      if (175 <= node.kind && node.kind <= 198) {
        return true;
      }
      switch (node.kind) {
        case 129:
        case 153:
        case 145:
        case 156:
        case 148:
        case 132:
        case 149:
        case 146:
        case 151:
        case 142:
          return true;
        case 114:
          return node.parent.kind !== 215;
        case 226:
          return !isExpressionWithTypeArgumentsInClassExtendsClause(node);
        case 161:
          return node.parent.kind === 193 || node.parent.kind === 188;
        case 79:
          if (node.parent.kind === 159 && node.parent.right === node) {
            node = node.parent;
          } else if (node.parent.kind === 204 && node.parent.name === node) {
            node = node.parent;
          }
          ts2.Debug.assert(node.kind === 79 || node.kind === 159 || node.kind === 204, "'node' was expected to be a qualified name, identifier or property access in 'isPartOfTypeNode'.");
        case 159:
        case 204:
        case 108: {
          var parent = node.parent;
          if (parent.kind === 179) {
            return false;
          }
          if (parent.kind === 198) {
            return !parent.isTypeOf;
          }
          if (175 <= parent.kind && parent.kind <= 198) {
            return true;
          }
          switch (parent.kind) {
            case 226:
              return !isExpressionWithTypeArgumentsInClassExtendsClause(parent);
            case 161:
              return node === parent.constraint;
            case 339:
              return node === parent.constraint;
            case 165:
            case 164:
            case 162:
            case 252:
              return node === parent.type;
            case 254:
            case 211:
            case 212:
            case 169:
            case 167:
            case 166:
            case 170:
            case 171:
              return node === parent.type;
            case 172:
            case 173:
            case 174:
              return node === parent.type;
            case 209:
              return node === parent.type;
            case 206:
            case 207:
              return ts2.contains(parent.typeArguments, node);
            case 208:
              return false;
          }
        }
      }
      return false;
    }
    ts2.isPartOfTypeNode = isPartOfTypeNode;
    function isChildOfNodeWithKind(node, kind) {
      while (node) {
        if (node.kind === kind) {
          return true;
        }
        node = node.parent;
      }
      return false;
    }
    ts2.isChildOfNodeWithKind = isChildOfNodeWithKind;
    function forEachReturnStatement(body, visitor) {
      return traverse(body);
      function traverse(node) {
        switch (node.kind) {
          case 245:
            return visitor(node);
          case 261:
          case 233:
          case 237:
          case 238:
          case 239:
          case 240:
          case 241:
          case 242:
          case 246:
          case 247:
          case 287:
          case 288:
          case 248:
          case 250:
          case 290:
            return ts2.forEachChild(node, traverse);
        }
      }
    }
    ts2.forEachReturnStatement = forEachReturnStatement;
    function forEachYieldExpression(body, visitor) {
      return traverse(body);
      function traverse(node) {
        switch (node.kind) {
          case 222:
            visitor(node);
            var operand = node.expression;
            if (operand) {
              traverse(operand);
            }
            return;
          case 258:
          case 256:
          case 259:
          case 257:
            return;
          default:
            if (ts2.isFunctionLike(node)) {
              if (node.name && node.name.kind === 160) {
                traverse(node.name.expression);
                return;
              }
            } else if (!isPartOfTypeNode(node)) {
              ts2.forEachChild(node, traverse);
            }
        }
      }
    }
    ts2.forEachYieldExpression = forEachYieldExpression;
    function getRestParameterElementType(node) {
      if (node && node.kind === 181) {
        return node.elementType;
      } else if (node && node.kind === 176) {
        return ts2.singleOrUndefined(node.typeArguments);
      } else {
        return void 0;
      }
    }
    ts2.getRestParameterElementType = getRestParameterElementType;
    function getMembersOfDeclaration(node) {
      switch (node.kind) {
        case 256:
        case 255:
        case 224:
        case 180:
          return node.members;
        case 203:
          return node.properties;
      }
    }
    ts2.getMembersOfDeclaration = getMembersOfDeclaration;
    function isVariableLike(node) {
      if (node) {
        switch (node.kind) {
          case 201:
          case 294:
          case 162:
          case 291:
          case 165:
          case 164:
          case 292:
          case 252:
            return true;
        }
      }
      return false;
    }
    ts2.isVariableLike = isVariableLike;
    function isVariableLikeOrAccessor(node) {
      return isVariableLike(node) || ts2.isAccessor(node);
    }
    ts2.isVariableLikeOrAccessor = isVariableLikeOrAccessor;
    function isVariableDeclarationInVariableStatement(node) {
      return node.parent.kind === 253 && node.parent.parent.kind === 235;
    }
    ts2.isVariableDeclarationInVariableStatement = isVariableDeclarationInVariableStatement;
    function isValidESSymbolDeclaration(node) {
      return ts2.isVariableDeclaration(node) ? isVarConst(node) && ts2.isIdentifier(node.name) && isVariableDeclarationInVariableStatement(node) : ts2.isPropertyDeclaration(node) ? hasEffectiveReadonlyModifier(node) && hasStaticModifier(node) : ts2.isPropertySignature(node) && hasEffectiveReadonlyModifier(node);
    }
    ts2.isValidESSymbolDeclaration = isValidESSymbolDeclaration;
    function introducesArgumentsExoticObject(node) {
      switch (node.kind) {
        case 167:
        case 166:
        case 169:
        case 170:
        case 171:
        case 254:
        case 211:
          return true;
      }
      return false;
    }
    ts2.introducesArgumentsExoticObject = introducesArgumentsExoticObject;
    function unwrapInnermostStatementOfLabel(node, beforeUnwrapLabelCallback) {
      while (true) {
        if (beforeUnwrapLabelCallback) {
          beforeUnwrapLabelCallback(node);
        }
        if (node.statement.kind !== 248) {
          return node.statement;
        }
        node = node.statement;
      }
    }
    ts2.unwrapInnermostStatementOfLabel = unwrapInnermostStatementOfLabel;
    function isFunctionBlock(node) {
      return node && node.kind === 233 && ts2.isFunctionLike(node.parent);
    }
    ts2.isFunctionBlock = isFunctionBlock;
    function isObjectLiteralMethod(node) {
      return node && node.kind === 167 && node.parent.kind === 203;
    }
    ts2.isObjectLiteralMethod = isObjectLiteralMethod;
    function isObjectLiteralOrClassExpressionMethod(node) {
      return node.kind === 167 && (node.parent.kind === 203 || node.parent.kind === 224);
    }
    ts2.isObjectLiteralOrClassExpressionMethod = isObjectLiteralOrClassExpressionMethod;
    function isIdentifierTypePredicate(predicate) {
      return predicate && predicate.kind === 1;
    }
    ts2.isIdentifierTypePredicate = isIdentifierTypePredicate;
    function isThisTypePredicate(predicate) {
      return predicate && predicate.kind === 0;
    }
    ts2.isThisTypePredicate = isThisTypePredicate;
    function getPropertyAssignment(objectLiteral, key, key2) {
      return objectLiteral.properties.filter(function(property) {
        if (property.kind === 291) {
          var propName = getTextOfPropertyName(property.name);
          return key === propName || !!key2 && key2 === propName;
        }
        return false;
      });
    }
    ts2.getPropertyAssignment = getPropertyAssignment;
    function getPropertyArrayElementValue(objectLiteral, propKey, elementValue) {
      return ts2.firstDefined(getPropertyAssignment(objectLiteral, propKey), function(property) {
        return ts2.isArrayLiteralExpression(property.initializer) ? ts2.find(property.initializer.elements, function(element) {
          return ts2.isStringLiteral(element) && element.text === elementValue;
        }) : void 0;
      });
    }
    ts2.getPropertyArrayElementValue = getPropertyArrayElementValue;
    function getTsConfigObjectLiteralExpression(tsConfigSourceFile) {
      if (tsConfigSourceFile && tsConfigSourceFile.statements.length) {
        var expression = tsConfigSourceFile.statements[0].expression;
        return ts2.tryCast(expression, ts2.isObjectLiteralExpression);
      }
    }
    ts2.getTsConfigObjectLiteralExpression = getTsConfigObjectLiteralExpression;
    function getTsConfigPropArrayElementValue(tsConfigSourceFile, propKey, elementValue) {
      return ts2.firstDefined(getTsConfigPropArray(tsConfigSourceFile, propKey), function(property) {
        return ts2.isArrayLiteralExpression(property.initializer) ? ts2.find(property.initializer.elements, function(element) {
          return ts2.isStringLiteral(element) && element.text === elementValue;
        }) : void 0;
      });
    }
    ts2.getTsConfigPropArrayElementValue = getTsConfigPropArrayElementValue;
    function getTsConfigPropArray(tsConfigSourceFile, propKey) {
      var jsonObjectLiteral = getTsConfigObjectLiteralExpression(tsConfigSourceFile);
      return jsonObjectLiteral ? getPropertyAssignment(jsonObjectLiteral, propKey) : ts2.emptyArray;
    }
    ts2.getTsConfigPropArray = getTsConfigPropArray;
    function getContainingFunction(node) {
      return ts2.findAncestor(node.parent, ts2.isFunctionLike);
    }
    ts2.getContainingFunction = getContainingFunction;
    function getContainingFunctionDeclaration(node) {
      return ts2.findAncestor(node.parent, ts2.isFunctionLikeDeclaration);
    }
    ts2.getContainingFunctionDeclaration = getContainingFunctionDeclaration;
    function getContainingClass(node) {
      return ts2.findAncestor(node.parent, ts2.isClassLike);
    }
    ts2.getContainingClass = getContainingClass;
    function getContainingClassStaticBlock(node) {
      return ts2.findAncestor(node.parent, function(n) {
        if (ts2.isClassLike(n) || ts2.isFunctionLike(n)) {
          return "quit";
        }
        return ts2.isClassStaticBlockDeclaration(n);
      });
    }
    ts2.getContainingClassStaticBlock = getContainingClassStaticBlock;
    function getContainingFunctionOrClassStaticBlock(node) {
      return ts2.findAncestor(node.parent, ts2.isFunctionLikeOrClassStaticBlockDeclaration);
    }
    ts2.getContainingFunctionOrClassStaticBlock = getContainingFunctionOrClassStaticBlock;
    function getThisContainer(node, includeArrowFunctions) {
      ts2.Debug.assert(node.kind !== 300);
      while (true) {
        node = node.parent;
        if (!node) {
          return ts2.Debug.fail();
        }
        switch (node.kind) {
          case 160:
            if (ts2.isClassLike(node.parent.parent)) {
              return node;
            }
            node = node.parent;
            break;
          case 163:
            if (node.parent.kind === 162 && ts2.isClassElement(node.parent.parent)) {
              node = node.parent.parent;
            } else if (ts2.isClassElement(node.parent)) {
              node = node.parent;
            }
            break;
          case 212:
            if (!includeArrowFunctions) {
              continue;
            }
          case 254:
          case 211:
          case 259:
          case 168:
          case 165:
          case 164:
          case 167:
          case 166:
          case 169:
          case 170:
          case 171:
          case 172:
          case 173:
          case 174:
          case 258:
          case 300:
            return node;
        }
      }
    }
    ts2.getThisContainer = getThisContainer;
    function isInTopLevelContext(node) {
      if (ts2.isIdentifier(node) && (ts2.isClassDeclaration(node.parent) || ts2.isFunctionDeclaration(node.parent)) && node.parent.name === node) {
        node = node.parent;
      }
      var container = getThisContainer(node, true);
      return ts2.isSourceFile(container);
    }
    ts2.isInTopLevelContext = isInTopLevelContext;
    function getNewTargetContainer(node) {
      var container = getThisContainer(node, false);
      if (container) {
        switch (container.kind) {
          case 169:
          case 254:
          case 211:
            return container;
        }
      }
      return void 0;
    }
    ts2.getNewTargetContainer = getNewTargetContainer;
    function getSuperContainer(node, stopOnFunctions) {
      while (true) {
        node = node.parent;
        if (!node) {
          return node;
        }
        switch (node.kind) {
          case 160:
            node = node.parent;
            break;
          case 254:
          case 211:
          case 212:
            if (!stopOnFunctions) {
              continue;
            }
          case 165:
          case 164:
          case 167:
          case 166:
          case 169:
          case 170:
          case 171:
          case 168:
            return node;
          case 163:
            if (node.parent.kind === 162 && ts2.isClassElement(node.parent.parent)) {
              node = node.parent.parent;
            } else if (ts2.isClassElement(node.parent)) {
              node = node.parent;
            }
            break;
        }
      }
    }
    ts2.getSuperContainer = getSuperContainer;
    function getImmediatelyInvokedFunctionExpression(func) {
      if (func.kind === 211 || func.kind === 212) {
        var prev = func;
        var parent = func.parent;
        while (parent.kind === 210) {
          prev = parent;
          parent = parent.parent;
        }
        if (parent.kind === 206 && parent.expression === prev) {
          return parent;
        }
      }
    }
    ts2.getImmediatelyInvokedFunctionExpression = getImmediatelyInvokedFunctionExpression;
    function isSuperOrSuperProperty(node) {
      return node.kind === 106 || isSuperProperty(node);
    }
    ts2.isSuperOrSuperProperty = isSuperOrSuperProperty;
    function isSuperProperty(node) {
      var kind = node.kind;
      return (kind === 204 || kind === 205) && node.expression.kind === 106;
    }
    ts2.isSuperProperty = isSuperProperty;
    function isThisProperty(node) {
      var kind = node.kind;
      return (kind === 204 || kind === 205) && node.expression.kind === 108;
    }
    ts2.isThisProperty = isThisProperty;
    function isThisInitializedDeclaration(node) {
      var _a;
      return !!node && ts2.isVariableDeclaration(node) && ((_a = node.initializer) === null || _a === void 0 ? void 0 : _a.kind) === 108;
    }
    ts2.isThisInitializedDeclaration = isThisInitializedDeclaration;
    function isThisInitializedObjectBindingExpression(node) {
      return !!node && (ts2.isShorthandPropertyAssignment(node) || ts2.isPropertyAssignment(node)) && ts2.isBinaryExpression(node.parent.parent) && node.parent.parent.operatorToken.kind === 63 && node.parent.parent.right.kind === 108;
    }
    ts2.isThisInitializedObjectBindingExpression = isThisInitializedObjectBindingExpression;
    function getEntityNameFromTypeNode(node) {
      switch (node.kind) {
        case 176:
          return node.typeName;
        case 226:
          return isEntityNameExpression(node.expression) ? node.expression : void 0;
        case 79:
        case 159:
          return node;
      }
      return void 0;
    }
    ts2.getEntityNameFromTypeNode = getEntityNameFromTypeNode;
    function getInvokedExpression(node) {
      switch (node.kind) {
        case 208:
          return node.tag;
        case 278:
        case 277:
          return node.tagName;
        default:
          return node.expression;
      }
    }
    ts2.getInvokedExpression = getInvokedExpression;
    function nodeCanBeDecorated(node, parent, grandparent) {
      if (ts2.isNamedDeclaration(node) && ts2.isPrivateIdentifier(node.name)) {
        return false;
      }
      switch (node.kind) {
        case 255:
          return true;
        case 165:
          return parent.kind === 255;
        case 170:
        case 171:
        case 167:
          return node.body !== void 0 && parent.kind === 255;
        case 162:
          return parent.body !== void 0 && (parent.kind === 169 || parent.kind === 167 || parent.kind === 171) && grandparent.kind === 255;
      }
      return false;
    }
    ts2.nodeCanBeDecorated = nodeCanBeDecorated;
    function nodeIsDecorated(node, parent, grandparent) {
      return node.decorators !== void 0 && nodeCanBeDecorated(node, parent, grandparent);
    }
    ts2.nodeIsDecorated = nodeIsDecorated;
    function nodeOrChildIsDecorated(node, parent, grandparent) {
      return nodeIsDecorated(node, parent, grandparent) || childIsDecorated(node, parent);
    }
    ts2.nodeOrChildIsDecorated = nodeOrChildIsDecorated;
    function childIsDecorated(node, parent) {
      switch (node.kind) {
        case 255:
          return ts2.some(node.members, function(m) {
            return nodeOrChildIsDecorated(m, node, parent);
          });
        case 167:
        case 171:
        case 169:
          return ts2.some(node.parameters, function(p) {
            return nodeIsDecorated(p, node, parent);
          });
        default:
          return false;
      }
    }
    ts2.childIsDecorated = childIsDecorated;
    function classOrConstructorParameterIsDecorated(node) {
      if (nodeIsDecorated(node))
        return true;
      var constructor = getFirstConstructorWithBody(node);
      return !!constructor && childIsDecorated(constructor, node);
    }
    ts2.classOrConstructorParameterIsDecorated = classOrConstructorParameterIsDecorated;
    function isJSXTagName(node) {
      var parent = node.parent;
      if (parent.kind === 278 || parent.kind === 277 || parent.kind === 279) {
        return parent.tagName === node;
      }
      return false;
    }
    ts2.isJSXTagName = isJSXTagName;
    function isExpressionNode(node) {
      switch (node.kind) {
        case 106:
        case 104:
        case 110:
        case 95:
        case 13:
        case 202:
        case 203:
        case 204:
        case 205:
        case 206:
        case 207:
        case 208:
        case 227:
        case 209:
        case 228:
        case 210:
        case 211:
        case 224:
        case 212:
        case 215:
        case 213:
        case 214:
        case 217:
        case 218:
        case 219:
        case 220:
        case 223:
        case 221:
        case 225:
        case 276:
        case 277:
        case 280:
        case 222:
        case 216:
        case 229:
          return true;
        case 159:
          while (node.parent.kind === 159) {
            node = node.parent;
          }
          return node.parent.kind === 179 || ts2.isJSDocLinkLike(node.parent) || ts2.isJSDocNameReference(node.parent) || ts2.isJSDocMemberName(node.parent) || isJSXTagName(node);
        case 306:
          while (ts2.isJSDocMemberName(node.parent)) {
            node = node.parent;
          }
          return node.parent.kind === 179 || ts2.isJSDocLinkLike(node.parent) || ts2.isJSDocNameReference(node.parent) || ts2.isJSDocMemberName(node.parent) || isJSXTagName(node);
        case 79:
          if (node.parent.kind === 179 || ts2.isJSDocLinkLike(node.parent) || ts2.isJSDocNameReference(node.parent) || ts2.isJSDocMemberName(node.parent) || isJSXTagName(node)) {
            return true;
          }
        case 8:
        case 9:
        case 10:
        case 14:
        case 108:
          return isInExpressionContext(node);
        default:
          return false;
      }
    }
    ts2.isExpressionNode = isExpressionNode;
    function isInExpressionContext(node) {
      var parent = node.parent;
      switch (parent.kind) {
        case 252:
        case 162:
        case 165:
        case 164:
        case 294:
        case 291:
        case 201:
          return parent.initializer === node;
        case 236:
        case 237:
        case 238:
        case 239:
        case 245:
        case 246:
        case 247:
        case 287:
        case 249:
          return parent.expression === node;
        case 240:
          var forStatement = parent;
          return forStatement.initializer === node && forStatement.initializer.kind !== 253 || forStatement.condition === node || forStatement.incrementor === node;
        case 241:
        case 242:
          var forInStatement = parent;
          return forInStatement.initializer === node && forInStatement.initializer.kind !== 253 || forInStatement.expression === node;
        case 209:
        case 227:
          return node === parent.expression;
        case 231:
          return node === parent.expression;
        case 160:
          return node === parent.expression;
        case 163:
        case 286:
        case 285:
        case 293:
          return true;
        case 226:
          return parent.expression === node && isExpressionWithTypeArgumentsInClassExtendsClause(parent);
        case 292:
          return parent.objectAssignmentInitializer === node;
        default:
          return isExpressionNode(parent);
      }
    }
    ts2.isInExpressionContext = isInExpressionContext;
    function isPartOfTypeQuery(node) {
      while (node.kind === 159 || node.kind === 79) {
        node = node.parent;
      }
      return node.kind === 179;
    }
    ts2.isPartOfTypeQuery = isPartOfTypeQuery;
    function isNamespaceReexportDeclaration(node) {
      return ts2.isNamespaceExport(node) && !!node.parent.moduleSpecifier;
    }
    ts2.isNamespaceReexportDeclaration = isNamespaceReexportDeclaration;
    function isExternalModuleImportEqualsDeclaration(node) {
      return node.kind === 263 && node.moduleReference.kind === 275;
    }
    ts2.isExternalModuleImportEqualsDeclaration = isExternalModuleImportEqualsDeclaration;
    function getExternalModuleImportEqualsDeclarationExpression(node) {
      ts2.Debug.assert(isExternalModuleImportEqualsDeclaration(node));
      return node.moduleReference.expression;
    }
    ts2.getExternalModuleImportEqualsDeclarationExpression = getExternalModuleImportEqualsDeclarationExpression;
    function getExternalModuleRequireArgument(node) {
      return isRequireVariableDeclaration(node) && getLeftmostAccessExpression(node.initializer).arguments[0];
    }
    ts2.getExternalModuleRequireArgument = getExternalModuleRequireArgument;
    function isInternalModuleImportEqualsDeclaration(node) {
      return node.kind === 263 && node.moduleReference.kind !== 275;
    }
    ts2.isInternalModuleImportEqualsDeclaration = isInternalModuleImportEqualsDeclaration;
    function isSourceFileJS(file) {
      return isInJSFile(file);
    }
    ts2.isSourceFileJS = isSourceFileJS;
    function isSourceFileNotJS(file) {
      return !isInJSFile(file);
    }
    ts2.isSourceFileNotJS = isSourceFileNotJS;
    function isInJSFile(node) {
      return !!node && !!(node.flags & 131072);
    }
    ts2.isInJSFile = isInJSFile;
    function isInJsonFile(node) {
      return !!node && !!(node.flags & 33554432);
    }
    ts2.isInJsonFile = isInJsonFile;
    function isSourceFileNotJson(file) {
      return !isJsonSourceFile(file);
    }
    ts2.isSourceFileNotJson = isSourceFileNotJson;
    function isInJSDoc(node) {
      return !!node && !!(node.flags & 4194304);
    }
    ts2.isInJSDoc = isInJSDoc;
    function isJSDocIndexSignature(node) {
      return ts2.isTypeReferenceNode(node) && ts2.isIdentifier(node.typeName) && node.typeName.escapedText === "Object" && node.typeArguments && node.typeArguments.length === 2 && (node.typeArguments[0].kind === 148 || node.typeArguments[0].kind === 145);
    }
    ts2.isJSDocIndexSignature = isJSDocIndexSignature;
    function isRequireCall(callExpression, requireStringLiteralLikeArgument) {
      if (callExpression.kind !== 206) {
        return false;
      }
      var _a = callExpression, expression = _a.expression, args = _a.arguments;
      if (expression.kind !== 79 || expression.escapedText !== "require") {
        return false;
      }
      if (args.length !== 1) {
        return false;
      }
      var arg = args[0];
      return !requireStringLiteralLikeArgument || ts2.isStringLiteralLike(arg);
    }
    ts2.isRequireCall = isRequireCall;
    function isRequireVariableDeclaration(node) {
      if (node.kind === 201) {
        node = node.parent.parent;
      }
      return ts2.isVariableDeclaration(node) && !!node.initializer && isRequireCall(getLeftmostAccessExpression(node.initializer), true);
    }
    ts2.isRequireVariableDeclaration = isRequireVariableDeclaration;
    function isRequireVariableStatement(node) {
      return ts2.isVariableStatement(node) && node.declarationList.declarations.length > 0 && ts2.every(node.declarationList.declarations, function(decl) {
        return isRequireVariableDeclaration(decl);
      });
    }
    ts2.isRequireVariableStatement = isRequireVariableStatement;
    function isSingleOrDoubleQuote(charCode) {
      return charCode === 39 || charCode === 34;
    }
    ts2.isSingleOrDoubleQuote = isSingleOrDoubleQuote;
    function isStringDoubleQuoted(str, sourceFile) {
      return getSourceTextOfNodeFromSourceFile(sourceFile, str).charCodeAt(0) === 34;
    }
    ts2.isStringDoubleQuoted = isStringDoubleQuoted;
    function isAssignmentDeclaration(decl) {
      return ts2.isBinaryExpression(decl) || isAccessExpression(decl) || ts2.isIdentifier(decl) || ts2.isCallExpression(decl);
    }
    ts2.isAssignmentDeclaration = isAssignmentDeclaration;
    function getEffectiveInitializer(node) {
      if (isInJSFile(node) && node.initializer && ts2.isBinaryExpression(node.initializer) && (node.initializer.operatorToken.kind === 56 || node.initializer.operatorToken.kind === 60) && node.name && isEntityNameExpression(node.name) && isSameEntityName(node.name, node.initializer.left)) {
        return node.initializer.right;
      }
      return node.initializer;
    }
    ts2.getEffectiveInitializer = getEffectiveInitializer;
    function getDeclaredExpandoInitializer(node) {
      var init = getEffectiveInitializer(node);
      return init && getExpandoInitializer(init, isPrototypeAccess(node.name));
    }
    ts2.getDeclaredExpandoInitializer = getDeclaredExpandoInitializer;
    function hasExpandoValueProperty(node, isPrototypeAssignment) {
      return ts2.forEach(node.properties, function(p) {
        return ts2.isPropertyAssignment(p) && ts2.isIdentifier(p.name) && p.name.escapedText === "value" && p.initializer && getExpandoInitializer(p.initializer, isPrototypeAssignment);
      });
    }
    function getAssignedExpandoInitializer(node) {
      if (node && node.parent && ts2.isBinaryExpression(node.parent) && node.parent.operatorToken.kind === 63) {
        var isPrototypeAssignment = isPrototypeAccess(node.parent.left);
        return getExpandoInitializer(node.parent.right, isPrototypeAssignment) || getDefaultedExpandoInitializer(node.parent.left, node.parent.right, isPrototypeAssignment);
      }
      if (node && ts2.isCallExpression(node) && isBindableObjectDefinePropertyCall(node)) {
        var result = hasExpandoValueProperty(node.arguments[2], node.arguments[1].text === "prototype");
        if (result) {
          return result;
        }
      }
    }
    ts2.getAssignedExpandoInitializer = getAssignedExpandoInitializer;
    function getExpandoInitializer(initializer, isPrototypeAssignment) {
      if (ts2.isCallExpression(initializer)) {
        var e = skipParentheses(initializer.expression);
        return e.kind === 211 || e.kind === 212 ? initializer : void 0;
      }
      if (initializer.kind === 211 || initializer.kind === 224 || initializer.kind === 212) {
        return initializer;
      }
      if (ts2.isObjectLiteralExpression(initializer) && (initializer.properties.length === 0 || isPrototypeAssignment)) {
        return initializer;
      }
    }
    ts2.getExpandoInitializer = getExpandoInitializer;
    function getDefaultedExpandoInitializer(name, initializer, isPrototypeAssignment) {
      var e = ts2.isBinaryExpression(initializer) && (initializer.operatorToken.kind === 56 || initializer.operatorToken.kind === 60) && getExpandoInitializer(initializer.right, isPrototypeAssignment);
      if (e && isSameEntityName(name, initializer.left)) {
        return e;
      }
    }
    function isDefaultedExpandoInitializer(node) {
      var name = ts2.isVariableDeclaration(node.parent) ? node.parent.name : ts2.isBinaryExpression(node.parent) && node.parent.operatorToken.kind === 63 ? node.parent.left : void 0;
      return name && getExpandoInitializer(node.right, isPrototypeAccess(name)) && isEntityNameExpression(name) && isSameEntityName(name, node.left);
    }
    ts2.isDefaultedExpandoInitializer = isDefaultedExpandoInitializer;
    function getNameOfExpando(node) {
      if (ts2.isBinaryExpression(node.parent)) {
        var parent = (node.parent.operatorToken.kind === 56 || node.parent.operatorToken.kind === 60) && ts2.isBinaryExpression(node.parent.parent) ? node.parent.parent : node.parent;
        if (parent.operatorToken.kind === 63 && ts2.isIdentifier(parent.left)) {
          return parent.left;
        }
      } else if (ts2.isVariableDeclaration(node.parent)) {
        return node.parent.name;
      }
    }
    ts2.getNameOfExpando = getNameOfExpando;
    function isSameEntityName(name, initializer) {
      if (isPropertyNameLiteral(name) && isPropertyNameLiteral(initializer)) {
        return getTextOfIdentifierOrLiteral(name) === getTextOfIdentifierOrLiteral(initializer);
      }
      if (ts2.isIdentifier(name) && isLiteralLikeAccess(initializer) && (initializer.expression.kind === 108 || ts2.isIdentifier(initializer.expression) && (initializer.expression.escapedText === "window" || initializer.expression.escapedText === "self" || initializer.expression.escapedText === "global"))) {
        var nameOrArgument = getNameOrArgument(initializer);
        if (ts2.isPrivateIdentifier(nameOrArgument)) {
          ts2.Debug.fail("Unexpected PrivateIdentifier in name expression with literal-like access.");
        }
        return isSameEntityName(name, nameOrArgument);
      }
      if (isLiteralLikeAccess(name) && isLiteralLikeAccess(initializer)) {
        return getElementOrPropertyAccessName(name) === getElementOrPropertyAccessName(initializer) && isSameEntityName(name.expression, initializer.expression);
      }
      return false;
    }
    ts2.isSameEntityName = isSameEntityName;
    function getRightMostAssignedExpression(node) {
      while (isAssignmentExpression(node, true)) {
        node = node.right;
      }
      return node;
    }
    ts2.getRightMostAssignedExpression = getRightMostAssignedExpression;
    function isExportsIdentifier(node) {
      return ts2.isIdentifier(node) && node.escapedText === "exports";
    }
    ts2.isExportsIdentifier = isExportsIdentifier;
    function isModuleIdentifier(node) {
      return ts2.isIdentifier(node) && node.escapedText === "module";
    }
    ts2.isModuleIdentifier = isModuleIdentifier;
    function isModuleExportsAccessExpression(node) {
      return (ts2.isPropertyAccessExpression(node) || isLiteralLikeElementAccess(node)) && isModuleIdentifier(node.expression) && getElementOrPropertyAccessName(node) === "exports";
    }
    ts2.isModuleExportsAccessExpression = isModuleExportsAccessExpression;
    function getAssignmentDeclarationKind(expr) {
      var special = getAssignmentDeclarationKindWorker(expr);
      return special === 5 || isInJSFile(expr) ? special : 0;
    }
    ts2.getAssignmentDeclarationKind = getAssignmentDeclarationKind;
    function isBindableObjectDefinePropertyCall(expr) {
      return ts2.length(expr.arguments) === 3 && ts2.isPropertyAccessExpression(expr.expression) && ts2.isIdentifier(expr.expression.expression) && ts2.idText(expr.expression.expression) === "Object" && ts2.idText(expr.expression.name) === "defineProperty" && isStringOrNumericLiteralLike(expr.arguments[1]) && isBindableStaticNameExpression(expr.arguments[0], true);
    }
    ts2.isBindableObjectDefinePropertyCall = isBindableObjectDefinePropertyCall;
    function isLiteralLikeAccess(node) {
      return ts2.isPropertyAccessExpression(node) || isLiteralLikeElementAccess(node);
    }
    ts2.isLiteralLikeAccess = isLiteralLikeAccess;
    function isLiteralLikeElementAccess(node) {
      return ts2.isElementAccessExpression(node) && isStringOrNumericLiteralLike(node.argumentExpression);
    }
    ts2.isLiteralLikeElementAccess = isLiteralLikeElementAccess;
    function isBindableStaticAccessExpression(node, excludeThisKeyword) {
      return ts2.isPropertyAccessExpression(node) && (!excludeThisKeyword && node.expression.kind === 108 || ts2.isIdentifier(node.name) && isBindableStaticNameExpression(node.expression, true)) || isBindableStaticElementAccessExpression(node, excludeThisKeyword);
    }
    ts2.isBindableStaticAccessExpression = isBindableStaticAccessExpression;
    function isBindableStaticElementAccessExpression(node, excludeThisKeyword) {
      return isLiteralLikeElementAccess(node) && (!excludeThisKeyword && node.expression.kind === 108 || isEntityNameExpression(node.expression) || isBindableStaticAccessExpression(node.expression, true));
    }
    ts2.isBindableStaticElementAccessExpression = isBindableStaticElementAccessExpression;
    function isBindableStaticNameExpression(node, excludeThisKeyword) {
      return isEntityNameExpression(node) || isBindableStaticAccessExpression(node, excludeThisKeyword);
    }
    ts2.isBindableStaticNameExpression = isBindableStaticNameExpression;
    function getNameOrArgument(expr) {
      if (ts2.isPropertyAccessExpression(expr)) {
        return expr.name;
      }
      return expr.argumentExpression;
    }
    ts2.getNameOrArgument = getNameOrArgument;
    function getAssignmentDeclarationKindWorker(expr) {
      if (ts2.isCallExpression(expr)) {
        if (!isBindableObjectDefinePropertyCall(expr)) {
          return 0;
        }
        var entityName = expr.arguments[0];
        if (isExportsIdentifier(entityName) || isModuleExportsAccessExpression(entityName)) {
          return 8;
        }
        if (isBindableStaticAccessExpression(entityName) && getElementOrPropertyAccessName(entityName) === "prototype") {
          return 9;
        }
        return 7;
      }
      if (expr.operatorToken.kind !== 63 || !isAccessExpression(expr.left) || isVoidZero(getRightMostAssignedExpression(expr))) {
        return 0;
      }
      if (isBindableStaticNameExpression(expr.left.expression, true) && getElementOrPropertyAccessName(expr.left) === "prototype" && ts2.isObjectLiteralExpression(getInitializerOfBinaryExpression(expr))) {
        return 6;
      }
      return getAssignmentDeclarationPropertyAccessKind(expr.left);
    }
    function isVoidZero(node) {
      return ts2.isVoidExpression(node) && ts2.isNumericLiteral(node.expression) && node.expression.text === "0";
    }
    function getElementOrPropertyAccessArgumentExpressionOrName(node) {
      if (ts2.isPropertyAccessExpression(node)) {
        return node.name;
      }
      var arg = skipParentheses(node.argumentExpression);
      if (ts2.isNumericLiteral(arg) || ts2.isStringLiteralLike(arg)) {
        return arg;
      }
      return node;
    }
    ts2.getElementOrPropertyAccessArgumentExpressionOrName = getElementOrPropertyAccessArgumentExpressionOrName;
    function getElementOrPropertyAccessName(node) {
      var name = getElementOrPropertyAccessArgumentExpressionOrName(node);
      if (name) {
        if (ts2.isIdentifier(name)) {
          return name.escapedText;
        }
        if (ts2.isStringLiteralLike(name) || ts2.isNumericLiteral(name)) {
          return ts2.escapeLeadingUnderscores(name.text);
        }
      }
      return void 0;
    }
    ts2.getElementOrPropertyAccessName = getElementOrPropertyAccessName;
    function getAssignmentDeclarationPropertyAccessKind(lhs) {
      if (lhs.expression.kind === 108) {
        return 4;
      } else if (isModuleExportsAccessExpression(lhs)) {
        return 2;
      } else if (isBindableStaticNameExpression(lhs.expression, true)) {
        if (isPrototypeAccess(lhs.expression)) {
          return 3;
        }
        var nextToLast = lhs;
        while (!ts2.isIdentifier(nextToLast.expression)) {
          nextToLast = nextToLast.expression;
        }
        var id = nextToLast.expression;
        if ((id.escapedText === "exports" || id.escapedText === "module" && getElementOrPropertyAccessName(nextToLast) === "exports") && isBindableStaticAccessExpression(lhs)) {
          return 1;
        }
        if (isBindableStaticNameExpression(lhs, true) || ts2.isElementAccessExpression(lhs) && isDynamicName(lhs)) {
          return 5;
        }
      }
      return 0;
    }
    ts2.getAssignmentDeclarationPropertyAccessKind = getAssignmentDeclarationPropertyAccessKind;
    function getInitializerOfBinaryExpression(expr) {
      while (ts2.isBinaryExpression(expr.right)) {
        expr = expr.right;
      }
      return expr.right;
    }
    ts2.getInitializerOfBinaryExpression = getInitializerOfBinaryExpression;
    function isPrototypePropertyAssignment(node) {
      return ts2.isBinaryExpression(node) && getAssignmentDeclarationKind(node) === 3;
    }
    ts2.isPrototypePropertyAssignment = isPrototypePropertyAssignment;
    function isSpecialPropertyDeclaration(expr) {
      return isInJSFile(expr) && expr.parent && expr.parent.kind === 236 && (!ts2.isElementAccessExpression(expr) || isLiteralLikeElementAccess(expr)) && !!ts2.getJSDocTypeTag(expr.parent);
    }
    ts2.isSpecialPropertyDeclaration = isSpecialPropertyDeclaration;
    function setValueDeclaration(symbol, node) {
      var valueDeclaration = symbol.valueDeclaration;
      if (!valueDeclaration || !(node.flags & 8388608 && !(valueDeclaration.flags & 8388608)) && (isAssignmentDeclaration(valueDeclaration) && !isAssignmentDeclaration(node)) || valueDeclaration.kind !== node.kind && isEffectiveModuleDeclaration(valueDeclaration)) {
        symbol.valueDeclaration = node;
      }
    }
    ts2.setValueDeclaration = setValueDeclaration;
    function isFunctionSymbol(symbol) {
      if (!symbol || !symbol.valueDeclaration) {
        return false;
      }
      var decl = symbol.valueDeclaration;
      return decl.kind === 254 || ts2.isVariableDeclaration(decl) && decl.initializer && ts2.isFunctionLike(decl.initializer);
    }
    ts2.isFunctionSymbol = isFunctionSymbol;
    function tryGetModuleSpecifierFromDeclaration(node) {
      var _a, _b, _c;
      switch (node.kind) {
        case 252:
          return node.initializer.arguments[0].text;
        case 264:
          return (_a = ts2.tryCast(node.moduleSpecifier, ts2.isStringLiteralLike)) === null || _a === void 0 ? void 0 : _a.text;
        case 263:
          return (_c = ts2.tryCast((_b = ts2.tryCast(node.moduleReference, ts2.isExternalModuleReference)) === null || _b === void 0 ? void 0 : _b.expression, ts2.isStringLiteralLike)) === null || _c === void 0 ? void 0 : _c.text;
        default:
          ts2.Debug.assertNever(node);
      }
    }
    ts2.tryGetModuleSpecifierFromDeclaration = tryGetModuleSpecifierFromDeclaration;
    function importFromModuleSpecifier(node) {
      return tryGetImportFromModuleSpecifier(node) || ts2.Debug.failBadSyntaxKind(node.parent);
    }
    ts2.importFromModuleSpecifier = importFromModuleSpecifier;
    function tryGetImportFromModuleSpecifier(node) {
      switch (node.parent.kind) {
        case 264:
        case 270:
          return node.parent;
        case 275:
          return node.parent.parent;
        case 206:
          return isImportCall(node.parent) || isRequireCall(node.parent, false) ? node.parent : void 0;
        case 194:
          ts2.Debug.assert(ts2.isStringLiteral(node));
          return ts2.tryCast(node.parent.parent, ts2.isImportTypeNode);
        default:
          return void 0;
      }
    }
    ts2.tryGetImportFromModuleSpecifier = tryGetImportFromModuleSpecifier;
    function getExternalModuleName(node) {
      switch (node.kind) {
        case 264:
        case 270:
          return node.moduleSpecifier;
        case 263:
          return node.moduleReference.kind === 275 ? node.moduleReference.expression : void 0;
        case 198:
          return isLiteralImportTypeNode(node) ? node.argument.literal : void 0;
        case 206:
          return node.arguments[0];
        case 259:
          return node.name.kind === 10 ? node.name : void 0;
        default:
          return ts2.Debug.assertNever(node);
      }
    }
    ts2.getExternalModuleName = getExternalModuleName;
    function getNamespaceDeclarationNode(node) {
      switch (node.kind) {
        case 264:
          return node.importClause && ts2.tryCast(node.importClause.namedBindings, ts2.isNamespaceImport);
        case 263:
          return node;
        case 270:
          return node.exportClause && ts2.tryCast(node.exportClause, ts2.isNamespaceExport);
        default:
          return ts2.Debug.assertNever(node);
      }
    }
    ts2.getNamespaceDeclarationNode = getNamespaceDeclarationNode;
    function isDefaultImport(node) {
      return node.kind === 264 && !!node.importClause && !!node.importClause.name;
    }
    ts2.isDefaultImport = isDefaultImport;
    function forEachImportClauseDeclaration(node, action) {
      if (node.name) {
        var result = action(node);
        if (result)
          return result;
      }
      if (node.namedBindings) {
        var result = ts2.isNamespaceImport(node.namedBindings) ? action(node.namedBindings) : ts2.forEach(node.namedBindings.elements, action);
        if (result)
          return result;
      }
    }
    ts2.forEachImportClauseDeclaration = forEachImportClauseDeclaration;
    function hasQuestionToken(node) {
      if (node) {
        switch (node.kind) {
          case 162:
          case 167:
          case 166:
          case 292:
          case 291:
          case 165:
          case 164:
            return node.questionToken !== void 0;
        }
      }
      return false;
    }
    ts2.hasQuestionToken = hasQuestionToken;
    function isJSDocConstructSignature(node) {
      var param = ts2.isJSDocFunctionType(node) ? ts2.firstOrUndefined(node.parameters) : void 0;
      var name = ts2.tryCast(param && param.name, ts2.isIdentifier);
      return !!name && name.escapedText === "new";
    }
    ts2.isJSDocConstructSignature = isJSDocConstructSignature;
    function isJSDocTypeAlias(node) {
      return node.kind === 340 || node.kind === 333 || node.kind === 334;
    }
    ts2.isJSDocTypeAlias = isJSDocTypeAlias;
    function isTypeAlias(node) {
      return isJSDocTypeAlias(node) || ts2.isTypeAliasDeclaration(node);
    }
    ts2.isTypeAlias = isTypeAlias;
    function getSourceOfAssignment(node) {
      return ts2.isExpressionStatement(node) && ts2.isBinaryExpression(node.expression) && node.expression.operatorToken.kind === 63 ? getRightMostAssignedExpression(node.expression) : void 0;
    }
    function getSourceOfDefaultedAssignment(node) {
      return ts2.isExpressionStatement(node) && ts2.isBinaryExpression(node.expression) && getAssignmentDeclarationKind(node.expression) !== 0 && ts2.isBinaryExpression(node.expression.right) && (node.expression.right.operatorToken.kind === 56 || node.expression.right.operatorToken.kind === 60) ? node.expression.right.right : void 0;
    }
    function getSingleInitializerOfVariableStatementOrPropertyDeclaration(node) {
      switch (node.kind) {
        case 235:
          var v = getSingleVariableOfVariableStatement(node);
          return v && v.initializer;
        case 165:
          return node.initializer;
        case 291:
          return node.initializer;
      }
    }
    ts2.getSingleInitializerOfVariableStatementOrPropertyDeclaration = getSingleInitializerOfVariableStatementOrPropertyDeclaration;
    function getSingleVariableOfVariableStatement(node) {
      return ts2.isVariableStatement(node) ? ts2.firstOrUndefined(node.declarationList.declarations) : void 0;
    }
    ts2.getSingleVariableOfVariableStatement = getSingleVariableOfVariableStatement;
    function getNestedModuleDeclaration(node) {
      return ts2.isModuleDeclaration(node) && node.body && node.body.kind === 259 ? node.body : void 0;
    }
    function getJSDocCommentsAndTags(hostNode, noCache) {
      var result;
      if (isVariableLike(hostNode) && ts2.hasInitializer(hostNode) && ts2.hasJSDocNodes(hostNode.initializer)) {
        result = ts2.append(result, ts2.last(hostNode.initializer.jsDoc));
      }
      var node = hostNode;
      while (node && node.parent) {
        if (ts2.hasJSDocNodes(node)) {
          result = ts2.append(result, ts2.last(node.jsDoc));
        }
        if (node.kind === 162) {
          result = ts2.addRange(result, (noCache ? ts2.getJSDocParameterTagsNoCache : ts2.getJSDocParameterTags)(node));
          break;
        }
        if (node.kind === 161) {
          result = ts2.addRange(result, (noCache ? ts2.getJSDocTypeParameterTagsNoCache : ts2.getJSDocTypeParameterTags)(node));
          break;
        }
        node = getNextJSDocCommentLocation(node);
      }
      return result || ts2.emptyArray;
    }
    ts2.getJSDocCommentsAndTags = getJSDocCommentsAndTags;
    function getNextJSDocCommentLocation(node) {
      var parent = node.parent;
      if (parent.kind === 291 || parent.kind === 269 || parent.kind === 165 || parent.kind === 236 && node.kind === 204 || parent.kind === 245 || getNestedModuleDeclaration(parent) || ts2.isBinaryExpression(node) && node.operatorToken.kind === 63) {
        return parent;
      } else if (parent.parent && (getSingleVariableOfVariableStatement(parent.parent) === node || ts2.isBinaryExpression(parent) && parent.operatorToken.kind === 63)) {
        return parent.parent;
      } else if (parent.parent && parent.parent.parent && (getSingleVariableOfVariableStatement(parent.parent.parent) || getSingleInitializerOfVariableStatementOrPropertyDeclaration(parent.parent.parent) === node || getSourceOfDefaultedAssignment(parent.parent.parent))) {
        return parent.parent.parent;
      }
    }
    ts2.getNextJSDocCommentLocation = getNextJSDocCommentLocation;
    function getParameterSymbolFromJSDoc(node) {
      if (node.symbol) {
        return node.symbol;
      }
      if (!ts2.isIdentifier(node.name)) {
        return void 0;
      }
      var name = node.name.escapedText;
      var decl = getHostSignatureFromJSDoc(node);
      if (!decl) {
        return void 0;
      }
      var parameter = ts2.find(decl.parameters, function(p) {
        return p.name.kind === 79 && p.name.escapedText === name;
      });
      return parameter && parameter.symbol;
    }
    ts2.getParameterSymbolFromJSDoc = getParameterSymbolFromJSDoc;
    function getHostSignatureFromJSDoc(node) {
      var host = getEffectiveJSDocHost(node);
      return host && ts2.isFunctionLike(host) ? host : void 0;
    }
    ts2.getHostSignatureFromJSDoc = getHostSignatureFromJSDoc;
    function getEffectiveJSDocHost(node) {
      var host = getJSDocHost(node);
      if (host) {
        return getSourceOfDefaultedAssignment(host) || getSourceOfAssignment(host) || getSingleInitializerOfVariableStatementOrPropertyDeclaration(host) || getSingleVariableOfVariableStatement(host) || getNestedModuleDeclaration(host) || host;
      }
    }
    ts2.getEffectiveJSDocHost = getEffectiveJSDocHost;
    function getJSDocHost(node) {
      var jsDoc = getJSDocRoot(node);
      if (!jsDoc) {
        return void 0;
      }
      var host = jsDoc.parent;
      if (host && host.jsDoc && jsDoc === ts2.lastOrUndefined(host.jsDoc)) {
        return host;
      }
    }
    ts2.getJSDocHost = getJSDocHost;
    function getJSDocRoot(node) {
      return ts2.findAncestor(node.parent, ts2.isJSDoc);
    }
    ts2.getJSDocRoot = getJSDocRoot;
    function getTypeParameterFromJsDoc(node) {
      var name = node.name.escapedText;
      var typeParameters = node.parent.parent.parent.typeParameters;
      return typeParameters && ts2.find(typeParameters, function(p) {
        return p.name.escapedText === name;
      });
    }
    ts2.getTypeParameterFromJsDoc = getTypeParameterFromJsDoc;
    function hasRestParameter(s) {
      var last = ts2.lastOrUndefined(s.parameters);
      return !!last && isRestParameter(last);
    }
    ts2.hasRestParameter = hasRestParameter;
    function isRestParameter(node) {
      var type = ts2.isJSDocParameterTag(node) ? node.typeExpression && node.typeExpression.type : node.type;
      return node.dotDotDotToken !== void 0 || !!type && type.kind === 313;
    }
    ts2.isRestParameter = isRestParameter;
    function hasTypeArguments(node) {
      return !!node.typeArguments;
    }
    ts2.hasTypeArguments = hasTypeArguments;
    var AssignmentKind;
    (function(AssignmentKind2) {
      AssignmentKind2[AssignmentKind2["None"] = 0] = "None";
      AssignmentKind2[AssignmentKind2["Definite"] = 1] = "Definite";
      AssignmentKind2[AssignmentKind2["Compound"] = 2] = "Compound";
    })(AssignmentKind = ts2.AssignmentKind || (ts2.AssignmentKind = {}));
    function getAssignmentTargetKind(node) {
      var parent = node.parent;
      while (true) {
        switch (parent.kind) {
          case 219:
            var binaryOperator = parent.operatorToken.kind;
            return isAssignmentOperator(binaryOperator) && parent.left === node ? binaryOperator === 63 || isLogicalOrCoalescingAssignmentOperator(binaryOperator) ? 1 : 2 : 0;
          case 217:
          case 218:
            var unaryOperator = parent.operator;
            return unaryOperator === 45 || unaryOperator === 46 ? 2 : 0;
          case 241:
          case 242:
            return parent.initializer === node ? 1 : 0;
          case 210:
          case 202:
          case 223:
          case 228:
            node = parent;
            break;
          case 293:
            node = parent.parent;
            break;
          case 292:
            if (parent.name !== node) {
              return 0;
            }
            node = parent.parent;
            break;
          case 291:
            if (parent.name === node) {
              return 0;
            }
            node = parent.parent;
            break;
          default:
            return 0;
        }
        parent = node.parent;
      }
    }
    ts2.getAssignmentTargetKind = getAssignmentTargetKind;
    function isAssignmentTarget(node) {
      return getAssignmentTargetKind(node) !== 0;
    }
    ts2.isAssignmentTarget = isAssignmentTarget;
    function isNodeWithPossibleHoistedDeclaration(node) {
      switch (node.kind) {
        case 233:
        case 235:
        case 246:
        case 237:
        case 247:
        case 261:
        case 287:
        case 288:
        case 248:
        case 240:
        case 241:
        case 242:
        c