import type { APIEvent, ExceptionEvent, LogEvent, MeasurementEvent, TraceEvent } from '../api';
import type { Meta } from '../metas';
export declare enum TransportItemType {
  EXCEPTION = 'exception',
  LOG = 'log',
  MEASUREMENT = 'measurement',
  TRACE = 'trace',
}
export declare type TransportItemPayload<P = APIEvent> = P;
export declare type BeforeSendHook<P = APIEvent> = (item: TransportItem<P>) => TransportItem<P> | null;
export interface TransportItem<P = APIEvent> {
  type: TransportItemType;
  payload: TransportItemPayload<P>;
  meta: Meta;
}
export interface Transport {
  send(item: TransportItem): void | Promise<void>;
  getIgnoreUrls(): Array<string | RegExp>;
}
export interface TransportBody {
  exceptions?: ExceptionEvent[];
  logs?: LogEvent[];
  measurements?: MeasurementEvent[];
  traces?: TraceEvent;
  meta: Meta;
}
export interface Transports {
  add: (...transports: Transport[]) => void;
  execute: (transportItem: TransportItem) => void;
  transports: Transport[];
}
