import { Dispatch, MutableRefObject, SetStateAction } from 'react';
import { CartesianCoords2D } from '@grafana/data';
import { UPlotConfigBuilder } from './UPlotConfigBuilder';
export declare type HoverEvent = {
    xIndex: number;
    yIndex: number;
    pageX: number;
    pageY: number;
};
declare type SetupConfigParams = {
    config: UPlotConfigBuilder;
    onUPlotClick: () => void;
    setFocusedSeriesIdx: Dispatch<SetStateAction<number | null>>;
    setFocusedPointIdx: Dispatch<SetStateAction<number | null>>;
    setCoords: Dispatch<SetStateAction<{
        viewport: CartesianCoords2D;
        canvas: CartesianCoords2D;
    } | null>>;
    setHover: Dispatch<SetStateAction<HoverEvent | undefined>>;
    isToolTipOpen: MutableRefObject<boolean>;
};
export declare const addTooltipSupport: ({ config, onUPlotClick, setFocusedSeriesIdx, setFocusedPointIdx, setCoords, setHover, isToolTipOpen, }: SetupConfigParams) => UPlotConfigBuilder;
export {};
