/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap;

import com.netscape.jndi.ldap.AttributesImpl;
import com.netscape.jndi.ldap.ContextEnv;
import com.netscape.jndi.ldap.EventService;
import com.netscape.jndi.ldap.LdapNameParser;
import com.netscape.jndi.ldap.LdapService;
import com.netscape.jndi.ldap.ObjectMapper;
import com.netscape.jndi.ldap.ProviderUtils;
import com.netscape.jndi.ldap.common.Debug;
import com.netscape.jndi.ldap.controls.NetscapeControlFactory;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamingListener;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPUrl;

public class LdapContextImpl
implements EventDirContext,
LdapContext {
    protected ContextEnv m_ctxEnv;
    protected String m_ctxDN;
    protected LdapService m_ldapSvc;
    protected LDAPSearchConstraints m_searchCons;

    public LdapContextImpl(Hashtable<Object, Object> env) throws NamingException {
        this.m_ctxEnv = new ContextEnv(env);
        this.m_ldapSvc = new LdapService();
        this.m_ldapSvc.connect(this);
        this.getDN();
        this.getSearchConstraints();
    }

    public LdapContextImpl(String ctxDN, LdapContextImpl cloneCtx) throws NamingException {
        this.m_ctxEnv = (ContextEnv)cloneCtx.m_ctxEnv.clone();
        this.m_ldapSvc = cloneCtx.m_ldapSvc;
        cloneCtx.m_ldapSvc.incrementClientCount();
        if (cloneCtx.getSearchConstraints().getServerControls() == null) {
            this.m_searchCons = cloneCtx.getSearchConstraints();
        } else {
            this.m_searchCons = (LDAPSearchConstraints)cloneCtx.getSearchConstraints().clone();
            this.m_searchCons.setServerControls((LDAPControl[])null);
        }
        this.m_ctxDN = ctxDN;
    }

    protected void finalize() {
        Debug.println(1, "finalize ctx");
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() throws NamingException {
        this.m_ldapSvc.disconnect();
        this.m_ldapSvc = null;
    }

    LDAPSearchConstraints getSearchConstraints() throws NamingException {
        if (this.m_searchCons == null) {
            LDAPSearchConstraints cons = new LDAPSearchConstraints();
            this.m_ctxEnv.updateSearchCons(cons);
            this.m_searchCons = cons;
        }
        return this.m_searchCons;
    }

    String getDN() throws NamingException {
        if (this.m_ctxDN == null) {
            LDAPUrl url = this.m_ctxEnv.getDirectoryServerURL();
            this.m_ctxDN = url != null && url.getDN() != null ? url.getDN() : "";
        }
        return this.m_ctxDN;
    }

    ContextEnv getEnv() {
        return this.m_ctxEnv;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.m_ctxDN;
    }

    String checkLdapUrlAsName(String name) throws NamingException {
        if (name.startsWith("ldap://")) {
            this.m_ctxEnv.setProperty("java.naming.provider.url", name);
            this.close();
            this.m_ldapSvc = new LdapService();
            return "";
        }
        return name;
    }

    public Hashtable<Object, Object> getEnvironment() throws NamingException {
        return this.m_ctxEnv.getAllProperties();
    }

    @Override
    public Object addToEnvironment(String propName, Object propValue) throws NamingException {
        if (propName.equalsIgnoreCase("com.netscape.ldap.trace")) {
            this.m_ldapSvc.setTraceOutput(propValue);
        }
        return this.m_ctxEnv.updateProperty(propName, propValue, this.getSearchConstraints());
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        if (propName.equalsIgnoreCase("com.netscape.ldap.trace")) {
            this.m_ldapSvc.setTraceOutput(null);
        }
        return this.m_ctxEnv.removeProperty(propName);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return name + "," + prefix;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        String compoundName = this.composeName(name.toString(), prefix.toString());
        return LdapNameParser.getParser().parse(compoundName);
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return new String(this.m_ctxDN);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return LdapNameParser.getParser();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return LdapNameParser.getParser();
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        name = this.checkLdapUrlAsName(name);
        return this.m_ldapSvc.search(this, name, filter, null, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        name = this.checkLdapUrlAsName(name);
        String filter = ProviderUtils.expandFilterExpr(filterExpr, filterArgs);
        return this.m_ldapSvc.search(this, name, filter, null, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws NamingException {
        name = this.checkLdapUrlAsName(name);
        String filter = ProviderUtils.attributesToFilter(matchingAttributes);
        return this.m_ldapSvc.search(this, name, filter, null, null);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        name = this.checkLdapUrlAsName(name);
        String filter = ProviderUtils.attributesToFilter(matchingAttributes);
        return this.m_ldapSvc.search(this, name, filter, attributesToReturn, null);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls cons) throws NamingException {
        return this.m_ldapSvc.search(this, name.toString(), filter, null, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        String filter = ProviderUtils.expandFilterExpr(filterExpr, filterArgs);
        return this.m_ldapSvc.search(this, name.toString(), filter, null, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes attrs) throws NamingException {
        String filter = ProviderUtils.attributesToFilter(attrs);
        return this.m_ldapSvc.search(this, name.toString(), filter, null, null);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        String filter = ProviderUtils.attributesToFilter(matchingAttributes);
        return this.m_ldapSvc.search(this, name.toString(), filter, attributesToReturn, null);
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        name = this.checkLdapUrlAsName(name);
        return this.m_ldapSvc.readAttrs(this, name, null);
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        name = this.checkLdapUrlAsName(name);
        return this.m_ldapSvc.readAttrs(this, name, attrIds);
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        return this.m_ldapSvc.readAttrs(this, name.toString(), null);
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.m_ldapSvc.readAttrs(this, name.toString(), attrIds);
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        name = this.checkLdapUrlAsName(name);
        this.m_ldapSvc.modifyEntry(this, name, AttributesImpl.jndiAttrsToLdapModSet(mod_op, attrs));
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        name = this.checkLdapUrlAsName(name);
        this.m_ldapSvc.modifyEntry(this, name, AttributesImpl.jndiModsToLdapModSet(mods));
    }

    @Override
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        this.m_ldapSvc.modifyEntry(this, name.toString(), AttributesImpl.jndiAttrsToLdapModSet(mod_op, attrs));
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        this.m_ldapSvc.modifyEntry(this, name.toString(), AttributesImpl.jndiModsToLdapModSet(mods));
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        name = this.checkLdapUrlAsName(name);
        return this.m_ldapSvc.addEntry(this, name, AttributesImpl.jndiAttrsToLdapAttrSet(attrs));
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        return this.m_ldapSvc.addEntry(this, name.toString(), AttributesImpl.jndiAttrsToLdapAttrSet(attrs));
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        name = this.checkLdapUrlAsName(name);
        this.m_ldapSvc.delEntry(this, name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.m_ldapSvc.delEntry(this, name.toString());
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        name = this.checkLdapUrlAsName(name);
        this.m_ldapSvc.addEntry(this, name.toString(), ObjectMapper.objectToAttrSet(obj, name, this, null));
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        name = this.checkLdapUrlAsName(name);
        this.m_ldapSvc.addEntry(this, name.toString(), ObjectMapper.objectToAttrSet(obj, name, this, attrs));
    }

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.bind(name.toString(), obj, attrs);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(name, obj, null);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj, null);
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        name = this.checkLdapUrlAsName(name);
        try {
            this.bind(name, obj, attrs);
        }
        catch (NameAlreadyBoundException ex) {
            this.unbind(name);
            this.bind(name, obj, attrs);
        }
    }

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.rebind(name.toString(), obj, attrs);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        oldName = this.checkLdapUrlAsName(oldName);
        LdapNameParser parser = LdapNameParser.getParser();
        Name oldNameObj = parser.parse(oldName);
        Name newNameObj = parser.parse(newName);
        this.rename(oldNameObj, newNameObj);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        if (newName.size() != oldName.size()) {
            throw new InvalidNameException("Invalid name " + newName);
        }
        Name oldPrefix = oldName.getPrefix(oldName.size() - 1);
        Name newPrefix = newName.getPrefix(oldName.size() - 1);
        if (!newPrefix.equals(oldPrefix)) {
            throw new InvalidNameException("Invalid name " + newName);
        }
        this.m_ldapSvc.changeRDN(this, oldName.toString(), newName.get(newName.size() - 1));
    }

    @Override
    public void unbind(String name) throws NamingException {
        name = this.checkLdapUrlAsName(name);
        this.destroySubcontext(name);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.destroySubcontext(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        name = this.checkLdapUrlAsName(name);
        return this.m_ldapSvc.list(this, name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.m_ldapSvc.list(this, name.toString());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        name = this.checkLdapUrlAsName(name);
        return this.m_ldapSvc.listBindings(this, name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.m_ldapSvc.listBindings(this, name.toString());
    }

    @Override
    public Object lookup(String name) throws NamingException {
        name = this.checkLdapUrlAsName(name);
        return this.m_ldapSvc.lookup(this, name);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.m_ldapSvc.lookup(this, name.toString());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        name = this.checkLdapUrlAsName(name);
        return this.m_ldapSvc.getSchema(this, name);
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        return this.m_ldapSvc.getSchema(this, name.toString());
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        name = this.checkLdapUrlAsName(name);
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return this.getSchemaClassDefinition(name.toString());
    }

    @Override
    public void addNamingListener(String target, int scope, NamingListener l) throws NamingException {
        EventService eventSvc = this.m_ldapSvc.getEventService(this);
        String filter = "(objectclass=*)";
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(scope);
        eventSvc.addListener(this, target, filter, ctls, l);
    }

    @Override
    public void addNamingListener(Name target, int scope, NamingListener l) throws NamingException {
        this.addNamingListener(target.toString(), scope, l);
    }

    @Override
    public void addNamingListener(String target, String filter, SearchControls ctls, NamingListener l) throws NamingException {
        EventService eventSvc = this.m_ldapSvc.getEventService(this);
        eventSvc.addListener(this, target, filter, ctls, l);
    }

    @Override
    public void addNamingListener(Name target, String filter, SearchControls ctls, NamingListener l) throws NamingException {
        this.addNamingListener(target.toString(), filter, ctls, l);
    }

    @Override
    public void addNamingListener(String target, String filterExpr, Object[] filterArgs, SearchControls ctls, NamingListener l) throws NamingException {
        EventService eventSvc = this.m_ldapSvc.getEventService(this);
        String filter = ProviderUtils.expandFilterExpr(filterExpr, filterArgs);
        eventSvc.addListener(this, target, filter, ctls, l);
    }

    @Override
    public void addNamingListener(Name target, String filterExpr, Object[] filterArgs, SearchControls ctls, NamingListener l) throws NamingException {
        this.addNamingListener(target.toString(), filterExpr, filterArgs, ctls, l);
    }

    @Override
    public void removeNamingListener(NamingListener l) throws NamingException {
        EventService eventSvc = this.m_ldapSvc.getEventService(this);
        eventSvc.removeListener(l);
    }

    @Override
    public boolean targetMustExist() {
        return true;
    }

    @Override
    public ExtendedResponse extendedOperation(ExtendedRequest req) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Control[] getRequestControls() throws NamingException {
        LDAPControl[] ldapCtls = this.m_searchCons.getServerControls();
        if (ldapCtls == null) {
            return null;
        }
        Control[] ctls = new Control[ldapCtls.length];
        for (int i = 0; i < ldapCtls.length; ++i) {
            ctls[i] = (Control)ldapCtls[i];
        }
        return ctls;
    }

    @Override
    public void setRequestControls(Control[] reqCtls) throws NamingException {
        LDAPControl[] ldapCtls = new LDAPControl[reqCtls.length];
        for (int i = 0; i < reqCtls.length; ++i) {
            try {
                ldapCtls[i] = (LDAPControl)reqCtls[i];
                continue;
            }
            catch (ClassCastException ex) {
                throw new NamingException("Unsupported control type " + reqCtls[i].getClass().getName());
            }
        }
        this.getSearchConstraints().setServerControls(ldapCtls);
    }

    @Override
    public Control[] getResponseControls() throws NamingException {
        LDAPControl[] ldapCtls = this.m_ldapSvc.getConnection().getResponseControls();
        if (ldapCtls == null) {
            return null;
        }
        Control[] ctls = new Control[ldapCtls.length];
        for (int i = 0; i < ldapCtls.length; ++i) {
            ctls[i] = NetscapeControlFactory.getControlInstance(ldapCtls[i]);
            if (ctls[i] != null) continue;
            throw new NamingException("Unsupported control " + ldapCtls[i].getID());
        }
        return ctls;
    }

    @Override
    public LdapContext newInstance(Control[] reqCtls) throws NamingException {
        LdapContextImpl clone = new LdapContextImpl(this.m_ctxDN, this);
        clone.m_ctxEnv.setProperty("java.naming.ldap.control.connect", reqCtls);
        return clone;
    }

    @Override
    public void reconnect(Control[] reqCtls) throws NamingException {
        this.close();
        this.m_ldapSvc = new LdapService();
        if (reqCtls != null) {
            this.m_ctxEnv.setProperty("java.naming.ldap.control.connect", reqCtls);
        }
        this.m_ldapSvc.connect(this);
    }

    @Override
    public Control[] getConnectControls() {
        return (Control[])this.m_ctxEnv.getProperty("java.naming.ldap.control.connect");
    }
}

