; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v,+m,+zfh,+zvfh -target-abi=ilp32d -riscv-v-vector-bits-min=128 \
; RUN:   -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+v,+m,+zfh,+zvfh -target-abi=lp64d -riscv-v-vector-bits-min=128 \
; RUN:   -verify-machineinstrs < %s | FileCheck %s

declare <7 x i1> @llvm.vp.fcmp.v7f16(<7 x half>, <7 x half>, metadata, <7 x i1>, i32)

define <7 x i1> @fcmp_oeq_vv_v7f16(<7 x half> %va, <7 x half> %vb, <7 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vv_v7f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <7 x i1> @llvm.vp.fcmp.v7f16(<7 x half> %va, <7 x half> %vb, metadata !"oeq", <7 x i1> %m, i32 %evl)
  ret <7 x i1> %v
}

declare <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half>, <8 x half>, metadata, <8 x i1>, i32)

define <8 x i1> @fcmp_oeq_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"oeq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_oeq_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"oeq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_oeq_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vf_swap_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"oeq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ogt_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ogt_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ogt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ogt_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ogt_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ogt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ogt_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ogt_vf_swap_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"ogt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_oge_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oge_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"oge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_oge_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oge_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"oge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_oge_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oge_vf_swap_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"oge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_olt_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_olt_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"olt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_olt_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_olt_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"olt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_olt_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_olt_vf_swap_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"olt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ole_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ole_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ole", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ole_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ole_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ole", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ole_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ole_vf_swap_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"ole", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_one_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_one_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmflt.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v8, v10
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"one", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_one_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_one_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"one", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_one_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_one_vf_swap_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmflt.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"one", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ord_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ord_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfeq.vv v9, v9, v9, v0.t
; CHECK-NEXT:    vmfeq.vv v8, v8, v8, v0.t
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ord", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ord_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ord_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfeq.vv v8, v8, v8, v0.t
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0, v0.t
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ord", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ord_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ord_vf_swap_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfeq.vv v8, v8, v8, v0.t
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0, v0.t
; CHECK-NEXT:    vmand.mm v0, v9, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"ord", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ueq_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ueq_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmflt.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vmnor.mm v0, v8, v10
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ueq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ueq_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ueq_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ueq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ueq_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ueq_vf_swap_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmflt.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"ueq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ugt_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ugt_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v8, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ugt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ugt_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ugt_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ugt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ugt_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ugt_vf_swap_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"ugt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uge_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uge_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v8, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"uge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uge_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uge_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"uge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uge_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uge_vf_swap_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"uge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ult_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ult_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ult", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ult_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ult_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ult", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ult_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ult_vf_swap_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"ult", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ule_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ule_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ule", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ule_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ule_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ule", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ule_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ule_vf_swap_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"ule", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_une_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_une_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"une", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_une_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_une_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"une", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_une_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_une_vf_swap_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"une", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uno_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uno_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfne.vv v9, v9, v9, v0.t
; CHECK-NEXT:    vmfne.vv v8, v8, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"uno", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uno_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uno_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfne.vv v8, v8, v8, v0.t
; CHECK-NEXT:    vmfne.vf v9, v9, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"uno", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uno_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uno_vf_swap_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmfne.vv v8, v8, v8, v0.t
; CHECK-NEXT:    vmfne.vf v9, v9, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v9, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"uno", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

declare <128 x i1> @llvm.vp.fcmp.v128f16(<128 x half>, <128 x half>, metadata, <128 x i1>, i32)

define <128 x i1> @fcmp_oeq_vv_v128f16(<128 x half> %va, <128 x half> %vb, <128 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vv_v128f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 4
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x10, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 16 * vlenb
; CHECK-NEXT:    vmv1r.v v24, v0
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vs8r.v v8, (a1) # Unknown-size Folded Spill
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    addi a3, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a3) # Unknown-size Folded Spill
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 8, e8, m1, ta, ma
; CHECK-NEXT:    addi a0, a2, -64
; CHECK-NEXT:    sltu a3, a2, a0
; CHECK-NEXT:    addi a3, a3, -1
; CHECK-NEXT:    and a0, a3, a0
; CHECK-NEXT:    vslidedown.vi v0, v0, 8
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    vmfeq.vv v1, v16, v8, v0.t
; CHECK-NEXT:    bltu a2, a1, .LBB43_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    li a2, 64
; CHECK-NEXT:  .LBB43_2:
; CHECK-NEXT:    vsetvli zero, a2, e16, m8, ta, ma
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vl8r.v v24, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vmfeq.vv v16, v8, v24, v0.t
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vslideup.vi v16, v1, 8
; CHECK-NEXT:    vmv.v.v v0, v16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %v = call <128 x i1> @llvm.vp.fcmp.v128f16(<128 x half> %va, <128 x half> %vb, metadata !"oeq", <128 x i1> %m, i32 %evl)
  ret <128 x i1> %v
}

declare <7 x i1> @llvm.vp.fcmp.v7f64(<7 x double>, <7 x double>, metadata, <7 x i1>, i32)

define <7 x i1> @fcmp_oeq_vv_v7f64(<7 x double> %va, <7 x double> %vb, <7 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vv_v7f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <7 x i1> @llvm.vp.fcmp.v7f64(<7 x double> %va, <7 x double> %vb, metadata !"oeq", <7 x i1> %m, i32 %evl)
  ret <7 x i1> %v
}

declare <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double>, <8 x double>, metadata, <8 x i1>, i32)

define <8 x i1> @fcmp_oeq_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"oeq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_oeq_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfeq.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"oeq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_oeq_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfeq.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"oeq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ogt_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ogt_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ogt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ogt_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ogt_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ogt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ogt_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ogt_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"ogt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_oge_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oge_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"oge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_oge_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oge_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"oge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_oge_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oge_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"oge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_olt_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_olt_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"olt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_olt_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_olt_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"olt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_olt_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_olt_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"olt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ole_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ole_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ole", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ole_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ole_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ole", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ole_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ole_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"ole", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_one_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_one_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmflt.vv v17, v12, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"one", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_one_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_one_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmfgt.vf v13, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"one", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_one_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_one_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmflt.vf v13, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"one", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ord_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ord_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v16, v12, v12, v0.t
; CHECK-NEXT:    vmfeq.vv v12, v8, v8, v0.t
; CHECK-NEXT:    vmand.mm v0, v12, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ord", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ord_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ord_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v16, v8, v8, v0.t
; CHECK-NEXT:    vmfeq.vf v8, v12, fa0, v0.t
; CHECK-NEXT:    vmand.mm v0, v16, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ord", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ord_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ord_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v16, v8, v8, v0.t
; CHECK-NEXT:    vmfeq.vf v8, v12, fa0, v0.t
; CHECK-NEXT:    vmand.mm v0, v8, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"ord", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ueq_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ueq_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmflt.vv v17, v12, v8, v0.t
; CHECK-NEXT:    vmnor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ueq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ueq_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ueq_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmfgt.vf v13, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ueq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ueq_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ueq_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmflt.vf v13, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"ueq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ugt_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ugt_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ugt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ugt_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ugt_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ugt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ugt_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ugt_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"ugt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uge_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uge_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"uge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uge_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uge_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"uge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uge_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uge_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"uge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ult_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ult_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ult", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ult_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ult_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ult", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ult_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ult_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"ult", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ule_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ule_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ule", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ule_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ule_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ule", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ule_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ule_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"ule", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_une_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_une_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"une", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_une_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_une_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfne.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"une", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_une_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_une_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfne.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"une", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uno_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uno_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v16, v12, v12, v0.t
; CHECK-NEXT:    vmfne.vv v12, v8, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v12, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"uno", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uno_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uno_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v16, v8, v8, v0.t
; CHECK-NEXT:    vmfne.vf v8, v12, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v16, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"uno", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uno_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uno_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v16, v8, v8, v0.t
; CHECK-NEXT:    vmfne.vf v8, v12, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v8, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"uno", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

declare <32 x i1> @llvm.vp.fcmp.v32f64(<32 x double>, <32 x double>, metadata, <32 x i1>, i32)

define <32 x i1> @fcmp_oeq_vv_v32f64(<32 x double> %va, <32 x double> %vb, <32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vv_v32f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 4
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x10, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 16 * vlenb
; CHECK-NEXT:    vmv1r.v v24, v0
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vs8r.v v8, (a1) # Unknown-size Folded Spill
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    addi a1, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a1) # Unknown-size Folded Spill
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 2, e8, mf4, ta, ma
; CHECK-NEXT:    addi a0, a2, -16
; CHECK-NEXT:    sltu a1, a2, a0
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    and a0, a1, a0
; CHECK-NEXT:    vslidedown.vi v0, v0, 2
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    li a0, 16
; CHECK-NEXT:    vmfeq.vv v1, v16, v8, v0.t
; CHECK-NEXT:    bltu a2, a0, .LBB87_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    li a2, 16
; CHECK-NEXT:  .LBB87_2:
; CHECK-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vl8r.v v24, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vmfeq.vv v16, v8, v24, v0.t
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vslideup.vi v16, v1, 2
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %v = call <32 x i1> @llvm.vp.fcmp.v32f64(<32 x double> %va, <32 x double> %vb, metadata !"oeq", <32 x i1> %m, i32 %evl)
  ret <32 x i1> %v
}
