/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"time"
	"reflect"
)


// RepositoriesAnsibleVersionsAPIService RepositoriesAnsibleVersionsAPI service
type RepositoriesAnsibleVersionsAPIService service

type RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsDeleteRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleVersionsAPIService
	ansibleAnsibleRepositoryVersionHref string
}

func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleVersionsDeleteExecute(r)
}

/*
RepositoriesAnsibleAnsibleVersionsDelete Delete a repository version

Trigger an asynchronous task to delete a repository version.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryVersionHref
 @return RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsDeleteRequest
*/
func (a *RepositoriesAnsibleVersionsAPIService) RepositoriesAnsibleAnsibleVersionsDelete(ctx context.Context, ansibleAnsibleRepositoryVersionHref string) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsDeleteRequest {
	return RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsDeleteRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryVersionHref: ansibleAnsibleRepositoryVersionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesAnsibleVersionsAPIService) RepositoriesAnsibleAnsibleVersionsDeleteExecute(r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleVersionsAPIService.RepositoriesAnsibleAnsibleVersionsDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_version_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_version_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryVersionHref, "ansibleAnsibleRepositoryVersionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleVersionsAPIService
	ansibleAnsibleRepositoryHref string
	content *string
	contentIn *string
	limit *int32
	number *int32
	numberGt *int32
	numberGte *int32
	numberLt *int32
	numberLte *int32
	numberRange *[]int32
	offset *int32
	ordering *[]string
	pulpCreated *time.Time
	pulpCreatedGt *time.Time
	pulpCreatedGte *time.Time
	pulpCreatedLt *time.Time
	pulpCreatedLte *time.Time
	pulpCreatedRange *[]time.Time
	pulpHrefIn *[]string
	fields *[]string
	excludeFields *[]string
}

// Content Unit referenced by HREF
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) Content(content string) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	r.content = &content
	return r
}

// Content Unit referenced by HREF
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) ContentIn(contentIn string) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	r.contentIn = &contentIn
	return r
}

// Number of results to return per page.
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) Limit(limit int32) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	r.limit = &limit
	return r
}

// Filter results where number matches value
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) Number(number int32) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	r.number = &number
	return r
}

// Filter results where number is greater than value
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) NumberGt(numberGt int32) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	r.numberGt = &numberGt
	return r
}

// Filter results where number is greater than or equal to value
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) NumberGte(numberGte int32) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	r.numberGte = &numberGte
	return r
}

// Filter results where number is less than value
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) NumberLt(numberLt int32) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	r.numberLt = &numberLt
	return r
}

// Filter results where number is less than or equal to value
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) NumberLte(numberLte int32) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	r.numberLte = &numberLte
	return r
}

// Filter results where number is between two comma separated values
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) NumberRange(numberRange []int32) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	r.numberRange = &numberRange
	return r
}

// The initial index from which to return the results.
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) Offset(offset int32) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;number&#x60; - Number * &#x60;-number&#x60; - Number (descending) * &#x60;complete&#x60; - Complete * &#x60;-complete&#x60; - Complete (descending) * &#x60;info&#x60; - Info * &#x60;-info&#x60; - Info (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) Ordering(ordering []string) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	r.ordering = &ordering
	return r
}

// Filter results where pulp_created matches value
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) PulpCreated(pulpCreated time.Time) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	r.pulpCreated = &pulpCreated
	return r
}

// Filter results where pulp_created is greater than value
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) PulpCreatedGt(pulpCreatedGt time.Time) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	r.pulpCreatedGt = &pulpCreatedGt
	return r
}

// Filter results where pulp_created is greater than or equal to value
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) PulpCreatedGte(pulpCreatedGte time.Time) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	r.pulpCreatedGte = &pulpCreatedGte
	return r
}

// Filter results where pulp_created is less than value
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) PulpCreatedLt(pulpCreatedLt time.Time) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	r.pulpCreatedLt = &pulpCreatedLt
	return r
}

// Filter results where pulp_created is less than or equal to value
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) PulpCreatedLte(pulpCreatedLte time.Time) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	r.pulpCreatedLte = &pulpCreatedLte
	return r
}

// Filter results where pulp_created is between two comma separated values
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) PulpCreatedRange(pulpCreatedRange []time.Time) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	r.pulpCreatedRange = &pulpCreatedRange
	return r
}

// Multiple values may be separated by commas.
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) PulpHrefIn(pulpHrefIn []string) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// A list of fields to include in the response.
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) Fields(fields []string) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) ExcludeFields(excludeFields []string) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) Execute() (*PaginatedRepositoryVersionResponseList, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleVersionsListExecute(r)
}

/*
RepositoriesAnsibleAnsibleVersionsList List repository versions

AnsibleRepositoryVersion represents a single file repository version.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryHref
 @return RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest
*/
func (a *RepositoriesAnsibleVersionsAPIService) RepositoriesAnsibleAnsibleVersionsList(ctx context.Context, ansibleAnsibleRepositoryHref string) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest {
	return RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryHref: ansibleAnsibleRepositoryHref,
	}
}

// Execute executes the request
//  @return PaginatedRepositoryVersionResponseList
func (a *RepositoriesAnsibleVersionsAPIService) RepositoriesAnsibleAnsibleVersionsListExecute(r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsListRequest) (*PaginatedRepositoryVersionResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedRepositoryVersionResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleVersionsAPIService.RepositoriesAnsibleAnsibleVersionsList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_href}versions/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryHref, "ansibleAnsibleRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.content != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "content", r.content, "")
	}
	if r.contentIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "content__in", r.contentIn, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.number != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "number", r.number, "")
	}
	if r.numberGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "number__gt", r.numberGt, "")
	}
	if r.numberGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "number__gte", r.numberGte, "")
	}
	if r.numberLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "number__lt", r.numberLt, "")
	}
	if r.numberLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "number__lte", r.numberLte, "")
	}
	if r.numberRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "number__range", r.numberRange, "csv")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpCreated != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created", r.pulpCreated, "")
	}
	if r.pulpCreatedGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__gt", r.pulpCreatedGt, "")
	}
	if r.pulpCreatedGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__gte", r.pulpCreatedGte, "")
	}
	if r.pulpCreatedLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__lt", r.pulpCreatedLt, "")
	}
	if r.pulpCreatedLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__lte", r.pulpCreatedLte, "")
	}
	if r.pulpCreatedRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__range", r.pulpCreatedRange, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsReadRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleVersionsAPIService
	ansibleAnsibleRepositoryVersionHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsReadRequest) Fields(fields []string) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsReadRequest) ExcludeFields(excludeFields []string) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsReadRequest) Execute() (*RepositoryVersionResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleVersionsReadExecute(r)
}

/*
RepositoriesAnsibleAnsibleVersionsRead Inspect a repository version

AnsibleRepositoryVersion represents a single file repository version.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryVersionHref
 @return RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsReadRequest
*/
func (a *RepositoriesAnsibleVersionsAPIService) RepositoriesAnsibleAnsibleVersionsRead(ctx context.Context, ansibleAnsibleRepositoryVersionHref string) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsReadRequest {
	return RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsReadRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryVersionHref: ansibleAnsibleRepositoryVersionHref,
	}
}

// Execute executes the request
//  @return RepositoryVersionResponse
func (a *RepositoriesAnsibleVersionsAPIService) RepositoriesAnsibleAnsibleVersionsReadExecute(r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsReadRequest) (*RepositoryVersionResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RepositoryVersionResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleVersionsAPIService.RepositoriesAnsibleAnsibleVersionsRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_version_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_version_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryVersionHref, "ansibleAnsibleRepositoryVersionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsRebuildMetadataRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleVersionsAPIService
	ansibleAnsibleRepositoryVersionHref string
	ansibleRepositoryRebuild *AnsibleRepositoryRebuild
}

func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsRebuildMetadataRequest) AnsibleRepositoryRebuild(ansibleRepositoryRebuild AnsibleRepositoryRebuild) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsRebuildMetadataRequest {
	r.ansibleRepositoryRebuild = &ansibleRepositoryRebuild
	return r
}

func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsRebuildMetadataRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleVersionsRebuildMetadataExecute(r)
}

/*
RepositoriesAnsibleAnsibleVersionsRebuildMetadata Method for RepositoriesAnsibleAnsibleVersionsRebuildMetadata

Trigger an asynchronous task to rebuild Ansible content meta.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryVersionHref
 @return RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsRebuildMetadataRequest
*/
func (a *RepositoriesAnsibleVersionsAPIService) RepositoriesAnsibleAnsibleVersionsRebuildMetadata(ctx context.Context, ansibleAnsibleRepositoryVersionHref string) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsRebuildMetadataRequest {
	return RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsRebuildMetadataRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryVersionHref: ansibleAnsibleRepositoryVersionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesAnsibleVersionsAPIService) RepositoriesAnsibleAnsibleVersionsRebuildMetadataExecute(r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsRebuildMetadataRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleVersionsAPIService.RepositoriesAnsibleAnsibleVersionsRebuildMetadata")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_version_href}rebuild_metadata/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_version_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryVersionHref, "ansibleAnsibleRepositoryVersionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ansibleRepositoryRebuild == nil {
		return localVarReturnValue, nil, reportError("ansibleRepositoryRebuild is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ansibleRepositoryRebuild
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsRepairRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleVersionsAPIService
	ansibleAnsibleRepositoryVersionHref string
	repair *Repair
}

func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsRepairRequest) Repair(repair Repair) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsRepairRequest {
	r.repair = &repair
	return r
}

func (r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsRepairRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleVersionsRepairExecute(r)
}

/*
RepositoriesAnsibleAnsibleVersionsRepair Method for RepositoriesAnsibleAnsibleVersionsRepair

Trigger an asynchronous task to repair a repository version.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryVersionHref
 @return RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsRepairRequest
*/
func (a *RepositoriesAnsibleVersionsAPIService) RepositoriesAnsibleAnsibleVersionsRepair(ctx context.Context, ansibleAnsibleRepositoryVersionHref string) RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsRepairRequest {
	return RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsRepairRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryVersionHref: ansibleAnsibleRepositoryVersionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesAnsibleVersionsAPIService) RepositoriesAnsibleAnsibleVersionsRepairExecute(r RepositoriesAnsibleVersionsAPIRepositoriesAnsibleAnsibleVersionsRepairRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleVersionsAPIService.RepositoriesAnsibleAnsibleVersionsRepair")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_version_href}repair/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_version_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryVersionHref, "ansibleAnsibleRepositoryVersionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.repair == nil {
		return localVarReturnValue, nil, reportError("repair is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.repair
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
