/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"time"
	"reflect"
)


// RepositoriesOstreeVersionsAPIService RepositoriesOstreeVersionsAPI service
type RepositoriesOstreeVersionsAPIService service

type RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsDeleteRequest struct {
	ctx context.Context
	ApiService *RepositoriesOstreeVersionsAPIService
	ostreeOstreeRepositoryVersionHref string
}

func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesOstreeOstreeVersionsDeleteExecute(r)
}

/*
RepositoriesOstreeOstreeVersionsDelete Delete a repository version

Trigger an asynchronous task to delete a repository version.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ostreeOstreeRepositoryVersionHref
 @return RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsDeleteRequest
*/
func (a *RepositoriesOstreeVersionsAPIService) RepositoriesOstreeOstreeVersionsDelete(ctx context.Context, ostreeOstreeRepositoryVersionHref string) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsDeleteRequest {
	return RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsDeleteRequest{
		ApiService: a,
		ctx: ctx,
		ostreeOstreeRepositoryVersionHref: ostreeOstreeRepositoryVersionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesOstreeVersionsAPIService) RepositoriesOstreeOstreeVersionsDeleteExecute(r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesOstreeVersionsAPIService.RepositoriesOstreeOstreeVersionsDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ostree_ostree_repository_version_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ostree_ostree_repository_version_href"+"}", parameterValueToString(r.ostreeOstreeRepositoryVersionHref, "ostreeOstreeRepositoryVersionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest struct {
	ctx context.Context
	ApiService *RepositoriesOstreeVersionsAPIService
	ostreeOstreeRepositoryHref string
	content *string
	contentIn *string
	limit *int32
	number *int32
	numberGt *int32
	numberGte *int32
	numberLt *int32
	numberLte *int32
	numberRange *[]int32
	offset *int32
	ordering *[]string
	pulpCreated *time.Time
	pulpCreatedGt *time.Time
	pulpCreatedGte *time.Time
	pulpCreatedLt *time.Time
	pulpCreatedLte *time.Time
	pulpCreatedRange *[]time.Time
	pulpHrefIn *[]string
	fields *[]string
	excludeFields *[]string
}

// Content Unit referenced by HREF
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) Content(content string) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	r.content = &content
	return r
}

// Content Unit referenced by HREF
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) ContentIn(contentIn string) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	r.contentIn = &contentIn
	return r
}

// Number of results to return per page.
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) Limit(limit int32) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	r.limit = &limit
	return r
}

// Filter results where number matches value
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) Number(number int32) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	r.number = &number
	return r
}

// Filter results where number is greater than value
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) NumberGt(numberGt int32) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	r.numberGt = &numberGt
	return r
}

// Filter results where number is greater than or equal to value
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) NumberGte(numberGte int32) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	r.numberGte = &numberGte
	return r
}

// Filter results where number is less than value
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) NumberLt(numberLt int32) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	r.numberLt = &numberLt
	return r
}

// Filter results where number is less than or equal to value
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) NumberLte(numberLte int32) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	r.numberLte = &numberLte
	return r
}

// Filter results where number is between two comma separated values
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) NumberRange(numberRange []int32) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	r.numberRange = &numberRange
	return r
}

// The initial index from which to return the results.
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) Offset(offset int32) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;number&#x60; - Number * &#x60;-number&#x60; - Number (descending) * &#x60;complete&#x60; - Complete * &#x60;-complete&#x60; - Complete (descending) * &#x60;info&#x60; - Info * &#x60;-info&#x60; - Info (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) Ordering(ordering []string) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	r.ordering = &ordering
	return r
}

// Filter results where pulp_created matches value
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) PulpCreated(pulpCreated time.Time) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	r.pulpCreated = &pulpCreated
	return r
}

// Filter results where pulp_created is greater than value
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) PulpCreatedGt(pulpCreatedGt time.Time) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	r.pulpCreatedGt = &pulpCreatedGt
	return r
}

// Filter results where pulp_created is greater than or equal to value
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) PulpCreatedGte(pulpCreatedGte time.Time) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	r.pulpCreatedGte = &pulpCreatedGte
	return r
}

// Filter results where pulp_created is less than value
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) PulpCreatedLt(pulpCreatedLt time.Time) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	r.pulpCreatedLt = &pulpCreatedLt
	return r
}

// Filter results where pulp_created is less than or equal to value
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) PulpCreatedLte(pulpCreatedLte time.Time) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	r.pulpCreatedLte = &pulpCreatedLte
	return r
}

// Filter results where pulp_created is between two comma separated values
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) PulpCreatedRange(pulpCreatedRange []time.Time) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	r.pulpCreatedRange = &pulpCreatedRange
	return r
}

// Multiple values may be separated by commas.
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) PulpHrefIn(pulpHrefIn []string) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// A list of fields to include in the response.
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) Fields(fields []string) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) ExcludeFields(excludeFields []string) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) Execute() (*PaginatedRepositoryVersionResponseList, *http.Response, error) {
	return r.ApiService.RepositoriesOstreeOstreeVersionsListExecute(r)
}

/*
RepositoriesOstreeOstreeVersionsList List repository versions

A ViewSet class that represents a single OSTree repository version.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ostreeOstreeRepositoryHref
 @return RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest
*/
func (a *RepositoriesOstreeVersionsAPIService) RepositoriesOstreeOstreeVersionsList(ctx context.Context, ostreeOstreeRepositoryHref string) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest {
	return RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest{
		ApiService: a,
		ctx: ctx,
		ostreeOstreeRepositoryHref: ostreeOstreeRepositoryHref,
	}
}

// Execute executes the request
//  @return PaginatedRepositoryVersionResponseList
func (a *RepositoriesOstreeVersionsAPIService) RepositoriesOstreeOstreeVersionsListExecute(r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsListRequest) (*PaginatedRepositoryVersionResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedRepositoryVersionResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesOstreeVersionsAPIService.RepositoriesOstreeOstreeVersionsList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ostree_ostree_repository_href}versions/"
	localVarPath = strings.Replace(localVarPath, "{"+"ostree_ostree_repository_href"+"}", parameterValueToString(r.ostreeOstreeRepositoryHref, "ostreeOstreeRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.content != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "content", r.content, "")
	}
	if r.contentIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "content__in", r.contentIn, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.number != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "number", r.number, "")
	}
	if r.numberGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "number__gt", r.numberGt, "")
	}
	if r.numberGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "number__gte", r.numberGte, "")
	}
	if r.numberLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "number__lt", r.numberLt, "")
	}
	if r.numberLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "number__lte", r.numberLte, "")
	}
	if r.numberRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "number__range", r.numberRange, "csv")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpCreated != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created", r.pulpCreated, "")
	}
	if r.pulpCreatedGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__gt", r.pulpCreatedGt, "")
	}
	if r.pulpCreatedGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__gte", r.pulpCreatedGte, "")
	}
	if r.pulpCreatedLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__lt", r.pulpCreatedLt, "")
	}
	if r.pulpCreatedLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__lte", r.pulpCreatedLte, "")
	}
	if r.pulpCreatedRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__range", r.pulpCreatedRange, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsReadRequest struct {
	ctx context.Context
	ApiService *RepositoriesOstreeVersionsAPIService
	ostreeOstreeRepositoryVersionHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsReadRequest) Fields(fields []string) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsReadRequest) ExcludeFields(excludeFields []string) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsReadRequest) Execute() (*RepositoryVersionResponse, *http.Response, error) {
	return r.ApiService.RepositoriesOstreeOstreeVersionsReadExecute(r)
}

/*
RepositoriesOstreeOstreeVersionsRead Inspect a repository version

A ViewSet class that represents a single OSTree repository version.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ostreeOstreeRepositoryVersionHref
 @return RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsReadRequest
*/
func (a *RepositoriesOstreeVersionsAPIService) RepositoriesOstreeOstreeVersionsRead(ctx context.Context, ostreeOstreeRepositoryVersionHref string) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsReadRequest {
	return RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsReadRequest{
		ApiService: a,
		ctx: ctx,
		ostreeOstreeRepositoryVersionHref: ostreeOstreeRepositoryVersionHref,
	}
}

// Execute executes the request
//  @return RepositoryVersionResponse
func (a *RepositoriesOstreeVersionsAPIService) RepositoriesOstreeOstreeVersionsReadExecute(r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsReadRequest) (*RepositoryVersionResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RepositoryVersionResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesOstreeVersionsAPIService.RepositoriesOstreeOstreeVersionsRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ostree_ostree_repository_version_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ostree_ostree_repository_version_href"+"}", parameterValueToString(r.ostreeOstreeRepositoryVersionHref, "ostreeOstreeRepositoryVersionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsRepairRequest struct {
	ctx context.Context
	ApiService *RepositoriesOstreeVersionsAPIService
	ostreeOstreeRepositoryVersionHref string
	repair *Repair
}

func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsRepairRequest) Repair(repair Repair) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsRepairRequest {
	r.repair = &repair
	return r
}

func (r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsRepairRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesOstreeOstreeVersionsRepairExecute(r)
}

/*
RepositoriesOstreeOstreeVersionsRepair Method for RepositoriesOstreeOstreeVersionsRepair

Trigger an asynchronous task to repair a repository version.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ostreeOstreeRepositoryVersionHref
 @return RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsRepairRequest
*/
func (a *RepositoriesOstreeVersionsAPIService) RepositoriesOstreeOstreeVersionsRepair(ctx context.Context, ostreeOstreeRepositoryVersionHref string) RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsRepairRequest {
	return RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsRepairRequest{
		ApiService: a,
		ctx: ctx,
		ostreeOstreeRepositoryVersionHref: ostreeOstreeRepositoryVersionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesOstreeVersionsAPIService) RepositoriesOstreeOstreeVersionsRepairExecute(r RepositoriesOstreeVersionsAPIRepositoriesOstreeOstreeVersionsRepairRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesOstreeVersionsAPIService.RepositoriesOstreeOstreeVersionsRepair")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ostree_ostree_repository_version_href}repair/"
	localVarPath = strings.Replace(localVarPath, "{"+"ostree_ostree_repository_version_href"+"}", parameterValueToString(r.ostreeOstreeRepositoryVersionHref, "ostreeOstreeRepositoryVersionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.repair == nil {
		return localVarReturnValue, nil, reportError("repair is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.repair
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
