/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dogtagpki.acme.ACMENonce;
import org.dogtagpki.acme.issuer.ACMEIssuer;
import org.dogtagpki.acme.server.ACMEEngine;
import org.dogtagpki.acme.server.ACMEManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="cert/{id}")
@ACMEManagedService
public class ACMECertificateService {
    public static Logger logger = LoggerFactory.getLogger(ACMECertificateService.class);
    @Context
    UriInfo uriInfo;

    @GET
    @Produces(value={"application/pem-certificate-chain"})
    public Response handleGET(@PathParam(value="id") String certID) throws Exception {
        return this.getCertificate(certID);
    }

    @POST
    @Produces(value={"application/pem-certificate-chain"})
    public Response handlePOST(@PathParam(value="id") String certID) throws Exception {
        return this.getCertificate(certID);
    }

    public Response getCertificate(String certID) throws Exception {
        logger.info("Retrieving certificate " + certID);
        ACMEEngine engine = ACMEEngine.getInstance();
        ACMEIssuer issuer = engine.getIssuer();
        String certChain = issuer.getCertificateChain(certID);
        Response.ResponseBuilder builder = Response.ok();
        ACMENonce nonce = engine.createNonce();
        builder.header("Replay-Nonce", (Object)nonce.getID());
        URI directoryURL = this.uriInfo.getBaseUriBuilder().path("directory").build(new Object[0]);
        builder.link(directoryURL, "index");
        builder.entity((Object)certChain);
        return builder.build();
    }
}

