/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.ca;

import com.netscape.certsrv.ca.CAClient;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.cmstools.ca.PublisherOCSPCLI;
import com.netscape.cmstools.cli.MainCLI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;

public class PublisherOCSPAddCLI
extends CommandCLI {
    public PublisherOCSPCLI publisherOCSPCLI;

    public PublisherOCSPAddCLI(PublisherOCSPCLI publisherOCSPCLI) {
        super("add", "Add OCSP publisher", (CLI)publisherOCSPCLI);
        this.publisherOCSPCLI = publisherOCSPCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "url", true, "Publisher URL");
        option.setArgName("URL");
        this.options.addOption(option);
        option = new Option(null, "subsystem-cert", true, "Subsystem certificate path");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "session", true, "Session ID");
        option.setArgName("ID");
        this.options.addOption(option);
        option = new Option(null, "install-token", true, "Install token");
        option.setArgName("path");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        String publisherURL = cmd.getOptionValue("url");
        if (publisherURL == null) {
            throw new Exception("Missing publisher URL");
        }
        URL url = new URL(publisherURL);
        String subsystemCertPath = cmd.getOptionValue("subsystem-cert");
        if (subsystemCertPath == null) {
            throw new Exception("Missing subsystem certificate");
        }
        String subsystemCert = new String(Files.readAllBytes(Paths.get(subsystemCertPath, new String[0])));
        String installToken = cmd.getOptionValue("install-token");
        String sessionID = installToken != null ? new String(Files.readAllBytes(Paths.get(installToken, new String[0]))) : cmd.getOptionValue("session");
        if (sessionID == null) {
            throw new Exception("Missing session ID or install token");
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        PKIClient client = mainCLI.getClient();
        CAClient caClient = new CAClient(client);
        caClient.addOCSPPublisher(url, subsystemCert, sessionID);
    }
}

