/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authentication;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authentication.ISharedToken;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.cms.authentication.DirBasedAuthentication;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LdapBoundConnFactory;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.math.BigInteger;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPSearchResults;
import org.dogtagpki.server.authentication.AuthManagerConfig;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.pkix.cmc.PKIData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedSecret
extends DirBasedAuthentication
implements ISharedToken {
    public static Logger logger = LoggerFactory.getLogger(SharedSecret.class);
    public static final String CRED_ShrTok = "shrTok";
    protected static String[] mRequiredCreds = new String[]{"shrTok"};
    protected static final String PROP_DNPATTERN = "dnpattern";
    protected static final String PROP_LDAPSTRINGATTRS = "ldapStringAttributes";
    protected static final String PROP_LDAPBYTEATTRS = "ldapByteAttributes";
    protected static final String PROP_LDAP_BOUND_CONN = "ldapBoundConn";
    protected static final String PROP_LDAP_BOUND_TAG = "ldapauth.bindPWPrompt";
    public static final String PROP_SharedToken_ATTR = "shrTokAttr";
    public static final String DEF_SharedToken_ATTR = "shrTok";
    public KeyWrapAlgorithm wrapAlgorithm = KeyWrapAlgorithm.RSA;
    protected static String[] mConfigParams = new String[]{"shrTokAttr", "dnpattern", "ldapStringAttributes", "ldapByteAttributes", "ldap.ldapconn.host", "ldap.ldapconn.port", "ldap.ldapconn.secureConn", "ldap.ldapconn.version", "ldap.ldapauth.bindDN", "ldap.ldapauth.bindPWPrompt", "ldap.ldapauth.clientCertNickname", "ldap.ldapauth.authtype", "ldap.basedn", "ldap.minConns", "ldap.maxConns"};
    protected String mShrTokAttr = "shrTok";
    private LdapBoundConnFactory shrTokLdapFactory;
    private LDAPConfig shrTokLdapConfigStore;
    private PrivateKey issuanceProtPrivKey = null;
    protected CryptoToken token = null;
    protected byte[] iv = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    EncryptionAlgorithm encryptAlgorithm = EncryptionAlgorithm.AES_128_CBC_PAD;
    CertificateRepository certRepository;

    public void init(AuthenticationConfig authenticationConfig, String name, String implName, AuthManagerConfig config) throws EBaseException {
        String method = "SharedSecret.init: ";
        Object msg = "";
        logger.debug(method + " begins.");
        super.init(authenticationConfig, name, implName, config);
        CAEngine caEngine = (CAEngine)this.engine;
        CAEngineConfig cs = caEngine.getConfig();
        this.mShrTokAttr = config.getString(PROP_SharedToken_ATTR, "shrTok");
        if (this.mShrTokAttr == null) {
            msg = method + "shrTokAttr null";
            logger.error((String)msg);
            throw new EBaseException((String)msg);
        }
        if (this.mShrTokAttr.equals("")) {
            this.mShrTokAttr = "shrTok";
        }
        boolean useOAEP = cs.getUseOAEPKeyWrap();
        logger.debug(method + " keyWrap.useOAEP: " + useOAEP);
        if (useOAEP) {
            this.wrapAlgorithm = KeyWrapAlgorithm.RSA_OAEP;
        }
        this.initLdapConn(config);
        this.issuanceProtPrivKey = caEngine.getIssuanceProtectionPrivateKey();
        if (this.issuanceProtPrivKey == null) {
            msg = method + "issuanceProtPrivKey null";
            logger.error((String)msg);
            throw new EBaseException((String)msg);
        }
        logger.debug(method + "got issuanceProtPrivKey");
        this.certRepository = caEngine.getCertificateRepository();
        if (this.certRepository == null) {
            msg = method + "certRepository null";
            logger.error((String)msg);
            throw new EBaseException((String)msg);
        }
        try {
            String tokenName = cs.getString("cmc.token", "internal");
            logger.debug(method + "getting token :" + tokenName);
            this.token = CryptoUtil.getKeyStorageToken((String)tokenName);
        }
        catch (Exception e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            throw new EBaseException(e);
        }
        if (this.token == null) {
            msg = method + "token null";
            logger.error((String)msg);
            throw new EBaseException((String)msg);
        }
        logger.debug(method + " ends.");
    }

    public void init(ConfigStore config) throws EProfileException {
    }

    public void initLdapConn(AuthManagerConfig config) throws EBaseException {
        String method = "SharedSecret.initLdapConn";
        Object msg = "";
        CAEngine caEngine = (CAEngine)this.engine;
        CAEngineConfig cs = caEngine.getConfig();
        this.shrTokLdapConfigStore = config.getLDAPConfig();
        if (this.shrTokLdapConfigStore == null) {
            msg = method + "config substore ldap null";
            logger.error((String)msg);
            throw new EBaseException((String)msg);
        }
        PKISocketConfig socketConfig = cs.getSocketConfig();
        LdapBoundConnFactory connFactory = new LdapBoundConnFactory("SharedSecret");
        connFactory.setCMSEngine(this.engine);
        connFactory.init(socketConfig, this.shrTokLdapConfigStore, this.engine.getPasswordStore());
        this.shrTokLdapFactory = connFactory;
    }

    public char[] getSharedToken(String identification, AuthToken authToken) throws EBaseException {
        char[] cArray;
        block14: {
            String method = "SharedSecret.getSharedToken(String identification, AuthToken authToken): ";
            Object msg = "";
            logger.debug(method + "begins.");
            if (identification == null || authToken == null) {
                throw new EBaseException(method + "paramsters identification or authToken cannot be null");
            }
            LDAPConnection shrTokLdapConnection = null;
            LDAPSearchResults res = null;
            LDAPEntry entry = null;
            try {
                logger.debug(method + "searching for identification =" + identification + "; mShrTokAttr =" + this.mShrTokAttr);
                shrTokLdapConnection = this.shrTokLdapFactory.getConn();
                if (shrTokLdapConnection == null) {
                    msg = method + "shrTokLdapConnection is null!!";
                    logger.error((String)msg);
                    throw new EBaseException((String)msg);
                }
                String userdn = null;
                res = shrTokLdapConnection.search(this.mBaseDN, 2, "(uid=" + identification + ")", null, false);
                if (res == null) {
                    msg = method + "shrTokLdapConnection.search returns null!!";
                    logger.error((String)msg);
                    throw new EBaseException((String)msg);
                }
                if (!res.hasMoreElements()) {
                    logger.error("SharedSecret: " + CMS.getLogMessage((String)"CMS_AUTH_USER_NOT_EXIST", (Object[])new Object[]{identification}));
                    msg = method + "ldap search result contains nothing";
                    logger.error((String)msg);
                    throw new EInvalidCredentials(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]));
                }
                entry = (LDAPEntry)res.nextElement();
                userdn = entry.getDN();
                if (userdn == null) {
                    msg = method + "ldap entry found userdn null!!";
                    logger.error((String)msg);
                    throw new EBaseException((String)msg);
                }
                logger.debug(method + "found user ldap entry: userdn = " + userdn);
                authToken.set("tokenCertSubject", userdn);
                res = shrTokLdapConnection.search(userdn, 0, "(objectclass=*)", new String[]{this.mShrTokAttr}, false);
                if (res == null || !res.hasMoreElements()) {
                    msg = method + "no entry returned for " + identification;
                    logger.error((String)msg);
                    throw new EInvalidCredentials(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]));
                }
                entry = (LDAPEntry)res.nextElement();
                LDAPAttribute shrTokAttr = entry.getAttribute(this.mShrTokAttr);
                if (shrTokAttr == null) {
                    logger.error(method + "no shared token attribute found");
                    throw new EInvalidCredentials(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]));
                }
                Enumeration shrTokValues = shrTokAttr.getByteValues();
                if (!shrTokValues.hasMoreElements()) {
                    logger.error(method + "no shared token attribute values found");
                    throw new EInvalidCredentials(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]));
                }
                byte[] entryShrTok = (byte[])shrTokValues.nextElement();
                if (entryShrTok == null) {
                    logger.error(method + "no shared token value found");
                    throw new EInvalidCredentials(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]));
                }
                logger.debug(method + " got entryShrTok");
                char[] shrSecret = this.decryptShrTokData(new String(entryShrTok));
                logger.debug(method + "returning");
                cArray = shrSecret;
                if (shrTokLdapConnection == null) break block14;
            }
            catch (Exception e) {
                try {
                    logger.error(method + " exception: " + e.toString());
                    throw new EBaseException(method + e.toString());
                }
                catch (Throwable throwable) {
                    if (shrTokLdapConnection != null) {
                        this.shrTokLdapFactory.returnConn(shrTokLdapConnection);
                    }
                    throw throwable;
                }
            }
            this.shrTokLdapFactory.returnConn(shrTokLdapConnection);
        }
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] decryptShrTokData(String data_s) {
        String method = "SharedSecret.decryptShrTokData: ";
        byte[] ver_passphrase = null;
        try {
            char[] ver_spassphraseChars;
            byte[] wrapped_secret_data = Utils.base64decode((String)data_s);
            DerValue wrapped_val = new DerValue(wrapped_secret_data);
            DerInputStream wrapped_in = wrapped_val.data;
            DerValue wrapped_dSession = wrapped_in.getDerValue();
            byte[] wrapped_session = wrapped_dSession.getOctetString();
            logger.debug(method + "wrapped session key retrieved");
            DerValue wrapped_dPassphrase = wrapped_in.getDerValue();
            byte[] wrapped_passphrase = wrapped_dPassphrase.getOctetString();
            logger.debug(method + "wrapped passphrase retrieved");
            SymmetricKey ver_session = CryptoUtil.unwrap((CryptoToken)this.token, (SymmetricKey.Type)SymmetricKey.AES, (int)128, (SymmetricKey.Usage)SymmetricKey.Usage.UNWRAP, (PrivateKey)this.issuanceProtPrivKey, (byte[])wrapped_session, (KeyWrapAlgorithm)this.wrapAlgorithm);
            ver_passphrase = CryptoUtil.decryptUsingSymmetricKey((CryptoToken)this.token, (IVParameterSpec)new IVParameterSpec(this.iv), (byte[])wrapped_passphrase, (SymmetricKey)ver_session, (EncryptionAlgorithm)this.encryptAlgorithm);
            char[] cArray = ver_spassphraseChars = CryptoUtil.bytesToChars((byte[])ver_passphrase);
            CryptoUtil.obscureBytes((byte[])ver_passphrase, (String)"random");
            return cArray;
        }
        catch (Exception e) {
            logger.warn(method + e.getMessage(), (Throwable)e);
            char[] cArray = null;
            return cArray;
        }
        finally {
            CryptoUtil.obscureBytes(ver_passphrase, (String)"random");
        }
    }

    public char[] getSharedToken(PKIData cmcdata) throws EBaseException {
        String method = "SharedSecret.getSharedToken(PKIData cmcdata): ";
        String msg = "";
        throw new EBaseException(method + msg);
    }

    public char[] getSharedToken(BigInteger serial) throws EBaseException {
        String method = "SharedSecret.getSharedToken(BigInteger serial): ";
        Object msg = "";
        if (serial == null) {
            throw new EBaseException(method + "paramster serial cannot be null");
        }
        logger.debug(method + serial.toString());
        CertRecord record = null;
        try {
            record = this.certRepository.readCertificateRecord(serial);
        }
        catch (EBaseException ee) {
            msg = method + "cert record not found: " + ee.getMessage();
            logger.error((String)msg, (Throwable)ee);
            throw ee;
        }
        MetaInfo metaInfo = (MetaInfo)record.get("certMetaInfo");
        if (metaInfo == null) {
            msg = "cert record metaInfo not found";
            logger.error(method + (String)msg);
            throw new EBaseException(method + (String)msg);
        }
        String shrTok_s = (String)metaInfo.get("revShrTok");
        if (shrTok_s == null) {
            msg = "shrTok not found in metaInfo";
            logger.error(method + (String)msg);
            throw new EBaseException(method + (String)msg);
        }
        char[] shrSecret = this.decryptShrTokData(shrTok_s);
        logger.debug(method + "returning");
        return shrSecret;
    }

    protected String authenticate(LDAPConnection conn, AuthCredentials authCreds, AuthToken token) throws EBaseException {
        String method = "SharedSecret:authenticate: ";
        throw new EBaseException(method + " unsupported to be called this way.");
    }

    public String[] getConfigParams() {
        return mConfigParams;
    }

    public String[] getRequiredCreds() {
        return mRequiredCreds;
    }

    static {
        mExtendedPluginInfo.add("shrTokAttr;string;directory attribute to use for pin (default 'pin')");
        mExtendedPluginInfo.add("ldap.ldapauth.bindDN;string;DN to bind. For example 'CN=SharedToken User'");
        mExtendedPluginInfo.add("ldap.ldapauth.bindPWPrompt;password;Enter password used to bind as the above user");
        mExtendedPluginInfo.add("ldap.ldapauth.clientCertNickname;string;If you want to use SSL client auth to the directory, set the client cert nickname here");
        mExtendedPluginInfo.add("ldap.ldapauth.authtype;choice(BasicAuth,SslClientAuth),required;How to bind to the directory (for pin removal only)");
        mExtendedPluginInfo.add("HELP_TEXT;Authenticate the username, password and pin provided by the user against an LDAP directory. Works with the Dir/ShrTok Based Enrollment HTML form");
        mExtendedPluginInfo.add("HELP_TOKEN;configuration-authrules-uidpwdpindirauth");
    }
}

