/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.constraint;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.constraint.EnrollConstraint;
import com.netscape.cms.profile.def.NoDefault;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertRecordList;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.request.Request;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueKeyConstraint
extends EnrollConstraint {
    public static Logger logger = LoggerFactory.getLogger(UniqueKeyConstraint.class);
    public static final String CONFIG_ALLOW_SAME_KEY_RENEWAL = "allowSameKeyRenewal";
    boolean mAllowSameKeyRenewal = false;

    public UniqueKeyConstraint() {
        this.addConfigName(CONFIG_ALLOW_SAME_KEY_RENEWAL);
    }

    @Override
    public void init(ConfigStore config) throws EProfileException {
        super.init(config);
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals(CONFIG_ALLOW_SAME_KEY_RENEWAL)) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CONFIG_ALLOW_SAME_KEY_RENEWAL", (String[])new String[0]));
        }
        return null;
    }

    public String getDefaultConfig(String name) {
        return null;
    }

    @Override
    public void validate(Request request, X509CertInfo info) throws ERejectException {
        boolean rejected;
        Object msg;
        String method;
        block19: {
            CertRecordList list;
            method = "UniqueKeyConstraint: validate: ";
            msg = "";
            rejected = false;
            int size = 0;
            this.mAllowSameKeyRenewal = this.getConfigBoolean(CONFIG_ALLOW_SAME_KEY_RENEWAL);
            msg = (String)msg + ": allowSameKeyRenewal=" + this.mAllowSameKeyRenewal + ";";
            logger.debug(method + (String)msg);
            CAEngine engine = CAEngine.getInstance();
            CertificateRepository cr = engine.getCertificateRepository();
            try {
                CertificateX509Key infokey = (CertificateX509Key)info.get("key");
                X509Key key = (X509Key)infokey.get("value");
                byte[] pub = key.getEncoded();
                String pub_s = UniqueKeyConstraint.escapeBinaryData(pub);
                String filter = "(x509cert.publicKeyData=" + pub_s + ")";
                list = cr.findCertRecordsInList(filter, null, 10);
                size = list.getSize();
            }
            catch (Exception e) {
                throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_INTERNAL_ERROR", (String[])new String[]{method + e.toString()}));
            }
            if (size > 0) {
                logger.debug(method + "found existing cert with same key");
                if (this.mAllowSameKeyRenewal) {
                    X500Name sjname_in_db = null;
                    X500Name sjname_in_req = null;
                    try {
                        CertificateSubjectName subName = (CertificateSubjectName)info.get("subject");
                        if (subName != null) {
                            sjname_in_req = (X500Name)subName.get("dname");
                            logger.debug(method + " cert request subject DN =" + sjname_in_req.toString());
                            Enumeration e = list.getCertRecords(0, size - 1);
                            Date latestOrigNotAfter = null;
                            Date origNotAfter = null;
                            boolean first = true;
                            while (e != null && e.hasMoreElements()) {
                                logger.debug(method + (String)msg);
                                CertRecord rec = (CertRecord)e.nextElement();
                                BigInteger serial = rec.getSerialNumber();
                                msg = (String)msg + "existing cert with same key found: " + serial.toString() + ";";
                                if (rec.getStatus().equals("REVOKED") || rec.getStatus().equals("REVOKED_EXPIRED")) {
                                    msg = (String)msg + "revoked cert cannot be renewed;";
                                    logger.debug(method + (String)msg);
                                    rejected = true;
                                    break;
                                }
                                if (!rec.getStatus().equals("VALID") && !rec.getStatus().equals("EXPIRED")) {
                                    logger.debug(method + "invalid cert cannot be renewed; continue;" + serial.toString());
                                    continue;
                                }
                                X509CertImpl origCert = rec.getCertificate();
                                sjname_in_db = origCert.getSubjectName();
                                if (!sjname_in_db.equals((Object)sjname_in_req)) {
                                    msg = (String)msg + "subject name not match in same key renewal;";
                                    rejected = true;
                                    break;
                                }
                                logger.debug("subject name match in same key renewal");
                                origNotAfter = origCert.getNotAfter();
                                logger.debug(method + "origNotAfter =" + origNotAfter.toString());
                                if (first) {
                                    latestOrigNotAfter = origNotAfter;
                                    first = false;
                                } else if (latestOrigNotAfter.before(origNotAfter)) {
                                    logger.debug(method + "newer cert found");
                                    latestOrigNotAfter = origNotAfter;
                                }
                                rejected = false;
                            }
                            if (latestOrigNotAfter != null) {
                                String existingOrigExpDate_s = request.getExtDataInString("origNotAfter");
                                if (existingOrigExpDate_s != null) {
                                    logger.debug(method + " original cert expiration date already exists. Not overriding.");
                                } else {
                                    logger.debug(method + "setting latest original cert expiration in request");
                                    request.setExtData("origNotAfter", BigInteger.valueOf(latestOrigNotAfter.getTime()));
                                }
                            }
                            break block19;
                        }
                        msg = (String)msg + "subject name not found in cert request info;";
                        rejected = true;
                    }
                    catch (Exception ex1) {
                        logger.warn(method + (String)msg + ex1.getMessage(), (Throwable)ex1);
                        rejected = true;
                    }
                } else {
                    msg = (String)msg + "found existing cert with same key;";
                    rejected = true;
                }
            }
        }
        if (rejected) {
            logger.debug(method + " rejected: " + (String)msg);
            throw new ERejectException((String)msg);
        }
        logger.debug(method + " approved");
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{};
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CONSTRAINT_ALLOW_SAME_KEY_RENEWAL_TEXT", (String[])params);
    }

    public static String escapeBinaryData(byte[] data) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int v = 0xFF & data[i];
            sb.append("\\");
            sb.append(v < 16 ? "0" : "");
            sb.append(Integer.toHexString(v));
        }
        return sb.toString();
    }

    @Override
    public boolean isApplicable(PolicyDefault def) {
        return def instanceof NoDefault;
    }
}

