/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.publish.publishers;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.publish.Publisher;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import netscape.ldap.LDAPConnection;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.mozilla.jss.util.Base64OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedPublisher
extends Publisher
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(FileBasedPublisher.class);
    private static final String PROP_DIR = "directory";
    private static final String PROP_DER = "Filename.der";
    private static final String PROP_B64 = "Filename.b64";
    private static final String PROP_LNK = "latestCrlLink";
    private static final String PROP_GMT = "timeStamp";
    private static final String PROP_EXT = "crlLinkExt";
    private static final String PROP_ZIP = "zipCRLs";
    private static final String PROP_LEV = "zipLevel";
    private static final String PROP_MAX_AGE = "maxAge";
    private static final String PROP_MAX_FULL_CRLS = "maxFullCRLs";
    private ConfigStore mConfig;
    private String mDir = null;
    private String mCrlIssuingPointId;
    protected boolean mDerAttr = true;
    protected boolean mB64Attr = false;
    protected boolean mLatestCRL = false;
    protected boolean mZipCRL = false;
    protected String mTimeStamp = null;
    protected String mLinkExt = null;
    protected int mZipLevel = 9;
    protected int maxAge = 0;
    protected int maxFullCRLs = 0;

    public void setIssuingPointId(String crlIssuingPointId) {
        this.mCrlIssuingPointId = crlIssuingPointId;
    }

    public String getImplName() {
        return "FileBasedPublisher";
    }

    public String getDescription() {
        return "This publisher writes the Certificates and CRLs into files.";
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"directory;string;Directory in which to put the files (absolute path or relative path to cert-* instance directory).", "Filename.der;boolean;Store certificates or CRLs into *.der files.", "Filename.b64;boolean;Store certificates or CRLs into *.b64 files.", "timeStamp;choice(LocalTime,GMT);Use local time or GMT to time stamp CRL file name with CRL's 'thisUpdate' field.", "latestCrlLink;boolean;Generate link to the latest binary CRL. It requires 'Filename.der' to be enabled.", "crlLinkExt;string;Name extension used by link to the latest CRL. Default name extension is 'der'.", "zipCRLs;boolean;Generate compressed CRLs.", "zipLevel;choice(0,1,2,3,4,5,6,7,8,9);Set compression level from 0 to 9.", "maxAge;integer;Number of days after which files should expire and be purged. Default is 0, which means to never expire.", "maxFullCRLs;integer;Maximum number of full CRLs to be kept.  Once new files are published, the oldest files will be purged.  Default is 0 (no limit)", "HELP_TOKEN;configuration-ldappublish-publisher-filepublisher", "HELP_TEXT;Stores the certificates or CRLs into files. Certificate is named as cert-<serialno>.der or *.b64, and CRL is named as <IssuingPoint>-<thisUpdate-time>.der or *.b64."};
        return params;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> v = new Vector<String>();
        String dir = "";
        String ext = "";
        try {
            dir = this.mConfig.getString(PROP_DIR);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        try {
            ext = this.mConfig.getString(PROP_EXT);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        try {
            this.mTimeStamp = this.mConfig.getString(PROP_GMT);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        try {
            this.mZipLevel = this.mConfig.getInteger(PROP_LEV, 9);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        try {
            this.maxFullCRLs = this.mConfig.getInteger(PROP_MAX_FULL_CRLS, 0);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        try {
            this.maxAge = this.mConfig.getInteger(PROP_MAX_AGE, 0);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        try {
            if (this.mTimeStamp == null || !this.mTimeStamp.equals("GMT")) {
                this.mTimeStamp = "LocalTime";
            }
            v.addElement("directory=" + dir);
            v.addElement("Filename.der=" + this.mConfig.getBoolean(PROP_DER, true));
            v.addElement("Filename.b64=" + this.mConfig.getBoolean(PROP_B64, false));
            v.addElement("timeStamp=" + this.mTimeStamp);
            v.addElement("latestCrlLink=" + this.mConfig.getBoolean(PROP_LNK, false));
            v.addElement("crlLinkExt=" + ext);
            v.addElement("zipCRLs=" + this.mConfig.getBoolean(PROP_ZIP, false));
            v.addElement("zipLevel=" + this.mZipLevel);
            v.addElement("maxFullCRLs=" + this.maxFullCRLs);
            v.addElement("maxAge=" + this.maxAge);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> v = new Vector<String>();
        v.addElement("directory=");
        v.addElement("Filename.der=true");
        v.addElement("Filename.b64=false");
        v.addElement("timeStamp=LocalTime");
        v.addElement("latestCrlLink=false");
        v.addElement("crlLinkExt=");
        v.addElement("zipCRLs=false");
        v.addElement("zipLevel=9");
        v.addElement("maxFullCRLs=0");
        v.addElement("maxAge=0");
        return v;
    }

    public void init(ConfigStore config) {
        this.mConfig = config;
        String dir = null;
        try {
            dir = this.mConfig.getString(PROP_DIR, null);
            this.mDerAttr = this.mConfig.getBoolean(PROP_DER, true);
            this.mB64Attr = this.mConfig.getBoolean(PROP_B64, false);
            this.mTimeStamp = this.mConfig.getString(PROP_GMT, "LocalTime");
            this.mLatestCRL = this.mConfig.getBoolean(PROP_LNK, false);
            this.mLinkExt = this.mConfig.getString(PROP_EXT, null);
            this.mZipCRL = this.mConfig.getBoolean(PROP_ZIP, false);
            this.mZipLevel = this.mConfig.getInteger(PROP_LEV, 9);
            this.maxFullCRLs = this.mConfig.getInteger(PROP_MAX_FULL_CRLS, 0);
            this.maxAge = this.mConfig.getInteger(PROP_MAX_AGE, 0);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        if (dir == null) {
            throw new RuntimeException("No Directory Specified");
        }
        dir = dir.replace('\\', '/');
        config.putString(PROP_DIR, dir);
        File dirCheck = new File(dir);
        if (dirCheck.isDirectory()) {
            this.mDir = dir;
        } else {
            String instanceDir = CMS.getInstanceDir();
            dirCheck = new File(instanceDir + File.separator + dir);
            if (dirCheck.isDirectory()) {
                this.mDir = instanceDir + File.separator + dir;
            } else {
                throw new RuntimeException("Invalid Directory " + dir);
            }
        }
    }

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    private String getGeneralCrlPrefix() {
        if (this.mCrlIssuingPointId != null && this.mCrlIssuingPointId.length() != 0) {
            return this.mCrlIssuingPointId;
        }
        return "crl";
    }

    private String[] getCrlNamePrefix(X509CRL crl, boolean useGMT) {
        String[] namePrefix = new String[]{this.getGeneralCrlPrefix(), this.getGeneralCrlPrefix()};
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd-HHmmss");
        TimeZone tz = TimeZone.getTimeZone("GMT");
        if (useGMT) {
            format.setTimeZone(tz);
        }
        String timeStamp = format.format(crl.getThisUpdate()).toString();
        namePrefix[0] = namePrefix[0] + "-" + timeStamp;
        if (((X509CRLImpl)crl).isDeltaCRL()) {
            namePrefix[0] = namePrefix[0] + "-delta";
            namePrefix[1] = namePrefix[1] + "-delta";
        }
        return namePrefix;
    }

    private void createLink(String linkName, String fileName) {
        String cmd = "ln -s " + fileName + " " + linkName + ".new";
        if (Utils.exec((String)cmd)) {
            File newLink;
            File link;
            File oldLink = new File(linkName + ".old");
            if (oldLink.exists()) {
                oldLink.delete();
            }
            if ((link = new File(linkName)).exists()) {
                link.renameTo(new File(linkName + ".old"));
            }
            if ((newLink = new File(linkName + ".new")).exists()) {
                newLink.renameTo(new File(linkName));
            }
            if ((oldLink = new File(linkName + ".old")).exists()) {
                oldLink.delete();
            }
        } else {
            logger.warn("FileBasedPublisher:  createLink: '" + cmd + "' --- failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LDAPConnection conn, String dn, Object object) throws ELdapException {
        block37: {
            logger.debug("FileBasedPublisher: publish");
            try {
                FileOutputStream fos;
                if (object instanceof X509Certificate) {
                    X509Certificate cert = (X509Certificate)object;
                    BigInteger sno = cert.getSerialNumber();
                    String name = this.mDir + File.separator + "cert-" + sno.toString();
                    if (this.mDerAttr) {
                        try (FileOutputStream fos2 = null;){
                            String fileName = name + ".der";
                            fos2 = new FileOutputStream(fileName);
                            fos2.write(cert.getEncoded());
                        }
                    }
                    if (!this.mB64Attr) break block37;
                    String fileName = name + ".b64";
                    PrintStream ps = null;
                    Base64OutputStream b64 = null;
                    FileOutputStream fos3 = null;
                    try {
                        fos3 = new FileOutputStream(fileName);
                        ByteArrayOutputStream output = new ByteArrayOutputStream();
                        b64 = new Base64OutputStream(new PrintStream(new FilterOutputStream(output)));
                        b64.write(cert.getEncoded());
                        b64.flush();
                        ps = new PrintStream(fos3);
                        ps.print(output.toString("8859_1"));
                        break block37;
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                        if (b64 != null) {
                            b64.close();
                        }
                        if (fos3 != null) {
                            fos3.close();
                        }
                    }
                }
                if (!(object instanceof X509CRL)) break block37;
                X509CRL crl = (X509CRL)object;
                String[] namePrefix = this.getCrlNamePrefix(crl, this.mTimeStamp.equals("GMT"));
                String baseName = this.mDir + File.separator + namePrefix[0];
                String tempFile = baseName + ".temp";
                ZipOutputStream zos = null;
                byte[] encodedArray = null;
                File destFile = null;
                String destName = null;
                File renameFile = null;
                if (this.mDerAttr) {
                    fos = null;
                    try {
                        fos = new FileOutputStream(tempFile);
                        encodedArray = crl.getEncoded();
                        fos.write(encodedArray);
                    }
                    finally {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    if (this.mZipCRL) {
                        try {
                            zos = new ZipOutputStream(new FileOutputStream(baseName + ".zip"));
                            zos.setLevel(this.mZipLevel);
                            zos.putNextEntry(new ZipEntry(baseName + ".der"));
                            zos.write(encodedArray, 0, encodedArray.length);
                            zos.closeEntry();
                        }
                        finally {
                            if (zos != null) {
                                zos.close();
                            }
                        }
                    }
                    if ((destFile = new File(destName = baseName + ".der")).exists()) {
                        destFile.delete();
                    }
                    renameFile = new File(tempFile);
                    renameFile.renameTo(destFile);
                    if (this.mLatestCRL) {
                        Object linkExt = ".";
                        linkExt = this.mLinkExt != null && this.mLinkExt.length() > 0 ? (String)linkExt + this.mLinkExt : (String)linkExt + "der";
                        String linkName = this.mDir + File.separator + namePrefix[1] + (String)linkExt;
                        this.createLink(linkName, destName);
                        if (this.mZipCRL) {
                            linkName = this.mDir + File.separator + namePrefix[1] + ".zip";
                            this.createLink(linkName, baseName + ".zip");
                        }
                    }
                }
                if (this.mB64Attr) {
                    if (encodedArray == null) {
                        encodedArray = crl.getEncoded();
                    }
                    fos = null;
                    try {
                        fos = new FileOutputStream(tempFile);
                        fos.write(Utils.base64encode((byte[])encodedArray, (boolean)true).getBytes());
                    }
                    finally {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    destName = baseName + ".b64";
                    destFile = new File(destName);
                    if (destFile.exists()) {
                        destFile.delete();
                    }
                    renameFile = new File(tempFile);
                    renameFile.renameTo(destFile);
                }
                this.purgeExpiredFiles();
                this.purgeExcessFiles();
            }
            catch (IOException e) {
                logger.warn(CMS.getLogMessage((String)"PUBLISH_FILE_PUBLISHER_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            catch (CertificateEncodingException e) {
                logger.warn(CMS.getLogMessage((String)"PUBLISH_FILE_PUBLISHER_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            catch (CRLException e) {
                logger.warn(CMS.getLogMessage((String)"PUBLISH_FILE_PUBLISHER_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
        }
    }

    public File[] getCRLFiles(File dir) {
        String pattern = this.getGeneralCrlPrefix() + "-\\d{8}-\\d{6}(-delta)?.(der|b64|zip)";
        RegexFileFilter filter = new RegexFileFilter(pattern);
        return dir.listFiles((FileFilter)filter);
    }

    public File[] getFullCRLFiles(File dir) {
        String pattern = this.getGeneralCrlPrefix() + "-\\d{8}-\\d{6}.(der|b64|zip)";
        RegexFileFilter filter = new RegexFileFilter(pattern);
        return dir.listFiles((FileFilter)filter);
    }

    long getCreationTime(File file) throws ParseException {
        String pattern = this.getGeneralCrlPrefix() + "-(\\d{8}-\\d{6})(-delta)?.(der|b64|zip)";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(file.getName());
        if (!m.matches()) {
            throw new ParseException("Invalid date format.", 0);
        }
        String creationTimeString = m.group(1);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd-HHmmss");
        Date creationTime = format.parse(creationTimeString);
        return creationTime.getTime();
    }

    public void purgeExpiredFiles() {
        File dir = new File(this.mDir);
        if (!dir.isDirectory()) {
            return;
        }
        if (this.maxAge != 0) {
            File[] files;
            long now = System.currentTimeMillis();
            long duration = 86400000 * this.maxAge;
            long expiration = now - duration;
            for (File file : files = this.getCRLFiles(dir)) {
                try {
                    long creationTime = this.getCreationTime(file);
                    if (creationTime >= expiration) continue;
                    logger.debug("Expiring and deleting CRLs older than " + this.maxAge + " hours: " + file.getName());
                    if (!file.isFile()) continue;
                    file.delete();
                }
                catch (ParseException e) {
                    logger.warn("Unable to correctly parse CRL " + file + ": " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void purgeExcessFiles() {
        File dir = new File(this.mDir);
        if (!dir.isDirectory()) {
            return;
        }
        if (this.maxFullCRLs != 0) {
            Object[] fullCRLs = this.getFullCRLFiles(dir);
            if (fullCRLs.length <= this.maxFullCRLs) {
                return;
            }
            Arrays.sort(fullCRLs);
            Object lastFullCRLToKeep = fullCRLs[fullCRLs.length - this.maxFullCRLs];
            Object[] crls = this.getCRLFiles(dir);
            Arrays.sort(crls);
            for (Object crl : crls) {
                if (((File)crl).getName().equals(((File)lastFullCRLToKeep).getName())) break;
                logger.debug("Deleting file as publishing directory has more than " + this.maxFullCRLs + " files: " + (File)crl);
                if (!((File)crl).isFile()) continue;
                ((File)crl).delete();
            }
        }
    }

    public void unpublish(LDAPConnection conn, String dn, Object object) throws ELdapException {
        String fileName;
        logger.debug("FileBasedPublisher: unpublish");
        String name = this.mDir + File.separator;
        if (object instanceof X509Certificate) {
            X509Certificate cert = (X509Certificate)object;
            BigInteger sno = cert.getSerialNumber();
            name = name + "cert-" + sno.toString();
        } else if (object instanceof X509CRL) {
            X509CRL crl = (X509CRL)object;
            String[] namePrefix = this.getCrlNamePrefix(crl, this.mTimeStamp.equals("GMT"));
            name = name + namePrefix[0];
            fileName = name + ".zip";
            File f = new File(fileName);
            f.delete();
        }
        fileName = name + ".der";
        File f = new File(fileName);
        f.delete();
        fileName = name + ".b64";
        f = new File(fileName);
        f.delete();
    }

    public boolean getDerAttr() {
        return this.mDerAttr;
    }

    public boolean getB64Attr() {
        return this.mB64Attr;
    }
}

