/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.publish.publishers;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.ldap.ELdapServerDownException;
import com.netscape.certsrv.publish.Publisher;
import com.netscape.cms.publish.publishers.LdapUserCertPublisher;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldapconn.LdapBoundConnection;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.ldapconn.PKISocketFactory;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.ssl.SSLSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapCrlPublisher
extends Publisher
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(LdapCrlPublisher.class);
    protected ConfigStore mConfig;
    boolean mInited = false;
    public static final String LDAP_CACERT_ATTR = "caCertificate;binary";
    public static final String LDAP_ARL_ATTR = "authorityRevocationList;binary";
    public static final String LDAP_CRL_ATTR = "certificateRevocationList;binary";
    public static final String LDAP_CRL_OBJECTCLASS = "pkiCA,deltaCRL";
    protected String mCrlAttr = "certificateRevocationList;binary";
    protected String mCrlObjectClass = "pkiCA,deltaCRL";
    protected String mObjAdded = "";
    protected String mObjDeleted = "";
    protected int mLdapPublishTimelimit_ms = 0;

    public LdapCrlPublisher() {
    }

    public String getImplName() {
        return "LdapCrlPublisher";
    }

    public String getDescription() {
        return "LdapCrlPublisher";
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"crlAttr;string;Name of Ldap attribute in which to store the CRL", "crlObjectClass;string;The name of the objectclasses which should be added to this entry, if they do not already exist. This can be a comma-separated list such as 'certificationAuthority,certificationAuthority-V2' (if using RFC 2256) or 'pkiCA, deltaCRL' (if using RFC 4523)", "HELP_TOKEN;configuration-ldappublish-publisher-crlpublisher", "HELP_TEXT;This plugin knows how to publish CRL's to 'certificateAuthority' and 'pkiCA' -type entries"};
        return params;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> v = new Vector<String>();
        v.addElement("crlAttr=" + this.mCrlAttr);
        v.addElement("crlObjectClass=" + this.mCrlObjectClass);
        return v;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> v = new Vector<String>();
        v.addElement("crlAttr=" + this.mCrlAttr);
        v.addElement("crlObjectClass=" + this.mCrlObjectClass);
        return v;
    }

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public void init(ConfigStore config) throws EBaseException {
        if (this.mInited) {
            return;
        }
        this.mConfig = config;
        this.mCrlAttr = this.mConfig.getString("crlAttr", LDAP_CRL_ATTR);
        this.mCrlObjectClass = this.mConfig.getString("crlObjectClass", LDAP_CRL_OBJECTCLASS);
        this.mObjAdded = this.mConfig.getString("crlObjectClassAdded", "");
        this.mObjDeleted = this.mConfig.getString("crlObjectClassDeleted", "");
        Integer limit = this.mConfig.getInteger("ldapPublishTimeLimit", 0);
        this.mLdapPublishTimelimit_ms = limit;
        this.mInited = true;
    }

    public LdapCrlPublisher(String crlAttr, String crlObjectClass) {
        this.mCrlAttr = crlAttr;
        this.mCrlObjectClass = crlObjectClass;
    }

    public String getCRLObjectclass() {
        return this.mCrlObjectClass;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void publish(LDAPConnection conn, String dn, Object crlObj) throws ELdapException {
        LDAPModificationSet modSet;
        if (conn == null) {
            logger.warn("LdapCrlPublisher: No LDAP connection");
            return;
        }
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        PKISocketConfig socketConfig = cs.getSocketConfig();
        try {
            this.mCrlAttr = this.mConfig.getString("crlAttr", LDAP_CRL_ATTR);
            this.mCrlObjectClass = this.mConfig.getString("crlObjectClass", LDAP_CRL_OBJECTCLASS);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        LdapBoundConnection altConn = null;
        try {
            String host = this.mConfig.getString("host", null);
            String port = this.mConfig.getString("port", null);
            if (host != null && port != null) {
                int portVal = Integer.parseInt(port);
                int version = Integer.parseInt(this.mConfig.getString("version", "2"));
                String cert_nick = this.mConfig.getString("clientCertNickname", null);
                PKISocketFactory sslSocket = new PKISocketFactory();
                sslSocket.setAuditor(engine.getAuditor());
                sslSocket.addSocketListener((SSLSocketListener)engine.getClientSocketListener());
                sslSocket.setSecure(true);
                sslSocket.setClientCertNickname(cert_nick);
                sslSocket.init(socketConfig);
                String mgr_dn = this.mConfig.getString("bindDN", null);
                String mgr_pwd = this.mConfig.getString("bindPWD", null);
                altConn = new LdapBoundConnection(host, portVal, version, (LDAPSocketFactory)sslSocket, mgr_dn, mgr_pwd);
                conn = altConn;
            }
        }
        catch (LDAPException e) {
            logger.warn("LdapCrlPublisher: Failed to create alt connection " + e.getMessage(), (Throwable)e);
        }
        catch (EBaseException e) {
            logger.warn("LdapCrlPublisher: Failed to create alt connection " + e.getMessage(), (Throwable)e);
        }
        int orig_timelimit = 0;
        LDAPConstraints constraints = null;
        try {
            byte[] crlEnc = ((X509CRL)crlObj).getEncoded();
            logger.info("LdapCrlPublisher: Retrieving attributes from " + dn);
            LDAPSearchResults res = null;
            res = this.mCrlAttr.equals(LDAP_CRL_ATTR) ? conn.search(dn, 0, "(objectclass=*)", new String[]{LDAP_CACERT_ATTR, LDAP_ARL_ATTR}, true) : conn.search(dn, 0, "(objectclass=*)", new String[]{LDAP_CRL_ATTR, LDAP_CACERT_ATTR, LDAP_ARL_ATTR}, true);
            LDAPEntry entry = res.next();
            LDAPAttribute crls = entry.getAttribute(LDAP_CRL_ATTR);
            LDAPAttribute certs = entry.getAttribute(LDAP_CACERT_ATTR);
            LDAPAttribute arls = entry.getAttribute(LDAP_ARL_ATTR);
            logger.info("LdapCrlPublisher: Retrieving object classes from " + dn);
            LDAPSearchResults res1 = conn.search(dn, 0, "(objectclass=*)", new String[]{"objectclass"}, false);
            LDAPEntry entry1 = res1.next();
            LDAPAttribute ocs = entry1.getAttribute("objectclass");
            modSet = new LDAPModificationSet();
            String[] oclist = this.mCrlObjectClass.split(",");
            boolean attrsAdded = false;
            for (int i = 0; i < oclist.length; ++i) {
                String oc = oclist[i].trim();
                boolean hasoc = LdapUserCertPublisher.StringValueExists(ocs, oc);
                if (hasoc) continue;
                logger.info("LdapCrlPublisher: Adding objectclass " + oc);
                modSet.add(0, new LDAPAttribute("objectclass", oc));
                if (attrsAdded || !oc.equalsIgnoreCase("certificationAuthority")) continue;
                if (arls == null) {
                    logger.info("LdapCrlPublisher: Adding attribute authorityRevocationList;binary");
                    modSet.add(0, new LDAPAttribute(LDAP_ARL_ATTR, ""));
                }
                if (certs == null) {
                    logger.info("LdapCrlPublisher: Adding attribute caCertificate;binary");
                    modSet.add(0, new LDAPAttribute(LDAP_CACERT_ATTR, ""));
                }
                if (crls == null && !this.mCrlAttr.equals(LDAP_CRL_ATTR)) {
                    logger.info("LdapCrlPublisher: Adding attribute certificateRevocationList;binary");
                    modSet.add(0, new LDAPAttribute(LDAP_CRL_ATTR, ""));
                }
                attrsAdded = true;
            }
            logger.info("LdapCrlPublisher: Replacing attribute " + this.mCrlAttr);
            modSet.add(2, new LDAPAttribute(this.mCrlAttr, crlEnc));
            String[] delList = this.mObjDeleted.split(",");
            if (delList.length > 0) {
                for (int i = 0; i < delList.length; ++i) {
                    String deloc = delList[i].trim();
                    boolean hasoc = LdapUserCertPublisher.StringValueExists(ocs, deloc);
                    boolean match = false;
                    for (int j = 0; j < oclist.length; ++j) {
                        if (!oclist[j].trim().equals(deloc)) continue;
                        match = true;
                        break;
                    }
                    if (match || !hasoc) continue;
                    logger.info("LdapCrlPublisher: Deleting objectclass " + deloc);
                    modSet.add(1, new LDAPAttribute("objectclass", deloc));
                }
            }
        }
        catch (CRLException e) {
            try {
                logger.error(CMS.getLogMessage((String)"PUBLISH_PUBLISH_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_PUBLISH_CRL_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
                catch (LDAPException e2) {
                    if (e2.getLDAPResultCode() == 52) {
                        logger.error(CMS.getLogMessage((String)"PUBLISH_NO_LDAP_SERVER", (Object[])new Object[0]), (Throwable)e2);
                        throw new ELdapServerDownException(CMS.getUserMessage((String)"CMS_LDAP_SERVER_UNAVAILABLE", (String[])new String[]{conn.getHost(), "" + conn.getPort()}), (Throwable)e2);
                    }
                    logger.error(CMS.getLogMessage((String)"PUBLISH_PUBLISH_ERROR", (Object[])new Object[]{e2.toString()}), (Throwable)e2);
                    throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_PUBLISH_CRL_ERROR", (String[])new String[]{e2.toString()}), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                if (constraints != null) {
                    logger.debug("CRLDEBUG - resetting original timelimit on conn to: " + String.valueOf(orig_timelimit));
                    constraints.setTimeLimit(orig_timelimit);
                    conn.setConstraints(constraints);
                }
                if (altConn == null) throw throwable;
                try {
                    altConn.disconnect();
                    throw throwable;
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (!this.mObjAdded.equals("") || !this.mObjDeleted.equals("")) {
            this.mObjAdded = "";
            this.mObjDeleted = "";
            this.mConfig.putString("crlObjectClassAdded", "");
            this.mConfig.putString("crlObjectClassDeleted", "");
            try {
                this.mConfig.commit(false);
            }
            catch (Exception e) {
                logger.warn("LdapCrlPublisher: Unable to update mObjAdded and mObjDeleted", (Throwable)e);
            }
        }
        if ((constraints = conn.getConstraints()) != null) {
            logger.debug("CRLDEBUG - setting publishing timelimit on conn to: " + String.valueOf(this.mLdapPublishTimelimit_ms));
            orig_timelimit = constraints.getTimeLimit();
            constraints.setTimeLimit(this.mLdapPublishTimelimit_ms);
            conn.setConstraints(constraints);
        } else {
            logger.debug("CRLDEBUG - constraints not set");
        }
        logger.info("LdapCrlPublisher: Modifying " + dn);
        conn.modify(dn, modSet);
        if (constraints != null) {
            logger.debug("CRLDEBUG - resetting original timelimit on conn to: " + String.valueOf(orig_timelimit));
            constraints.setTimeLimit(orig_timelimit);
            conn.setConstraints(constraints);
        }
        if (altConn == null) return;
        try {
            altConn.disconnect();
            return;
        }
        catch (LDAPException crlEnc) {
            return;
        }
    }

    public void unpublish(LDAPConnection conn, String dn, Object crlObj) throws ELdapException {
        try {
            byte[] crlEnc = ((X509CRL)crlObj).getEncoded();
            try {
                this.mCrlAttr = this.mConfig.getString("crlAttr", LDAP_CRL_ATTR);
                this.mCrlObjectClass = this.mConfig.getString("crlObjectClass", LDAP_CRL_OBJECTCLASS);
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
            LDAPSearchResults res = conn.search(dn, 0, "(objectclass=*)", new String[]{this.mCrlAttr, "objectclass"}, false);
            LDAPEntry e = res.next();
            LDAPAttribute crls = e.getAttribute(this.mCrlAttr);
            LDAPAttribute ocs = e.getAttribute("objectclass");
            LDAPModificationSet modSet = new LDAPModificationSet();
            boolean hasOC = false;
            boolean hasCRL = LdapUserCertPublisher.ByteValueExists(crls, crlEnc);
            if (hasCRL) {
                modSet.add(1, new LDAPAttribute(this.mCrlAttr, crlEnc));
            }
            String[] oclist = this.mCrlObjectClass.split(",");
            for (int i = 0; i < oclist.length; ++i) {
                String oc = oclist[i].trim();
                if (!LdapUserCertPublisher.StringValueExists(ocs, oc)) continue;
                logger.info("unpublish: deleting CRL object class " + oc + " from " + dn);
                modSet.add(1, new LDAPAttribute("objectClass", oc));
                hasOC = true;
            }
            if (hasCRL || hasOC) {
                conn.modify(dn, modSet);
            } else {
                logger.info("unpublish: " + dn + " already has not CRL");
            }
        }
        catch (CRLException e) {
            logger.error(CMS.getLogMessage((String)"PUBLISH_UNPUBLISH_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_PUBLISH_CRL_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_NO_LDAP_SERVER", (Object[])new Object[0]), (Throwable)e);
                throw new ELdapServerDownException(CMS.getUserMessage((String)"CMS_LDAP_SERVER_UNAVAILABLE", (String[])new String[]{conn.getHost(), "" + conn.getPort()}), (Throwable)e);
            }
            logger.error(CMS.getLogMessage((String)"PUBLISH_UNPUBLISH_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_UNPUBLISH_CRL_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
        }
    }
}

