/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.publish.publishers;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.ldap.ELdapServerDownException;
import com.netscape.certsrv.publish.Publisher;
import com.netscape.cms.publish.publishers.PublisherUtils;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldapconn.LdapBoundConnection;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.ldapconn.PKISocketFactory;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.ssl.SSLSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapUserCertPublisher
extends Publisher
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(LdapUserCertPublisher.class);
    public static final String LDAP_USERCERT_ATTR = "userCertificate;binary";
    protected String mCertAttr = "userCertificate;binary";
    private ConfigStore mConfig;
    private boolean mInited = false;

    public LdapUserCertPublisher() {
    }

    public String getImplName() {
        return "LdapUserCertPublisher";
    }

    public String getDescription() {
        return "LdapUserCertPublisher";
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"certAttr;string;LDAP attribute in which to store the certificate", "HELP_TOKEN;configuration-ldappublish-publisher-usercertpublisher", "HELP_TEXT;This plugin knows how to publish user certificates"};
        return params;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> v = new Vector<String>();
        v.addElement("certAttr=" + this.mCertAttr);
        return v;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> v = new Vector<String>();
        v.addElement("certAttr=" + this.mCertAttr);
        return v;
    }

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public void init(ConfigStore config) throws EBaseException {
        if (this.mInited) {
            return;
        }
        logger.info("LdapUserCertPublisher: Initializing LdapUserCertPublisher");
        this.mConfig = config;
        this.mCertAttr = this.mConfig.getString("certAttr", LDAP_USERCERT_ATTR);
        logger.info("LdapUserCertPublisher: - cert attr: " + this.mCertAttr);
        this.mInited = true;
    }

    public LdapUserCertPublisher(String certAttr) {
        this.mCertAttr = certAttr;
    }

    public void publish(LDAPConnection conn, String dn, Object certObj) throws ELdapException {
        if (conn == null) {
            return;
        }
        if (!(certObj instanceof X509Certificate)) {
            throw new IllegalArgumentException("Illegal arg to publish");
        }
        X509Certificate cert = (X509Certificate)certObj;
        CertId certID = new CertId(cert.getSerialNumber());
        logger.info("LdapUserCertPublisher: Publishing cert " + certID.toHexString() + " to " + dn);
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        PKISocketConfig socketConfig = cs.getSocketConfig();
        LdapBoundConnection altConn = null;
        try {
            String host = this.mConfig.getString("host", null);
            String port = this.mConfig.getString("port", null);
            if (host != null && port != null) {
                int portVal = Integer.parseInt(port);
                int version = Integer.parseInt(this.mConfig.getString("version", "2"));
                String cert_nick = this.mConfig.getString("clientCertNickname", null);
                PKISocketFactory sslSocket = new PKISocketFactory();
                sslSocket.setAuditor(engine.getAuditor());
                sslSocket.addSocketListener((SSLSocketListener)engine.getClientSocketListener());
                sslSocket.setSecure(true);
                sslSocket.setClientCertNickname(cert_nick);
                sslSocket.init(socketConfig);
                String mgr_dn = this.mConfig.getString("bindDN", null);
                String mgr_pwd = this.mConfig.getString("bindPWD", null);
                altConn = new LdapBoundConnection(host, portVal, version, (LDAPSocketFactory)sslSocket, mgr_dn, mgr_pwd);
                conn = altConn;
            }
        }
        catch (LDAPException e) {
            logger.warn("LdapUserCertPublisher: Failed to create alt connection " + e.getMessage(), (Throwable)e);
        }
        catch (EBaseException e) {
            logger.warn("LdapUserCertPublisher: Failed to create alt connection " + e.getMessage(), (Throwable)e);
        }
        boolean deleteCert = false;
        try {
            deleteCert = this.mConfig.getBoolean("deleteCert", false);
        }
        catch (Exception port) {
            // empty catch block
        }
        logger.info("LdapUserCertPublisher: - delete cert: " + deleteCert);
        try {
            byte[] certEnc = cert.getEncoded();
            LDAPSearchResults res = conn.search(dn, 0, "(objectclass=*)", new String[]{this.mCertAttr}, false);
            LDAPEntry entry = res.next();
            if (LdapUserCertPublisher.ByteValueExists(entry.getAttribute(this.mCertAttr), certEnc)) {
                logger.info("LdapUserCertPublisher: " + dn + " already has cert " + certID.toHexString());
                return;
            }
            LDAPModification mod = null;
            if (deleteCert) {
                logger.info("LdapUserCertPublisher: Replacing certs in " + dn);
                mod = new LDAPModification(2, new LDAPAttribute(this.mCertAttr, certEnc));
            } else {
                logger.info("LdapUserCertPublisher: Adding cert into " + dn);
                mod = new LDAPModification(0, new LDAPAttribute(this.mCertAttr, certEnc));
            }
            conn.modify(dn, mod);
            logger.info("{} successfully published serial number: 0x{} with DN: {}", new Object[]{"LdapUserCertPublisher", cert.getSerialNumber().toString(16), cert.getSubjectDN()});
        }
        catch (CertificateEncodingException e) {
            logger.error("LdapUserCertPublisher: error in publish: " + e.getMessage(), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_GET_DER_ENCODED_CERT_FAILED", (String[])new String[]{e.toString()}));
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_NO_LDAP_SERVER", (Object[])new Object[0]), (Throwable)e);
                throw new ELdapServerDownException(CMS.getUserMessage((String)"CMS_LDAP_SERVER_UNAVAILABLE", (String[])new String[]{conn.getHost(), "" + conn.getPort()}), (Throwable)e);
            }
            logger.error(CMS.getLogMessage((String)"PUBLISH_PUBLISH_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_PUBLISH_USERCERT_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        finally {
            if (altConn != null) {
                try {
                    altConn.disconnect();
                }
                catch (LDAPException lDAPException) {}
            }
        }
    }

    public void unpublish(LDAPConnection conn, String dn, Object certObj) throws ELdapException {
        boolean disableUnpublish = false;
        try {
            disableUnpublish = this.mConfig.getBoolean("disableUnpublish", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (disableUnpublish) {
            logger.debug("UserCertPublisher: disable unpublish");
            return;
        }
        if (!(certObj instanceof X509Certificate)) {
            throw new IllegalArgumentException("Illegal arg to publish");
        }
        X509Certificate cert = (X509Certificate)certObj;
        try {
            byte[] certEnc = cert.getEncoded();
            LDAPSearchResults res = conn.search(dn, 0, "(objectclass=*)", new String[]{this.mCertAttr}, false);
            LDAPEntry entry = res.next();
            if (!LdapUserCertPublisher.ByteValueExists(entry.getAttribute(this.mCertAttr), certEnc)) {
                logger.info("LdapUserCertPublisher: " + dn + " already has not cert");
                return;
            }
            LDAPModification mod = new LDAPModification(1, new LDAPAttribute(this.mCertAttr, certEnc));
            conn.modify(dn, mod);
        }
        catch (CertificateEncodingException e) {
            logger.error(CMS.getLogMessage((String)"PUBLISH_UNPUBLISH_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_GET_DER_ENCODED_CERT_FAILED", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_NO_LDAP_SERVER", (Object[])new Object[0]), (Throwable)e);
                throw new ELdapServerDownException(CMS.getUserMessage((String)"CMS_LDAP_SERVER_UNAVAILABLE", (String[])new String[]{conn.getHost(), "" + conn.getPort()}), (Throwable)e);
            }
            logger.error(CMS.getLogMessage((String)"PUBLISH_UNPUBLISH_ERROR", (Object[])new Object[0]), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_UNPUBLISH_USERCERT_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
        }
    }

    public static boolean ByteValueExists(LDAPAttribute attr, byte[] bval) {
        if (attr == null) {
            return false;
        }
        Enumeration vals = attr.getByteValues();
        byte[] val = null;
        while (vals.hasMoreElements()) {
            val = (byte[])vals.nextElement();
            if (val.length == 0 || !PublisherUtils.byteArraysAreEqual(val, bval)) continue;
            return true;
        }
        return false;
    }

    public static boolean StringValueExists(LDAPAttribute attr, String sval) {
        if (attr == null) {
            return false;
        }
        Enumeration vals = attr.getStringValues();
        String val = null;
        while (vals.hasMoreElements()) {
            val = (String)vals.nextElement();
            if (!val.equalsIgnoreCase(sval)) continue;
            return true;
        }
        return false;
    }
}

