/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.admin;

import com.netscape.ca.CASigningUnit;
import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.ConfigTrustedPublicKeyEvent;
import com.netscape.certsrv.security.KeyCertData;
import com.netscape.cms.servlet.admin.CMSAdminServlet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.cert.CrossCertPairSubsystem;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.security.JssSubsystem;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.crypto.PQGParams;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.BasicConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;

@WebServlet(name="caserver", urlPatterns={"/server"}, initParams={@WebInitParam(name="ID", value="caserver"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz")})
public class CACMSAdminServlet
extends CMSAdminServlet {
    public boolean isSubsystemInstalled(String subsystem) {
        return subsystem.equals("ca");
    }

    public void readEncryption(NameValuePairs params) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        CertificateAuthority ca = engine.getCA();
        CASigningUnit signingUnit = ca.getSigningUnit();
        String caTokenName = signingUnit.getTokenName();
        if (caTokenName.equals(jssSubsystem.getInternalTokenName())) {
            caTokenName = "internal";
        }
        String caNickName = signingUnit.getNickname();
        params.put((Object)"CA", (Object)this.getCertNickname(caNickName));
    }

    void readSubsystem(NameValuePairs params) {
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        params.put((Object)ca.getId(), (Object)"ca");
    }

    String getCANickname() {
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        CASigningUnit signingUnit = ca.getSigningUnit();
        return signingUnit.getNickname();
    }

    String getCANewnickname() throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        CASigningUnit signingUnit = ca.getSigningUnit();
        return signingUnit.getNewNickName();
    }

    void setCANewnickname(String tokenName, String nickname) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        CASigningUnit signingUnit = ca.getSigningUnit();
        if (CryptoUtil.isInternalToken((String)tokenName)) {
            signingUnit.setNewNickName(nickname);
        } else if (tokenName.equals("") && nickname.equals("")) {
            signingUnit.setNewNickName("");
        } else {
            signingUnit.setNewNickName(tokenName + ":" + nickname);
        }
    }

    String getOCSPNickname() {
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        CASigningUnit signingUnit = ca.getOCSPSigningUnit();
        return signingUnit.getNickname();
    }

    String getOCSPNewnickname() throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        CASigningUnit signingUnit = ca.getOCSPSigningUnit();
        return signingUnit.getNewNickName();
    }

    void setOCSPNewnickname(String tokenName, String nickname) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        CASigningUnit signingUnit = ca.getOCSPSigningUnit();
        if (CryptoUtil.isInternalToken((String)tokenName)) {
            signingUnit.setNewNickName(nickname);
        } else if (tokenName.equals("") && nickname.equals("")) {
            signingUnit.setNewNickName("");
        } else {
            signingUnit.setNewNickName(tokenName + ":" + nickname);
        }
    }

    public void modifyCACert(HttpServletRequest request, String value) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        CertificateAuthority ca = engine.getCA();
        CASigningUnit signingUnit = ca.getSigningUnit();
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        if (tokenizer.countTokens() != 2) {
            String auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_ENCRYPTION_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(request)});
            auditor.log(auditMessage);
            throw new EBaseException(CMS.getLogMessage((String)"BASE_INVALID_UI_INFO", (Object[])new Object[0]));
        }
        String tokenName = (String)tokenizer.nextElement();
        Object nickName = (String)tokenizer.nextElement();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        if (CryptoUtil.isInternalToken((String)tokenName)) {
            tokenName = jssSubsystem.getInternalTokenName();
        } else {
            nickName = tokenName + ":" + (String)nickName;
        }
        boolean isCACert = jssSubsystem.isCACert((String)nickName);
        if (!isCACert) {
            String auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_ENCRYPTION_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(request)});
            auditor.log(auditMessage);
            throw new EBaseException(CMS.getLogMessage((String)"BASE_NOT_CA_CERT", (Object[])new Object[0]));
        }
        signingUnit.updateConfig((String)nickName, tokenName);
    }

    public void modifyServerCert(String nickname) throws EBaseException {
        this.modifyCAGatewayCert(nickname);
    }

    public void modifyCAGatewayCert(String nickname) {
        CAEngine engine = CAEngine.getInstance();
        engine.setServerCertNickname(nickname);
    }

    public void updateCASignature(String nickname, KeyCertData properties, JssSubsystem jssSubsystem) throws EBaseException {
        String alg = jssSubsystem.getSignatureAlgorithm(nickname);
        SignatureAlgorithm sigAlg = Cert.mapAlgorithmToJss((String)alg);
        properties.setSignatureAlgorithm(sigAlg);
        properties.setAlgorithmId(jssSubsystem.getAlgorithmId(alg, (ConfigStore)this.mConfig));
    }

    public void issueImportCert(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, EBaseException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        try {
            CASigningUnit ocspSigningUnit;
            String tokenName = "internal";
            String keyType = "RSA";
            String newtokenname = null;
            KeyCertData properties = new KeyCertData();
            Enumeration paramNames = request.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String name = (String)paramNames.nextElement();
                String value = request.getParameter(name);
                if (name.equals("pathname")) continue;
                if (name.equals("tokenName")) {
                    newtokenname = value;
                }
                properties.put((Object)name, (Object)value);
            }
            String certType = (String)properties.get((Object)"RS_ID");
            JssSubsystem jssSubsystem = engine.getJSSSubsystem();
            CertificateAuthority ca = engine.getCA();
            CASigningUnit signingUnit = ca.getSigningUnit();
            Object nickname = this.getNickname(certType);
            Object nicknameWithoutTokenName = "";
            String oldcatokenname = signingUnit.getTokenName();
            String canickname = this.getNickname("caSigningCert");
            String canicknameWithoutTokenName = "";
            int index = ((String)nickname).indexOf(":");
            String oldtokenname = null;
            if (index == -1) {
                nicknameWithoutTokenName = nickname;
                oldtokenname = "internal";
            } else if (index > 0 && index < ((String)nickname).length() - 1) {
                nicknameWithoutTokenName = ((String)nickname).substring(index + 1);
                oldtokenname = ((String)nickname).substring(0, index);
            } else {
                auditor.log((LogEvent)new ConfigTrustedPublicKeyEvent(auditSubjectID, "Failure", this.auditParams(request)));
                throw new EBaseException(CMS.getLogMessage((String)"BASE_CERT_NOT_FOUND", (Object[])new Object[0]));
            }
            if (newtokenname == null) {
                newtokenname = oldtokenname;
            }
            if ((index = canickname.indexOf(":")) == -1) {
                canicknameWithoutTokenName = canickname;
            } else if (index > 0 && index < canickname.length() - 1) {
                canicknameWithoutTokenName = canickname.substring(index + 1);
            } else {
                auditor.log((LogEvent)new ConfigTrustedPublicKeyEvent(auditSubjectID, "Failure", this.auditParams(request)));
                throw new EBaseException(CMS.getLogMessage((String)"BASE_CERT_NOT_FOUND", (Object[])new Object[0]));
            }
            properties.setIssuerName(jssSubsystem.getCertSubjectName(oldcatokenname, canicknameWithoutTokenName));
            if (((String)nickname).equals("")) {
                auditor.log((LogEvent)new ConfigTrustedPublicKeyEvent(auditSubjectID, "Failure", this.auditParams(request)));
                throw new EBaseException(CMS.getLogMessage((String)"BASE_CERT_NOT_FOUND", (Object[])new Object[0]));
            }
            properties.setCertNickname((String)nickname);
            if (!certType.equals("caSigningCert")) {
                CertificateExtensions exts = jssSubsystem.getExtensions(oldcatokenname, canicknameWithoutTokenName);
                properties.setCAExtensions(exts);
            }
            String defaultSigningAlg = null;
            String defaultOCSPSigningAlg = null;
            if (properties.getHashType() != null) {
                if (certType.equals("caSigningCert")) {
                    defaultSigningAlg = properties.getHashType();
                }
                if (certType.equals("ocspSigningCert")) {
                    defaultOCSPSigningAlg = properties.getHashType();
                }
            }
            KeyPair pair = null;
            KeyPair caKeyPair = null;
            if (properties.getKeyCurveName() != null) {
                logger.info("CACMSAdminServlet: Generating ECC keys");
                pair = jssSubsystem.getECCKeyPair(properties);
                if (certType.equals("caSigningCert")) {
                    caKeyPair = pair;
                }
            } else if (properties.getKeyLength() != null) {
                keyType = properties.getKeyType();
                String keyLen = properties.getKeyLength();
                if (keyType.equals("DSA")) {
                    PQGParams pQGParams = jssSubsystem.getCAPQG(Integer.parseInt(keyLen), (ConfigStore)this.mConfig);
                }
                pair = jssSubsystem.getKeyPair(properties);
                if (certType.equals("caSigningCert")) {
                    caKeyPair = pair;
                }
            } else {
                pair = jssSubsystem.getKeyPair((String)nickname);
                if (certType.equals("caSigningCert")) {
                    this.updateCASignature((String)nickname, properties, jssSubsystem);
                    caKeyPair = pair;
                    defaultSigningAlg = signingUnit.getDefaultAlgorithm();
                }
            }
            String alg = properties.getSignedBy();
            if (!certType.equals("caSigningCert")) {
                caKeyPair = jssSubsystem.getKeyPair(canickname);
                this.updateCASignature(canickname, properties, jssSubsystem);
            } else if (alg != null) {
                SignatureAlgorithm sigAlg = Cert.mapAlgorithmToJss((String)alg);
                properties.setSignatureAlgorithm(sigAlg);
                properties.setAlgorithmId(jssSubsystem.getAlgorithmId(alg, (ConfigStore)this.mConfig));
            }
            if (pair == null) {
                logger.warn("CACMSAdminServlet: Missing key pair");
            }
            CertificateRepository repository = engine.getCertificateRepository();
            BigInteger nextSerialNo = repository.getNextSerialNumber();
            properties.setSerialNumber(nextSerialNo);
            properties.setKeyPair(pair);
            properties.setConfigFile((ConfigStore)this.mConfig);
            properties.put((Object)"caKeyPair", (Object)caKeyPair);
            X509CertImpl signedCert = jssSubsystem.getSignedCert(properties, certType, caKeyPair.getPrivate());
            if (signedCert == null) {
                logger.warn("CACMSAdminServlet: Missing signed certificate");
            }
            boolean nicknameChanged = false;
            try {
                logger.info("CACMSAdminServlet: Importing cert: " + (String)nicknameWithoutTokenName);
                jssSubsystem.importCert(signedCert, (String)nicknameWithoutTokenName, certType);
            }
            catch (EBaseException e) {
                logger.warn("CACMSAdminServlet: Unable to import " + (String)nicknameWithoutTokenName + ": " + e.getMessage());
                Date now = new Date();
                String newNickname = (String)nicknameWithoutTokenName + "-" + now.getTime();
                logger.info("CACMSAdminServlet: Importing cert with nickname: " + newNickname);
                jssSubsystem.importCert(signedCert, newNickname, certType);
                nicknameWithoutTokenName = newNickname;
                nicknameChanged = true;
                nickname = tokenName.equals("internal") ? newNickname : tokenName + ":" + newNickname;
            }
            CertRecord certRecord = new CertRecord(signedCert.getSerialNumber(), (Certificate)signedCert, null);
            repository.addCertificateRecord(certRecord);
            if (certType.equals("caSigningCert")) {
                try {
                    X509CertInfo certInfo = (X509CertInfo)signedCert.get("x509.info");
                    CertificateExtensions extensions = (CertificateExtensions)certInfo.get("extensions");
                    if (extensions != null) {
                        BasicConstraintsExtension basic = (BasicConstraintsExtension)extensions.get("BasicConstraints");
                        if (basic == null) {
                            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_BASIC_CONSTRAIN_NULL", (Object[])new Object[0]));
                        } else {
                            Integer pathlen = (Integer)basic.get("path_len");
                            int num = pathlen;
                            if (num == 0) {
                                ca.setBasicConstraintMaxLen(num);
                            } else if (num > 0) {
                                ca.setBasicConstraintMaxLen(--num);
                            }
                        }
                    } else {
                        logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_CERT_NO_EXT", (Object[])new Object[0]));
                    }
                }
                catch (Exception e) {
                    logger.warn("CACMSAdminServlet: " + e.getMessage(), (Throwable)e);
                }
            }
            logger.debug("CACMSAdminServlet: old token:" + oldtokenname);
            logger.debug("CACMSAdminServlet: new token:" + newtokenname);
            logger.debug("CACMSAdminServlet: nickname:" + (String)nickname);
            if (newtokenname != null && !newtokenname.equals(oldtokenname) || nicknameChanged) {
                if (certType.equals("caSigningCert")) {
                    if (newtokenname.equals("internal")) {
                        signingUnit.updateConfig((String)nicknameWithoutTokenName, newtokenname);
                    } else {
                        signingUnit.updateConfig(newtokenname + ":" + (String)nicknameWithoutTokenName, newtokenname);
                    }
                } else if (certType.equals("serverCert")) {
                    nickname = newtokenname.equals("internal") ? nicknameWithoutTokenName : newtokenname + ":" + (String)nicknameWithoutTokenName;
                    this.modifyAgentGatewayCert((String)nickname);
                    this.modifyCAGatewayCert((String)nickname);
                } else if (certType.equals("serverCertRadm")) {
                    nickname = newtokenname.equals("internal") ? nicknameWithoutTokenName : newtokenname + ":" + (String)nicknameWithoutTokenName;
                    this.modifyRADMCert((String)nickname);
                } else if (certType.equals("ocspSigningCert") && ca != null) {
                    ocspSigningUnit = ca.getOCSPSigningUnit();
                    if (newtokenname.equals("internal")) {
                        ocspSigningUnit.updateConfig((String)nicknameWithoutTokenName, newtokenname);
                    } else {
                        ocspSigningUnit.updateConfig(newtokenname + ":" + (String)nicknameWithoutTokenName, newtokenname);
                    }
                }
            }
            if (certType.equals("caSigningCert")) {
                signingUnit.setDefaultAlgorithm(defaultSigningAlg);
            }
            if (defaultOCSPSigningAlg != null) {
                ocspSigningUnit = ca.getOCSPSigningUnit();
                ocspSigningUnit.setDefaultAlgorithm(defaultOCSPSigningAlg);
            }
            properties.clear();
            properties = null;
            auditor.log((LogEvent)new ConfigTrustedPublicKeyEvent(auditSubjectID, "Success", this.auditParams(request)));
            this.mConfig.commit(true);
            this.sendResponse(SUCCESS, null, null, response);
        }
        catch (EBaseException e) {
            logger.error("CACMSAdminServlet: " + e.getMessage());
            auditor.log((LogEvent)new ConfigTrustedPublicKeyEvent(auditSubjectID, "Failure", this.auditParams(request)));
            throw e;
        }
        catch (IOException e) {
            logger.error("CACMSAdminServlet: " + e.getMessage());
            auditor.log((LogEvent)new ConfigTrustedPublicKeyEvent(auditSubjectID, "Failure", this.auditParams(request)));
            throw e;
        }
    }

    public void installCASigningCert(String fullName, String nickname, String tokenName) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        CASigningUnit signingUnit = ca.getSigningUnit();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        String signatureAlg = jssSubsystem.getSignatureAlgorithm(fullName);
        signingUnit.setDefaultAlgorithm(signatureAlg);
        this.setCANewnickname("", "");
        try {
            CertificateExtensions extensions = null;
            if (fullName.equals(nickname)) {
                signingUnit.updateConfig(fullName, "internal");
                extensions = jssSubsystem.getExtensions("internal", fullName);
            } else {
                signingUnit.updateConfig(fullName, tokenName);
                extensions = jssSubsystem.getExtensions(tokenName, nickname);
            }
            if (extensions != null) {
                BasicConstraintsExtension basic = (BasicConstraintsExtension)extensions.get("BasicConstraints");
                if (basic == null) {
                    logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_BASIC_CONSTRAIN_NULL", (Object[])new Object[0]));
                } else {
                    Integer pathlen = (Integer)basic.get("path_len");
                    int num = pathlen;
                    if (num == 0) {
                        ca.setBasicConstraintMaxLen(num);
                    } else if (num > 0) {
                        ca.setBasicConstraintMaxLen(--num);
                    }
                }
            } else {
                logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_CERT_NO_EXT", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.warn("CACMSAdminServlet: " + e.toString());
        }
    }

    public void installOCSPSigningCert(String fullName, String nickname, String tokenName) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        this.setOCSPNewnickname("", "");
        CASigningUnit signingUnit = ca.getOCSPSigningUnit();
        if (fullName.equals(nickname)) {
            signingUnit.updateConfig(fullName, "internal");
        } else {
            signingUnit.updateConfig(fullName, tokenName);
        }
    }

    protected void importXCert(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        try {
            String b64Cert = "";
            Object pathname = "";
            String serverRoot = "";
            String serverID = "";
            String certpath = "";
            Enumeration names = req.getParameterNames();
            NameValuePairs results = new NameValuePairs();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                String value = req.getParameter(key);
                if (key.equals("pkcs10")) {
                    b64Cert = value;
                    continue;
                }
                if (key.equals("pathname")) {
                    pathname = value;
                    continue;
                }
                if (key.equals("serverRoot")) {
                    serverRoot = value;
                    continue;
                }
                if (key.equals("serverID")) {
                    serverID = value;
                    continue;
                }
                if (!key.equals("certFilePath")) continue;
                certpath = value;
            }
            try {
                if (b64Cert == null || b64Cert.equals("")) {
                    if (certpath == null || certpath.equals("")) {
                        auditor.log((LogEvent)new ConfigTrustedPublicKeyEvent(auditSubjectID, "Failure", this.auditParams(req)));
                        EBaseException ex = new EBaseException(CMS.getLogMessage((String)"BASE_INVALID_FILE_PATH", (Object[])new Object[0]));
                        throw ex;
                    }
                    FileInputStream in = new FileInputStream(certpath);
                    BufferedReader d = new BufferedReader(new InputStreamReader(in));
                    String content = "";
                    b64Cert = "";
                    StringBuffer sb = new StringBuffer();
                    while ((content = d.readLine()) != null) {
                        sb.append(content);
                        sb.append("\n");
                    }
                    b64Cert = sb.toString();
                    d.close();
                    b64Cert = b64Cert.substring(0, b64Cert.length() - 1);
                }
            }
            catch (IOException e) {
                auditor.log((LogEvent)new ConfigTrustedPublicKeyEvent(auditSubjectID, "Failure", this.auditParams(req)));
                throw new EBaseException(CMS.getLogMessage((String)"BASE_OPEN_FILE_FAILED", (Object[])new Object[0]));
            }
            logger.debug("CACMSAdminServlet: got b64Cert");
            b64Cert = Cert.stripBrackets((String)b64Cert.trim());
            byte[] bCert = null;
            try {
                bCert = Utils.base64decode((String)b64Cert);
            }
            catch (Exception e) {
                logger.warn("CACMSAdminServlet: exception: " + e);
            }
            pathname = serverRoot + File.separator + serverID + File.separator + "config" + File.separator + (String)pathname;
            CrossCertPairSubsystem ccps = (CrossCertPairSubsystem)engine.getSubsystem("CrossCertPair");
            try {
                ccps.importCert(bCert);
            }
            catch (Exception e) {
                auditor.log((LogEvent)new ConfigTrustedPublicKeyEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(1, "xcert importing failure:" + e, null, resp);
                return;
            }
            try {
                ccps.publishCertPairs();
            }
            catch (EBaseException e) {
                auditor.log((LogEvent)new ConfigTrustedPublicKeyEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(1, "xcerts publishing failure:" + e, null, resp);
                return;
            }
            JssSubsystem jssSubsystem = engine.getJSSSubsystem();
            String content = jssSubsystem.getCertPrettyPrint(b64Cert, super.getLocale(req));
            results.put((Object)"nickname", (Object)"FBCA cross-signed cert");
            results.put((Object)"certContent", (Object)content);
            auditor.log((LogEvent)new ConfigTrustedPublicKeyEvent(auditSubjectID, "Success", this.auditParams(req)));
            this.sendResponse(SUCCESS, null, results, resp);
        }
        catch (EBaseException e) {
            auditor.log((LogEvent)new ConfigTrustedPublicKeyEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw e;
        }
        catch (IOException e) {
            auditor.log((LogEvent)new ConfigTrustedPublicKeyEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw e;
        }
    }
}

