/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldap;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.request.RequestListener;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldap.LdapMappers;
import com.netscape.cmscore.ldap.LdapPublishModule;
import com.netscape.cmscore.request.Request;
import java.security.cert.X509Certificate;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HandleEnrollment
extends RequestListener {
    public static Logger logger = LoggerFactory.getLogger(HandleEnrollment.class);
    LdapPublishModule mModule = null;

    public HandleEnrollment(LdapPublishModule module) {
        this.mModule = module;
    }

    public void set(String name, String val) {
    }

    public void init(Subsystem sub, ConfigStore config) throws EBaseException {
    }

    public void accept(Request r) {
        logger.debug("handling publishing for enrollment request id " + r.getRequestId());
        if (r.getExtDataInInteger("Result") == null) {
            return;
        }
        if (r.getExtDataInInteger("Result").equals(Request.RES_ERROR)) {
            logger.debug("Request errored. Nothing to publish for enrollment request id " + r.getRequestId());
            return;
        }
        logger.debug("Checking publishing for request " + r.getRequestId());
        X509CertImpl[] certs = r.getExtDataInCertArray("issuedCerts");
        if (certs == null || certs.length == 0 || certs[0] == null) {
            logger.debug("No certs to publish for request id " + r.getRequestId());
            return;
        }
        LdapMappers mappers = this.mModule.getMappers("client");
        if (mappers == null || mappers.publisher == null) {
            logger.debug("In publishing: No publisher for type client");
            return;
        }
        Integer[] results = new Integer[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            try {
                if (certs[i] == null) continue;
                this.mModule.publish(mappers.mapper, mappers.publisher, (X509Certificate)certs[i]);
                results[i] = Request.RES_SUCCESS;
                logger.debug("Published cert serial no 0x" + certs[i].getSerialNumber().toString(16));
                this.mModule.setPublishedFlag(certs[i].getSerialNumber(), true);
            }
            catch (ELdapException e) {
                logger.warn(CMS.getLogMessage((String)"CMSCORE_LDAP_CERT_NOT_PUBLISH", (Object[])new Object[]{certs[i].getSerialNumber().toString(16), e.toString()}), (Throwable)e);
                results[i] = Request.RES_ERROR;
            }
            r.setExtData("ldapPublishStatus", results);
        }
    }
}

