/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Vector;
import org.dogtagpki.legacy.core.policy.GeneralNameUtil;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.extensions.CertificateScopeEntry;
import org.mozilla.jss.netscape.security.extensions.CertificateScopeOfUseExtension;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;

public class CertificateScopeOfUseExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    protected static final String PROP_CRITICAL = "critical";
    protected static final String PROP_ENTRY = "entry";
    protected static final String PROP_NAME = "name";
    protected static final String PROP_NAME_TYPE = "name_type";
    protected static final String PROP_PORT_NUMBER = "port_number";
    public static final int MAX_ENTRY = 5;
    public ConfigStore mConfig;

    public CertificateScopeOfUseExt() {
        this.NAME = "CertificateScopeOfUseExt";
        this.DESC = "Sets scope of use extension for certificates";
    }

    public String[] getExtendedPluginInfo() {
        Vector<Object> v = new Vector<Object>();
        v.addElement("critical;boolean; This extension may be either critical or non-critical.");
        v.addElement("HELP_TOKEN;configuration-policyrules-certificatescopeofuse");
        v.addElement("HELP_TEXT;Adds Certificate Scope of Use Extension.");
        for (int i = 0; i < 5; ++i) {
            v.addElement(PROP_ENTRY + Integer.toString(i) + "_name;string;Value according to the GeneralName choice.");
            v.addElement(PROP_ENTRY + Integer.toString(i) + "_name_type;choice(rfc822Name,directoryName,dNSName,ediPartyName,URL,iPAddress,OID,otherName);GeneralName choice. See RFC 2459 appendix B2 on GeneralName.");
            v.addElement(PROP_ENTRY + Integer.toString(i) + "_port_number;string;The port number (optional).");
        }
        return Utils.getStringArrayFromVector(v);
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        this.mConfig = config;
    }

    private Vector<CertificateScopeEntry> getScopeEntries() throws EBaseException {
        Vector<CertificateScopeEntry> entries = new Vector<CertificateScopeEntry>();
        int i = 0;
        while (true) {
            String port = this.mConfig.getString(PROP_ENTRY + Integer.toString(i) + "_port_number", null);
            BigInt portNumber = null;
            if (port != null && !port.equals("")) {
                portNumber = new BigInt(Integer.parseInt(port));
            }
            String name_type = this.mConfig.getString(PROP_ENTRY + Integer.toString(i) + "_name_type", null);
            String name = this.mConfig.getString(PROP_ENTRY + Integer.toString(i) + "_name", null);
            if (name == null || name.equals("")) break;
            GeneralName gn = GeneralNameUtil.form_GeneralNameAsConstraints((String)name_type, (String)name);
            entries.addElement(new CertificateScopeEntry(gn, portNumber));
            ++i;
        }
        return entries;
    }

    public PolicyResult apply(Request req) {
        PolicyResult res = PolicyResult.ACCEPTED;
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        for (int j = 0; j < ci.length; ++j) {
            X509CertInfo certInfo = ci[j];
            if (certInfo == null) {
                logger.warn(CMS.getLogMessage((String)"CA_CERT_INFO_ERROR", (Object[])new Object[]{this.NAME}));
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, "Configuration Info Error");
                return PolicyResult.REJECTED;
            }
            try {
                CertificateExtensions extensions = (CertificateExtensions)certInfo.get("extensions");
                Vector<CertificateScopeEntry> entries = this.getScopeEntries();
                if (entries.size() == 0) {
                    return res;
                }
                if (extensions == null) {
                    certInfo.set("version", (Object)new CertificateVersion(2));
                    extensions = new CertificateExtensions();
                    certInfo.set("extensions", (Object)extensions);
                } else {
                    try {
                        extensions.delete("CertificateScopeOfUse");
                        logger.info("Previous extension deleted: CertificateScopeOfUse");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                CertificateScopeOfUseExtension suExt = new CertificateScopeOfUseExtension(this.mConfig.getBoolean(PROP_CRITICAL, false), entries);
                extensions.set("CertificateScopeOfUse", (Object)suExt);
                continue;
            }
            catch (IOException e) {
                logger.warn(CMS.getLogMessage((String)"BASE_IO_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, e.getMessage());
                return PolicyResult.REJECTED;
            }
            catch (EBaseException e) {
                logger.warn("Configuration Info Error encountered: " + e.getMessage(), (Throwable)e);
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, "Configuration Info Error");
                return PolicyResult.REJECTED;
            }
            catch (CertificateException e) {
                logger.warn(CMS.getLogMessage((String)"CA_CERT_INFO_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, "Certificate Info Error");
                return PolicyResult.REJECTED;
            }
        }
        return res;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> params = new Vector<String>();
        try {
            params.addElement("critical=" + this.mConfig.getBoolean(PROP_CRITICAL, false));
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        int i = 0;
        while (true) {
            String name_type = null;
            try {
                name_type = this.mConfig.getString(PROP_ENTRY + Integer.toString(i) + "_name_type", null);
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
            if (name_type == null) break;
            params.addElement(PROP_ENTRY + Integer.toString(i) + "_name_type=" + name_type);
            String name = null;
            try {
                name = this.mConfig.getString(PROP_ENTRY + Integer.toString(i) + "_name", null);
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
            if (name == null) break;
            params.addElement(PROP_ENTRY + Integer.toString(i) + "_name=" + name);
            String port = null;
            try {
                port = this.mConfig.getString(PROP_ENTRY + Integer.toString(i) + "_port_number", "");
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
            params.addElement(PROP_ENTRY + Integer.toString(i) + "_port_number=" + port);
            ++i;
        }
        return params;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> defParams = new Vector<String>();
        defParams.addElement("critical=false");
        for (int i = 0; i < 5; ++i) {
            defParams.addElement(PROP_ENTRY + Integer.toString(i) + "_name_type=");
            defParams.addElement(PROP_ENTRY + Integer.toString(i) + "_name=");
            defParams.addElement(PROP_ENTRY + Integer.toString(i) + "_port_number=");
        }
        return defParams;
    }
}

