/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.processors;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.KeyGenInfo;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.processors.PKIProcessor;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import java.io.IOException;
import java.security.cert.CertificateException;
import org.dogtagpki.server.authentication.AuthToken;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyGenProcessor
extends PKIProcessor {
    public static Logger logger = LoggerFactory.getLogger(KeyGenProcessor.class);

    public KeyGenProcessor() {
    }

    public KeyGenProcessor(CMSRequest cmsReq, CMSServlet servlet) {
        super(cmsReq, servlet);
    }

    @Override
    public void process(CMSRequest cmsReq) throws EBaseException {
    }

    @Override
    public void fillCertInfo(String protocolString, X509CertInfo certInfo, AuthToken authToken, ArgBlock httpParams) throws EBaseException {
        logger.debug("KeyGenProcessor: fillCertInfo");
        if (this.mServlet == null) {
            return;
        }
        KeyGenInfo keyGenInfo = httpParams.getValueAsKeyGenInfo("subjectKeyGenInfo", null);
        X509Key key = null;
        key = keyGenInfo.getSPKI();
        if (key == null) {
            logger.error(CMS.getLogMessage("CMSGW_MISSING_KEY_IN_KEYGENINFO", new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_MISSING_KEY_IN_KEYGENINFO", new String[0]));
        }
        try {
            certInfo.set("key", (Object)new CertificateX509Key(key));
        }
        catch (CertificateException e) {
            logger.error("KeyGenProcessor: Could not set key into certInfo from keygen: " + e.getMessage(), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_SET_KEY_FROM_KEYGEN_FAILED", e.toString()), e);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSGW_FAILED_SET_KEY_FROM_KEYGEN_1", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_SET_KEY_FROM_KEYGEN_FAILED", e.toString()), e);
        }
        String authMgr = this.mServlet.getAuthMgr();
        if (authToken == null) {
            KeyGenProcessor.fillCertInfoFromForm(certInfo, httpParams);
        } else if (authToken.getInString("tokenCertSubject") == null) {
            if (!authMgr.equals("certUserDBAuthMgr") && !authMgr.equals("passwdUserDBAuthMgr")) {
                logger.error(CMS.getLogMessage("CMSGW_MISSING_SUBJECT_NAME_FROM_AUTHTOKEN", new Object[0]));
                throw new ECMSGWException(CMS.getUserMessage("CMS_GW_MISSING_SUBJECT_NAME_FROM_AUTHTOKEN", new String[0]));
            }
            KeyGenProcessor.fillCertInfoFromForm(certInfo, httpParams);
        } else {
            KeyGenProcessor.fillCertInfoFromAuthToken(certInfo, authToken);
        }
    }
}

