/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.processors;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.processors.PKIProcessor;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import org.dogtagpki.server.authentication.AuthToken;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.pkcs.PKCS10Attribute;
import org.mozilla.jss.netscape.security.pkcs.PKCS10Attributes;
import org.mozilla.jss.netscape.security.pkcs.PKCS9Attribute;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.Extensions;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS10Processor
extends PKIProcessor {
    public static Logger logger = LoggerFactory.getLogger(PKCS10Processor.class);
    private PKCS10 mPkcs10 = null;
    private final String USE_INTERNAL_PKCS10 = "internal";

    public PKCS10Processor() {
    }

    public PKCS10Processor(CMSRequest cmsReq, CMSServlet servlet) {
        super(cmsReq, servlet);
    }

    @Override
    public void process(CMSRequest cmsReq) throws EBaseException {
    }

    public void fillCertInfo(PKCS10 pkcs10, X509CertInfo certInfo, AuthToken authToken, ArgBlock httpParams) throws EBaseException {
        this.mPkcs10 = pkcs10;
        this.fillCertInfo("internal", certInfo, authToken, httpParams);
    }

    @Override
    public void fillCertInfo(String protocolString, X509CertInfo certInfo, AuthToken authToken, ArgBlock httpParams) throws EBaseException {
        PKCS10 p10 = null;
        logger.debug("PKCS10Processor:fillCertInfo");
        if (protocolString == null) {
            p10 = this.getPKCS10(httpParams);
        } else if (protocolString.equals("internal")) {
            p10 = this.mPkcs10;
        } else {
            logger.error("PKCS10Processor::fillCertInfo() - p10 is null!");
            throw new EBaseException("p10 is null");
        }
        if (this.mServlet == null) {
            ECMSGWException ex = new ECMSGWException("Servlet property of PKCS10Processor is null.");
            throw ex;
        }
        X509Key key = p10.getSubjectPublicKeyInfo();
        if (key == null) {
            logger.error(CMS.getLogMessage("CMSGW_MISSING_KEY_IN_P10", new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_MISSING_KEY_IN_P10", new String[0]));
        }
        CertificateX509Key certKey = new CertificateX509Key(key);
        try {
            certInfo.set("key", (Object)certKey);
        }
        catch (CertificateException e) {
            ECMSGWException ex = new ECMSGWException(CMS.getUserMessage("CMS_GW_SET_KEY_FROM_P10_FAILED", e.toString()), e);
            logger.error("PKCS10Processor: " + ex.getMessage(), (Throwable)e);
            throw ex;
        }
        catch (IOException e) {
            ECMSGWException ex = new ECMSGWException(CMS.getUserMessage("CMS_GW_SET_KEY_FROM_P10_FAILED", e.toString()), e);
            logger.error("PKCS10Processor: " + ex.getMessage(), (Throwable)e);
            throw ex;
        }
        X500Name subject = p10.getSubjectName();
        if (subject != null) {
            try {
                certInfo.set("subject", (Object)new CertificateSubjectName(subject));
                logger.info("PKCS10Processor: Setting subject name " + subject + " from p10.");
            }
            catch (CertificateException e) {
                logger.error(CMS.getLogMessage("CMSGW_FAILED_SET_SUBJECT_FROM_P10", e.toString()), (Throwable)e);
                throw new ECMSGWException(CMS.getUserMessage("CMS_GW_SET_SUBJECT_FROM_P10_FAILED", e.toString()), e);
            }
            catch (IOException e) {
                logger.error(CMS.getLogMessage("CMSGW_FAILED_SET_SUBJECT_FROM_P10", e.toString()), (Throwable)e);
                throw new ECMSGWException(CMS.getUserMessage("CMS_GW_SET_SUBJECT_FROM_P10_FAILED", e.toString()), e);
            }
            catch (Exception e) {
                logger.error(CMS.getLogMessage("CMSGW_FAILED_SET_SUBJECT_FROM_P10", e.toString()), (Throwable)e);
                throw new ECMSGWException(CMS.getUserMessage("CMS_GW_SET_SUBJECT_FROM_P10_FAILED", e.toString()), e);
            }
        } else if (authToken == null || authToken.getInString("tokenCertSubject") == null) {
            logger.error(CMS.getLogMessage("CMSGW_MISSING_SUBJECT_IN_P10", new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_MISSING_SUBJECT_IN_P10", new String[0]));
        }
        try {
            PKCS10Attribute p10Attr;
            PKCS10Attributes p10Attrs = p10.getAttributes();
            if (p10Attrs != null && (p10Attr = p10Attrs.getAttribute("extensions")) != null && p10Attr.getAttributeId().equals(PKCS9Attribute.EXTENSION_REQUEST_OID)) {
                Extensions exts0 = (Extensions)p10Attr.getAttributeValue();
                DerOutputStream extOut = new DerOutputStream();
                exts0.encode((OutputStream)extOut);
                byte[] extB = extOut.toByteArray();
                DerInputStream extIn = new DerInputStream(extB);
                CertificateExtensions exts = new CertificateExtensions(extIn);
                if (exts != null) {
                    certInfo.set("extensions", (Object)exts);
                }
            }
            logger.debug("PKCS10Processor: Seted cert extensions from pkcs10. ");
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSGW_FAILED_SET_EXTENSIONS_FROM_P10", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_SET_KEY_FROM_P10_FAILED", e.toString()), e);
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage("CMSGW_FAILED_SET_EXTENSIONS_FROM_P10", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_SET_KEY_FROM_P10_FAILED", e.toString()));
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage("CMSGW_FAILED_SET_EXTENSIONS_FROM_P10", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_SET_KEY_FROM_P10_FAILED", e.toString()), e);
        }
        String authMgr = this.mServlet.getAuthMgr();
        if (authToken != null && authToken.getInString("tokenCertSubject") != null && !authMgr.equals("passwdUserDBAuthMgr")) {
            PKCS10Processor.fillCertInfoFromAuthToken(certInfo, authToken);
        }
        if (this.mServletId.equals("caadminEnroll")) {
            PKCS10Processor.fillValidityFromForm(certInfo, httpParams);
        }
    }

    private PKCS10 getPKCS10(ArgBlock httpParams) throws EBaseException {
        PKCS10 pkcs10 = null;
        String certType = null;
        certType = httpParams.getValueAsString("csrCertType", null);
        if (certType == null) {
            certType = httpParams.getValueAsString("certType", "client");
        }
        if (certType.equals("client")) {
            String p10b64 = httpParams.getValueAsString("pkcs10Request", null);
            if (p10b64 != null) {
                try {
                    byte[] bytes = Utils.base64decode((String)p10b64);
                    pkcs10 = new PKCS10(bytes);
                }
                catch (Exception e) {
                    pkcs10 = httpParams.getValueAsPKCS10("pkcs10Request", false, null);
                }
            }
        } else {
            try {
                pkcs10 = httpParams.getValueAsPKCS10("pkcs10Request", false, null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return pkcs10;
    }
}

