/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.core.policy;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import java.util.Vector;
import org.dogtagpki.legacy.core.policy.GeneralNameConfig;
import org.dogtagpki.legacy.policy.IGeneralNamesConfig;
import org.mozilla.jss.netscape.security.x509.GeneralNames;

public class GeneralNamesConfig
implements IGeneralNamesConfig {
    public String mName = null;
    public GeneralNameConfig[] mGenNameConfigs = null;
    public ConfigStore mConfig;
    public boolean mIsValueConfigured = true;
    public boolean mIsPolicyEnabled = true;
    public int mDefNumGenNames = 8;
    public GeneralNames mGeneralNames = null;
    private String mNameDotGeneralName = this.mName + ".generalName";

    public GeneralNamesConfig(String name, ConfigStore config, boolean isValueConfigured, boolean isPolicyEnabled) throws EBaseException {
        this.mIsValueConfigured = isValueConfigured;
        this.mIsPolicyEnabled = isPolicyEnabled;
        this.mName = name;
        this.mNameDotGeneralName = this.mName != null ? this.mName + ".generalName" : "generalName";
        this.mConfig = config;
        int numGNs = this.mConfig.getInteger("numGeneralNames");
        if (numGNs < 0) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTR_VALUE", "numGeneralNames=" + numGNs, "value must be greater than or equal to 0."));
        }
        this.mGenNameConfigs = new GeneralNameConfig[numGNs];
        for (int i = 0; i < numGNs; ++i) {
            String storeName = this.mNameDotGeneralName + i;
            this.mGenNameConfigs[i] = this.newGeneralNameConfig(storeName, this.mConfig.getSubStore(storeName, ConfigStore.class), this.mIsValueConfigured, this.mIsPolicyEnabled);
        }
        if (this.mIsValueConfigured && this.mIsPolicyEnabled) {
            this.mGeneralNames = new GeneralNames();
            for (int j = 0; j < numGNs; ++j) {
                this.mGeneralNames.addElement((Object)this.mGenNameConfigs[j].mGeneralName);
            }
        }
    }

    @Override
    public GeneralNames getGeneralNames() {
        return this.mGeneralNames;
    }

    protected GeneralNameConfig newGeneralNameConfig(String name, ConfigStore config, boolean isValueConfigured, boolean isPolicyEnabled) throws EBaseException {
        return new GeneralNameConfig(name, config, isValueConfigured, isPolicyEnabled);
    }

    public GeneralNameConfig[] getGenNameConfig() {
        return (GeneralNameConfig[])this.mGenNameConfigs.clone();
    }

    public int getNumGeneralNames() {
        return this.mGenNameConfigs.length;
    }

    public ConfigStore getConfig() {
        return this.mConfig;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isValueConfigured() {
        return this.mIsValueConfigured;
    }

    public void setDefNumGenNames(int defNum) {
        this.mDefNumGenNames = defNum;
    }

    public int getDefNumGenNames() {
        return this.mDefNumGenNames;
    }

    public static void getDefaultParams(String name, boolean isValueConfigured, Vector<String> params) {
        Object nameDot = "";
        if (name != null) {
            nameDot = name + ".";
        }
        params.addElement((String)nameDot + "numGeneralNames=8");
        for (int i = 0; i < 8; ++i) {
            GeneralNameConfig.getDefaultParams((String)nameDot + "generalName" + i, isValueConfigured, params);
        }
    }

    @Override
    public void getInstanceParams(Vector<String> params) {
        params.addElement("numGeneralNames=" + this.mGenNameConfigs.length);
        for (int i = 0; i < this.mGenNameConfigs.length; ++i) {
            this.mGenNameConfigs[i].getInstanceParams(params);
        }
    }

    public static void getExtendedPluginInfo(String name, boolean isValueConfigured, Vector<String> info) {
        Object nameDot = "";
        if (name != null && name.length() > 0) {
            nameDot = name + ".";
        }
        info.addElement("numGeneralNames;number;The total number of alternative names or identities permitted in the extension.");
        for (int i = 0; i < 8; ++i) {
            GeneralNameConfig.getExtendedPluginInfo((String)nameDot + "generalName" + i, isValueConfigured, info);
        }
    }
}

