// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files
// DO NOT EDIT

use crate::AsyncProgress;
use crate::Repo;
use crate::RepoPullFlags;
use crate::Sysroot;
use crate::SysrootUpgraderFlags;
use crate::SysrootUpgraderPullFlags;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::translate::*;
use glib::StaticType;
use std::fmt;
use std::mem;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "OstreeSysrootUpgrader")]
    pub struct SysrootUpgrader(Object<ffi::OstreeSysrootUpgrader>);

    match fn {
        type_ => || ffi::ostree_sysroot_upgrader_get_type(),
    }
}

impl SysrootUpgrader {
    #[doc(alias = "ostree_sysroot_upgrader_new")]
    pub fn new<P: IsA<gio::Cancellable>>(sysroot: &Sysroot, cancellable: Option<&P>) -> Result<SysrootUpgrader, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::ostree_sysroot_upgrader_new(sysroot.to_glib_none().0, cancellable.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    #[doc(alias = "ostree_sysroot_upgrader_new_for_os")]
    #[doc(alias = "new_for_os")]
    pub fn for_os<P: IsA<gio::Cancellable>>(sysroot: &Sysroot, osname: Option<&str>, cancellable: Option<&P>) -> Result<SysrootUpgrader, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::ostree_sysroot_upgrader_new_for_os(sysroot.to_glib_none().0, osname.to_glib_none().0, cancellable.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    #[doc(alias = "ostree_sysroot_upgrader_new_for_os_with_flags")]
    #[doc(alias = "new_for_os_with_flags")]
    pub fn for_os_with_flags<P: IsA<gio::Cancellable>>(sysroot: &Sysroot, osname: Option<&str>, flags: SysrootUpgraderFlags, cancellable: Option<&P>) -> Result<SysrootUpgrader, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::ostree_sysroot_upgrader_new_for_os_with_flags(sysroot.to_glib_none().0, osname.to_glib_none().0, flags.into_glib(), cancellable.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    #[doc(alias = "ostree_sysroot_upgrader_deploy")]
    pub fn deploy<P: IsA<gio::Cancellable>>(&self, cancellable: Option<&P>) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::ostree_sysroot_upgrader_deploy(self.to_glib_none().0, cancellable.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    #[doc(alias = "ostree_sysroot_upgrader_dup_origin")]
    pub fn dup_origin(&self) -> Option<glib::KeyFile> {
        unsafe {
            from_glib_full(ffi::ostree_sysroot_upgrader_dup_origin(self.to_glib_none().0))
        }
    }

    #[doc(alias = "ostree_sysroot_upgrader_get_origin")]
    #[doc(alias = "get_origin")]
    pub fn origin(&self) -> Option<glib::KeyFile> {
        unsafe {
            from_glib_none(ffi::ostree_sysroot_upgrader_get_origin(self.to_glib_none().0))
        }
    }

    #[doc(alias = "ostree_sysroot_upgrader_get_origin_description")]
    #[doc(alias = "get_origin_description")]
    pub fn origin_description(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::ostree_sysroot_upgrader_get_origin_description(self.to_glib_none().0))
        }
    }

    #[doc(alias = "ostree_sysroot_upgrader_pull")]
    pub fn pull<P: IsA<gio::Cancellable>>(&self, flags: RepoPullFlags, upgrader_flags: SysrootUpgraderPullFlags, progress: Option<&AsyncProgress>, cancellable: Option<&P>) -> Result<bool, glib::Error> {
        unsafe {
            let mut out_changed = mem::MaybeUninit::uninit();
            let mut error = ptr::null_mut();
            let _ = ffi::ostree_sysroot_upgrader_pull(self.to_glib_none().0, flags.into_glib(), upgrader_flags.into_glib(), progress.to_glib_none().0, out_changed.as_mut_ptr(), cancellable.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            let out_changed = out_changed.assume_init();
            if error.is_null() { Ok(from_glib(out_changed)) } else { Err(from_glib_full(error)) }
        }
    }

    #[doc(alias = "ostree_sysroot_upgrader_pull_one_dir")]
    pub fn pull_one_dir<P: IsA<gio::Cancellable>>(&self, dir_to_pull: &str, flags: RepoPullFlags, upgrader_flags: SysrootUpgraderPullFlags, progress: Option<&AsyncProgress>, cancellable: Option<&P>) -> Result<bool, glib::Error> {
        unsafe {
            let mut out_changed = mem::MaybeUninit::uninit();
            let mut error = ptr::null_mut();
            let _ = ffi::ostree_sysroot_upgrader_pull_one_dir(self.to_glib_none().0, dir_to_pull.to_glib_none().0, flags.into_glib(), upgrader_flags.into_glib(), progress.to_glib_none().0, out_changed.as_mut_ptr(), cancellable.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            let out_changed = out_changed.assume_init();
            if error.is_null() { Ok(from_glib(out_changed)) } else { Err(from_glib_full(error)) }
        }
    }

    #[doc(alias = "ostree_sysroot_upgrader_set_origin")]
    pub fn set_origin<P: IsA<gio::Cancellable>>(&self, origin: Option<&glib::KeyFile>, cancellable: Option<&P>) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::ostree_sysroot_upgrader_set_origin(self.to_glib_none().0, origin.to_glib_none().0, cancellable.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    pub fn flags(&self) -> SysrootUpgraderFlags {
        unsafe {
            let mut value = glib::Value::from_type(<SysrootUpgraderFlags as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.as_ptr() as *mut glib::gobject_ffi::GObject, b"flags\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `flags` getter")
        }
    }

    pub fn osname(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.as_ptr() as *mut glib::gobject_ffi::GObject, b"osname\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `osname` getter")
        }
    }

    pub fn sysroot(&self) -> Option<Sysroot> {
        unsafe {
            let mut value = glib::Value::from_type(<Sysroot as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.as_ptr() as *mut glib::gobject_ffi::GObject, b"sysroot\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `sysroot` getter")
        }
    }

    #[doc(alias = "ostree_sysroot_upgrader_check_timestamps")]
    pub fn check_timestamps(repo: &Repo, from_rev: &str, to_rev: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::ostree_sysroot_upgrader_check_timestamps(repo.to_glib_none().0, from_rev.to_glib_none().0, to_rev.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }
}

impl fmt::Display for SysrootUpgrader {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("SysrootUpgrader")
    }
}
