use std::ffi::c_char;

use rats_cert::crypto::AsymmetricAlgo;
use rats_cert::crypto::HashAlgo;

#[allow(non_camel_case_types)]
pub type hash_algo_t = HashAlgo;

#[allow(non_camel_case_types)]
pub type asymmetric_algo_t = AsymmetricAlgo;

#[derive(Debug, PartialEq)]
#[repr(C)]
pub enum LocalAttesterType {
    Auto,
    SgxDcap,
    Tdx,
}

#[allow(non_camel_case_types)]
pub type local_attester_type_t = LocalAttesterType;

#[derive(Debug, PartialEq)]
#[repr(C)]
pub enum CocoAttestMode {
    /// Get CoCo evidence (generated by attestation-agent)
    Evidence,
    /// Get CoCo evidence from attestation-agent, and then convert it to CoCo attestation token.
    Token {
        /// The address of CoCo Attestation Service
        as_addr: *const c_char,
        /// If true, connect to Attestation Service via Grpc protocol. If false, connect via HTTP protocol.
        as_is_grpc: bool,
        /// The policy ids needed to check
        policy_ids: *const *const c_char,
        /// The length of policy_ids array
        policy_ids_len: usize,
    },
}

#[allow(non_camel_case_types)]
pub type coco_attest_mode_t = CocoAttestMode;

#[derive(Debug, PartialEq)]
#[repr(C)]
pub enum AttesterType {
    Local {
        /// The type of local attester.
        r#type: local_attester_type_t,
    },
    Coco {
        /// The detailed attest mode of CoCo to select
        attest_mode: coco_attest_mode_t,
        /// The ttrpc unix domain socket address of attestation-agent to connect to.
        aa_addr: *const c_char,
        /// Timeout for ttrpc call to AA, should be nano seconds. Wait indefinitely when set to 0.  
        timeout_nano: i64,
    },
}

#[allow(non_camel_case_types)]
pub type attester_type_t = AttesterType;
