// Code generated by go-swagger; DO NOT EDIT.

//
// Copyright 2021 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package entries

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/sigstore/rekor/pkg/generated/models"
)

// GetLogEntryByUUIDReader is a Reader for the GetLogEntryByUUID structure.
type GetLogEntryByUUIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetLogEntryByUUIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetLogEntryByUUIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewGetLogEntryByUUIDNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		result := NewGetLogEntryByUUIDDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetLogEntryByUUIDOK creates a GetLogEntryByUUIDOK with default headers values
func NewGetLogEntryByUUIDOK() *GetLogEntryByUUIDOK {
	return &GetLogEntryByUUIDOK{}
}

/*
GetLogEntryByUUIDOK describes a response with status code 200, with default header values.

Information needed for a client to compute the inclusion proof
*/
type GetLogEntryByUUIDOK struct {
	Payload models.LogEntry
}

// IsSuccess returns true when this get log entry by Uuid o k response has a 2xx status code
func (o *GetLogEntryByUUIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get log entry by Uuid o k response has a 3xx status code
func (o *GetLogEntryByUUIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get log entry by Uuid o k response has a 4xx status code
func (o *GetLogEntryByUUIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get log entry by Uuid o k response has a 5xx status code
func (o *GetLogEntryByUUIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get log entry by Uuid o k response a status code equal to that given
func (o *GetLogEntryByUUIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get log entry by Uuid o k response
func (o *GetLogEntryByUUIDOK) Code() int {
	return 200
}

func (o *GetLogEntryByUUIDOK) Error() string {
	return fmt.Sprintf("[GET /api/v1/log/entries/{entryUUID}][%d] getLogEntryByUuidOK  %+v", 200, o.Payload)
}

func (o *GetLogEntryByUUIDOK) String() string {
	return fmt.Sprintf("[GET /api/v1/log/entries/{entryUUID}][%d] getLogEntryByUuidOK  %+v", 200, o.Payload)
}

func (o *GetLogEntryByUUIDOK) GetPayload() models.LogEntry {
	return o.Payload
}

func (o *GetLogEntryByUUIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLogEntryByUUIDNotFound creates a GetLogEntryByUUIDNotFound with default headers values
func NewGetLogEntryByUUIDNotFound() *GetLogEntryByUUIDNotFound {
	return &GetLogEntryByUUIDNotFound{}
}

/*
GetLogEntryByUUIDNotFound describes a response with status code 404, with default header values.

The content requested could not be found
*/
type GetLogEntryByUUIDNotFound struct {
}

// IsSuccess returns true when this get log entry by Uuid not found response has a 2xx status code
func (o *GetLogEntryByUUIDNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get log entry by Uuid not found response has a 3xx status code
func (o *GetLogEntryByUUIDNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get log entry by Uuid not found response has a 4xx status code
func (o *GetLogEntryByUUIDNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get log entry by Uuid not found response has a 5xx status code
func (o *GetLogEntryByUUIDNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get log entry by Uuid not found response a status code equal to that given
func (o *GetLogEntryByUUIDNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get log entry by Uuid not found response
func (o *GetLogEntryByUUIDNotFound) Code() int {
	return 404
}

func (o *GetLogEntryByUUIDNotFound) Error() string {
	return fmt.Sprintf("[GET /api/v1/log/entries/{entryUUID}][%d] getLogEntryByUuidNotFound ", 404)
}

func (o *GetLogEntryByUUIDNotFound) String() string {
	return fmt.Sprintf("[GET /api/v1/log/entries/{entryUUID}][%d] getLogEntryByUuidNotFound ", 404)
}

func (o *GetLogEntryByUUIDNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetLogEntryByUUIDDefault creates a GetLogEntryByUUIDDefault with default headers values
func NewGetLogEntryByUUIDDefault(code int) *GetLogEntryByUUIDDefault {
	return &GetLogEntryByUUIDDefault{
		_statusCode: code,
	}
}

/*
GetLogEntryByUUIDDefault describes a response with status code -1, with default header values.

There was an internal error in the server while processing the request
*/
type GetLogEntryByUUIDDefault struct {
	_statusCode int

	Payload *models.Error
}

// IsSuccess returns true when this get log entry by UUID default response has a 2xx status code
func (o *GetLogEntryByUUIDDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get log entry by UUID default response has a 3xx status code
func (o *GetLogEntryByUUIDDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get log entry by UUID default response has a 4xx status code
func (o *GetLogEntryByUUIDDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get log entry by UUID default response has a 5xx status code
func (o *GetLogEntryByUUIDDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get log entry by UUID default response a status code equal to that given
func (o *GetLogEntryByUUIDDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get log entry by UUID default response
func (o *GetLogEntryByUUIDDefault) Code() int {
	return o._statusCode
}

func (o *GetLogEntryByUUIDDefault) Error() string {
	return fmt.Sprintf("[GET /api/v1/log/entries/{entryUUID}][%d] getLogEntryByUUID default  %+v", o._statusCode, o.Payload)
}

func (o *GetLogEntryByUUIDDefault) String() string {
	return fmt.Sprintf("[GET /api/v1/log/entries/{entryUUID}][%d] getLogEntryByUUID default  %+v", o._statusCode, o.Payload)
}

func (o *GetLogEntryByUUIDDefault) GetPayload() *models.Error {
	return o.Payload
}

func (o *GetLogEntryByUUIDDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
