# Offline file system KBC module

The offline file system KBC reads keys and resources from files present in the guest file system.
**The offline file system KBC is only secure to use when the guest file system is at no point readable by a hypothetical adversary**, such as with IBM Secure Execution for Linux (IBM Z & LinuxONE).
Being an offline module, it is not a broker _client_ in the stricter sense of the word.
See the [CoCo Keyprovider](../../../coco_keyprovider/README.md) for correspondent software to wrap keys.

## Usage

The guest must provide OpenSSL at runtime.
Keys must be provided in the guest file system at `/etc/aa-offline_fs_kbc-keys.json` like:
```json
{
    "default/image-decryption-key/key_id1": "base64-encoded-key",
    "default/image-decryption-key/key_id2": "base64-encoded-key",
    ...
}
```

with the 32-byte keys base64-encoded.

The script [`generate_keys.sh`](../../../coco_keyprovider/tools/generate_keys.sh) can be used to generate some sample keys based on `/dev/random` if it fits your use case sufficiently well.
Here is a sample generated keys file [`aa-offline_fs_kbc-keys.json`](aa-offline_fs_kbc-keys.json)

Resources must be provide in the guest file system at `/etc/aa-offline_fs_kbc-resources.json` like:
```json
{
  "default/security-policy/test": "<base64-encoded content from policy.json>",
  "default/sigstore-config/test": "<base64-encoded content from sigstore_config.yaml>",
  "default/gpg-public-config/test": "<base64-encoded content from pubkey.gpg>",
  "default/cosign-public-key/test": "<base64-encoded content from cosign.pub>",
  "default/credential/test": "<base64-encoded content from auth.json>"
}
```
The values are base64-encoded related file content, can be generated by command such as:
```bash
cat </path/to/policy.json> | base64
cat </path/to/sigstore_config.yaml> | base64
cat </path/to/pubkey.gpg> | base64
cat </path/to/cosign.pub> | base64
cat </path/to/auth.json> | base64
```
Here is a sample resource file [`aa-offline_fs_kbc-resources.json`](aa-offline_fs_kbc-resources.json) which base on the files under sample_kbc folder:
- [`policy.json`](../sample_kbc/policy.json)
- [`sigstore_config.yaml`](../sample_kbc/sigstore_config.yaml)
- [`pubkey.gpg`](../sample_kbc/pubkey.gpg)
- [`cosign.pub`](../sample_kbc/cosign.pub)
- [`auth.json`](../sample_kbc/auth.json)
    
Referrers

 - [containers-auth man page](https://github.com/containers/image/blob/main/docs/containers-auth.json.5.md)
 - [image-rs image authentication documentation](../../../../image-rs/docs/image_auth.md)

AA with this KBC can be build and run with e.g.:
```bash
cd attestation-agent
make KBC=offline_fs_kbc && make install
attestation-agent --keyprovider_sock 127.0.0.1:47777 --getresource_sock 127.0.0.1:48888
```
