/*
 * Rekor
 *
 * Rekor is a cryptographically secure, immutable transparency log for signed software releases.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use crate::rekor::TreeSize;
use serde::{Deserialize, Serialize};

#[derive(Clone, Debug, PartialEq, Eq, Default, Serialize, Deserialize)]
pub struct InclusionProof {
    /// The index of the entry in the transparency log
    #[serde(rename = "logIndex")]
    pub log_index: i64,
    /// The hash value stored at the root of the merkle tree at the time the proof was generated
    #[serde(rename = "rootHash")]
    pub root_hash: String,
    /// The size of the merkle tree at the time the inclusion proof was generated
    #[serde(rename = "treeSize")]
    pub tree_size: TreeSize,
    /// A list of hashes required to compute the inclusion proof, sorted in order from leaf to root
    #[serde(rename = "hashes")]
    pub hashes: Vec<String>,
}

impl InclusionProof {
    pub fn new(
        log_index: i64,
        root_hash: String,
        tree_size: TreeSize,
        hashes: Vec<String>,
    ) -> InclusionProof {
        InclusionProof {
            log_index,
            root_hash,
            tree_size,
            hashes,
        }
    }
}
