.\"	$Id: dhclient.conf.5,v 1.34 2012/01/24 22:23:39 sar Exp $
.\"
.\" Copyright (c) 2004-2017 by Internet Systems Consortium, Inc. ("ISC")
.\" Copyright (c) 1996-2003 by Internet Software Consortium
.\"
.\" Permission to use, copy, modify, and distribute this software for any
.\" purpose with or without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES
.\" WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR
.\" ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
.\" WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
.\" ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
.\" OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\"   Internet Systems Consortium, Inc.
.\"   950 Charter Street
.\"   Redwood City, CA 94063
.\"   <info@isc.org>
.\"   https://www.isc.org/
.\"
.\" Support and other services are available for ISC products - see
.\" https://www.isc.org for more information or to learn more about ISC.
.\"
.TH dhclient.conf 5
.SH NAME
dhclient.conf - DHCP client configuration file
.SH DESCRIPTION
The dhclient.conf file contains configuration information for
.IR dhclient,
the Internet Systems Consortium DHCP Client.
.PP
The dhclient.conf file is a free-form ASCII text file.  It is parsed by
the recursive-descent parser built into dhclient.  The file may contain
extra tabs and newlines for formatting purposes.  Keywords in the file
are case-insensitive.  Comments may be placed anywhere within the
file (except within quotes).  Comments begin with the # character and
end at the end of the line.
.PP
The dhclient.conf file can be used to configure the behaviour of the
client in a wide variety of ways: protocol timing, information
requested from the server, information required of the server,
defaults to use if the server does not provide certain information,
values with which to override information provided by the server, or
values to prepend or append to information provided by the server.
The configuration file can also be preinitialized with addresses to
use on networks that don't have DHCP servers.
.SH PROTOCOL TIMING
The timing behaviour of the client need not be configured by the user.
If no timing configuration is provided by the user, a fairly
reasonable timing behaviour will be used by default - one which
results in fairly timely updates without placing an inordinate load on
the server.
.PP
If required the following statements can be used to adjust the timing
behaviour of the DHCPv4 client.  The DHCPv6 protocol provides values
to use and they are not currently configurable.
.PP
.I The
.B timeout
.I statement
.PP
 \fBtimeout \fItime\fR\fB;\fR
.PP
The
.I timeout
statement determines the amount of time that must pass between the
time that the client begins to try to determine its address and the
time that it decides that it's not going to be able to contact a
server.  By default, this timeout is sixty seconds.  After the
timeout has passed, if there are any static leases defined in the
configuration file, or any leases remaining in the lease database that
have not yet expired, the client will loop through these leases
attempting to validate them, and if it finds one that appears to be
valid, it will use that lease's address.  If there are no valid
static leases or unexpired leases in the lease database, the client
will restart the protocol after the defined retry interval.
.PP
.I The
.B retry
.I statement
.PP
 \fBretry \fItime\fR\fB;\fR
.PP
The
.I retry
statement determines the time that must pass after the client has
determined that there is no DHCP server present before it tries again
to contact a DHCP server.  By default, this is five minutes.
.PP
.I The
.B select-timeout
.I statement
.PP
 \fBselect-timeout \fItime\fR\fB;\fR
.PP
It is possible (some might say desirable) for there to be more than
one DHCP server serving any given network.  In this case, it is
possible that a client may be sent more than one offer in response to
its initial lease discovery message.  It may be that one of these
offers is preferable to the other (e.g., one offer may have the
address the client previously used, and the other may not).
.PP
The
.I select-timeout
is the time after the client sends its first lease discovery request
at which it stops waiting for offers from servers, assuming that it
has received at least one such offer.  If no offers have been
received by the time the
.I select-timeout
has expired, the client will accept the first offer that arrives.
.PP
By default, the select-timeout is zero seconds - that is, the client
will take the first offer it sees.
.PP
.I The
.B reboot
.I statement
.PP
 \fBreboot \fItime\fR\fB;\fR
.PP
When the client is restarted, it first tries to reacquire the last
address it had.  This is called the INIT-REBOOT state.  If it is
still attached to the same network it was attached to when it last
ran, this is the quickest way to get started.  The
.I reboot
statement sets the time that must elapse after the client first tries
to reacquire its old address before it gives up and tries to discover
a new address.  By default, the reboot timeout is ten seconds.
.PP
.I The
.B backoff-cutoff
.I statement
.PP
 \fBbackoff-cutoff \fItime\fR\fB;\fR
.PP
The client uses an exponential backoff algorithm with some randomness,
so that if many clients try to configure themselves at the same time,
they will not make their requests in lockstep.  The
.I backoff-cutoff
statement determines the maximum amount of time that the client is
allowed to back off, the actual value will be evaluated randomly between
1/2 to 1 1/2 times the \fItime\fR specified.  It defaults to fifteen
seconds.
.PP
.I The
.B initial-interval
.I statement
.PP
 \fBinitial-interval \fItime\fR\fB;\fR
.PP
The
.I initial-interval
statement sets the amount of time between the first attempt to reach a
server and the second attempt to reach a server.  Each time a message
is sent, the interval between messages is incremented by twice the
current interval multiplied by a random number between zero and one.
If it is greater than the backoff-cutoff amount, it is set to that
amount.  It defaults to ten seconds.
.PP
.I The initial-delay
.I statement
.PP
 \fBinitial-delay \fItime\fR\fB;\fR
.PP
.I initial-delay 
parameter sets the maximum time client can wait after start before 
commencing first transmission.
According to RFC2131 Section 4.4.1, client should wait a random time between
startup and the actual first transmission. Previous versions of ISC DHCP 
client used to wait random time up to 5 seconds, but that was unwanted
due to impact on startup time. As such, new versions have the default
initial delay set to 0. To restore old behavior, please set initial-delay
to 5.
.SH DHCPv6 LEASE SELECTION
In the DHCPv6 protocol the client will wait a small amount of time to
allow ADVERTISE messages from multiple servers to arrive.  It will then
need to choose from all of the messages that may have arrived before
proceeding to making a request of the selected server.

The first selection criteria is the set of options and addresses
in the message.  Messages that don't include an option specified
as required will be given a score of 0 and not used.  If the
\fI-R\fR option is given on the command line then messages that
don't include the correct number of bindings (IA-NA, IA-TA or
IA-PD) will be discarded.

The next criteria is the preference value from the message.  With
the highest preference value being used even if leases with better
addresses or options are available.

Finally the lease is scored and the lease with the highest score
is selected.  A lease's score is based on the number of bindings,
number of addresses and number of options it contains:
.nf
	bindings * X + addresses * Y + options
.fi
By default X = 10000 and Y = 100, this will cause the client to
select a lease with more bindings over a lease with less bindings
but more addresses.  The weightings were changed as part of
implementing RFC 7550.  Previously they were X = 50 and Y = 100
meaning more addresses were preferred over more bindings.  If
you wish to continue using the old style you may do so by editing
the file includes/site.h and uncommenting the define for
USE_ORIGINAL_CLIENT_LEASE_WEIGHTS.
.SH LEASE REQUIREMENTS AND REQUESTS
The DHCP protocol allows the client to request that the server send it
specific information, and not send it other information that it is not
prepared to accept.  The protocol also allows the client to reject
offers from servers if they don't contain information the client
needs, or if the information provided is not satisfactory.
.PP
There is a variety of data contained in offers that DHCP servers send
to DHCP clients.  The data that can be specifically requested is what
are called \fIDHCP Options\fR.  DHCP Options are defined in
 \fBdhcp-options(5)\fR.
.PP
.I The
.B request
.I statement
.PP
 \fB[ also ] request [ [ \fIoption-space\fR . ] \fIoption\fR ] [\fB,\fI ... ]\fB;\fR
.PP
The request statement causes the client to request that any server
responding to the client send the client its values for the specified
options.  Only the option names should be specified in the request
statement - not option parameters.  By default, the DHCPv4 client
requests the subnet-mask, broadcast-address, time-offset, routers,
domain-name, domain-name-servers and host-name options while the DHCPv6
client requests the dhcp6 name-servers and domain-search options.  Note
that if you enter a \'request\' statement, you over-ride these defaults
and these options will not be requested.
.PP
In some cases, it may be desirable to send no parameter request list
at all.  To do this, simply write the request statement but specify
no parameters:
.PP
.nf
	request;
.fi
.PP
In most cases, it is desirable to simply add one option to the request
list which is of interest to the client in question.  In this case, it
is best to \'also request\' the additional options:
.PP
.nf
	also request domain-search, dhcp6.sip-servers-addresses;
.fi
.PP
.I The
.B require
.I statement
.PP
 \fB[ also ] require [ [ \fIoption-space\fR . ] \fIoption\fR ] [\fB,\fI ... ]\fB;\fR
.PP
The require statement lists options that must be sent in order for an
offer to be accepted.  Offers that do not contain all the listed
options will be ignored.  There is no default require list.
.PP
.nf
	require name-servers;

	interface eth0 {
		also require domain-search;
	}
.fi

NOTE: For ISC DHCP release 4.3.5 and earlier, dhclient running in -6 mode does
not discard offers as described above. This has been corrected as of release
4.3.6 but must be enabled at compile time (see ENFORCE_DHCPV6_CLIENT_REQUIRE
in includes/site.h).
.PP
.I The
.B send
.I statement
.PP
 \fBsend [ \fIoption declaration\fR ] \fB;\fR
.PP
The send statement causes the client to send the specified option to
the server with the specified value.  This is a full option
declaration as described in \fBdhcp-options(5)\fR.  Options that are
always sent in the DHCP protocol should not be specified here, except
that the client can specify a requested \fBdhcp-lease-time\fR option other
than the default requested lease time, which is two hours.  The other
obvious use for this statement is to send information to the server
that will allow it to differentiate between this client and other
clients or kinds of clients.
.SH DYNAMIC DNS
The client now has some very limited support for doing DNS updates
when a lease is acquired.  This is prototypical, and probably doesn't
do what you want.  It also only works if you happen to have control
over your DNS server, which isn't very likely.
.PP
Note that everything in this section is true whether you are using DHCPv4
or DHCPv6.  The exact same syntax is used for both.
.PP
To make it work, you have to declare a key and zone as in the DHCP
server (see \fBdhcpd.conf\fR(5) for details).  You also need to
configure the \fIfqdn\fR option on the client, as follows:
.PP
.nf
  send fqdn.fqdn "grosse.example.com.";
  send fqdn.encoded on;
  send fqdn.server-update off;
  also request fqdn, dhcp6.fqdn;
.fi
.PP
The \fIfqdn.fqdn\fR option \fBMUST\fR be a fully-qualified domain
name.  You \fBMUST\fR define a zone statement for the zone to be
updated.  The \fIfqdn.encoded\fR option may need to be set to
\fIon\fR or \fIoff\fR, depending on the DHCP server you are using.
.PP
.I The
.B do-forward-updates
.I statement
.PP
 \fBdo-forward-updates [ \fIflag\fR ] \fB;\fR
.PP
If you want to do DNS updates in the DHCP client
script (see \fBdhclient-script(8)\fR) rather than having the
DHCP client do the update directly (for example, if you want to
use SIG(0) authentication, which is not supported directly by the
DHCP client, you can instruct the client not to do the update using
the \fBdo-forward-updates\fR statement.  \fIFlag\fR should be \fBtrue\fR
if you want the DHCP client to do the update, and \fBfalse\fR if
you don't want the DHCP client to do the update.  By default, the DHCP
client will do the DNS update.
.SH OPTION MODIFIERS
In some cases, a client may receive option data from the server which
is not really appropriate for that client, or may not receive
information that it needs, and for which a useful default value
exists.  It may also receive information which is useful, but which
needs to be supplemented with local information.  To handle these
needs, several option modifiers are available.
.PP
.I The
.B default
.I statement
.PP
 \fBdefault [ \fIoption declaration\fR ] \fB;\fR
.PP
If for some option the client should use the value supplied by
the server, but needs to use some default value if no value was supplied
by the server, these values can be defined in the
.B default
statement.
.PP
.I The
.B supersede
.I statement
.PP
 \fBsupersede [ \fIoption declaration\fR ] \fB;\fR
.PP
If for some option the client should always use a locally-configured
value or values rather than whatever is supplied by the server, these
values can be defined in the 
.B supersede
statement.
.PP
.I The
.B prepend
.I statement
.PP
 \fBprepend [ \fIoption declaration\fR ] \fB;\fR
.PP
If for some set of options the client should use a value you
supply, and then use the values supplied by
the server, if any, these values can be defined in the
.B prepend
statement.  The
.B prepend
statement can only be used for options which
allow more than one value to be given.  This restriction is not
enforced - if you ignore it, the behaviour will be unpredictable.
.PP
.I The
.B append
.I statement
.PP
 \fBappend [ \fIoption declaration\fR ] \fB;\fR
.PP
If for some set of options the client should first use the values
supplied by the server, if any, and then use values you supply, these
values can be defined in the
.B append
statement.  The
.B append
statement can only be used for options which
allow more than one value to be given.  This restriction is not
enforced - if you ignore it, the behaviour will be unpredictable.
.SH LEASE DECLARATIONS
.PP
.I The
.B lease
.I declaration
.PP
 \fBlease {\fR \fIlease-declaration\fR [ ... \fIlease-declaration ] \fB}\fR
.PP
The DHCP client may decide after some period of time (see \fBPROTOCOL
TIMING\fR) that it is not going to succeed in contacting a
server.  At that time, it consults its own database of old leases and
tests each one that has not yet timed out by pinging the listed router
for that lease to see if that lease could work.  It is possible to
define one or more \fIfixed\fR leases in the client configuration file
for networks where there is no DHCP or BOOTP service, so that the
client can still automatically configure its address.  This is done
with the
.B lease
statement.
.PP
NOTE: the lease statement is also used in the dhclient.leases file in
order to record leases that have been received from DHCP servers.
Some of the syntax for leases as described below is only needed in the
dhclient.leases file.  Such syntax is documented here for
completeness.
.PP
A lease statement consists of the lease keyword, followed by a left
curly brace, followed by one or more lease declaration statements,
followed by a right curly brace.  The following lease declarations
are possible:
.PP
 \fBbootp;\fR
.PP
The
.B bootp
statement is used to indicate that the lease was acquired using the
BOOTP protocol rather than the DHCP protocol.  It is never necessary
to specify this in the client configuration file.  The client uses
this syntax in its lease database file.
.PP
 \fBinterface\fR \fB"\fR\fIstring\fR\fB";\fR
.PP
The
.B interface
lease statement is used to indicate the interface on which the lease
is valid.  If set, this lease will only be tried on a particular
interface.  When the client receives a lease from a server, it always
records the interface number on which it received that lease.
If predefined leases are specified in the dhclient.conf file, the
interface should also be specified, although this is not required.
.PP
 \fBfixed-address\fR \fIip-address\fR\fB;\fR
.PP
The
.B fixed-address
statement is used to set the ip address of a particular lease.  This
is required for all lease statements.  The IP address must be
specified as a dotted quad (e.g., 12.34.56.78).
.PP
 \fBfilename "\fR\fIstring\fR\fB";\fR
.PP
The
.B filename
statement specifies the name of the boot filename to use.  This is
not used by the standard client configuration script, but is included
for completeness.
.PP
 \fBserver-name "\fR\fIstring\fR\fB";\fR
.PP
The
.B server-name
statement specifies the name of the boot server name to use.  This is
also not used by the standard client configuration script.
.PP
 \fBoption\fR \fIoption-declaration\fR\fB;\fR
.PP
The
.B option
statement is used to specify the value of an option supplied by the
server, or, in the case of predefined leases declared in
dhclient.conf, the value that the user wishes the client configuration
script to use if the predefined lease is used.
.PP
 \fBscript "\fIscript-name\fB";\fR
.PP
The
.B script
statement is used to specify the pathname of the dhcp client
configuration script.  This script is used by the dhcp client to set
each interface's initial configuration prior to requesting an address,
to test the address once it has been offered, and to set the
interface's final configuration once a lease has been acquired.  If
no lease is acquired, the script is used to test predefined leases, if
any, and also called once if no valid lease can be identified.  For
more information, see
.B dhclient-script(8).
.PP
 \fBvendor option space "\fIname\fB";\fR
.PP
The
.B vendor option space
statement is used to specify which option space should be used for
decoding the vendor-encapsulate-options option if one is received.
The \fIdhcp-vendor-identifier\fR can be used to request a specific
class of vendor options from the server.  See
.B dhcp-options(5)
for details.
.PP
 \fBmedium "\fImedia setup\fB";\fR
.PP
The
.B medium
statement can be used on systems where network interfaces cannot
automatically determine the type of network to which they are
connected.  The media setup string is a system-dependent parameter
which is passed to the dhcp client configuration script when
initializing the interface.  On Unix and Unix-like systems, the
argument is passed on the ifconfig command line when configuring the
interface.
.PP
The dhcp client automatically declares this parameter if it uses a
media type (see the
.B media
statement) when configuring the interface in order to obtain a lease.
This statement should be used in predefined leases only if the network
interface requires media type configuration.
.PP
 \fBrenew\fR \fIdate\fB;\fR
.PP
 \fBrebind\fR \fIdate\fB;\fR
.PP
 \fBexpire\fR \fIdate\fB;\fR
.PP
The \fBrenew\fR statement defines the time at which the dhcp client
should begin trying to contact its server to renew a lease that it is
using.  The \fBrebind\fR statement defines the time at which the dhcp
client should begin to try to contact \fIany\fR dhcp server in order
to renew its lease.  The \fBexpire\fR statement defines the time at
which the dhcp client must stop using a lease if it has not been able
to contact a server in order to renew it.
.PP
These declarations are automatically set in leases acquired by the
DHCP client, but must also be configured in predefined leases - a
predefined lease whose expiry time has passed will not be used by the
DHCP client.
.PP
Dates are specified in one of two ways.  The software will output times in
these two formats depending on if the \fBdb-time-format\fR configuration
parameter has been set to \fIdefault\fR or \fIlocal\fR.
.PP
If it is set to \fIdefault\fR, then \fIdate\fR values appear as follows:
.PP
 \fI<weekday> <year>\fB/\fI<month>\fB/\fI<day>
<hour>\fB:\fI<minute>\fB:\fI<second>\fR
.PP
The weekday is present to make it easy for a human to tell when a
lease expires - it's specified as a number from zero to six, with zero
being Sunday.  When declaring a predefined lease, it can always be
specified as zero.  The year is specified with the century, so it
should generally be four digits except for really long leases.  The
month is specified as a number starting with 1 for January.  The day
of the month is likewise specified starting with 1.  The hour is a
number between 0 and 23, the minute a number between 0 and 59, and the
second also a number between 0 and 59.
.PP
If the \fBdb-time-format\fR configuration was set to \fIlocal\fR, then
the \fIdate\fR values appear as follows:
.PP
 \fBepoch\fR \fI<seconds-since-epoch>\fR\fB; #\fR \fI<day-name> <month-name>
<day-number> <hours>\fR\fB:\fR\fI<minutes>\fR\fB:\fR\fI<seconds> <year>\fR
.PP
The \fIseconds-since-epoch\fR is as according to the system's local clock (often
referred to as "unix time").  The \fB#\fR symbol supplies a comment that
describes what actual time this is as according to the system's configured
timezone, at the time the value was written.  It is provided only for human
inspection, the epoch time is the only recommended value for machine
inspection.
.PP
Note that when defining a static lease, one may use either time format one
wishes, and need not include the comment or values after it.
.PP
If the time is infinite in duration, then the \fIdate\fR is \fBnever\fR
instead of an actual date.
.SH ALIAS DECLARATIONS
 \fBalias { \fI declarations ... \fB}\fR
.PP
Some DHCP clients running TCP/IP roaming protocols may require that in
addition to the lease they may acquire via DHCP, their interface also
be configured with a predefined IP alias so that they can have a
permanent IP address even while roaming.  The Internet Systems
Consortium DHCP client doesn't support roaming with fixed addresses
directly, but in order to facilitate such experimentation, the dhcp
client can be set up to configure an IP alias using the
.B alias
declaration.
.PP
The alias declaration resembles a lease declaration, except that
options other than the subnet-mask option are ignored by the standard
client configuration script, and expiry times are ignored.  A typical
alias declaration includes an interface declaration, a fixed-address
declaration for the IP alias address, and a subnet-mask option
declaration.  A medium statement should never be included in an alias
declaration.
.SH OTHER DECLARATIONS
 \fBdb-time-format\fR [ \fIdefault\fR | \fIlocal\fR ] \fB;\fR
.PP
The \fBdb-time-format\fR option determines which of two output methods are
used for printing times in leases files.  The \fIdefault\fR format provides
day-and-time in UTC, whereas \fIlocal\fR uses a seconds-since-epoch to store
the time value, and helpfully places a local timezone time in a comment on
the same line.  The formats are described in detail in this manpage, within
the LEASE DECLARATIONS section.
.PP
The
.I lease-id-format
parameter
.RS 0.25i
.PP
.B lease-id-format \fIformat\fB;\fR
.PP
The \fIformat\fR parameter must be either \fBoctal\fR or \fBhex\fR.
This parameter governs the format used to write certain values to lease
files. With the default format, octal, values are written as quoted strings in
which non-printable characters are represented as octal escapes -
a backslash character followed by three octal digits.  When the hex format
is specified, values are written as an unquoted series of hexadecimal digit
pairs, separated by colons.

Currently, the values written out based on lease-id-format are the default-duid
and the IAID value (DHCPv6 only).  The client automatically reads the values
in either format.  Note that when the format is octal, rather than as an octal
string, IAID is output as hex if it contains no printable characters or as a
string if contains only printable characters. This is done to maintain backward
compatibility.
.PP
 \fBreject \fIcidr-ip-address\fR [\fB,\fR \fI...\fB \fIcidr-ip-address\fR ] \fB;\fR
.PP
The
.B reject
statement causes the DHCP client to reject offers from
servers whose server identifier matches any of the specified hosts or
subnets.  This can be used to avoid being configured by rogue or
misconfigured dhcp servers, although it should be a last resort -
better to track down the bad DHCP server and fix it.
.PP
The \fIcidr-ip-address\fR configuration type is of the
form \fIip-address\fR[\fB/\fIprefixlen\fR], where \fIip-address\fR is a
dotted quad IP address, and \fRprefixlen\fR is the CIDR prefix length of
the subnet, counting the number of significant bits in the netmask starting
from the leftmost end.  Example configuration syntax:
.PP
.I \fIreject\fR 192.168.0.0\fB/\fR16\fB,\fR 10.0.0.5\fB;\fR
.PP
The above example would cause offers from any server identifier in the
entire RFC 1918 "Class C" network 192.168.0.0/16, or the specific
single address 10.0.0.5, to be rejected.
.PP
 \fBinterface "\fIname\fB" { \fIdeclarations ... \fB }
.PP
A client with more than one network interface may require different
behaviour depending on which interface is being configured.  All
timing parameters and declarations other than lease and alias
declarations can be enclosed in an interface declaration, and those
parameters will then be used only for the interface that matches the
specified name.  Interfaces for which there is no interface
declaration will use the parameters declared outside of any interface
declaration, or the default settings.
.PP
.B Note well:
ISC dhclient only maintains one list of interfaces, which is either
determined at startup from command line arguments, or otherwise is
autodetected.  If you supplied the list of interfaces on the command
line, this configuration clause will add the named interface to the
list in such a way that will cause it to be configured by DHCP.  Which
may not be the result you had intended.  This is an undesirable side
effect that will be addressed in a future release.
.PP
 \fBpseudo "\fIname\fR" "\fIreal-name\fB" { \fIdeclarations ... \fB }
.PP
Under some circumstances it can be useful to declare a pseudo-interface 
and have the DHCP client acquire a configuration for that interface.
Each interface that the DHCP client is supporting normally has a DHCP
client state machine running on it to acquire and maintain its lease.
A pseudo-interface is just another state machine running on the
interface named \fIreal-name\fR, with its own lease and its own
state.  If you use this feature, you must provide a client identifier
for both the pseudo-interface and the actual interface, and the two
identifiers must be different.  You must also provide a separate
client script for the pseudo-interface to do what you want with the IP
address.  For example:
.PP
.nf
	interface "ep0" {
		send dhcp-client-identifier "my-client-ep0";
	}
	pseudo "secondary" "ep0" {
		send dhcp-client-identifier "my-client-ep0-secondary";
		script "/etc/dhclient-secondary";
	}
.fi
.PP
The client script for the pseudo-interface should not configure the
interface up or down - essentially, all it needs to handle are the
states where a lease has been acquired or renewed, and the states
where a lease has expired.  See \fBdhclient-script(8)\fR for more
information.
.PP
 \fBmedia "\fImedia setup\fB"\fI [ \fB, "\fImedia setup\fB", \fI... ]\fB;\fR
.PP
The
.B media
statement defines one or more media configuration parameters which may
be tried while attempting to acquire an IP address.  The dhcp client
will cycle through each media setup string on the list, configuring
the interface using that setup and attempting to boot, and then trying
the next one.  This can be used for network interfaces which aren't
capable of sensing the media type unaided - whichever media type
succeeds in getting a request to the server and hearing the reply is
probably right (no guarantees).
.PP
The media setup is only used for the initial phase of address
acquisition (the DHCPDISCOVER and DHCPOFFER packets).  Once an
address has been acquired, the dhcp client will record it in its lease
database and will record the media type used to acquire the address.
Whenever the client tries to renew the lease, it will use that same
media type.  The lease must expire before the client will go back to
cycling through media types.
.PP
 \fBhardware\fR \fIlink-type mac-address\fR\fB;\fR
.PP
The
.B hardware
statement defines the hardware MAC address to use for this interface,
for DHCP servers or relays to direct their replies.  dhclient will determine
the interface's MAC address automatically, so use of this parameter
is not recommended.  The \fIlink-type\fR corresponds to the interface's
link layer type (example: \'ethernet\'), while the \fImac-address\fR is
a string of colon-separated hexadecimal values for octets.
.PP
 \fBanycast-mac\fR \fIlink-type mac-address\fR\fB;\fR
.PP
The
.B anycast-mac
statement over-rides the all-ones broadcast MAC address dhclient will use
when it is transmitting packets to the all-ones limited broadcast IPv4
address.  This configuration parameter is useful to reduce the number of
broadcast packets transmitted by DHCP clients, but is only useful if you
know the DHCP service(s) anycast MAC address prior to configuring your
client.  The \fIlink-type\fR and \fImac-address\fR parameters are configured
in a similar manner to the \fBhardware\fR statement.
.PP
.SH SAMPLE
The following configuration file was used on a laptop running NetBSD
1.3, though the domains have been modified.
The laptop has an IP alias of 192.5.5.213, and has one
interface, ep0 (a 3com 3C589C).  Booting intervals have been
shortened somewhat from the default, because the client is known to
spend most of its time on networks with little DHCP activity.  The
laptop does roam to multiple networks.

.nf

timeout 60;
retry 60;
reboot 10;
select-timeout 5;
initial-interval 2;
reject 192.33.137.209;

interface "ep0" {
    send host-name "andare.example.com";
    hardware ethernet 00:a0:24:ab:fb:9c;
    send dhcp-client-identifier 1:0:a0:24:ab:fb:9c;
    send dhcp-lease-time 3600;
    supersede domain-search "example.com", "rc.isc.org", "home.isc.org";
    prepend domain-name-servers 127.0.0.1;
    request subnet-mask, broadcast-address, time-offset, routers,
	    domain-name, domain-name-servers, host-name;
    require subnet-mask, domain-name-servers;
    script "CLIENTBINDIR/dhclient-script";
    media "media 10baseT/UTP", "media 10base2/BNC";
}

alias {
  interface "ep0";
  fixed-address 192.5.5.213;
  option subnet-mask 255.255.255.255;
}
.fi
This is a very complicated dhclient.conf file - in general, yours
should be much simpler.  In many cases, it's sufficient to just
create an empty dhclient.conf file - the defaults are usually fine.
.SH SEE ALSO
dhcp-options(5), dhcp-eval(5), dhclient.leases(5), dhcpd(8), dhcpd.conf(5),
RFC2132, RFC2131.
.SH AUTHOR
.B dhclient(8)
Information about Internet Systems Consortium can be found at
.B https://www.isc.org.
