﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/guardduty/model/GetMalwareScanSettingsResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::GuardDuty::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetMalwareScanSettingsResult::GetMalwareScanSettingsResult() : 
    m_ebsSnapshotPreservation(EbsSnapshotPreservation::NOT_SET)
{
}

GetMalwareScanSettingsResult::GetMalwareScanSettingsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) : 
    m_ebsSnapshotPreservation(EbsSnapshotPreservation::NOT_SET)
{
  *this = result;
}

GetMalwareScanSettingsResult& GetMalwareScanSettingsResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("scanResourceCriteria"))
  {
    m_scanResourceCriteria = jsonValue.GetObject("scanResourceCriteria");

  }

  if(jsonValue.ValueExists("ebsSnapshotPreservation"))
  {
    m_ebsSnapshotPreservation = EbsSnapshotPreservationMapper::GetEbsSnapshotPreservationForName(jsonValue.GetString("ebsSnapshotPreservation"));

  }


  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if(requestIdIter != headers.end())
  {
    m_requestId = requestIdIter->second;
  }


  return *this;
}
