﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/guardduty/model/OrganizationMalwareProtectionConfiguration.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace GuardDuty
{
namespace Model
{

OrganizationMalwareProtectionConfiguration::OrganizationMalwareProtectionConfiguration() : 
    m_scanEc2InstanceWithFindingsHasBeenSet(false)
{
}

OrganizationMalwareProtectionConfiguration::OrganizationMalwareProtectionConfiguration(JsonView jsonValue) : 
    m_scanEc2InstanceWithFindingsHasBeenSet(false)
{
  *this = jsonValue;
}

OrganizationMalwareProtectionConfiguration& OrganizationMalwareProtectionConfiguration::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("scanEc2InstanceWithFindings"))
  {
    m_scanEc2InstanceWithFindings = jsonValue.GetObject("scanEc2InstanceWithFindings");

    m_scanEc2InstanceWithFindingsHasBeenSet = true;
  }

  return *this;
}

JsonValue OrganizationMalwareProtectionConfiguration::Jsonize() const
{
  JsonValue payload;

  if(m_scanEc2InstanceWithFindingsHasBeenSet)
  {
   payload.WithObject("scanEc2InstanceWithFindings", m_scanEc2InstanceWithFindings.Jsonize());

  }

  return payload;
}

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
