Name: cockpit-session-recording
Version: 20
Release: 1%{?dist}
Summary: Cockpit Session Recording
License: LGPL-2.1-or-later
URL:     https://github.com/Scribery/%{name}
Source:  https://github.com/Scribery/%{name}/releases/download/%{version}/%{name}-%{version}.tar.xz

BuildArch: noarch
%if ! 0%{?rhel} || 0%{?rhel} >= 10
BuildRequires: nodejs >= 18
%endif
BuildRequires: make
%if 0%{?suse_version}
# Suse's package has a different name
BuildRequires: appstream-glib
%else
BuildRequires: libappstream-glib
%endif
BuildRequires: gettext
%if 0%{?rhel} && 0%{?rhel} <= 8
BuildRequires: libappstream-glib-devel
%endif

Requires: cockpit-system
Requires: tlog
Requires: sssd-proxy

Provides: bundled(npm(@patternfly/patternfly)) = 6.2.3
Provides: bundled(npm(@patternfly/react-core)) = 6.2.2
Provides: bundled(npm(@patternfly/react-icons)) = 6.2.2
Provides: bundled(npm(@patternfly/react-styles)) = 6.2.2
Provides: bundled(npm(@patternfly/react-table)) = 6.2.2
Provides: bundled(npm(@patternfly/react-tokens)) = 6.2.2
Provides: bundled(npm(@xterm/addon-canvas)) = 0.7.0
Provides: bundled(npm(@xterm/xterm)) = 5.5.0
Provides: bundled(npm(array-timsort)) = 1.0.3
Provides: bundled(npm(attr-accept)) = 2.2.5
Provides: bundled(npm(base64-js)) = 1.5.1
Provides: bundled(npm(buffer)) = 6.0.3
Provides: bundled(npm(comment-json)) = 4.2.5
Provides: bundled(npm(core-util-is)) = 1.0.3
Provides: bundled(npm(esprima)) = 4.0.1
Provides: bundled(npm(file-selector)) = 2.1.2
Provides: bundled(npm(focus-trap)) = 7.6.4
Provides: bundled(npm(has-own-prop)) = 2.0.0
Provides: bundled(npm(ieee754)) = 1.2.1
Provides: bundled(npm(ini)) = 5.0.0
Provides: bundled(npm(jquery)) = 3.7.1
Provides: bundled(npm(js-tokens)) = 4.0.0
Provides: bundled(npm(lodash)) = 4.17.21
Provides: bundled(npm(loose-envify)) = 1.4.0
Provides: bundled(npm(object-assign)) = 4.1.1
Provides: bundled(npm(prop-types)) = 15.8.1
Provides: bundled(npm(react-dom)) = 18.3.1
Provides: bundled(npm(react-dropzone)) = 14.3.8
Provides: bundled(npm(react-is)) = 16.13.1
Provides: bundled(npm(react)) = 18.3.1
Provides: bundled(npm(repeat-string)) = 1.6.1
Provides: bundled(npm(scheduler)) = 0.23.2
Provides: bundled(npm(tabbable)) = 6.2.0
Provides: bundled(npm(throttle-debounce)) = 5.0.2
Provides: bundled(npm(tslib)) = 2.8.1

%description
Cockpit module providing session recording configuration and playback.
This module allows viewing and playback of journal-stored terminal session
recordings generated by the tlog component.

%prep
%setup -q -n %{name}

%build
NODE_ENV=production make

%install
%make_install PREFIX=/usr
appstream-util validate-relax --nonet %{buildroot}/%{_datadir}/metainfo/*

%files
%{_datadir}/cockpit/*
%{_datadir}/metainfo/*

%changelog
* Thu Feb 1 2024 Packit <hello@packit.dev> - 15-1
- Config: Update to authselect with-tlog feature
- stylelint: handle stylelint-scss deprecation
- Add ruff configuration
- package.json: drop flowtype plugin
- package.json: drop po2json
- package.json: document the required nodejs version
- fmf: Plumb through $TEST_* variables for unexpected messages
- tests: Use mc for testPlayBinary
- package.json: drop deprecated eslint-plugin-standard
- Revert "build: add support for /pybridge scenario"
- Player: Stop making the Terminal object state
- build.js: support flags
- packaging: Update spec License: to SPDX format
- build.js: Fix LINT env variable check
- Tests: Allow charset journal messages
- Update to the new root creation function
- package.json: Bump stylelint to 15
- test: add check for sssd config id_provider proxy
- Tests: Allow invalid non-UTF8 journal messages
- Add xterm-canvas-addon dependency for rendering
- Minor Eslint fixes
- Tests: Update data list to PF5 for testAppMenu
- Update org.cockpit-project.session-recording.metainfo.xml
- Makefile: bump our test/common dependency
- patternfly-5-overrides should be auto-imported by the page.scss file
- Drop obsolete pf-m-redhat-font class

* Wed May 17 2023 Packit <hello@packit.dev> - 14-1
- Upgrade to PatternFly 5 Alpha
- Makefile: Update Cockpit lib to da5abbb4245b0455cc8b610efe01e684
- package.json: Pin down versions of @patternfly/react-{styles,icons}
- Makefile: Update Cockpit lib to 947f1753867e3924b9617aaace936225
- Makefile: Fix watch dependencies
- Update release.yml
- Automate the release process

* Mon May 23 2022 Justin Stephenson <jstephen@redhat.com> - 12-1
- Drop moment.js dependency
- Tests: Assert pause state with a later command in rec1
- CI: Update image to ubuntu 20.04

* Mon Apr 18 2022 Justin Stephenson <jstephen@redhat.com> - 11.1
- Enable SSSD files domain unconditionally

* Wed Nov 17 2021 Justin Stephenson <jstephen@redhat.com> - 11-1
- Avoid crash in unmount if journal is null
- Sync Makefile closer to starter-kit
- Use current babel/eslint integration
- Use Flex layout for spacing the two config cards in the config page
- Use Page/PageSection/Breadcrumb patternfly components
- Move to xz dist tarballs
- Remove unused slider.html file
- package.json: explicitely depend on @patternfly/react-icons
- webpack: Use relative resolve path for npm 7 compatibility
- package.json: update patternfly packages
- package.json: use sass instead of node-sass
- Fetch pkg/lib automatically from cockpit instead of keeping a local copy
- Update Docker image and TEST_OS run to Fedora 35
- Tests: Test SSSD exclude_users and exclude_groups
- Config: Add SSSD exclude_users and exclude_groups
- TESTS: Fix testSessionRecordingConf cleanup issue
- TESTS: Restart SSSD after restoring config

* Wed Jul 21 2021 Justin Stephenson <jstephen@redhat.com> - 9-1
- Release v9
- Tests: Fix RHEL9 filter test timing failures

* Wed Jul 14 2021 Justin Stephenson <jstephen@redhat.com> - 8-1
- Release v8
- Throttle journalctl restarts
- Minor CI fixes

* Wed Jan 13 2021 Justin Stephenson <jstephen@redhat.com> - 7-1
- Release v7
- Remove bots sudo rm from Makefile
- Use journalctl --utc for Logs view to handle DST
- Add Applications Menu test
- Install cockpit-packagekit in local VM
- Set timezone for Logs Correlation test

* Mon Oct 12 2020 Justin Stephenson <jstephen@redhat.com> - 6-1
- Release v6
- Bump testlib to 229
- Add binary recording test

* Wed May 20 2020 Justin Stephenson <jstephen@redhat.com> - 4-1
- Release v4
- Update parent id in metainfo file
- Update package manifest
- Fix rpmmacro to resolve correc    t path on CentOS7
- Handle byte-array encoded journal data
- Don't clobber cockpit bots directory
- Move code out of deprecated React lifecycle functions

* Mon Nov 25 2019 Justin Stephenson <jstephen@redhat.com> - 3-1
- Release v3
- Reset Logs View on Player Rewind
- Configuration page UI CSS Improvements

* Wed Sep 11 2019 Justin Stephenson <jstephen@redhat.com> - 2-1
- Release 2
- Optimize performance when playing back flooded output recordings.
- Make Logs View optional rendered with a toggle button.
- Make Logs component a child of Recording component.
- Fix Recording page column sorting in Google Chrome.
- CSS updates for Patternfly 4 compatibility.
- Replace term.js with maintained xterm.js library.
- Fix hostname and username filtering.

* Thu Apr 4 2019 Kirill Glebov <kgliebov@redhat.com> - 1-1
- Release 1
- First release. Includes logs correlation, player controls, journal remote support.
