#ifndef DYNINST_AMDGPU_VEGA_SYS_REGS_H
#define DYNINST_AMDGPU_VEGA_SYS_REGS_H
DEF_REGISTER(address_mode_32,                          Arch_amdgpu_vega |        HWR |              BITS_32 |          0,"amdgpu_vega");
DEF_REGISTER(exec,                                     Arch_amdgpu_vega |        HWR |              BITS_64 |          1,"amdgpu_vega");
DEF_REGISTER(exec_lo,                                  Arch_amdgpu_vega |        0x0 |    BITS_32  | 0x8000 |          1,"amdgpu_vega");
DEF_REGISTER(exec_hi,                                  Arch_amdgpu_vega |   0x200000 |    BITS_32  | 0x8000 |          1,"amdgpu_vega");
DEF_REGISTER(expcnt,                                   Arch_amdgpu_vega |        HWR |               BITS_3 |          2,"amdgpu_vega");
DEF_REGISTER(export_icount,                            Arch_amdgpu_vega |        HWR |               BITS_8 |          3,"amdgpu_vega");
DEF_REGISTER(flat_scratch,                             Arch_amdgpu_vega |        HWR |              BITS_64 |          4,"amdgpu_vega");
DEF_REGISTER(flat_scratch_lo,                          Arch_amdgpu_vega |        0x0 |    BITS_32  | 0x8000 |          4,"amdgpu_vega");
DEF_REGISTER(flat_scratch_hi,                          Arch_amdgpu_vega |   0x200000 |    BITS_32  | 0x8000 |          4,"amdgpu_vega");
DEF_REGISTER(gpr_alloc,                                Arch_amdgpu_vega |        HWR |              BITS_32 |          5,"amdgpu_vega");
DEF_REGISTER(vgpr_base,                                Arch_amdgpu_vega |        0x0 |     BITS_6  | 0x8000 |          5,"amdgpu_vega");
DEF_REGISTER(vgpt_size,                                Arch_amdgpu_vega |    0x80000 |     BITS_6  | 0x8000 |          5,"amdgpu_vega");
DEF_REGISTER(sgpr_base,                                Arch_amdgpu_vega |   0x100000 |     BITS_6  | 0x8000 |          5,"amdgpu_vega");
DEF_REGISTER(sgpr_size,                                Arch_amdgpu_vega |   0x180000 |     BITS_4  | 0x8000 |          5,"amdgpu_vega");
DEF_REGISTER(ib_sts,                                   Arch_amdgpu_vega |        HWR |              BITS_32 |          6,"amdgpu_vega");
DEF_REGISTER(exp_cnt,                                  Arch_amdgpu_vega |    0x40000 |     BITS_3  | 0x8000 |          6,"amdgpu_vega");
DEF_REGISTER(lgkm_cnt,                                 Arch_amdgpu_vega |    0x80000 |     BITS_4  | 0x8000 |          6,"amdgpu_vega");
DEF_REGISTER(valu_cnt,                                 Arch_amdgpu_vega |    0xc0000 |     BITS_3  | 0x8000 |          6,"amdgpu_vega");
DEF_REGISTER(vm_cnt,                                   Arch_amdgpu_vega |    0xf0000 |     BITS_6  | 0x8000 |          6,"amdgpu_vega");
DEF_REGISTER(lds_alloc,                                Arch_amdgpu_vega |        HWR |              BITS_32 |          7,"amdgpu_vega");
DEF_REGISTER(lds_base,                                 Arch_amdgpu_vega |        0x0 |     BITS_8  | 0x8000 |          7,"amdgpu_vega");
DEF_REGISTER(lds_size,                                 Arch_amdgpu_vega |    0xc0000 |     BITS_9  | 0x8000 |          7,"amdgpu_vega");
DEF_REGISTER(lds_gds_constant_message_count,           Arch_amdgpu_vega |        HWR |               BITS_8 |          8,"amdgpu_vega");
DEF_REGISTER(lgkmcnt,                                  Arch_amdgpu_vega |        HWR |               BITS_4 |          9,"amdgpu_vega");
DEF_REGISTER(m0,                                       Arch_amdgpu_vega |        HWR |              BITS_32 |         10,"amdgpu_vega");
DEF_REGISTER(gds_size,                                 Arch_amdgpu_vega |        0x0 |    BITS_16  | 0x8000 |         10,"amdgpu_vega");
DEF_REGISTER(lds_direct_address,                       Arch_amdgpu_vega |        0x0 |    BITS_16  | 0x8000 |         10,"amdgpu_vega");
DEF_REGISTER(lds_interpolation_parameter_offset,       Arch_amdgpu_vega |        0x0 |    BITS_16  | 0x8000 |         10,"amdgpu_vega");
DEF_REGISTER(lds_memory_vfetch_offset,                 Arch_amdgpu_vega |        0x0 |    BITS_16  | 0x8000 |         10,"amdgpu_vega");
DEF_REGISTER(lds_direct_data_type,                     Arch_amdgpu_vega |   0x100000 |     BITS_3  | 0x8000 |         10,"amdgpu_vega");
DEF_REGISTER(lds_interpolation_new_prim_mask,          Arch_amdgpu_vega |   0x100000 |    BITS_15  | 0x8000 |         10,"amdgpu_vega");
DEF_REGISTER(gds_base,                                 Arch_amdgpu_vega |   0x100000 |    BITS_16  | 0x8000 |         10,"amdgpu_vega");
DEF_REGISTER(mode,                                     Arch_amdgpu_vega |        HWR |              BITS_32 |         11,"amdgpu_vega");
DEF_REGISTER(fp_round,                                 Arch_amdgpu_vega |        0x0 |     BITS_4  | 0x8000 |         11,"amdgpu_vega");
DEF_REGISTER(fp_denorm,                                Arch_amdgpu_vega |    0x40000 |     BITS_4  | 0x8000 |         11,"amdgpu_vega");
DEF_REGISTER(dx10_clamp,                               Arch_amdgpu_vega |    0x80000 |     BITS_1  | 0x8000 |         11,"amdgpu_vega");
DEF_REGISTER(ieee,                                     Arch_amdgpu_vega |    0x90000 |     BITS_1  | 0x8000 |         11,"amdgpu_vega");
DEF_REGISTER(lod_clamped,                              Arch_amdgpu_vega |    0xa0000 |     BITS_1  | 0x8000 |         11,"amdgpu_vega");
DEF_REGISTER(debug,                                    Arch_amdgpu_vega |    0xb0000 |     BITS_1  | 0x8000 |         11,"amdgpu_vega");
DEF_REGISTER(excp_en,                                  Arch_amdgpu_vega |    0xc0000 |     BITS_7  | 0x8000 |         11,"amdgpu_vega");
DEF_REGISTER(fp16_ovfl,                                Arch_amdgpu_vega |   0x170000 |     BITS_1  | 0x8000 |         11,"amdgpu_vega");
DEF_REGISTER(pops_packer0,                             Arch_amdgpu_vega |   0x180000 |     BITS_1  | 0x8000 |         11,"amdgpu_vega");
DEF_REGISTER(pops_packer1,                             Arch_amdgpu_vega |   0x190000 |     BITS_1  | 0x8000 |         11,"amdgpu_vega");
DEF_REGISTER(disable_perf,                             Arch_amdgpu_vega |   0x1a0000 |     BITS_1  | 0x8000 |         11,"amdgpu_vega");
DEF_REGISTER(gpr_idx_en,                               Arch_amdgpu_vega |   0x1b0000 |     BITS_1  | 0x8000 |         11,"amdgpu_vega");
DEF_REGISTER(vskip,                                    Arch_amdgpu_vega |   0x1c0000 |     BITS_1  | 0x8000 |         11,"amdgpu_vega");
DEF_REGISTER(csp,                                      Arch_amdgpu_vega |   0x1d0000 |     BITS_3  | 0x8000 |         11,"amdgpu_vega");
DEF_REGISTER(pc,                                       Arch_amdgpu_vega |         PC |              BITS_48 |          0,"amdgpu_vega");
DEF_REGISTER(pops_exiting_wave_id,                     Arch_amdgpu_vega |        HWR |              BITS_64 |         12,"amdgpu_vega");
DEF_REGISTER(private_base,                             Arch_amdgpu_vega |        HWR |              BITS_64 |         13,"amdgpu_vega");
DEF_REGISTER(private_limit,                            Arch_amdgpu_vega |        HWR |              BITS_64 |         14,"amdgpu_vega");
DEF_REGISTER(shared_base,                              Arch_amdgpu_vega |        HWR |              BITS_64 |         15,"amdgpu_vega");
DEF_REGISTER(shared_limit,                             Arch_amdgpu_vega |        HWR |              BITS_64 |         16,"amdgpu_vega");
DEF_REGISTER(status,                                   Arch_amdgpu_vega |        HWR |              BITS_32 |         17,"amdgpu_vega");
DEF_REGISTER(scc,                                      Arch_amdgpu_vega |        0x0 |     BITS_1  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(spi_prio,                                 Arch_amdgpu_vega |    0x10000 |     BITS_2  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(wave_prio,                                Arch_amdgpu_vega |    0x30000 |     BITS_2  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(priv,                                     Arch_amdgpu_vega |    0x50000 |     BITS_1  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(trap_en,                                  Arch_amdgpu_vega |    0x60000 |     BITS_1  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(ttrace_en,                                Arch_amdgpu_vega |    0x70000 |     BITS_1  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(export_rdy,                               Arch_amdgpu_vega |    0x80000 |     BITS_1  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(execz,                                    Arch_amdgpu_vega |    0x90000 |     BITS_1  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(vccz,                                     Arch_amdgpu_vega |    0xa0000 |     BITS_1  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(in_tg,                                    Arch_amdgpu_vega |    0xb0000 |     BITS_1  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(in_barrier,                               Arch_amdgpu_vega |    0xc0000 |     BITS_1  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(halt,                                     Arch_amdgpu_vega |    0xd0000 |     BITS_1  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(trap,                                     Arch_amdgpu_vega |    0xe0000 |     BITS_1  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(ttrace_cu_en,                             Arch_amdgpu_vega |    0xf0000 |     BITS_1  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(valid,                                    Arch_amdgpu_vega |   0x100000 |     BITS_1  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(ecc_err,                                  Arch_amdgpu_vega |   0x110000 |     BITS_1  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(skin_export,                              Arch_amdgpu_vega |   0x120000 |     BITS_1  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(perf_en,                                  Arch_amdgpu_vega |   0x130000 |     BITS_1  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(cond_dbg_user,                            Arch_amdgpu_vega |   0x140000 |     BITS_1  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(cond_dbg_sys,                             Arch_amdgpu_vega |   0x150000 |     BITS_1  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(allow_replay,                             Arch_amdgpu_vega |   0x160000 |     BITS_1  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(must_export,                              Arch_amdgpu_vega |   0x1b0000 |     BITS_1  | 0x8000 |         17,"amdgpu_vega");
DEF_REGISTER(tba,                                      Arch_amdgpu_vega |        HWR |              BITS_64 |         18,"amdgpu_vega");
DEF_REGISTER(tid,                                      Arch_amdgpu_vega |        HWR |              BITS_32 |         19,"amdgpu_vega");
DEF_REGISTER(tma,                                      Arch_amdgpu_vega |        HWR |              BITS_64 |         20,"amdgpu_vega");
DEF_REGISTER(trap_base_address,                        Arch_amdgpu_vega |        HWR |              BITS_64 |         21,"amdgpu_vega");
DEF_REGISTER(trap_memory_address,                      Arch_amdgpu_vega |        HWR |              BITS_64 |         22,"amdgpu_vega");
DEF_REGISTER(ttmp0,                                    Arch_amdgpu_vega |  TTMP_SGPR |              BITS_32 |          0,"amdgpu_vega");
DEF_REGISTER(ttmp1,                                    Arch_amdgpu_vega |  TTMP_SGPR |              BITS_32 |          1,"amdgpu_vega");
DEF_REGISTER(ttmp10,                                   Arch_amdgpu_vega |  TTMP_SGPR |              BITS_32 |          2,"amdgpu_vega");
DEF_REGISTER(ttmp11,                                   Arch_amdgpu_vega |  TTMP_SGPR |              BITS_32 |          3,"amdgpu_vega");
DEF_REGISTER(ttmp12,                                   Arch_amdgpu_vega |  TTMP_SGPR |              BITS_32 |          4,"amdgpu_vega");
DEF_REGISTER(ttmp13,                                   Arch_amdgpu_vega |  TTMP_SGPR |              BITS_32 |          5,"amdgpu_vega");
DEF_REGISTER(ttmp14,                                   Arch_amdgpu_vega |  TTMP_SGPR |              BITS_32 |          6,"amdgpu_vega");
DEF_REGISTER(ttmp15,                                   Arch_amdgpu_vega |  TTMP_SGPR |              BITS_32 |          7,"amdgpu_vega");
DEF_REGISTER(ttmp2,                                    Arch_amdgpu_vega |  TTMP_SGPR |              BITS_32 |          8,"amdgpu_vega");
DEF_REGISTER(ttmp3,                                    Arch_amdgpu_vega |  TTMP_SGPR |              BITS_32 |          9,"amdgpu_vega");
DEF_REGISTER(ttmp4,                                    Arch_amdgpu_vega |  TTMP_SGPR |              BITS_32 |         10,"amdgpu_vega");
DEF_REGISTER(ttmp5,                                    Arch_amdgpu_vega |  TTMP_SGPR |              BITS_32 |         11,"amdgpu_vega");
DEF_REGISTER(ttmp6,                                    Arch_amdgpu_vega |  TTMP_SGPR |              BITS_32 |         12,"amdgpu_vega");
DEF_REGISTER(ttmp7,                                    Arch_amdgpu_vega |  TTMP_SGPR |              BITS_32 |         13,"amdgpu_vega");
DEF_REGISTER(ttmp8,                                    Arch_amdgpu_vega |  TTMP_SGPR |              BITS_32 |         14,"amdgpu_vega");
DEF_REGISTER(ttmp9,                                    Arch_amdgpu_vega |  TTMP_SGPR |              BITS_32 |         15,"amdgpu_vega");
DEF_REGISTER(vcc,                                      Arch_amdgpu_vega |        HWR |              BITS_64 |         23,"amdgpu_vega");
DEF_REGISTER(vcc_lo,                                   Arch_amdgpu_vega |        0x0 |    BITS_32  | 0x8000 |         23,"amdgpu_vega");
DEF_REGISTER(vcc_hi,                                   Arch_amdgpu_vega |   0x200000 |    BITS_32  | 0x8000 |         23,"amdgpu_vega");
DEF_REGISTER(vectory_memory_icount,                    Arch_amdgpu_vega |        HWR |               BITS_8 |         24,"amdgpu_vega");
DEF_REGISTER(vmcnt,                                    Arch_amdgpu_vega |        HWR |               BITS_6 |         25,"amdgpu_vega");
DEF_REGISTER(xnack_mask,                               Arch_amdgpu_vega |        HWR |              BITS_64 |         26,"amdgpu_vega");
DEF_REGISTER(xnack_mask_lo,                            Arch_amdgpu_vega |        0x0 |    BITS_32  | 0x8000 |         26,"amdgpu_vega");
DEF_REGISTER(xnack_mask_hi,                            Arch_amdgpu_vega |   0x200000 |    BITS_32  | 0x8000 |         26,"amdgpu_vega");
DEF_REGISTER(sgpr0,                                    Arch_amdgpu_vega |       SGPR |              BITS_32 |          0,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_0,                              Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |          0,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_0,                              Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |          0,"amdgpu_vega");
DEF_REGISTER(sgpr_vec8_0,                              Arch_amdgpu_vega |  SGPR_VEC8 |             BITS_256 |          0,"amdgpu_vega");
DEF_REGISTER(sgpr_vec16_0,                             Arch_amdgpu_vega | SGPR_VEC16 |             BITS_512 |          0,"amdgpu_vega");
DEF_REGISTER(sgpr1,                                    Arch_amdgpu_vega |       SGPR |              BITS_32 |          1,"amdgpu_vega");
DEF_REGISTER(sgpr2,                                    Arch_amdgpu_vega |       SGPR |              BITS_32 |          2,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_2,                              Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |          2,"amdgpu_vega");
DEF_REGISTER(sgpr3,                                    Arch_amdgpu_vega |       SGPR |              BITS_32 |          3,"amdgpu_vega");
DEF_REGISTER(sgpr4,                                    Arch_amdgpu_vega |       SGPR |              BITS_32 |          4,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_4,                              Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |          4,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_4,                              Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |          4,"amdgpu_vega");
DEF_REGISTER(sgpr5,                                    Arch_amdgpu_vega |       SGPR |              BITS_32 |          5,"amdgpu_vega");
DEF_REGISTER(sgpr6,                                    Arch_amdgpu_vega |       SGPR |              BITS_32 |          6,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_6,                              Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |          6,"amdgpu_vega");
DEF_REGISTER(sgpr7,                                    Arch_amdgpu_vega |       SGPR |              BITS_32 |          7,"amdgpu_vega");
DEF_REGISTER(sgpr8,                                    Arch_amdgpu_vega |       SGPR |              BITS_32 |          8,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_8,                              Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |          8,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_8,                              Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |          8,"amdgpu_vega");
DEF_REGISTER(sgpr_vec8_8,                              Arch_amdgpu_vega |  SGPR_VEC8 |             BITS_256 |          8,"amdgpu_vega");
DEF_REGISTER(sgpr9,                                    Arch_amdgpu_vega |       SGPR |              BITS_32 |          9,"amdgpu_vega");
DEF_REGISTER(sgpr10,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         10,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_10,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         10,"amdgpu_vega");
DEF_REGISTER(sgpr11,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         11,"amdgpu_vega");
DEF_REGISTER(sgpr12,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         12,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_12,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         12,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_12,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         12,"amdgpu_vega");
DEF_REGISTER(sgpr13,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         13,"amdgpu_vega");
DEF_REGISTER(sgpr14,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         14,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_14,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         14,"amdgpu_vega");
DEF_REGISTER(sgpr15,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         15,"amdgpu_vega");
DEF_REGISTER(sgpr16,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         16,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_16,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         16,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_16,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         16,"amdgpu_vega");
DEF_REGISTER(sgpr_vec8_16,                             Arch_amdgpu_vega |  SGPR_VEC8 |             BITS_256 |         16,"amdgpu_vega");
DEF_REGISTER(sgpr_vec16_16,                            Arch_amdgpu_vega | SGPR_VEC16 |             BITS_512 |         16,"amdgpu_vega");
DEF_REGISTER(sgpr17,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         17,"amdgpu_vega");
DEF_REGISTER(sgpr18,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         18,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_18,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         18,"amdgpu_vega");
DEF_REGISTER(sgpr19,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         19,"amdgpu_vega");
DEF_REGISTER(sgpr20,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         20,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_20,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         20,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_20,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         20,"amdgpu_vega");
DEF_REGISTER(sgpr21,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         21,"amdgpu_vega");
DEF_REGISTER(sgpr22,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         22,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_22,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         22,"amdgpu_vega");
DEF_REGISTER(sgpr23,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         23,"amdgpu_vega");
DEF_REGISTER(sgpr24,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         24,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_24,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         24,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_24,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         24,"amdgpu_vega");
DEF_REGISTER(sgpr_vec8_24,                             Arch_amdgpu_vega |  SGPR_VEC8 |             BITS_256 |         24,"amdgpu_vega");
DEF_REGISTER(sgpr25,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         25,"amdgpu_vega");
DEF_REGISTER(sgpr26,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         26,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_26,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         26,"amdgpu_vega");
DEF_REGISTER(sgpr27,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         27,"amdgpu_vega");
DEF_REGISTER(sgpr28,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         28,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_28,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         28,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_28,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         28,"amdgpu_vega");
DEF_REGISTER(sgpr29,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         29,"amdgpu_vega");
DEF_REGISTER(sgpr30,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         30,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_30,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         30,"amdgpu_vega");
DEF_REGISTER(sgpr31,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         31,"amdgpu_vega");
DEF_REGISTER(sgpr32,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         32,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_32,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         32,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_32,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         32,"amdgpu_vega");
DEF_REGISTER(sgpr_vec8_32,                             Arch_amdgpu_vega |  SGPR_VEC8 |             BITS_256 |         32,"amdgpu_vega");
DEF_REGISTER(sgpr_vec16_32,                            Arch_amdgpu_vega | SGPR_VEC16 |             BITS_512 |         32,"amdgpu_vega");
DEF_REGISTER(sgpr33,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         33,"amdgpu_vega");
DEF_REGISTER(sgpr34,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         34,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_34,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         34,"amdgpu_vega");
DEF_REGISTER(sgpr35,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         35,"amdgpu_vega");
DEF_REGISTER(sgpr36,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         36,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_36,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         36,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_36,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         36,"amdgpu_vega");
DEF_REGISTER(sgpr37,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         37,"amdgpu_vega");
DEF_REGISTER(sgpr38,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         38,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_38,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         38,"amdgpu_vega");
DEF_REGISTER(sgpr39,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         39,"amdgpu_vega");
DEF_REGISTER(sgpr40,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         40,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_40,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         40,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_40,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         40,"amdgpu_vega");
DEF_REGISTER(sgpr_vec8_40,                             Arch_amdgpu_vega |  SGPR_VEC8 |             BITS_256 |         40,"amdgpu_vega");
DEF_REGISTER(sgpr41,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         41,"amdgpu_vega");
DEF_REGISTER(sgpr42,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         42,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_42,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         42,"amdgpu_vega");
DEF_REGISTER(sgpr43,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         43,"amdgpu_vega");
DEF_REGISTER(sgpr44,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         44,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_44,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         44,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_44,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         44,"amdgpu_vega");
DEF_REGISTER(sgpr45,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         45,"amdgpu_vega");
DEF_REGISTER(sgpr46,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         46,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_46,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         46,"amdgpu_vega");
DEF_REGISTER(sgpr47,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         47,"amdgpu_vega");
DEF_REGISTER(sgpr48,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         48,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_48,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         48,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_48,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         48,"amdgpu_vega");
DEF_REGISTER(sgpr_vec8_48,                             Arch_amdgpu_vega |  SGPR_VEC8 |             BITS_256 |         48,"amdgpu_vega");
DEF_REGISTER(sgpr_vec16_48,                            Arch_amdgpu_vega | SGPR_VEC16 |             BITS_512 |         48,"amdgpu_vega");
DEF_REGISTER(sgpr49,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         49,"amdgpu_vega");
DEF_REGISTER(sgpr50,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         50,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_50,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         50,"amdgpu_vega");
DEF_REGISTER(sgpr51,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         51,"amdgpu_vega");
DEF_REGISTER(sgpr52,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         52,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_52,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         52,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_52,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         52,"amdgpu_vega");
DEF_REGISTER(sgpr53,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         53,"amdgpu_vega");
DEF_REGISTER(sgpr54,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         54,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_54,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         54,"amdgpu_vega");
DEF_REGISTER(sgpr55,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         55,"amdgpu_vega");
DEF_REGISTER(sgpr56,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         56,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_56,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         56,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_56,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         56,"amdgpu_vega");
DEF_REGISTER(sgpr_vec8_56,                             Arch_amdgpu_vega |  SGPR_VEC8 |             BITS_256 |         56,"amdgpu_vega");
DEF_REGISTER(sgpr57,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         57,"amdgpu_vega");
DEF_REGISTER(sgpr58,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         58,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_58,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         58,"amdgpu_vega");
DEF_REGISTER(sgpr59,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         59,"amdgpu_vega");
DEF_REGISTER(sgpr60,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         60,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_60,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         60,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_60,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         60,"amdgpu_vega");
DEF_REGISTER(sgpr61,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         61,"amdgpu_vega");
DEF_REGISTER(sgpr62,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         62,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_62,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         62,"amdgpu_vega");
DEF_REGISTER(sgpr63,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         63,"amdgpu_vega");
DEF_REGISTER(sgpr64,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         64,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_64,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         64,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_64,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         64,"amdgpu_vega");
DEF_REGISTER(sgpr_vec8_64,                             Arch_amdgpu_vega |  SGPR_VEC8 |             BITS_256 |         64,"amdgpu_vega");
DEF_REGISTER(sgpr_vec16_64,                            Arch_amdgpu_vega | SGPR_VEC16 |             BITS_512 |         64,"amdgpu_vega");
DEF_REGISTER(sgpr65,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         65,"amdgpu_vega");
DEF_REGISTER(sgpr66,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         66,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_66,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         66,"amdgpu_vega");
DEF_REGISTER(sgpr67,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         67,"amdgpu_vega");
DEF_REGISTER(sgpr68,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         68,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_68,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         68,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_68,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         68,"amdgpu_vega");
DEF_REGISTER(sgpr69,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         69,"amdgpu_vega");
DEF_REGISTER(sgpr70,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         70,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_70,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         70,"amdgpu_vega");
DEF_REGISTER(sgpr71,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         71,"amdgpu_vega");
DEF_REGISTER(sgpr72,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         72,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_72,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         72,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_72,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         72,"amdgpu_vega");
DEF_REGISTER(sgpr_vec8_72,                             Arch_amdgpu_vega |  SGPR_VEC8 |             BITS_256 |         72,"amdgpu_vega");
DEF_REGISTER(sgpr73,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         73,"amdgpu_vega");
DEF_REGISTER(sgpr74,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         74,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_74,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         74,"amdgpu_vega");
DEF_REGISTER(sgpr75,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         75,"amdgpu_vega");
DEF_REGISTER(sgpr76,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         76,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_76,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         76,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_76,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         76,"amdgpu_vega");
DEF_REGISTER(sgpr77,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         77,"amdgpu_vega");
DEF_REGISTER(sgpr78,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         78,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_78,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         78,"amdgpu_vega");
DEF_REGISTER(sgpr79,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         79,"amdgpu_vega");
DEF_REGISTER(sgpr80,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         80,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_80,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         80,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_80,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         80,"amdgpu_vega");
DEF_REGISTER(sgpr_vec8_80,                             Arch_amdgpu_vega |  SGPR_VEC8 |             BITS_256 |         80,"amdgpu_vega");
DEF_REGISTER(sgpr_vec16_80,                            Arch_amdgpu_vega | SGPR_VEC16 |             BITS_512 |         80,"amdgpu_vega");
DEF_REGISTER(sgpr81,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         81,"amdgpu_vega");
DEF_REGISTER(sgpr82,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         82,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_82,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         82,"amdgpu_vega");
DEF_REGISTER(sgpr83,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         83,"amdgpu_vega");
DEF_REGISTER(sgpr84,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         84,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_84,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         84,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_84,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         84,"amdgpu_vega");
DEF_REGISTER(sgpr85,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         85,"amdgpu_vega");
DEF_REGISTER(sgpr86,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         86,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_86,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         86,"amdgpu_vega");
DEF_REGISTER(sgpr87,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         87,"amdgpu_vega");
DEF_REGISTER(sgpr88,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         88,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_88,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         88,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_88,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         88,"amdgpu_vega");
DEF_REGISTER(sgpr_vec8_88,                             Arch_amdgpu_vega |  SGPR_VEC8 |             BITS_256 |         88,"amdgpu_vega");
DEF_REGISTER(sgpr89,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         89,"amdgpu_vega");
DEF_REGISTER(sgpr90,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         90,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_90,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         90,"amdgpu_vega");
DEF_REGISTER(sgpr91,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         91,"amdgpu_vega");
DEF_REGISTER(sgpr92,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         92,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_92,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         92,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_92,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         92,"amdgpu_vega");
DEF_REGISTER(sgpr93,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         93,"amdgpu_vega");
DEF_REGISTER(sgpr94,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         94,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_94,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         94,"amdgpu_vega");
DEF_REGISTER(sgpr95,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         95,"amdgpu_vega");
DEF_REGISTER(sgpr96,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         96,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_96,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         96,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_96,                             Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |         96,"amdgpu_vega");
DEF_REGISTER(sgpr_vec8_96,                             Arch_amdgpu_vega |  SGPR_VEC8 |             BITS_256 |         96,"amdgpu_vega");
DEF_REGISTER(sgpr97,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         97,"amdgpu_vega");
DEF_REGISTER(sgpr98,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         98,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_98,                             Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |         98,"amdgpu_vega");
DEF_REGISTER(sgpr99,                                   Arch_amdgpu_vega |       SGPR |              BITS_32 |         99,"amdgpu_vega");
DEF_REGISTER(sgpr100,                                  Arch_amdgpu_vega |       SGPR |              BITS_32 |        100,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_100,                            Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |        100,"amdgpu_vega");
DEF_REGISTER(sgpr_vec4_100,                            Arch_amdgpu_vega |  SGPR_VEC4 |             BITS_128 |        100,"amdgpu_vega");
DEF_REGISTER(sgpr101,                                  Arch_amdgpu_vega |       SGPR |              BITS_32 |        101,"amdgpu_vega");
DEF_REGISTER(sgpr102,                                  Arch_amdgpu_vega |       SGPR |              BITS_32 |        102,"amdgpu_vega");
DEF_REGISTER(sgpr_vec2_102,                            Arch_amdgpu_vega |  SGPR_VEC2 |              BITS_64 |        102,"amdgpu_vega");
DEF_REGISTER(sgpr103,                                  Arch_amdgpu_vega |       SGPR |              BITS_32 |        103,"amdgpu_vega");
DEF_REGISTER(vgpr0,                                    Arch_amdgpu_vega |       VGPR |              BITS_32 |          0,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_0,                              Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |          0,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_0,                              Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |          0,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_0,                              Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |          0,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_0,                             Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |          0,"amdgpu_vega");
DEF_REGISTER(vgpr1,                                    Arch_amdgpu_vega |       VGPR |              BITS_32 |          1,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_1,                              Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |          1,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_1,                              Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |          1,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_1,                              Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |          1,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_1,                             Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |          1,"amdgpu_vega");
DEF_REGISTER(vgpr2,                                    Arch_amdgpu_vega |       VGPR |              BITS_32 |          2,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_2,                              Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |          2,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_2,                              Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |          2,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_2,                              Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |          2,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_2,                             Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |          2,"amdgpu_vega");
DEF_REGISTER(vgpr3,                                    Arch_amdgpu_vega |       VGPR |              BITS_32 |          3,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_3,                              Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |          3,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_3,                              Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |          3,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_3,                              Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |          3,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_3,                             Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |          3,"amdgpu_vega");
DEF_REGISTER(vgpr4,                                    Arch_amdgpu_vega |       VGPR |              BITS_32 |          4,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_4,                              Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |          4,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_4,                              Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |          4,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_4,                              Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |          4,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_4,                             Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |          4,"amdgpu_vega");
DEF_REGISTER(vgpr5,                                    Arch_amdgpu_vega |       VGPR |              BITS_32 |          5,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_5,                              Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |          5,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_5,                              Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |          5,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_5,                              Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |          5,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_5,                             Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |          5,"amdgpu_vega");
DEF_REGISTER(vgpr6,                                    Arch_amdgpu_vega |       VGPR |              BITS_32 |          6,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_6,                              Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |          6,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_6,                              Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |          6,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_6,                              Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |          6,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_6,                             Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |          6,"amdgpu_vega");
DEF_REGISTER(vgpr7,                                    Arch_amdgpu_vega |       VGPR |              BITS_32 |          7,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_7,                              Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |          7,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_7,                              Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |          7,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_7,                              Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |          7,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_7,                             Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |          7,"amdgpu_vega");
DEF_REGISTER(vgpr8,                                    Arch_amdgpu_vega |       VGPR |              BITS_32 |          8,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_8,                              Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |          8,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_8,                              Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |          8,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_8,                              Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |          8,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_8,                             Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |          8,"amdgpu_vega");
DEF_REGISTER(vgpr9,                                    Arch_amdgpu_vega |       VGPR |              BITS_32 |          9,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_9,                              Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |          9,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_9,                              Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |          9,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_9,                              Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |          9,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_9,                             Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |          9,"amdgpu_vega");
DEF_REGISTER(vgpr10,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         10,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_10,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         10,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_10,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         10,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_10,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         10,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_10,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         10,"amdgpu_vega");
DEF_REGISTER(vgpr11,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         11,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_11,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         11,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_11,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         11,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_11,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         11,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_11,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         11,"amdgpu_vega");
DEF_REGISTER(vgpr12,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         12,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_12,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         12,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_12,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         12,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_12,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         12,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_12,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         12,"amdgpu_vega");
DEF_REGISTER(vgpr13,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         13,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_13,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         13,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_13,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         13,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_13,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         13,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_13,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         13,"amdgpu_vega");
DEF_REGISTER(vgpr14,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         14,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_14,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         14,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_14,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         14,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_14,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         14,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_14,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         14,"amdgpu_vega");
DEF_REGISTER(vgpr15,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         15,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_15,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         15,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_15,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         15,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_15,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         15,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_15,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         15,"amdgpu_vega");
DEF_REGISTER(vgpr16,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         16,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_16,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         16,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_16,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         16,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_16,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         16,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_16,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         16,"amdgpu_vega");
DEF_REGISTER(vgpr17,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         17,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_17,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         17,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_17,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         17,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_17,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         17,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_17,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         17,"amdgpu_vega");
DEF_REGISTER(vgpr18,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         18,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_18,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         18,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_18,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         18,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_18,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         18,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_18,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         18,"amdgpu_vega");
DEF_REGISTER(vgpr19,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         19,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_19,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         19,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_19,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         19,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_19,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         19,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_19,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         19,"amdgpu_vega");
DEF_REGISTER(vgpr20,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         20,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_20,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         20,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_20,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         20,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_20,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         20,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_20,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         20,"amdgpu_vega");
DEF_REGISTER(vgpr21,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         21,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_21,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         21,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_21,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         21,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_21,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         21,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_21,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         21,"amdgpu_vega");
DEF_REGISTER(vgpr22,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         22,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_22,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         22,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_22,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         22,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_22,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         22,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_22,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         22,"amdgpu_vega");
DEF_REGISTER(vgpr23,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         23,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_23,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         23,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_23,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         23,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_23,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         23,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_23,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         23,"amdgpu_vega");
DEF_REGISTER(vgpr24,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         24,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_24,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         24,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_24,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         24,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_24,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         24,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_24,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         24,"amdgpu_vega");
DEF_REGISTER(vgpr25,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         25,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_25,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         25,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_25,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         25,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_25,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         25,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_25,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         25,"amdgpu_vega");
DEF_REGISTER(vgpr26,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         26,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_26,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         26,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_26,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         26,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_26,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         26,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_26,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         26,"amdgpu_vega");
DEF_REGISTER(vgpr27,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         27,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_27,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         27,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_27,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         27,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_27,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         27,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_27,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         27,"amdgpu_vega");
DEF_REGISTER(vgpr28,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         28,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_28,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         28,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_28,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         28,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_28,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         28,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_28,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         28,"amdgpu_vega");
DEF_REGISTER(vgpr29,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         29,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_29,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         29,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_29,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         29,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_29,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         29,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_29,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         29,"amdgpu_vega");
DEF_REGISTER(vgpr30,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         30,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_30,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         30,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_30,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         30,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_30,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         30,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_30,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         30,"amdgpu_vega");
DEF_REGISTER(vgpr31,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         31,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_31,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         31,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_31,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         31,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_31,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         31,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_31,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         31,"amdgpu_vega");
DEF_REGISTER(vgpr32,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         32,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_32,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         32,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_32,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         32,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_32,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         32,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_32,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         32,"amdgpu_vega");
DEF_REGISTER(vgpr33,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         33,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_33,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         33,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_33,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         33,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_33,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         33,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_33,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         33,"amdgpu_vega");
DEF_REGISTER(vgpr34,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         34,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_34,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         34,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_34,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         34,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_34,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         34,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_34,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         34,"amdgpu_vega");
DEF_REGISTER(vgpr35,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         35,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_35,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         35,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_35,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         35,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_35,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         35,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_35,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         35,"amdgpu_vega");
DEF_REGISTER(vgpr36,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         36,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_36,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         36,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_36,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         36,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_36,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         36,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_36,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         36,"amdgpu_vega");
DEF_REGISTER(vgpr37,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         37,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_37,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         37,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_37,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         37,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_37,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         37,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_37,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         37,"amdgpu_vega");
DEF_REGISTER(vgpr38,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         38,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_38,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         38,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_38,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         38,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_38,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         38,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_38,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         38,"amdgpu_vega");
DEF_REGISTER(vgpr39,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         39,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_39,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         39,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_39,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         39,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_39,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         39,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_39,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         39,"amdgpu_vega");
DEF_REGISTER(vgpr40,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         40,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_40,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         40,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_40,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         40,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_40,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         40,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_40,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         40,"amdgpu_vega");
DEF_REGISTER(vgpr41,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         41,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_41,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         41,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_41,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         41,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_41,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         41,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_41,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         41,"amdgpu_vega");
DEF_REGISTER(vgpr42,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         42,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_42,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         42,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_42,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         42,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_42,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         42,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_42,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         42,"amdgpu_vega");
DEF_REGISTER(vgpr43,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         43,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_43,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         43,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_43,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         43,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_43,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         43,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_43,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         43,"amdgpu_vega");
DEF_REGISTER(vgpr44,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         44,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_44,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         44,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_44,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         44,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_44,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         44,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_44,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         44,"amdgpu_vega");
DEF_REGISTER(vgpr45,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         45,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_45,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         45,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_45,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         45,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_45,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         45,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_45,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         45,"amdgpu_vega");
DEF_REGISTER(vgpr46,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         46,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_46,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         46,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_46,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         46,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_46,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         46,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_46,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         46,"amdgpu_vega");
DEF_REGISTER(vgpr47,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         47,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_47,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         47,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_47,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         47,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_47,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         47,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_47,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         47,"amdgpu_vega");
DEF_REGISTER(vgpr48,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         48,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_48,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         48,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_48,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         48,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_48,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         48,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_48,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         48,"amdgpu_vega");
DEF_REGISTER(vgpr49,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         49,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_49,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         49,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_49,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         49,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_49,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         49,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_49,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         49,"amdgpu_vega");
DEF_REGISTER(vgpr50,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         50,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_50,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         50,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_50,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         50,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_50,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         50,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_50,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         50,"amdgpu_vega");
DEF_REGISTER(vgpr51,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         51,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_51,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         51,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_51,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         51,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_51,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         51,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_51,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         51,"amdgpu_vega");
DEF_REGISTER(vgpr52,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         52,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_52,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         52,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_52,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         52,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_52,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         52,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_52,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         52,"amdgpu_vega");
DEF_REGISTER(vgpr53,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         53,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_53,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         53,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_53,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         53,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_53,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         53,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_53,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         53,"amdgpu_vega");
DEF_REGISTER(vgpr54,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         54,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_54,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         54,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_54,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         54,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_54,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         54,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_54,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         54,"amdgpu_vega");
DEF_REGISTER(vgpr55,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         55,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_55,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         55,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_55,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         55,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_55,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         55,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_55,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         55,"amdgpu_vega");
DEF_REGISTER(vgpr56,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         56,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_56,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         56,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_56,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         56,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_56,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         56,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_56,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         56,"amdgpu_vega");
DEF_REGISTER(vgpr57,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         57,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_57,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         57,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_57,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         57,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_57,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         57,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_57,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         57,"amdgpu_vega");
DEF_REGISTER(vgpr58,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         58,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_58,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         58,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_58,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         58,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_58,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         58,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_58,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         58,"amdgpu_vega");
DEF_REGISTER(vgpr59,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         59,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_59,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         59,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_59,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         59,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_59,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         59,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_59,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         59,"amdgpu_vega");
DEF_REGISTER(vgpr60,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         60,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_60,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         60,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_60,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         60,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_60,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         60,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_60,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         60,"amdgpu_vega");
DEF_REGISTER(vgpr61,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         61,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_61,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         61,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_61,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         61,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_61,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         61,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_61,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         61,"amdgpu_vega");
DEF_REGISTER(vgpr62,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         62,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_62,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         62,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_62,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         62,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_62,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         62,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_62,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         62,"amdgpu_vega");
DEF_REGISTER(vgpr63,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         63,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_63,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         63,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_63,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         63,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_63,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         63,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_63,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         63,"amdgpu_vega");
DEF_REGISTER(vgpr64,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         64,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_64,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         64,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_64,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         64,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_64,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         64,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_64,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         64,"amdgpu_vega");
DEF_REGISTER(vgpr65,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         65,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_65,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         65,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_65,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         65,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_65,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         65,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_65,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         65,"amdgpu_vega");
DEF_REGISTER(vgpr66,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         66,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_66,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         66,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_66,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         66,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_66,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         66,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_66,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         66,"amdgpu_vega");
DEF_REGISTER(vgpr67,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         67,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_67,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         67,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_67,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         67,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_67,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         67,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_67,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         67,"amdgpu_vega");
DEF_REGISTER(vgpr68,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         68,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_68,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         68,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_68,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         68,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_68,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         68,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_68,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         68,"amdgpu_vega");
DEF_REGISTER(vgpr69,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         69,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_69,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         69,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_69,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         69,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_69,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         69,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_69,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         69,"amdgpu_vega");
DEF_REGISTER(vgpr70,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         70,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_70,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         70,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_70,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         70,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_70,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         70,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_70,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         70,"amdgpu_vega");
DEF_REGISTER(vgpr71,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         71,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_71,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         71,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_71,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         71,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_71,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         71,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_71,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         71,"amdgpu_vega");
DEF_REGISTER(vgpr72,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         72,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_72,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         72,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_72,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         72,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_72,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         72,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_72,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         72,"amdgpu_vega");
DEF_REGISTER(vgpr73,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         73,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_73,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         73,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_73,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         73,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_73,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         73,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_73,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         73,"amdgpu_vega");
DEF_REGISTER(vgpr74,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         74,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_74,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         74,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_74,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         74,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_74,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         74,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_74,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         74,"amdgpu_vega");
DEF_REGISTER(vgpr75,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         75,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_75,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         75,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_75,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         75,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_75,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         75,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_75,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         75,"amdgpu_vega");
DEF_REGISTER(vgpr76,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         76,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_76,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         76,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_76,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         76,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_76,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         76,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_76,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         76,"amdgpu_vega");
DEF_REGISTER(vgpr77,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         77,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_77,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         77,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_77,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         77,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_77,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         77,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_77,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         77,"amdgpu_vega");
DEF_REGISTER(vgpr78,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         78,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_78,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         78,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_78,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         78,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_78,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         78,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_78,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         78,"amdgpu_vega");
DEF_REGISTER(vgpr79,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         79,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_79,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         79,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_79,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         79,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_79,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         79,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_79,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         79,"amdgpu_vega");
DEF_REGISTER(vgpr80,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         80,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_80,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         80,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_80,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         80,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_80,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         80,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_80,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         80,"amdgpu_vega");
DEF_REGISTER(vgpr81,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         81,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_81,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         81,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_81,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         81,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_81,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         81,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_81,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         81,"amdgpu_vega");
DEF_REGISTER(vgpr82,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         82,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_82,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         82,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_82,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         82,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_82,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         82,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_82,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         82,"amdgpu_vega");
DEF_REGISTER(vgpr83,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         83,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_83,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         83,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_83,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         83,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_83,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         83,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_83,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         83,"amdgpu_vega");
DEF_REGISTER(vgpr84,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         84,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_84,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         84,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_84,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         84,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_84,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         84,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_84,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         84,"amdgpu_vega");
DEF_REGISTER(vgpr85,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         85,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_85,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         85,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_85,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         85,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_85,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         85,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_85,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         85,"amdgpu_vega");
DEF_REGISTER(vgpr86,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         86,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_86,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         86,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_86,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         86,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_86,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         86,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_86,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         86,"amdgpu_vega");
DEF_REGISTER(vgpr87,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         87,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_87,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         87,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_87,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         87,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_87,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         87,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_87,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         87,"amdgpu_vega");
DEF_REGISTER(vgpr88,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         88,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_88,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         88,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_88,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         88,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_88,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         88,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_88,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         88,"amdgpu_vega");
DEF_REGISTER(vgpr89,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         89,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_89,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         89,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_89,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         89,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_89,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         89,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_89,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         89,"amdgpu_vega");
DEF_REGISTER(vgpr90,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         90,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_90,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         90,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_90,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         90,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_90,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         90,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_90,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         90,"amdgpu_vega");
DEF_REGISTER(vgpr91,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         91,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_91,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         91,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_91,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         91,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_91,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         91,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_91,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         91,"amdgpu_vega");
DEF_REGISTER(vgpr92,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         92,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_92,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         92,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_92,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         92,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_92,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         92,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_92,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         92,"amdgpu_vega");
DEF_REGISTER(vgpr93,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         93,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_93,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         93,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_93,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         93,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_93,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         93,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_93,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         93,"amdgpu_vega");
DEF_REGISTER(vgpr94,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         94,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_94,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         94,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_94,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         94,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_94,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         94,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_94,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         94,"amdgpu_vega");
DEF_REGISTER(vgpr95,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         95,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_95,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         95,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_95,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         95,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_95,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         95,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_95,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         95,"amdgpu_vega");
DEF_REGISTER(vgpr96,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         96,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_96,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         96,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_96,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         96,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_96,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         96,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_96,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         96,"amdgpu_vega");
DEF_REGISTER(vgpr97,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         97,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_97,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         97,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_97,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         97,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_97,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         97,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_97,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         97,"amdgpu_vega");
DEF_REGISTER(vgpr98,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         98,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_98,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         98,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_98,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         98,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_98,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         98,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_98,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         98,"amdgpu_vega");
DEF_REGISTER(vgpr99,                                   Arch_amdgpu_vega |       VGPR |              BITS_32 |         99,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_99,                             Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |         99,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_99,                             Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |         99,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_99,                             Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |         99,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_99,                            Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |         99,"amdgpu_vega");
DEF_REGISTER(vgpr100,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        100,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_100,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        100,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_100,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        100,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_100,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        100,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_100,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        100,"amdgpu_vega");
DEF_REGISTER(vgpr101,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        101,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_101,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        101,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_101,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        101,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_101,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        101,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_101,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        101,"amdgpu_vega");
DEF_REGISTER(vgpr102,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        102,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_102,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        102,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_102,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        102,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_102,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        102,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_102,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        102,"amdgpu_vega");
DEF_REGISTER(vgpr103,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        103,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_103,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        103,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_103,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        103,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_103,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        103,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_103,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        103,"amdgpu_vega");
DEF_REGISTER(vgpr104,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        104,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_104,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        104,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_104,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        104,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_104,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        104,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_104,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        104,"amdgpu_vega");
DEF_REGISTER(vgpr105,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        105,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_105,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        105,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_105,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        105,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_105,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        105,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_105,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        105,"amdgpu_vega");
DEF_REGISTER(vgpr106,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        106,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_106,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        106,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_106,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        106,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_106,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        106,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_106,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        106,"amdgpu_vega");
DEF_REGISTER(vgpr107,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        107,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_107,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        107,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_107,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        107,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_107,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        107,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_107,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        107,"amdgpu_vega");
DEF_REGISTER(vgpr108,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        108,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_108,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        108,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_108,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        108,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_108,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        108,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_108,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        108,"amdgpu_vega");
DEF_REGISTER(vgpr109,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        109,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_109,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        109,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_109,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        109,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_109,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        109,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_109,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        109,"amdgpu_vega");
DEF_REGISTER(vgpr110,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        110,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_110,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        110,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_110,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        110,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_110,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        110,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_110,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        110,"amdgpu_vega");
DEF_REGISTER(vgpr111,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        111,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_111,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        111,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_111,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        111,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_111,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        111,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_111,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        111,"amdgpu_vega");
DEF_REGISTER(vgpr112,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        112,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_112,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        112,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_112,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        112,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_112,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        112,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_112,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        112,"amdgpu_vega");
DEF_REGISTER(vgpr113,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        113,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_113,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        113,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_113,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        113,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_113,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        113,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_113,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        113,"amdgpu_vega");
DEF_REGISTER(vgpr114,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        114,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_114,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        114,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_114,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        114,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_114,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        114,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_114,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        114,"amdgpu_vega");
DEF_REGISTER(vgpr115,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        115,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_115,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        115,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_115,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        115,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_115,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        115,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_115,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        115,"amdgpu_vega");
DEF_REGISTER(vgpr116,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        116,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_116,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        116,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_116,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        116,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_116,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        116,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_116,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        116,"amdgpu_vega");
DEF_REGISTER(vgpr117,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        117,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_117,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        117,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_117,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        117,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_117,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        117,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_117,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        117,"amdgpu_vega");
DEF_REGISTER(vgpr118,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        118,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_118,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        118,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_118,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        118,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_118,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        118,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_118,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        118,"amdgpu_vega");
DEF_REGISTER(vgpr119,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        119,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_119,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        119,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_119,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        119,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_119,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        119,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_119,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        119,"amdgpu_vega");
DEF_REGISTER(vgpr120,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        120,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_120,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        120,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_120,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        120,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_120,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        120,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_120,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        120,"amdgpu_vega");
DEF_REGISTER(vgpr121,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        121,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_121,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        121,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_121,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        121,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_121,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        121,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_121,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        121,"amdgpu_vega");
DEF_REGISTER(vgpr122,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        122,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_122,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        122,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_122,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        122,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_122,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        122,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_122,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        122,"amdgpu_vega");
DEF_REGISTER(vgpr123,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        123,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_123,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        123,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_123,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        123,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_123,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        123,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_123,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        123,"amdgpu_vega");
DEF_REGISTER(vgpr124,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        124,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_124,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        124,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_124,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        124,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_124,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        124,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_124,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        124,"amdgpu_vega");
DEF_REGISTER(vgpr125,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        125,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_125,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        125,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_125,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        125,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_125,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        125,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_125,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        125,"amdgpu_vega");
DEF_REGISTER(vgpr126,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        126,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_126,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        126,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_126,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        126,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_126,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        126,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_126,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        126,"amdgpu_vega");
DEF_REGISTER(vgpr127,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        127,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_127,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        127,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_127,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        127,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_127,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        127,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_127,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        127,"amdgpu_vega");
DEF_REGISTER(vgpr128,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        128,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_128,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        128,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_128,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        128,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_128,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        128,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_128,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        128,"amdgpu_vega");
DEF_REGISTER(vgpr129,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        129,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_129,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        129,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_129,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        129,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_129,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        129,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_129,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        129,"amdgpu_vega");
DEF_REGISTER(vgpr130,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        130,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_130,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        130,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_130,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        130,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_130,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        130,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_130,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        130,"amdgpu_vega");
DEF_REGISTER(vgpr131,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        131,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_131,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        131,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_131,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        131,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_131,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        131,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_131,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        131,"amdgpu_vega");
DEF_REGISTER(vgpr132,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        132,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_132,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        132,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_132,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        132,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_132,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        132,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_132,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        132,"amdgpu_vega");
DEF_REGISTER(vgpr133,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        133,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_133,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        133,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_133,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        133,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_133,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        133,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_133,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        133,"amdgpu_vega");
DEF_REGISTER(vgpr134,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        134,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_134,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        134,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_134,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        134,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_134,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        134,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_134,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        134,"amdgpu_vega");
DEF_REGISTER(vgpr135,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        135,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_135,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        135,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_135,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        135,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_135,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        135,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_135,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        135,"amdgpu_vega");
DEF_REGISTER(vgpr136,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        136,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_136,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        136,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_136,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        136,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_136,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        136,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_136,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        136,"amdgpu_vega");
DEF_REGISTER(vgpr137,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        137,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_137,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        137,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_137,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        137,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_137,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        137,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_137,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        137,"amdgpu_vega");
DEF_REGISTER(vgpr138,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        138,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_138,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        138,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_138,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        138,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_138,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        138,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_138,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        138,"amdgpu_vega");
DEF_REGISTER(vgpr139,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        139,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_139,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        139,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_139,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        139,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_139,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        139,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_139,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        139,"amdgpu_vega");
DEF_REGISTER(vgpr140,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        140,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_140,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        140,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_140,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        140,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_140,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        140,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_140,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        140,"amdgpu_vega");
DEF_REGISTER(vgpr141,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        141,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_141,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        141,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_141,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        141,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_141,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        141,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_141,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        141,"amdgpu_vega");
DEF_REGISTER(vgpr142,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        142,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_142,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        142,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_142,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        142,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_142,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        142,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_142,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        142,"amdgpu_vega");
DEF_REGISTER(vgpr143,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        143,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_143,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        143,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_143,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        143,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_143,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        143,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_143,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        143,"amdgpu_vega");
DEF_REGISTER(vgpr144,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        144,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_144,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        144,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_144,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        144,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_144,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        144,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_144,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        144,"amdgpu_vega");
DEF_REGISTER(vgpr145,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        145,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_145,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        145,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_145,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        145,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_145,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        145,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_145,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        145,"amdgpu_vega");
DEF_REGISTER(vgpr146,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        146,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_146,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        146,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_146,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        146,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_146,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        146,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_146,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        146,"amdgpu_vega");
DEF_REGISTER(vgpr147,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        147,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_147,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        147,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_147,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        147,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_147,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        147,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_147,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        147,"amdgpu_vega");
DEF_REGISTER(vgpr148,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        148,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_148,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        148,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_148,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        148,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_148,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        148,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_148,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        148,"amdgpu_vega");
DEF_REGISTER(vgpr149,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        149,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_149,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        149,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_149,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        149,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_149,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        149,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_149,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        149,"amdgpu_vega");
DEF_REGISTER(vgpr150,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        150,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_150,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        150,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_150,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        150,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_150,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        150,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_150,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        150,"amdgpu_vega");
DEF_REGISTER(vgpr151,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        151,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_151,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        151,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_151,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        151,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_151,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        151,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_151,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        151,"amdgpu_vega");
DEF_REGISTER(vgpr152,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        152,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_152,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        152,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_152,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        152,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_152,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        152,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_152,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        152,"amdgpu_vega");
DEF_REGISTER(vgpr153,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        153,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_153,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        153,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_153,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        153,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_153,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        153,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_153,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        153,"amdgpu_vega");
DEF_REGISTER(vgpr154,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        154,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_154,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        154,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_154,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        154,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_154,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        154,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_154,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        154,"amdgpu_vega");
DEF_REGISTER(vgpr155,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        155,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_155,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        155,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_155,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        155,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_155,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        155,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_155,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        155,"amdgpu_vega");
DEF_REGISTER(vgpr156,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        156,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_156,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        156,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_156,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        156,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_156,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        156,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_156,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        156,"amdgpu_vega");
DEF_REGISTER(vgpr157,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        157,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_157,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        157,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_157,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        157,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_157,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        157,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_157,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        157,"amdgpu_vega");
DEF_REGISTER(vgpr158,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        158,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_158,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        158,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_158,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        158,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_158,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        158,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_158,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        158,"amdgpu_vega");
DEF_REGISTER(vgpr159,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        159,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_159,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        159,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_159,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        159,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_159,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        159,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_159,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        159,"amdgpu_vega");
DEF_REGISTER(vgpr160,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        160,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_160,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        160,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_160,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        160,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_160,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        160,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_160,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        160,"amdgpu_vega");
DEF_REGISTER(vgpr161,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        161,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_161,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        161,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_161,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        161,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_161,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        161,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_161,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        161,"amdgpu_vega");
DEF_REGISTER(vgpr162,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        162,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_162,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        162,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_162,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        162,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_162,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        162,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_162,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        162,"amdgpu_vega");
DEF_REGISTER(vgpr163,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        163,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_163,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        163,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_163,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        163,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_163,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        163,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_163,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        163,"amdgpu_vega");
DEF_REGISTER(vgpr164,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        164,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_164,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        164,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_164,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        164,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_164,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        164,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_164,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        164,"amdgpu_vega");
DEF_REGISTER(vgpr165,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        165,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_165,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        165,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_165,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        165,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_165,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        165,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_165,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        165,"amdgpu_vega");
DEF_REGISTER(vgpr166,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        166,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_166,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        166,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_166,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        166,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_166,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        166,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_166,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        166,"amdgpu_vega");
DEF_REGISTER(vgpr167,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        167,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_167,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        167,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_167,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        167,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_167,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        167,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_167,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        167,"amdgpu_vega");
DEF_REGISTER(vgpr168,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        168,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_168,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        168,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_168,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        168,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_168,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        168,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_168,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        168,"amdgpu_vega");
DEF_REGISTER(vgpr169,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        169,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_169,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        169,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_169,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        169,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_169,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        169,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_169,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        169,"amdgpu_vega");
DEF_REGISTER(vgpr170,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        170,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_170,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        170,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_170,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        170,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_170,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        170,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_170,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        170,"amdgpu_vega");
DEF_REGISTER(vgpr171,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        171,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_171,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        171,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_171,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        171,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_171,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        171,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_171,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        171,"amdgpu_vega");
DEF_REGISTER(vgpr172,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        172,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_172,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        172,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_172,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        172,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_172,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        172,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_172,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        172,"amdgpu_vega");
DEF_REGISTER(vgpr173,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        173,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_173,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        173,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_173,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        173,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_173,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        173,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_173,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        173,"amdgpu_vega");
DEF_REGISTER(vgpr174,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        174,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_174,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        174,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_174,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        174,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_174,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        174,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_174,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        174,"amdgpu_vega");
DEF_REGISTER(vgpr175,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        175,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_175,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        175,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_175,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        175,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_175,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        175,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_175,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        175,"amdgpu_vega");
DEF_REGISTER(vgpr176,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        176,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_176,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        176,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_176,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        176,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_176,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        176,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_176,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        176,"amdgpu_vega");
DEF_REGISTER(vgpr177,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        177,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_177,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        177,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_177,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        177,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_177,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        177,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_177,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        177,"amdgpu_vega");
DEF_REGISTER(vgpr178,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        178,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_178,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        178,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_178,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        178,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_178,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        178,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_178,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        178,"amdgpu_vega");
DEF_REGISTER(vgpr179,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        179,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_179,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        179,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_179,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        179,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_179,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        179,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_179,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        179,"amdgpu_vega");
DEF_REGISTER(vgpr180,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        180,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_180,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        180,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_180,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        180,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_180,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        180,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_180,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        180,"amdgpu_vega");
DEF_REGISTER(vgpr181,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        181,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_181,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        181,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_181,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        181,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_181,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        181,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_181,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        181,"amdgpu_vega");
DEF_REGISTER(vgpr182,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        182,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_182,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        182,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_182,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        182,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_182,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        182,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_182,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        182,"amdgpu_vega");
DEF_REGISTER(vgpr183,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        183,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_183,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        183,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_183,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        183,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_183,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        183,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_183,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        183,"amdgpu_vega");
DEF_REGISTER(vgpr184,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        184,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_184,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        184,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_184,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        184,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_184,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        184,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_184,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        184,"amdgpu_vega");
DEF_REGISTER(vgpr185,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        185,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_185,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        185,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_185,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        185,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_185,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        185,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_185,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        185,"amdgpu_vega");
DEF_REGISTER(vgpr186,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        186,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_186,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        186,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_186,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        186,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_186,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        186,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_186,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        186,"amdgpu_vega");
DEF_REGISTER(vgpr187,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        187,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_187,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        187,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_187,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        187,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_187,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        187,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_187,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        187,"amdgpu_vega");
DEF_REGISTER(vgpr188,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        188,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_188,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        188,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_188,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        188,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_188,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        188,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_188,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        188,"amdgpu_vega");
DEF_REGISTER(vgpr189,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        189,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_189,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        189,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_189,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        189,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_189,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        189,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_189,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        189,"amdgpu_vega");
DEF_REGISTER(vgpr190,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        190,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_190,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        190,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_190,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        190,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_190,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        190,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_190,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        190,"amdgpu_vega");
DEF_REGISTER(vgpr191,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        191,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_191,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        191,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_191,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        191,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_191,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        191,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_191,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        191,"amdgpu_vega");
DEF_REGISTER(vgpr192,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        192,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_192,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        192,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_192,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        192,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_192,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        192,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_192,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        192,"amdgpu_vega");
DEF_REGISTER(vgpr193,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        193,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_193,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        193,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_193,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        193,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_193,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        193,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_193,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        193,"amdgpu_vega");
DEF_REGISTER(vgpr194,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        194,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_194,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        194,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_194,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        194,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_194,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        194,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_194,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        194,"amdgpu_vega");
DEF_REGISTER(vgpr195,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        195,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_195,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        195,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_195,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        195,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_195,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        195,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_195,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        195,"amdgpu_vega");
DEF_REGISTER(vgpr196,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        196,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_196,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        196,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_196,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        196,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_196,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        196,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_196,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        196,"amdgpu_vega");
DEF_REGISTER(vgpr197,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        197,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_197,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        197,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_197,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        197,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_197,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        197,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_197,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        197,"amdgpu_vega");
DEF_REGISTER(vgpr198,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        198,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_198,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        198,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_198,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        198,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_198,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        198,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_198,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        198,"amdgpu_vega");
DEF_REGISTER(vgpr199,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        199,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_199,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        199,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_199,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        199,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_199,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        199,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_199,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        199,"amdgpu_vega");
DEF_REGISTER(vgpr200,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        200,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_200,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        200,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_200,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        200,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_200,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        200,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_200,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        200,"amdgpu_vega");
DEF_REGISTER(vgpr201,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        201,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_201,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        201,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_201,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        201,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_201,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        201,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_201,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        201,"amdgpu_vega");
DEF_REGISTER(vgpr202,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        202,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_202,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        202,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_202,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        202,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_202,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        202,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_202,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        202,"amdgpu_vega");
DEF_REGISTER(vgpr203,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        203,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_203,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        203,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_203,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        203,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_203,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        203,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_203,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        203,"amdgpu_vega");
DEF_REGISTER(vgpr204,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        204,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_204,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        204,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_204,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        204,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_204,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        204,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_204,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        204,"amdgpu_vega");
DEF_REGISTER(vgpr205,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        205,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_205,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        205,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_205,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        205,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_205,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        205,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_205,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        205,"amdgpu_vega");
DEF_REGISTER(vgpr206,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        206,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_206,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        206,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_206,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        206,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_206,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        206,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_206,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        206,"amdgpu_vega");
DEF_REGISTER(vgpr207,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        207,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_207,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        207,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_207,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        207,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_207,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        207,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_207,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        207,"amdgpu_vega");
DEF_REGISTER(vgpr208,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        208,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_208,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        208,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_208,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        208,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_208,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        208,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_208,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        208,"amdgpu_vega");
DEF_REGISTER(vgpr209,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        209,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_209,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        209,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_209,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        209,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_209,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        209,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_209,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        209,"amdgpu_vega");
DEF_REGISTER(vgpr210,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        210,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_210,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        210,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_210,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        210,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_210,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        210,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_210,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        210,"amdgpu_vega");
DEF_REGISTER(vgpr211,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        211,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_211,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        211,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_211,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        211,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_211,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        211,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_211,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        211,"amdgpu_vega");
DEF_REGISTER(vgpr212,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        212,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_212,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        212,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_212,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        212,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_212,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        212,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_212,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        212,"amdgpu_vega");
DEF_REGISTER(vgpr213,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        213,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_213,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        213,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_213,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        213,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_213,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        213,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_213,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        213,"amdgpu_vega");
DEF_REGISTER(vgpr214,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        214,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_214,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        214,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_214,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        214,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_214,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        214,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_214,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        214,"amdgpu_vega");
DEF_REGISTER(vgpr215,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        215,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_215,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        215,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_215,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        215,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_215,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        215,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_215,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        215,"amdgpu_vega");
DEF_REGISTER(vgpr216,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        216,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_216,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        216,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_216,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        216,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_216,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        216,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_216,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        216,"amdgpu_vega");
DEF_REGISTER(vgpr217,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        217,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_217,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        217,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_217,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        217,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_217,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        217,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_217,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        217,"amdgpu_vega");
DEF_REGISTER(vgpr218,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        218,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_218,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        218,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_218,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        218,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_218,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        218,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_218,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        218,"amdgpu_vega");
DEF_REGISTER(vgpr219,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        219,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_219,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        219,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_219,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        219,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_219,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        219,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_219,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        219,"amdgpu_vega");
DEF_REGISTER(vgpr220,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        220,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_220,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        220,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_220,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        220,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_220,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        220,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_220,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        220,"amdgpu_vega");
DEF_REGISTER(vgpr221,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        221,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_221,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        221,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_221,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        221,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_221,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        221,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_221,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        221,"amdgpu_vega");
DEF_REGISTER(vgpr222,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        222,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_222,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        222,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_222,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        222,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_222,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        222,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_222,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        222,"amdgpu_vega");
DEF_REGISTER(vgpr223,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        223,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_223,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        223,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_223,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        223,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_223,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        223,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_223,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        223,"amdgpu_vega");
DEF_REGISTER(vgpr224,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        224,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_224,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        224,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_224,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        224,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_224,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        224,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_224,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        224,"amdgpu_vega");
DEF_REGISTER(vgpr225,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        225,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_225,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        225,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_225,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        225,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_225,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        225,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_225,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        225,"amdgpu_vega");
DEF_REGISTER(vgpr226,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        226,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_226,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        226,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_226,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        226,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_226,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        226,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_226,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        226,"amdgpu_vega");
DEF_REGISTER(vgpr227,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        227,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_227,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        227,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_227,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        227,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_227,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        227,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_227,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        227,"amdgpu_vega");
DEF_REGISTER(vgpr228,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        228,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_228,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        228,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_228,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        228,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_228,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        228,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_228,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        228,"amdgpu_vega");
DEF_REGISTER(vgpr229,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        229,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_229,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        229,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_229,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        229,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_229,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        229,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_229,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        229,"amdgpu_vega");
DEF_REGISTER(vgpr230,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        230,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_230,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        230,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_230,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        230,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_230,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        230,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_230,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        230,"amdgpu_vega");
DEF_REGISTER(vgpr231,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        231,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_231,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        231,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_231,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        231,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_231,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        231,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_231,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        231,"amdgpu_vega");
DEF_REGISTER(vgpr232,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        232,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_232,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        232,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_232,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        232,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_232,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        232,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_232,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        232,"amdgpu_vega");
DEF_REGISTER(vgpr233,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        233,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_233,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        233,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_233,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        233,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_233,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        233,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_233,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        233,"amdgpu_vega");
DEF_REGISTER(vgpr234,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        234,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_234,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        234,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_234,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        234,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_234,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        234,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_234,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        234,"amdgpu_vega");
DEF_REGISTER(vgpr235,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        235,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_235,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        235,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_235,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        235,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_235,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        235,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_235,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        235,"amdgpu_vega");
DEF_REGISTER(vgpr236,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        236,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_236,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        236,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_236,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        236,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_236,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        236,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_236,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        236,"amdgpu_vega");
DEF_REGISTER(vgpr237,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        237,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_237,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        237,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_237,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        237,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_237,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        237,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_237,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        237,"amdgpu_vega");
DEF_REGISTER(vgpr238,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        238,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_238,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        238,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_238,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        238,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_238,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        238,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_238,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        238,"amdgpu_vega");
DEF_REGISTER(vgpr239,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        239,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_239,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        239,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_239,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        239,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_239,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        239,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_239,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        239,"amdgpu_vega");
DEF_REGISTER(vgpr240,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        240,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_240,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        240,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_240,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        240,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_240,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        240,"amdgpu_vega");
DEF_REGISTER(vgpr_vec16_240,                           Arch_amdgpu_vega | VGPR_VEC16 |             BITS_512 |        240,"amdgpu_vega");
DEF_REGISTER(vgpr241,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        241,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_241,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        241,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_241,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        241,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_241,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        241,"amdgpu_vega");
DEF_REGISTER(vgpr242,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        242,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_242,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        242,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_242,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        242,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_242,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        242,"amdgpu_vega");
DEF_REGISTER(vgpr243,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        243,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_243,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        243,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_243,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        243,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_243,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        243,"amdgpu_vega");
DEF_REGISTER(vgpr244,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        244,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_244,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        244,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_244,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        244,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_244,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        244,"amdgpu_vega");
DEF_REGISTER(vgpr245,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        245,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_245,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        245,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_245,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        245,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_245,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        245,"amdgpu_vega");
DEF_REGISTER(vgpr246,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        246,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_246,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        246,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_246,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        246,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_246,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        246,"amdgpu_vega");
DEF_REGISTER(vgpr247,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        247,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_247,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        247,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_247,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        247,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_247,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        247,"amdgpu_vega");
DEF_REGISTER(vgpr248,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        248,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_248,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        248,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_248,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        248,"amdgpu_vega");
DEF_REGISTER(vgpr_vec8_248,                            Arch_amdgpu_vega |  VGPR_VEC8 |             BITS_256 |        248,"amdgpu_vega");
DEF_REGISTER(vgpr249,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        249,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_249,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        249,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_249,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        249,"amdgpu_vega");
DEF_REGISTER(vgpr250,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        250,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_250,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        250,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_250,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        250,"amdgpu_vega");
DEF_REGISTER(vgpr251,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        251,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_251,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        251,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_251,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        251,"amdgpu_vega");
DEF_REGISTER(vgpr252,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        252,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_252,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        252,"amdgpu_vega");
DEF_REGISTER(vgpr_vec4_252,                            Arch_amdgpu_vega |  VGPR_VEC4 |             BITS_128 |        252,"amdgpu_vega");
DEF_REGISTER(vgpr253,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        253,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_253,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        253,"amdgpu_vega");
DEF_REGISTER(vgpr254,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        254,"amdgpu_vega");
DEF_REGISTER(vgpr_vec2_254,                            Arch_amdgpu_vega |  VGPR_VEC2 |              BITS_64 |        254,"amdgpu_vega");
DEF_REGISTER(vgpr255,                                  Arch_amdgpu_vega |       VGPR |              BITS_32 |        255,"amdgpu_vega");
#endif //DYNINST_AMDGPU_VEGA_SYS_REGS_H
