//  BEGIN COPYRIGHT BLOCK
//  This Program is free software; you can redistribute it and/or modify it under
//  the terms of the GNU General Public License as published by the Free Software
//  Foundation; version 2 of the License.
//
//  This Program is distributed in the hope that it will be useful, but WITHOUT
//  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
//  FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with
//  this Program; if not, write to the Free Software Foundation, Inc., 59 Temple
//  Place, Suite 330, Boston, MA 02111-1307 USA.
//
//  Copyright (C) 2005 Red Hat, Inc.
//  All rights reserved.
//  END COPYRIGHT BLOCK

#ifndef __COOLKEY_MGR_H__
#define __COOLKEY_MGR_H__

#include <glib-object.h>
#include "coolkey-token.h"

typedef struct _CoolkeyMgrPrivate CoolkeyMgrPrivate;


// Declare CoolkeyMgr as a final (non-derivable) class inherited from GObject
#define COOLKEY_TYPE_MGR coolkey_mgr_get_type ()
G_DECLARE_FINAL_TYPE (CoolkeyMgr, coolkey_mgr, COOLKEY, MGR, GObject)

// constructor
CoolkeyMgr * coolkey_mgr_new (void);

/*
 * CoolkeyMgr method declarations.
 */

void  coolkey_mgr_get_token_info(CoolkeyMgr* self, CoolkeyToken* token);

gchar * coolkey_mgr_speak (CoolkeyMgr* self, gchar *words);
void coolkey_mgr_cleanup(CoolkeyMgr *self);

#endif /* __COOLKEY_MGR_H__ */
