/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.SecretDecoderRing;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.SecretDecoderRing.Encoding;
import org.mozilla.jss.SecretDecoderRing.KeyManager;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.TokenException;

public class Encryptor {
    private CryptoToken token;
    private byte[] keyID;
    private SecretKey key;
    private EncryptionAlgorithm alg;
    private KeyManager keyManager;
    public static final EncryptionAlgorithm DEFAULT_ENCRYPTION_ALG = EncryptionAlgorithm.DES3_CBC;
    static final String PROVIDER = "Mozilla-JSS";
    static final String RNG_ALG = "pkcs11prng";

    public Encryptor(CryptoToken token, byte[] keyID, EncryptionAlgorithm alg) throws TokenException, InvalidKeyException {
        this.token = token;
        this.keyID = keyID;
        this.alg = alg;
        this.keyManager = new KeyManager(token);
        this.key = this.keyManager.lookupKey(alg, keyID);
        if (this.key == null) {
            throw new InvalidKeyException("Key not found");
        }
    }

    public byte[] encrypt(byte[] plaintext) throws NotInitializedException, GeneralSecurityException, InvalidBERException {
        CryptoManager cm = CryptoManager.getInstance();
        CryptoToken savedToken = cm.getThreadToken();
        try {
            cm.setThreadToken(this.token);
            byte[] iv = new byte[this.alg.getIVLength()];
            SecureRandom rng = SecureRandom.getInstance(RNG_ALG, PROVIDER);
            rng.nextBytes(iv);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance(this.alg.toString(), PROVIDER);
            cipher.init(1, (Key)this.key, ivSpec);
            byte[] paddedPtext = Cipher.pad(plaintext, this.alg.getBlockSize());
            byte[] rawCtext = cipher.doFinal(paddedPtext);
            Encoding encoding = new Encoding(this.keyID, iv, this.alg.toOID(), rawCtext);
            byte[] byArray = ASN1Util.encode(encoding);
            return byArray;
        }
        catch (IllegalStateException ise) {
            throw new GeneralSecurityException(ise.toString());
        }
        finally {
            cm.setThreadToken(savedToken);
        }
    }
}

