/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.crypto.SecretKey;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.pkcs11.KeyType;

public interface SymmetricKey
extends SecretKey {
    public static final Type GENERIC_SECRET = Type.GENERIC_SECRET;
    public static final Type DES = Type.DES;
    public static final Type DES3 = Type.DES3;
    public static final Type RC4 = Type.RC4;
    public static final Type RC2 = Type.RC2;
    @Deprecated(since="5.0.1", forRemoval=true)
    public static final Type SHA1_HMAC = Type.SHA1_HMAC;
    public static final Type SHA256_HMAC = Type.SHA256_HMAC;
    public static final Type SHA384_HMAC = Type.SHA384_HMAC;
    public static final Type SHA512_HMAC = Type.SHA512_HMAC;
    public static final Type AES = Type.AES;

    public Type getType();

    public CryptoToken getOwningToken();

    public int getStrength();

    public int getLength();

    public byte[] getKeyData() throws NotExtractableException;

    @Override
    public String getAlgorithm();

    @Override
    public byte[] getEncoded();

    @Override
    public String getFormat();

    public String getNickName();

    public void setNickName(String var1);

    public static final class Type {
        private static Hashtable<String, Type> nameMap = new Hashtable();
        private static ArrayList<Type> allTypes = new ArrayList();
        private String[] names;
        private KeyGenAlgorithm keyGenAlg;
        private KeyType keyType;
        public static final Type GENERIC_SECRET = new Type(new String[]{"GenericSecret", "GENERIC_SECRET"}, KeyGenAlgorithm.GENERIC_SECRET, KeyType.GENERIC_SECRET);
        public static final Type DES = new Type(new String[]{"DES"}, KeyGenAlgorithm.DES, KeyType.DES);
        public static final Type DES3;
        public static final Type DESede;
        public static final Type RC4;
        public static final Type RC2;
        @Deprecated(since="5.0.1", forRemoval=true)
        public static final Type SHA1_HMAC;
        public static final Type SHA256_HMAC;
        public static final Type SHA384_HMAC;
        public static final Type SHA512_HMAC;
        @Deprecated(since="5.0.1", forRemoval=true)
        public static final Type PBA_SHA1_HMAC;
        public static final Type AES;

        private Type() {
        }

        private Type(String[] names, KeyGenAlgorithm keyGenAlg, KeyType keyType) {
            this.names = names;
            this.keyGenAlg = keyGenAlg;
            this.keyType = keyType;
            for (String name : names) {
                nameMap.put(name.toLowerCase(), this);
            }
            allTypes.add(this);
        }

        public String toString() {
            return this.names[0];
        }

        public String[] getAliases() {
            return this.names;
        }

        public KeyGenAlgorithm getKeyGenAlg() throws NoSuchAlgorithmException {
            if (this.keyGenAlg == null) {
                throw new NoSuchAlgorithmException(this.names[0]);
            }
            return this.keyGenAlg;
        }

        public KeyType getKeyType() {
            return this.keyType;
        }

        public static Type fromName(String name) throws NoSuchAlgorithmException {
            Type type = nameMap.get(name.toLowerCase());
            if (type == null) {
                throw new NoSuchAlgorithmException();
            }
            return type;
        }

        public static Type fromKeyType(KeyType type) {
            for (Type current : allTypes) {
                if (current.getKeyType() != type) continue;
                return current;
            }
            return null;
        }

        static {
            DESede = DES3 = new Type(new String[]{"DESede", "TDES", "3DES", "DES3"}, KeyGenAlgorithm.DES3, KeyType.DES3);
            RC4 = new Type(new String[]{"RC4"}, KeyGenAlgorithm.RC4, KeyType.RC4);
            RC2 = new Type(new String[]{"RC2"}, KeyGenAlgorithm.RC2, KeyType.RC4);
            SHA1_HMAC = new Type(new String[]{"SHA1_HMAC", "SHA1-HMAC", "SHA1HMAC", "HMAC_SHA1", "HMAC-SHA1", "HMACSHA1"}, KeyGenAlgorithm.SHA1_HMAC, KeyType.SHA1_HMAC);
            SHA256_HMAC = new Type(new String[]{"SHA256_HMAC", "SHA256-HMAC", "SHA256HMAC", "HMAC_SHA256", "HMAC-SHA256", "HMACSHA256"}, KeyGenAlgorithm.SHA256_HMAC, KeyType.SHA256_HMAC);
            SHA384_HMAC = new Type(new String[]{"SHA384_HMAC", "SHA384-HMAC", "SHA384HMAC", "HMAC_SHA384", "HMAC-SHA384", "HMACSHA384"}, KeyGenAlgorithm.SHA384_HMAC, KeyType.SHA384_HMAC);
            SHA512_HMAC = new Type(new String[]{"SHA512_HMAC", "SHA512-HMAC", "SHA512HMAC", "HMAC_SHA512", "HMAC-SHA512", "HMACSHA512"}, KeyGenAlgorithm.SHA512_HMAC, KeyType.SHA512_HMAC);
            PBA_SHA1_HMAC = new Type(new String[]{"PBA_SHA1_HMAC"}, KeyGenAlgorithm.PBA_SHA1_HMAC, null);
            AES = new Type(new String[]{"AES"}, KeyGenAlgorithm.AES, KeyType.AES);
        }
    }

    public static enum Usage {
        ENCRYPT(256L, 260L),
        DECRYPT(512L, 261L),
        WRAP(131072L, 262L),
        UNWRAP(262144L, 263L),
        SIGN(2048L, 264L),
        VERIFY(8192L, 266L);

        private final long value;
        private final long cka_value;

        private Usage(long value, long cka_value) {
            this.value = value;
            this.cka_value = cka_value;
        }

        @Deprecated
        public int getVal() {
            return this.ordinal();
        }

        public long value() {
            return this.value;
        }

        @Deprecated
        public long getPKCS11Constant() {
            return this.cka_value;
        }
    }

    public static class NotExtractableException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NotExtractableException() {
        }

        public NotExtractableException(String mesg) {
            super(mesg);
        }
    }
}

