/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.extensions;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;

public class PresenceServerExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = -6333109673043357921L;
    private boolean mCritical;
    private int mVersion = 0;
    private String mStreetAddress = null;
    private String mTelephoneNumber = null;
    private String mRFC822Name = null;
    private String mID = null;
    private String mHostName = null;
    private int mPortNumber = 0;
    private int mMaxUsers = 0;
    private int mServiceLevel = 0;
    public static final String OID = "2.16.840.1.113730.1.18";

    public PresenceServerExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = new ObjectIdentifier(OID);
        this.critical = critical;
        this.extensionValue = (byte[])((byte[])value).clone();
        this.decodeThis();
    }

    public PresenceServerExtension(boolean critical, int version, String streetAddress, String telephoneNumber, String rfc822Name, String ID, String hostName, int portNumber, int maxUsers, int serviceLevel) throws IOException {
        this.mCritical = critical;
        this.mVersion = version;
        this.mStreetAddress = streetAddress;
        this.mTelephoneNumber = telephoneNumber;
        this.mRFC822Name = rfc822Name;
        this.mID = ID;
        this.mHostName = hostName;
        this.mPortNumber = portNumber;
        this.mMaxUsers = maxUsers;
        this.mServiceLevel = serviceLevel;
        this.extensionId = new ObjectIdentifier(OID);
        this.critical = this.mCritical;
        this.encodeThis();
    }

    public int getVersion() {
        return this.mVersion;
    }

    public String getStreetAddress() {
        return this.mStreetAddress;
    }

    public String getTelephoneNumber() {
        return this.mTelephoneNumber;
    }

    public String getRFC822() {
        return this.mRFC822Name;
    }

    public String getID() {
        return this.mID;
    }

    public String getHostName() {
        return this.mHostName;
    }

    public int getPortNumber() {
        return this.mPortNumber;
    }

    public int getMaxUsers() {
        return this.mMaxUsers;
    }

    public int getServiceLevel() {
        return this.mServiceLevel;
    }

    public void encodeThis() throws IOException {
        try (DerOutputStream out = new DerOutputStream();){
            DerOutputStream temp = new DerOutputStream();
            temp.putInteger(new BigInt(this.mVersion));
            temp.putOctetString(this.mStreetAddress.getBytes());
            temp.putOctetString(this.mTelephoneNumber.getBytes());
            temp.putOctetString(this.mRFC822Name.getBytes());
            temp.putOctetString(this.mID.getBytes());
            temp.putOctetString(this.mHostName.getBytes());
            temp.putInteger(new BigInt(this.mPortNumber));
            temp.putInteger(new BigInt(this.mMaxUsers));
            temp.putInteger(new BigInt(this.mServiceLevel));
            out.write((byte)48, temp);
            this.extensionValue = out.toByteArray();
        }
    }

    public void decodeThis() throws IOException {
        DerInputStream val = new DerInputStream(this.extensionValue);
        byte[] data = null;
        DerValue[] seq = val.getSequence(0);
        this.mVersion = seq[0].getInteger().toInt();
        data = null;
        if (seq[1].length() > 0) {
            data = seq[1].getOctetString();
        }
        this.mStreetAddress = data == null ? "" : new String(data);
        data = null;
        if (seq[2].length() > 0) {
            data = seq[2].getOctetString();
        }
        this.mTelephoneNumber = data == null ? "" : new String(data);
        data = null;
        if (seq[3].length() > 0) {
            data = seq[3].getOctetString();
        }
        this.mRFC822Name = data == null ? "" : new String(data);
        data = null;
        if (seq[4].length() > 0) {
            data = seq[4].getOctetString();
        }
        this.mID = data == null ? "" : new String(data);
        data = null;
        if (seq[5].length() > 0) {
            data = seq[5].getOctetString();
        }
        this.mHostName = data == null ? "" : new String(data);
        this.mPortNumber = seq[6].getInteger().toInt();
        this.mMaxUsers = seq[7].getInteger().toInt();
        this.mServiceLevel = seq[8].getInteger().toInt();
    }

    @Override
    public void decode(InputStream in) throws CertificateException, IOException {
    }

    @Override
    public void encode(OutputStream out) throws CertificateException, IOException {
        DerOutputStream dos = new DerOutputStream();
        super.encode(dos);
        out.write(dos.toByteArray());
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public Object get(String name) throws IOException {
        return null;
    }

    @Override
    public void delete(String name) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return null;
    }

    @Override
    public String getName() {
        return "PresenceServerExtension";
    }

    public void setName(String name) {
    }

    public String getOID() {
        return OID;
    }

    public void setOID(String oid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ByteArrayOutputStream dos = null;
        FileOutputStream fos = null;
        try {
            boolean critical = false;
            int version = 1;
            String streetAddress = "401E Middlefield Rd.,MV,CA94041";
            String telephoneNumber = "650-111-1111";
            String rfc822Name = "admin@netscape.com";
            String ID = "ps-capitol";
            String hostName = "capitol";
            int portNumber = 80;
            int maxUsers = 10;
            int serviceLevel = 1;
            PresenceServerExtension ext = new PresenceServerExtension(critical, version, streetAddress, telephoneNumber, rfc822Name, ID, hostName, portNumber, maxUsers, serviceLevel);
            dos = new ByteArrayOutputStream();
            ext.encode(dos);
            fos = new FileOutputStream("pse.der");
            fos.write(dos.toByteArray());
            Extension ext1 = new Extension(new DerValue(dos.toByteArray()));
            PresenceServerExtension presenceServerExtension = new PresenceServerExtension(false, ext1.getExtensionValue());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

