/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.mozilla.jss.netscape.security.util.PrintableCharset;

public class PrintableCharsetDecoder
extends CharsetDecoder {
    public PrintableCharsetDecoder(Charset cs) {
        super(cs, 1.0f, 1.0f);
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        while (in.remaining() >= 1) {
            in.mark();
            byte b = in.get();
            char c = (char)(b & 0x7F);
            if (CodingErrorAction.REPORT == this.unmappableCharacterAction() && !PrintableCharset.isPrintableChar(c)) continue;
            if (out.remaining() < 1) {
                in.reset();
                return CoderResult.OVERFLOW;
            }
            out.put(c);
        }
        return CoderResult.UNDERFLOW;
    }
}

