/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.apache.commons.lang3.ArrayUtils;
import org.mozilla.jss.netscape.security.util.DerEncoder;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;

public class AlgorithmId
implements Serializable,
DerEncoder {
    private static final long serialVersionUID = 7205873507486557157L;
    private ObjectIdentifier algid;
    private AlgorithmParameters algParams;
    private String cachedAlgName;
    protected DerValue params;
    protected String paramsString;
    private static final int[] MD2_data = new int[]{1, 2, 840, 113549, 2, 2};
    private static final int[] MD5_data = new int[]{1, 2, 840, 113549, 2, 5};
    @Deprecated(since="5.0.1", forRemoval=true)
    private static final int[] SHA1_OIW_data = new int[]{1, 3, 14, 3, 2, 26};
    private static final int[] SHA256_data = new int[]{2, 16, 840, 1, 101, 3, 4, 2, 1};
    private static final int[] SHA384_data = new int[]{2, 16, 840, 1, 101, 3, 4, 2, 2};
    private static final int[] SHA512_data = new int[]{2, 16, 840, 1, 101, 3, 4, 2, 3};
    private static final int[] MGF1_data = new int[]{1, 2, 840, 113549, 1, 1, 8};
    public static final ObjectIdentifier MD2_oid = new ObjectIdentifier(MD2_data);
    public static final ObjectIdentifier MD5_oid = new ObjectIdentifier(MD5_data);
    @Deprecated(since="5.0.1", forRemoval=true)
    public static final ObjectIdentifier SHA_oid = new ObjectIdentifier(SHA1_OIW_data);
    public static final ObjectIdentifier SHA256_oid = new ObjectIdentifier(SHA256_data);
    public static final ObjectIdentifier SHA384_oid = new ObjectIdentifier(SHA384_data);
    public static final ObjectIdentifier SHA512_oid = new ObjectIdentifier(SHA512_data);
    public static final ObjectIdentifier MGF1_oid = new ObjectIdentifier(MGF1_data);
    private static final int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
    private static final int[] DH_PKIX_data = new int[]{1, 2, 840, 10046, 2, 1};
    private static final int[] DSA_OIW_data = new int[]{1, 3, 14, 3, 2, 12};
    private static final int[] DSA_PKIX_data = new int[]{1, 2, 840, 10040, 4, 1};
    private static final int[] RSA_data = new int[]{1, 2, 5, 8, 1, 1};
    private static final int[] RSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 1};
    private static final int[] ANSI_X962_public_key_data = new int[]{1, 2, 840, 10045, 2, 1};
    private static final int[] ANSI_X962_sha1_with_ec_data = new int[]{1, 2, 840, 10045, 4, 1};
    public static final ObjectIdentifier ANSIX962_EC_Public_Key_oid = new ObjectIdentifier(ANSI_X962_public_key_data);
    @Deprecated(since="5.0.1", forRemoval=true)
    public static final ObjectIdentifier ANSIX962_SHA1_With_EC_oid = new ObjectIdentifier(ANSI_X962_sha1_with_ec_data);
    public static final ObjectIdentifier DH_oid = new ObjectIdentifier(DH_data);
    public static final ObjectIdentifier DH_PKIX_oid = new ObjectIdentifier(DH_PKIX_data);
    public static final ObjectIdentifier DSA_OIW_oid = new ObjectIdentifier(DSA_OIW_data);
    public static final ObjectIdentifier DSA_oid = new ObjectIdentifier(DSA_PKIX_data);
    public static final ObjectIdentifier RSA_oid = new ObjectIdentifier(RSA_data);
    public static final ObjectIdentifier RSAEncryption_oid = new ObjectIdentifier(RSAEncryption_data);
    @Deprecated(since="5.0.1", forRemoval=true)
    private static final int[] sha1WithEC_data = new int[]{1, 2, 840, 10045, 4, 1};
    private static final int[] sha224WithEC_data = new int[]{1, 2, 840, 10045, 4, 3, 1};
    private static final int[] sha256WithEC_data = new int[]{1, 2, 840, 10045, 4, 3, 2};
    private static final int[] sha384WithEC_data = new int[]{1, 2, 840, 10045, 4, 3, 3};
    private static final int[] sha512WithEC_data = new int[]{1, 2, 840, 10045, 4, 3, 4};
    private static final int[] md2WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 2};
    private static final int[] md5WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 4};
    @Deprecated(since="5.0.1", forRemoval=true)
    private static final int[] sha1WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 5};
    private static final int[] sha256WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 11};
    private static final int[] sha384WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 12};
    private static final int[] sha512WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 13};
    @Deprecated(since="5.0.1", forRemoval=true)
    private static final int[] sha1WithRSAEncryption_OIW_data = new int[]{1, 3, 14, 3, 2, 29};
    @Deprecated(since="5.0.1", forRemoval=true)
    private static final int[] shaWithDSA_OIW_data = new int[]{1, 3, 14, 3, 2, 13};
    @Deprecated(since="5.0.1", forRemoval=true)
    private static final int[] sha1WithDSA_OIW_data = new int[]{1, 3, 14, 3, 2, 27};
    @Deprecated(since="5.0.1", forRemoval=true)
    private static final int[] dsaWithSHA1_PKIX_data = new int[]{1, 2, 840, 10040, 4, 3};
    private static final int[] rsaPSS_data = new int[]{1, 2, 840, 113549, 1, 1, 10};
    @Deprecated(since="5.0.1", forRemoval=true)
    public static final ObjectIdentifier sha1WithEC_oid = new ObjectIdentifier(sha1WithEC_data);
    public static final ObjectIdentifier sha224WithEC_oid = new ObjectIdentifier(sha224WithEC_data);
    public static final ObjectIdentifier sha256WithEC_oid = new ObjectIdentifier(sha256WithEC_data);
    public static final ObjectIdentifier sha384WithEC_oid = new ObjectIdentifier(sha384WithEC_data);
    public static final ObjectIdentifier sha512WithEC_oid = new ObjectIdentifier(sha512WithEC_data);
    public static final ObjectIdentifier rsaPSS_oid = new ObjectIdentifier(rsaPSS_data);
    public static final ObjectIdentifier md2WithRSAEncryption_oid = new ObjectIdentifier(md2WithRSAEncryption_data);
    public static final ObjectIdentifier md5WithRSAEncryption_oid = new ObjectIdentifier(md5WithRSAEncryption_data);
    @Deprecated(since="5.0.1", forRemoval=true)
    public static final ObjectIdentifier sha1WithRSAEncryption_oid = new ObjectIdentifier(sha1WithRSAEncryption_data);
    public static final ObjectIdentifier sha256WithRSAEncryption_oid = new ObjectIdentifier(sha256WithRSAEncryption_data);
    public static final ObjectIdentifier sha384WithRSAEncryption_oid = new ObjectIdentifier(sha384WithRSAEncryption_data);
    public static final ObjectIdentifier sha512WithRSAEncryption_oid = new ObjectIdentifier(sha512WithRSAEncryption_data);
    @Deprecated(since="5.0.1", forRemoval=true)
    public static final ObjectIdentifier sha1WithRSAEncryption_OIW_oid = new ObjectIdentifier(sha1WithRSAEncryption_OIW_data);
    @Deprecated(since="5.0.1", forRemoval=true)
    public static final ObjectIdentifier shaWithDSA_OIW_oid = new ObjectIdentifier(shaWithDSA_OIW_data);
    @Deprecated(since="5.0.1", forRemoval=true)
    public static final ObjectIdentifier sha1WithDSA_OIW_oid = new ObjectIdentifier(sha1WithDSA_OIW_data);
    @Deprecated(since="5.0.1", forRemoval=true)
    public static final ObjectIdentifier sha1WithDSA_oid = new ObjectIdentifier(dsaWithSHA1_PKIX_data);
    @Deprecated(since="5.0.1", forRemoval=true)
    public static final String[] DSA_SIGNING_ALGORITHMS = new String[]{"SHA1withDSA"};
    public static final String[] RSA_SIGNING_ALGORITHMS = new String[]{"SHA256withRSA", "SHA384withRSA", "SHA512withRSA", "SHA1withRSA", "SHA256withRSA/PSS", "SHA384withRSA/PSS", "SHA512withRSA/PSS"};
    public static final String[] EC_SIGNING_ALGORITHMS = new String[]{"SHA256withEC", "SHA384withEC", "SHA512withEC", "SHA1withEC"};
    public static final String[] ALL_SIGNING_ALGORITHMS = (String[])ArrayUtils.addAll((Object[])RSA_SIGNING_ALGORITHMS, (Object[])EC_SIGNING_ALGORITHMS);

    public AlgorithmParameters getParameters() {
        return this.algParams;
    }

    public String getParametersString() {
        return this.paramsString;
    }

    public void setParametersString(String paramStr) {
        this.paramsString = paramStr;
    }

    public static AlgorithmId get(String algname) throws NoSuchAlgorithmException {
        ObjectIdentifier oid = AlgorithmId.algOID(algname);
        if (oid == null) {
            throw new NoSuchAlgorithmException("unrecognized algorithm name: " + algname);
        }
        try {
            return new AlgorithmId(oid, algname);
        }
        catch (Exception e) {
            throw new NoSuchAlgorithmException(e);
        }
    }

    public static AlgorithmId parse(DerValue val) throws IOException {
        DerValue params;
        if (val.tag != 48) {
            throw new IOException("algid parse error, not a sequence");
        }
        DerInputStream in = val.toDerInputStream();
        ObjectIdentifier algid = in.getOID();
        if (in.available() == 0) {
            params = null;
        } else {
            params = in.getDerValue();
            if (params.tag == 5) {
                params = null;
            }
        }
        AlgorithmId alg = null;
        if (!(algid.equals(sha224WithEC_oid) || algid.equals(sha256WithEC_oid) || algid.equals(sha384WithEC_oid) || algid.equals(sha512WithEC_oid))) {
            alg = new AlgorithmId(algid, params);
        } else {
            try {
                alg = new AlgorithmId(algid);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (params != null) {
            alg.decodeParams();
        }
        String paramStr = null;
        if (params != null) {
            paramStr = params.toString();
        }
        alg.setParametersString(paramStr);
        return alg;
    }

    public static AlgorithmId parse(byte[] val) throws IOException {
        return null;
    }

    public AlgorithmId(ObjectIdentifier oid, AlgorithmParameters params) throws IOException, NoSuchAlgorithmException {
        this.algid = null;
        this.algParams = null;
        this.cachedAlgName = null;
        this.params = null;
        this.paramsString = null;
        this.algid = oid;
        this.algParams = params;
        if (this.algParams == null) {
            throw new NoSuchAlgorithmException("AlgorithmId: null algParams.");
        }
        this.params = new DerValue(this.algParams.getEncoded());
    }

    public AlgorithmId(ObjectIdentifier oid, String algName) throws IOException, NoSuchAlgorithmException {
        this.algid = null;
        this.algParams = null;
        this.cachedAlgName = null;
        this.params = null;
        this.paramsString = null;
        this.algid = oid;
        this.cachedAlgName = algName;
        if (algName != null && algName.contains("PSS")) {
            this.algParams = this.getPSSParams(algName);
            this.params = new DerValue(this.algParams.getEncoded());
        }
    }

    public AlgorithmId(ObjectIdentifier oid) {
        block5: {
            this.algid = null;
            this.algParams = null;
            this.cachedAlgName = null;
            this.params = null;
            this.paramsString = null;
            this.algid = oid;
            String algName = this.algName();
            if (algName != null && algName.contains("PSS")) {
                try {
                    this.algParams = this.getPSSParams(algName);
                    if (this.algParams == null) break block5;
                    try {
                        this.params = new DerValue(this.algParams.getEncoded());
                    }
                    catch (IOException e) {
                        throw new IOException(e);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to create pssPrams in Algorithmid(ObjectIdentifier oid): " + e.getMessage(), e);
                }
            }
        }
    }

    private AlgorithmParameters getPSSParams(String algName) throws NoSuchAlgorithmException, IOException {
        this.cachedAlgName = algName;
        AlgorithmParameters ret = null;
        try {
            ret = AlgorithmId.createPSSAlgorithmParameters(algName);
        }
        catch (Exception e) {
            throw new NoSuchAlgorithmException(e);
        }
        return ret;
    }

    private AlgorithmId(ObjectIdentifier oid, DerValue params) throws IOException {
        this.algid = null;
        this.algParams = null;
        this.cachedAlgName = null;
        this.params = null;
        this.paramsString = null;
        this.algid = oid;
        this.params = params;
        if (this.params != null) {
            this.decodeParams();
        }
    }

    @Deprecated
    public AlgorithmId() {
        this.algid = null;
        this.algParams = null;
        this.cachedAlgName = null;
        this.params = null;
        this.paramsString = null;
    }

    protected void decodeParams() throws IOException {
        try {
            if (this.algid.equals(rsaPSS_oid)) {
                try {
                    this.algParams = AlgorithmId.createPSSAlgorithmParametersFromData(this.params.toByteArray());
                    return;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            this.algParams = AlgorithmParameters.getInstance(this.algid.toString());
        }
        catch (NoSuchAlgorithmException e) {
            this.algParams = null;
            return;
        }
        this.algParams.init(this.params.toByteArray());
    }

    public final void encode(DerOutputStream out) throws IOException {
        this.derEncode(out);
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        try (DerOutputStream tmp = new DerOutputStream();){
            DerOutputStream bytes = new DerOutputStream();
            bytes.putOID(this.algid);
            if (!(this.algid.equals(sha224WithEC_oid) || this.algid.equals(sha256WithEC_oid) || this.algid.equals(sha384WithEC_oid) || this.algid.equals(sha512WithEC_oid))) {
                if (this.params == null) {
                    bytes.putNull();
                } else {
                    bytes.putDerValue(this.params);
                }
            }
            tmp.write((byte)48, bytes);
            out.write(tmp.toByteArray());
        }
    }

    public void derEncodeWithContext(OutputStream out, int contextVal) throws IOException {
        try (DerOutputStream tmp = new DerOutputStream();){
            DerOutputStream bytes = new DerOutputStream();
            bytes.putOID(this.algid);
            byte val = (byte)contextVal;
            if (!(this.algid.equals(sha224WithEC_oid) || this.algid.equals(sha256WithEC_oid) || this.algid.equals(sha384WithEC_oid) || this.algid.equals(sha512WithEC_oid))) {
                if (this.params == null) {
                    bytes.putNull();
                } else {
                    bytes.putDerValue(this.params);
                }
            }
            DerOutputStream seq = new DerOutputStream();
            seq.write((byte)48, bytes);
            tmp.write(DerValue.createTag((byte)-128, true, val), seq);
            out.write(tmp.toByteArray());
        }
    }

    public final byte[] encode() throws IOException {
        try (DerOutputStream out = new DerOutputStream();){
            DerOutputStream bytes = new DerOutputStream();
            bytes.putOID(this.algid);
            if (!(this.algid.equals(sha224WithEC_oid) || this.algid.equals(sha256WithEC_oid) || this.algid.equals(sha384WithEC_oid) || this.algid.equals(sha512WithEC_oid))) {
                if (this.params == null) {
                    bytes.putNull();
                } else {
                    bytes.putDerValue(this.params);
                }
            }
            out.write((byte)48, bytes);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static String[] getSigningAlgorithms(AlgorithmId alg) {
        ObjectIdentifier algOid = alg.getOID();
        if (algOid.equals(DSA_oid) || algOid.equals(DSA_OIW_oid)) {
            return DSA_SIGNING_ALGORITHMS;
        }
        if (algOid.equals(RSA_oid) || algOid.equals(RSAEncryption_oid)) {
            return RSA_SIGNING_ALGORITHMS;
        }
        if (algOid.equals(ANSIX962_EC_Public_Key_oid) || algOid.equals(ANSIX962_SHA1_With_EC_oid)) {
            return EC_SIGNING_ALGORITHMS;
        }
        return null;
    }

    private static ObjectIdentifier algOID(String name) {
        if (name.equals("MD5")) {
            return MD5_oid;
        }
        if (name.equals("MD2")) {
            return MD2_oid;
        }
        if (name.equals("SHA") || name.equals("SHA1") || name.equals("SHA-1")) {
            return SHA_oid;
        }
        if (name.equals("SHA256") || name.equals("SHA-256")) {
            return SHA256_oid;
        }
        if (name.equals("SHA512") || name.equals("SHA-512")) {
            return SHA512_oid;
        }
        if (name.equals("RSA")) {
            return RSA_oid;
        }
        if (name.equals("RSAEncryption")) {
            return RSAEncryption_oid;
        }
        if (name.equals("Diffie-Hellman") || name.equals("DH")) {
            return DH_oid;
        }
        if (name.equals("DSA")) {
            return DSA_oid;
        }
        if (name.equals("SHA1withEC") || name.equals("SHA1/EC") || name.equals("1.2.840.10045.4.1")) {
            return sha1WithEC_oid;
        }
        if (name.equals("SHA224withEC") || name.equals("SHA224/EC") || name.equals("1.2.840.10045.4.3.1")) {
            return sha224WithEC_oid;
        }
        if (name.equals("SHA256withEC") || name.equals("SHA256/EC") || name.equals("1.2.840.10045.4.3.2")) {
            return sha256WithEC_oid;
        }
        if (name.equals("SHA384withEC") || name.equals("SHA384/EC") || name.equals("1.2.840.10045.4.3.3")) {
            return sha384WithEC_oid;
        }
        if (name.equals("SHA512withEC") || name.equals("SHA512/EC") || name.equals("1.2.840.10045.4.3.4")) {
            return sha512WithEC_oid;
        }
        if (name.equals("SHA1withRSA") || name.equals("SHA1/RSA") || name.equals("1.2.840.113549.1.1.5")) {
            return sha1WithRSAEncryption_oid;
        }
        if (name.equals("SHA256withRSA") || name.equals("SHA256/RSA") || name.equals("1.2.840.113549.1.1.11")) {
            return sha256WithRSAEncryption_oid;
        }
        if (name.equals("SHA384withRSA") || name.equals("SHA384/RSA") || name.equals("1.2.840.113549.1.1.12")) {
            return sha384WithRSAEncryption_oid;
        }
        if (name.equals("SHA512withRSA") || name.equals("SHA512/RSA") || name.equals("1.2.840.113549.1.1.13")) {
            return sha512WithRSAEncryption_oid;
        }
        if (name.equals("MD5withRSA") || name.equals("MD5/RSA")) {
            return md5WithRSAEncryption_oid;
        }
        if (name.equals("MD2withRSA") || name.equals("MD2/RSA")) {
            return md2WithRSAEncryption_oid;
        }
        if (name.equals("SHAwithDSA") || name.equals("SHA1withDSA") || name.equals("SHA/DSA") || name.equals("SHA1/DSA")) {
            return sha1WithDSA_oid;
        }
        if (name.equals("SHA256withRSA/PSS") || name.equals("SHA384withRSA/PSS") || name.equals("SHA512withRSA/PSS")) {
            return rsaPSS_oid;
        }
        return null;
    }

    private String algName() {
        if (this.algid.equals(MD5_oid)) {
            return "MD5";
        }
        if (this.algid.equals(MD2_oid)) {
            return "MD2";
        }
        if (this.algid.equals(SHA_oid)) {
            return "SHA";
        }
        if (this.algid.equals(SHA256_oid)) {
            return "SHA256";
        }
        if (this.algid.equals(SHA384_oid)) {
            return "SHA384";
        }
        if (this.algid.equals(SHA512_oid)) {
            return "SHA512";
        }
        if (this.algid.equals(rsaPSS_oid)) {
            if (this.cachedAlgName != null) {
                return this.cachedAlgName;
            }
            String paramStr = this.paramsToString();
            if (paramStr != null) {
                if (paramStr.contains("HashAlg: SHA-256")) {
                    this.cachedAlgName = "SHA256withRSA/PSS";
                } else if (paramStr.contains("HashAlg: SHA-384")) {
                    this.cachedAlgName = "SHA384withRSA/PSS";
                } else if (paramStr.contains("HashAlg: SHA-512")) {
                    this.cachedAlgName = "SHA512withRSA/PSS";
                } else {
                    throw new RuntimeException("Unknown or unsupported signature algorithm in PSS parameters: " + paramStr);
                }
            }
            return this.cachedAlgName;
        }
        if (this.algid.equals(ANSIX962_EC_Public_Key_oid)) {
            return "EC";
        }
        if (this.algid.equals(RSAEncryption_oid) || this.algid.equals(RSA_oid)) {
            return "RSA";
        }
        if (this.algid.equals(DH_oid) || this.algid.equals(DH_PKIX_oid)) {
            return "Diffie-Hellman";
        }
        if (this.algid.equals(DSA_oid) || this.algid.equals(DSA_OIW_oid)) {
            return "DSA";
        }
        if (this.algid.equals(sha1WithEC_oid)) {
            return "SHA1withEC";
        }
        if (this.algid.equals(sha256WithEC_oid)) {
            return "SHA256withEC";
        }
        if (this.algid.equals(sha384WithEC_oid)) {
            return "SHA384withEC";
        }
        if (this.algid.equals(sha512WithEC_oid)) {
            return "SHA512withEC";
        }
        if (this.algid.equals(md5WithRSAEncryption_oid)) {
            return "MD5withRSA";
        }
        if (this.algid.equals(md2WithRSAEncryption_oid)) {
            return "MD2withRSA";
        }
        if (this.algid.equals(sha1WithRSAEncryption_oid)) {
            return "SHA1withRSA";
        }
        if (this.algid.equals(sha256WithRSAEncryption_oid)) {
            return "SHA256withRSA";
        }
        if (this.algid.equals(sha384WithRSAEncryption_oid)) {
            return "SHA384withRSA";
        }
        if (this.algid.equals(sha512WithRSAEncryption_oid)) {
            return "SHA512withRSA";
        }
        if (this.algid.equals(sha1WithDSA_oid) || this.algid.equals(sha1WithDSA_OIW_oid) || this.algid.equals(shaWithDSA_OIW_oid)) {
            return "SHA1withDSA";
        }
        return "OID." + this.algid.toString();
    }

    public final ObjectIdentifier getOID() {
        return this.algid;
    }

    public String getName() {
        return this.algName();
    }

    public String toString() {
        return this.algName();
    }

    public String toStringWithParams() {
        if (this.params == null) {
            return this.algName();
        }
        return this.algName() + " " + this.paramsToString();
    }

    public byte[] getEncodedParams() throws IOException {
        return this.params == null ? null : this.params.toByteArray();
    }

    protected String paramsToString() {
        if (this.params == null) {
            return "";
        }
        if (this.algParams != null) {
            return this.algParams.toString();
        }
        return ", params unparsed";
    }

    public boolean equals(AlgorithmId other) {
        if (!this.algid.equals(other.algid)) {
            return false;
        }
        if (this.params == null && other.params == null) {
            return true;
        }
        if (this.params == null) {
            return false;
        }
        return this.params.equals(other.params);
    }

    public boolean equals(Object other) {
        if (other instanceof AlgorithmId) {
            return this.equals((AlgorithmId)other);
        }
        if (other instanceof ObjectIdentifier) {
            return this.equals((ObjectIdentifier)other);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.algParams == null ? 0 : this.algParams.hashCode());
        result = 31 * result + (this.algid == null ? 0 : this.algid.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        result = 31 * result + (this.paramsString == null ? 0 : this.paramsString.hashCode());
        return result;
    }

    public final boolean equals(ObjectIdentifier id) {
        return this.algid.equals(id);
    }

    public static AlgorithmParameters createPSSAlgorithmParametersFromData(byte[] der) throws Exception {
        if (der == null) {
            throw new Exception("Invalid input data.");
        }
        AlgorithmParameters pssParams = null;
        try {
            pssParams = AlgorithmParameters.getInstance("RSAPSSAlgorithmParameters", "Mozilla-JSS");
        }
        catch (NoSuchProviderException e) {
            throw new Exception(e);
        }
        try {
            pssParams.init(der);
        }
        catch (IOException e) {
            throw new Exception("Error intializing RSAPSS parameters: " + e);
        }
        return pssParams;
    }

    public static AlgorithmParameters createPSSAlgorithmParameters(String algName) throws IllegalArgumentException, NoSuchProviderException, InvalidParameterSpecException, NoSuchAlgorithmException {
        if (algName == null) {
            throw new IllegalArgumentException("Invalid Algorithm name input.");
        }
        if (!algName.contains("PSS")) {
            throw new IllegalArgumentException("PSS Algorithm name not supported.");
        }
        AlgorithmParameters pssParams = null;
        PSSParameterSpec pssSpec = null;
        if ("SHA256withRSA/PSS".equals(algName)) {
            pssSpec = new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1);
        } else if ("SHA384withRSA/PSS".equals(algName)) {
            pssSpec = new PSSParameterSpec("SHA-384", "MGF1", MGF1ParameterSpec.SHA384, 48, 1);
        } else if ("SHA512withRSA/PSS".equals(algName)) {
            pssSpec = new PSSParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, 64, 1);
        } else {
            throw new IllegalArgumentException("Unsupported algorithm: " + algName);
        }
        pssParams = AlgorithmParameters.getInstance("RSAPSSAlgorithmParameters", "Mozilla-JSS");
        pssParams.init(pssSpec);
        return pssParams;
    }
}

