/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.GeneralNamesException;
import org.mozilla.jss.netscape.security.x509.KeyIdentifier;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.SerialNumber;

public class AuthorityKeyIdentifierExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = -157913621972354170L;
    public static final String IDENT = "x509.info.extensions.AuthorityKeyIdentifier";
    public static final String NAME = "AuthorityKeyIdentifier";
    public static final String KEY_ID = "key_id";
    public static final String AUTH_NAME = "auth_name";
    public static final String SERIAL_NUMBER = "serial_number";
    private static final byte TAG_ID = 0;
    private static final byte TAG_NAMES = 1;
    private static final byte TAG_SERIAL_NUM = 2;
    private KeyIdentifier id = null;
    private GeneralNames names = null;
    private SerialNumber serialNum = null;

    private void encodeThis() throws IOException {
        try (DerOutputStream tmp = new DerOutputStream();
             DerOutputStream seq = new DerOutputStream();){
            DerOutputStream tmp1;
            if (this.id != null) {
                tmp1 = new DerOutputStream();
                this.id.encode(tmp1);
                tmp.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), tmp1);
            }
            try {
                if (this.names != null) {
                    tmp1 = new DerOutputStream();
                    this.names.encode(tmp1);
                    tmp.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), tmp1);
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (this.serialNum != null) {
                tmp1 = new DerOutputStream();
                this.serialNum.encode(tmp1);
                tmp.writeImplicit(DerValue.createTag((byte)-128, false, (byte)2), tmp1);
            }
            seq.write((byte)48, tmp);
            this.extensionValue = seq.toByteArray();
        }
    }

    public AuthorityKeyIdentifierExtension(boolean critical, KeyIdentifier kid, GeneralNames name, SerialNumber sn) throws IOException {
        this.id = kid;
        this.names = name;
        this.serialNum = sn;
        this.extensionId = PKIXExtensions.AuthorityKey_Id;
        this.critical = critical;
        this.encodeThis();
    }

    public AuthorityKeyIdentifierExtension(KeyIdentifier kid, GeneralNames name, SerialNumber sn) throws IOException {
        this.id = kid;
        this.names = name;
        this.serialNum = sn;
        this.extensionId = PKIXExtensions.AuthorityKey_Id;
        this.critical = false;
        this.encodeThis();
    }

    public AuthorityKeyIdentifierExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.AuthorityKey_Id;
        this.critical = critical;
        if (!(value instanceof byte[])) {
            throw new IOException("Illegal argument type");
        }
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        System.arraycopy(value, 0, extValue, 0, len);
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for AuthorityKeyIdentifierExtension.");
        }
        while (val.data.available() != 0) {
            DerValue opt = val.data.getDerValue();
            if (opt.isContextSpecific((byte)0) && !opt.isConstructed()) {
                if (this.id != null) {
                    throw new IOException("Duplicate KeyIdentifier in AuthorityKeyIdentifier.");
                }
                opt.resetTag((byte)4);
                this.id = new KeyIdentifier(opt);
                continue;
            }
            if (opt.isContextSpecific((byte)1) && opt.isConstructed()) {
                if (this.names != null) {
                    throw new IOException("Duplicate GeneralNames in AuthorityKeyIdentifier.");
                }
                try {
                    opt.resetTag((byte)48);
                    this.names = new GeneralNames(opt);
                    continue;
                }
                catch (GeneralNamesException e) {
                    throw new IOException(e);
                }
            }
            if (opt.isContextSpecific((byte)2) && !opt.isConstructed()) {
                if (this.serialNum != null) {
                    throw new IOException("Duplicate SerialNumber in AuthorityKeyIdentifier.");
                }
                opt.resetTag((byte)2);
                this.serialNum = new SerialNumber(opt);
                continue;
            }
            throw new IOException("Invalid encoding of AuthorityKeyIdentifierExtension.");
        }
    }

    @Override
    public String toString() {
        String s = super.toString() + "AuthorityKeyIdentifier [\n";
        if (this.id != null) {
            s = s + this.id.toString();
        }
        if (this.names != null) {
            s = s + this.names.toString() + "\n";
        }
        if (this.serialNum != null) {
            s = s + this.serialNum.toString() + "\n";
        }
        return s + "]\n";
    }

    @Override
    public void decode(InputStream in) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.AuthorityKey_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        this.clearValue();
        if (name.equalsIgnoreCase(KEY_ID)) {
            if (!(obj instanceof KeyIdentifier)) {
                throw new IOException("Attribute value should be of type KeyIdentifier.");
            }
            this.id = (KeyIdentifier)obj;
        } else if (name.equalsIgnoreCase(AUTH_NAME)) {
            if (!(obj instanceof GeneralNames)) {
                throw new IOException("Attribute value should be of type GeneralNames.");
            }
            this.names = (GeneralNames)obj;
        } else if (name.equalsIgnoreCase(SERIAL_NUMBER)) {
            if (!(obj instanceof SerialNumber)) {
                throw new IOException("Attribute value should be of type SerialNumber.");
            }
            this.serialNum = (SerialNumber)obj;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(KEY_ID)) {
            return this.id;
        }
        if (name.equalsIgnoreCase(AUTH_NAME)) {
            return this.names;
        }
        if (name.equalsIgnoreCase(SERIAL_NUMBER)) {
            return this.serialNum;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (name.equalsIgnoreCase(KEY_ID)) {
            this.id = null;
        } else if (name.equalsIgnoreCase(AUTH_NAME)) {
            this.names = null;
        } else if (name.equalsIgnoreCase(SERIAL_NUMBER)) {
            this.serialNum = null;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
        }
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(KEY_ID);
        elements.addElement(AUTH_NAME);
        elements.addElement(SERIAL_NUMBER);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

