/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class BodyPartReference
implements ASN1Value {
    public static final INTEGER BODYIDMAX = new INTEGER("4294967295");
    public static Type BodyPartID = Type.BodyPartID;
    public static Type BodyPartPath = Type.BodyPartPath;
    private Type type;
    private INTEGER bodyPartID;
    private SEQUENCE bodyPartPath;
    private static final Template templateInstance = new Template();

    public BodyPartReference(Type type, INTEGER bodyPartID, SEQUENCE bodyPartPath) {
        this.bodyPartID = bodyPartID;
        this.bodyPartPath = bodyPartPath;
    }

    public void addBodyPartId(int id) {
        INTEGER id1 = new INTEGER(id);
        assert (id1.compareTo(BODYIDMAX) <= 0);
        this.bodyPartPath.addElement(id1);
    }

    public Type getType() {
        return this.type;
    }

    public INTEGER getBodyPartID() {
        return this.bodyPartID;
    }

    public SEQUENCE getBodyPartPath() {
        return this.bodyPartPath;
    }

    @Override
    public Tag getTag() {
        if (this.type == BodyPartID) {
            return INTEGER.TAG;
        }
        assert (this.type == BodyPartPath);
        return SEQUENCE.TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        if (this.type == BodyPartID) {
            this.bodyPartID.encode(ostream);
        } else {
            assert (this.type == BodyPartPath);
            this.bodyPartPath.encode(ostream);
        }
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.encode(ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Type {
        static Type BodyPartID = new Type();
        static Type BodyPartPath = new Type();

        private Type() {
        }
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template choicet = new CHOICE.Template();

        public Template() {
            this.choicet.addElement(INTEGER.getTemplate());
            this.choicet.addElement(new SEQUENCE.OF_Template(INTEGER.getTemplate()));
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return this.choicet.tagMatch(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            CHOICE c = (CHOICE)this.choicet.decode(istream);
            if (c.getTag().equals(INTEGER.TAG)) {
                return new BodyPartReference(BodyPartID, (INTEGER)c.getValue(), null);
            }
            assert (c.getTag().equals(SEQUENCE.TAG));
            return new BodyPartReference(BodyPartPath, null, (SEQUENCE)c.getValue());
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            return this.decode(istream);
        }
    }
}

