/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class PendInfo
implements ASN1Value {
    private SEQUENCE sequence = new SEQUENCE();
    private OCTET_STRING pendToken;
    private GeneralizedTime pendTime;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public PendInfo(OCTET_STRING pendToken, GeneralizedTime pendTime) {
        this.pendToken = pendToken;
        this.sequence.addElement(pendToken);
        this.pendTime = pendTime;
        this.sequence.addElement(pendTime);
    }

    public PendInfo(String reqId, Date date) {
        this.pendToken = new OCTET_STRING(reqId.getBytes());
        this.sequence.addElement(new OCTET_STRING(reqId.getBytes()));
        this.pendTime = new GeneralizedTime(date);
        this.sequence.addElement(new GeneralizedTime(date));
    }

    public GeneralizedTime getPendTime() {
        return this.pendTime;
    }

    public OCTET_STRING getPendToken() {
        return this.pendToken;
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(OCTET_STRING.getTemplate());
            this.seqt.addElement(GeneralizedTime.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            assert (seq.size() == 2);
            return new PendInfo((OCTET_STRING)seq.elementAt(0), (GeneralizedTime)seq.elementAt(1));
        }
    }
}

