/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.NULL;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.crmf.POPOPrivKey;
import org.mozilla.jss.pkix.crmf.POPOSigningKey;

public class ProofOfPossession
implements ASN1Value {
    public static Type RA_VERIFIED = Type.RA_VERIFIED;
    public static Type SIGNATURE = Type.SIGNATURE;
    public static Type KEY_ENCIPHERMENT = Type.KEY_ENCIPHERMENT;
    public static Type KEY_AGREEMENT = Type.KEY_AGREEMENT;
    private Type type;
    private POPOSigningKey signature;
    private POPOPrivKey keyEncipherment;
    private POPOPrivKey keyAgreement;

    public Type getType() {
        return this.type;
    }

    public POPOSigningKey getSignature() {
        return this.signature;
    }

    public POPOPrivKey getKeyEncipherment() {
        return this.keyEncipherment;
    }

    public POPOPrivKey getKeyAgreement() {
        return this.keyAgreement;
    }

    private ProofOfPossession() {
    }

    private ProofOfPossession(Type type, POPOSigningKey signature, POPOPrivKey keyEncipherment, POPOPrivKey keyAgreement) {
        this.type = type;
        this.signature = signature;
        this.keyEncipherment = keyEncipherment;
        this.keyAgreement = keyAgreement;
    }

    public static ProofOfPossession createRaVerified() {
        return new ProofOfPossession(RA_VERIFIED, null, null, null);
    }

    public static ProofOfPossession createSignature(POPOSigningKey signature) {
        return new ProofOfPossession(SIGNATURE, signature, null, null);
    }

    public static ProofOfPossession createKeyEncipherment(POPOPrivKey keyEncipherment) {
        return new ProofOfPossession(KEY_ENCIPHERMENT, null, keyEncipherment, null);
    }

    public static ProofOfPossession createKeyAgreement(POPOPrivKey keyAgreement) {
        return new ProofOfPossession(KEY_AGREEMENT, null, null, keyAgreement);
    }

    @Override
    public Tag getTag() {
        if (this.type == RA_VERIFIED) {
            return Tag.get(0L);
        }
        if (this.type == SIGNATURE) {
            return Tag.get(1L);
        }
        if (this.type == KEY_ENCIPHERMENT) {
            return Tag.get(2L);
        }
        assert (this.type == KEY_AGREEMENT);
        return Tag.get(3L);
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        if (this.type == RA_VERIFIED) {
            new NULL().encode(Tag.get(0L), ostream);
        } else if (this.type == SIGNATURE) {
            this.signature.encode(Tag.get(1L), ostream);
        } else if (this.type == KEY_ENCIPHERMENT) {
            EXPLICIT e = new EXPLICIT(Tag.get(2L), this.keyEncipherment);
            e.encode(ostream);
        } else {
            assert (this.type == KEY_AGREEMENT);
            EXPLICIT e = new EXPLICIT(Tag.get(3L), this.keyAgreement);
            e.encode(ostream);
        }
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        assert (implicitTag.equals(this.getTag()));
        this.encode(ostream);
    }

    public static class Type {
        static Type RA_VERIFIED = new Type();
        static Type SIGNATURE = new Type();
        static Type KEY_ENCIPHERMENT = new Type();
        static Type KEY_AGREEMENT = new Type();

        private Type() {
        }
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template choicet = new CHOICE.Template();

        public Template() {
            this.choicet.addElement(Tag.get(0L), NULL.getTemplate());
            this.choicet.addElement(Tag.get(1L), POPOSigningKey.getTemplate());
            EXPLICIT.Template et = new EXPLICIT.Template(Tag.get(2L), POPOPrivKey.getTemplate());
            this.choicet.addElement(et);
            et = new EXPLICIT.Template(Tag.get(3L), POPOPrivKey.getTemplate());
            this.choicet.addElement(et);
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return this.choicet.tagMatch(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            CHOICE c = (CHOICE)this.choicet.decode(istream);
            if (c.getTag().equals(Tag.get(0L))) {
                return ProofOfPossession.createRaVerified();
            }
            if (c.getTag().equals(Tag.get(1L))) {
                return ProofOfPossession.createSignature((POPOSigningKey)c.getValue());
            }
            if (c.getTag().equals(Tag.get(2L))) {
                EXPLICIT e = (EXPLICIT)c.getValue();
                return ProofOfPossession.createKeyEncipherment((POPOPrivKey)e.getContent());
            }
            assert (c.getTag().equals(Tag.get(3L)));
            EXPLICIT e = (EXPLICIT)c.getValue();
            return ProofOfPossession.createKeyAgreement((POPOPrivKey)e.getContent());
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            throw new RuntimeException("A CHOICE cannot be implicitly tagged");
        }
    }
}

