/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.javax.crypto;

import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import org.mozilla.jss.crypto.CMACAlgorithm;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.HMACAlgorithm;
import org.mozilla.jss.crypto.JSSMessageDigest;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenRuntimeException;
import org.mozilla.jss.crypto.TokenSupplierManager;

public class JSSMacSpi
extends MacSpi {
    private JSSMessageDigest digest = null;
    private DigestAlgorithm alg;
    private String keyName;

    protected JSSMacSpi(DigestAlgorithm alg, String keyName) {
        try {
            this.alg = alg;
            this.keyName = keyName;
            CryptoToken token = TokenSupplierManager.getTokenSupplier().getThreadToken();
            this.digest = token.getDigestContext(alg);
        }
        catch (DigestException de) {
            throw new TokenRuntimeException(de.getMessage());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new TokenRuntimeException(nsae.getMessage());
        }
    }

    @Override
    public int engineGetMacLength() {
        return this.alg.getOutputSize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            SymmetricKey real_key = null;
            if (key instanceof SecretKeyFacade) {
                SecretKeyFacade facade = (SecretKeyFacade)key;
                real_key = facade.key;
            } else if (key instanceof SymmetricKey) {
                real_key = (SymmetricKey)key;
            } else {
                SecretKeySpec spec;
                if (key.getEncoded() == null) {
                    Object msg = "Must use a key created by JSS; got ";
                    msg = (String)msg + key.getClass().getName() + ". ";
                    msg = (String)msg + "Try exporting the key data and importing it via ";
                    msg = (String)msg + "SecretKeyFactory or use an exportable key type ";
                    msg = (String)msg + "so JSS can do this automatically.";
                    throw new InvalidKeyException((String)msg);
                }
                SecretKeyFactory factory = SecretKeyFactory.getInstance(this.keyName, "Mozilla-JSS");
                SecretKey manufactured = factory.generateSecret(spec = new SecretKeySpec(key.getEncoded(), this.keyName));
                if (manufactured instanceof SecretKeyFacade) {
                    SecretKeyFacade facade = (SecretKeyFacade)manufactured;
                    real_key = facade.key;
                } else {
                    if (!(manufactured instanceof SymmetricKey)) {
                        Object msg = "Internal error while converting key: ";
                        msg = (String)msg + "SecretKeyFactory gave unrecognized manufactured ";
                        msg = (String)msg + "key type: " + manufactured.getClass().getName();
                        throw new InvalidKeyException((String)msg);
                    }
                    real_key = (SymmetricKey)manufactured;
                }
            }
            this.digest.initHMAC(real_key);
            return;
        }
        catch (DigestException de) {
            throw new InvalidKeyException("DigestException: " + de.getMessage(), de);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InvalidKeyException("NoSuchAlgorithmException when importing key to JSS: " + nsae.getMessage(), nsae);
        }
        catch (NoSuchProviderException nspe) {
            throw new InvalidKeyException("NoSuchProviderException when importing key to JSS: " + nspe.getMessage(), nspe);
        }
        catch (InvalidKeySpecException ikse) {
            throw new InvalidKeyException("InvalidKeySpecException when importing key to JSS: " + ikse.getMessage(), ikse);
        }
    }

    @Override
    public void engineUpdate(byte input) {
        try {
            this.digest.update(input);
        }
        catch (DigestException de) {
            throw new TokenRuntimeException("DigestException: " + de.getMessage());
        }
    }

    @Override
    public void engineUpdate(byte[] input, int offset, int len) {
        try {
            this.digest.update(input, offset, len);
        }
        catch (DigestException de) {
            throw new TokenRuntimeException("DigestException: " + de.getMessage());
        }
    }

    @Override
    public byte[] engineDoFinal() {
        try {
            return this.digest.digest();
        }
        catch (DigestException de) {
            throw new TokenRuntimeException("DigestException: " + de.getMessage());
        }
    }

    @Override
    public void engineReset() {
        try {
            this.digest.reset();
        }
        catch (DigestException de) {
            throw new TokenRuntimeException("DigestException: " + de.getMessage());
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public static class CmacAES
    extends JSSMacSpi {
        public CmacAES() {
            super(CMACAlgorithm.AES, "AES");
        }
    }

    public static class HmacSHA512
    extends JSSMacSpi {
        public HmacSHA512() {
            super(HMACAlgorithm.SHA512, "HmacSHA512");
        }
    }

    public static class HmacSHA384
    extends JSSMacSpi {
        public HmacSHA384() {
            super(HMACAlgorithm.SHA384, "HmacSHA384");
        }
    }

    public static class HmacSHA256
    extends JSSMacSpi {
        public HmacSHA256() {
            super(HMACAlgorithm.SHA256, "HmacSHA256");
        }
    }

    @Deprecated(since="5.0.1", forRemoval=true)
    public static class HmacSHA1
    extends JSSMacSpi {
        public HmacSHA1() {
            super(HMACAlgorithm.SHA1, "HmacSHA1");
        }
    }
}

