/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss;

import org.mozilla.jss.InvalidLengthException;
import org.mozilla.jss.util.ConsolePasswordCallback;
import org.mozilla.jss.util.PasswordCallback;

public final class InitializationValues {
    public final int TOKEN_LENGTH = 33;
    public final int SLOT_LENGTH = 65;
    public final int MANUFACTURER_LENGTH = 33;
    public final int LIBRARY_LENGTH = 33;
    public String configDir = null;
    public String certPrefix = null;
    public String keyPrefix = null;
    public String secmodName = null;
    public PasswordCallback passwordCallback = new ConsolePasswordCallback();
    public FIPSMode fipsMode = FIPSMode.UNCHANGED;
    public boolean readOnly = false;
    public boolean initializeContext = false;
    private String manufacturerID = "mozilla.org                      ";
    private String libraryDescription = "Internal Crypto Services         ";
    private String internalTokenDescription = "NSS Generic Crypto Services      ";
    private String internalKeyStorageTokenDescription = "Internal Key Storage Token       ";
    private String internalSlotDescription = "NSS Internal Cryptographic Services                              ";
    private String internalKeyStorageSlotDescription = "NSS User Private Key and Certificate Services                    ";
    private String FIPSSlotDescription = "NSS FIPS 140-2 User Private Key Services                         ";
    private String FIPSKeyStorageSlotDescription = "NSS FIPS 140-2 User Private Key Services                         ";
    public boolean ocspCheckingEnabled = false;
    public String ocspResponderURL = null;
    public String ocspResponderCertNickname = null;
    public boolean installJSSProvider = true;
    public boolean removeSunProvider = false;
    public boolean installJSSProviderFirst = true;
    public boolean initializeJavaOnly = false;
    public boolean PKIXVerify = false;
    public boolean noCertDB = false;
    public boolean noModDB = false;
    public boolean forceOpen = false;
    public boolean noRootInit = false;
    public boolean optimizeSpace = false;
    public boolean PK11ThreadSafe = false;
    public boolean PK11Reload = false;
    public boolean noPK11Finalize = false;
    public boolean cooperate = false;

    protected InitializationValues() {
        throw new RuntimeException("Default InitializationValues constructor");
    }

    public InitializationValues(String configDir) {
        this.configDir = configDir;
    }

    public InitializationValues(String configDir, String certPrefix, String keyPrefix, String secmodName) {
        this.configDir = configDir;
        this.certPrefix = certPrefix;
        this.keyPrefix = keyPrefix;
        this.secmodName = secmodName;
    }

    public boolean getInitializeContext() {
        return this.initializeContext;
    }

    public void setInitializeContext(boolean value) {
        this.initializeContext = value;
    }

    public String getManufacturerID() {
        return this.manufacturerID;
    }

    public void setManufacturerID(String s) throws InvalidLengthException {
        if (s.length() != 33) {
            Object msg = "Expected internal manufacturer ID description ";
            msg = (String)msg + "of length 33 but was ";
            msg = (String)msg + s.length();
            throw new InvalidLengthException();
        }
        this.manufacturerID = s;
    }

    public String getLibraryDescription() {
        return this.libraryDescription;
    }

    public void setLibraryDescription(String s) throws InvalidLengthException {
        if (s.length() != 33) {
            Object msg = "Expected internal library description of length ";
            msg = (String)msg + "33 but was " + s.length();
            throw new InvalidLengthException((String)msg);
        }
        this.libraryDescription = s;
    }

    public String getInternalTokenDescription() {
        return this.internalTokenDescription;
    }

    public void setInternalTokenDescription(String s) throws InvalidLengthException {
        if (s.length() != 33) {
            Object msg = "Expected internal token description of length ";
            msg = (String)msg + "33 but was " + s.length();
            throw new InvalidLengthException((String)msg);
        }
        this.internalTokenDescription = s;
    }

    public String getInternalKeyStorageTokenDescription() {
        return this.internalKeyStorageTokenDescription;
    }

    public void setInternalKeyStorageTokenDescription(String s) throws InvalidLengthException {
        if (s.length() != 33) {
            Object msg = "Expected internal key storage token description ";
            msg = (String)msg + "of length 33 but was " + s.length();
            throw new InvalidLengthException((String)msg);
        }
        this.internalKeyStorageTokenDescription = s;
    }

    public String getInternalSlotDescription() {
        return this.internalSlotDescription;
    }

    public void setInternalSlotDescription(String s) throws InvalidLengthException {
        if (s.length() != 65) {
            Object msg = "Expected internal slot description of length ";
            msg = (String)msg + "65 but was " + s.length();
            throw new InvalidLengthException((String)msg);
        }
        this.internalSlotDescription = s;
    }

    public String getInternalKeyStorageSlotDescription() {
        return this.internalKeyStorageSlotDescription;
    }

    public void setInternalKeyStorageSlotDescription(String s) throws InvalidLengthException {
        if (s.length() != 65) {
            Object msg = "Expected internal key storage slot description of ";
            msg = (String)msg + "length 65 but was " + s.length();
            throw new InvalidLengthException((String)msg);
        }
        this.internalKeyStorageSlotDescription = s;
    }

    public String getFIPSSlotDescription() {
        return this.FIPSSlotDescription;
    }

    public void setFIPSSlotDescription(String s) throws InvalidLengthException {
        if (s.length() != 65) {
            Object msg = "Expected FIPS slot description of length ";
            msg = (String)msg + "65 but was " + s.length();
            throw new InvalidLengthException((String)msg);
        }
        this.FIPSSlotDescription = s;
    }

    public String getFIPSKeyStorageSlotDescription() {
        return this.FIPSKeyStorageSlotDescription;
    }

    public void setFIPSKeyStorageSlotDescription(String s) throws InvalidLengthException {
        if (s.length() != 65) {
            Object msg = "Expected FIPS key storage slot description of ";
            msg = (String)msg + "length 65 but was " + s.length();
            throw new InvalidLengthException((String)msg);
        }
        this.FIPSKeyStorageSlotDescription = s;
    }

    public static final class FIPSMode {
        public static final FIPSMode ENABLED = new FIPSMode();
        public static final FIPSMode DISABLED = new FIPSMode();
        public static final FIPSMode UNCHANGED = new FIPSMode();

        private FIPSMode() {
        }
    }
}

