/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.Serializable;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;

public class Extension
implements Serializable {
    private static final long serialVersionUID = -643549610716024753L;
    protected ObjectIdentifier extensionId = null;
    protected boolean critical = false;
    protected byte[] extensionValue = null;

    public Extension() {
    }

    public Extension(DerValue derVal) throws IOException {
        DerInputStream in = derVal.toDerInputStream();
        this.extensionId = in.getOID();
        DerValue val = in.getDerValue();
        if (val.tag == 1) {
            this.critical = val.getBoolean();
            val = in.getDerValue();
            this.extensionValue = val.getOctetString();
        } else {
            this.critical = false;
            this.extensionValue = val.getOctetString();
        }
    }

    public Extension(ObjectIdentifier extensionId, boolean critical, byte[] extensionValue) throws IOException {
        this.extensionId = extensionId;
        this.critical = critical;
        DerValue inDerVal = new DerValue(extensionValue);
        this.extensionValue = inDerVal.getOctetString();
    }

    public Extension(Extension ext) {
        this.extensionId = ext.extensionId;
        this.critical = ext.critical;
        this.extensionValue = ext.extensionValue;
    }

    public void encode(DerOutputStream out) throws IOException {
        if (this.extensionId == null) {
            throw new IOException("Null OID to encode for the extension!");
        }
        DerOutputStream bytes = new DerOutputStream();
        bytes.putOID(this.extensionId);
        if (this.critical) {
            bytes.putBoolean(this.critical);
        }
        if (this.extensionValue != null) {
            bytes.putOctetString(this.extensionValue);
        }
        out.write((byte)48, bytes);
    }

    public boolean isCritical() {
        return this.critical;
    }

    public void setCritical(boolean c) {
        this.critical = c;
    }

    public void clearValue() {
        this.extensionValue = null;
    }

    public ObjectIdentifier getExtensionId() {
        return this.extensionId;
    }

    public void setExtensionId(ObjectIdentifier oid) {
        this.extensionId = oid;
    }

    public byte[] getExtensionValue() {
        if (this.extensionValue == null) {
            return null;
        }
        byte[] dup = new byte[this.extensionValue.length];
        System.arraycopy(this.extensionValue, 0, dup, 0, dup.length);
        return dup;
    }

    public void setExtensionValue(byte[] value) {
        this.extensionValue = value;
    }

    public String toString() {
        String s = "ObjectId: " + this.extensionId.toString();
        s = this.critical ? s + " Criticality=true\n" : s + " Criticality=false\n";
        return s;
    }
}

