/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.IOException;
import java.io.InputStream;

class CountingStream
extends InputStream {
    private int count = 0;
    private int markpos;
    private InputStream source;
    private static final boolean DEBUG = false;

    public CountingStream(InputStream source) {
        this.source = source;
    }

    @Override
    public int available() throws IOException {
        return this.source.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.source.mark(readlimit);
        this.markpos = this.count;
    }

    @Override
    public boolean markSupported() {
        return this.source.markSupported();
    }

    @Override
    public int read() throws IOException {
        int n = this.source.read();
        if (n != -1) {
            ++this.count;
        }
        return n;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        int n = this.source.read(buffer);
        if (n != -1) {
            this.count += n;
        }
        return n;
    }

    @Override
    public int read(byte[] buffer, int offset, int count) throws IOException {
        int n = this.source.read(buffer, offset, count);
        if (n != -1) {
            this.count += n;
        }
        return n;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.source.reset();
        this.count = this.markpos;
    }

    @Override
    public long skip(long count) throws IOException {
        this.count = (int)((long)this.count + count);
        return this.source.skip(count);
    }

    public int getNumRead() {
        return this.count;
    }

    public void resetNumRead() {
        this.count = 0;
        this.markpos = 0;
    }
}

