/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.extensions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.GeneralName;

public class AccessDescription
implements Serializable {
    ObjectIdentifier mOID = null;
    GeneralName mLocation = null;

    AccessDescription(ObjectIdentifier oid, GeneralName location) {
        this.mOID = oid;
        this.mLocation = location;
    }

    public ObjectIdentifier getMethod() {
        return this.mOID;
    }

    public GeneralName getLocation() {
        return this.mLocation;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try (DerOutputStream seq = new DerOutputStream();
             DerOutputStream tmp = new DerOutputStream();){
            tmp.putOID(this.mOID);
            this.mLocation.encode(tmp);
            seq.write((byte)48, tmp);
            out.write(seq.toByteArray());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        DerValue val = new DerValue(in);
        DerValue seq = val.data.getDerValue();
        this.mOID = seq.getOID();
        DerValue derLoc = val.data.getDerValue();
        this.mLocation = new GeneralName(derLoc);
    }
}

