/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.netscape.security.util.BitArray;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.x509.CRLDistributionPoint;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.RDN;
import org.mozilla.jss.netscape.security.x509.URIName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLDistributionPointsExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = 8551761833349709229L;
    private static final Logger logger = LoggerFactory.getLogger(CRLDistributionPointsExtension.class);
    private SEQUENCE distributionPoints = new SEQUENCE();
    private byte[] cachedEncoding = null;
    public static final String OID = "2.5.29.31";
    public static final String NAME = "CRLDistributionPoints";

    public CRLDistributionPointsExtension(Boolean critical, Object value) {
        try {
            this.extensionId = PKIXExtensions.CRLDistributionPoints_Id;
            this.critical = critical;
            this.extensionValue = (byte[])((byte[])value).clone();
            try {
                SEQUENCE.OF_Template seqOfCRLDP = new SEQUENCE.OF_Template(CRLDistributionPoint.getTemplate());
                this.distributionPoints = (SEQUENCE)ASN1Util.decode(seqOfCRLDP, this.extensionValue);
            }
            catch (InvalidBERException e) {
                throw new IOException("Invalid BER-encoding: " + e, e);
            }
        }
        catch (IOException e) {
            logger.error("Error decoding CRLDistributionPoints", (Throwable)e);
        }
    }

    public CRLDistributionPointsExtension(CRLDistributionPoint dp) {
        this.extensionId = PKIXExtensions.CRLDistributionPoints_Id;
        this.critical = false;
        this.distributionPoints.addElement(dp);
    }

    public void addPoint(CRLDistributionPoint dp) {
        this.distributionPoints.addElement(dp);
        this.cachedEncoding = null;
    }

    public int getNumPoints() {
        return this.distributionPoints.size();
    }

    public CRLDistributionPoint getPointAt(int index) {
        return (CRLDistributionPoint)this.distributionPoints.elementAt(index);
    }

    @Override
    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        this.extensionValue = ASN1Util.encode(this.distributionPoints);
        super.encode(out);
    }

    public void flushCachedEncoding() {
        this.cachedEncoding = null;
    }

    @Override
    public String toString() {
        return NAME;
    }

    @Override
    public void encode(OutputStream ostream) throws CertificateException, IOException {
        if (this.cachedEncoding == null) {
            DerOutputStream tmp = new DerOutputStream();
            this.encode(tmp);
            this.cachedEncoding = tmp.toByteArray();
        }
        ostream.write(this.cachedEncoding);
    }

    @Override
    public void decode(InputStream in) throws CertificateException, IOException {
        throw new IOException("Not supported");
    }

    @Override
    public void set(String name, Object obj) throws CertificateException, IOException {
        throw new IOException("Attribute name not recognized by CertAttrSet:CRLDistributionPointsExtension");
    }

    @Override
    public Object get(String name) throws CertificateException, IOException {
        throw new IOException("Attribute name not recognized by CertAttrSet:CRLDistributionPointsExtension");
    }

    @Override
    public void delete(String name) throws CertificateException, IOException {
        throw new IOException("Attribute name not recognized by CertAttrSet:CRLDistributionPointsExtension");
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return new Vector().elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        FilterOutputStream bos = null;
        try {
            if (args.length != 1) {
                System.out.println("Usage: CRLDistributionPointsExtentions <outfile>");
                System.exit(-1);
            }
            bos = new BufferedOutputStream(new FileOutputStream(args[0]));
            CRLDistributionPoint cdp = new CRLDistributionPoint();
            URIName uri = new URIName("http://www.mycrl.com/go/here");
            GeneralNames generalNames = new GeneralNames();
            generalNames.addElement(uri);
            cdp.setFullName(generalNames);
            CRLDistributionPointsExtension crldpExt = new CRLDistributionPointsExtension(cdp);
            cdp = new CRLDistributionPoint();
            X500Name dn = new X500Name("CN=Otis Smith,E=otis@fedoraproject.org,OU=Certificate Server,O=Fedora,C=US");
            generalNames = new GeneralNames();
            generalNames.addElement(dn);
            cdp.setFullName(generalNames);
            crldpExt.addPoint(cdp);
            BitArray ba = new BitArray(5, new byte[]{40});
            cdp = new CRLDistributionPoint();
            cdp.setFullName(generalNames);
            cdp.setReasons(ba);
            crldpExt.addPoint(cdp);
            cdp = new CRLDistributionPoint();
            RDN rdn = new RDN("OU=foobar dept");
            cdp.setRelativeName(rdn);
            cdp.setReasons(ba);
            cdp.setCRLIssuer(generalNames);
            crldpExt.addPoint(cdp);
            crldpExt.setCritical(true);
            crldpExt.encode(bos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class Reason {
        private String name;
        private byte bitMask;
        private static Hashtable<String, Reason> map = new Hashtable();
        private static Vector<Reason> list = new Vector();
        public static final Reason UNUSED = new Reason("unused", -128);
        public static final Reason KEY_COMPROMISE = new Reason("keyCompromise", 64);
        public static final Reason CA_COMPROMISE = new Reason("cACompromise", 32);
        public static final Reason AFFILIATION_CHANGED = new Reason("affiliationChanged", 16);
        public static final Reason SUPERSEDED = new Reason("superseded", 8);
        public static final Reason CESSATION_OF_OPERATION = new Reason("cessationOfOperation", 4);
        public static final Reason CERTIFICATE_HOLD = new Reason("certificateHold", 2);

        private Reason() {
        }

        private Reason(String name, byte bitMask) {
            this.name = name;
            this.bitMask = bitMask;
            map.put(name, this);
            list.addElement(this);
        }

        public static Reason fromString(String name) {
            return map.get(name);
        }

        public String getName() {
            return this.name;
        }

        public byte getBitMask() {
            return this.bitMask;
        }

        public static Reason[] bitArrayToReasonArray(byte bitFlags) {
            return Reason.bitArrayToReasonArray(new byte[]{bitFlags});
        }

        public static Reason[] bitArrayToReasonArray(byte[] bitFlags) {
            byte first = bitFlags[0];
            int size = list.size();
            Vector<Reason> result = new Vector<Reason>();
            for (int i = 0; i < size; ++i) {
                Reason r = list.elementAt(i);
                byte b = r.getBitMask();
                if ((first & b) == 0) continue;
                result.addElement(r);
            }
            size = result.size();
            Reason[] retval = new Reason[size];
            for (int i = 0; i < size; ++i) {
                retval[i] = (Reason)result.elementAt(i);
            }
            return retval;
        }
    }
}

