/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.Serializable;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyId;
import org.mozilla.jss.netscape.security.x509.PolicyQualifiers;

public class CertificatePolicyInfo
implements Serializable {
    private static final long serialVersionUID = -8516006396099280477L;
    private CertificatePolicyId mPolicyIdentifier;
    private PolicyQualifiers mPolicyQualifiers;

    public CertificatePolicyInfo(CertificatePolicyId id) {
        this.mPolicyIdentifier = id;
        this.mPolicyQualifiers = null;
    }

    public CertificatePolicyInfo(CertificatePolicyId id, PolicyQualifiers qualifiers) {
        this.mPolicyIdentifier = id;
        this.mPolicyQualifiers = qualifiers;
    }

    public CertificatePolicyInfo(DerValue val) throws IOException {
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for CertificatePolicyInfo");
        }
        this.mPolicyIdentifier = new CertificatePolicyId(val.data.getDerValue());
        this.mPolicyQualifiers = val.data.available() == 0 ? null : new PolicyQualifiers(val.data.getDerValue());
    }

    public CertificatePolicyId getPolicyIdentifier() {
        return this.mPolicyIdentifier;
    }

    public PolicyQualifiers getPolicyQualifiers() {
        return this.mPolicyQualifiers;
    }

    public String toString() {
        String s = "CertificatePolicyInfo: [\nPolicyIdentifier:" + this.mPolicyIdentifier.toString() + "]\n";
        return s;
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        this.mPolicyIdentifier.encode(tmp);
        if (this.mPolicyQualifiers != null) {
            this.mPolicyQualifiers.encode(tmp);
        }
        out.write((byte)48, tmp);
    }
}

