/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.GeneralSubtrees;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;

public class NameConstraintsExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = -3506940192931244539L;
    public static final String IDENT = "x509.info.extensions.NameConstraints";
    public static final String NAME = "NameConstraints";
    public static final String PERMITTED_SUBTREES = "permitted_subtrees";
    public static final String EXCLUDED_SUBTREES = "excluded_subtrees";
    private static final byte TAG_PERMITTED = 0;
    private static final byte TAG_EXCLUDED = 1;
    private GeneralSubtrees permitted;
    private GeneralSubtrees excluded;
    private transient PrettyPrintFormat pp = new PrettyPrintFormat(":");

    private void encodeThis() throws IOException {
        try (DerOutputStream seq = new DerOutputStream();){
            DerOutputStream tmp;
            DerOutputStream tagged = new DerOutputStream();
            if (this.permitted != null && this.permitted.getSubtrees().size() > 0) {
                tmp = new DerOutputStream();
                this.permitted.encode(tmp);
                tagged.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), tmp);
            }
            if (this.excluded != null && this.excluded.getSubtrees().size() > 0) {
                tmp = new DerOutputStream();
                this.excluded.encode(tmp);
                tagged.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), tmp);
            }
            if (this.permitted == null && this.excluded == null) {
                this.extensionValue = null;
            } else {
                seq.write((byte)48, tagged);
                this.extensionValue = seq.toByteArray();
            }
        }
    }

    public NameConstraintsExtension(GeneralSubtrees permitted, GeneralSubtrees excluded) throws IOException {
        this.init(false, permitted, excluded);
    }

    public NameConstraintsExtension(boolean critical, GeneralSubtrees permitted, GeneralSubtrees excluded) throws IOException {
        this.init(critical, permitted, excluded);
    }

    private void init(boolean critical, GeneralSubtrees permitted, GeneralSubtrees excluded) throws IOException {
        if (permitted == null && excluded == null) {
            throw new IOException("NameConstraints: Invalid arguments");
        }
        this.permitted = permitted;
        this.excluded = excluded;
        this.extensionId = PKIXExtensions.NameConstraints_Id;
        this.critical = critical;
        this.encodeThis();
    }

    public NameConstraintsExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.NameConstraints_Id;
        this.critical = critical;
        if (!(value instanceof byte[])) {
            throw new IOException("Illegal argument type");
        }
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        System.arraycopy(value, 0, extValue, 0, len);
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for NameConstraintsExtension.");
        }
        while (val.data.available() != 0) {
            DerValue opt = val.data.getDerValue();
            if (opt.isContextSpecific((byte)0) && opt.isConstructed()) {
                if (this.permitted != null) {
                    throw new IOException("Duplicate permitted GeneralSubtrees in NameConstraintsExtension.");
                }
                opt.resetTag((byte)48);
                this.permitted = new GeneralSubtrees(opt);
                continue;
            }
            if (opt.isContextSpecific((byte)1) && opt.isConstructed()) {
                if (this.excluded != null) {
                    throw new IOException("Duplicate excluded GeneralSubtrees in NameConstraintsExtension.");
                }
                opt.resetTag((byte)48);
                this.excluded = new GeneralSubtrees(opt);
                continue;
            }
            throw new IOException("Invalid encoding of NameConstraintsExtension.");
        }
    }

    @Override
    public String toString() {
        return super.toString() + "NameConstraints: [" + (String)(this.permitted == null ? "" : "\n    Permitted:" + this.permitted.toString()) + (String)(this.excluded == null ? "" : "\n    Excluded:" + this.excluded.toString()) + "   ]\n";
    }

    public String toPrint(int indent) {
        return "GeneralSubtrees: " + (String)(this.permitted == null ? "" : "\n" + this.pp.indent(indent + 2) + "Permitted:" + this.permitted.toPrint(indent + 4)) + (String)(this.excluded == null ? "" : "\n" + this.pp.indent(indent + 2) + "Excluded:" + this.excluded.toPrint(indent + 4)) + "\n";
    }

    @Override
    public void decode(InputStream in) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.NameConstraints_Id;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        this.clearValue();
        if (name.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            if (!(obj instanceof GeneralSubtrees)) {
                throw new IOException("Attribute value should be of type GeneralSubtrees.");
            }
            this.permitted = (GeneralSubtrees)obj;
        } else if (name.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            if (!(obj instanceof GeneralSubtrees)) {
                throw new IOException("Attribute value should be of type GeneralSubtrees.");
            }
            this.excluded = (GeneralSubtrees)obj;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            return this.permitted;
        }
        if (name.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            return this.excluded;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (name.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            this.permitted = null;
        } else if (name.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            this.excluded = null;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
        }
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(PERMITTED_SUBTREES);
        elements.addElement(EXCLUDED_SUBTREES);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

