/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.javax.crypto;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IllegalBlockSizeException;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.TokenRuntimeException;
import org.mozilla.jss.crypto.TokenSupplierManager;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;

public class JSSCipherSpi
extends CipherSpi {
    private String algFamily = null;
    private String algMode = null;
    private String algPadding = null;
    CryptoToken token = null;
    private Cipher cipher = null;
    private KeyWrapper wrapper = null;
    private AlgorithmParameterSpec params = null;
    private int blockSize;
    private int keyStrength;
    private static final NoAlgParams noAlgParams = new NoAlgParams();

    protected JSSCipherSpi(String algFamily) {
        this.algFamily = algFamily;
        this.token = TokenSupplierManager.getTokenSupplier().getThreadToken();
    }

    @Override
    public void engineSetMode(String mode) {
        this.algMode = mode;
    }

    @Override
    public void engineSetPadding(String padding) {
        this.algPadding = padding;
    }

    private static SecretKey importKey(Key key) throws InvalidKeyException {
        if (key instanceof SecretKey) {
            SecretKey sKey = (SecretKey)key;
            SecretKeyFactory fact = null;
            try {
                fact = SecretKeyFactory.getInstance(sKey.getAlgorithm(), "Mozilla-JSS");
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidKeyException("Unable to translate key with Algorithm" + key.getAlgorithm());
            }
            catch (NoSuchProviderException ex) {
                throw new InvalidKeyException("Unable to find provider, this should not happen");
            }
            return fact.translateKey(sKey);
        }
        throw new InvalidKeyException("Invalid key type: " + key.getClass().getName());
    }

    @Override
    public void engineInit(int opmode, Key key, AlgorithmParameterSpec givenParams, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        block22: {
            try {
                this.cipher = null;
                this.wrapper = null;
                this.params = givenParams;
                if (this.algFamily == null) {
                    throw new InvalidAlgorithmParameterException("incorrectly specified algorithm");
                }
                if (opmode != 1 && opmode != 2 && opmode != 3 && opmode != 4) {
                    throw new InvalidKeyException("Invalid opmode");
                }
                StringBuilder buf = new StringBuilder();
                buf.append(this.algFamily);
                if (this.algMode != null) {
                    buf.append('/');
                    buf.append(this.algMode);
                }
                if (this.algPadding != null) {
                    buf.append('/');
                    buf.append(this.algPadding);
                }
                if (opmode == 1 || opmode == 2) {
                    if (!(key instanceof SecretKeyFacade)) {
                        key = JSSCipherSpi.importKey(key);
                    }
                    SymmetricKey symkey = ((SecretKeyFacade)key).key;
                    this.keyStrength = symkey.getStrength();
                    EncryptionAlgorithm encAlg = EncryptionAlgorithm.lookup(this.algFamily, this.algMode, this.algPadding, this.keyStrength);
                    this.blockSize = encAlg.getBlockSize();
                    if (!this.token.doesAlgorithm(encAlg)) {
                        throw new NoSuchAlgorithmException(encAlg.toString() + " is not supported by this token " + this.token.getName());
                    }
                    this.cipher = this.token.getCipherContext(encAlg);
                    if (opmode == 1) {
                        if (this.params == noAlgParams) {
                            this.params = this.generateAlgParams(encAlg, this.blockSize);
                        }
                        this.cipher.initEncrypt(symkey, this.params);
                    } else {
                        if (this.params == noAlgParams) {
                            this.params = null;
                        }
                        this.cipher.initDecrypt(symkey, this.params);
                    }
                    break block22;
                }
                KeyWrapAlgorithm wrapAlg = KeyWrapAlgorithm.fromString(buf.toString());
                this.blockSize = wrapAlg.getBlockSize();
                this.wrapper = this.token.getKeyWrapper(wrapAlg);
                if (this.params == noAlgParams) {
                    this.params = opmode == 3 ? this.generateAlgParams(wrapAlg, this.blockSize) : null;
                }
                if (key instanceof PrivateKey) {
                    PrivateKey privKey = (PrivateKey)key;
                    if (opmode != 4) {
                        throw new InvalidKeyException("Private key can only be used for unwrapping");
                    }
                    this.wrapper.initUnwrap(privKey, this.params);
                    break block22;
                }
                if (key instanceof PublicKey) {
                    PublicKey pubKey = (PublicKey)key;
                    if (opmode != 3) {
                        throw new InvalidKeyException("Public key can only be used for wrapping");
                    }
                    this.wrapper.initWrap(pubKey, this.params);
                    break block22;
                }
                if (key instanceof SecretKeyFacade) {
                    SecretKeyFacade sk = (SecretKeyFacade)key;
                    if (opmode == 3) {
                        this.wrapper.initWrap(sk.key, this.params);
                    } else {
                        this.wrapper.initUnwrap(sk.key, this.params);
                    }
                    break block22;
                }
                throw new InvalidKeyException("Invalid key type: " + key.getClass().getName());
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidAlgorithmParameterException(e.getMessage());
            }
            catch (TokenException te) {
                throw new TokenRuntimeException(te.getMessage());
            }
        }
    }

    @Override
    public void engineInit(int opmode, Key key, AlgorithmParameters givenParams, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            AlgorithmParameterSpec gp = null;
            if (this.algFamily.compareToIgnoreCase("RC2") == 0) {
                gp = givenParams.getParameterSpec(RC2ParameterSpec.class);
            } else if (this.algMode.compareToIgnoreCase("CBC") == 0) {
                gp = givenParams.getParameterSpec(IvParameterSpec.class);
            }
            if (gp == null) {
                throw new InvalidAlgorithmParameterException("Unknown Parameter Spec");
            }
            this.engineInit(opmode, key, gp, random);
        }
        catch (Exception e) {
            throw new InvalidAlgorithmParameterException(e.getMessage());
        }
    }

    @Override
    public void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, noAlgParams, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    private AlgorithmParameterSpec generateAlgParams(Algorithm alg, int blockSize) {
        Class<?>[] paramClasses = alg.getParameterClasses();
        AlgorithmParameterSpec algParSpec = null;
        if (paramClasses == null) {
            return null;
        }
        byte[] iv = new byte[blockSize];
        try {
            SecureRandom random = SecureRandom.getInstance("pkcs11prng", "Mozilla-JSS");
            random.nextBytes(iv);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < paramClasses.length; ++i) {
            if (paramClasses[i].equals(IvParameterSpec.class)) {
                algParSpec = new IvParameterSpec(iv);
                break;
            }
            if (!paramClasses[i].equals(RC2ParameterSpec.class)) continue;
            algParSpec = new RC2ParameterSpec(this.keyStrength, iv);
            break;
        }
        return algParSpec;
    }

    @Override
    public int engineGetBlockSize() {
        return this.blockSize;
    }

    @Override
    public byte[] engineGetIV() {
        if (this.params == null) {
            return null;
        }
        AlgorithmParameterSpec algorithmParameterSpec = this.params;
        if (algorithmParameterSpec instanceof IvParameterSpec) {
            IvParameterSpec ipSpec = (IvParameterSpec)algorithmParameterSpec;
            return ipSpec.getIV();
        }
        algorithmParameterSpec = this.params;
        if (algorithmParameterSpec instanceof RC2ParameterSpec) {
            RC2ParameterSpec rc2 = (RC2ParameterSpec)algorithmParameterSpec;
            return rc2.getIV();
        }
        return null;
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algParams = null;
        try {
            if (this.params instanceof IvParameterSpec || this.params instanceof RC2ParameterSpec) {
                algParams = AlgorithmParameters.getInstance(this.algFamily);
                algParams.init(this.params);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to get parameters: " + e.getMessage(), e);
        }
        catch (InvalidParameterSpecException e) {
            throw new RuntimeException("Unable to get parameters: " + e.getMessage(), e);
        }
        return algParams;
    }

    @Override
    public int engineGetOutputSize(int inputLen) {
        int total = this.blockSize - 1 + inputLen;
        return (total / this.blockSize + 1) * this.blockSize;
    }

    @Override
    public byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (this.cipher == null) {
            throw new IllegalStateException();
        }
        try {
            return this.cipher.update(input, inputOffset, inputLen);
        }
        catch (TokenException te) {
            throw new TokenRuntimeException(te.getMessage());
        }
    }

    @Override
    public int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        byte[] bytes = this.engineUpdate(input, inputOffset, inputLen);
        if (bytes.length > output.length - outputOffset) {
            throw new ShortBufferException(bytes.length + " needed, " + (output.length - outputOffset) + " supplied");
        }
        System.arraycopy(bytes, 0, output, outputOffset, bytes.length);
        return bytes.length;
    }

    @Override
    public byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws javax.crypto.IllegalBlockSizeException, BadPaddingException {
        if (this.cipher == null) {
            throw new IllegalStateException();
        }
        try {
            if (input == null || inputLen == 0) {
                return this.cipher.doFinal();
            }
            return this.cipher.doFinal(input, inputOffset, inputLen);
        }
        catch (IllegalStateException ise) {
            throw ise;
        }
        catch (IllegalBlockSizeException ibse) {
            throw new javax.crypto.IllegalBlockSizeException(ibse.getMessage());
        }
        catch (TokenException te) {
            throw new TokenRuntimeException(te.getMessage());
        }
    }

    @Override
    public int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, javax.crypto.IllegalBlockSizeException, BadPaddingException {
        byte[] bytes = this.engineDoFinal(input, inputOffset, inputLen);
        if (bytes.length > output.length - outputOffset) {
            throw new ShortBufferException(bytes.length + " needed, " + (output.length - outputOffset) + " supplied");
        }
        System.arraycopy(bytes, 0, output, outputOffset, bytes.length);
        return bytes.length;
    }

    @Override
    public byte[] engineWrap(Key key) throws javax.crypto.IllegalBlockSizeException, InvalidKeyException {
        if (this.wrapper == null) {
            throw new IllegalStateException();
        }
        try {
            if (key instanceof PrivateKey) {
                PrivateKey privKey = (PrivateKey)key;
                return this.wrapper.wrap(privKey);
            }
            if (key instanceof SecretKeyFacade) {
                SecretKeyFacade sk = (SecretKeyFacade)key;
                return this.wrapper.wrap(sk.key);
            }
            throw new InvalidKeyException("Unsupported key type: " + key.getClass().getName());
        }
        catch (IllegalStateException ise) {
            throw ise;
        }
        catch (TokenException te) {
            throw new TokenRuntimeException(te.getMessage());
        }
    }

    @Override
    public Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.wrapper == null) {
            throw new IllegalStateException();
        }
        switch (wrappedKeyType) {
            case 3: {
                return this.engineUnwrapSecret(wrappedKey, wrappedKeyAlgorithm);
            }
            case 2: {
                return this.engineUnwrapPrivate(wrappedKey, wrappedKeyAlgorithm);
            }
            case 1: {
                throw new UnsupportedOperationException("Unable to unwrap public keys");
            }
        }
        throw new NoSuchAlgorithmException("Invalid key type: " + wrappedKeyType);
    }

    private Key engineUnwrapSecret(byte[] wrappedKey, String wrappedKeyAlg) throws NoSuchAlgorithmException {
        try {
            int idx = wrappedKeyAlg.indexOf(47);
            if (idx != -1) {
                wrappedKeyAlg = wrappedKeyAlg.substring(0, idx);
            }
            SymmetricKey.Type wrappedKeyType = SymmetricKey.Type.fromName(wrappedKeyAlg);
            SymmetricKey key = this.wrapper.unwrapSymmetric(wrappedKey, wrappedKeyType, 0);
            return new SecretKeyFacade(key);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new NoSuchAlgorithmException("Unknown algorithm: " + wrappedKeyAlg);
        }
        catch (TokenException te) {
            throw new TokenRuntimeException(te.getMessage());
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new NoSuchAlgorithmException("Invalid algorithm parameters" + iape.getMessage());
        }
    }

    private Key engineUnwrapPrivate(byte[] wrappedKey, String wrappedKeyAlg) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Unwrapping private keys via the JCA interface is not supported: http://bugzilla.mozilla.org/show_bug.cgi?id=135328");
    }

    @Override
    public int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof PK11PrivKey) {
            PK11PrivKey pkPrivKey = (PK11PrivKey)key;
            return pkPrivKey.getStrength();
        }
        if (key instanceof PK11PubKey) {
            PK11PubKey pkPubKey = (PK11PubKey)key;
            try {
                byte[] encoded = pkPubKey.getEncoded();
                SubjectPublicKeyInfo.Template spkiTemp = new SubjectPublicKeyInfo.Template();
                SubjectPublicKeyInfo spki = (SubjectPublicKeyInfo)ASN1Util.decode(spkiTemp, encoded);
                BIT_STRING pk = spki.getSubjectPublicKey();
                return pk.getBits().length - pk.getPadCount();
            }
            catch (InvalidBERException e) {
                throw new InvalidKeyException("Exception while decoding public key: " + e.getMessage());
            }
        }
        if (key instanceof SecretKeyFacade) {
            SecretKeyFacade sk = (SecretKeyFacade)key;
            SymmetricKey symkey = sk.key;
            return symkey.getLength();
        }
        key = JSSCipherSpi.importKey(key);
        SymmetricKey symkey = ((SecretKeyFacade)key).key;
        return symkey.getLength();
    }

    private static class NoAlgParams
    implements AlgorithmParameterSpec {
        private NoAlgParams() {
        }
    }

    public static class RC2
    extends JSSCipherSpi {
        public RC2() {
            super("RC2");
        }
    }

    public static class RSA
    extends JSSCipherSpi {
        public RSA() {
            super("RSA");
        }
    }

    public static class RC4
    extends JSSCipherSpi {
        public RC4() {
            super("RC4");
        }
    }

    public static class AES
    extends JSSCipherSpi {
        public AES() {
            super("AES");
        }
    }

    public static class DESede
    extends JSSCipherSpi {
        public DESede() {
            super("DESede");
        }
    }

    public static class DES
    extends JSSCipherSpi {
        public DES() {
            super("DES");
        }
    }
}

