/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.OIDMap;

public class CertificateExtensions
extends Vector<Extension>
implements CertAttrSet {
    private static final long serialVersionUID = -7172635300185788849L;
    public static final String IDENT = "x509.info.extensions";
    public static final String NAME = "extensions";
    private LinkedHashMap<String, Extension> map = new LinkedHashMap();

    public void parseExtension(Extension ext) throws IOException {
        try {
            Class<?> extClass = OIDMap.getClass(ext.getExtensionId());
            if (extClass == null) {
                this.map.put(ext.getExtensionId().toString(), ext);
                this.addElement(ext);
                return;
            }
            Class[] params = new Class[]{Boolean.class, Object.class};
            Constructor<?> cons = extClass.getConstructor(params);
            byte[] extData = ext.getExtensionValue();
            int extLen = extData.length;
            Object value = Array.newInstance(Byte.TYPE, extLen);
            for (int i = 0; i < extLen; ++i) {
                Array.setByte(value, i, extData[i]);
            }
            Object[] passed = new Object[]{ext.isCritical(), value};
            CertAttrSet certExt = (CertAttrSet)cons.newInstance(passed);
            if (certExt != null && certExt.getName() != null) {
                this.map.put(certExt.getName(), (Extension)((Object)certExt));
                this.addElement((Extension)((Object)certExt));
            }
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public CertificateExtensions() {
    }

    public CertificateExtensions(DerInputStream in) throws IOException {
        DerValue[] exts = in.getSequence(5);
        for (int i = 0; i < exts.length; ++i) {
            Extension ext = new Extension(exts[i]);
            this.parseExtension(ext);
        }
    }

    @Override
    public void decode(InputStream in) throws IOException {
        DerValue val = new DerValue(in);
        DerInputStream str = val.toDerInputStream();
        this.map = new LinkedHashMap();
        DerValue[] exts = str.getSequence(5);
        for (int i = 0; i < exts.length; ++i) {
            Extension ext = new Extension(exts[i]);
            this.parseExtension(ext);
        }
    }

    public void decodeEx(InputStream in) throws IOException {
        DerValue val = new DerValue(in);
        DerInputStream str = null;
        str = val.isConstructed() && val.isContextSpecific((byte)3) ? val.data : val.toDerInputStream();
        this.map = new LinkedHashMap();
        DerValue[] exts = str.getSequence(5);
        for (int i = 0; i < exts.length; ++i) {
            Extension ext = new Extension(exts[i]);
            this.parseExtension(ext);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws CertificateException, IOException {
        this.encode(stream);
    }

    private void readObject(ObjectInputStream stream) throws CertificateException, IOException {
        this.decodeEx(stream);
    }

    @Override
    public void encode(OutputStream out) throws CertificateException, IOException {
        try (DerOutputStream tmp = new DerOutputStream();){
            DerOutputStream extOut = new DerOutputStream();
            for (int i = 0; i < this.size(); ++i) {
                Object thisOne = this.elementAt(i);
                if (thisOne instanceof CertAttrSet) {
                    ((CertAttrSet)thisOne).encode(extOut);
                    continue;
                }
                if (thisOne instanceof Extension) {
                    ((Extension)thisOne).encode(extOut);
                    continue;
                }
                throw new CertificateException("Invalid extension object");
            }
            DerOutputStream seq = new DerOutputStream();
            seq.write((byte)48, extOut);
            tmp.write(DerValue.createTag((byte)-128, true, (byte)3), seq);
            out.write(tmp.toByteArray());
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        this.map.put(name, (Extension)obj);
        this.addElement((Extension)obj);
    }

    @Override
    public Object get(String name) throws IOException {
        Extension obj = this.map.get(name);
        if (obj == null) {
            throw new IOException("No extension found with name " + name);
        }
        return obj;
    }

    @Override
    public void delete(String name) throws IOException {
        Extension obj = this.map.get(name);
        if (obj == null) {
            throw new IOException("No extension found with name " + name);
        }
        this.map.remove(name);
        this.removeElement(obj);
    }

    public Enumeration<String> getNames() {
        return Collections.enumeration(this.map.keySet());
    }

    public Enumeration<Extension> getAttributes() {
        return Collections.enumeration(this.map.values());
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return this.getNames();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public synchronized int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    @Override
    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertificateExtensions other = (CertificateExtensions)obj;
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }
}

